<?php 

/**
* WPBakery Page Builder Stockie Pricing List shortcode
*/

add_shortcode( 'stockie_pricing_list', 'stockie_pricing_list_func' );

function stockie_pricing_list_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );

	// Default values, parsing and filtering
	$name = isset( $name ) ? StockieExtraFilter::string( $name, 'string', '') : '';
	$indigriends = isset( $indigriends ) ? StockieExtraFilter::string( $indigriends, 'string', '') : '';
	$sale_price = isset( $sale_price ) ? StockieExtraFilter::string( $sale_price, 'string', '') : '';
	$regular_price = isset( $regular_price ) ? StockieExtraFilter::string( $regular_price, 'string', '') : '';
	$mark = isset( $new ) ? StockieExtraFilter::boolean( $new ) : false;

	$name_typo = isset( $name_typo ) ? StockieExtraFilter::string( $name_typo ) : false;
	$indigriends_typo = isset( $indigriends_typo ) ? StockieExtraFilter::string( $indigriends_typo ) : false;
	$sale_price_typo = isset( $sale_price_typo ) ? StockieExtraFilter::string( $sale_price_typo ) : false;
	$regular_price_typo = isset( $regular_price_typo ) ? StockieExtraFilter::string( $regular_price_typo ) : false;
	$mark_typo = isset( $mark_typo ) ? StockieExtraFilter::string( $mark_typo ) : false;

	$name_color = isset( $name_color ) ? StockieExtraFilter::string( $name_color, 'string', false ) : false;
	$indigriends_color = isset( $indigriends_color ) ? StockieExtraFilter::string( $indigriends_color, 'string', false ) : false;
	$sale_price_color = isset( $sale_price_color ) ? StockieExtraFilter::string( $sale_price_color, 'string', false ) : false;
	$regular_price_color = isset( $regular_price_color ) ? StockieExtraFilter::string( $regular_price_color, 'string', false ) : false;
	$border_color = isset( $border_color ) ? StockieExtraFilter::string( $border_color, 'string', false ) : false;
	$mark_color = isset( $mark_color ) ? StockieExtraFilter::string( $mark_color, 'string', false ) : false;
	$mark_background_color = isset( $mark_background_color ) ? StockieExtraFilter::string( $mark_background_color, 'string', false ) : false;

	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' ) : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false ) : false;
	if ( $appearance_duration ) $appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );

	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' ) : '';

	// Styling
	$menu_list_uniqid = uniqid( 'stockie-custom-' );

	$name_css = ( $name_color ) ? 'color: ' . $name_color . ';' : '';
	$indigriends_css = ( $indigriends_color ) ? 'color: ' . $indigriends_color . ';' : '';
	$sale_price_css = ( $sale_price_color ) ? 'color: ' . $sale_price_color . ';' : '';
	$regular_price_css = ( $regular_price_color ) ? 'color: ' . $regular_price_color . ';' : '';
	$border_css = ( $border_color ) ? 'border-color: ' . $border_color . ';' : '';
	$mark_css = ( $mark_color ) ? 'color: ' . $mark_color . ';' : '';
	$mark_css .= ( $mark_background_color ) ? 'background-color: ' . $mark_background_color . ';' : '';

	StockieExtraParser::VC_typo_custom_font( $name_typo );
	StockieExtraParser::VC_typo_custom_font( $indigriends_typo );
	StockieExtraParser::VC_typo_custom_font( $sale_price_typo );
	StockieExtraParser::VC_typo_custom_font( $regular_price_typo );
	StockieExtraParser::VC_typo_custom_font( $mark_typo );

	$name_css = $name_css . StockieExtraParser::VC_typo_to_CSS( $name_typo );
	$indigriends_css = $indigriends_css . StockieExtraParser::VC_typo_to_CSS( $indigriends_typo );
	$sale_price_css = $sale_price_css . StockieExtraParser::VC_typo_to_CSS( $sale_price_typo );
	$regular_price_css = $regular_price_css . StockieExtraParser::VC_typo_to_CSS( $regular_price_typo );
	$mark_css = $mark_css . StockieExtraParser::VC_typo_to_CSS( $mark_typo );

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'pricing_list__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'pricing_list__view.php' );
	return ob_get_clean();
}