<?php

/**
* WPBakery Page Builder Stockie Instagram Feed shortcode params
*/
vc_lean_map( 'stockie_instagram_feed', 'stockie_instagram_feed_sc_map' );

function stockie_instagram_feed_sc_map() {
	return array(
		'name' => __( 'Instagram Feed', 'stockie-extra' ),
		'description' => __( 'Instagram feed module', 'stockie-extra' ),
		'base' => 'stockie_instagram_feed',
		'category' => __( 'Stockie', 'stockie-extra' ),
		'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
		'params' => array(

			// General
			array(
				'type' => 'text',
				'group' => __( 'General', 'stockie-extra' ),
				'heading' => __( 'Usage note', 'stockie-extra' ),
				'param_name' => 'photo_count',
				'description' => __( 'Ensure that <a target="_blank" href="/wp-admin/plugins.php">Instagram Feed</a> plugin is installed. Then <a target="_blank" href="/wp-admin/admin.php?page=sbi-feed-builder">connect and adjust</a> your feed using the plugin\'s settings.', 'stockie-extra' ),
			),
			array(
				'type' => 'textfield',
				'group' => __( 'General', 'stockie-extra' ),
				'heading' => __( 'Feed ID number', 'stockie-extra' ),
				'param_name' => 'feed_id',
				'description' => __( '1 by default', 'stockie-extra' ),
			),
			array(
				'type' => 'stockie_check',
				'group' => __( 'General', 'stockie-extra' ),
				'heading' => __( 'Remove columns gap?', 'stockie-extra' ),
				'param_name' => 'columns_gap',
				'value' => array(
					'Yes' => '0'
				),
				'default' => '6',
			),

			// Custom CSS Class
			array(
				'type' => 'textfield',
				'group' => __( 'Styles', 'stockie-extra' ),
				'heading' => __( 'Custom CSS class', 'stockie-extra' ),
				'param_name' => 'css_class',
				'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
			),
		)
	);
}