<?php 

/**
* WPBakery Page Builder Stockie Instagram Feed shortcode
*/

add_shortcode( 'stockie_instagram_feed', 'stockie_instagram_feed_func' );

function stockie_instagram_feed_func( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) extract( $atts );
	$columns_gap = isset( $columns_gap ) ? 0 : 20;
	$feed_id = isset( $feed_id ) ? StockieExtraFilter::string( $feed_id, 'string', '1') : '1';
	$appearance_effect = isset( $appearance_effect ) ? StockieExtraFilter::string( $appearance_effect, 'attr', 'none' )  : 'none';
	$appearance_duration = isset( $appearance_duration ) ? StockieExtraFilter::string( $appearance_duration, 'attr', false )  : false;
	$appearance_duration = intval( str_replace( 'ms', '', $appearance_duration ) );
	$css_class = isset( $css_class ) ? ' ' . StockieExtraFilter::string( $css_class, 'attr', '' ) : '';

	// Styling
	$instagram_feed_uniqid = uniqid( 'stockie-custom-' );

	if ( $columns_gap == 0) {
		$css_class .= ' no-margins'; 
	}

	// Assembling
	include( plugin_dir_path( __FILE__ ) . 'instagram_feed__style.php' );
	ob_start();
	include( plugin_dir_path( __FILE__ ) . 'instagram_feed__view.php' );
	return ob_get_clean();
}