<?php

/**
* WPBakery Page Builder Stockie Icon Box shortcode view
*/

?>
<div class="stockie-icon-box-sc <?php echo $icon_box_class_main . $css_class; ?>" 
	id="<?php echo esc_attr( $icon_box_uniqid ); ?>" 
	<?php if ( $appearance_effect != 'none' ) { echo ' data-aos="' . esc_attr( $appearance_effect ) . '"'; } ?> 
	<?php if ( $appearance_duration ) { echo ' data-aos-duration="' . esc_attr( $appearance_duration ) . '"'; } ?>>

	<i class="icon-box-wrap<?php echo $icon_box_class_icon; ?>">
		<?php if ( $icon_type == 'font_icon' && $icon_as_icon ) : ?>
			<span class="<?php echo $icon_as_icon; ?>"></span>
		<?php elseif ( $icon_as_image ) : ?>
			<img src="<?php echo esc_url( $icon_as_image ); ?>" alt="<?php echo esc_attr( $title ); ?>">
		<?php endif; ?>
	</i>

	<div class="icon-box-content">
		<div class="<?php if ( $content_full == 'full' ) { echo ' with-full'; } ?>">
			<div class="wrap">
				<h6 class="icon-box-headline"><?php echo $title; ?></h6>
			</div>
		</div>
		
		<?php if ( $content_full == 'full' ) : ?>
	</div>
		<?php endif; ?>

		<p class="icon-box-details<?php echo $description_settings_class; ?>">
			<?php echo $description; ?>
		</p>

		<?php if ( $use_link ) : ?>
			<a class="btn<?php echo $button_css['classes']; ?>" href="<?php echo esc_url( $link_url['url'] ); ?>"
			<?php if ( $link_url['blank'] ) { echo ' target="_blank"'; } ?>>
				<?php echo $link_url['caption']; ?>
				<?php if( $button_settings['type'] == 'arrow_link' ) : ?>
					<span class="icon-arrow ion-ios-arrow-thin-right"></span>
				<?php endif; ?>
			</a>
		<?php endif; ?>

	<?php if ( $content_full != 'full' ) : ?>
	</div>
	<?php endif; ?>
</div>