<?php

/**
* WPBakery Page Builder Stockie Gallery shortcode params
*/

vc_map( array(
	'name' => __( 'Gallery', 'stockie-extra' ),
	'description' => __( 'Simple lightbox gallery module', 'stockie-extra' ),
	'base' => 'stockie_gallery',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(
		// General
		array(
			'type' => 'attach_images',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Images', 'stockie-extra' ),
			'param_name' => 'content_images',
			'description' => __( 'First image will be main. Set title and caption in WordPress media.', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Hide overlay?', 'stockie-extra' ),
			'param_name' => 'hide_overlay',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Show title on preview', 'stockie-extra' ),
			'param_name' => 'show_title',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
			'dependency' => array(
				'element' => 'hide_overlay',
				'value' => array(
					'0'
				)
			)
		),

		// Grid
		array(
			'type' => 'stockie_check',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Masonry grid', 'stockie-extra' ),
			'param_name' => 'masonry_grid',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Metro style', 'stockie-extra' ),
			'param_name' => 'metro_style',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Gap between images', 'stockie-extra' ),
			'param_name' => 'gap',
			'std' => '15px',
			'description' => __( 'CSS value.', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_columns',
			'group' => __( 'Grid', 'stockie-extra' ),
			'heading' => __( 'Columns', 'stockie-extra' ),
			'param_name' => 'columns',
			'std' => '4-3-2-1'
		),

		// Pagination
		array(
			'type' => 'stockie_check',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Use pagination', 'stockie-extra' ),
			'param_name' => 'use_pagination',
			'description' => '',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Pagination type', 'stockie-extra' ),
			'param_name' => 'pagination_type',
			'value' => array(
				__( 'Simple', 'stockie-extra' ) => 'simple',
				__( 'Lazy load', 'stockie-extra' ) => 'lazy_scroll',
				__( 'Load more button', 'stockie-extra' ) => 'lazy_button',
			),
			'std' => 'simple',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => array(
					'1'
				)
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Pagination', 'stockie-extra' ),
			'heading' => __( 'Number of items per page', 'stockie-extra' ),
			'param_name' => 'pagination_items_per_page',
			'value' => '6',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => array(
					'1'
				)
			)
		),

		// Style
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_grid',
			'value' => __( 'Grid', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Overlay color', 'stockie-extra' ),
			'param_name' => 'overlay_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Title color', 'stockie-extra' ),
			'param_name' => 'title_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Icon color', 'stockie-extra' ),
			'param_name' => 'icon_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Pagination color', 'stockie-extra' ),
			'param_name' => 'pagination_color',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => '1',
			)
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Pagination hover and active color', 'stockie-extra' ),
			'param_name' => 'pagination_active_color',
			'dependency' => array(
				'element' => 'use_pagination',
				'value' => '1',
			)
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_gallery',
			'value' => __( 'Gallery', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Background color', 'stockie-extra' ),
			'param_name' => 'gallery_bg_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Image title color', 'stockie-extra' ),
			'param_name' => 'gallery_title_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Image subtitle color', 'stockie-extra' ),
			'param_name' => 'gallery_subtitle_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Buttons color', 'stockie-extra' ),
			'param_name' => 'gallery_buttons_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Slider navigation buttons background color', 'stockie-extra' ),
			'param_name' => 'slider_nav_bg_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Slider navigation buttons color', 'stockie-extra' ),
			'param_name' => 'slider_nav_color',
		),

		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );