<?php

/**
* WPBakery Page Builder Stockie Dynamic Text shortcode params
*/

vc_map( array(
	'name' => __( 'Dynamic Text', 'stockie-extra' ),
	'description' => __( 'Effective dynamic text block', 'stockie-extra' ),
	'base' => 'stockie_dynamic_text',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Text alignment', 'stockie-extra' ),
			'param_name' => 'alignment',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_035.svg',
					'key' => 'left',
					'title' => __( 'Left', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_036.svg',
					'key' => 'center',
					'title' => __( 'Center', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_037.svg',
					'key' => 'right',
					'title' => __( 'Right', 'stockie-extra' ),
				)
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Static text before', 'stockie-extra' ),
			'param_name' => 'pre_title',
			'description' => __( '', 'stockie-extra' ),
		),
		array(
			'type' => 'param_group',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Dynamic text', 'stockie-extra' ),
			'param_name' => 'dynamic_title',
			'description' => __( '', 'stockie-extra' ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => __( 'Variant string', 'stockie-extra' ),
					'param_name' => 'dynamic_part',
				),
			),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Static text after', 'stockie-extra' ),
			'param_name' => 'post_title',
			'description' => __( '', 'stockie-extra' ),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Type speed', 'stockie-extra' ),
			'param_name' => 'type_speed',
			'value' => array(
				__( 'Slow', 'stockie-extra' ) => 'slow',
				__( 'Normal', 'stockie-extra' ) => 'normal',
				__( 'Fast', 'stockie-extra' ) => 'fast',
				__( 'Very fast', 'stockie-extra' ) => 'very_fast',
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Loop', 'stockie-extra' ),
			'param_name' => 'loop',
			'value' => array(
				'Yes' => '1'
			),
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_static',
			'value' => __( 'Static text', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'static_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_dynamic',
			'value' => __( 'Dynamic text', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'dynamic_typo',
		),
		
		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'argenta_extra' ),
			'heading' => __( 'Static text color', 'argenta_extra' ),
			'param_name' => 'static_color',
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'argenta_extra' ),
			'heading' => __( 'Dynamic text color', 'argenta_extra' ),
			'param_name' => 'dynamic_color',
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );