<?php

/**
* WPBakery Page Builder Stockie Countdown shortcode params
*/

vc_map( array(
	'name' => __( 'Countdown', 'stockie-extra' ),
	'description' => __( 'Time countdown module', 'stockie-extra' ),
	'base' => 'stockie_countdown',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Layout', 'stockie-extra' ),
			'param_name' => 'layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_031.svg',
					'key' => 'default',
					'title' => __( 'Default', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_032.svg',
					'key' => 'boxed',
					'title' => __( 'Boxed', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Use classic style', 'stockie-extra' ),
			'param_name' => 'countdown_classic',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
			'dependency' => array(
				'element' => 'layout',
				'value' => 'default'
			)
		),
		array(
			'type' => 'stockie_datetime',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Expiration date', 'stockie-extra' ),
			'param_name' => 'countdown_date'
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_numbers',
			'value' => __( 'Numbers', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'numbers_typo',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_titles',
			'value' => __( 'Titles', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'titles_typo'
		),
		
		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Numbers color', 'stockie-extra' ),
			'param_name' => 'numbers_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Titles color', 'stockie-extra' ),
			'param_name' => 'titles_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Divider dots', 'stockie-extra' ),
			'param_name' => 'divider_dots_color',
			'dependency' => array(
				'element' => 'countdown_classic',
				'value' => '1'
			)
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Box color', 'stockie-extra' ),
			'param_name' => 'box_color',
			'dependency' => array(
				'element' => 'layout',
				'value' => 'boxed'
			)
		),
		
		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );