<?php

/**
* WPBakery Page Builder Stockie Contact Form shortcode params
*/

$stockie_extra_cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

$stockie_extra_contact_forms = array();
if ( $stockie_extra_cf7 ) {
	foreach ( $stockie_extra_cf7 as $cform ) {
		$stockie_extra_contact_forms[ $cform->post_title ] = $cform->ID;
	}
} else {
	$stockie_extra_contact_forms[ __( 'No contact forms found', 'stockie-extra' ) ] = 0;
}

vc_map( array(
	'name' => __( 'Contact Form 7', 'stockie-extra' ),
	'description' => __( 'Contact and subscribe forms', 'stockie-extra' ),
	'base' => 'stockie_contact_form',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'text',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Usage note:', 'stockie-extra' ),
			'param_name' => 'photo_count',
			'description' => __( 'To use the shortcode please firstly install <a target="_blank" href="/wp-admin/plugins.php">Contact Form 7</a> from the recommended plugins.', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Form layout', 'stockie-extra' ),
			'param_name' => 'form_style',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_030.svg',
					'key' => 'border',
					'title' => __( 'Outline', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_031.svg',
					'key' => 'flat',
					'title' => __( 'Flat', 'stockie-extra' ),
				),
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Form', 'stockie-extra' ),
			'param_name' => 'form_id',
			'value' => $stockie_extra_contact_forms,
		),
		array(
			'type' => 'textfield',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Fields offset', 'stockie-extra' ),
			'param_name' => 'fields_offset',
			'description' => __( 'CSS value.', 'stockie-extra' ),
			'value' => '10px'
		),

		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_fields',
			'value' => __( 'Fields', 'stockie-extra' ),
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Fields background color', 'stockie-extra' ),
			'param_name' => 'fields_color',
			'dependency' => array(
				'element' => 'form_style',
				'value' => array(
					'flat',
				)
			)
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Fields border color', 'stockie-extra' ),
			'param_name' => 'fields_border_color',
			'dependency' => array(
				'element' => 'form_style',
				'value' => array(
					'border'
				)
			)
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Fields text color', 'stockie-extra' ),
			'param_name' => 'fields_text_color',
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Fields focus border color', 'stockie-extra' ),
			'param_name' => 'fields_focus_border_color',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_button',
			'value' => __( 'Button', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_button',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'button',
			'value' => 'color=brand',
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Button position', 'stockie-extra' ),
			'param_name' => 'button_position',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right'
			),
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_other',
			'value' => __( 'Other', 'stockie-extra' ),
		),

		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );