<?php

/**
* WPBakery Page Builder Stockie Button shortcode params
*/

vc_map( array(
	'name' => __( 'Button', 'stockie-extra' ),
	'description' => __( 'Simple eye catching button', 'stockie-extra' ),
	'base' => 'stockie_button',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'params' => array(

		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Layout type', 'stockie-extra' ),
			'param_name' => 'layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_023.svg',
					'key' => 'fill',
					'title' => __( 'Fill', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_024.svg',
					'key' => 'outline',
					'title' => __( 'Outline', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_025.svg',
					'key' => 'flat',
					'title' => __( 'Flat', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_026.svg',
					'key' => 'link',
					'title' => __( 'Link', 'stockie-extra' ),
				)
			)
		),
		array(
			'type' => 'vc_link',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Link', 'stockie-extra' ),
			'param_name' => 'link',
			'description' => __( 'Fill link text field to change the \'Get started\' label.', 'stockie-extra' ),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Button size', 'stockie-extra' ),
			'param_name' => 'shape_size',
			'std' => 'default',
			'value' => array(
				__( 'Small', 'stockie-extra' ) => 'small',
				__( 'Default', 'stockie-extra' ) => 'default',
				__( 'Large', 'stockie-extra' ) => 'large',
				__( 'Huge', 'stockie-extra' ) => 'huge',
			),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Button position', 'stockie-extra' ),
			'param_name' => 'shape_position',
			'std' => 'center',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Center', 'stockie-extra' ) => 'center',
				__( 'Right', 'stockie-extra' ) => 'right',
			),
			'description' => __( 'You can choose button alignment position.', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Full width', 'stockie-extra' ),
			'param_name' => 'full_width',
			'value' => array(
				__( 'Yes, set 100% width', 'stockie-extra' ) => '0'
			),
		),

		// Icon
		array(
			'type' => 'stockie_check',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Add icon', 'stockie-extra' ),
			'param_name' => 'icon_use',
			'value' => array(
				__( 'Yes, add icon', 'stockie-extra' ) => '0'
			),
			'description' => __( 'You can add icon instead or with text.', 'stockie-extra' )
		),
		array(
			'type' => 'stockie_check',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Swap icon to text on hover', 'stockie-extra' ),
			'param_name' => 'text_on_hover',
			'value' => array(
				__( 'Yes', 'stockie-extra' ) => '0'
			),
			'dependency' => array(
				'element' => 'icon_use',
				'value' => '1'
			),
			'description' => __( 'This add "rolling" effect on hover.', 'stockie-extra' ),
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon position', 'stockie-extra' ),
			'param_name' => 'icon_position',
			'std' => 'left',
			'value' => array(
				__( 'Left', 'stockie-extra' ) => 'left',
				__( 'Right', 'stockie-extra' ) => 'right',
			),
			'dependency' => array(
				'element' => 'icon_use',
				'value' => '1'
			)
		),
		array(
			'type' => 'dropdown',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon type', 'stockie-extra' ),
			'param_name' => 'icon_type',
			'value' => array(
				__( 'Font icon', 'stockie-extra' ) => 'font_icon',
				__( 'Custom image', 'stockie-extra' ) => 'user_image'
			),
			'dependency' => array(
				'element' => 'icon_use',
				'value' => '1'
			),
			'description' => __( 'Choose icon from font icons packs or your custom image.', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_icon_picker',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon', 'stockie-extra' ),
			'param_name' => 'icon_as_icon',
			'settings' => array(),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => array(
					'font_icon'
				)
			)
		),
		array(
			'type' => 'attach_image',
			'group' => __( 'Icon', 'stockie-extra' ),
			'heading' => __( 'Icon image', 'stockie-extra' ),
			'param_name' => 'icon_as_image',
			'description' => __( 'Choose icon image.', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => array(
					'user_image'
				)
			)
		),

		// Typography
		array(
		'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_heading',
			'value' => __( 'Heading', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo',
		),
		
		// Color settings
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'color_settings_title',
			'value' => __( 'Color settings', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Button background', 'stockie-extra' ),
			'param_name' => 'color',
			'description' => __( 'This color is also used for button border.', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Text color', 'stockie-extra' ),
			'param_name' => 'text_color',
		),

		// Custom CSS Class
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'other_settings_title',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );