<?php

/**
* WPBakery Page Builder Stockie Banner shortcode view
*/

?>
<div class="stockie-banner-box-sc <?php echo $banner_box_class . $css_class; ?>" 
	id="<?php echo esc_attr( $banner_box_uniqid ); ?>"
	<?php if ( $appearance_effect != 'none' ) { echo ' data-aos="' . $appearance_effect . '"'; } ?> 
	<?php if ( $appearance_duration ) { echo ' data-aos-duration="' . intval( $appearance_duration ) . '"'; } ?>>
	<?php if ( $block_type_layout == 'inner' || $block_type_layout == 'inner_hover' ) : ?>
		<div class="image-wrap">
			<img src="<?php echo esc_attr( $background_image ); ?>" alt="<?php echo StockieExtraFilter::string( $title, 'attr', '' ); ?>">
			<div class="overlay">
				<div class="content">
					<h4><?php echo $title; ?></h4>
					<p class="description"><?php echo $description; ?></p>
				</div>
				<?php if ( $use_link ) : ?>
				<a class="btn<?php echo $button_css['classes']; ?>" href="<?php echo $link_url['url']; ?>"<?php if ( $link_url['blank'] ) { echo ' target="_blank"'; } ?>>
					<?php echo $link_url['caption']; ?>
					<i class="ion-right ion ion-ios-arrow-forward"></i>
					
				</a>
				<?php endif; ?>
			</div>
		</div>
	<?php else : ?>
		<div class="image-wrap">
			<img src="<?php echo $background_image; ?>" alt="<?php echo StockieExtraFilter::string( $title, 'attr', '' ); ?>">
			<div class="overlay default">
				<?php if ( $use_link && $block_type_layout != 'overlay_title' && $block_type_layout != 'hover_title' ) : ?>
				<a class="btn<?php echo $button_css['classes']; ?>" href="<?php echo $link_url['url']; ?>"<?php if ( $link_url['blank'] ) { echo ' target="_blank"'; } ?>>
					<?php echo $link_url['caption']; ?>
					<i class="ion-right ion ion-ios-arrow-forward"></i>
				</a>
				<?php endif; ?>
			</div>
		</div>
		<div class="content">
			<div class="title-wrap">	
				<h4><?php echo $title; ?></h4>
			</div>
			<div class="description-wrap">	
				<p class="description"><?php echo $description; ?></p>
				<?php if ( $use_link && ( $block_type_layout == 'overlay_title' || $block_type_layout == 'hover_title' ) ) : ?>
				<a class="btn<?php echo $button_css['classes']; ?>" href="<?php echo $link_url['url']; ?>"<?php if ( $link_url['blank'] ) { echo ' target="_blank"'; } ?>>
					<?php echo $link_url['caption']; ?>
					<i class="ion-right ion ion-ios-arrow-forward"></i>
				</a>
				<?php endif; ?>
			</div>
		</div>
	<?php endif; ?>
</div>