<?php

/**
* WPBakery Page Builder Stockie Banner shortcode params
*/

vc_map( array(
	'name' => __( 'Banner', 'stockie-extra' ),
	'description' => __( 'Banner / Announcement box', 'stockie-extra' ),
	'base' => 'stockie_banner',
	'category' => __( 'Stockie', 'stockie-extra' ),
	'icon' => plugin_dir_url( __FILE__ ) . 'images/icon.svg',
	'js_view' => 'VcStockieBannerBoxView',
	'custom_markup' => '{{title}}<div class="vc_stockie_banner_box-container">
			<div class="image">
				<div class="title">%%title%%</div>
			</div>
		</div>',
	'params' => array(
		// General
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Banner layout', 'stockie-extra' ),
			'param_name' => 'block_type_layout',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_001.svg',
					'key' => 'full',
					'title' => __( 'Card', 'stockie-extra' )
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_004.svg',
					'key' => 'boxed',
					'title' => __( 'Card boxed', 'stockie-extra' )
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_005.svg',
					'key' => 'inner',
					'title' => __( 'Overlay details', 'stockie-extra' )
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_006.svg',
					'key' => 'inner_hover',
					'title' => __( 'Hover details', 'stockie-extra' )
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_007.svg',
					'key' => 'overlay_title',
					'title' => __( 'Overlay title', 'stockie-extra' )
				)
			)
		),
		array(
			'type' => 'stockie_choose_box',
			'group' => __( 'General', 'stockie-extra' ),
			'heading' => __( 'Content alignment', 'stockie-extra' ),
			'param_name' => 'block_type_full_align',
			'value' => array(
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_035.svg',
					'key' => 'left',
					'title' => __( 'Left', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_036.svg',
					'key' => 'center',
					'title' => __( 'Center', 'stockie-extra' ),
				),
				array(
					'icon' => plugin_dir_url( __FILE__ ) . 'images/wpb_params_037.svg',
					'key' => 'right',
					'title' => __( 'Right', 'stockie-extra' ),
				)
			),
		),
		array(
			'type' => 'textfield',
			'holder' => 'em',
			'group' => __( 'Content', 'stockie-extra' ),
			'heading' => __( 'Headline', 'stockie-extra' ),
			'param_name' => 'title'
		),
		array(
			'type' => 'textarea_raw_html',
			'group' => __( 'Content', 'stockie-extra' ),
			'heading' => __( 'Description', 'stockie-extra' ),
			'param_name' => 'description',
			'description' => __( 'Banner can be used as announcement block. Therefore, you can write text of the announcement for page / post / category / external link (HTML allowed).', 'stockie-extra' )
		),
		array(
			'type' => 'attach_image',
			'group' => __( 'Content', 'stockie-extra' ),
			'heading' => __( 'Background image', 'stockie-extra' ),
			'param_name' => 'background_image',
			'description' => __( 'Choose block background image.', 'stockie-extra' ),
		),

		// Link
		array(
			'type' => 'stockie_check',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Use link?', 'stockie-extra' ),
			'param_name' => 'use_link',
			'value' => array(
				__( 'Yes, sure', 'stockie-extra' ) => '1'
			),
			'description' => __( 'You can use banner as link to another page.', 'stockie-extra' ),
		),
		array(
			'type' => 'vc_link',
			'group' => __( 'Link', 'stockie-extra' ),
			'heading' => __( 'Link URL', 'stockie-extra' ),
			'param_name' => 'link_url',
			'dependency' => array(
				'element' => 'use_link',
				'value' => array(
					'1'
				)
			),
			'description' => __( 'Fill Link Text field to change the <strong>Read More</strong> label.', 'stockie-extra' ),
		),

		// Typography
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_title',
			'value' => __( 'Headline', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'title_typo',
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'subtitle_typo'
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_description',
			'value' => __( 'Description', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'description_typo',
		),
		array(
			'type' => 'argenta_divider',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'typo_tab_divider_heading',
			'value' => __( 'Button text', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'use_link',
				'value' => array(
					'1'
				)
			),
		),
		array(
			'type' => 'argenta_typography',
			'group' => __( 'Typography', 'stockie-extra' ),
			'param_name' => 'button_typo',
			'dependency' => array(
				'element' => 'use_link',
				'value' => array(
					'1'
				)
			),
		),

		// Style
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_content',
			'value' => __( 'Content', 'stockie-extra' ),
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Headline color', 'stockie-extra' ),
			'param_name' => 'title_color',
		),
		array(
			'type' => 'stockie_colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Description color', 'stockie-extra' ),
			'param_name' => 'description_color',
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_readmore',
			'value' => __( 'Read more button', 'stockie-extra' ),
			'dependency' => array(
				'element' => 'use_link',
				'value' => array(
					'1'
				)
			),
		),
		array(
			'type' => 'stockie_button',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'readmore_button',
			'value' => 'type=outline&size=small',
			'dependency' => array(
				'element' => 'use_link',
				'value' => array(
					'1'
				)
			),
		),
		array(
			'type' => 'stockie_divider',
			'group' => __( 'Styles', 'stockie-extra' ),
			'param_name' => 'style_tab_divider_other',
			'value' => __( 'Other', 'stockie-extra' ),
		),
		array(
			'type' => 'colorpicker',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Background overlay color', 'stockie-extra' ),
			'param_name' => 'overlay_color',
			'value' => 'rgba(52, 52, 54, 0.9)',
		),
		
		// Custom CSS Class
		array(
			'type' => 'textfield',
			'group' => __( 'Styles', 'stockie-extra' ),
			'heading' => __( 'Custom CSS class', 'stockie-extra' ),
			'param_name' => 'css_class',
			'description' => __( 'If you want to add styles to a specific unit, use this field to add CSS class.', 'stockie-extra' )
		),

		// Appear Effect
		array(
			'type' => 'dropdown',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Appear effect', 'stockie-extra' ),
			'param_name' => 'appearance_effect',
			'value' => array(
				__( 'None', 'stockie-extra' ) => 'none',
				__( 'Fade up', 'stockie-extra' ) => 'fade-up',
				__( 'Fade down', 'stockie-extra' ) => 'fade-down',
				__( 'Fade right', 'stockie-extra' ) => 'fade-right',
				__( 'Fade left', 'stockie-extra' ) => 'fade-left',
				__( 'Flip up', 'stockie-extra' ) => 'flip-up',
				__( 'Flip down', 'stockie-extra' ) => 'flip-down',
				__( 'Zoom in', 'stockie-extra' ) => 'zoom-in',
				__( 'Zoom out', 'stockie-extra' ) => 'zoom-out'
			)
		),
		array(
			'type' => 'textfield',
			'group' => __( 'Appear Effect', 'stockie-extra' ),
			'heading' => __( 'Animation duration', 'stockie-extra' ),
			'param_name' => 'appearance_duration',
			'description' => __( 'Duration accept values from 50 to 3000 (ms), with step 50.', 'stockie-extra' ),
		),
	)
) );