<?php

class bt_bb_service extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'icon'         => '',
			'title'        => '',
			'text'         => '',
			'url'          => '',
			'target'       => '',
			'color_scheme' => '',
			'style'        => '',
			'size'         => '',
			'shape'        => '',
			'align'        => ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );
		$data_override_class = array();

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		if ( $color_scheme != '' ) {
			$class[] = $this->prefix . 'color_scheme_' . bt_bb_get_color_scheme_id( $color_scheme );
		}		

		if ( $style != '' ) {
			$class[] = $this->prefix . 'style' . '_' . $style;
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'size',
				'value' => $size
			)
		);

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}
		
		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'align',
				'value' => $align
			)
		);
		
		if ( $url != '' ) {
			$url = bt_bb_get_url( $url );
			$title = '<a href="' . esc_url( $url ) . '" target="' . esc_attr( $target ) . '">' . $title . '</a>';
		} 


		$icon = bt_bb_icon::get_html( $icon, '', $url, $target );
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );


		$output = '<div class="' . esc_attr( $this->shortcode . '_content' ) . '">';
			$output = '<div class="' . esc_attr( $this->shortcode . '_content' ) . '">';
			$output .= $icon;
			if ( $title != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_content_title' ) . '">' . $title . '</div>';
		$output .= '</div>';

		if ( $text != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_content_text' ) . '">' . nl2br( $text ) . '</div>';

		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>' . $output . '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		if ( function_exists('boldthemes_get_icon_fonts_bb_array') ) {
			$icon_arr = boldthemes_get_icon_fonts_bb_array();
		} else {
			require_once( dirname(__FILE__) . '/../../../../../content_elements_misc/fa_icons.php' );
			require_once( dirname(__FILE__) . '/../../../../../content_elements_misc/s7_icons.php' );
			$icon_arr = array( 'Font Awesome' => bt_bb_fa_icons(), 'S7' => bt_bb_s7_icons() );
		}

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Service', 'squadrone' ), 'description' => esc_html__( 'Icon with text', 'squadrone' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'squadrone' ), 'value' => $icon_arr, 'preview' => true ),
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'squadrone' ), 'preview' => true ),
				array( 'param_name' => 'text', 'type' => 'textarea', 'heading' => esc_html__( 'Text', 'squadrone' ) ),
				array( 'param_name' => 'url', 'type' => 'link', 'heading' => esc_html__( 'URL', 'squadrone' ), 'description' => esc_html__( 'Enter full or local URL (e.g. https://www.bold-themes.com or /pages/about-us) or post slug (e.g. about-us) or search for existing content.', 'squadrone' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'squadrone' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'squadrone' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'squadrone' ) => '_blank',
					)
				),
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon alignment', 'squadrone' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Inherit', 'squadrone' ) 		=> 'inherit',
						esc_html__( 'Left', 'squadrone' ) 		=> 'left',
						esc_html__( 'Right', 'squadrone' ) 		=> 'right'
					)
				),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon size', 'squadrone' ), 'preview' => true, 'group' => esc_html__( 'Design', 'squadrone' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Small', 'squadrone' ) 			=> 'small',
						esc_html__( 'Extra small', 'squadrone' ) 		=> 'xsmall',
						esc_html__( 'Normal', 'squadrone' ) 			=> 'normal',
						esc_html__( 'Large', 'squadrone' ) 			=> 'large',
						esc_html__( 'Extra large', 'squadrone' ) 		=> 'xlarge'
					)
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'squadrone' ), 'value' => $color_scheme_arr, 'preview' => true, 'group' => esc_html__( 'Design', 'squadrone' ) ),
				array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon style', 'squadrone' ), 'preview' => true, 'group' => esc_html__( 'Design', 'squadrone' ),
					'value' => array(
						esc_html__( 'Outline', 'squadrone' ) 			=> 'outline',
						esc_html__( 'Filled', 'squadrone' ) 			=> 'filled',
						esc_html__( 'Borderless', 'squadrone' ) 		=> 'borderless'
					)
				),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon shape', 'squadrone' ), 'group' => esc_html__( 'Design', 'squadrone' ),
					'value' => array(
						esc_html__( 'Circle', 'squadrone' ) 				=> 'circle',
						esc_html__( 'Square', 'squadrone' ) 				=> 'square',
						esc_html__( 'Rounded Square', 'squadrone' ) 		=> 'round'
					)
				)
			)
		) );
	}
}