<?php

class bt_bb_column extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {

		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'width'    		   			=> '',
			'width_lg'               	=> '',
			'width_md'               	=> '',
			'width_sm'               	=> '',
			'width_xs'               	=> '',
			'align'   		   			=> 'left',
			'vertical_align'   			=> 'top',
			'padding'          			=> 'normal',
			'order'                  	=> '',
			'background_image'      	=> '',
			'lazy_load'              	=> 'no',
			'inner_background_image'    => '',
			'color_scheme'           	=> '',
			'background_color' 			=> '',
			'inner_background_color' 	=> '',
			'opacity'	       			=> '',
			'triangle'					=> ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );
		$data_override_class = array();
		
		$class[] = $this->get_responsive_class( $width, 'xl' );
		
		if ( $width_xs != '' ) {
			$class[] = $this->get_responsive_class( $width_xs, 'xs' );
		}
		if ( $width_sm != '' ) {
			$class[] = $this->get_responsive_class( $width_sm, 'sm' );
		}
		if ( $width_md != '' ) {
			$class[] = $this->get_responsive_class( $width_md, 'md' );
		}
		if ( $width_lg != '' ) {
			$class[] = $this->get_responsive_class( $width_lg, 'lg' );
		}

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = 'id="' . esc_attr( $el_id ) . '"';
		}

		if ( $color_scheme != '' ) {
			$class[] = $this->prefix . 'color_scheme_' . bt_bb_get_color_scheme_id( $color_scheme );
		}
		
		if ( method_exists( get_parent_class( $this ), 'responsive_data_override_class' ) ) {
			$this->responsive_data_override_class(
				$class, $data_override_class,
				array(
					'prefix' => $this->prefix,
					'param' => 'align',
					'value' => $align
				)
			);
		} else {
			if ( $align != '' ) {
				$class[] = $this->prefix . 'align' . '_' . $align;
			}
		}

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		if ( $vertical_align != '' ) {
			$class[] = $this->prefix . 'vertical_align' . '_' . $vertical_align;
		}

		if ( $padding != '' ) {
			$class[] = $this->prefix . 'padding' . '_' . $padding;
		}
		
		if ( method_exists( get_parent_class( $this ), 'responsive_override_class' ) ) {
			$this->responsive_override_class(
				$class,
				array(
					'prefix' => $this->prefix,
					'ignore' => '0',
					'param'  => 'order',
					'value'  => $order
				)
			);
		}

		$triangle_style = '';

		if ( $background_color != '' ) {
				if ( strpos( $background_color, '#' ) !== false ) {
				$background_color = bt_bb_column::hex2rgb( $background_color );
				if ( $opacity == '' ) {
					$opacity = 1;
				}
				$el_style .= 'background-color: rgba(' . $background_color[0] . ', ' . $background_color[1] . ', ' . $background_color[2] . ', ' . $opacity . ');';
				$triangle_style .= 'border-color: rgba(' . $background_color[0] . ', ' . $background_color[1] . ', ' . $background_color[2] . ', ' . $opacity . ');';
			} else {
				$el_style .= 'background-color:' . $background_color . ';';
				$triangle_style .= 'border-color:' . $background_color . ';';
			}
		}

		if ( $triangle != '' ) {
			$class[] = $this->prefix . 'triangle' . '_' . $triangle;
		}

		$el_inner_style = '';
		
		if ( $inner_background_color != '' ) {
			if ( strpos( $inner_background_color, '#' ) !== false ) {
				$inner_background_color = bt_bb_column::hex2rgb( $inner_background_color );
				if ( $opacity == '' ) {
					$opacity = 1;
				}
				$el_inner_style .= 'background-color:rgba(' . $inner_background_color[0] . ', ' . $inner_background_color[1] . ', ' . $inner_background_color[2] . ', ' . $opacity . ');';
			} else {
				$el_inner_style .= 'background-color:' . $inner_background_color . ';';
			}
		}
		
		if ( $background_image != '' ) {
			$background_image = wp_get_attachment_image_src( $background_image, 'full' );
			if ( $background_image ) {
				$background_image_url = $background_image[0];
				if ( $lazy_load == 'yes' ) {
					$blank_image_src = BT_BB_Root::$path . 'img/blank.gif';
					$el_style .= 'background-image:url(\'' . $blank_image_src . '\');';
					$background_data_attr .= ' data-background_image_src=\'' . $background_image_url . '\'';
					$class[] = 'btLazyLoadBackground';
				} else {
					$el_style .= 'background-image:url(\'' . $background_image_url . '\');';				
				}
			}
				
			$class[] = 'bt_bb_column_background_image';
		}

		if ( $inner_background_image != '' ) {
			$inner_background_image = wp_get_attachment_image_src( $inner_background_image, 'full' );

			$inner_background_image_url = $inner_background_image[0];
			if ( $lazy_load == 'yes' ) {
				$blank_image_src = BT_BB_Root::$path . 'img/blank.gif';
				$el_inner_style .= 'background-image:url(\'' . $blank_image_src . '\');';
				$inner_background_data_attr .= ' data-background_image_src="' . $inner_background_image_url . '"';
				$inner_class[] = 'btLazyLoadBackground';
			} else {
				$el_inner_style .= 'background-image:url(\'' . $inner_background_image_url . '\');';				
			}
			$class[] = 'bt_bb_column_inner_background_image';
		}

		if ( $el_inner_style != '' ) {
			$el_inner_style = ' style="' . esc_attr( $el_inner_style ) . '"';
		}
		
		$style_attr = '';

		if ( $el_style != '' ) {
			$style_attr = 'style="' . esc_attr( $el_style ) . '"';
		}


		if ( $triangle_style != '' ) {
			$triangle_style = ' style="' . esc_attr( $triangle_style ) . '"';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );

		$output = '<div ' . $id_attr . ' class="' . implode( ' ', $class ) . '" ' . $style_attr . ' data-width="' . esc_attr( $this->get_width2( $width ) ) . '" data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '">';
			$output .= '<div class="' . esc_attr( $this->shortcode . '_content' ) . '"' . $el_inner_style . '>';
				$output .= wptexturize( do_shortcode( $content ) );
			$output .= '</div>';
			if ( $triangle != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_triangle_box' ) . '" ' . $triangle_style . '></div>';
		$output .= '</div>';

		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}
	
	function get_responsive_class( $width, $size ) {
		
		$width = $this->get_width1( $width );

		$class = 'col-' . $size . '-' . $width;
		
		return $class;
	}
	
	function get_width1( $width ) {
		$array = explode( '/', $width );

		if ( empty( $array ) || $array[0] == 0 || $array[1] == 0 ) {
			$width = 12;
		} else {
			$top = $array[0];
			$bottom = $array[1];
			$width = 12 * $top / $bottom;
			if ( $width < 1 || $width > 12 ) {
				$width = 12;
			}
		}
		
		$width = str_replace( '.', '_', $width );
		
		return $width;
	}
	
	function get_width2( $width ) {
		$array = explode( '/', $width );

		if ( empty( $array ) || $array[0] == 0 || $array[1] == 0 ) {
			$width = 12;
		} else {
			$top = $array[0];
			$bottom = $array[1];
			$width = 12 * $top / $bottom;
			if ( $width < 1 || $width > 12 ) {
				$width = 12;
			}
		}
		
		return $width;
	}

	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Column', 'squadrone' ), 'description' => esc_html__( 'Column element', 'squadrone' ), 'width_param' => 'width', 'container' => 'vertical', 'accept' => array( 'bt_bb_section' => false, 'bt_bb_row' => false, 'bt_bb_column' => false, 'bt_bb_column_inner' => false, 'bt_bb_tab_item' => false, 'bt_bb_accordion_item' => false, 'bt_bb_cost_calculator_item' => false, 'bt_cc_group' => false, 'bt_cc_multiply' => false, 'bt_cc_item' => false, 'bt_bb_content_slider_item' => false, 'bt_bb_google_maps_location' => false, '_content' => false ), 'accept_all' => true, 'toggle' => false, 'responsive_override' => true,
			'params' => array(
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Align', 'squadrone' ), 'preview' => true, 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Left', 'squadrone' ) 		=> 'left',
						esc_html__( 'Right', 'squadrone' ) 		=> 'right',
						esc_html__( 'Center', 'squadrone' ) 		=> 'center'
					)
				),
				array( 'param_name' => 'vertical_align', 'type' => 'dropdown', 'heading' => esc_html__( 'Vertical align', 'squadrone' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Top', 'squadrone' )     		=> 'top',
						esc_html__( 'Middle', 'squadrone' )  		=> 'middle',
						esc_html__( 'Bottom', 'squadrone' )  		=> 'bottom'
					)
				),			
				array( 'param_name' => 'padding', 'type' => 'dropdown', 'heading' => esc_html__( 'Padding', 'squadrone' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Normal', 'squadrone' ) 			=> 'normal',
						esc_html__( 'Double', 'squadrone' ) 			=> 'double',
						esc_html__( 'Text Indent', 'squadrone' ) 		=> 'text_indent'				
					)
				),
				array( 'param_name' => 'order', 'type' => 'dropdown', 'heading' => esc_html__( 'Order', 'squadrone' ), 'default' => '0', 'responsive_override' => true, 'description' => esc_html__( 'Columns are placed in the visual order according to selected order, lowest values first.', 'squadrone' ),
					'value' => array(
						esc_html__( ' -5', 'squadrone' ) 			=> '-5',
						esc_html__( ' -4', 'squadrone' ) 			=> '-4',
						esc_html__( ' -3', 'squadrone' ) 			=> '-3',
						esc_html__( ' -2', 'squadrone' ) 			=> '-2',
						esc_html__( ' -1', 'squadrone' ) 			=> '-1',
						esc_html__( ' 0 (default)', 'squadrone' ) => '0',
						esc_html__( ' 1', 'squadrone' ) 			=> '1',
						esc_html__( ' 2', 'squadrone' ) 			=> '2',
						esc_html__( ' 3', 'squadrone' ) 			=> '3',
						esc_html__( ' 4', 'squadrone' ) 			=> '4',
						esc_html__( ' 5', 'squadrone' ) 			=> '5'
					)
				),
				array( 'param_name' => 'background_image', 'type' => 'attach_image',  'preview' => true, 'heading' => esc_html__( 'Background image', 'squadrone' ), 'group' => esc_html__( 'Design', 'squadrone' ) ),
				array( 'param_name' => 'inner_background_image', 'type' => 'attach_image',  'preview' => true, 'heading' => esc_html__( 'Inner background image', 'squadrone' ), 'group' => esc_html__( 'Design', 'squadrone' ) ),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'yes', 'heading' => esc_html__( 'Lazy load background image', 'squadrone' ), 'group' => esc_html__( 'Design', 'squadrone' ),
					'value' => array(
						esc_html__( 'No', 'squadrone' ) 		=> 'no',
						esc_html__( 'Yes', 'squadrone' ) 	=> 'yes'
					)
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'squadrone' ), 'description' => esc_html__( 'Define color schemes in Bold Builder settings or define accent and alternate colors in theme customizer (if avaliable)', 'squadrone' ), 'value' => $color_scheme_arr, 'preview' => true, 'group' => esc_html__( 'Design', 'squadrone' )  ),
				array( 'param_name' => 'background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'squadrone' ), 'group' => esc_html__( 'Design', 'squadrone' ) ),
				array( 'param_name' => 'inner_background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Inner background color', 'squadrone' ), 'group' => esc_html__( 'Design', 'squadrone' ) ),
				array( 'param_name' => 'opacity', 'type' => 'textfield', 'heading' => esc_html__( 'Background color opacity (deprecated)', 'squadrone' ), 'group' => esc_html__( 'Design', 'squadrone' ) ),
				array( 'param_name' => 'triangle', 'type' => 'dropdown', 'heading' => esc_html__( 'Triangle', 'squadrone' ),  'group' => esc_html__( 'Design', 'squadrone' ), 'description' => 'Set column background color in order to manage triangle color',
					'value' => array(
						esc_html__( 'No', 'squadrone' ) 		=> '',
						esc_html__( 'Top', 'squadrone' ) 		=> 'top',
						esc_html__( 'Bottom', 'squadrone' ) 	=> 'bottom',
						esc_html__( 'Left', 'squadrone' ) 	=> 'left',
						esc_html__( 'Right', 'squadrone' ) 	=> 'right'
					)
				)
			)
		) );
	}

	static function hex2rgb( $hex ) {
		$hex = str_replace( '#', '', $hex );
		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
		} else {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
		}
		$rgb = array( $r, $g, $b );
		return $rgb;
	}
}