<?php
splash_enqueue_modul_scripts_styles('stm_player_statistics_volleyball');
$title = $league = $season = $playerList = '';
$players = array();
extract( $atts );
if( empty( $players ) ) $players = array();
if( $atts[ "league" ] != "" ) $league = $atts[ "league" ];
if( $atts[ "season" ] != "" ) $season = $atts[ "season" ];
if( !empty( $atts[ "players" ] ) ) $players = explode( ', ', $atts[ 'players' ] );

$seasonName = get_term_by( 'id', $season, 'sp_season' );

if( $seasonName ) {
    $seasonName = $seasonName->name;
}
else {
    $seasonName = "";
}
if( !empty( $atts[ "player_lists" ] ) ) {
    $playerList = new SP_Player_List( $atts[ 'player_lists' ] );
    $i = 0;

    foreach( $playerList->data( false ) as $k => $val ) {
        if( $k != 0 ) {
            $players[ $i ] = $k;
            $i++;
        }
    }
}
$id = 'stm-player-statistic-unit-' . rand(0, 9999);
?>
<div class="stm-player-statistic stm-player-statistic-details style_volleyball <?php echo esc_attr($id); ?>">
    <div class="stm-player-statistic__header">
        <?php if( !empty( $title ) ): ?>
        <h2><?php echo esc_attr( $title ); ?></h2>
        <?php endif; ?>
        <div class="stm-player-statistic__carousel-nav">
            <div class="stm-player-statistic__carousel-prev"><i class="fa fa-angle-left"></i></div>
            <div class="stm-player-statistic__carousel-next"><i class="fa fa-angle-right"></i></div>
        </div>
    </div>
    <div class="stm-player-statistic__content">
        <div class="stm-player-statistic__carousel">
        <?php if( !empty( $players ) ):
                $equations = array_keys( sp_get_var_equations( 'sp_statistic' ) );
                foreach( $players as $post_id ):
                    if( $post_id != 0 ):
                        $player = new SP_Player( $post_id );
                        if( $player != null ) :
                            $playerData = $player->data( $league );
                            $params = $playerData[ 0 ];
                            if( isset( $playerData[ $season ] ) ) :
                                $statistics = $playerData[ $season ];

                                $metrics = $player->metrics();
                                if( $statistics != null ):
                                    /*IMAGE*/
                                    $player_image_id = get_post_meta( $post_id, 'player_image', true );
                                    if( !empty( $player_image_id ) ) {
                                        $image = splash_get_thumbnail_url( $post_id, $player_image_id, 'stm-360-404' );
                                    }
                                    else {
                                        $image = '';
                                    }

                                    /*TITLE*/
                                    $title = get_the_title( $post_id );
                                    $player_url = get_the_permalink( $post_id );

                                    /*POSITION*/
                                    $positions = wp_get_post_terms( $post_id, 'sp_position' );
                                    $position = false;
                                    if( $positions ) {
                                        $position = $positions[ 0 ]->name;
                                    }
                                    /*NUMBER*/
                                    $player_number = get_post_meta( $post_id, 'sp_number', true );
                                    ?>
                                    <div class="stm-player-statistic__player">
                                        <div class="stm-player-statistic__player-image">
                                            <?php if( !empty($image) ): ?>
                                            <a href="<?php echo esc_url( $player_url ); ?>">
                                                <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>">
                                            </a>
                                            <?php endif; ?>

                                            <?php if( !empty( $player_number ) ): ?>
                                            <div class="stm-player-statistic__player-number">
                                                <?php echo esc_html( $player_number ); ?>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="stm-player-statistic__player-info">
                                            <div class="stm-player-statistic__player-name">
                                                <a href="<?php echo esc_url( $player_url ); ?>">
                                                    <?php echo esc_attr( $title ); ?>
                                                </a>
                                            </div>
                                            <div class="stm-player-statistic__player-stats">
                                                <div class="stm-player-statistic__player-stats-col">
                                                    <div class="stm-player-statistic__player-stats-title">
                                                    <?php if( !empty( $position ) ): ?>
                                                        <?php echo esc_attr( $position ); ?>
                                                    <?php endif; ?>
                                                    </div>

                                                    <ul class="stm-player-statistic__player-stats-list">
                                                    <?php
                                                    if( $metrics != null ):
                                                        foreach( $metrics as $k => $val ):
                                                            if( empty( $val ) ) continue
                                                            ?>
                                                            <li><span><?php echo esc_html( $k ); ?></span> <span><?php echo esc_html( $val ); ?></span></li>
                                                            <?php
                                                        endforeach;
                                                    endif;
                                                    ?>
                                                    </ul>
                                                </div>
                                                <div class="stm-player-statistic__player-stats-col">
                                                    <div class="stm-player-statistic__player-stats-title"><?php esc_html_e( 'Quick stats', 'splash' ); ?> (<?php echo esc_html($seasonName) ?>)</div>
                                                    <ul class="stm-player-statistic__player-stats-list">
                                                    <?php
                                                    if( $statistics != null ):
                                                        foreach( $statistics as $k => $val ):
                                                            if( in_array( $k, $equations ) ) {
                                                                if( $val != 0 && $val != "" && $val != "-" && $k != "name" && $k != "team" ):
                                                                    ?>
                                                                    <li><span><?php echo esc_html( $k ); ?></span> <span><?php echo esc_html( $val ); ?></span></li>
                                                                    <?php
                                                                endif;
                                                            }
                                                        endforeach;
                                                    endif;
                                                    ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<script type="text/javascript">
    (function ($) {
        "use strict";

        $(document).ready(function () {
            var unique_class = "<?php echo esc_js($id); ?>";
            var owl = $('.stm-player-statistic-details.' + unique_class + ' .stm-player-statistic__carousel' );
            owl.owlCarousel({
                items: 1,
                dots: false,
                autoplay: false,
                slideBy: 1,
                smartSpeed: 700,
                sliderSpeed: 900,
                arrows: false
            });

            $('.stm-player-statistic__carousel-prev').on('click', function () {
                owl.trigger('prev.owl.carousel');
            });

            $('.stm-player-statistic__carousel-next').on('click', function () {
                owl.trigger('next.owl.carousel');
            });
        });
    })(jQuery);
</script>