(function ($) {
	"use strict";
	$(".penci_ai_gen").on("click", function (e) {
		e.preventDefault();
		const $this = $(this);
		const $form = $this.closest(".pcac_page_container");
		const $textarea = $form.find("#penci_ai_prompt");
		const $nonce = $form.find("#penci_ai_nonce").val();
		const $content = $("#content");
		const $desc = $(".description");

		if ($textarea.val().length < 1) {
			$desc.val("Please enter a prompt.");
			return;
		}

		$this.prop("disabled", true);
		$textarea.prop("disabled", true);
		$desc.html($desc.attr("data-loading"));

		const data = {
			action: "penciai_suggest_excerpt",
			front: true,
			main_title: $textarea.val(),
			rc_nonce: $nonce,
		};

		$.post(ajax_var_more.url, data, function (response) {
			if (response.success && "data" in response) {
				if (typeof tinymce !== "undefined" && tinymce.get("content")) {
					tinymce.get("content").setContent(response.data);
				} else {
					$content.val(response.data);
				}
			}
		}).always(function () {
			$this.prop("disabled", false);
			$textarea.prop("disabled", false);
			$desc.html($desc.attr("data-text"));
		});
	});
})(jQuery);