<?php

namespace PenciAIContentGenerator\AjaxRequests;


class GenerateStock {

	private $ajax;

	/**
	 * PreloadCaches constructor.
	 */
	public function __construct( $a ) {
		$this->ajax = $a;
		add_action( "wp_ajax_penciai_generate_stock", [ $this, 'ajax' ] );
	}

	public function ajax() {
		\penciai_checkNonce();
		$page  		 = isset( $_POST['page'] ) ? sanitize_text_field( $_POST['page'] ) : 1;
		$main_title  = isset( $_POST['main_title'] ) ? sanitize_text_field( $_POST['main_title'] ) : "";

		$main_title = trim( $main_title );
		if ( empty( $main_title ) ) {
			wp_send_json_error( array( 'error' => 'Empty title' ) );
		}

		$url = 'https://api.pexels.com/v1/search?query=' . urlencode( $main_title ) . '&per_page=1&page=' . $page;
		$pexels_dev_key = apply_filters( 'penci_ai_pexels_dev_key', 'NpSkQrb7kD666rz8z18jkymWnBANzd7H0b9sd7Ffcmf1m1aLWKlRNR4L' );

		$response = wp_remote_get( $url, array(
			'headers' => array(
				'Authorization' => $pexels_dev_key,
			),
			'timeout' => 15,
		) );

		if ( is_wp_error( $response ) ) {
			wp_send_json_error( array( 'error' => $response->get_error_message() ) );
		}

		$body = json_decode( wp_remote_retrieve_body( $response ), true );

		if ( ! isset( $body['photos'][0]['src']['original'] ) ) {
			wp_send_json_error( array( 'error' => 'No image found in Pexels response.', 'response' => $body ) );
		}

		$img_url = esc_url_raw( $body['photos'][0]['src']['large2x'] );

		// Optional: check if the helper function exists
		if ( ! function_exists( 'penciai_upload_image_to_media_gallery' ) ) {
			wp_send_json_error( array( 'error' => 'Image upload function not found.' ) );
		}

		$media_url = penciai_upload_image_to_media_gallery( $img_url );
		wp_send_json_success( $media_url );

		
		wp_die();


	}
}