
( function( window, wp ){

    // just to keep it cleaner - we refer to our link by id for speed of lookup on DOM.
    var link_id = 'penciai-content-generator-btn';

    // prepare our custom link's html.
    var link_html = '<a style="min-width:125px;" id="' + link_id + '" class="components-button penciai-toolbar-btn penciai-content-generator-btn penciai-button loading" href="#" >Penci AI <span class="penciai_spinner hide_spin"></span></a>';

    // check if gutenberg's editor root element is present.
    var editorEl = document.getElementById( 'editor' );
    if( !editorEl ){ // do nothing if there's no gutenberg root element on page.
        return;
    }

    var unsubscribe = wp.data.subscribe( function () {
        setTimeout( function () {
            if ( /*!document.getElementById( link_id )*/ document.getElementsByClassName("penciai-toolbar-btn")[0]==undefined ) {
                var toolbalEl = editorEl.querySelector( '.edit-post-header-toolbar' );
                if( toolbalEl instanceof HTMLElement ){
                    toolbalEl.insertAdjacentHTML( 'beforeend', link_html );
                }
            }

            var postTitle = wp.data.select('core/editor').getEditedPostAttribute('title');

            var excerptEl = document.querySelector('.editor-post-excerpt');
            if (excerptEl && !excerptEl.querySelector('.penciai_suggested_summary')) {
                excerptEl.insertAdjacentHTML('beforeend', '<div class="penciai_suggested_summary"><a data-title="'+postTitle+'" class="button button-primary button-gutg penciai_suggested_summary_btn" href="#">Generate Summary</a></div>');
            }

        }, 1 )
    } );
    // unsubscribe is a function - it's not used right now
    // but in case you'll need to stop this link from being reappeared at any point you can just call unsubscribe();

} )( window, wp )