<?php
/*
Plugin Name: Penci Templates
Plugin URI: https://pencidesign.net/templates
Description: Template
Author: Tan Nguyen <hi@tan.ng>
Version: 0.0.1
Author URI: https://tan.ng
*/

add_action( 'rest_api_init', function () {
	register_rest_route( 'penci-blocks/v1', '/templates', [
		'methods'             => 'GET',
		'callback'            => 'penci_get_elementor_templates',
		'permission_callback' => '__return_true',
	] );
} );

if ( isset( $_GET['penci_clear_data'] ) ) {
	delete_transient( 'all-templates' );
}

function penci_get_elementor_templates( \WP_REST_Request $request ) {
	$params = $request->get_params();

	if ( isset( $params['id'] ) ) {
		return penci_get_single_elementor_template( $params['id'] );
	}

	if ( false === ( $allTemplates = get_transient( 'all-templates' ) ) ) {
		$allTemplates = penci_get_all_elementor_templates();
		set_transient( 'all-templates', $allTemplates );
	}

	return $allTemplates;
}

function penci_get_all_elementor_templates() {
	global $wpdb;

	$pages = get_pages( [
		'meta_key'   => '_wp_page_template',
		'meta_value' => 'page-fullwidth.php',
	] );

	$pagesId = array_map( function ( $page ) {
		return $page->ID;
	}, $pages );

	$inPageIds = implode( ',', $pagesId );

	$templatesAndBlocks = $wpdb->get_results( "SELECT * FROM lib_term_relationships WHERE object_id IN ({$inPageIds})", ARRAY_A );

	$templateTypes = [];
	$allTags       = [];

	$pageTags   = $wpdb->get_results( "SELECT * FROM lib_term_taxonomy", OBJECT_K );
	$terms      = $wpdb->get_results( "SELECT * FROM lib_terms", OBJECT_K );
	$filterTags = [];

	foreach ( $templatesAndBlocks as $tax ) {
		if ( $tax['term_taxonomy_id'] == 2 ) {
			$templateTypes[ $tax['object_id'] ] = 'template';
		}

		if ( $tax['term_taxonomy_id'] == 3 ) {
			$templateTypes[ $tax['object_id'] ] = 'block';
		}

		if ( ! isset( $allTags[ $tax['object_id'] ] ) ) {
			$allTags[ $tax['object_id'] ] = [];
		}

		$allTags[ $tax['object_id'] ][] = $terms[ $tax['term_taxonomy_id'] ]->slug;

		$filterTags[ $tax['term_taxonomy_id'] ] = $tax;
	}


	$allTaxonomies = implode( ',', array_keys( $filterTags ) );
	$terms         = $wpdb->get_results( "SELECT * FROM library.lib_terms A, library.lib_term_taxonomy B WHERE A.term_id = B.term_id AND A.term_id IN ($allTaxonomies) AND B.taxonomy = 'post_tag'" );

	$templates = [];

	foreach ( $pages as $page ) {
		$imageName = str_replace( ' ', '_', $page->post_title );

		$templates[] = [
			'id'    => $page->ID,
			'title' => $page->post_title,
			'slug'  => $page->post_name,
			'link'  => get_permalink( $page ),
			'image' => "https://soledad-images-library.s3.amazonaws.com/{$imageName}.jpg",
			'type'  => $templateTypes[ $page->ID ],
			'class' => implode( ',', $allTags[ $page->ID ] ), // @replace
		];
	}

	$tags = [];

	foreach ( $terms as $term ) {
		if ( $term->term_id == 2 || $term->term_id == 3 ) {
			continue;
		}

		$tags[] = [
			'title' => $term->name,
			'slug'  => $term->slug,
			'count' => $term->count
		];
	}

	return [
		'elements' => $templates,
		'count'    => count( $templates ),
		'tags'     => $tags
	];
}

function penci_get_single_elementor_template( $id ) {
	$template = get_post_meta( $id, '_elementor_data', true );

    $template = json_decode( $template, true );
    penci_templ_remove_placeholer ( $template );

	return [
		'content'       => $template,
		'page_settings' => [],
	];
}

function penci_templ_remove_placeholer(&$array) {
    foreach ($array as $key => &$value) {
        if (is_array($value)) {
            if (isset($value['image']) && strpos($value['image']['url'], 'placeholder') !== false) {
                $value['image'] = [
					'url' => ''
				];
            }
            penci_templ_remove_placeholer($value);
        }
    }
}
