<?php
$options   = [];
$options[] = array(
	'default'  => 'before-content',
	'label'    => __( 'Player Position', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_position',
	'type'     => 'soledad-fw-select',
	'priority' => 1,
	'choices'  => array(
		"before-content" => esc_html__( 'Before Post Content', 'penci-text-to-speech' ),
		"after-content"  => esc_html__( 'After Post Content', 'penci-text-to-speech' ),
		"before-title"   => esc_html__( 'Before Post Categories', 'penci-text-to-speech' ),
		"after-title"    => esc_html__( 'After Post Meta', 'penci-text-to-speech' ),
		"top-fixed"      => esc_html__( 'Top Fixed', 'penci-text-to-speech' ),
		"bottom-fixed"   => esc_html__( 'Bottom Fixed', 'penci-text-to-speech' ),
		"shortcode"      => esc_html__( 'Shortcode [penci-texttospeech]', 'penci-text-to-speech' )
	)
);

$options[] = array(
	'default'  => 'style-4',
	'label'    => __( 'Player Style', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_style',
	'type'     => 'soledad-fw-select',
	'priority' => 1,
	'choices'  => array(
		'style-1' => esc_html__( 'Round Player', 'penci-text-to-speech' ),
		'style-2' => esc_html__( 'Rounded Player', 'penci-text-to-speech' ),
		'style-3' => esc_html__( 'Squared Player', 'penci-text-to-speech' ),
		'style-4' => esc_html__( 'WordPress Default Player', 'penci-text-to-speech' ),
		'style-5' => esc_html__( 'Chrome Style Player', 'penci-text-to-speech' ),
		'style-6' => esc_html__( 'Browser Default Player', 'penci-text-to-speech' )
	)
);

$options[] = array(
	'default'  => 'none',
	'label'    => __( 'Download Link', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_link',
	'type'     => 'soledad-fw-select',
	'priority' => 1,
	'choices'  => array(
		'none'                 => esc_html__( 'Do not show', 'penci-text-to-speech' ),
		'backend'              => esc_html__( 'Backend Only', 'penci-text-to-speech' ),
		'frontend'             => esc_html__( 'Frontend Only', 'penci-text-to-speech' ),
		'backend-and-frontend' => esc_html__( 'Backend and Frontend', 'penci-text-to-speech' )
	)
);

$options[] = array(
	'label'       => __( 'Description Before Audio Player', 'penci-text-to-speech' ),
	'description' => __( 'Add a text or HTML markup before the player', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_before_player_switcher',
	'type'        => 'soledad-fw-textarea',
	'default'     => '',
	'sanitize'    => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'       => __( 'Description After Audio Player', 'penci-text-to-speech' ),
	'description' => __( 'Add a text or HTML markup after the player', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_after_player_switcher',
	'type'        => 'soledad-fw-textarea',
	'default'     => '',
	'sanitize'    => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'       => __( 'Autoplay', 'penci-text-to-speech' ),
	'description' => __( 'Autoplay the audio after page load. May not work in some browsers due to Browser Autoplay Policy. More details for <a href="https://developers.google.com/web/updates/2017/09/autoplay-policy-changes" target="_blank" rel="noreferrer">WebKit Browsers</a> and <a href="https://hacks.mozilla.org/2019/02/firefox-66-to-block-automatically-playing-audible-video-and-audio/" target="_blank" rel="noreferrer">Firefox</a>', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_autoplay',
	'type'        => 'soledad-fw-toggle',
	'default'     => false,
	'sanitize'    => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'       => __( 'Loop', 'penci-text-to-speech' ),
	'description' => __( 'Loop the audio playback', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_loop',
	'type'        => 'soledad-fw-toggle',
	'default'     => false,
	'sanitize'    => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'       => __( 'Speed Controls', 'penci-text-to-speech' ),
	'description' => __( 'Speed controls for the audio player the audio after page load', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_speed_controls',
	'type'        => 'soledad-fw-toggle',
	'default'     => true,
	'sanitize'    => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'       => __( 'Speed Block Title', 'penci-text-to-speech' ),
	'description' => __( 'Specify the title for speeds section', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_speed_title',
	'type'        => 'soledad-fw-text',
	'default'     => '',
	'sanitize'    => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'default'     => '0.25, 0.5, 0.75, 1.25, 1.5, 1.75',
	'id'          => 'penci_texttospeech_speed',
	'label'       => __( 'Available Speed', 'penci-text-to-speech' ),
	'description' => 'Specify speeds separated by commas. Speed must be in range from 0.1 to 16. Use period for decimal numbers, for example: 1.2, 1.5, 1.75',
	'type'        => 'soledad-fw-text',
	'priority'    => 1,
);

$options[] = array(
	'label'       => __( 'Synthesize Audio on Save', 'penci-text-to-speech' ),
	'description' => __( 'Auto re-generate the audio file when you updating post content', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_auto_generation',
	'type'        => 'soledad-fw-toggle',
	'default'     => false,
	'sanitize'    => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'       => __( 'Add Custom Fields', 'penci-text-to-speech' ),
	'description' => __( 'Add audio meta-data to the post Custom Fields', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_post_meta',
	'type'        => 'soledad-fw-toggle',
	'default'     => false,
	'sanitize'    => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'       => __( 'Visible in the Media Library', 'penci-text-to-speech' ),
	'description' => __( 'Make the audio visible and available in the Media Library', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_media_library',
	'type'        => 'soledad-fw-toggle',
	'default'     => false,
	'sanitize'    => 'penci_sanitize_checkbox_field'
);


$options[] = array(
	'label'       => __( 'Audio Preload', 'penci-text-to-speech' ),
	'description' => __( 'The preload attribute specifies if and how the audio file should be loaded when the page loads.', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_preload',
	'type'        => 'soledad-fw-select',
	'default'     => 'none',
	'choices'     => [
		'none'     => esc_html__( 'None', 'penci-text-to-speech' ),
		'metadata' => esc_html__( 'Metadata', 'penci-text-to-speech' ),
		'auto'     => esc_html__( 'Auto', 'penci-text-to-speech' ),
		'backend'  => esc_html__( 'Backend', 'penci-text-to-speech' ),
	],
);

$options[] = array(
	'default'  => '',
	'sanitize' => 'sanitize_hex_color',
	'type'     => 'soledad-fw-color',
	'label'    => 'Custom Background Color for Media Player',
	'id'       => 'penci_texttospeech_bgcolor',
	'priority' => 2
);

$options[] = array(
	'label'    => '',
	'id'       => 'penci_texttospeech_mtm',
	'type'     => 'soledad-fw-hidden',
	'sanitize' => 'absint',
	'default'  => '14',
);
$options[] = array(
	'label'    => __( 'Custom Top Spacing for Media Player', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_mt',
	'type'     => 'soledad-fw-size',
	'default'  => '',
	'sanitize' => 'absint',
	'ids'      => array(
		'desktop' => 'penci_texttospeech_mt',
		'mobile'  => 'penci_texttospeech_mtm',
	),
	'choices'  => array(
		'desktop' => array(
			'min'     => 1,
			'max'     => 500,
			'step'    => 1,
			'edit'    => true,
			'unit'    => 'px',
			'default' => '',
		),
		'mobile'  => array(
			'min'     => 1,
			'max'     => 500,
			'step'    => 1,
			'edit'    => true,
			'unit'    => 'px',
			'default' => '',
		),
	),
);

$options[] = array(
	'label'    => '',
	'id'       => 'penci_texttospeech_mbm',
	'type'     => 'soledad-fw-hidden',
	'sanitize' => 'absint',
	'default'  => '14',
);
$options[] = array(
	'label'    => __( 'Custom Bottom Spacing for Media Player', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_mb',
	'type'     => 'soledad-fw-size',
	'default'  => '',
	'sanitize' => 'absint',
	'ids'      => array(
		'desktop' => 'penci_texttospeech_mb',
		'mobile'  => 'penci_texttospeech_mbm',
	),
	'choices'  => array(
		'desktop' => array(
			'min'     => 1,
			'max'     => 500,
			'step'    => 1,
			'edit'    => true,
			'unit'    => 'px',
			'default' => '',
		),
		'mobile'  => array(
			'min'     => 1,
			'max'     => 500,
			'step'    => 1,
			'edit'    => true,
			'unit'    => 'px',
			'default' => '',
		),
	),
);

return $options;