<?php
// Get content width
$content_max_width       = absint( $this->get( 'content_max_width' ) );

// Get template colors
$theme_color             = $this->get_customizer_setting( 'theme_color' );
$text_color              = $this->get_customizer_setting( 'text_color' );
$link_color              = $this->get_customizer_setting( 'link_color' );
$muted_text_color        = $this->get_customizer_setting( 'muted_text_color' );
$border_color            = $this->get_customizer_setting( 'border_color' );
$header_background_color = $this->get_customizer_setting( 'header_background_color' );
$header_color            = $this->get_customizer_setting( 'header_color' );
$title_color             = $this->get_customizer_setting( 'title_color' );

$font_OpenSans = "'Open Sans', sans-serif";
$font_Roboto   = "'Roboto', sans-serif";
$font_Teko     = "'Teko', sans-serif";

$custom_typo_body  = penci_amp_customize_typo_body();
$custom_typo_title = penci_amp_customize_typo_title();

// Generic WP styling
echo '*{ outline: none; text-decoration: none; box-sizing: border-box; }textarea, input[type="text"], input[type="email"], input[type="search"], input[type="button"], input[type="submit"]{ -webkit-appearance: none; border-radius: 0; -webkit-border-radius: 0; }.wrap a,.wrap a:active,.wrap a:visited{ text-decoration: none } .penci-google-adsense { margin: 0 0 30px; text-align: center; overflow: hidden; display: block; width: 100%; } strong, b { font-weight: '. penci_amp_get_setting( 'penci_amp_font_weight_title' ).'; } h1{ font-size: 24px; } h2{ font-size: 20px; } h3{ font-size: 18px; } h4{ font-size: 16px; } h5{ font-size: 14px; } h6{ font-size: 12px; }';
echo '.nopost-found{font-size: 15px; margin: 1em 0;text-align: center;}.search-label{margin-bottom: 16px;}.screen-reader-text { clip: rect(1px, 1px, 1px, 1px); position: absolute; height: 1px; width: 1px; overflow: hidden; } .screen-reader-text:focus { background-color: #f1f1f1; border-radius: 3px; box-shadow: 0 0 2px 2px rgba(0, 0, 0, 0.6); clip: auto; color: #21759b; display: block; font-size: 14px; font-weight: 700; height: auto; left: 5px; line-height: normal; padding: 15px 23px 14px; text-decoration: none; top: 5px; width: auto; z-index: 100000; }';
echo 'h1, h2, h3, h4, h5, h6 { clear: both; line-height: 1.3; font-family: '. $font_Roboto.'; font-style: normal; font-weight: 600; } a{ background-color: transparent; transition: color 0.3s; text-decoration: none; vertical-align: baseline; } .byline, .updated:not(.published) { display: none; } .alignright { float: right; } .alignleft { float: left; } .aligncenter { display: block; margin-left: auto; margin-right: auto; }';
echo '.amp-wp-enforced-sizes { max-width: 100%; margin: 0 auto; } .amp-wp-unknown-size img { object-fit: contain; }';
if ( $content_max_width > 0 ){
	echo '.amp-wp-content, .amp-wp-title-bar div { margin: 0 auto; max-width: '. sprintf( '%dpx', $content_max_width ).'; }';
}
echo 'body { background: #fff; color: '. sanitize_hex_color( $text_color ).'; font-size: 15px; line-height: 1.5; text-rendering: optimizeLegibility; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; word-wrap: break-word; margin: 0; overflow-x: hidden; } body, button, input, select, textarea { '. $custom_typo_body.' } .penci-amp-wrapper { background: '. sanitize_hex_color( $theme_color ).'; max-width: 780px; margin: 0 auto; } .penci-amp-wrapper .amp-slider { background: '. sanitize_hex_color( $theme_color ).'; } p, ol, ul, figure { margin: 0 0 1em; padding: 0; } a,a:visited { color: '. sanitize_hex_color( $link_color ).'; } a:hover,a:active,a:focus { color: '. sanitize_hex_color( $text_color ).'; } button, .button, input[type="button"], input[type="reset"], input[type="submit"] { border: 1px solid '. $link_color.'; border-radius: 0; background-color: '. $link_color.'; color: #ffffff; line-height: 36px; padding: 2px 15px 0; text-align: center; transition: all 0.25s; font-size: 14px; text-transform: uppercase; cursor: pointer; } button:hover, .button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover { opacity: 0.8; border-color: '. $link_color.'; background-color: '. $link_color.'; color: #ffffff; } .penci-inline-related-posts .penci-irp-heading { font-size: 16px; font-weight: bold; margin-bottom: 8px; display: block; } .penci-inline-related-posts .penci_post-meta { display: none; } blockquote { color: '. sanitize_hex_color( $text_color ).'; background: rgba(127,127,127,.125); border-left: 4px solid '. sanitize_hex_color( $link_color ).'; margin: 8px 0 24px 0; padding: 16px; } blockquote p:last-child { margin-bottom: 0; } blockquote.alignleft { margin: 5px 10px 10px 0; } blockquote.alignright { margin: 5px 0 10px 10px; }';
echo '.amp-wp-meta, .penci-amp-wp-header div, .wp-caption-text, .amp-wp-tax-category, .amp-wp-tax-tag, .amp-wp-comments-link, .penci-amp-footer p, .back-to-top { font-family:'. penci_amp_google_fonts_parse_attributes( penci_amp_get_setting( 'penci_amp_font_for_body' ) ).'; } .penci-amp-wp-header { background-color: '. sanitize_hex_color( $header_background_color ).'; overflow: hidden; } body.sticky-header { padding-top: 54px; } .sticky-header .penci-amp-wp-header { position: fixed; left: 0; right: 0; top: 0; z-index: 999; display: block; } .site-header .navbar-toggle { font-size: 21px; left: 0; } .penci-amp-wp-header .navbar-search, .penci-amp-wp-header .navbar-toggle, .penci-amp-wp-header .branding { color: '. sanitize_hex_color( $header_color ).'; } .penci-amp-wp-header .navbar-search .fa { top: 2px; position: relative; } .penci-amp-wp-header .branding { display: block; text-align: center; font-size: 30px; font-weight: 600; text-decoration: none; font-family: '. $font_Teko.'; width: 100%; padding: 10px 55px; z-index: 9; height: 54px; line-height: 34px; box-sizing: border-box; } .penci-amp-wp-header .navbar-search, .penci-amp-wp-header .navbar-toggle { font-weight: normal; font-size: 18px; position: absolute; top: 0; z-index: 99; border: none; background: transparent; height: 54px; line-height: 52px; margin: 0; padding: 0; width: 52px; text-align: center; outline: 0; cursor: pointer; -webkit-transition: all .6s ease; -moz-transition: all .6s ease; -o-transition: all .6s ease; transition: all .6s ease; } .penci-amp-wp-header .navbar-toggle { font-size: 21px; left: 0; } .penci-amp-wp-header .navbar-search { font-size: 18px; right: 0; line-height: 48px; } .penci-amp-wp-header div { color: '. sanitize_hex_color( $header_color ).'; font-size: 1em; font-weight: 400; margin: 0 auto; padding: 0; position: relative; box-sizing: border-box; height:54px; } .penci-amp-wp-header a { color: '. sanitize_hex_color( $header_color ).'; text-decoration: none; } .penci-amp-wp-header .penci-amp-site-icon { padding: 2px 60px; box-sizing: border-box; max-height: 54px; display: flex; align-items: center; justify-content: center; overflow: hidden; } .penci-amp-wp-header .penci-amp-site-icon amp-img{ margin-left: auto; margin-right: auto; display:block; } .wrap { padding: 15px 15px 0; height: 100%; } .img-holder { position: relative; width: 100%; background: #ccc url(images/no-image.jpg); display: inline-block; vertical-align: top; background-repeat: no-repeat; background-position: center center; background-size: cover; -webkit-background-size: cover; -moz-background-size: cover; -o-background-size: cover; height: 100%; transition: transform .3s ease, opacity .3s; transition-timing-function: cubic-bezier(0.39, 0.76, 0.51, 0.56); } .img-holder:before{ display: block; content: ""; width: 100%; padding-top: 66.6667%; background: none ; box-shadow: none ; }';
echo '.amp-slider{ background: #eee; direction: ltr; } .amp-slider a{ text-decoration: none; } .homepage-slider{ margin: 0 0 0; width: 100%; position: relative; max-width: 100%; }';
if( is_front_page() || is_home() || penci_amp_polylang_front_page() ){
	echo '.homepage-slider amp-carousel { margin-top: 3px; }';
}
echo '.rtl .amp-featured-slider .content-holder{ direction: rtl; } .amp-featured-slider .img-holder:after{ content: ""; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: #000; z-index: 1; bottom: 0; right: 0; background: linear-gradient(to bottom, transparent 50%, #000 90%); opacity: 0.9; transition: opacity 0.3s; } .amp-featured-slider .slider-item-not-caption .img-holder:after { content: none; } .gallery-feature-img-single .content-holder span{ color: #fff; } .penci-owl-featured-area .penci-slider__text { text-align: left; position: absolute; bottom: 0; padding: 20px 20px 9px; z-index: 99; } .amp-featured-slider .content-holder{ text-align: center; position: absolute; bottom: 0; padding: 0px 0 15px; z-index: 99; } .amp-featured-slider .content-holder a{ color: #fff; } .amp-featured-slider .content-holder h3{ margin: 20px 0 0; font-size: 22px; }';
echo '.amp-wp-article { color: '. sanitize_hex_color( $text_color ).'; font-weight: 400; margin: 1.5em auto; max-width: 840px; overflow-wrap: break-word; word-wrap: break-word; } .amp-wp-article > p:last-child{ margin-bottom: 0; } .amp-wp-article-header { align-items: center; align-content: stretch; display: flex; flex-wrap: wrap; justify-content: space-between; margin: 1.5em 0 1.5em; } .amp-wp-title { color: '. sanitize_hex_color( $title_color ).'; display: block; flex: 1 0 100%; width: 100%; line-height: 1.2; margin-top: 9px; margin-bottom: 6px; } .post-image{ margin-bottom: 20px; } .amp-wp-meta { color: '. sanitize_hex_color( $muted_text_color ).'; display: inline-block; flex: 2 1 50%; font-size: .875em; line-height: 1.5em; margin: 0; padding: 0; } .amp-wp-article-header .amp-wp-meta:last-of-type { text-align: right; } .amp-wp-article-header .amp-wp-meta:first-of-type { text-align: left; } .amp-wp-byline amp-img, .amp-wp-byline .amp-wp-author { display: inline-block; vertical-align: middle; } .amp-wp-byline amp-img { border: 1px solid '. sanitize_hex_color( $link_color ).'; border-radius: 50%; position: relative; margin-right: 6px; } .amp-wp-posted-on { text-align: right; } .penci-amp-entry-meta{ color: '. $muted_text_color .'; line-height: 1.6; font-size: 13px; margin-top: 5px; } .penci-amp-entry-meta .entry-meta-item{ margin-right: 15px; display: inline-block; }.penci-amp-entry-meta .penci-amp-pviews{ display: none; }.penci-amp-entry-meta a, .penci-amp-entry-meta span, .penci-amp-entry-meta i { font-size: inherit; color: inherit; text-decoration: none; } .penci-amp-entry-meta i{ margin-right: 3px; }.penci-amp-entry-meta .entry-meta-item:last-child { margin-right: 0; } .amp-wp-article-featured-image { margin: 0 0 1em; } .amp-wp-article-featured-image amp-img { margin: 0 auto; } .amp-wp-article-content { margin: 0; } .amp-wp-article-content ul, .amp-wp-article-content ol { margin-left: 1em; } .amp-wp-article-content amp-img { margin: 0 auto; } .amp-wp-article-content amp-img.alignright, .amp-wp-article-content amp-img.alignleft { margin: 0 0 1em 0; } .amp-wp-article-content amp-img.alignright { display: inline; float: right; margin-left: 1.5em; } .amp-wp-article-content amp-img.alignleft { display: inline; float: left; margin-right: 1.5em; } .wp-caption { padding: 0; } .wp-caption.alignleft { margin-right: 16px; } .wp-caption.alignright { margin-left: 16px; } .wp-caption .wp-caption-text { color: '. sanitize_hex_color( $muted_text_color ).'; font-size: 14px; line-height: 1.3; margin: 0; padding: .66em 10px .75em; text-align: center; }';
if( is_front_page() || is_home() || penci_amp_polylang_front_page() ){
	echo 'amp-carousel { background: '. sanitize_hex_color( $border_color ).'; margin: 20px 0 0; } amp-carousel > amp-img > img { object-fit: contain; } .amp-wp-article-content amp-carousel amp-img { border: none; }';
}
echo 'amp-iframe, amp-youtube, amp-instagram, amp-vine { background: '. sanitize_hex_color( $border_color ).'; margin: 0 -16px 1.5em; } .amp-wp-iframe-placeholder { background: '. sanitize_hex_color( $border_color ).' url( '. esc_url( $this->get( 'placeholder_image_url' ) ).' ) no-repeat center 40%; background-size: 48px 48px; min-height: 48px; } /* Article Footer Meta */ .amp-wp-article-footer { padding-top: 20px; } .amp-wp-article-footer .amp-wp-meta { display: block; } .penci-amp-tags-links { margin: 10px 0 5px; width: 100%; overflow: hidden; display: block; } .penci-amp-tags-links a { float: left; display: inline-block; min-height: 24px; line-height: 24px; font-size: 10px; font-weight: 700; text-align: left; color: '. sanitize_hex_color( $muted_text_color ).'; background: #ececec; transition: all 0.3s; margin: 0 2.5px 5px; text-transform: uppercase; padding-left: 10px; padding-right: 10px; } .penci-amp-tags-links a:hover { color: '. sanitize_hex_color( $muted_text_color ).'; background: #ececec; } .penci-amp-tax-category { overflow: hidden; } .penci-amp-tax-category a { font-size: 13px; color: '. $link_color.'; line-height: 1.2; margin: 0 18px 0 0; padding-right: 10px; display: inline-block; vertical-align: top; background: none; transition: all 0.3s; -webkit-transition: all 0.3s; -moz-transition: all 0.3s; font-weight: normal; margin-bottom: 5px; position: relative; text-decoration: none; } .penci-amp-tax-category a:after { content: ""; display: inline-block; border: 1px solid; font-size: 12px; margin-left: 11px; position: absolute; top: 50%; margin-top: -3px; width: 3px; height: 3px; transform: rotate(45deg); -moz-transform: rotate(45deg); -webkit-transform: rotate(45deg); } .penci-amp-tax-category a:last-child:after { content: none; } .penci-amp-single .penci-social-buttons { margin-top: 19px; margin-bottom: 35px; display: block; border: 1px solid '. sanitize_hex_color( $border_color ).'; padding: 10px 15px; } .penci-social-buttons .penci-social-share-text { text-transform: uppercase; font-weight: 700; margin-right: 20px; font-size: 14px; } .penci-social-buttons .penci-social-item { display: inline-block; margin: 5px 9px 5px 0; font-size: 14px; font-weight: normal; line-height: 32px; text-align: left; color: #ffffff; text-transform: none; height: 32px; border: 0; background-color: #0d47a1; padding: 0 12px; transition: opacity 0.3s; border-radius: 0; vertical-align: middle; } .penci-social-buttons .penci-social-item:last-child{ margin-right: 0; } .penci-social-buttons .penci-social-item .dt-share { display: none; } .penci-social-buttons .penci-social-item.twitter { background-color: #40c4ff; } .penci-social-buttons .penci-social-item.google_plus { background-color: #eb4026; } .penci-social-buttons .penci-social-item.instagram { background-color: #417096; } .penci-social-buttons .penci-social-item.pinterest { background-color: #C92228; } .penci-social-buttons .penci-social-item.vk{ background-color: #5181b8; } .penci-social-buttons .penci-social-item.ok{ background-color: #F18F00; } .penci-social-buttons .penci-social-item.pocket{ background-color: #ef4056; } .penci-social-buttons .penci-social-item.skype{ background-color: #00aff0; }.penci-social-buttons .penci-social-item.email { background-color: #a7a7a7; } .penci-social-buttons .penci-social-item.linkedin { background-color: #0077B5; } .penci-social-buttons .penci-social-item.tumblr { background-color: #34465d; } .penci-social-buttons .penci-social-item.reddit { background-color: #ff4500; } .penci-social-buttons .penci-social-item.stumbleupon { background-color: #ee4813; } .penci-social-buttons .penci-social-item.whatsapp { background-color: #00c853; } .penci-social-buttons .penci-social-item.telegram { background-color: #179cde; }';
echo '.penci-post-pagination { width: 100%; margin: 0; overflow: hidden; padding: 0 0 30px; } .penci-post-pagination .prev-post-title { margin-top: -8px; } .penci-post-pagination span { color: '. $muted_text_color .'; display: inline-block; font-size: 10px; font-weight: bold; line-height: 2.4; text-transform: uppercase; } .penci-post-pagination span i { margin-right: 6px; } .penci-post-pagination span i.fa-angle-right { margin: 0 0 0 6px; } .penci-post-pagination h5 { font-size: 15px; line-height: 1.33; margin: 0; padding: 0 15px 0 0; position: relative; } .penci-post-pagination h5.next-title { padding: 0 0 0 15px; } .penci-post-pagination a { color: '. sanitize_hex_color( $link_color ).'; } .penci-post-pagination a:hover { color: '. sanitize_hex_color( $link_color ).'; } .pagi-text { margin-top: 6px; } .penci-post-pagination .prev-post, .penci-post-pagination .next-post { width: 100%; padding: 0; text-align: center; } .penci-post-pagination .prev-post + .next-post { padding-top: 20px; margin-top: 20px; padding-left: 0; width: 100%; border-top: 1px solid '. sanitize_hex_color( $border_color ).'; } .penci-ajax-more .penci-block-ajax-more-button { width: 100%; } .penci-post-related{ border-top: 1px solid '. sanitize_hex_color( $border_color ).'; overflow: hidden; margin: 0 0 20px; padding: 22px 0 0px; width: 100%; } .penci-amp-single .post-title-box { margin-bottom: 13px; } .post-title-box .post-box-title { font-size: 18px; text-transform: uppercase; position: relative; z-index: 10; display: inline-block; margin: 0; line-height: 1.67; color: '. $text_color.'; } .penci-post-related .post-related_content { margin-left: -10px; margin-right: -10px; overflow: hidden; } .penci-post-related .post-related_content:after { content: " "; display: block; clear: both; width:100%; } .penci-post-related .item-related { width: 33.3333%; float: left; padding: 0 10px; } .penci-post-related .item-related h4 { margin: 15px 0 0; font-size: 15px; font-weight: 600; line-height: 1.3; } .penci-post-related .item-related h4 a{ color: '. $text_color.'; } .amp-wp-comments-link { color: '. sanitize_hex_color( $muted_text_color ).'; font-size: .875em; line-height: 1.5em; text-align: center; margin: 2.25em 0 1.5em; } .amp-wp-comments-link a { border-style: solid; border-color: '. sanitize_hex_color( $border_color ).'; border-width: 1px 1px 2px; border-radius: 4px; background-color: transparent; color: '. sanitize_hex_color( $link_color ).'; cursor: pointer; display: block; font-size: 14px; font-weight: 600; line-height: 18px; margin: 0 auto; max-width: 200px; padding: 11px 16px; text-decoration: none; width: 50%; -webkit-transition: background-color 0.2s ease; transition: background-color 0.2s ease; } .penci-amp-archive-page-header { padding: 15px 0px 9px; margin: 0 0 15px; font-weight: 500; position: relative; } .penci-amp-taxonomy-description { font-size: 13px; font-weight: normal; line-height: 1.5; margin-top: 10px; color: #777; } .penci-amp-taxonomy-description p{ margin:0; font-size: inherit; font-weight: inherit; color: inherit; } .penci-amp-archive-page-header .pre-title { font-size: 14px; margin-bottom: 3px; font-weight: 400; color: #868686; text-transform: capitalize; } .penci-amp-archive-page-header .archive-title { margin: 0; font-size: 25px; text-transform: capitalize; color: '. $title_color.'; }';
echo '.penci-archive__list_posts.listing-1 .article_content, .penci-archive__list_posts.listing-3 .article_content{ display: -webkit-box; display: -webkit-flex; display: -ms-flexbox; display: flex; -webkit-box-align: start; -webkit-align-items: flex-start; -ms-flex-align: start; align-items: flex-start; } .penci-archive__list_posts .penci-post-item{ margin-top: 20px; } .penci-archive__list_posts .penci-post-item-1{ margin-top: 0; } .penci-archive__list_posts .entry-media a, .penci-archive__list_posts .entry-media img{ display: block; } .penci-archive__list_posts.listing-1 .entry-media, .penci-archive__list_posts.listing-3 .entry-media{ margin-right: 15px; width: 35%; } .penci-archive__list_posts .penci-post-thumb{ width:100%; height: auto; } .penci-archive__list_posts.listing-1 .entry-text, .penci-archive__list_posts.listing-3 .entry-text{ flex: 1; } .penci-archive__list_posts.listing-1 .penci__post-title, .penci-archive__list_posts.listing-3 .penci__post-title{ font-size: 14px; margin-top: 0; margin-bottom: 0; position: relative; font-weight: 500; font-family: '. $font_Roboto.'; }.penci-archive__list_posts .penci__post-title a{ color: '. $title_color.'; text-decoration: none; } .penci-archive__list_posts .penci__post-title a:hover{ color: '. $link_color .'; } .penci-amp-wrapper .penci-archive__list_posts.listing-1 .post-excerpt, .penci-amp-wrapper .penci-archive__list_posts.listing-3 .post-excerpt{ display: none; } .penci-archive__list_posts .entry-meta{ margin-top: 9px; color: '. $muted_text_color.'; font-size: 13px; display:block; }.penci-archive__list_posts .entry-meta span{margin-right: 10px;color:inherit;}.penci-archive__list_posts .entry-meta span:last-child{margin-right:0;}.penci-archive__list_posts .entry-meta span a{ color: inherit; }.penci-archive__list_posts .penci-posted-on a{ color: inherit; } .penci-archive__list_posts .entry-meta .fa{ margin-right: 3px; } .penci-archive__list_posts .post-excerpt p:last-child{ margin-bottom:0; } .penci-archive__list_posts.listing-2 a.post-read-more, .penci-archive__list_posts.listing-3 .penci-post-item-1 a.post-read-more { margin-top: 10px; display: block; } .penci-archive__list_posts a.post-read-more { font-family: '. $font_Roboto.'; font-weight: 600; text-decoration: none; padding: 0; border-radius: 33px; display: inline-block; line-height: 24px; margin-top: 8px; text-transform: uppercase; border: 0; padding: 0; font-size: 13px; line-height: 1; } .penci-archive__list_posts a.post-read-more .fa { margin-left: 3px; font-size: 15px; vertical-align: middle; top: -2px; position: relative; } .penci-archive__list_posts.listing-2 .penci__post-title, .penci-archive__list_posts.listing-3 .penci-post-item-1 .penci__post-title{ font-size: 17px; margin-top: 10px; margin-bottom: 0; position: relative; font-weight: 500; font-family: '. $font_Roboto.'; } .penci-archive__list_posts.listing-2 .post-excerpt, .penci-archive__list_posts.listing-3 .penci-post-item-1 .post-excerpt{ font-size: 14px; line-height: 1.71; color: #666666; display:block; margin-top: 5px; } .penci-archive__list_posts.listing-2 .post-excerpt .link-more, .penci-archive__list_posts.listing-3 .penci-post-item-1 .post-excerpt .link-more{ display:none; } .penci-archive__list_posts.listing-3 .penci-post-item-1 .article_content { display:block; } .penci-archive__list_posts.listing-3 .penci-post-item-1 .entry-media { margin-right: 0; width: 100%; } .meta-none{ display: none; }.meta-show{ display: inline-block; }';
echo '.penci-amp-comment { border-top: 1px solid '. sanitize_hex_color( $border_color ).'; padding-top: 21px; margin-top: 26px; } .penci-post-item + .post-comments h3.comment-reply-title { padding-top: 0; } h3.comment-reply-title { padding-top: 32px; } .penci-comments-button { margin-top: 20px; padding-top: 20px; border-top: 1px solid '. sanitize_hex_color( $border_color ).'; } .penci-comments-button a { display: block; width: 50%; margin-right: auto; margin-left: auto; line-height: 38px; padding: 0px 15px 0; font-weight: bold; } .penci-comments-button + .post-comments { display: none; } .penci-comments-button + .post-comments .comment-reply-title, .penci-post-related + .post-comments .comment-reply-title, .penci-post-related + .post-comments .post-title-box { margin-top: 20px; border-top: 1px solid '. sanitize_hex_color( $border_color ).'; } .comments .comment { border-top: 1px solid '. sanitize_hex_color( $border_color ).'; } .comments .comment .comment { border-top: 1px solid '. sanitize_hex_color( $border_color ).'; } .comments > .comment:first-child, .comments .comment > .comment:first-child { border-top: none; } .thecomment { padding-top: 20px; padding-bottom: 0; display: table; width: 100%; } .comments > .comment:first-child > .thecomment { padding-top: 0; } .thecomment .author-img { display: none; } .thecomment .comment-text { margin-left: 0; position: relative; } .thecomment .comment-text span.author, .thecomment .comment-text span.author a { display: block; margin-top: -3px; margin-bottom: 5px; font-family: "Mukta Vaani", sans-serif; font-size: 18px; font-weight: bold; line-height: 1.33; text-align: left; color: '. $text_color.'; } .thecomment .comment-text span.author a { display: inline-block; margin: 0; } .thecomment .comment-text span.author a:hover { color: '. $link_color.'; } .thecomment .comment-text span.date { font-size: 12px; color: '. $muted_text_color.'; display: block; } .thecomment .comment-text span.date i { margin-right: 5px; } .thecomment .comment-text em { font-size: 12px; display: block; color: orange; letter-spacing: 1px; margin: 5px 0 0; } .thecomment .comment-text em i { font-size: 14px; color: #f3bd00; } .thecomment .comment-content { margin: 15px 0; } .thecomment .comment-text span.reply { display: none; } .post-comments span.reply a { font-size: 11px; color: '. $muted_text_color .'; margin-left: 18px; font-family: "Raleway", sans-serif; font-weight: 500; -o-transition: .3s; -moz-transition: .3s; -webkit-transition: .3s; transition: .3s; text-transform: uppercase; line-height: 1; display: inline-block; text-align: center; } .post-comments span.reply a:hover { color: '. $link_color.'; } .comments .comment + #respond { margin-bottom: 20px; } #respond { overflow: hidden; position: relative; } .no-comment-yet #respond { padding-top: 0; border-top: 0; } #respond h3 { font-size: 18px; text-transform: uppercase; position: relative; z-index: 10; display: inline-block; margin: 0; width: 100%; font-size: 18px; font-weight: bold; line-height: 1.67; color: '. $text_color.'; margin-bottom: 13px; } #respond h3 a { color: #000; display: inline-block; } #respond h3 small a { text-transform: uppercase; font-size: 12px; color: '. $muted_text_color .'; padding: 0; margin-left: 7px; letter-spacing: 0; -o-transition: .3s; -ms-transition: .3s; -moz-transition: .3s; -webkit-transition: .3s; transition: .3s; font-weight: 500; position: absolute; right: 0; } #respond #cancel-comment-reply-link { font-size: 11px; font-family: '. $font_Roboto.'; font-weight: normal; } #respond h3 small a:hover { color: '. $title_color.'; } #respond form#commentform, form.wpcf7-form { margin-left: -10px; margin-right: -10px; } .mc4wp-form label { text-align: left; margin-bottom: 10px; } #respond p.comment-form-author, #respond p.comment-form-email, #respond p.comment-form-url, .wpcf7 p.name, .wpcf7 p.email, .wpcf7 p.subject { width: 100%; padding: 0 10px; float: left; display: inline-block; margin: 0; } #respond p.comment-form-comment, .wpcf7 p.message { clear: both; margin: 0 10px; }';
echo 'form.comment-form > p, form.comment-form > div, form.comment-form > input, form.comment-form > textarea, form.comment-form > label, form.comment-form > span, form.wpcf7-form > div, form.wpcf7-form > p, form.wpcf7-form > input, form.wpcf7-form > textarea, form.wpcf7-form > label, form.wpcf7-form > span, form#commentform > p, form#commentform > div, form#commentform > input, form#commentform > textarea, form#commentform > label, form#commentform > span { margin: 0 14px; } form#commentform > input[type="checkbox"] { margin-left: 14px; margin-right: 14px; } .captchaSizeDivLarge { clear: both; } label#captcha_code_label { display: inline-block; } .woocommerce div.product .woocommerce-tabs .panel #respond p.comment-form-author, .woocommerce div.product .woocommerce-tabs .panel #respond p.comment-form-email { padding: 0; } .penci-amp-single-product .entry-meta-hide, .woocommerce .penci-product-item .entry-meta-hide { display: none; } .woocommerce #review_form #respond p { margin: 10px 14px; } .woocommerce #review_form #respond p.stars { margin-left: 0; margin-right: 0; } #respond label, .wpcf7 label { color: #939393; font-size: 12px; display: block; text-transform: uppercase; font-weight: bold; letter-spacing: 1px; margin-bottom: 8px; } #respond p.form-submit, .wpcf7 p.submit { margin: 0 10px; } .button.add-comment, #respond input, .wpcf7 input, .widget_wysija input { padding: 12px 19px 11px; max-width: 100%; border: 1px solid '. sanitize_hex_color( $border_color ).'; margin-bottom: 19px; width: 100%; max-height: 40px; font-size: 12px; line-height: 1.3; color: '. $muted_text_color .'; } .wpcf7 input[type="checkbox"]{ width: auto; } #respond input:focus, .wpcf7 input:focus { outline: none; } .jetpack_subscription_widget #subscribe-email input { width: 100% ; padding: 12px 19px 11px; margin-top: 10px; } #respond textarea, .wpcf7 textarea { padding: 12px 19px 11px; border: 1px solid '. sanitize_hex_color( $border_color ).'; width: 100%; min-height: 120px; font-size: 12px; margin-bottom: 19px; outline: none; vertical-align: top; font-size: 12px; line-height: 1.3; background: transparent; color: '. $muted_text_color .'; } #respond textarea:focus, .wpcf7 textarea:focus { outline: none; } .button.add-comment, #respond #submit, .wpcf7 input[type="submit"], .widget_wysija input[type="submit"] {     text-decoration: none;text-transform: uppercase; border-radius: 0; display: inline-block; transition: all .3s; cursor: pointer; width: auto; min-width: 91px; margin: 0; border: none; line-height: 1; font-size: 14px; font-weight: bold; color: #ffffff; } .button.add-comment, #respond #submit:hover, .wpcf7 input[type="submit"]:hover, .widget_wysija input[type="submit"]:hover { color: #fff; } .contact-form input[type=email], .contact-form input[type=text] { max-width: 300px; width: 100%; padding: 10px 15px; }';
echo '.penci-amp-footer { border-top: 1px solid '. sanitize_hex_color( $border_color ).'; margin: calc(1.5em - 1px) -15px 0; clear: both; } .penci-amp-footer-nav { padding: 7px 15px; } .penci-amp-footer .penci-amp-footer-container { margin: 0 auto; max-width: calc(840px - 32px); padding: 0; position: relative; } .penci-footer-navigation { list-style: none; margin: 0; padding: 0; text-align: center; } .penci-footer-navigation li { display: inline-block; margin: 0 8px 5px; line-height: 1.3; } .penci-footer-navigation ul.sub-menu{ display: none; } .penci-footer-navigation a { color: '. $text_color.'; font-family: '. $font_Roboto.'; font-weight: 400; font-size: 14px; } .penci-footer-navigation a:hover { color: '. $link_color.'; } .penci-footer-navigation li li { display: none; } .penci-footer-navigation .fa { margin-right: 5px; } .penci-amp-footer h2 { font-size: 1em; line-height: 1.375em; margin: 0 0 .5em; } .penci-amp-footer p { color: '. sanitize_hex_color( $muted_text_color ).'; font-size: .8em; margin: 0 85px 0 0; } .penci-amp-footer a { text-decoration: none; } .footer__copyright_menu a{ color : #fff; } .footer__copyright_menu a:hover { color: '. $link_color.'; } .back-to-top { bottom: 1.275em; font-size: .8em; font-weight: 600; line-height: 2em; position: absolute; right: 16px; top:7px; } .back-to-top .fa{ margin-left: 5px; } .penci-amp-main-link { text-align: center; padding: 17px 10px; } .penci-amp-main-link a { color: #ffffff; text-decoration: none; padding: 1px 14px 0; display: inline-block; border: 0; border-radius: 0; line-height: 28px; font-size: 11px; font-weight: 400; transition: all 0.3s; letter-spacing: 0; text-transform: uppercase; background: '. $link_color .'; } .penci-amp-main-link .fa{ padding-right: 2px; font-size: 10px; } .penci-amp-main-link a:hover { opacity: 0.8; } .footer__copyright_menu {min-height: 36px;clear: both; overflow: hidden; background: #212121; padding-left: 15px; position: relative; padding-top: 11px; padding-bottom: 11px; line-height: 1.3; text-align: left; color: #414141; }';
echo '.sidebar-nav-social .screen-reader-text { clip: rect(1px, 1px, 1px, 1px); position: absolute; height: 1px; width: 1px; overflow: hidden; } .mobile-sidebar { padding: 5px 15px 15px; width:270px; max-width: 100%; background :#fff; } .mobile-sidebar::-webkit-scrollbar { width: 6px; background: #848484; } .mobile-sidebar::-webkit-scrollbar-thumb { background-color: #313131; border-radius:0; -webkit-border-radius:0; -moz-border-radius:0; } .mobile-sidebar::-webkit-scrollbar-corner { background-color: #DEDEDE; } #close-sidebar-nav { border: 0; background: transparent; position: absolute; top: 5px; right: 10px; z-index: 100; padding:0; } #close-sidebar-nav i { width: 24px; height: 24px; background-color: #fff; line-height: 24px; text-align: center; border-radius: 12px; font-size: 14px; vertical-align: top; color: '. $text_color.'; } .mobile-sidebar .mobile-navigation { clear: both; } .mobile-sidebar .primary-menu-mobile { margin: 0; padding: 0; list-style: none; } .mobile-sidebar .primary-menu-mobile li > ul, .mobile-sidebar .primary-menu-mobile li > ol { margin-bottom: 0; } .mobile-sidebar .primary-menu-mobile li { display: block; border-bottom: 1px solid #dedede; } .mobile-sidebar .primary-menu-mobile > li:last-child, .mobile-sidebar .primary-menu-mobile ul > li:last-child { border-bottom: none; } .mobile-sidebar .primary-menu-mobile li.penci-mega-menu .dropdown-toggle, .mobile-sidebar .primary-menu-mobile li.penci-mega-menu .sub-menu{ display: none; } .mobile-sidebar .primary-menu-mobile li. { position: relative; } .mobile-sidebar .primary-menu-mobile li a { font-size: 14px; font-weight: normal; letter-spacing: 0; text-transform: uppercase; color: #212121; margin: 0; position: relative; padding: 12px 0 12px 0; display: block; line-height: 1.3em; text-decoration: none; } .mobile-sidebar .primary-menu-mobile li.menu-item-has-children a { padding-right: 17px; } .mobile-sidebar .primary-menu-mobile li a:hover { color: '. $link_color.'; } .mobile-sidebar .primary-menu-mobile li a > i { display: none; } .mobile-sidebar ul.sub-menu { border-top: 1px solid #dedede; padding: 10px 0 10px 12px; margin-left: 0; } .mobile-sidebar ul.sub-menu ul.sub-menu { border: none; padding: 5px 0 5px 12px; padding-right: 0; margin-left: 0; } .mobile-sidebar ul.sub-menu li { overflow: hidden; border: none; } .mobile-sidebar ul.sub-menu li a { margin: 0 0 0 0; padding: 10px 0; transition: all 0.3s; -webkit-transition: all 0.3s; -moz-transition: all 0.3s; } .mobile-sidebar .primary-menu-mobile .dropdown-toggle { text-decoration: none; position: absolute; top: 0; right: 0; z-index: 20; font-size: 17px; font-style: normal; text-align: right; padding: 11px 0 11px 5px; line-height: 1; transition: all 0.3s; color: #212121; } .mobile-sidebar .primary-menu-mobile .sub-menu li a .dropdown-toggle { padding: 8px 0 8px 5px; } .mobile-sidebar .primary-menu-mobile .sub-menu li a .dropdown-toggle { padding: 8px 0 8px 5px; } .mobile-sidebar .penci-amphtml-accordion-header { background-color: transparent; border: 0; } .mobile-sidebar .primary-menu-mobile li.toggled-on > a, .mobile-sidebar .primary-menu-mobile li.toggled-on > .dropdown-toggle, .mobile-sidebar .primary-menu-mobile li.current-menu-item > a, .mobile-sidebar .primary-menu-mobile li.current-menu-item > .dropdown-toggle { color: '. $text_color.'; } .mobile-sidebar #sidebar-nav-logo { max-width: 230px; padding: 20px 0 0; text-align: center; margin: 0; position: relative; overflow: hidden; font-size: 2em; } .mobile-sidebar #sidebar-nav-logo a { font-family: "Teko", sans-serif; font-weight: 700; line-height: 1; color: '. $text_color.'; padding: 0; margin: 0; text-decoration: none; } .mobile-sidebar .sidebar-nav-social { margin: 0 0 43px 0; padding: 0 10px; text-align: center; } .mobile-sidebar .sidebar-nav-social .inner-header-social { display: inline-block; vertical-align: top; position: relative; } .mobile-sidebar .sidebar-nav-social a { float: left; display: inline-block; vertical-align: top; margin-right: 13px; color: #212121; } .mobile-sidebar .sidebar-nav-social a:hover { color: '. $link_color .'; }';
echo 'body.penci-amp-body.search-results .penci-search-form.empty { padding: 35px 0; border-bottom: none; min-height: 250px; } .penci-search-form { font-family: '. $font_Roboto.'; font-size: 16px; padding: 0 0 18px; margin: 0 0 6px; } .penci-search-form label { display: block; padding: 0 0 10px; color: '. $text_color.'; } .penci-search-form .search-input-submit { position: relative; } .penci-search-form .search-field { -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075); -moz-box-shadow: inset 0 1px 1px rgba(0,0,0,.075); box-shadow: inset 0 1px 1px rgba(0,0,0,.075); background: transparent; display: block; border: 1px solid '. sanitize_hex_color( $border_color ).'; font-size: 15px; padding: 0 100px 0 18px; line-height: 36px; width: 100%; border-radius: 0; -webkit-appearance: textfield; color: '. $text_color.'; } .penci-search-form .search-submit { position: absolute; top: 0; right: 0; bottom: 0; width: auto; text-transform: uppercase; border: none; cursor: pointer; line-height: 38px; padding: 0 22px; border-radius: 0; } .penci-search-form + .penci-archive__list_posts { border-top:1px solid '. sanitize_hex_color( $border_color ).'; padding-top: 20px; }';
echo '.pagination { clear: both; overflow: hidden; text-align: center; padding: 20px 0 9px; width: 100%; font-size: 12px; font-weight: 600; } .pagination .nav-links { display: inline-block; margin: -2px -2px 0; vertical-align: top; text-align: center; margin-left: auto; margin-right: auto; } .pagination a, .pagination span.page-numbers { margin-left: 2px; margin-right: 2px; margin-top: 2px; float: left; display: inline-block; background: transparent; border: solid 1px '. sanitize_hex_color( $border_color ).'; color: '. $title_color.'; min-width: 30px; height: 30px; line-height: 28px; transition: all 0.3s; text-decoration: none; box-sizing: border-box; } .pagination span.current, .pagination a:hover { background: '. $link_color.'; border-color: '. $link_color.'; color: #ffffff; } .penci-amp-error-404 { text-align: center; padding-bottom:10px; } #penci-disable-amp-accordion { display: none; }';

echo '.post-title-box{margin-bottom: 13px;}.penci-featured-cats-wrap .post-title-box a{ color: '. $text_color.'; }.penci-featured-cats-wrap:not(.penci-fcats-after){border-bottom: 1px solid #dedede;margin-bottom: 20px; padding-bottom: 20px;}';
echo '.amp-wp-article-content .blocks-gallery-grid {list-style: none; }.fcatblposts .penci-featured-cats-wrap{margin: 20px 0 0 0; padding: 20px 0 0 0; border-top: 1px solid #dedede; border-bottom: 0;}';
if ( class_exists( 'WooCommerce' ) ){
	echo "@font-face { font-family: 'star'; src: url('". penci_amp_get_asset_url( 'fonts/star.eot' ) ."'); src: url('". penci_amp_get_asset_url( 'fonts/star.eot?#iefix' ) ."') format('embedded-opentype'), url('". penci_amp_get_asset_url( 'fonts/star.woff' ) ."') format('woff'), url('". penci_amp_get_asset_url( 'fonts/star.ttf' ) ."') format('truetype'), url('". penci_amp_get_asset_url( 'fonts/star.svg#star' ) ."') format('svg'); font-weight: normal; font-style: normal; }";
	echo "@font-face { font-family: 'WooCommerce'; src: url('". penci_amp_get_asset_url( 'fonts/WooCommerce.eot' ) ."'); src: url('". penci_amp_get_asset_url( 'fonts/WooCommerce.eot?#iefix' ) ."') format('embedded-opentype'), url('". penci_amp_get_asset_url( 'fonts/WooCommerce.woff' ) ."') format('woff'), url('". penci_amp_get_asset_url( 'fonts/WooCommerce.ttf' ) ."') format('truetype'), url('". penci_amp_get_asset_url( 'fonts/WooCommerce.svg#WooCommerce' ) ."') format('svg'); font-weight: normal; font-style: normal; }";
	echo '.penci-archive__list_product { margin: -20px -10px 0; overflow: hidden; } .penci-archive__list_product .penci-product-item { width: 50%; padding:20px 10px 0; float:left; } .penci-archive__list_product .penci-product-item:nth-child( 2n+ 1 ) { clear: both; } .penci-archive__list_product .penci-product-item .article_content{ position: relative; padding:0; } .onsale { margin: 0; right: 10px; top: 10px; position: absolute; min-width: 38px; height: 20px; line-height: 20px; background: '. $text_color.'; text-align: center; padding: 0 7px; font-weight: bold; font-size: 12px; text-transform: uppercase; color: #fff; border-radius: 0; -webkit-border-radius: 0; -moz-border-radius: 0; white-space: nowrap; -webkit-font-smoothing: antialiased; z-index: 9; display: inline-block; } .penci-product-item .star-rating { margin: 0; position: absolute; top: 16px; left: 10px; z-index: 5; display: block; overflow: hidden; height: 1em; line-height: 1; font-size: 11px; width: 5.4em; font-family: star; } .star-rating::before { content: "\73\73\73\73\73"; color: #d3ced2; float: left; top: 0; left: 0; position: absolute; } .star-rating span { color: #FFCA00; overflow: hidden; float: left; top: 0; left: 0; position: absolute; padding-top: 1.5em; } .star-rating span::before { content: "\53\53\53\53\53"; top: 0; position: absolute; left: 0; } .penci-product-item .entry-text { text-align: center; } .penci-product-item .penci__product__title { font-size: 18px; text-align: center; padding: 0; margin: 20px 0 3px 0; color: '. $title_color.'; letter-spacing: 0; } .penci-product-item .penci__product__title a{ color: '. $title_color.'; } .penci-product-item .penci__product__title a:hover { color: '. $link_color.'; } .penci-product-item .woocommerce-price { margin: 0; text-align: center; font-size: 18px; color: '. $text_color.'; text-decoration: none; font-weight: normal; display: block; } .penci-product-item .woocommerce-price del { display: inline-block; font-size: 16px; color: #ccc; margin-right: 10px; opacity: 1; text-decoration: line-through; } .penci-product-item .woocommerce-price ins { font-weight: normal; } .penci-product-item .button { font-size: 14px; font-weight: bold; margin-top: 15px; display: block; border-radius: 0; -webkit-border-radius: 0; -moz-border-radius: 0; text-align: center; text-transform: uppercase; padding: 0; height: 40px; line-height: 40px; transition: .3s; cursor: pointer; width:100%; }';
	echo '.penci-amp-single-product { position: relative; } .penci-amp-single-product .product-thumbnails{ width:45%; float: left; } .penci-amp-single-product .product-thumbnails + .entry-summary { width:55%; float: left; padding-left:20px; } .product-gallery { margin-top:0 -10px; } .penci-amp-product-gallery__image { width:33.3333%; float:left; padding: 10px 5px; } .penci-amp-product-gallery__image:nth-child( 3n + 1 ) { clear: both; } .penci-amp-single-product .star-rating, .penci-amp-woo-tabs .star-rating { float: left; overflow: hidden; position: relative; height: 1em; line-height: 1; font-size: 1em; width: 5.4em; font-family: star; } .penci-amp-single-product .onsale { right: auto; left: 10px; } .penci-amp-woo-tabs { clear: both; padding-top: 20px; display: block; } .penci-amp-single-product .woocommerce-review-link { position: relative; top: -3px; padding-left: 5px; padding-left: 5px; } .penci-amp-woo-tabs .woocommerce-Tabs-panel{ padding: 10px; border-right: 1px solid '. $border_color.'; border-left: 1px solid '. $border_color.'; } .penci-amp-woo-tabs section:last-child .woocommerce-Tabs-panel{ padding: 10px; border-bottom: 1px solid '. $border_color.'; } #reviews #comments h2 { font-size: 15px; color: #313131; clear: both; letter-spacing: 0; line-height: 1.3em; margin-bottom: 17px; text-transform: uppercase; font-weight: bold; text-align: left; display: block; } #reviews #comments ol.commentlist { margin: 0; width: 100%; background: 0 0; list-style: none; } #reviews #comments ol.commentlist li { padding: 0; margin: 0 0 20px; border: 0; position: relative; background: 0; border: 0; } #reviews #comments ol.commentlist li img.avatar { width: 60px; border: none; border-radius: 50%; -webkit-border-radius: 50%; -moz-border-radius: 50%; padding: 0; background: none; float: left; position: absolute; top: 0; left: 0; height: auto; margin: 0; box-shadow: none; } #reviews #comments ol.commentlist li .comment-text { border: 1px solid #dedede; padding: 12px 20px; border-radius: 0; -webkit-border-radius: 0; -moz-border-radius: 0; margin: 0; } #reviews .star-rating { float: right; } #respond .comment-reply-title { font-size: 15px; color:'. $title_color.'; clear: both; letter-spacing: 0; line-height: 1.3em; margin-bottom: 17px; padding-top: 0; text-transform: uppercase; font-weight: bold; text-align: left; display: block; margin-top: 6px; } .penci-post-related.products .penci-archive__list_product{ margin-top: 0; }';
}
if ( function_exists( 'penci_recipe_shortcode_function' ) ){
	echo '.penci-recipe { border: 1px solid #dedede; padding: 5px 10px; } .penci-recipe-thumb,.penci-recipe-print,.penci-hide-tagupdated,.penci_rateyo, .penci-nutrition{ display: none; }.penci-nutrition.penci-show-nutrition{ display: block; }';
	echo '.penci-recipe h2{margin-top:5px;} .penci-recipe-heading .penci-recipe-meta { margin-top: 15px; } .penci-recipe-heading .penci-recipe-meta > span { display: block; margin-bottom: 4px; }';
}

if ( function_exists( 'penci_review_shortcode_function' ) ){
	echo '.wrapper-penci-review { margin:20px 0; border: 1px solid #dedede; padding: 5px 10px } .penci-review .penci-review-title{margin-top: 5px; margin-bottom: 10px;} .penci-review-thumb,.penci-review-average ,.penci-review-hauthor{ display:none; }.penci-review-metas .penci-review-meta i { margin-right: 4px; }.penci-review-btnbuyw .button { color: #fff; margin: 10px 0 20px; display: inline-block; line-height: 30px; } .penci-review-number .penci-review-text > div{display: inline-block;}';
}
if( get_theme_mod( 'penci_enable_cookie_law' ) ){
	echo '#amp-user-notification-gdpr{padding: 1em 1em 0; text-align: center; background: rgba(255, 255, 255, 0.85);}#amp-user-notification-gdpr button{line-height:26px;}';
}
if( is_rtl() ){
	echo 'body.rtl { direction: rtl; unicode-bidi: embed; } .rtl th { text-align: right; } .rtl dd { margin-right: 0; margin-left: auto } .rtl blockquote { border-left: 0; border-right: 2px solid '. sanitize_hex_color( $link_color ).'; } .rtl blockquote.alignleft { margin: 5px 0 10px 10px; } .rtl blockquote.alignright { margin: 5px 10px 10px 0; } .rtl .penci-owl-featured-area .penci-slider__text { text-align: right; } .rtl .amp-wp-article-header .amp-wp-meta:last-of-type { text-align: left; } .rtl .amp-wp-article-header .amp-wp-meta:first-of-type { text-align: right; } .rtl .penci-amp-entry-meta .entry-meta-item, .rtl .penci-archive__list_posts .entry-meta span{ margin-left: 10px; margin-right: 0; } .rtl .penci-amp-entry-meta i { margin-right: 0; margin-left: 3px; } .rtl .amp-wp-article-content ul, .rtl .amp-wp-article-content ol { margin-left: 0; margin-right: 19px; } .rtl .penci-amp-entry-meta .entry-meta-item:last-child, .rtl .penci-archive__list_posts .entry-meta span:last-child{ margin-left: 0; margin-right: 0; } .rtl .amp-wp-article-content amp-img.alignright { margin-right: 1.5em; margin-left: 0; } .rtl .amp-wp-article-content amp-img.alignright { margin-right: 0; margin-left: 1.5em; } .rtl .wp-caption.alignright { margin-right: 16px; } .rtl .wp-caption.alignleft { margin-left: 16px; } .rtl .penci-amp-tax-category a, .rtl .penci-amp-tags-links a { float: right; text-align: right; } .rtl .penci-amp-tax-category a{ margin: 0 0 0 18px;padding-right: 0; padding-left: 0; } .rtl .penci-social-buttons .penci-social-item{ text-align: right; } .rtl .penci-post-related .item-related { float: right; } .rtl .penci-archive__list_posts a.post-read-more .fa, .rtl .penci-archive__list_posts .entry-meta .fa{ margin-left: 3px; margin-right: 0; } .rtl .penci-post-pagination span i { margin-right: 0; margin-left: 6px; } .rtl .penci-post-pagination span i.fa-angle-right { margin: 0 6px 0 0; } .rtl .penci-post-pagination span i.fa-angle-right:before{ content: "\f104"; } .rtl .penci-post-pagination span i.fa-angle-left:before{ content: "\f105"; } .rtl .thecomment .author-img { float: right; margin-right: 0; margin-left: 20px; } .rtl .penci-archive__list_posts.listing-1 .entry-media, .rtl .penci-archive__list_posts.listing-3 .entry-media { margin-right: 0; margin-left: 15px; } .rtl .penci-archive__list_posts .penci-posted-on .fa { margin-right: 0; margin-left: 5px; } .rtl .penci-archive__list_posts a.post-read-more .fa { margin-left: 3px; margin-right: 0; } .rtl .penci-archive__list_posts a.post-read-more .fa-angle-right:before { content: "\f104"; } .rtl .thecomment .comment-text span.author, .rtl .thecomment .comment-text span.author a { text-align: right; } .rtl .thecomment .comment-text span.date i { margin-right: 0; margin-left: 5px; } .rtl .penci-social-buttons .penci-social-share-text { margin-right: 0; margin-left: 14px; } .rtl .footer__copyright_menu{ text-align: right; padding-left: 0; padding-right: 15px; min-height: 36px; } .rtl .penci-amp-footer p { margin: 0 0 0 85px; } .rtl .back-to-top { right: auto; left: 16px; } .rtl .back-to-top .fa { margin-left: 0; margin-right: 5px; } .rtl .pagination a, .pagination span.page-numbers{ float: right; } .rtl .pagination a i.fa-angle-right:before{ content: "\f104"; } .rtl .pagination a i.fa-angle-left:before{ content: "\f105"; } .rtl .penci-amp-main-link .fa { padding-right: 0; padding-left: 3px; } .rtl .penci-amp-wp-header .navbar-search { right: auto; left: 0; } .rtl .penci-amp-wp-header .navbar-toggle { left: auto; right: 0; } .rtl #close-sidebar-nav { right: auto; left: 10px; } .rtl .mobile-sidebar .primary-menu-mobile .dropdown-toggle { right: auto; left: 0; } .rtl .mobile-sidebar .penci-amphtml-accordion-header { background-color: transparent; padding-right: 0; padding-left: 20px; } .rtl .mobile-sidebar .primary-menu-mobile li.menu-item-has-children a { padding-right: 0; padding-left: 17px; } .rtl .mobile-sidebar ul.sub-menu { padding: 10px 12px 10px 0; } .rtl .penci-social-buttons .penci-social-item{ margin: 5px 0 5px 9px; }';
}

echo '@media only screen and (max-width : 680px) { .amp-featured-slider .content-holder h3 { font-size: 15px; } }';
echo '@media only screen and (max-width : 480px){ .penci-search-form .search-submit { padding: 0 15px; } .amp-featured-slider .img-holder:before { padding-top: 80%; } .amp-featured-slider .content-holder{ padding-left: 15px; padding-right:15px; width: 100%; } .penci-archive__list_posts.listing-1 .entry-media, .penci-archive__list_posts.listing-3 .entry-media { width: 108px; } .penci-post-related .item-related { width: 100%; margin-bottom: 20px; } .penci-post-related .item-related:last-child { margin-bottom: 0; } #respond p.comment-form-author, #respond p.comment-form-email, #respond p.comment-form-url, .wpcf7 p.name, .wpcf7 p.email, .wpcf7 p.subject { width:100%; } .penci-archive__list_product .penci-product-item { width: 100%; padding: 20px 10px 0; float: left; } .penci-amp-single-product .product-thumbnails, .penci-amp-single-product .product-thumbnails + .entry-summary { width:100%; padding-left: 0; } }';
echo '@media only screen and (min-width : 600px){ .amp-featured-slider .content-holder { left: 26px; right: 26px; } }';
echo 'h1, h2, h3, h4, h5, h6, .mobile-sidebar .primary-menu-mobile li a, .penci-archive__list_posts.listing-1 .penci__post-title, .penci-archive__list_posts.listing-3 .penci__post-title, .penci-archive__list_posts.listing-2 .penci__post-title, .penci-archive__list_posts.listing-3 .penci-post-item-1 .penci__post-title, .penci-archive__list_posts a.post-read-more, .penci-footer-navigation a, .penci-search-form, #respond h3, .penci-post-related .item-related h4, #respond #cancel-comment-reply-link { '. $custom_typo_title .' }';

if( $font_size_title = penci_amp_get_setting( 'penci_amp_font_for_size_title' ) ){
	echo '.penci-post-pagination h5, .penci-post-related .item-related h4, .penci-archive__list_posts.listing-1 .penci__post-title, .penci-archive__list_posts.listing-3 .penci__post-title, .penci-archive__list_posts.listing-2 .penci__post-title, .penci-archive__list_posts.listing-3 .penci-post-item-1 .penci__post-title{ font-size:'. $font_size_title .'px; }';
}

// Customizer

penci_amp_css_hidden_attr( 'penci_amp_home_show_slider', '.homepage-slider' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_comment', '.penci-amp-comment' );

// Header bar
penci_amp_css_hidden_attr( 'penci_amp_show_sidebar', '.penci-amp-wp-header .navbar-toggle' );
penci_amp_css_hidden_attr( 'penci_amp_show_search', '.penci-amp-wp-header .navbar-search' );

// Featured posts
penci_amp_css_hidden_attr( 'penci_amp_home_show_pdate', '.penci-archive__list_posts .penci-post-item .penci-posted-on' );
penci_amp_css_inlineblock_attr( 'penci_amp_home_show_pauthor', '.penci-archive__list_posts .penci-amp-author' );
penci_amp_css_inlineblock_attr( 'penci_amp_home_show_pcomments', '.penci-archive__list_posts .penci-comment-count' );
penci_amp_css_inlineblock_attr( 'penci_amp_home_show_pview', '.penci-archive__list_posts .penci-amp-pviews' );
penci_amp_css_hidden_attr( 'penci_amp_home_show_excrept', '.penci-archive__list_posts.listing-2 .post-excerpt, .penci-archive__list_posts.listing-3 .penci-post-item-1 .post-excerpt' );
penci_amp_css_hidden_attr( 'penci_amp_home_show_readmore', '.penci-archive__list_posts a.post-read-more, .penci-archive__list_posts.listing-2 a.post-read-more, .penci-archive__list_posts.listing-3 .penci-post-item-1 a.post-read-more' );

// Post
penci_amp_css_hidden_attr( 'penci_amp_posts_show_pcat', '.penci-amp-tax-category' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_pauthor', '.penci-amp-entry-meta .penci-amp-author' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_pdate', '.penci-amp-entry-meta .penci-posted-on' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_pcomment', '.penci-amp-entry-meta .penci-comment-count' );
penci_amp_css_inlineblock_attr( 'penci_amp_posts_show_pview', '.penci-amp-entry-meta .penci-amp-pviews' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_thumb', '.amp-wp-article-featured-image' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_ptag', '.penci-amp-tags-links' );
penci_amp_css_hidden_attr( 'penci_amp_home_show_pagination', '.penci-amp-pagination' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_show_pag', '.penci-post-pagination' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_related', '.penci-post-related' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_pmeta', '.penci-amp-entry-meta' );
penci_amp_css_hidden_attr( 'penci_amp_posts_show_share', '.penci-social-share-footer, .penci-amp-single .penci-social-buttons' );

// Sidebar
penci_amp_css_hidden_attr( 'penci_amp_sidebar_show_socail', '.sidebar-nav-social' );
penci_amp_css_hidden_attr( 'penci_amp_sidebar_show_logo', '#sidebar-nav-logo' );

// Footer
penci_amp_css_hidden_attr( 'penci_amp_no_version_link', '.penci-amp-main-link' );
penci_amp_css_hidden_attr( 'penci_amp_gototop', '.back-to-top' );
?>

<?php
// Custom css
echo penci_amp_get_setting( 'penci_amp_customcss' );
?>
