<?php

class Penci_Player_Rankings_Manager {
	public function __construct() {
		add_action( 'init', array( $this, 'init' ) );
		add_action( 'template_include', array( $this, 'template' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'style' ) );
		add_action( 'elementor/widgets/register', [ $this, 'register_widget' ] );
		add_action( 'pre_get_posts', array( $this, 'penci_order_team_by_ranking' ) );
		add_action( 'soledad_theme/custom_css', array( $this, 'css' ) );
	}

	public function penci_order_team_by_ranking( $query ) {
		if (
			! is_admin() &&
			$query->is_main_query() &&
			is_tax( 'team' )
		) {
			$query->set( 'meta_key', 'pencibm_ranking' );
			$query->set( 'orderby', 'meta_value_num' );
			$query->set( 'order', 'DESC' );
		}
	}

	public function style() {
		wp_enqueue_style( 'penci-player-rankings', plugin_dir_url( __DIR__ ) . 'assets/style.css', array(), PENCI_PLAYER_RANKINGS_VERSION );
		wp_register_script( 'mixitup', plugin_dir_url( __DIR__ ) . 'assets/mixitup.min.js', array( 'jquery' ), PENCI_PLAYER_RANKINGS_VERSION, true );
		wp_enqueue_script( 'penci-player-rankings', plugin_dir_url( __DIR__ ) . 'assets/scripts.js', array( 'mixitup' ), PENCI_PLAYER_RANKINGS_VERSION, true );
	}

	public function init() {

		$player_slug      = get_theme_mod( 'penci_player_rankings_player_slug', 'player' );
		$player_team_slug = get_theme_mod( 'penci_player_rankings_player_team_slug', 'team' );

		$labels = array(
			'name'                  => _x( 'Player', 'Post type general name', 'penci-player-rankings' ),
			'singular_name'         => _x( 'Player', 'Post type singular name', 'penci-player-rankings' ),
			'menu_name'             => _x( 'Players', 'Admin Menu text', 'penci-player-rankings' ),
			'name_admin_bar'        => _x( 'Player', 'Add New on Toolbar', 'penci-player-rankings' ),
			'add_new'               => __( 'Add New', 'penci-player-rankings' ),
			'add_new_item'          => __( 'Add New Player', 'penci-player-rankings' ),
			'new_item'              => __( 'New Player', 'penci-player-rankings' ),
			'edit_item'             => __( 'Edit Player', 'penci-player-rankings' ),
			'view_item'             => __( 'View Player', 'penci-player-rankings' ),
			'all_items'             => __( 'All Player', 'penci-player-rankings' ),
			'search_items'          => __( 'Search Players', 'penci-player-rankings' ),
			'parent_item_colon'     => __( 'Parent Player:', 'penci-player-rankings' ),
			'not_found'             => __( 'No player found.', 'penci-player-rankings' ),
			'not_found_in_trash'    => __( 'No players found in Trash.', 'penci-player-rankings' ),
			'featured_image'        => _x( 'Player Avatar', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'penci-player-rankings' ),
			'archives'              => _x( 'Player archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', 'penci-player-rankings' ),
			'insert_into_item'      => _x( 'Insert into player', 'Overrides the “Insert into post”/”Insert into page” phrase (used when inserting media into a post). Added in 4.4', 'penci-player-rankings' ),
			'uploaded_to_this_item' => _x( 'Uploaded to this player', 'Overrides the “Uploaded to this post”/”Uploaded to this page” phrase (used when viewing media attached to a post). Added in 4.4', 'penci-player-rankings' ),
			'filter_items_list'     => _x( 'Filter players list', 'Screen reader text for the filter links heading on the post type listing screen. Default “Filter posts list”/”Filter pages list”. Added in 4.4', 'penci-player-rankings' ),
			'items_list_navigation' => _x( 'Players list navigation', 'Screen reader text for the pagination heading on the post type listing screen. Default “Posts list navigation”/”Pages list navigation”. Added in 4.4', 'penci-player-rankings' ),
			'items_list'            => _x( 'Players list', 'Screen reader text for the items list heading on the post type listing screen. Default “Posts list”/”Pages list”. Added in 4.4', 'penci-player-rankings' ),
		);

		register_post_type( 'player', array(
			'labels'      => $labels,
			'public'      => true,
			'has_archive' => true,
			'menu_icon'   => 'dashicons-groups',
			'rewrite'     => array( 'slug' => $player_slug ),
			'supports'    => array( 'title', 'editor', 'thumbnail' )
		) );

		register_taxonomy( 'player_team', 'player', array(
			'labels'       => array(
				'name'          => __( 'Teams' ),
				'singular_name' => __( 'Team' )
			),
			'hierarchical' => true,
			'rewrite'      => array( 'slug' => $player_team_slug ),
		) );
	}

	public function template( $template ) {
		if ( is_singular( 'player' ) ) {
			$template = PENCI_PLAYER_RANKINGS_DIR . 'templates/single-player.php';
		}

		if ( is_post_type_archive( 'player' ) ) {
			$template = PENCI_PLAYER_RANKINGS_DIR . 'templates/archive-player.php';
		}

		if ( is_tax( 'player_team' ) ) {
			$template = PENCI_PLAYER_RANKINGS_DIR . 'templates/archive-player.php';
		}

		return $template;
	}

	public function register_widget( $widgets_manager ) {

		require_once( PENCI_PLAYER_RANKINGS_DIR . 'builder/player_lists.php' );

		$widgets_manager->register( new PenciPlayerRankingsPlayers() );
	}

	public function css() {

		$css = '';

		$desk_col   = get_theme_mod( 'penci_player_rankings_acol', '4' );
		$mobile_col = get_theme_mod( 'penci_player_rankings_amcol', '2' );

		if ( $desk_col ) {
			$css .= '.penci-prankings-box-wrapper.penci-billard-style-2{--col:' . $desk_col . '}';
			$css .= '@media only screen and (max-width: 767px){.penci-prankings-box-wrapper.penci-billard-style-2{--col:' . $mobile_col . '}}';
		}

		$custom_colors = [
			'penci_player_general_bgcolor'   => '.penci-prankings-item.card-player .player-image .player-image-content{background-color: {{VALUE}};}',
			'penci_player_general_bdcolor'   => '.penci-prankings-item.card-player .player-image .rank-band{background-color: {{VALUE}};}',
			'penci_player_general_rankcolor' => '.penci-prankings-item.card-player .player-image .rank{color: {{VALUE}};}',
			'penci_player_general_namecolor' => '.penci-prankings-item.card-player .player-bio .title{color: {{VALUE}};}',
			'penci_player_s_bdt_color'       => '.hub-player .player-namecard{border-color: {{VALUE}};}',
			'penci_player_s_name_color'      => '.hub-player .player-namecard .title{color: {{VALUE}};}',
			'penci_player_s_rank_color'      => '.hub-player .player-namecard .rank{color: {{VALUE}};}',
			'penci_player_s_rank_color'      => '.hub-player .player-namecard .rank{color: {{VALUE}};}',
			'penci_player_s_stats_bgcolor'   => '.hub-player .player-stats{background: {{VALUE}};}',
			'penci_player_s_stats_bdcolor'   => '.hub-player .grid-stack .player-stats-data{--pcborder-cl: {{VALUE}};}',
			'penci_player_s_stat_lbcolor'    => '.hub-player .player-stats .stat-label{color: {{VALUE}};}',
			'penci_player_s_stat_vlcolor'    => '.hub-player .player-stats .stat-value{color: {{VALUE}};}',
		];

		foreach ( $custom_colors as $option_id => $css_rule ) {
			$color = get_theme_mod( $option_id, '' );
			if ( $color ) {
				$css .= str_replace( '{{VALUE}}', $color, $css_rule );
			}
		}

		echo $css;
	}
}

new Penci_Player_Rankings_Manager();