<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use PenciSoledadElementor\Base\Base_Widget;

class PenciPlayerRankingsPlayers extends Base_Widget {

	public function get_title() {
		return penci_get_theme_name( 'Penci' ) . ' ' . esc_html__( 'Players Rankings', 'penci-player-rankings' );
	}

	public function get_icon() {
		return 'eicon-table';
	}

	public function get_categories() {
		return [ 'penci-elements' ];
	}

	public function get_keywords() {
		return [ 'player', 'players', 'ranking' ];
	}

	public function get_name() {
		return 'penci-players-rankings';
	}

	public function get_script_depends() {
		return [ 'penci-player-rankings' ];
	}

	protected function register_controls() {

		$this->start_controls_section( 'query_section', [
			'label' => esc_html__( 'Query Settings', 'penci-player-rankings' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		] );

		$this->add_control(
			'number',
			array(
				'label'   => __( 'Number Players', 'penci-player-rankings' ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
			)
		);

		$this->add_control(
			'offset',
			array(
				'label' => __( 'Offset', 'penci-player-rankings' ),
				'type'  => \Elementor\Controls_Manager::NUMBER,
			)
		);

		$this->add_control(
			'include',
			array(
				'label'       => __( 'Include Players', 'penci-player-rankings' ),
				'label_block' => true,
				'type'        => 'penci_el_autocomplete',
				'search'      => 'penci_get_posts_by_query',
				'render'      => 'penci_get_posts_title_by_id',
				'post_type'   => 'player',
				'multiple'    => true,
			)
		);

		$this->add_control(
			'exclude',
			array(
				'label'       => __( 'Exclude Players', 'penci-player-rankings' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'label_block' => true,
				'type'        => 'penci_el_autocomplete',
				'search'      => 'penci_get_posts_by_query',
				'render'      => 'penci_get_posts_title_by_id',
				'post_type'   => 'player',
				'multiple'    => true,
			)
		);
		
		$this->add_control(
			'team',
			array(
				'label'       => __( 'Team', 'penci-player-rankings' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'label_block' => true,
				'type'        => 'penci_el_autocomplete',
				'search'      => 'penci_get_taxonomies_by_query',
				'render'      => 'penci_get_taxonomies_title_by_id',
				'taxonomy'    => ['player_team'],
				'multiple'    => true,
			)
		);

		$this->add_control(
			'order',
			array(
				'label'       => __( 'Order', 'penci-player-rankings' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'desc',
				'label_block' => true,
				'options'     => [
					'asc'  => __( 'ASC', 'penci-player-rankings' ),
					'desc' => __( 'DESC', 'penci-player-rankings' ),
				],
			)
		);

		$this->add_control(
			'order_by',
			array(
				'label'       => __( 'Order by', 'penci-player-rankings' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'date',
				'label_block' => true,
				'options'     => [
					'date'     => __( 'Date', 'soledad' ),
					'ID'       => __( 'ID', 'soledad' ),
					'modified' => __( 'Modified Date', 'soledad' ),
					'title'    => __( 'Title', 'soledad' ),
					'rand'     => __( 'Random', 'soledad' ),
					'prize'    => __( 'Prize', 'soledad' ),
					'ranking'  => __( 'Custom Ranking', 'soledad' ),
				],
			)
		);

		$this->end_controls_section();


		$this->start_controls_section( 'layout_section', [
			'label' => esc_html__( 'Layout', 'penci-player-rankings' ),
			'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
		] );

		$this->add_control(
			'layout',
			array(
				'label'       => __( 'Style', 'penci-player-rankings' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'style-1',
				'label_block' => true,
				'options'     => [
					'style-1' => __( 'Style 1', 'penci-player-rankings' ),
					'style-2' => __( 'Style 2', 'penci-player-rankings' ),
					'style-3' => __( 'Style 3', 'penci-player-rankings' ),
				],
			)
		);

		$this->add_responsive_control(
			'col',
			array(
				'label'           => __( 'Columns', 'penci-player-rankings' ),
				'type'            => \Elementor\Controls_Manager::SELECT,
				'options'         => [
					1 => __( '1 Column', 'penci-player-rankings' ),
					2 => __( '2 Columns', 'penci-player-rankings' ),
					3 => __( '3 Columns', 'penci-player-rankings' ),
					4 => __( '4 Columns', 'penci-player-rankings' ),
					5 => __( '5 Columns', 'penci-player-rankings' ),
					6 => __( '6 Columns', 'penci-player-rankings' ),
				],
				'desktop_default' => 4,
				'mobile_default'  => 2,
				'label_block'     => true,
				'condition'       => [
					'layout' => ['style-1','style-2'],
				],
				'selectors'       => array(
					'{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"]' => '--col: {{VALUE}};',
					'{{WRAPPER}} .penci-prankings-box-wrapper.penci-billard-style-2' => '--col: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'layout_gap',
			array(
				'label' => __( 'Row/Columns Gap', 'penci-player-rankings' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'range'     => array( 'px' => array( 'min' => 0, 'max' => 100, ) ),
				'condition' => [
					'layout' => ['style-1','style-2'],
				],
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"]' => '--gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .penci-prankings-box-wrapper.penci-billard-style-2' => '--gap: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'col_layout2',
			array(
				'label'           => __( 'Small Columns', 'penci-player-rankings' ),
				'type'            => \Elementor\Controls_Manager::SELECT,
				'options'         => [
					1 => __( '1 Column', 'penci-player-rankings' ),
					2 => __( '2 Columns', 'penci-player-rankings' ),
					3 => __( '3 Columns', 'penci-player-rankings' ),
					4 => __( '4 Columns', 'penci-player-rankings' ),
					5 => __( '5 Columns', 'penci-player-rankings' ),
					6 => __( '6 Columns', 'penci-player-rankings' ),
				],
				'desktop_default' => 3,
				'mobile_default'  => 2,
				'label_block'     => true,
				'condition'       => [
					'layout' => 'style-3',
				],
				'selectors'       => array(
					'{{WRAPPER}} .penci-prankings-t3 > .penci-prankings-box-wrapper' => '--col: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'show_search',
			array(
				'label' => __( 'Show Search Field', 'penci-player-rankings' ),
				'type'  => \Elementor\Controls_Manager::SWITCHER,
				'condition' => [
					'layout' => ['style-1','style-2'],
				],
			)
		);

		$this->add_control(
			'show_country_filter',
			array(
				'label' => __( 'Show Country Filter', 'penci-player-rankings' ),
				'type'  => \Elementor\Controls_Manager::SWITCHER,
				'condition' => [
					'layout' => ['style-1','style-2'],
				],
			)
		);

		$this->end_controls_section();

		$this->register_block_title_section_controls();

		$this->start_controls_section( 'style_section_03', [
			'label' => esc_html__( 'General Style', 'penci-player-rankings' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		] );

		$this->add_control(
			'item_bgcolor',
			array(
				'label'     => __( 'Background Color', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player' => 'background: {{VALUE}};',
					'{{WRAPPER}} .penci-prankings-item.card-player .player-image .player-image-content'            => 'background: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'item_bordercolor',
			array(
				'label'     => __( 'Border Color', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player' => '--pcborder-cl: {{VALUE}};',
					'{{WRAPPER}} .penci-prankings-item.card-player'                                                => '--pcborder-cl: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'ranking_heading',
			array(
				'label' => __( 'Ranking', 'penci-player-rankings' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			)
		);

		$this->add_control(
			'ranking_color',
			array(
				'label'     => __( 'Ranking Color', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player .rank' => 'color: {{VALUE}};',
					'{{WRAPPER}} .penci-prankings-item.card-player .player-image .rank'                                  => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'ranking_typo',
			'label'    => __( 'Ranking Typography', 'penci-player-rankings' ),
			'selector' => '{{WRAPPER}} .penci-prankings-item.card-player .player-image .rank, {{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player .rank'
		) );

		$this->add_control(
			'fname_heading',
			array(
				'label' => __( 'First Name', 'penci-player-rankings' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			)
		);

		$this->add_control(
			'fname_color',
			array(
				'label'     => __( 'First Name Color', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-item.card-player .player-bio .title .first, {{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player .penci-prankings-item-content-detail .title .first' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'fname_typo',
			'label'    => __( 'First Name Typography', 'penci-player-rankings' ),
			'selector' => '{{WRAPPER}} .penci-prankings-item.card-player .player-bio .title .first, {{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player .penci-prankings-item-content-detail .title .first'
		) );

		$this->add_control(
			'lname_heading',
			array(
				'label' => __( 'Last Name', 'penci-player-rankings' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			)
		);

		$this->add_control(
			'lname_color',
			array(
				'label'     => __( 'Last Name Color', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-item.card-player .player-bio .title .last, {{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player .penci-prankings-item-content-detail .title .last' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'lname_typo',
			'label'    => __( 'Last Name Typography', 'penci-player-rankings' ),
			'selector' => '{{WRAPPER}} .penci-prankings-item.card-player .player-bio .title .last, {{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player .penci-prankings-item-content-detail .title .last'
		) );

		$this->add_control(
			'country_heading',
			array(
				'label' => __( 'Country', 'penci-player-rankings' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			)
		);

		$this->add_control(
			'country_color',
			array(
				'label'     => __( 'Country Color', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player .penci-prankings-item-content-detail .country' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'country_typo',
			'label'    => __( 'Country Typography', 'penci-player-rankings' ),
			'selector' => '{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player .penci-prankings-item-content-detail .country'
		) );

		$this->add_responsive_control(
			'item_border_radius',
			array(
				'label'     => __( 'Border Radius', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'item_padding',
			array(
				'label'     => __( 'Item Padding', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'item_border_w',
			array(
				'label'     => __( 'Border Width', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .penci-prankings-cabinet .display[data-type="players"] .penci-prankings-item.card-player' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'filter_control',
			array(
				'label' => __( 'Filter Control', 'penci-player-rankings' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			)
		);

		$this->add_responsive_control(
			'filter_control_bw',
			array(
				'label'     => __( 'Border Width', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .display-filters .filter-container' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
		
		$this->add_responsive_control(
			'filter_control_pd',
			array(
				'label'     => __( 'Padding', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .display-filters .filter-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'filter_control_brds',
			array(
				'label'     => __( 'Border Radius', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => array(
					'{{WRAPPER}} .display-filters .filter-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'filter_control_bdc',
			array(
				'label'     => __( 'Border Color', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .display-filters .filter-container' => '--pcborder-cl: {{VALUE}};',
				),
			)
		);

		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'filter_control_label_typo',
			'label'    => __( 'Label Typography', 'penci-player-rankings' ),
			'selector' => '{{WRAPPER}} .display-filters .filter-container label'
		) );

		$this->add_control(
			'filter_control_label_cl',
			array(
				'label'     => __( 'Label Color', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .display-filters .filter-container label' => 'color: {{VALUE}};',
				),
			)
		);
		
		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'filter_control_input_typo',
			'label'    => __( 'Input Typography', 'penci-player-rankings' ),
			'selector' => '{{WRAPPER}} .display-filters .filter-container input,{{WRAPPER}} .display-filters .filter-container select'
		) );

		$this->add_control(
			'filter_control_input_color',
			array(
				'label'     => __( 'Input Color', 'penci-player-rankings' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .display-filters .filter-container input,{{WRAPPER}} .display-filters .filter-container select' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->register_block_title_style_section_controls();

	}

	protected function render() {
		$settings = $this->get_settings();

		$args = array(
			'post_type'      => 'player',
			'posts_per_page' => $settings['number'],
			'orderby'        => $settings['order_by'],
			'order'          => $settings['order'],
		);

		if ( $settings['order_by'] == 'prize' ) {
			$args['meta_key'] = 'match_prize';
			$args['orderby']  = 'meta_value_num';
		}

		if ( $settings['order_by'] == 'ranking' ) {
			$args['meta_key'] = 'pencibm_ranking';
			$args['orderby']  = 'meta_value_num';
		}

		if ( $settings['offset'] ) {
			$args['offset'] = $settings['offset'];
		}

		if ( $settings['team'] ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'player_team',
					'field'    => 'id',
					'terms'    => $settings['team'],
				),
			);
		}

		if ( ! empty( $settings['include'] ) ) {
			$args['post__in'] = $settings['include'];
		}

		if ( ! empty( $settings['exclude'] ) ) {
			$args['post__not_in'] = $settings['exclude'];
		}

		$query = new WP_Query( $args );
		$rank  = 1;

		$this->markup_block_title( $settings, $this );

		if ( $query->have_posts() ):

			echo '<div class="penci-bl-user-list penci-bl-user-filter">';

			if ( $settings['show_search'] || $settings['show_country_filter'] ) { ?>

				<div class="display-filters">
					<form>
						<?php if ( $settings['show_search'] ) : ?>
							<div class="filter-container">
								<label for="name" class="filter-label">Name</label>
								<input type="text" id="name" name="name" title="name" class="search_name" placeholder="Search by name">
							</div>
							
						<?php endif; ?>
						<?php if ( $settings['show_country_filter'] ) : ?>
							<div class="filter-container">
								<label for="country" class="filter-label">Country</label>
								<select id="country" name="country" title="country" class="filter" >
									<option value="">All</option>
									<?php
									$country_list = [];
									while ( $query->have_posts() ): $query->the_post();
										$country      = get_post_meta( get_the_ID(), 'pencibm_country', true );

										if ( in_array( $country, $country_list ) ) {
											continue;
										}
										
										$country_list[] = $country;
										
										$country_name = penci_player_rankings_country_list( $country );
										echo '<option value="' . strtolower( $country ) . '">' . esc_html( $country_name ) . '</option>';
									endwhile;
									wp_reset_postdata()
									?>
								</select>
							</div>
						<?php endif; ?>
					</form>
				</div>
			<?php }

			if ( $settings['layout'] == 'style-1' ) {
				?>
                <div class="penci-prankings-cabinet" data-type="cards">

                    <div id="penci-prankings-player-wrapper" class="penci-prankings-box-wrapper penci-prankings-player-wrapper display"
                         data-type="players">

						<?php while ( $query->have_posts() ): $query->the_post();
							$country      = get_post_meta( get_the_ID(), 'pencibm_country', true );
							$country_name = penci_player_rankings_country_list( $country );
							$fname = get_post_meta( get_the_ID(), 'pencibm_fname', true );
							$lname = get_post_meta( get_the_ID(), 'pencibm_lname', true );
							?>
                            <div class="penci-prankings-item card-player <?php echo strtolower( $country ); ?>"
                                 data-name="<?php echo strtolower( $fname . ','. $lname ); ?>"
                                 data-country="<?php echo strtolower( $country ); ?>">

                                <a href="<?php the_permalink(); ?>" class="penci-prankings-item-inner">

                                    <div class="penci-prankings-item-content">

                                        <div class="penci-prankings-item-content-detail">

                                            <div class="image">
												<?php
												if ( has_post_thumbnail() ) {
													echo get_the_post_thumbnail( get_the_ID(), 'penci-masonry-thumb' );
												} else {
													echo penci_player_rankings_df_ava();
												}
												?>
                                            </div>

                                            <div class="bio">
                                                <div class="title">
                                                    <span class="first"><?php echo $fname; ?></span>
                                                    <span class="last"><?php echo $lname; ?></span>
                                                </div>
                                                <div class="country"><?php echo $country_name; ?></div>
                                            </div>

                                        </div>

                                        <div class="rank"><span>#</span><?php echo $rank ++; ?></div>

                                    </div>

                                </a>

                            </div>
						<?php endwhile; ?>
                    </div>
                    <div class="no-results">
                        <div class="no-results-inner">There are no results for your current selection.</div>
                    </div>
                </div>

			<?php } else if ( $settings['layout'] == 'style-2' ) { ?>
				<div class="penci-prankings-box-wrapper penci-billard-style-2">
					<?php
					$player_count = 1;
					while ( $query->have_posts() ):
						$query->the_post();
						$country = get_post_meta( get_the_ID(), 'pencibm_country', true );
						$flag_img = 'https://flagcdn.com/w160/' . strtolower( $country ) . '.png';
						?>
						<div class="penci-prankings-item card-player"
                                 data-name="<?php echo strtolower( get_post_meta( get_the_ID(), 'pencibm_fname', true ) ); ?>"
                                 data-country="<?php echo strtolower( $country ); ?>">

                                <a href="<?php the_permalink(); ?>" class="penci-prankings-item-inner">

                                    <div class="player-image">
										<?php
										if ( has_post_thumbnail() ) {
											echo get_the_post_thumbnail( get_the_ID(), 'penci-masonry-thumb' );
										} else {
											echo penci_player_rankings_df_ava();										}
										?>
                                        <div class="player-image-content">
                                            <div class="flag"><img
                                                        src="<?php echo esc_url( $flag_img ); ?>"
                                                        alt="" class="img-flag"></div>
                                            <div class="rank"><span>#</span><?php echo $player_count; ?></div>
                                        </div>
                                        <div class="rank-band"></div>
                                    </div>

                                    <div class="player-bio">
                                        <div class="title">
                                            <span class="first"><?php echo get_post_meta( get_the_ID(), 'pencibm_fname', true ); ?></span>
                                            <span class="last"><?php echo get_post_meta( get_the_ID(), 'pencibm_lname', true ); ?></span>
                                        </div>
                                        <div class="icon-container"><span class="icon icon-linkarrow"></span></div>
                                    </div>

                                </a>

                            </div>
						<?php 
						$player_count ++;
					endwhile; ?>
				</div>
			<?php } else { ?>

                <!-- other layout -->
                <div class="penci-prankings-grid penci-prankings-t4">

					<?php
					$player_count = 1;
					while ( $query->have_posts() ):
						$query->the_post();
						$extra_class = 1 == $player_count ? ' first' : '';
						$show_close  = false;
						if ( $player_count == 2 ) {
							echo '<div class="penci-prankings-box-wrapper penci-prankings-t3 penci-prankings-wide">';
							$show_close = true;
						}
						$country  = get_post_meta( get_the_ID(), 'pencibm_country', true );
						$flag_img = 'https://flagcdn.com/w160/' . strtolower( $country ) . '.png';
						?>
                        <div class="penci-prankings-box-wrapper<?php echo esc_attr( $extra_class ); ?>">
                            <div class="penci-prankings-item card-player rank<?php echo $player_count; ?>"
                                 data-name="<?php echo strtolower( get_post_meta( get_the_ID(), 'pencibm_fname', true ) ); ?>"
                                 data-country="<?php echo strtolower( $country ); ?>">

                                <a href="<?php the_permalink(); ?>" class="penci-prankings-item-inner">

                                    <div class="player-image">
										<?php
										if ( has_post_thumbnail() ) {
											echo get_the_post_thumbnail( get_the_ID(), 'penci-masonry-thumb' );
										} else {
											echo penci_player_rankings_df_ava();										}
										?>
                                        <div class="player-image-content">
                                            <div class="flag"><img
                                                        src="<?php echo esc_url( $flag_img ); ?>"
                                                        alt="" class="img-flag"></div>
                                            <div class="rank"><span>#</span><?php echo $player_count; ?></div>
                                        </div>
                                        <div class="rank-band"></div>
                                    </div>

                                    <div class="player-bio">
                                        <div class="title">
                                            <span class="first"><?php echo get_post_meta( get_the_ID(), 'pencibm_fname', true ); ?></span>
                                            <span class="last"><?php echo get_post_meta( get_the_ID(), 'pencibm_lname', true ); ?></span>
                                        </div>
                                        <div class="icon-container"><span class="icon icon-linkarrow"></span></div>
                                    </div>

                                </a>

                            </div>
                        </div>
						<?php
						$player_count ++;
					endwhile;
					if ( $show_close ) {
						echo '</div>';
					}
					?>
                </div>
				<?php
			}
			echo '</div>';
		endif;
		wp_reset_postdata();
	}
}