(function ($) {
  "use strict";

  var PENCI_BLIA = PENCI_BLIA || {};

  // Player Filter
  PENCI_BLIA.UserFilter = function () {
    var filter_wrapper = $(".penci-bl-user-filter"),
      filter_container = filter_wrapper.find(".penci-prankings-box-wrapper")[0],
      filter_control = filter_wrapper.find(".filter"),
      searchInput = filter_wrapper.find(".search_name");

    if (!filter_container) return;

    var playerMixer = mixitup(filter_container, {
      selectors: {
        target: '.card-player'
      },
      controls: {
        scope: 'local'
      },
    });

    // Country dropdown
    filter_control.on('change', function () {
      var filter_val = $(this).val();
      if (filter_val) {
        playerMixer.filter('[data-country="' + filter_val + '"]');
      } else {
        playerMixer.filter('all');
      }
    });

    // Search filter
    searchInput.on('keyup', function () {
      var searchTerm = $(this).val().trim().toLowerCase();

      if (searchTerm) {
        var $matching = $();
        $('.card-player').each(function () {
          var itemName = $(this).data('name').toLowerCase();
          if (itemName.includes(searchTerm)) {
            $matching = $matching.add(this);
          }
        });
        playerMixer.filter($matching);
      } else {
        playerMixer.filter('all');
      }
    });
  };

  // Init
  $(document).ready(function () {
    PENCI_BLIA.UserFilter();
  });

  $(window).on('elementor/frontend/init', function () {
    if ( window.elementorFrontend && window.elementorFrontend.isEditMode() ) {

        elementorFrontend.hooks.addAction('frontend/element_ready/penci-players-rankings.default', function ($scope) {
          PENCI_BLIA.UserFilter();
        });
        
    }
  });

})(jQuery);