<?php
/*
Plugin Name: Penci Player Rankings
Plugin URI: http://pencidesign.net/
Description: This plugin helps you easily create ranking tables for players across different fields. It supports search, filtering based on various criteria, and displays detailed information for each player.
Version: 1.0
Author: PenciDesign
Author URI: http://themeforest.net/user/pencidesign?ref=pencidesign
*/

define( 'PENCI_PLAYER_RANKINGS_VERSION', '1.0' );
define( 'PENCI_PLAYER_RANKINGS_DIR', plugin_dir_path( __FILE__ ) );
define( 'PENCI_PLAYER_RANKINGS_URL', plugin_dir_url( __FILE__ ) );

add_action( 'plugin_loaded', function () {
	require_once( 'inc/init.php' );
	require_once( 'inc/metabox.php' );
	require_once( 'inc/helper.php' );
} );

add_action(
	'init',
	function () {
		if ( class_exists( 'SoledadFW\Customizer\CustomizerOptionAbstract' ) ) {
			require_once PENCI_PLAYER_RANKINGS_DIR . 'customizer/panel.php';
			require_once PENCI_PLAYER_RANKINGS_DIR . 'customizer/settings.php';
			\SoledadFW\PenciPlayerRankingsCustomizer::getInstance();
		}
	}
);