<?php
$group_color = 'Typo & Color';

vc_map( array(
	'base'          => 'penci_counter_up',
	'icon'          => PENCI_SOLEDAD_URL . '/images/vc-icon.png',
	'category'      => penci_get_theme_name( 'Soledad' ),
	'html_template' => PENCI_SOLEDAD_DIR . '/inc/js_composer/shortcodes/counter_up/frontend.php',
	'weight'        => 700,
	'name'          => penci_get_theme_name( 'Penci' ) . ' ' . esc_html__( 'Counter Up', 'soledad' ),
	'description'   => __( 'Counter Up Block', 'soledad' ),
	'controls'      => 'full',
	'params'        => array_merge(
		Penci_Vc_Params_Helper::params_container_width(),
		array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Counter Up style', 'soledad' ),
				'param_name' => 'cup_style',
				'std'        => 's1',
				'value'      => array(
					esc_html__( 'Style 1', 'soledad' ) => 's1',
					esc_html__( 'Style 2', 'soledad' ) => 's2',
				),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Posttion', 'soledad' ),
				'param_name' => 'cup_align',
				'value'      => array(
					__( 'Align Center', 'soledad' ) => 'center',
					__( 'Align Left', 'soledad' )   => 'left',
					__( 'Align Right', 'soledad' )  => 'right',
				),
				'std'        => 'center',
				'dependency' => array( 'element' => 'cup_style', 'value' => 's1' ),
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Number', 'soledad' ),
				'param_name' => 'cup_number'
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Prefix of number', 'soledad' ),
				'param_name' => 'cup_prefix_number'
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Suffix of number', 'soledad' ),
				'param_name' => 'cup_suffix_number',
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Title', 'soledad' ),
				'param_name'  => 'cup_title',
				'admin_label' => true
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon type', 'soledad' ),
				'param_name' => 'cup_icon_type',
				'value'      => array(
					esc_html__( 'Icon', 'soledad' )  => 'icon',
					esc_html__( 'Image', 'soledad' ) => 'image',
				),
			),
			array(
				'type'       => 'attach_image',
				'heading'    => esc_html__( 'Image', 'soledad' ),
				'param_name' => 'cup_image',
				'dependency' => array( 'element' => 'cup_icon_type', 'value' => 'image' ),
			),
			array(
				'type'       => 'textfield',
				'heading'    => __( 'Image size', 'soledad' ),
				'param_name' => 'img_size',
				'std'        => 'full',
				'dependency' => array( 'element' => 'cup_icon_type', 'value' => 'image' ),
			),
			array(
				'type'       => 'iconpicker',
				'heading'    => __( 'Icon', 'soledad' ),
				'param_name' => 'cup_icon',
				'value'      => '',
				'settings'   => array( 'emptyIcon' => true, 'iconsPerPage' => 4000 ),
				'dependency' => array( 'element' => 'cup_icon_type', 'value' => 'icon' )
			),
			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Icon Border Style', 'soledad' ),
				'param_name' => 'icon_border_style',
				'value'      => array(
					esc_html__( 'None', 'soledad' )   => '',
					esc_html__( 'Solid', 'soledad' )  => 'solid',
					esc_html__( 'Dashed', 'soledad' ) => 'dashed',
					esc_html__( 'Dotted', 'soledad' ) => 'dotted',
					esc_html__( 'Double', 'soledad' ) => 'double',
				),
				'dependency' => array( 'element' => 'cup_icon_type', 'value' => 'icon' ),
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'icon_border_width',
				'heading'          => __( 'Border width for Icon', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
				'dependency'       => array(
					'element' => 'icon_border_style',
					'value'   => array( 'solid', 'dashed', 'dotted', 'double' )
				),
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'icon_border_radius',
				'heading'          => __( 'Border radius for Icon', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
				'dependency'       => array(
					'element' => 'icon_border_style',
					'value'   => array( 'solid', 'dashed', 'dotted', 'double' )
				),
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'icon_padding',
				'heading'          => __( 'Padding for Icon', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
				'dependency'       => array( 'element' => 'icon_size', 'value' => 'custom' ),
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => '_image_width_height',
				'heading'          => __( 'Image with/height', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
				'dependency'       => array( 'element' => 'cup_icon_type', 'value' => 'image' ),
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'icon_margin_bottom',
				'heading'          => __( 'Custom margin bottom for Icon or Image', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'number_margin_top',
				'heading'          => __( 'Custom margin top for number', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'number_padding_lr',
				'heading'          => __( 'Custom padding left/right for number', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'title_margin_top',
				'heading'          => __( 'Custom margin top for title', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Delay', 'soledad' ),
				'param_name' => 'cup_delay',
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Time', 'soledad' ),
				'param_name' => 'cup_time',
			),
			// Heading
			array(
				'type'        => 'penci_switch',
				'heading'     => __( 'Show Heading Title', 'soledad' ),
				'param_name'  => 'show_block_heading',
				'true_state'  => 'yes',
				'false_state' => 'no',
				'default'     => 'no',
				'std'         => 'no',
				'group'       => 'Heading',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Title Style', 'soledad' ),
				'param_name' => 'heading_title_style',
				'std'        => '',
				'value'      => array(
					esc_html__( 'Default ( follow Customize )', 'soledad' ) => '',
					esc_html__( 'Style 1', 'soledad' )                      => 'style-1',
					esc_html__( 'Style 2', 'soledad' )                      => 'style-2',
					esc_html__( 'Style 3', 'soledad' )                      => 'style-3',
					esc_html__( 'Style 4', 'soledad' )                      => 'style-4',
					esc_html__( 'Style 5', 'soledad' )                      => 'style-5',
					esc_html__( 'Style 6', 'soledad' )                      => 'style-6',
					esc_html__( 'Style 7', 'soledad' )                      => 'style-7',
					esc_html__( 'Style 8', 'soledad' )                      => 'style-9',
					esc_html__( 'Style 9', 'soledad' )                      => 'style-8',
					esc_html__( 'Style 10', 'soledad' )                     => 'style-10',
					esc_html__( 'Style 11', 'soledad' )                     => 'style-11',
					esc_html__( 'Style 12', 'soledad' )                     => 'style-12',
					esc_html__( 'Style 13', 'soledad' )                     => 'style-13',
					esc_html__( 'Style 14', 'soledad' )                     => 'style-14',
					esc_html__( 'Style 15', 'soledad' )                     => 'style-15',
					esc_html__( 'Style 16', 'soledad' )                     => 'style-16',
					esc_html__( 'Style 17', 'soledad' )                     => 'style-2 style-17',
					esc_html__( 'Style 18', 'soledad' )                     => 'style-18',
					esc_html__( 'Style 19', 'soledad' )                     => 'style-18 style-19',
					esc_html__( 'Style 20', 'soledad' )                     => 'style-18 style-20',
					esc_html__( 'Style 21', 'soledad' )                     => 'style-21',
					esc_html__( 'Style 22', 'soledad' )                     => 'style-22',
					esc_html__( 'Style 23', 'soledad' )                     => 'style-23',
					esc_html__( 'Style 24', 'soledad' )                     => 'style-24',
					esc_html__( 'Style 25', 'soledad' )                     => 'style-25',
					esc_html__( 'Style 26', 'soledad' )                     => 'style-26',
					esc_html__( 'Style 27', 'soledad' )                     => 'style-27',
				),
				'group'      => 'Heading',
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Heading Title', 'soledad' ),
				'param_name'  => 'heading',
				'value'       => esc_html__( 'Heading Title', 'soledad' ),
				'std'         => esc_html__( 'Heading Title', 'soledad' ),
				'admin_label' => true,
				'description' => esc_html__( 'A title for this block, if you leave it blank the block will not have a title', 'soledad' ),
				'group'       => 'Heading',
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Title Url', 'soledad' ),
				'param_name'  => 'heading_title_link',
				'std'         => '',
				'description' => esc_html__( 'A custom url when the block title is clicked', 'soledad' ),
				'group'       => 'Heading',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Align', 'soledad' ),
				'param_name' => 'heading_title_align',
				'std'        => '',
				'value'      => array(
					esc_html__( 'Default ( follow Customize )', 'soledad' ) => '',
					esc_html__( 'Left', 'soledad' )                         => 'pcalign-left',
					esc_html__( 'Center', 'soledad' )                       => 'pcalign-center',
					esc_html__( 'Right', 'soledad' )                        => 'pcalign-right',
				),
				'group'      => 'Heading',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => 'Align Icon on Style 15',
				'value'       => array(
					'Default( follow Customize )' => '',
					'Right'                       => 'pciconp-right',
					'Left'                        => 'pciconp-left',
				),
				'param_name'  => 'heading_icon_pos',
				'description' => '',
				'dependency'  => array( 'element' => 'heading_title_style', 'value' => array( 'style-15' ) ),
				'group'       => 'Heading',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => 'Custom Icon on Style 15',
				'value'       => array(
					'Default( follow Customize )' => '',
					'Arrow Right'                 => 'pcicon-right',
					'Arrow Left'                  => 'pcicon-left',
					'Arrow Down'                  => 'pcicon-down',
					'Arrow Up'                    => 'pcicon-up',
					'Star'                        => 'pcicon-star',
					'Bars'                        => 'pcicon-bars',
					'File'                        => 'pcicon-file',
					'Fire'                        => 'pcicon-fire',
					'Book'                        => 'pcicon-book',
				),
				'param_name'  => 'heading_icon',
				'description' => '',
				'dependency'  => array( 'element' => 'heading_title_style', 'value' => array( 'style-15' ) ),
				'group'       => 'Heading',
			),
		),
		Penci_Vc_Params_Helper::params_heading_typo_color(),
		// Color
		array(
			array(
				'type'             => 'textfield',
				'param_name'       => 'cup_icon_heading',
				'heading'          => esc_html__( 'Icon', 'soledad' ),
				'value'            => '',
				'group'            => $group_color,
				'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Icon color', 'soledad' ),
				'param_name'       => 'cup_icon_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Icon background color', 'soledad' ),
				'param_name'       => 'cup_icon_bgcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'cup_icon_size',
				'heading'          => __( 'Font size for Icon', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'             => 'textfield',
				'param_name'       => 'cup_number_heading',
				'heading'          => esc_html__( 'Number', 'soledad' ),
				'value'            => '',
				'group'            => $group_color,
				'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Number Color', 'soledad' ),
				'param_name'       => 'cup_number_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'google_fonts',
				'group'      => $group_color,
				'param_name' => 'cup_number_typo',
				'value'      => '',
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'cup_number_size',
				'heading'          => __( 'Font Size for Number', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Font Weight for Number', 'soledad' ),
				'param_name' => 'cup_number_weight',
				'std'        => 's1',
				'value'      => array(
					__( 'Default', 'soledad' ) => '',
					'Normal'                   => 'normal',
					'Bold'                     => 'bold',
					'Bolder'                   => 'bolder',
					'Lighter'                  => 'lighter',
					'100'                      => '100',
					'200'                      => '200',
					'300'                      => '300',
					'400'                      => '400',
					'500'                      => '500',
					'600'                      => '600',
					'700'                      => '700',
					'800'                      => '800',
					'900'                      => '900'
				),
				'group'      => $group_color,
			),
			array(
				'type'             => 'textfield',
				'param_name'       => 'cup_prefix_suffix_heading',
				'heading'          => esc_html__( 'Prefix and Suffix', 'soledad' ),
				'value'            => '',
				'group'            => $group_color,
				'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Prefix and Suffix Color', 'soledad' ),
				'param_name'       => 'cup_frefix_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'google_fonts',
				'group'      => $group_color,
				'param_name' => 'cup_frefix_typo',
				'value'      => '',
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'heading'          => esc_html__( 'Font size for Prefix and Suffix', 'soledad' ),
				'param_name'       => 'cup_frefix_size',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'textfield',
				'param_name'       => 'cup_title_heading',
				'heading'          => esc_html__( 'Title', 'soledad' ),
				'value'            => '',
				'group'            => $group_color,
				'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Title color', 'soledad' ),
				'param_name'       => 'cup_title_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'google_fonts',
				'group'      => $group_color,
				'param_name' => 'cup_title_typo',
				'value'      => '',
			),
			array(
				'type'             => 'penci_responsive_sizes',
				'param_name'       => 'cup_title_size',
				'heading'          => __( 'Font size for Title', 'soledad' ),
				'suffix'           => 'px',
				'min'              => 1,
				'edit_field_class' => 'vc_col-sm-6',
				'group'            => $group_color,
			),
			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Font Weight for Number', 'soledad' ),
				'param_name' => 'cup_title_weight',
				'std'        => 's1',
				'value'      => array(
					__( 'Default', 'soledad' ) => '',
					'Normal'                   => 'normal',
					'Bold'                     => 'bold',
					'Bolder'                   => 'bolder',
					'Lighter'                  => 'lighter',
					'100'                      => '100',
					'200'                      => '200',
					'300'                      => '300',
					'400'                      => '400',
					'500'                      => '500',
					'600'                      => '600',
					'700'                      => '700',
					'800'                      => '800',
					'900'                      => '900'
				),
				'group'      => $group_color,
			),
		),
		Penci_Vc_Params_Helper::extra_params()
	)
) );
