<?php
/**
 * The template to display the reviewers meta data (name, verified owner, review date)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review-meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

global $comment;
$verified = wc_review_is_from_verified_owner( $comment->comment_ID );

if ( '0' === $comment->comment_approved ) { ?>

	<p class="meta">
		<em class="woocommerce-review__awaiting-approval">
			<?php esc_attr_e( 'Your review is awaiting approval', 'smilepure' ); ?>
		</em>
	</p>

<?php } else { ?>

	<div class="meta">
		<h6 class="woocommerce-review__author"><?php comment_author(); ?></h6>
		<?php
		if ( 'yes' === get_option( 'woocommerce_review_rating_verification_label' ) && $verified ) {
			echo '<em class="woocommerce-review__verified verified">(' . esc_attr__( 'verified owner', 'smilepure' ) . ')</em> ';
		}
		?>
		<time class="woocommerce-review__published-date"
		      datetime="<?php echo get_comment_date( 'c' ); ?>">
			<?php
			printf( '%s %s %s', get_comment_date(), esc_html__( 'at', 'smilepure' ), get_comment_time() );
			?>
		</time>
	</div>

<?php }
