<?php
$styling_tab   = esc_html__( 'Styling', 'smilepure' );
$separator_tab = esc_html__( 'Separator', 'smilepure' );

vc_remove_param( 'vc_row', 'css' );
vc_remove_param( 'vc_row', 'gap' );
vc_remove_param( 'vc_row', 'parallax' );
vc_remove_param( 'vc_row', 'parallax_image' );
vc_remove_param( 'vc_row', 'parallax_speed_bg' );

vc_add_params( 'vc_row', array_merge( Smilepure_VC::get_vc_spacing_tab(), array(
	array(
		'heading'     => esc_html__( 'Layer Index', 'smilepure' ),
		'description' => esc_html__( 'When content in row or row has negative margin then this controls layer ( z-index ) of row', 'smilepure' ),
		'type'        => 'number',
		'param_name'  => 'layer_index',
		'min'         => 0,
		'max'         => 100,
		'step'        => 1,
	),
	array(
		'heading'     => esc_html__( 'Gutter', 'smilepure' ),
		'type'        => 'number_responsive',
		'param_name'  => 'gutter',
		'min'         => 0,
		'max'         => 100,
		'step'        => 2,
		'suffix'      => 'px',
		'media_query' => array(
			'lg' => '',
			'md' => '',
			'sm' => '',
			'xs' => '',
		),
	),
	array(
		'heading'    => esc_html__( 'Column Separator', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'column_separator',
		'value'      => array(
			esc_html__( 'None', 'smilepure' )     => '',
			esc_html__( 'Style 01', 'smilepure' ) => '01',
			esc_html__( 'Style 02', 'smilepure' ) => '02',
			esc_html__( 'Style 03', 'smilepure' ) => '03',
			esc_html__( 'Style 04', 'smilepure' ) => '04',

		),
		'std'        => '',
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Border Radius', 'smilepure' ),
		'description' => esc_html__( 'E.g 5px or 50%', 'smilepure' ),
		'type'        => 'textfield',
		'param_name'  => 'border_radius',
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Box Shadow', 'smilepure' ),
		'description' => esc_html__( 'E.g 0 20px 30px #ccc', 'smilepure' ),
		'type'        => 'textfield',
		'param_name'  => 'box_shadow',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Row Effect', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'effect',
		'value'      => array(
			esc_html__( 'None', 'smilepure' )    => '',
			esc_html__( 'Firefly', 'smilepure' ) => 'firefly',
			esc_html__( 'Wavify', 'smilepure' )  => 'wavify',
		),
		'std'        => '',
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Wavify Height', 'smilepure' ),
		'type'        => 'number_responsive',
		'param_name'  => 'wavify_height',
		'step'        => 1,
		'suffix'      => 'px',
		'media_query' => array(
			'lg' => 400,
			'md' => '',
			'sm' => '',
			'xs' => '',
		),
		'dependency'  => array(
			'element' => 'effect',
			'value'   => array( 'wavify' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Wavify Items', 'smilepure' ),
		'type'       => 'param_group',
		'param_name' => 'wavify_items',
		'params'     => array_merge( array(
			array(
				'heading'     => esc_html__( 'Height', 'smilepure' ),
				'type'        => 'textfield',
				'param_name'  => 'height',
				'admin_label' => true,
				'value'       => 400,
				'min'         => 0,
				'max'         => 1000,
				'step'        => 10,
				'std'         => 400,
				'suffix'      => 'px',
			),
			array(
				'heading'    => esc_html__( 'Amplitude', 'smilepure' ),
				'type'       => 'number',
				'param_name' => 'amplitude',
				'value'      => 200,
				'min'        => 0,
				'max'        => 1000,
				'step'       => 10,
				'std'        => 200,
				'suffix'     => 'px',
			),
			array(
				'heading'    => esc_html__( 'Bones', 'smilepure' ),
				'type'       => 'number',
				'param_name' => 'bones',
				'value'      => 4,
				'min'        => 0,
				'max'        => 10,
				'step'       => 1,
				'std'        => 4,
			),
			array(
				'heading'    => esc_html__( 'Background', 'smilepure' ),
				'type'       => 'colorpicker',
				'param_name' => 'background',
			),
		) ),
		'dependency' => array(
			'element' => 'effect',
			'value'   => array( 'wavify' ),
		),
	),
	array(
		'group'            => $styling_tab,
		'heading'          => esc_html__( 'Firefly Color', 'smilepure' ),
		'type'             => 'colorpicker',
		'param_name'       => 'firefly_color',
		'dependency'       => array(
			'element' => 'effect',
			'value'   => array( 'firefly' ),
		),
		'std'              => '#fff',
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'group'            => $styling_tab,
		'heading'          => esc_html__( 'Firely Total', 'smilepure' ),
		'type'             => 'number',
		'param_name'       => 'firefly_total',
		'value'            => 100,
		'min'              => 0,
		'max'              => 100,
		'step'             => 1,
		'suffix'           => '%',
		'std'              => 30,
		'dependency'       => array(
			'element' => 'effect',
			'value'   => array( 'firefly' ),
		),
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'group'            => $styling_tab,
		'heading'          => esc_html__( 'Firely Min Width', 'smilepure' ),
		'type'             => 'number',
		'param_name'       => 'firefly_min_size',
		'value'            => 100,
		'min'              => 0,
		'max'              => 100,
		'step'             => 1,
		'suffix'           => '%',
		'std'              => 1,
		'dependency'       => array(
			'element' => 'effect',
			'value'   => array( 'firefly' ),
		),
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'group'            => $styling_tab,
		'heading'          => esc_html__( 'Firely Max Width', 'smilepure' ),
		'type'             => 'number',
		'param_name'       => 'firefly_max_size',
		'value'            => 100,
		'min'              => 0,
		'max'              => 100,
		'step'             => 1,
		'suffix'           => '%',
		'std'              => 3,
		'dependency'       => array(
			'element' => 'effect',
			'value'   => array( 'firefly' ),
		),
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Color', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'background_color',
		'value'      => array(
			esc_html__( 'None', 'smilepure' )            => '',
			esc_html__( 'Primary Color', 'smilepure' )   => 'primary',
			esc_html__( 'Secondary Color', 'smilepure' ) => 'secondary',
			esc_html__( 'Custom Color', 'smilepure' )    => 'custom',
			esc_html__( 'Gradient Color', 'smilepure' )  => 'gradient',
		),
		'std'        => '',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Custom Background Color', 'smilepure' ),
		'type'       => 'colorpicker',
		'param_name' => 'custom_background_color',
		'dependency' => array(
			'element' => 'background_color',
			'value'   => array( 'custom' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Gradient', 'smilepure' ),
		'type'       => 'gradient',
		'param_name' => 'background_gradient',
		'dependency' => array(
			'element' => 'background_color',
			'value'   => array( 'gradient' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Image', 'smilepure' ),
		'type'       => 'attach_image',
		'param_name' => 'background_image',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Hide Background Image', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'hide_background_image',
		'value'      => array(
			esc_html__( 'Always show', 'smilepure' )             => '',
			esc_html__( 'Medium Device Down', 'smilepure' )      => 'md',
			esc_html__( 'Small Device Down', 'smilepure' )       => 'sm',
			esc_html__( 'Extra Small Device Down', 'smilepure' ) => 'xs',
		),
		'std'        => '',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Repeat', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'background_repeat',
		'value'      => array(
			esc_html__( 'No repeat', 'smilepure' )         => 'no-repeat',
			esc_html__( 'Tile', 'smilepure' )              => 'repeat',
			esc_html__( 'Tile Horizontally', 'smilepure' ) => 'repeat-x',
			esc_html__( 'Tile Vertically', 'smilepure' )   => 'repeat-y',
		),
		'std'        => 'no-repeat',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Size', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'background_size',
		'value'      => array(
			esc_html__( 'Auto', 'smilepure' )    => 'auto',
			esc_html__( 'Cover', 'smilepure' )   => 'cover',
			esc_html__( 'Contain', 'smilepure' ) => 'contain',
			esc_html__( 'Manual', 'smilepure' )  => 'manual',
		),
		'std'        => 'cover',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Background Size (Manual Setting)', 'smilepure' ),
		'description' => esc_html__( 'E.g 50% 100%', 'smilepure' ),
		'type'        => 'textfield',
		'param_name'  => 'background_size_manual',
		'dependency'  => array(
			'element' => 'background_size',
			'value'   => 'manual',
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Background Position', 'smilepure' ),
		'description' => esc_html__( 'E.g left center', 'smilepure' ),
		'type'        => 'textfield',
		'param_name'  => 'background_position',
		'dependency'  => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Scroll Effect', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'background_attachment',
		'value'      => array(
			esc_html__( 'Move with the content', 'smilepure' ) => 'scroll',
			esc_html__( 'Fixed at its position', 'smilepure' ) => 'fixed',
			esc_html__( 'Marque', 'smilepure' )                => 'marque',
		),
		'std'        => 'scroll',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Marque Direction', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'marque_direction',
		'value'      => array(
			esc_html__( 'To Left', 'smilepure' )  => 'to-left',
			esc_html__( 'To Right', 'smilepure' ) => 'to-right',
		),
		'std'        => 'to-right',
		'dependency' => array(
			'element' => 'background_attachment',
			'value'   => 'marque',
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Marque Pause On Hover.', 'smilepure' ),
		'type'       => 'checkbox',
		'param_name' => 'marque_pause_on_hover',
		'value'      => array(
			esc_html__( 'Yes', 'smilepure' ) => '1',
		),
		'dependency' => array(
			'element' => 'background_attachment',
			'value'   => 'marque',
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Background Overlay', 'smilepure' ),
		'description' => esc_html__( 'Choose an overlay background color.', 'smilepure' ),
		'type'        => 'dropdown',
		'param_name'  => 'overlay_background',
		'value'       => array(
			esc_html__( 'None', 'smilepure' )            => '',
			esc_html__( 'Primary Color', 'smilepure' )   => 'primary',
			esc_html__( 'Secondary Color', 'smilepure' ) => 'secondary',
			esc_html__( 'Custom Color', 'smilepure' )    => 'custom',
			esc_html__( 'Gradient Color', 'smilepure' )  => 'gradient',
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Custom Background Overlay', 'smilepure' ),
		'description' => esc_html__( 'Choose an custom background color overlay.', 'smilepure' ),
		'type'        => 'colorpicker',
		'param_name'  => 'overlay_custom_background',
		'std'         => '#000000',
		'dependency'  => array(
			'element' => 'overlay_background',
			'value'   => array( 'custom' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Gradient Overlay', 'smilepure' ),
		'type'       => 'gradient',
		'param_name' => 'overlay_gradient_background',
		'dependency' => array(
			'element' => 'overlay_background',
			'value'   => array( 'gradient' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Opacity', 'smilepure' ),
		'type'       => 'number',
		'param_name' => 'overlay_opacity',
		'value'      => 100,
		'min'        => 0,
		'max'        => 100,
		'step'       => 1,
		'suffix'     => '%',
		'std'        => 80,
		'dependency' => array(
			'element'   => 'overlay_background',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $separator_tab,
		'heading'    => esc_html__( 'Type', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'separator_type',
		'value'      => array(
			esc_html__( 'None', 'smilepure' )               => '',
			esc_html__( 'Circle', 'smilepure' )             => 'circle',
			esc_html__( 'Curve', 'smilepure' )              => 'curve',
			esc_html__( 'Clouds', 'smilepure' )             => 'clouds',
			esc_html__( 'Waves', 'smilepure' )              => 'waves',
			esc_html__( 'Tilt Left', 'smilepure' )          => 'tilt_left',
			esc_html__( 'Tilt Right', 'smilepure' )         => 'tilt_right',
			esc_html__( 'Triangle', 'smilepure' )           => 'triangle',
			esc_html__( 'Big Triangle', 'smilepure' )       => 'big_triangle',
			esc_html__( 'Big Triangle Alt', 'smilepure' )   => 'big_triangle_alt',
			esc_html__( 'Big Triangle Left', 'smilepure' )  => 'big_triangle_left',
			esc_html__( 'Big Triangle Right', 'smilepure' ) => 'big_triangle_right',
		),
		'std'        => '',
	),
	array(
		'group'       => $separator_tab,
		'heading'     => esc_html__( 'Height', 'smilepure' ),
		'type'        => 'number_responsive',
		'param_name'  => 'separator_height',
		'step'        => 1,
		'suffix'      => 'px',
		'media_query' => array(
			'lg' => 100,
			'md' => '',
			'sm' => '',
			'xs' => '',
		),
		'dependency'  => array(
			'element'   => 'separator_type',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $separator_tab,
		'heading'    => esc_html__( 'Position', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'separator_position',
		'value'      => array(
			esc_html__( 'Top', 'smilepure' )    => 'top',
			esc_html__( 'Bottom', 'smilepure' ) => 'bottom',
		),
		'std'        => 'bottom',
		'dependency' => array(
			'element'   => 'separator_type',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $separator_tab,
		'heading'    => esc_html__( 'Separator Color', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'separator_color',
		'value'      => array(
			esc_html__( 'Primary Color', 'smilepure' ) => 'primary',
			esc_html__( 'Custom Color', 'smilepure' )  => 'custom',
		),
		'std'        => 'custom',
		'dependency' => array(
			'element'   => 'separator_type',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $separator_tab,
		'heading'    => esc_html__( 'Custom Separator Color', 'smilepure' ),
		'type'       => 'colorpicker',
		'param_name' => 'custom_separator_color',
		'dependency' => array(
			'element' => 'separator_color',
			'value'   => array( 'custom' ),
		),
		'std'        => '#fff',
	),
) ) );
