<?php

$styling_tab = esc_html__( 'Styling', 'smilepure' );

vc_remove_param( 'vc_column_inner', 'css' );

vc_add_params( 'vc_column_inner', array_merge( Smilepure_VC::get_vc_spacing_tab(), array(
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Border Radius', 'smilepure' ),
		'description' => esc_html__( 'E.g 5px or 50%', 'smilepure' ),
		'type'        => 'textfield',
		'param_name'  => 'border_radius',
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Box Shadow', 'smilepure' ),
		'description' => esc_html__( 'E.g 0 20px 30px #ccc', 'smilepure' ),
		'type'        => 'textfield',
		'param_name'  => 'box_shadow',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Color', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'background_color',
		'value'      => array(
			esc_html__( 'None', 'smilepure' )            => '',
			esc_html__( 'Primary Color', 'smilepure' )   => 'primary',
			esc_html__( 'Secondary Color', 'smilepure' ) => 'secondary',
			esc_html__( 'Custom Color', 'smilepure' )    => 'custom',
			esc_html__( 'Gradient Color', 'smilepure' )  => 'gradient',
		),
		'std'        => '',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Custom Background Color', 'smilepure' ),
		'type'       => 'colorpicker',
		'param_name' => 'custom_background_color',
		'dependency' => array(
			'element' => 'background_color',
			'value'   => array( 'custom' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Gradient', 'smilepure' ),
		'type'       => 'gradient',
		'param_name' => 'background_gradient',
		'dependency' => array(
			'element' => 'background_color',
			'value'   => array( 'gradient' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Image', 'smilepure' ),
		'type'       => 'attach_image',
		'param_name' => 'background_image',
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Hide Background Image', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'hide_background_image',
		'value'      => array(
			esc_html__( 'Always show', 'smilepure' )             => '',
			esc_html__( 'Medium Device Down', 'smilepure' )      => 'md',
			esc_html__( 'Small Device Down', 'smilepure' )       => 'sm',
			esc_html__( 'Extra Small Device Down', 'smilepure' ) => 'xs',
		),
		'std'        => '',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Repeat', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'background_repeat',
		'value'      => array(
			esc_html__( 'No repeat', 'smilepure' )         => 'no-repeat',
			esc_html__( 'Tile', 'smilepure' )              => 'repeat',
			esc_html__( 'Tile Horizontally', 'smilepure' ) => 'repeat-x',
			esc_html__( 'Tile Vertically', 'smilepure' )   => 'repeat-y',
		),
		'std'        => 'no-repeat',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Size', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'background_size',
		'value'      => array(
			esc_html__( 'Auto', 'smilepure' )    => 'auto',
			esc_html__( 'Cover', 'smilepure' )   => 'cover',
			esc_html__( 'Contain', 'smilepure' ) => 'contain',
		),
		'std'        => 'cover',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Background Position', 'smilepure' ),
		'description' => esc_html__( 'E.g left center', 'smilepure' ),
		'type'        => 'textfield',
		'param_name'  => 'background_position',
		'dependency'  => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Scroll Effect', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'background_attachment',
		'value'      => array(
			esc_html__( 'Move with the content', 'smilepure' ) => 'scroll',
			esc_html__( 'Fixed at its position', 'smilepure' ) => 'fixed',
		),
		'std'        => 'scroll',
		'dependency' => array(
			'element'   => 'background_image',
			'not_empty' => true,
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Background Overlay', 'smilepure' ),
		'description' => esc_html__( 'Choose an overlay background color.', 'smilepure' ),
		'type'        => 'dropdown',
		'param_name'  => 'overlay_background',
		'value'       => array(
			esc_html__( 'None', 'smilepure' )            => '',
			esc_html__( 'Primary Color', 'smilepure' )   => 'primary',
			esc_html__( 'Secondary Color', 'smilepure' ) => 'secondary',
			esc_html__( 'Custom Color', 'smilepure' )    => 'custom',
			esc_html__( 'Gradient Color', 'smilepure' )  => 'gradient',
		),
	),
	array(
		'group'       => $styling_tab,
		'heading'     => esc_html__( 'Custom Background Overlay', 'smilepure' ),
		'description' => esc_html__( 'Choose an custom background color overlay.', 'smilepure' ),
		'type'        => 'colorpicker',
		'param_name'  => 'overlay_custom_background',
		'std'         => '#000000',
		'dependency'  => array(
			'element' => 'overlay_background',
			'value'   => array( 'custom' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Background Gradient Overlay', 'smilepure' ),
		'type'       => 'gradient',
		'param_name' => 'overlay_gradient_background',
		'dependency' => array(
			'element' => 'overlay_background',
			'value'   => array( 'gradient' ),
		),
	),
	array(
		'group'      => $styling_tab,
		'heading'    => esc_html__( 'Opacity', 'smilepure' ),
		'type'       => 'number',
		'param_name' => 'overlay_opacity',
		'value'      => 100,
		'min'        => 0,
		'max'        => 100,
		'step'       => 1,
		'suffix'     => '%',
		'std'        => 80,
		'dependency' => array(
			'element'   => 'overlay_background',
			'not_empty' => true,
		),
	),
	array(
		'heading'     => esc_html__( 'Layer Index', 'smilepure' ),
		'description' => esc_html__( 'Controls z-index of this column', 'smilepure' ),
		'type'        => 'number',
		'param_name'  => 'layer_index',
		'min'         => 0,
		'max'         => 100,
		'step'        => 1,
	),
	array(
		'heading'     => esc_html__( 'Column Order', 'smilepure' ),
		'type'        => 'number_responsive',
		'param_name'  => 'order',
		'min'         => 0,
		'max'         => 100,
		'step'        => 1,
		'media_query' => array(
			'lg' => '',
			'md' => '',
			'sm' => '',
			'xs' => '',
		),
	),
	array(
		'heading'     => esc_html__( 'Width', 'smilepure' ),
		'description' => esc_html__( 'Controls the width of the column on large device. For E.g 570px.', 'smilepure' ),
		'type'        => 'textfield',
		'param_name'  => 'max_width',
	),
	array(
		'heading'    => esc_html__( 'Content Alignment Large Device', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'content_alignment',
		'value'      => array(
			esc_html__( 'Left', 'smilepure' )   => 'left',
			esc_html__( 'Center', 'smilepure' ) => 'center',
			esc_html__( 'Right', 'smilepure' )  => 'right',
		),
		'std'        => 'left',
	),
	array(
		'heading'    => esc_html__( 'Content Alignment Medium Device', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'md_content_alignment',
		'value'      => array(
			esc_html__( 'Inherit from larger device', 'smilepure' ) => '',
			esc_html__( 'Left', 'smilepure' )                       => 'left',
			esc_html__( 'Center', 'smilepure' )                     => 'center',
			esc_html__( 'Right', 'smilepure' )                      => 'right',
		),
		'std'        => '',
	),
	array(
		'heading'    => esc_html__( 'Content Alignment Small Device', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'sm_content_alignment',
		'value'      => array(
			esc_html__( 'Inherit from larger device', 'smilepure' ) => '',
			esc_html__( 'Left', 'smilepure' )                       => 'left',
			esc_html__( 'Center', 'smilepure' )                     => 'center',
			esc_html__( 'Right', 'smilepure' )                      => 'right',
		),
		'std'        => '',
	),
	array(
		'heading'    => esc_html__( 'Content Alignment Extra Small Device', 'smilepure' ),
		'type'       => 'dropdown',
		'param_name' => 'xs_content_alignment',
		'value'      => array(
			esc_html__( 'Inherit from larger device', 'smilepure' ) => '',
			esc_html__( 'Left', 'smilepure' )                       => 'left',
			esc_html__( 'Center', 'smilepure' )                     => 'center',
			esc_html__( 'Right', 'smilepure' )                      => 'right',
		),
		'std'        => '',
	),
) ) );
