<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section
 *
 * @link     https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package  SmilePure
 * @since    1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> <?php Smilepure::body_attributes(); ?>>
<?php wp_body_open(); ?>

<?php Smilepure_Templates::preloader(); ?>

<div id="page" class="site">
	<div class="content-wrapper">
		<?php Smilepure_Templates::slider( 'above' ); ?>
		<?php Smilepure_Templates::top_bar(); ?>
		<?php Smilepure_Templates::header(); ?>
		<?php Smilepure_Templates::slider( 'below' ); ?>
