<?php
/**
 * Define constant
 */
$theme = wp_get_theme();

if ( ! empty( $theme['Template'] ) ) {
	$theme = wp_get_theme( $theme['Template'] );
}

if ( ! defined( 'DS' ) ) {
	define( 'DS', DIRECTORY_SEPARATOR );
}

define( 'SMILEPURE_THEME_NAME', $theme['Name'] );
define( 'SMILEPURE_THEME_VERSION', $theme['Version'] );
define( 'SMILEPURE_THEME_DIR', get_template_directory() );
define( 'SMILEPURE_THEME_URI', get_template_directory_uri() );
define( 'SMILEPURE_THEME_IMAGE_DIR', get_template_directory() . DS . 'assets' . DS . 'images' );
define( 'SMILEPURE_THEME_IMAGE_URI', get_template_directory_uri() . DS . 'assets' . DS . 'images' );
define( 'SMILEPURE_CHILD_THEME_URI', get_stylesheet_directory_uri() );
define( 'SMILEPURE_CHILD_THEME_DIR', get_stylesheet_directory() );
define( 'SMILEPURE_FRAMEWORK_DIR', get_template_directory() . DS . 'framework' );
define( 'SMILEPURE_CUSTOMIZER_DIR', SMILEPURE_THEME_DIR . DS . 'customizer' );
define( 'SMILEPURE_WIDGETS_DIR', SMILEPURE_THEME_DIR . DS . 'widgets' );
define( 'SMILEPURE_VC_MAPS_DIR', SMILEPURE_THEME_DIR . DS . 'vc-extend' . DS . 'vc-maps' );
define( 'SMILEPURE_VC_PARAMS_DIR', SMILEPURE_THEME_DIR . DS . 'vc-extend' . DS . 'vc-params' );
define( 'SMILEPURE_VC_SHORTCODE_CATEGORY', 'By ' . SMILEPURE_THEME_NAME );
define( 'SMILEPURE_PROTOCOL', is_ssl() ? 'https' : 'http' );

require_once SMILEPURE_FRAMEWORK_DIR . '/class-static.php';

$files = array(
	SMILEPURE_FRAMEWORK_DIR . '/class-init.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-global.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-actions-filters.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-admin.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-customize.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-enqueue.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-functions.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-helper.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-color.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-import.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-kirki.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-metabox.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-plugins.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-query.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-custom-css.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-templates.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-aqua-resizer.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-visual-composer.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-vc-icon-fontawesome5.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-vc-icon-smilepure.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-vc-icon-flaticon.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-vc-icon-ion.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-vc-icon-icomoon.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-vc-icon-themify.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-vc-icon-linea.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-walker-nav-menu.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-widget.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-widgets.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-footer.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-post-type-blog.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-post-type-service.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-posttypes.php',
	SMILEPURE_FRAMEWORK_DIR . '/class-woo.php',
	SMILEPURE_FRAMEWORK_DIR . '/tgm-plugin-activation.php',
	SMILEPURE_FRAMEWORK_DIR . '/tgm-plugin-registration.php',
);

/**
 * Load Framework.
 */
Smilepure::require_files( $files );

/**
 * Init the theme
 */
Smilepure_Init::instance();

add_action('init', 'get_config_xml', 9999);
function get_config_xml() {

	$a = Smilepure_Kirki::instance()->get_key_string_wpml_config();

	Smilepure_Helper::d($a);
}

/**
 * Admin notice waning minimum plugin version required.
 *
 * @param $plugin_name
 * @param $plugin_version
 */
function smilepure_notice_required_plugin_version( $plugin_name, $plugin_version ) {
	if ( isset( $_GET['activate'] ) ) {
		unset( $_GET['activate'] );
	}

	$message = sprintf(
		esc_html__( '%1$s requires %2$s plugin version %3$s or greater!', 'smilepure' ),
		'<strong>' . SMILEPURE_THEME_NAME . '</strong>',
		'<strong>' . $plugin_name . '</strong>',
		$plugin_version
	);

	printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
}

/**
 * Allow to remove method for an hook when, it's a class method used and class don't have variable, but you know the class name :)
 *
 * @see https://github.com/herewithme/wp-filters-extras/blob/master/wp-filters-extras.php
 *
 * @param string $hook_name   The action hook to which the function to be removed is hooked.
 * @param string $class_name  The class name of contain function which should be removed.
 * @param string $method_name The name of the function which should be removed.
 * @param int    $priority    Optional. The priority of the function. Default 10.
 *
 * @return bool
 */
function smilepure_remove_filters_for_anonymous_class( $hook_name = '', $class_name = '', $method_name = '', $priority = 10 ) {
	global $wp_filter;

	// Take only filters on right hook name and priority
	if ( ! isset( $wp_filter[ $hook_name ][ $priority ] ) || ! is_array( $wp_filter[ $hook_name ][ $priority ] ) ) {
		return false;
	}

	// Loop on filters registered
	foreach ( (array) $wp_filter[ $hook_name ][ $priority ] as $unique_id => $filter_array ) {
		// Test if filter is an array ! (always for class/method)
		if ( isset( $filter_array['function'] ) && is_array( $filter_array['function'] ) ) {
			// Test if object is a class, class and method is equal to param !
			if ( is_object( $filter_array['function'][0] ) && get_class( $filter_array['function'][0] ) && get_class( $filter_array['function'][0] ) == $class_name && $filter_array['function'][1] == $method_name ) {
				// Test for WordPress >= 4.7 WP_Hook class (https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/)
				if ( is_a( $wp_filter[ $hook_name ], 'WP_Hook' ) ) {
					unset( $wp_filter[ $hook_name ]->callbacks[ $priority ][ $unique_id ] );
				} else {
					unset( $wp_filter[ $hook_name ][ $priority ][ $unique_id ] );
				}
			}
		}

	}

	return false;
}
