<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Smilepure_VC_Icon_FontAwesome5' ) ) {
	class Smilepure_VC_Icon_FontAwesome5 {

		public function __construct() {
			/*
			 * Add styles & script file only on add new or edit post type.
			 */
			add_action( 'load-post.php', array( $this, 'enqueue_scripts' ) );
			add_action( 'load-post-new.php', array( $this, 'enqueue_scripts' ) );

			add_filter( 'vc_iconpicker-type-fontawesome5', array( $this, 'add_fonts' ) );
			add_filter( 'Smilepure_vc_icon_libraries', array( $this, 'add_to_libraries' ) );
			add_filter( 'Smilepure_vc_icon_libraries_fields', array( $this, 'add_icon_picker_field' ), 10, 2 );

			add_action( 'vc_enqueue_font_icon_element', array( $this, 'vc_element_enqueue' ) );
		}

		public function add_to_libraries( $list ) {
			$list = $list + array( esc_html__( 'Font Awesome Pro', 'smilepure' ) => 'fontawesome5' );

			return $list;
		}

		public function add_icon_picker_field( $fields, $args ) {
			$fields[] = array(
				'type'        => 'iconpicker',
				'heading'     => esc_html__( 'Icon', 'smilepure' ),
				'param_name'  => 'icon_fontawesome5',
				'value'       => 'fa fa-adjust',
				'settings'    => array(
					'emptyIcon'    => true,
					'type'         => 'fontawesome5',
					'iconsPerPage' => 300,
				),
				'dependency'  => array(
					'element' => $args['param_name'],
					'value'   => 'fontawesome5',
				),
				'description' => esc_html__( 'Select icon from library.', 'smilepure' ),
			);

			return $fields;
		}

		public function vc_element_enqueue( $font ) {
			switch ( $font ) {
				case 'fontawesome5':
					wp_enqueue_style( 'font-awesome-pro', SMILEPURE_THEME_URI . '/assets/fonts/awesome/css/fontawesome-all.min.css', null, '6.4.2' );
					break;
			}
		}

		public function enqueue_scripts() {
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		}

		function admin_enqueue_scripts() {
			wp_enqueue_style( 'font-awesome-pro', SMILEPURE_THEME_URI . '/assets/fonts/awesome/css/fontawesome-all.min.css', null, '6.4.2' );
		}

		public function add_fonts( $icons ) {
			$new_icons = array(
				esc_html__( 'Brands', 'smilepure' )  => array(
					array( 'fa-brands fa-42-group' => '42-group' ),
					array( 'fa-brands fa-500px' => '500px' ),
					array( 'fa-brands fa-accessible-icon' => 'accessible-icon' ),
					array( 'fa-brands fa-accusoft' => 'accusoft' ),
					array( 'fa-brands fa-adn' => 'adn' ),
					array( 'fa-brands fa-adversal' => 'adversal' ),
					array( 'fa-brands fa-affiliatetheme' => 'affiliatetheme' ),
					array( 'fa-brands fa-airbnb' => 'airbnb' ),
					array( 'fa-brands fa-algolia' => 'algolia' ),
					array( 'fa-brands fa-alipay' => 'alipay' ),
					array( 'fa-brands fa-amazon-pay' => 'amazon-pay' ),
					array( 'fa-brands fa-amazon' => 'amazon' ),
					array( 'fa-brands fa-amilia' => 'amilia' ),
					array( 'fa-brands fa-android' => 'android' ),
					array( 'fa-brands fa-angellist' => 'angellist' ),
					array( 'fa-brands fa-angrycreative' => 'angrycreative' ),
					array( 'fa-brands fa-angular' => 'angular' ),
					array( 'fa-brands fa-app-store-ios' => 'app-store-ios' ),
					array( 'fa-brands fa-app-store' => 'app-store' ),
					array( 'fa-brands fa-apper' => 'apper' ),
					array( 'fa-brands fa-apple-pay' => 'apple-pay' ),
					array( 'fa-brands fa-apple' => 'apple' ),
					array( 'fa-brands fa-artstation' => 'artstation' ),
					array( 'fa-brands fa-asymmetrik' => 'asymmetrik' ),
					array( 'fa-brands fa-atlassian' => 'atlassian' ),
					array( 'fa-brands fa-audible' => 'audible' ),
					array( 'fa-brands fa-autoprefixer' => 'autoprefixer' ),
					array( 'fa-brands fa-avianex' => 'avianex' ),
					array( 'fa-brands fa-aviato' => 'aviato' ),
					array( 'fa-brands fa-aws' => 'aws' ),
					array( 'fa-brands fa-bandcamp' => 'bandcamp' ),
					array( 'fa-brands fa-battle-net' => 'battle-net' ),
					array( 'fa-brands fa-behance' => 'behance' ),
					array( 'fa-brands fa-bilibili' => 'bilibili' ),
					array( 'fa-brands fa-bimobject' => 'bimobject' ),
					array( 'fa-brands fa-bitbucket' => 'bitbucket' ),
					array( 'fa-brands fa-bitcoin' => 'bitcoin' ),
					array( 'fa-brands fa-bity' => 'bity' ),
					array( 'fa-brands fa-black-tie' => 'black-tie' ),
					array( 'fa-brands fa-blackberry' => 'blackberry' ),
					array( 'fa-brands fa-blogger-b' => 'blogger-b' ),
					array( 'fa-brands fa-blogger' => 'blogger' ),
					array( 'fa-brands fa-bluetooth-b' => 'bluetooth-b' ),
					array( 'fa-brands fa-bluetooth' => 'bluetooth' ),
					array( 'fa-brands fa-bootstrap' => 'bootstrap' ),
					array( 'fa-brands fa-bots' => 'bots' ),
					array( 'fa-brands fa-btc' => 'btc' ),
					array( 'fa-brands fa-buffer' => 'buffer' ),
					array( 'fa-brands fa-buromobelexperte' => 'buromobelexperte' ),
					array( 'fa-brands fa-buy-n-large' => 'buy-n-large' ),
					array( 'fa-brands fa-buysellads' => 'buysellads' ),
					array( 'fa-brands fa-canadian-maple-leaf' => 'canadian-maple-leaf' ),
					array( 'fa-brands fa-cc-amazon-pay' => 'cc-amazon-pay' ),
					array( 'fa-brands fa-cc-amex' => 'cc-amex' ),
					array( 'fa-brands fa-cc-apple-pay' => 'cc-apple-pay' ),
					array( 'fa-brands fa-cc-diners-club' => 'cc-diners-club' ),
					array( 'fa-brands fa-cc-discover' => 'cc-discover' ),
					array( 'fa-brands fa-cc-jcb' => 'cc-jcb' ),
					array( 'fa-brands fa-cc-mastercard' => 'cc-mastercard' ),
					array( 'fa-brands fa-cc-paypal' => 'cc-paypal' ),
					array( 'fa-brands fa-cc-stripe' => 'cc-stripe' ),
					array( 'fa-brands fa-cc-visa' => 'cc-visa' ),
					array( 'fa-brands fa-centercode' => 'centercode' ),
					array( 'fa-brands fa-centos' => 'centos' ),
					array( 'fa-brands fa-chrome' => 'chrome' ),
					array( 'fa-brands fa-chromecast' => 'chromecast' ),
					array( 'fa-brands fa-cloudflare' => 'cloudflare' ),
					array( 'fa-brands fa-cloudscale' => 'cloudscale' ),
					array( 'fa-brands fa-cloudsmith' => 'cloudsmith' ),
					array( 'fa-brands fa-cloudversify' => 'cloudversify' ),
					array( 'fa-brands fa-cmplid' => 'cmplid' ),
					array( 'fa-brands fa-codepen' => 'codepen' ),
					array( 'fa-brands fa-codiepie' => 'codiepie' ),
					array( 'fa-brands fa-confluence' => 'confluence' ),
					array( 'fa-brands fa-connectdevelop' => 'connectdevelop' ),
					array( 'fa-brands fa-contao' => 'contao' ),
					array( 'fa-brands fa-cotton-bureau' => 'cotton-bureau' ),
					array( 'fa-brands fa-cpanel' => 'cpanel' ),
					array( 'fa-brands fa-creative-commons-by' => 'creative-commons-by' ),
					array( 'fa-brands fa-creative-commons-nc-eu' => 'creative-commons-nc-eu' ),
					array( 'fa-brands fa-creative-commons-nc-jp' => 'creative-commons-nc-jp' ),
					array( 'fa-brands fa-creative-commons-nc' => 'creative-commons-nc' ),
					array( 'fa-brands fa-creative-commons-nd' => 'creative-commons-nd' ),
					array( 'fa-brands fa-creative-commons-pd-alt' => 'creative-commons-pd-alt' ),
					array( 'fa-brands fa-creative-commons-pd' => 'creative-commons-pd' ),
					array( 'fa-brands fa-creative-commons-remix' => 'creative-commons-remix' ),
					array( 'fa-brands fa-creative-commons-sa' => 'creative-commons-sa' ),
					array( 'fa-brands fa-creative-commons-sampling-plus' => 'creative-commons-sampling-plus' ),
					array( 'fa-brands fa-creative-commons-sampling' => 'creative-commons-sampling' ),
					array( 'fa-brands fa-creative-commons-share' => 'creative-commons-share' ),
					array( 'fa-brands fa-creative-commons-zero' => 'creative-commons-zero' ),
					array( 'fa-brands fa-creative-commons' => 'creative-commons' ),
					array( 'fa-brands fa-critical-role' => 'critical-role' ),
					array( 'fa-brands fa-css3-alt' => 'css3-alt' ),
					array( 'fa-brands fa-css3' => 'css3' ),
					array( 'fa-brands fa-cuttlefish' => 'cuttlefish' ),
					array( 'fa-brands fa-d-and-d-beyond' => 'd-and-d-beyond' ),
					array( 'fa-brands fa-d-and-d' => 'd-and-d' ),
					array( 'fa-brands fa-dailymotion' => 'dailymotion' ),
					array( 'fa-brands fa-dashcube' => 'dashcube' ),
					array( 'fa-brands fa-debian' => 'debian' ),
					array( 'fa-brands fa-deezer' => 'deezer' ),
					array( 'fa-brands fa-delicious' => 'delicious' ),
					array( 'fa-brands fa-deploydog' => 'deploydog' ),
					array( 'fa-brands fa-deskpro' => 'deskpro' ),
					array( 'fa-brands fa-dev' => 'dev' ),
					array( 'fa-brands fa-deviantart' => 'deviantart' ),
					array( 'fa-brands fa-dhl' => 'dhl' ),
					array( 'fa-brands fa-diaspora' => 'diaspora' ),
					array( 'fa-brands fa-digg' => 'digg' ),
					array( 'fa-brands fa-digital-ocean' => 'digital-ocean' ),
					array( 'fa-brands fa-discord' => 'discord' ),
					array( 'fa-brands fa-discourse' => 'discourse' ),
					array( 'fa-brands fa-dochub' => 'dochub' ),
					array( 'fa-brands fa-docker' => 'docker' ),
					array( 'fa-brands fa-draft2digital' => 'draft2digital' ),
					array( 'fa-brands fa-dribbble' => 'dribbble' ),
					array( 'fa-brands fa-dropbox' => 'dropbox' ),
					array( 'fa-brands fa-drupal' => 'drupal' ),
					array( 'fa-brands fa-dyalog' => 'dyalog' ),
					array( 'fa-brands fa-earlybirds' => 'earlybirds' ),
					array( 'fa-brands fa-ebay' => 'ebay' ),
					array( 'fa-brands fa-edge-legacy' => 'edge-legacy' ),
					array( 'fa-brands fa-edge' => 'edge' ),
					array( 'fa-brands fa-elementor' => 'elementor' ),
					array( 'fa-brands fa-ello' => 'ello' ),
					array( 'fa-brands fa-ember' => 'ember' ),
					array( 'fa-brands fa-empire' => 'empire' ),
					array( 'fa-brands fa-envira' => 'envira' ),
					array( 'fa-brands fa-erlang' => 'erlang' ),
					array( 'fa-brands fa-ethereum' => 'ethereum' ),
					array( 'fa-brands fa-etsy' => 'etsy' ),
					array( 'fa-brands fa-evernote' => 'evernote' ),
					array( 'fa-brands fa-expeditedssl' => 'expeditedssl' ),
					array( 'fa-brands fa-facebook-f' => 'facebook-f' ),
					array( 'fa-brands fa-facebook-messenger' => 'facebook-messenger' ),
					array( 'fa-brands fa-facebook' => 'facebook' ),
					array( 'fa-brands fa-fantasy-flight-games' => 'fantasy-flight-games' ),
					array( 'fa-brands fa-fedex' => 'fedex' ),
					array( 'fa-brands fa-fedora' => 'fedora' ),
					array( 'fa-brands fa-figma' => 'figma' ),
					array( 'fa-brands fa-firefox-browser' => 'firefox-browser' ),
					array( 'fa-brands fa-firefox' => 'firefox' ),
					array( 'fa-brands fa-first-order-alt' => 'first-order-alt' ),
					array( 'fa-brands fa-first-order' => 'first-order' ),
					array( 'fa-brands fa-firstdraft' => 'firstdraft' ),
					array( 'fa-brands fa-flickr' => 'flickr' ),
					array( 'fa-brands fa-flipboard' => 'flipboard' ),
					array( 'fa-brands fa-fly' => 'fly' ),
					array( 'fa-brands fa-font-awesome' => 'font-awesome' ),
					array( 'fa-brands fa-fonticons-fi' => 'fonticons-fi' ),
					array( 'fa-brands fa-fonticons' => 'fonticons' ),
					array( 'fa-brands fa-fort-awesome-alt' => 'fort-awesome-alt' ),
					array( 'fa-brands fa-fort-awesome' => 'fort-awesome' ),
					array( 'fa-brands fa-forumbee' => 'forumbee' ),
					array( 'fa-brands fa-foursquare' => 'foursquare' ),
					array( 'fa-brands fa-free-code-camp' => 'free-code-camp' ),
					array( 'fa-brands fa-freebsd' => 'freebsd' ),
					array( 'fa-brands fa-fulcrum' => 'fulcrum' ),
					array( 'fa-brands fa-galactic-republic' => 'galactic-republic' ),
					array( 'fa-brands fa-galactic-senate' => 'galactic-senate' ),
					array( 'fa-brands fa-get-pocket' => 'get-pocket' ),
					array( 'fa-brands fa-gg-circle' => 'gg-circle' ),
					array( 'fa-brands fa-gg' => 'gg' ),
					array( 'fa-brands fa-git-alt' => 'git-alt' ),
					array( 'fa-brands fa-git' => 'git' ),
					array( 'fa-brands fa-github-alt' => 'github-alt' ),
					array( 'fa-brands fa-github' => 'github' ),
					array( 'fa-brands fa-gitkraken' => 'gitkraken' ),
					array( 'fa-brands fa-gitlab' => 'gitlab' ),
					array( 'fa-brands fa-gitter' => 'gitter' ),
					array( 'fa-brands fa-glide-g' => 'glide-g' ),
					array( 'fa-brands fa-glide' => 'glide' ),
					array( 'fa-brands fa-gofore' => 'gofore' ),
					array( 'fa-brands fa-golang' => 'golang' ),
					array( 'fa-brands fa-goodreads-g' => 'goodreads-g' ),
					array( 'fa-brands fa-goodreads' => 'goodreads' ),
					array( 'fa-brands fa-google-drive' => 'google-drive' ),
					array( 'fa-brands fa-google-pay' => 'google-pay' ),
					array( 'fa-brands fa-google-play' => 'google-play' ),
					array( 'fa-brands fa-google-plus-g' => 'google-plus-g' ),
					array( 'fa-brands fa-google-plus' => 'google-plus' ),
					array( 'fa-brands fa-google-wallet' => 'google-wallet' ),
					array( 'fa-brands fa-google' => 'google' ),
					array( 'fa-brands fa-gratipay' => 'gratipay' ),
					array( 'fa-brands fa-grav' => 'grav' ),
					array( 'fa-brands fa-gripfire' => 'gripfire' ),
					array( 'fa-brands fa-grunt' => 'grunt' ),
					array( 'fa-brands fa-guilded' => 'guilded' ),
					array( 'fa-brands fa-gulp' => 'gulp' ),
					array( 'fa-brands fa-hacker-news' => 'hacker-news' ),
					array( 'fa-brands fa-hackerrank' => 'hackerrank' ),
					array( 'fa-brands fa-hashnode' => 'hashnode' ),
					array( 'fa-brands fa-hips' => 'hips' ),
					array( 'fa-brands fa-hire-a-helper' => 'hire-a-helper' ),
					array( 'fa-brands fa-hive' => 'hive' ),
					array( 'fa-brands fa-hooli' => 'hooli' ),
					array( 'fa-brands fa-hornbill' => 'hornbill' ),
					array( 'fa-brands fa-hotjar' => 'hotjar' ),
					array( 'fa-brands fa-houzz' => 'houzz' ),
					array( 'fa-brands fa-html5' => 'html5' ),
					array( 'fa-brands fa-hubspot' => 'hubspot' ),
					array( 'fa-brands fa-ideal' => 'ideal' ),
					array( 'fa-brands fa-imdb' => 'imdb' ),
					array( 'fa-brands fa-instagram' => 'instagram' ),
					array( 'fa-brands fa-instalod' => 'instalod' ),
					array( 'fa-brands fa-intercom' => 'intercom' ),
					array( 'fa-brands fa-internet-explorer' => 'internet-explorer' ),
					array( 'fa-brands fa-invision' => 'invision' ),
					array( 'fa-brands fa-ioxhost' => 'ioxhost' ),
					array( 'fa-brands fa-itch-io' => 'itch-io' ),
					array( 'fa-brands fa-itunes-note' => 'itunes-note' ),
					array( 'fa-brands fa-itunes' => 'itunes' ),
					array( 'fa-brands fa-java' => 'java' ),
					array( 'fa-brands fa-jedi-order' => 'jedi-order' ),
					array( 'fa-brands fa-jenkins' => 'jenkins' ),
					array( 'fa-brands fa-jira' => 'jira' ),
					array( 'fa-brands fa-joget' => 'joget' ),
					array( 'fa-brands fa-joomla' => 'joomla' ),
					array( 'fa-brands fa-js' => 'js' ),
					array( 'fa-brands fa-jsfiddle' => 'jsfiddle' ),
					array( 'fa-brands fa-kaggle' => 'kaggle' ),
					array( 'fa-brands fa-keybase' => 'keybase' ),
					array( 'fa-brands fa-keycdn' => 'keycdn' ),
					array( 'fa-brands fa-kickstarter-k' => 'kickstarter-k' ),
					array( 'fa-brands fa-kickstarter' => 'kickstarter' ),
					array( 'fa-brands fa-korvue' => 'korvue' ),
					array( 'fa-brands fa-laravel' => 'laravel' ),
					array( 'fa-brands fa-lastfm' => 'lastfm' ),
					array( 'fa-brands fa-leanpub' => 'leanpub' ),
					array( 'fa-brands fa-less' => 'less' ),
					array( 'fa-brands fa-line' => 'line' ),
					array( 'fa-brands fa-linkedin-in' => 'linkedin-in' ),
					array( 'fa-brands fa-linkedin' => 'linkedin' ),
					array( 'fa-brands fa-linode' => 'linode' ),
					array( 'fa-brands fa-linux' => 'linux' ),
					array( 'fa-brands fa-lyft' => 'lyft' ),
					array( 'fa-brands fa-magento' => 'magento' ),
					array( 'fa-brands fa-mailchimp' => 'mailchimp' ),
					array( 'fa-brands fa-mandalorian' => 'mandalorian' ),
					array( 'fa-brands fa-markdown' => 'markdown' ),
					array( 'fa-brands fa-mastodon' => 'mastodon' ),
					array( 'fa-brands fa-maxcdn' => 'maxcdn' ),
					array( 'fa-brands fa-mdb' => 'mdb' ),
					array( 'fa-brands fa-medapps' => 'medapps' ),
					array( 'fa-brands fa-medium' => 'medium' ),
					array( 'fa-brands fa-medrt' => 'medrt' ),
					array( 'fa-brands fa-meetup' => 'meetup' ),
					array( 'fa-brands fa-megaport' => 'megaport' ),
					array( 'fa-brands fa-mendeley' => 'mendeley' ),
					array( 'fa-brands fa-meta' => 'meta' ),
					array( 'fa-brands fa-microblog' => 'microblog' ),
					array( 'fa-brands fa-microsoft' => 'microsoft' ),
					array( 'fa-brands fa-mix' => 'mix' ),
					array( 'fa-brands fa-mixcloud' => 'mixcloud' ),
					array( 'fa-brands fa-mixer' => 'mixer' ),
					array( 'fa-brands fa-mizuni' => 'mizuni' ),
					array( 'fa-brands fa-modx' => 'modx' ),
					array( 'fa-brands fa-monero' => 'monero' ),
					array( 'fa-brands fa-napster' => 'napster' ),
					array( 'fa-brands fa-neos' => 'neos' ),
					array( 'fa-brands fa-nfc-directional' => 'nfc-directional' ),
					array( 'fa-brands fa-nfc-symbol' => 'nfc-symbol' ),
					array( 'fa-brands fa-nimblr' => 'nimblr' ),
					array( 'fa-brands fa-node-js' => 'node-js' ),
					array( 'fa-brands fa-node' => 'node' ),
					array( 'fa-brands fa-npm' => 'npm' ),
					array( 'fa-brands fa-ns8' => 'ns8' ),
					array( 'fa-brands fa-nutritionix' => 'nutritionix' ),
					array( 'fa-brands fa-octopus-deploy' => 'octopus-deploy' ),
					array( 'fa-brands fa-odnoklassniki' => 'odnoklassniki' ),
					array( 'fa-brands fa-odysee' => 'odysee' ),
					array( 'fa-brands fa-old-republic' => 'old-republic' ),
					array( 'fa-brands fa-opencart' => 'opencart' ),
					array( 'fa-brands fa-openid' => 'openid' ),
					array( 'fa-brands fa-opera' => 'opera' ),
					array( 'fa-brands fa-optin-monster' => 'optin-monster' ),
					array( 'fa-brands fa-orcid' => 'orcid' ),
					array( 'fa-brands fa-osi' => 'osi' ),
					array( 'fa-brands fa-padlet' => 'padlet' ),
					array( 'fa-brands fa-page4' => 'page4' ),
					array( 'fa-brands fa-pagelines' => 'pagelines' ),
					array( 'fa-brands fa-palfed' => 'palfed' ),
					array( 'fa-brands fa-patreon' => 'patreon' ),
					array( 'fa-brands fa-paypal' => 'paypal' ),
					array( 'fa-brands fa-perbyte' => 'perbyte' ),
					array( 'fa-brands fa-periscope' => 'periscope' ),
					array( 'fa-brands fa-phabricator' => 'phabricator' ),
					array( 'fa-brands fa-phoenix-framework' => 'phoenix-framework' ),
					array( 'fa-brands fa-phoenix-squadron' => 'phoenix-squadron' ),
					array( 'fa-brands fa-php' => 'php' ),
					array( 'fa-brands fa-pied-piper-alt' => 'pied-piper-alt' ),
					array( 'fa-brands fa-pied-piper-hat' => 'pied-piper-hat' ),
					array( 'fa-brands fa-pied-piper-pp' => 'pied-piper-pp' ),
					array( 'fa-brands fa-pied-piper' => 'pied-piper' ),
					array( 'fa-brands fa-pinterest-p' => 'pinterest-p' ),
					array( 'fa-brands fa-pinterest' => 'pinterest' ),
					array( 'fa-brands fa-pix' => 'pix' ),
					array( 'fa-brands fa-playstation' => 'playstation' ),
					array( 'fa-brands fa-product-hunt' => 'product-hunt' ),
					array( 'fa-brands fa-pushed' => 'pushed' ),
					array( 'fa-brands fa-python' => 'python' ),
					array( 'fa-brands fa-qq' => 'qq' ),
					array( 'fa-brands fa-quinscape' => 'quinscape' ),
					array( 'fa-brands fa-quora' => 'quora' ),
					array( 'fa-brands fa-r-project' => 'r-project' ),
					array( 'fa-brands fa-raspberry-pi' => 'raspberry-pi' ),
					array( 'fa-brands fa-ravelry' => 'ravelry' ),
					array( 'fa-brands fa-react' => 'react' ),
					array( 'fa-brands fa-reacteurope' => 'reacteurope' ),
					array( 'fa-brands fa-readme' => 'readme' ),
					array( 'fa-brands fa-rebel' => 'rebel' ),
					array( 'fa-brands fa-red-river' => 'red-river' ),
					array( 'fa-brands fa-reddit-alien' => 'reddit-alien' ),
					array( 'fa-brands fa-reddit' => 'reddit' ),
					array( 'fa-brands fa-redhat' => 'redhat' ),
					array( 'fa-brands fa-renren' => 'renren' ),
					array( 'fa-brands fa-replyd' => 'replyd' ),
					array( 'fa-brands fa-researchgate' => 'researchgate' ),
					array( 'fa-brands fa-resolving' => 'resolving' ),
					array( 'fa-brands fa-rev' => 'rev' ),
					array( 'fa-brands fa-rocketchat' => 'rocketchat' ),
					array( 'fa-brands fa-rockrms' => 'rockrms' ),
					array( 'fa-brands fa-rust' => 'rust' ),
					array( 'fa-brands fa-safari' => 'safari' ),
					array( 'fa-brands fa-salesforce' => 'salesforce' ),
					array( 'fa-brands fa-sass' => 'sass' ),
					array( 'fa-brands fa-schlix' => 'schlix' ),
					array( 'fa-brands fa-screenpal' => 'screenpal' ),
					array( 'fa-brands fa-scribd' => 'scribd' ),
					array( 'fa-brands fa-searchengin' => 'searchengin' ),
					array( 'fa-brands fa-sellcast' => 'sellcast' ),
					array( 'fa-brands fa-sellsy' => 'sellsy' ),
					array( 'fa-brands fa-servicestack' => 'servicestack' ),
					array( 'fa-brands fa-shirtsinbulk' => 'shirtsinbulk' ),
					array( 'fa-brands fa-shoelace' => 'shoelace' ),
					array( 'fa-brands fa-shopify' => 'shopify' ),
					array( 'fa-brands fa-shopware' => 'shopware' ),
					array( 'fa-brands fa-simplybuilt' => 'simplybuilt' ),
					array( 'fa-brands fa-sistrix' => 'sistrix' ),
					array( 'fa-brands fa-sith' => 'sith' ),
					array( 'fa-brands fa-sitrox' => 'sitrox' ),
					array( 'fa-brands fa-sketch' => 'sketch' ),
					array( 'fa-brands fa-skyatlas' => 'skyatlas' ),
					array( 'fa-brands fa-skype' => 'skype' ),
					array( 'fa-brands fa-slack' => 'slack' ),
					array( 'fa-brands fa-slideshare' => 'slideshare' ),
					array( 'fa-brands fa-snapchat' => 'snapchat' ),
					array( 'fa-brands fa-soundcloud' => 'soundcloud' ),
					array( 'fa-brands fa-sourcetree' => 'sourcetree' ),
					array( 'fa-brands fa-space-awesome' => 'space-awesome' ),
					array( 'fa-brands fa-speakap' => 'speakap' ),
					array( 'fa-brands fa-speaker-deck' => 'speaker-deck' ),
					array( 'fa-brands fa-spotify' => 'spotify' ),
					array( 'fa-brands fa-square-behance' => 'square-behance' ),
					array( 'fa-brands fa-square-dribbble' => 'square-dribbble' ),
					array( 'fa-brands fa-square-facebook' => 'square-facebook' ),
					array( 'fa-brands fa-square-font-awesome-stroke' => 'square-font-awesome-stroke' ),
					array( 'fa-brands fa-square-font-awesome' => 'square-font-awesome' ),
					array( 'fa-brands fa-square-git' => 'square-git' ),
					array( 'fa-brands fa-square-github' => 'square-github' ),
					array( 'fa-brands fa-square-gitlab' => 'square-gitlab' ),
					array( 'fa-brands fa-square-google-plus' => 'square-google-plus' ),
					array( 'fa-brands fa-square-hacker-news' => 'square-hacker-news' ),
					array( 'fa-brands fa-square-instagram' => 'square-instagram' ),
					array( 'fa-brands fa-square-js' => 'square-js' ),
					array( 'fa-brands fa-square-lastfm' => 'square-lastfm' ),
					array( 'fa-brands fa-square-odnoklassniki' => 'square-odnoklassniki' ),
					array( 'fa-brands fa-square-pied-piper' => 'square-pied-piper' ),
					array( 'fa-brands fa-square-pinterest' => 'square-pinterest' ),
					array( 'fa-brands fa-square-reddit' => 'square-reddit' ),
					array( 'fa-brands fa-square-snapchat' => 'square-snapchat' ),
					array( 'fa-brands fa-square-steam' => 'square-steam' ),
					array( 'fa-brands fa-square-threads' => 'square-threads' ),
					array( 'fa-brands fa-square-tumblr' => 'square-tumblr' ),
					array( 'fa-brands fa-square-twitter' => 'square-twitter' ),
					array( 'fa-brands fa-square-viadeo' => 'square-viadeo' ),
					array( 'fa-brands fa-square-vimeo' => 'square-vimeo' ),
					array( 'fa-brands fa-square-whatsapp' => 'square-whatsapp' ),
					array( 'fa-brands fa-square-x-twitter' => 'square-x-twitter' ),
					array( 'fa-brands fa-square-xing' => 'square-xing' ),
					array( 'fa-brands fa-square-youtube' => 'square-youtube' ),
					array( 'fa-brands fa-squarespace' => 'squarespace' ),
					array( 'fa-brands fa-stack-exchange' => 'stack-exchange' ),
					array( 'fa-brands fa-stack-overflow' => 'stack-overflow' ),
					array( 'fa-brands fa-stackpath' => 'stackpath' ),
					array( 'fa-brands fa-staylinked' => 'staylinked' ),
					array( 'fa-brands fa-steam-symbol' => 'steam-symbol' ),
					array( 'fa-brands fa-steam' => 'steam' ),
					array( 'fa-brands fa-sticker-mule' => 'sticker-mule' ),
					array( 'fa-brands fa-strava' => 'strava' ),
					array( 'fa-brands fa-stripe-s' => 'stripe-s' ),
					array( 'fa-brands fa-stripe' => 'stripe' ),
					array( 'fa-brands fa-stubber' => 'stubber' ),
					array( 'fa-brands fa-studiovinari' => 'studiovinari' ),
					array( 'fa-brands fa-stumbleupon-circle' => 'stumbleupon-circle' ),
					array( 'fa-brands fa-stumbleupon' => 'stumbleupon' ),
					array( 'fa-brands fa-superpowers' => 'superpowers' ),
					array( 'fa-brands fa-supple' => 'supple' ),
					array( 'fa-brands fa-suse' => 'suse' ),
					array( 'fa-brands fa-swift' => 'swift' ),
					array( 'fa-brands fa-symfony' => 'symfony' ),
					array( 'fa-brands fa-teamspeak' => 'teamspeak' ),
					array( 'fa-brands fa-telegram' => 'telegram' ),
					array( 'fa-brands fa-tencent-weibo' => 'tencent-weibo' ),
					array( 'fa-brands fa-the-red-yeti' => 'the-red-yeti' ),
					array( 'fa-brands fa-themeco' => 'themeco' ),
					array( 'fa-brands fa-themeisle' => 'themeisle' ),
					array( 'fa-brands fa-think-peaks' => 'think-peaks' ),
					array( 'fa-brands fa-threads' => 'threads' ),
					array( 'fa-brands fa-tiktok' => 'tiktok' ),
					array( 'fa-brands fa-trade-federation' => 'trade-federation' ),
					array( 'fa-brands fa-trello' => 'trello' ),
					array( 'fa-brands fa-tumblr' => 'tumblr' ),
					array( 'fa-brands fa-twitch' => 'twitch' ),
					array( 'fa-brands fa-twitter' => 'twitter' ),
					array( 'fa-brands fa-typo3' => 'typo3' ),
					array( 'fa-brands fa-uber' => 'uber' ),
					array( 'fa-brands fa-ubuntu' => 'ubuntu' ),
					array( 'fa-brands fa-uikit' => 'uikit' ),
					array( 'fa-brands fa-umbraco' => 'umbraco' ),
					array( 'fa-brands fa-uncharted' => 'uncharted' ),
					array( 'fa-brands fa-uniregistry' => 'uniregistry' ),
					array( 'fa-brands fa-unity' => 'unity' ),
					array( 'fa-brands fa-unsplash' => 'unsplash' ),
					array( 'fa-brands fa-untappd' => 'untappd' ),
					array( 'fa-brands fa-ups' => 'ups' ),
					array( 'fa-brands fa-usb' => 'usb' ),
					array( 'fa-brands fa-usps' => 'usps' ),
					array( 'fa-brands fa-ussunnah' => 'ussunnah' ),
					array( 'fa-brands fa-vaadin' => 'vaadin' ),
					array( 'fa-brands fa-viacoin' => 'viacoin' ),
					array( 'fa-brands fa-viadeo' => 'viadeo' ),
					array( 'fa-brands fa-viber' => 'viber' ),
					array( 'fa-brands fa-vimeo-v' => 'vimeo-v' ),
					array( 'fa-brands fa-vimeo' => 'vimeo' ),
					array( 'fa-brands fa-vine' => 'vine' ),
					array( 'fa-brands fa-vk' => 'vk' ),
					array( 'fa-brands fa-vnv' => 'vnv' ),
					array( 'fa-brands fa-vuejs' => 'vuejs' ),
					array( 'fa-brands fa-watchman-monitoring' => 'watchman-monitoring' ),
					array( 'fa-brands fa-waze' => 'waze' ),
					array( 'fa-brands fa-weebly' => 'weebly' ),
					array( 'fa-brands fa-weibo' => 'weibo' ),
					array( 'fa-brands fa-weixin' => 'weixin' ),
					array( 'fa-brands fa-whatsapp' => 'whatsapp' ),
					array( 'fa-brands fa-whmcs' => 'whmcs' ),
					array( 'fa-brands fa-wikipedia-w' => 'wikipedia-w' ),
					array( 'fa-brands fa-windows' => 'windows' ),
					array( 'fa-brands fa-wirsindhandwerk' => 'wirsindhandwerk' ),
					array( 'fa-brands fa-wix' => 'wix' ),
					array( 'fa-brands fa-wizards-of-the-coast' => 'wizards-of-the-coast' ),
					array( 'fa-brands fa-wodu' => 'wodu' ),
					array( 'fa-brands fa-wolf-pack-battalion' => 'wolf-pack-battalion' ),
					array( 'fa-brands fa-wordpress-simple' => 'wordpress-simple' ),
					array( 'fa-brands fa-wordpress' => 'wordpress' ),
					array( 'fa-brands fa-wpbeginner' => 'wpbeginner' ),
					array( 'fa-brands fa-wpexplorer' => 'wpexplorer' ),
					array( 'fa-brands fa-wpforms' => 'wpforms' ),
					array( 'fa-brands fa-wpressr' => 'wpressr' ),
					array( 'fa-brands fa-x-twitter' => 'x-twitter' ),
					array( 'fa-brands fa-xbox' => 'xbox' ),
					array( 'fa-brands fa-xing' => 'xing' ),
					array( 'fa-brands fa-y-combinator' => 'y-combinator' ),
					array( 'fa-brands fa-yahoo' => 'yahoo' ),
					array( 'fa-brands fa-yammer' => 'yammer' ),
					array( 'fa-brands fa-yandex-international' => 'yandex-international' ),
					array( 'fa-brands fa-yandex' => 'yandex' ),
					array( 'fa-brands fa-yarn' => 'yarn' ),
					array( 'fa-brands fa-yelp' => 'yelp' ),
					array( 'fa-brands fa-yoast' => 'yoast' ),
					array( 'fa-brands fa-youtube' => 'youtube' ),
					array( 'fa-brands fa-zhihu' => 'zhihu' ),
				),
				esc_html__( 'Regular', 'smilepure' ) => array(
					array( 'fa-regular fa-0' => '0' ),
					array( 'fa-regular fa-00' => '00' ),
					array( 'fa-regular fa-1' => '1' ),
					array( 'fa-regular fa-2' => '2' ),
					array( 'fa-regular fa-3' => '3' ),
					array( 'fa-regular fa-4' => '4' ),
					array( 'fa-regular fa-5' => '5' ),
					array( 'fa-regular fa-6' => '6' ),
					array( 'fa-regular fa-7' => '7' ),
					array( 'fa-regular fa-8' => '8' ),
					array( 'fa-regular fa-9' => '9' ),
					array( 'fa-regular fa-360-degrees' => '360-degrees' ),
					array( 'fa-regular fa-a' => 'a' ),
					array( 'fa-regular fa-abacus' => 'abacus' ),
					array( 'fa-regular fa-accent-grave' => 'accent-grave' ),
					array( 'fa-regular fa-acorn' => 'acorn' ),
					array( 'fa-regular fa-address-book' => 'address-book' ),
					array( 'fa-regular fa-address-card' => 'address-card' ),
					array( 'fa-regular fa-air-conditioner' => 'air-conditioner' ),
					array( 'fa-regular fa-airplay' => 'airplay' ),
					array( 'fa-regular fa-alarm-clock' => 'alarm-clock' ),
					array( 'fa-regular fa-alarm-exclamation' => 'alarm-exclamation' ),
					array( 'fa-regular fa-alarm-plus' => 'alarm-plus' ),
					array( 'fa-regular fa-alarm-snooze' => 'alarm-snooze' ),
					array( 'fa-regular fa-album-circle-plus' => 'album-circle-plus' ),
					array( 'fa-regular fa-album-circle-user' => 'album-circle-user' ),
					array( 'fa-regular fa-album-collection-circle-plus' => 'album-collection-circle-plus' ),
					array( 'fa-regular fa-album-collection-circle-user' => 'album-collection-circle-user' ),
					array( 'fa-regular fa-album-collection' => 'album-collection' ),
					array( 'fa-regular fa-album' => 'album' ),
					array( 'fa-regular fa-alicorn' => 'alicorn' ),
					array( 'fa-regular fa-alien-8bit' => 'alien-8bit' ),
					array( 'fa-regular fa-alien' => 'alien' ),
					array( 'fa-regular fa-align-center' => 'align-center' ),
					array( 'fa-regular fa-align-justify' => 'align-justify' ),
					array( 'fa-regular fa-align-left' => 'align-left' ),
					array( 'fa-regular fa-align-right' => 'align-right' ),
					array( 'fa-regular fa-align-slash' => 'align-slash' ),
					array( 'fa-regular fa-alt' => 'alt' ),
					array( 'fa-regular fa-amp-guitar' => 'amp-guitar' ),
					array( 'fa-regular fa-ampersand' => 'ampersand' ),
					array( 'fa-regular fa-anchor-circle-check' => 'anchor-circle-check' ),
					array( 'fa-regular fa-anchor-circle-exclamation' => 'anchor-circle-exclamation' ),
					array( 'fa-regular fa-anchor-circle-xmark' => 'anchor-circle-xmark' ),
					array( 'fa-regular fa-anchor-lock' => 'anchor-lock' ),
					array( 'fa-regular fa-anchor' => 'anchor' ),
					array( 'fa-regular fa-angel' => 'angel' ),
					array( 'fa-regular fa-angle-90' => 'angle-90' ),
					array( 'fa-regular fa-angle-down' => 'angle-down' ),
					array( 'fa-regular fa-angle-left' => 'angle-left' ),
					array( 'fa-regular fa-angle-right' => 'angle-right' ),
					array( 'fa-regular fa-angle-up' => 'angle-up' ),
					array( 'fa-regular fa-angle' => 'angle' ),
					array( 'fa-regular fa-angles-down' => 'angles-down' ),
					array( 'fa-regular fa-angles-left' => 'angles-left' ),
					array( 'fa-regular fa-angles-right' => 'angles-right' ),
					array( 'fa-regular fa-angles-up-down' => 'angles-up-down' ),
					array( 'fa-regular fa-angles-up' => 'angles-up' ),
					array( 'fa-regular fa-ankh' => 'ankh' ),
					array( 'fa-regular fa-apartment' => 'apartment' ),
					array( 'fa-regular fa-aperture' => 'aperture' ),
					array( 'fa-regular fa-apostrophe' => 'apostrophe' ),
					array( 'fa-regular fa-apple-core' => 'apple-core' ),
					array( 'fa-regular fa-apple-whole' => 'apple-whole' ),
					array( 'fa-regular fa-archway' => 'archway' ),
					array( 'fa-regular fa-arrow-down-1-9' => 'arrow-down-1-9' ),
					array( 'fa-regular fa-arrow-down-9-1' => 'arrow-down-9-1' ),
					array( 'fa-regular fa-arrow-down-a-z' => 'arrow-down-a-z' ),
					array( 'fa-regular fa-arrow-down-arrow-up' => 'arrow-down-arrow-up' ),
					array( 'fa-regular fa-arrow-down-big-small' => 'arrow-down-big-small' ),
					array( 'fa-regular fa-arrow-down-from-arc' => 'arrow-down-from-arc' ),
					array( 'fa-regular fa-arrow-down-from-dotted-line' => 'arrow-down-from-dotted-line' ),
					array( 'fa-regular fa-arrow-down-from-line' => 'arrow-down-from-line' ),
					array( 'fa-regular fa-arrow-down-left-and-arrow-up-right-to-center' => 'arrow-down-left-and-arrow-up-right-to-center' ),
					array( 'fa-regular fa-arrow-down-left' => 'arrow-down-left' ),
					array( 'fa-regular fa-arrow-down-long' => 'arrow-down-long' ),
					array( 'fa-regular fa-arrow-down-right' => 'arrow-down-right' ),
					array( 'fa-regular fa-arrow-down-short-wide' => 'arrow-down-short-wide' ),
					array( 'fa-regular fa-arrow-down-small-big' => 'arrow-down-small-big' ),
					array( 'fa-regular fa-arrow-down-square-triangle' => 'arrow-down-square-triangle' ),
					array( 'fa-regular fa-arrow-down-to-arc' => 'arrow-down-to-arc' ),
					array( 'fa-regular fa-arrow-down-to-bracket' => 'arrow-down-to-bracket' ),
					array( 'fa-regular fa-arrow-down-to-dotted-line' => 'arrow-down-to-dotted-line' ),
					array( 'fa-regular fa-arrow-down-to-line' => 'arrow-down-to-line' ),
					array( 'fa-regular fa-arrow-down-to-square' => 'arrow-down-to-square' ),
					array( 'fa-regular fa-arrow-down-triangle-square' => 'arrow-down-triangle-square' ),
					array( 'fa-regular fa-arrow-down-up-across-line' => 'arrow-down-up-across-line' ),
					array( 'fa-regular fa-arrow-down-up-lock' => 'arrow-down-up-lock' ),
					array( 'fa-regular fa-arrow-down-wide-short' => 'arrow-down-wide-short' ),
					array( 'fa-regular fa-arrow-down-z-a' => 'arrow-down-z-a' ),
					array( 'fa-regular fa-arrow-down' => 'arrow-down' ),
					array( 'fa-regular fa-arrow-left-from-arc' => 'arrow-left-from-arc' ),
					array( 'fa-regular fa-arrow-left-from-line' => 'arrow-left-from-line' ),
					array( 'fa-regular fa-arrow-left-long-to-line' => 'arrow-left-long-to-line' ),
					array( 'fa-regular fa-arrow-left-long' => 'arrow-left-long' ),
					array( 'fa-regular fa-arrow-left-to-arc' => 'arrow-left-to-arc' ),
					array( 'fa-regular fa-arrow-left-to-line' => 'arrow-left-to-line' ),
					array( 'fa-regular fa-arrow-left' => 'arrow-left' ),
					array( 'fa-regular fa-arrow-pointer' => 'arrow-pointer' ),
					array( 'fa-regular fa-arrow-progress' => 'arrow-progress' ),
					array( 'fa-regular fa-arrow-right-arrow-left' => 'arrow-right-arrow-left' ),
					array( 'fa-regular fa-arrow-right-from-arc' => 'arrow-right-from-arc' ),
					array( 'fa-regular fa-arrow-right-from-bracket' => 'arrow-right-from-bracket' ),
					array( 'fa-regular fa-arrow-right-from-line' => 'arrow-right-from-line' ),
					array( 'fa-regular fa-arrow-right-long-to-line' => 'arrow-right-long-to-line' ),
					array( 'fa-regular fa-arrow-right-long' => 'arrow-right-long' ),
					array( 'fa-regular fa-arrow-right-to-arc' => 'arrow-right-to-arc' ),
					array( 'fa-regular fa-arrow-right-to-bracket' => 'arrow-right-to-bracket' ),
					array( 'fa-regular fa-arrow-right-to-city' => 'arrow-right-to-city' ),
					array( 'fa-regular fa-arrow-right-to-line' => 'arrow-right-to-line' ),
					array( 'fa-regular fa-arrow-right' => 'arrow-right' ),
					array( 'fa-regular fa-arrow-rotate-left' => 'arrow-rotate-left' ),
					array( 'fa-regular fa-arrow-rotate-right' => 'arrow-rotate-right' ),
					array( 'fa-regular fa-arrow-trend-down' => 'arrow-trend-down' ),
					array( 'fa-regular fa-arrow-trend-up' => 'arrow-trend-up' ),
					array( 'fa-regular fa-arrow-turn-down-left' => 'arrow-turn-down-left' ),
					array( 'fa-regular fa-arrow-turn-down-right' => 'arrow-turn-down-right' ),
					array( 'fa-regular fa-arrow-turn-down' => 'arrow-turn-down' ),
					array( 'fa-regular fa-arrow-turn-up' => 'arrow-turn-up' ),
					array( 'fa-regular fa-arrow-up-1-9' => 'arrow-up-1-9' ),
					array( 'fa-regular fa-arrow-up-9-1' => 'arrow-up-9-1' ),
					array( 'fa-regular fa-arrow-up-a-z' => 'arrow-up-a-z' ),
					array( 'fa-regular fa-arrow-up-arrow-down' => 'arrow-up-arrow-down' ),
					array( 'fa-regular fa-arrow-up-big-small' => 'arrow-up-big-small' ),
					array( 'fa-regular fa-arrow-up-from-arc' => 'arrow-up-from-arc' ),
					array( 'fa-regular fa-arrow-up-from-bracket' => 'arrow-up-from-bracket' ),
					array( 'fa-regular fa-arrow-up-from-dotted-line' => 'arrow-up-from-dotted-line' ),
					array( 'fa-regular fa-arrow-up-from-ground-water' => 'arrow-up-from-ground-water' ),
					array( 'fa-regular fa-arrow-up-from-line' => 'arrow-up-from-line' ),
					array( 'fa-regular fa-arrow-up-from-square' => 'arrow-up-from-square' ),
					array( 'fa-regular fa-arrow-up-from-water-pump' => 'arrow-up-from-water-pump' ),
					array( 'fa-regular fa-arrow-up-left-from-circle' => 'arrow-up-left-from-circle' ),
					array( 'fa-regular fa-arrow-up-left' => 'arrow-up-left' ),
					array( 'fa-regular fa-arrow-up-long' => 'arrow-up-long' ),
					array( 'fa-regular fa-arrow-up-right-and-arrow-down-left-from-center' => 'arrow-up-right-and-arrow-down-left-from-center' ),
					array( 'fa-regular fa-arrow-up-right-dots' => 'arrow-up-right-dots' ),
					array( 'fa-regular fa-arrow-up-right-from-square' => 'arrow-up-right-from-square' ),
					array( 'fa-regular fa-arrow-up-right' => 'arrow-up-right' ),
					array( 'fa-regular fa-arrow-up-short-wide' => 'arrow-up-short-wide' ),
					array( 'fa-regular fa-arrow-up-small-big' => 'arrow-up-small-big' ),
					array( 'fa-regular fa-arrow-up-square-triangle' => 'arrow-up-square-triangle' ),
					array( 'fa-regular fa-arrow-up-to-arc' => 'arrow-up-to-arc' ),
					array( 'fa-regular fa-arrow-up-to-dotted-line' => 'arrow-up-to-dotted-line' ),
					array( 'fa-regular fa-arrow-up-to-line' => 'arrow-up-to-line' ),
					array( 'fa-regular fa-arrow-up-triangle-square' => 'arrow-up-triangle-square' ),
					array( 'fa-regular fa-arrow-up-wide-short' => 'arrow-up-wide-short' ),
					array( 'fa-regular fa-arrow-up-z-a' => 'arrow-up-z-a' ),
					array( 'fa-regular fa-arrow-up' => 'arrow-up' ),
					array( 'fa-regular fa-arrows-cross' => 'arrows-cross' ),
					array( 'fa-regular fa-arrows-down-to-line' => 'arrows-down-to-line' ),
					array( 'fa-regular fa-arrows-down-to-people' => 'arrows-down-to-people' ),
					array( 'fa-regular fa-arrows-from-dotted-line' => 'arrows-from-dotted-line' ),
					array( 'fa-regular fa-arrows-from-line' => 'arrows-from-line' ),
					array( 'fa-regular fa-arrows-left-right-to-line' => 'arrows-left-right-to-line' ),
					array( 'fa-regular fa-arrows-left-right' => 'arrows-left-right' ),
					array( 'fa-regular fa-arrows-maximize' => 'arrows-maximize' ),
					array( 'fa-regular fa-arrows-minimize' => 'arrows-minimize' ),
					array( 'fa-regular fa-arrows-repeat-1' => 'arrows-repeat-1' ),
					array( 'fa-regular fa-arrows-repeat' => 'arrows-repeat' ),
					array( 'fa-regular fa-arrows-retweet' => 'arrows-retweet' ),
					array( 'fa-regular fa-arrows-rotate' => 'arrows-rotate' ),
					array( 'fa-regular fa-arrows-spin' => 'arrows-spin' ),
					array( 'fa-regular fa-arrows-split-up-and-left' => 'arrows-split-up-and-left' ),
					array( 'fa-regular fa-arrows-to-circle' => 'arrows-to-circle' ),
					array( 'fa-regular fa-arrows-to-dot' => 'arrows-to-dot' ),
					array( 'fa-regular fa-arrows-to-dotted-line' => 'arrows-to-dotted-line' ),
					array( 'fa-regular fa-arrows-to-eye' => 'arrows-to-eye' ),
					array( 'fa-regular fa-arrows-to-line' => 'arrows-to-line' ),
					array( 'fa-regular fa-arrows-turn-right' => 'arrows-turn-right' ),
					array( 'fa-regular fa-arrows-turn-to-dots' => 'arrows-turn-to-dots' ),
					array( 'fa-regular fa-arrows-up-down-left-right' => 'arrows-up-down-left-right' ),
					array( 'fa-regular fa-arrows-up-down' => 'arrows-up-down' ),
					array( 'fa-regular fa-arrows-up-to-line' => 'arrows-up-to-line' ),
					array( 'fa-regular fa-asterisk' => 'asterisk' ),
					array( 'fa-regular fa-at' => 'at' ),
					array( 'fa-regular fa-atom-simple' => 'atom-simple' ),
					array( 'fa-regular fa-atom' => 'atom' ),
					array( 'fa-regular fa-audio-description-slash' => 'audio-description-slash' ),
					array( 'fa-regular fa-audio-description' => 'audio-description' ),
					array( 'fa-regular fa-austral-sign' => 'austral-sign' ),
					array( 'fa-regular fa-avocado' => 'avocado' ),
					array( 'fa-regular fa-award-simple' => 'award-simple' ),
					array( 'fa-regular fa-award' => 'award' ),
					array( 'fa-regular fa-axe-battle' => 'axe-battle' ),
					array( 'fa-regular fa-axe' => 'axe' ),
					array( 'fa-regular fa-b' => 'b' ),
					array( 'fa-regular fa-baby-carriage' => 'baby-carriage' ),
					array( 'fa-regular fa-baby' => 'baby' ),
					array( 'fa-regular fa-backpack' => 'backpack' ),
					array( 'fa-regular fa-backward-fast' => 'backward-fast' ),
					array( 'fa-regular fa-backward-step' => 'backward-step' ),
					array( 'fa-regular fa-backward' => 'backward' ),
					array( 'fa-regular fa-bacon' => 'bacon' ),
					array( 'fa-regular fa-bacteria' => 'bacteria' ),
					array( 'fa-regular fa-bacterium' => 'bacterium' ),
					array( 'fa-regular fa-badge-check' => 'badge-check' ),
					array( 'fa-regular fa-badge-dollar' => 'badge-dollar' ),
					array( 'fa-regular fa-badge-percent' => 'badge-percent' ),
					array( 'fa-regular fa-badge-sheriff' => 'badge-sheriff' ),
					array( 'fa-regular fa-badge' => 'badge' ),
					array( 'fa-regular fa-badger-honey' => 'badger-honey' ),
					array( 'fa-regular fa-badminton' => 'badminton' ),
					array( 'fa-regular fa-bag-seedling' => 'bag-seedling' ),
					array( 'fa-regular fa-bag-shopping' => 'bag-shopping' ),
					array( 'fa-regular fa-bagel' => 'bagel' ),
					array( 'fa-regular fa-bags-shopping' => 'bags-shopping' ),
					array( 'fa-regular fa-baguette' => 'baguette' ),
					array( 'fa-regular fa-bahai' => 'bahai' ),
					array( 'fa-regular fa-baht-sign' => 'baht-sign' ),
					array( 'fa-regular fa-ball-pile' => 'ball-pile' ),
					array( 'fa-regular fa-balloon' => 'balloon' ),
					array( 'fa-regular fa-balloons' => 'balloons' ),
					array( 'fa-regular fa-ballot-check' => 'ballot-check' ),
					array( 'fa-regular fa-ballot' => 'ballot' ),
					array( 'fa-regular fa-ban-bug' => 'ban-bug' ),
					array( 'fa-regular fa-ban-parking' => 'ban-parking' ),
					array( 'fa-regular fa-ban-smoking' => 'ban-smoking' ),
					array( 'fa-regular fa-ban' => 'ban' ),
					array( 'fa-regular fa-banana' => 'banana' ),
					array( 'fa-regular fa-bandage' => 'bandage' ),
					array( 'fa-regular fa-bangladeshi-taka-sign' => 'bangladeshi-taka-sign' ),
					array( 'fa-regular fa-banjo' => 'banjo' ),
					array( 'fa-regular fa-barcode-read' => 'barcode-read' ),
					array( 'fa-regular fa-barcode-scan' => 'barcode-scan' ),
					array( 'fa-regular fa-barcode' => 'barcode' ),
					array( 'fa-regular fa-bars-filter' => 'bars-filter' ),
					array( 'fa-regular fa-bars-progress' => 'bars-progress' ),
					array( 'fa-regular fa-bars-sort' => 'bars-sort' ),
					array( 'fa-regular fa-bars-staggered' => 'bars-staggered' ),
					array( 'fa-regular fa-bars' => 'bars' ),
					array( 'fa-regular fa-baseball-bat-ball' => 'baseball-bat-ball' ),
					array( 'fa-regular fa-baseball' => 'baseball' ),
					array( 'fa-regular fa-basket-shopping-simple' => 'basket-shopping-simple' ),
					array( 'fa-regular fa-basket-shopping' => 'basket-shopping' ),
					array( 'fa-regular fa-basketball-hoop' => 'basketball-hoop' ),
					array( 'fa-regular fa-basketball' => 'basketball' ),
					array( 'fa-regular fa-bat' => 'bat' ),
					array( 'fa-regular fa-bath' => 'bath' ),
					array( 'fa-regular fa-battery-bolt' => 'battery-bolt' ),
					array( 'fa-regular fa-battery-empty' => 'battery-empty' ),
					array( 'fa-regular fa-battery-exclamation' => 'battery-exclamation' ),
					array( 'fa-regular fa-battery-full' => 'battery-full' ),
					array( 'fa-regular fa-battery-half' => 'battery-half' ),
					array( 'fa-regular fa-battery-low' => 'battery-low' ),
					array( 'fa-regular fa-battery-quarter' => 'battery-quarter' ),
					array( 'fa-regular fa-battery-slash' => 'battery-slash' ),
					array( 'fa-regular fa-battery-three-quarters' => 'battery-three-quarters' ),
					array( 'fa-regular fa-bed-bunk' => 'bed-bunk' ),
					array( 'fa-regular fa-bed-empty' => 'bed-empty' ),
					array( 'fa-regular fa-bed-front' => 'bed-front' ),
					array( 'fa-regular fa-bed-pulse' => 'bed-pulse' ),
					array( 'fa-regular fa-bed' => 'bed' ),
					array( 'fa-regular fa-bee' => 'bee' ),
					array( 'fa-regular fa-beer-mug-empty' => 'beer-mug-empty' ),
					array( 'fa-regular fa-beer-mug' => 'beer-mug' ),
					array( 'fa-regular fa-bell-concierge' => 'bell-concierge' ),
					array( 'fa-regular fa-bell-exclamation' => 'bell-exclamation' ),
					array( 'fa-regular fa-bell-on' => 'bell-on' ),
					array( 'fa-regular fa-bell-plus' => 'bell-plus' ),
					array( 'fa-regular fa-bell-school-slash' => 'bell-school-slash' ),
					array( 'fa-regular fa-bell-school' => 'bell-school' ),
					array( 'fa-regular fa-bell-slash' => 'bell-slash' ),
					array( 'fa-regular fa-bell' => 'bell' ),
					array( 'fa-regular fa-bells' => 'bells' ),
					array( 'fa-regular fa-bench-tree' => 'bench-tree' ),
					array( 'fa-regular fa-bezier-curve' => 'bezier-curve' ),
					array( 'fa-regular fa-bicycle' => 'bicycle' ),
					array( 'fa-regular fa-billboard' => 'billboard' ),
					array( 'fa-regular fa-bin-bottles-recycle' => 'bin-bottles-recycle' ),
					array( 'fa-regular fa-bin-bottles' => 'bin-bottles' ),
					array( 'fa-regular fa-bin-recycle' => 'bin-recycle' ),
					array( 'fa-regular fa-binary-circle-check' => 'binary-circle-check' ),
					array( 'fa-regular fa-binary-lock' => 'binary-lock' ),
					array( 'fa-regular fa-binary-slash' => 'binary-slash' ),
					array( 'fa-regular fa-binary' => 'binary' ),
					array( 'fa-regular fa-binoculars' => 'binoculars' ),
					array( 'fa-regular fa-biohazard' => 'biohazard' ),
					array( 'fa-regular fa-bird' => 'bird' ),
					array( 'fa-regular fa-bitcoin-sign' => 'bitcoin-sign' ),
					array( 'fa-regular fa-blanket-fire' => 'blanket-fire' ),
					array( 'fa-regular fa-blanket' => 'blanket' ),
					array( 'fa-regular fa-blender-phone' => 'blender-phone' ),
					array( 'fa-regular fa-blender' => 'blender' ),
					array( 'fa-regular fa-blinds-open' => 'blinds-open' ),
					array( 'fa-regular fa-blinds-raised' => 'blinds-raised' ),
					array( 'fa-regular fa-blinds' => 'blinds' ),
					array( 'fa-regular fa-block-brick-fire' => 'block-brick-fire' ),
					array( 'fa-regular fa-block-brick' => 'block-brick' ),
					array( 'fa-regular fa-block-question' => 'block-question' ),
					array( 'fa-regular fa-block-quote' => 'block-quote' ),
					array( 'fa-regular fa-block' => 'block' ),
					array( 'fa-regular fa-blog' => 'blog' ),
					array( 'fa-regular fa-blueberries' => 'blueberries' ),
					array( 'fa-regular fa-bluetooth' => 'bluetooth' ),
					array( 'fa-regular fa-bold' => 'bold' ),
					array( 'fa-regular fa-bolt-auto' => 'bolt-auto' ),
					array( 'fa-regular fa-bolt-lightning' => 'bolt-lightning' ),
					array( 'fa-regular fa-bolt-slash' => 'bolt-slash' ),
					array( 'fa-regular fa-bolt' => 'bolt' ),
					array( 'fa-regular fa-bomb' => 'bomb' ),
					array( 'fa-regular fa-bone-break' => 'bone-break' ),
					array( 'fa-regular fa-bone' => 'bone' ),
					array( 'fa-regular fa-bong' => 'bong' ),
					array( 'fa-regular fa-book-arrow-right' => 'book-arrow-right' ),
					array( 'fa-regular fa-book-arrow-up' => 'book-arrow-up' ),
					array( 'fa-regular fa-book-atlas' => 'book-atlas' ),
					array( 'fa-regular fa-book-bible' => 'book-bible' ),
					array( 'fa-regular fa-book-blank' => 'book-blank' ),
					array( 'fa-regular fa-book-bookmark' => 'book-bookmark' ),
					array( 'fa-regular fa-book-circle-arrow-right' => 'book-circle-arrow-right' ),
					array( 'fa-regular fa-book-circle-arrow-up' => 'book-circle-arrow-up' ),
					array( 'fa-regular fa-book-copy' => 'book-copy' ),
					array( 'fa-regular fa-book-font' => 'book-font' ),
					array( 'fa-regular fa-book-heart' => 'book-heart' ),
					array( 'fa-regular fa-book-journal-whills' => 'book-journal-whills' ),
					array( 'fa-regular fa-book-medical' => 'book-medical' ),
					array( 'fa-regular fa-book-open-cover' => 'book-open-cover' ),
					array( 'fa-regular fa-book-open-reader' => 'book-open-reader' ),
					array( 'fa-regular fa-book-open' => 'book-open' ),
					array( 'fa-regular fa-book-quran' => 'book-quran' ),
					array( 'fa-regular fa-book-section' => 'book-section' ),
					array( 'fa-regular fa-book-skull' => 'book-skull' ),
					array( 'fa-regular fa-book-sparkles' => 'book-sparkles' ),
					array( 'fa-regular fa-book-tanakh' => 'book-tanakh' ),
					array( 'fa-regular fa-book-user' => 'book-user' ),
					array( 'fa-regular fa-book' => 'book' ),
					array( 'fa-regular fa-bookmark-slash' => 'bookmark-slash' ),
					array( 'fa-regular fa-bookmark' => 'bookmark' ),
					array( 'fa-regular fa-books-medical' => 'books-medical' ),
					array( 'fa-regular fa-books' => 'books' ),
					array( 'fa-regular fa-boombox' => 'boombox' ),
					array( 'fa-regular fa-boot-heeled' => 'boot-heeled' ),
					array( 'fa-regular fa-boot' => 'boot' ),
					array( 'fa-regular fa-booth-curtain' => 'booth-curtain' ),
					array( 'fa-regular fa-border-all' => 'border-all' ),
					array( 'fa-regular fa-border-bottom-right' => 'border-bottom-right' ),
					array( 'fa-regular fa-border-bottom' => 'border-bottom' ),
					array( 'fa-regular fa-border-center-h' => 'border-center-h' ),
					array( 'fa-regular fa-border-center-v' => 'border-center-v' ),
					array( 'fa-regular fa-border-inner' => 'border-inner' ),
					array( 'fa-regular fa-border-left' => 'border-left' ),
					array( 'fa-regular fa-border-none' => 'border-none' ),
					array( 'fa-regular fa-border-outer' => 'border-outer' ),
					array( 'fa-regular fa-border-right' => 'border-right' ),
					array( 'fa-regular fa-border-top-left' => 'border-top-left' ),
					array( 'fa-regular fa-border-top' => 'border-top' ),
					array( 'fa-regular fa-bore-hole' => 'bore-hole' ),
					array( 'fa-regular fa-bottle-droplet' => 'bottle-droplet' ),
					array( 'fa-regular fa-bottle-water' => 'bottle-water' ),
					array( 'fa-regular fa-bow-arrow' => 'bow-arrow' ),
					array( 'fa-regular fa-bowl-chopsticks-noodles' => 'bowl-chopsticks-noodles' ),
					array( 'fa-regular fa-bowl-chopsticks' => 'bowl-chopsticks' ),
					array( 'fa-regular fa-bowl-food' => 'bowl-food' ),
					array( 'fa-regular fa-bowl-hot' => 'bowl-hot' ),
					array( 'fa-regular fa-bowl-rice' => 'bowl-rice' ),
					array( 'fa-regular fa-bowl-scoop' => 'bowl-scoop' ),
					array( 'fa-regular fa-bowl-scoops' => 'bowl-scoops' ),
					array( 'fa-regular fa-bowl-soft-serve' => 'bowl-soft-serve' ),
					array( 'fa-regular fa-bowl-spoon' => 'bowl-spoon' ),
					array( 'fa-regular fa-bowling-ball-pin' => 'bowling-ball-pin' ),
					array( 'fa-regular fa-bowling-ball' => 'bowling-ball' ),
					array( 'fa-regular fa-bowling-pins' => 'bowling-pins' ),
					array( 'fa-regular fa-box-archive' => 'box-archive' ),
					array( 'fa-regular fa-box-ballot' => 'box-ballot' ),
					array( 'fa-regular fa-box-check' => 'box-check' ),
					array( 'fa-regular fa-box-circle-check' => 'box-circle-check' ),
					array( 'fa-regular fa-box-dollar' => 'box-dollar' ),
					array( 'fa-regular fa-box-heart' => 'box-heart' ),
					array( 'fa-regular fa-box-open-full' => 'box-open-full' ),
					array( 'fa-regular fa-box-open' => 'box-open' ),
					array( 'fa-regular fa-box-taped' => 'box-taped' ),
					array( 'fa-regular fa-box-tissue' => 'box-tissue' ),
					array( 'fa-regular fa-box' => 'box' ),
					array( 'fa-regular fa-boxes-packing' => 'boxes-packing' ),
					array( 'fa-regular fa-boxes-stacked' => 'boxes-stacked' ),
					array( 'fa-regular fa-boxing-glove' => 'boxing-glove' ),
					array( 'fa-regular fa-bracket-curly-right' => 'bracket-curly-right' ),
					array( 'fa-regular fa-bracket-curly' => 'bracket-curly' ),
					array( 'fa-regular fa-bracket-round-right' => 'bracket-round-right' ),
					array( 'fa-regular fa-bracket-round' => 'bracket-round' ),
					array( 'fa-regular fa-bracket-square-right' => 'bracket-square-right' ),
					array( 'fa-regular fa-bracket-square' => 'bracket-square' ),
					array( 'fa-regular fa-brackets-curly' => 'brackets-curly' ),
					array( 'fa-regular fa-brackets-round' => 'brackets-round' ),
					array( 'fa-regular fa-brackets-square' => 'brackets-square' ),
					array( 'fa-regular fa-braille' => 'braille' ),
					array( 'fa-regular fa-brain-arrow-curved-right' => 'brain-arrow-curved-right' ),
					array( 'fa-regular fa-brain-circuit' => 'brain-circuit' ),
					array( 'fa-regular fa-brain' => 'brain' ),
					array( 'fa-regular fa-brake-warning' => 'brake-warning' ),
					array( 'fa-regular fa-brazilian-real-sign' => 'brazilian-real-sign' ),
					array( 'fa-regular fa-bread-loaf' => 'bread-loaf' ),
					array( 'fa-regular fa-bread-slice-butter' => 'bread-slice-butter' ),
					array( 'fa-regular fa-bread-slice' => 'bread-slice' ),
					array( 'fa-regular fa-bridge-circle-check' => 'bridge-circle-check' ),
					array( 'fa-regular fa-bridge-circle-exclamation' => 'bridge-circle-exclamation' ),
					array( 'fa-regular fa-bridge-circle-xmark' => 'bridge-circle-xmark' ),
					array( 'fa-regular fa-bridge-lock' => 'bridge-lock' ),
					array( 'fa-regular fa-bridge-suspension' => 'bridge-suspension' ),
					array( 'fa-regular fa-bridge-water' => 'bridge-water' ),
					array( 'fa-regular fa-bridge' => 'bridge' ),
					array( 'fa-regular fa-briefcase-arrow-right' => 'briefcase-arrow-right' ),
					array( 'fa-regular fa-briefcase-blank' => 'briefcase-blank' ),
					array( 'fa-regular fa-briefcase-medical' => 'briefcase-medical' ),
					array( 'fa-regular fa-briefcase' => 'briefcase' ),
					array( 'fa-regular fa-brightness-low' => 'brightness-low' ),
					array( 'fa-regular fa-brightness' => 'brightness' ),
					array( 'fa-regular fa-bring-forward' => 'bring-forward' ),
					array( 'fa-regular fa-bring-front' => 'bring-front' ),
					array( 'fa-regular fa-broccoli' => 'broccoli' ),
					array( 'fa-regular fa-broom-ball' => 'broom-ball' ),
					array( 'fa-regular fa-broom-wide' => 'broom-wide' ),
					array( 'fa-regular fa-broom' => 'broom' ),
					array( 'fa-regular fa-browser' => 'browser' ),
					array( 'fa-regular fa-browsers' => 'browsers' ),
					array( 'fa-regular fa-brush' => 'brush' ),
					array( 'fa-regular fa-bucket' => 'bucket' ),
					array( 'fa-regular fa-bug-slash' => 'bug-slash' ),
					array( 'fa-regular fa-bug' => 'bug' ),
					array( 'fa-regular fa-bugs' => 'bugs' ),
					array( 'fa-regular fa-building-circle-arrow-right' => 'building-circle-arrow-right' ),
					array( 'fa-regular fa-building-circle-check' => 'building-circle-check' ),
					array( 'fa-regular fa-building-circle-exclamation' => 'building-circle-exclamation' ),
					array( 'fa-regular fa-building-circle-xmark' => 'building-circle-xmark' ),
					array( 'fa-regular fa-building-columns' => 'building-columns' ),
					array( 'fa-regular fa-building-flag' => 'building-flag' ),
					array( 'fa-regular fa-building-lock' => 'building-lock' ),
					array( 'fa-regular fa-building-ngo' => 'building-ngo' ),
					array( 'fa-regular fa-building-shield' => 'building-shield' ),
					array( 'fa-regular fa-building-un' => 'building-un' ),
					array( 'fa-regular fa-building-user' => 'building-user' ),
					array( 'fa-regular fa-building-wheat' => 'building-wheat' ),
					array( 'fa-regular fa-building' => 'building' ),
					array( 'fa-regular fa-buildings' => 'buildings' ),
					array( 'fa-regular fa-bullhorn' => 'bullhorn' ),
					array( 'fa-regular fa-bullseye-arrow' => 'bullseye-arrow' ),
					array( 'fa-regular fa-bullseye-pointer' => 'bullseye-pointer' ),
					array( 'fa-regular fa-bullseye' => 'bullseye' ),
					array( 'fa-regular fa-buoy-mooring' => 'buoy-mooring' ),
					array( 'fa-regular fa-buoy' => 'buoy' ),
					array( 'fa-regular fa-burger-cheese' => 'burger-cheese' ),
					array( 'fa-regular fa-burger-fries' => 'burger-fries' ),
					array( 'fa-regular fa-burger-glass' => 'burger-glass' ),
					array( 'fa-regular fa-burger-lettuce' => 'burger-lettuce' ),
					array( 'fa-regular fa-burger-soda' => 'burger-soda' ),
					array( 'fa-regular fa-burger' => 'burger' ),
					array( 'fa-regular fa-burrito' => 'burrito' ),
					array( 'fa-regular fa-burst' => 'burst' ),
					array( 'fa-regular fa-bus-school' => 'bus-school' ),
					array( 'fa-regular fa-bus-simple' => 'bus-simple' ),
					array( 'fa-regular fa-bus' => 'bus' ),
					array( 'fa-regular fa-business-time' => 'business-time' ),
					array( 'fa-regular fa-butter' => 'butter' ),
					array( 'fa-regular fa-c' => 'c' ),
					array( 'fa-regular fa-cabin' => 'cabin' ),
					array( 'fa-regular fa-cabinet-filing' => 'cabinet-filing' ),
					array( 'fa-regular fa-cable-car' => 'cable-car' ),
					array( 'fa-regular fa-cactus' => 'cactus' ),
					array( 'fa-regular fa-cake-candles' => 'cake-candles' ),
					array( 'fa-regular fa-cake-slice' => 'cake-slice' ),
					array( 'fa-regular fa-calculator-simple' => 'calculator-simple' ),
					array( 'fa-regular fa-calculator' => 'calculator' ),
					array( 'fa-regular fa-calendar-arrow-down' => 'calendar-arrow-down' ),
					array( 'fa-regular fa-calendar-arrow-up' => 'calendar-arrow-up' ),
					array( 'fa-regular fa-calendar-check' => 'calendar-check' ),
					array( 'fa-regular fa-calendar-circle-exclamation' => 'calendar-circle-exclamation' ),
					array( 'fa-regular fa-calendar-circle-minus' => 'calendar-circle-minus' ),
					array( 'fa-regular fa-calendar-circle-plus' => 'calendar-circle-plus' ),
					array( 'fa-regular fa-calendar-circle-user' => 'calendar-circle-user' ),
					array( 'fa-regular fa-calendar-clock' => 'calendar-clock' ),
					array( 'fa-regular fa-calendar-day' => 'calendar-day' ),
					array( 'fa-regular fa-calendar-days' => 'calendar-days' ),
					array( 'fa-regular fa-calendar-exclamation' => 'calendar-exclamation' ),
					array( 'fa-regular fa-calendar-heart' => 'calendar-heart' ),
					array( 'fa-regular fa-calendar-image' => 'calendar-image' ),
					array( 'fa-regular fa-calendar-lines-pen' => 'calendar-lines-pen' ),
					array( 'fa-regular fa-calendar-lines' => 'calendar-lines' ),
					array( 'fa-regular fa-calendar-minus' => 'calendar-minus' ),
					array( 'fa-regular fa-calendar-pen' => 'calendar-pen' ),
					array( 'fa-regular fa-calendar-plus' => 'calendar-plus' ),
					array( 'fa-regular fa-calendar-range' => 'calendar-range' ),
					array( 'fa-regular fa-calendar-star' => 'calendar-star' ),
					array( 'fa-regular fa-calendar-users' => 'calendar-users' ),
					array( 'fa-regular fa-calendar-week' => 'calendar-week' ),
					array( 'fa-regular fa-calendar-xmark' => 'calendar-xmark' ),
					array( 'fa-regular fa-calendar' => 'calendar' ),
					array( 'fa-regular fa-calendars' => 'calendars' ),
					array( 'fa-regular fa-camcorder' => 'camcorder' ),
					array( 'fa-regular fa-camera-cctv' => 'camera-cctv' ),
					array( 'fa-regular fa-camera-movie' => 'camera-movie' ),
					array( 'fa-regular fa-camera-polaroid' => 'camera-polaroid' ),
					array( 'fa-regular fa-camera-retro' => 'camera-retro' ),
					array( 'fa-regular fa-camera-rotate' => 'camera-rotate' ),
					array( 'fa-regular fa-camera-security' => 'camera-security' ),
					array( 'fa-regular fa-camera-slash' => 'camera-slash' ),
					array( 'fa-regular fa-camera-viewfinder' => 'camera-viewfinder' ),
					array( 'fa-regular fa-camera-web-slash' => 'camera-web-slash' ),
					array( 'fa-regular fa-camera-web' => 'camera-web' ),
					array( 'fa-regular fa-camera' => 'camera' ),
					array( 'fa-regular fa-campfire' => 'campfire' ),
					array( 'fa-regular fa-campground' => 'campground' ),
					array( 'fa-regular fa-can-food' => 'can-food' ),
					array( 'fa-regular fa-candle-holder' => 'candle-holder' ),
					array( 'fa-regular fa-candy-bar' => 'candy-bar' ),
					array( 'fa-regular fa-candy-cane' => 'candy-cane' ),
					array( 'fa-regular fa-candy-corn' => 'candy-corn' ),
					array( 'fa-regular fa-candy' => 'candy' ),
					array( 'fa-regular fa-cannabis' => 'cannabis' ),
					array( 'fa-regular fa-capsules' => 'capsules' ),
					array( 'fa-regular fa-car-battery' => 'car-battery' ),
					array( 'fa-regular fa-car-bolt' => 'car-bolt' ),
					array( 'fa-regular fa-car-building' => 'car-building' ),
					array( 'fa-regular fa-car-bump' => 'car-bump' ),
					array( 'fa-regular fa-car-burst' => 'car-burst' ),
					array( 'fa-regular fa-car-bus' => 'car-bus' ),
					array( 'fa-regular fa-car-circle-bolt' => 'car-circle-bolt' ),
					array( 'fa-regular fa-car-garage' => 'car-garage' ),
					array( 'fa-regular fa-car-mirrors' => 'car-mirrors' ),
					array( 'fa-regular fa-car-on' => 'car-on' ),
					array( 'fa-regular fa-car-rear' => 'car-rear' ),
					array( 'fa-regular fa-car-side-bolt' => 'car-side-bolt' ),
					array( 'fa-regular fa-car-side' => 'car-side' ),
					array( 'fa-regular fa-car-tilt' => 'car-tilt' ),
					array( 'fa-regular fa-car-tunnel' => 'car-tunnel' ),
					array( 'fa-regular fa-car-wash' => 'car-wash' ),
					array( 'fa-regular fa-car-wrench' => 'car-wrench' ),
					array( 'fa-regular fa-car' => 'car' ),
					array( 'fa-regular fa-caravan-simple' => 'caravan-simple' ),
					array( 'fa-regular fa-caravan' => 'caravan' ),
					array( 'fa-regular fa-card-club' => 'card-club' ),
					array( 'fa-regular fa-card-diamond' => 'card-diamond' ),
					array( 'fa-regular fa-card-heart' => 'card-heart' ),
					array( 'fa-regular fa-card-spade' => 'card-spade' ),
					array( 'fa-regular fa-cards-blank' => 'cards-blank' ),
					array( 'fa-regular fa-cards' => 'cards' ),
					array( 'fa-regular fa-caret-down' => 'caret-down' ),
					array( 'fa-regular fa-caret-left' => 'caret-left' ),
					array( 'fa-regular fa-caret-right' => 'caret-right' ),
					array( 'fa-regular fa-caret-up' => 'caret-up' ),
					array( 'fa-regular fa-carrot' => 'carrot' ),
					array( 'fa-regular fa-cars' => 'cars' ),
					array( 'fa-regular fa-cart-arrow-down' => 'cart-arrow-down' ),
					array( 'fa-regular fa-cart-arrow-up' => 'cart-arrow-up' ),
					array( 'fa-regular fa-cart-circle-arrow-down' => 'cart-circle-arrow-down' ),
					array( 'fa-regular fa-cart-circle-arrow-up' => 'cart-circle-arrow-up' ),
					array( 'fa-regular fa-cart-circle-check' => 'cart-circle-check' ),
					array( 'fa-regular fa-cart-circle-exclamation' => 'cart-circle-exclamation' ),
					array( 'fa-regular fa-cart-circle-plus' => 'cart-circle-plus' ),
					array( 'fa-regular fa-cart-circle-xmark' => 'cart-circle-xmark' ),
					array( 'fa-regular fa-cart-flatbed-boxes' => 'cart-flatbed-boxes' ),
					array( 'fa-regular fa-cart-flatbed-empty' => 'cart-flatbed-empty' ),
					array( 'fa-regular fa-cart-flatbed-suitcase' => 'cart-flatbed-suitcase' ),
					array( 'fa-regular fa-cart-flatbed' => 'cart-flatbed' ),
					array( 'fa-regular fa-cart-minus' => 'cart-minus' ),
					array( 'fa-regular fa-cart-plus' => 'cart-plus' ),
					array( 'fa-regular fa-cart-shopping-fast' => 'cart-shopping-fast' ),
					array( 'fa-regular fa-cart-shopping' => 'cart-shopping' ),
					array( 'fa-regular fa-cart-xmark' => 'cart-xmark' ),
					array( 'fa-regular fa-cash-register' => 'cash-register' ),
					array( 'fa-regular fa-cassette-betamax' => 'cassette-betamax' ),
					array( 'fa-regular fa-cassette-tape' => 'cassette-tape' ),
					array( 'fa-regular fa-cassette-vhs' => 'cassette-vhs' ),
					array( 'fa-regular fa-castle' => 'castle' ),
					array( 'fa-regular fa-cat-space' => 'cat-space' ),
					array( 'fa-regular fa-cat' => 'cat' ),
					array( 'fa-regular fa-cauldron' => 'cauldron' ),
					array( 'fa-regular fa-cedi-sign' => 'cedi-sign' ),
					array( 'fa-regular fa-cent-sign' => 'cent-sign' ),
					array( 'fa-regular fa-certificate' => 'certificate' ),
					array( 'fa-regular fa-chair-office' => 'chair-office' ),
					array( 'fa-regular fa-chair' => 'chair' ),
					array( 'fa-regular fa-chalkboard-user' => 'chalkboard-user' ),
					array( 'fa-regular fa-chalkboard' => 'chalkboard' ),
					array( 'fa-regular fa-champagne-glass' => 'champagne-glass' ),
					array( 'fa-regular fa-champagne-glasses' => 'champagne-glasses' ),
					array( 'fa-regular fa-charging-station' => 'charging-station' ),
					array( 'fa-regular fa-chart-area' => 'chart-area' ),
					array( 'fa-regular fa-chart-bar' => 'chart-bar' ),
					array( 'fa-regular fa-chart-bullet' => 'chart-bullet' ),
					array( 'fa-regular fa-chart-candlestick' => 'chart-candlestick' ),
					array( 'fa-regular fa-chart-column' => 'chart-column' ),
					array( 'fa-regular fa-chart-gantt' => 'chart-gantt' ),
					array( 'fa-regular fa-chart-line-down' => 'chart-line-down' ),
					array( 'fa-regular fa-chart-line-up-down' => 'chart-line-up-down' ),
					array( 'fa-regular fa-chart-line-up' => 'chart-line-up' ),
					array( 'fa-regular fa-chart-line' => 'chart-line' ),
					array( 'fa-regular fa-chart-mixed-up-circle-currency' => 'chart-mixed-up-circle-currency' ),
					array( 'fa-regular fa-chart-mixed-up-circle-dollar' => 'chart-mixed-up-circle-dollar' ),
					array( 'fa-regular fa-chart-mixed' => 'chart-mixed' ),
					array( 'fa-regular fa-chart-network' => 'chart-network' ),
					array( 'fa-regular fa-chart-pie-simple-circle-currency' => 'chart-pie-simple-circle-currency' ),
					array( 'fa-regular fa-chart-pie-simple-circle-dollar' => 'chart-pie-simple-circle-dollar' ),
					array( 'fa-regular fa-chart-pie-simple' => 'chart-pie-simple' ),
					array( 'fa-regular fa-chart-pie' => 'chart-pie' ),
					array( 'fa-regular fa-chart-pyramid' => 'chart-pyramid' ),
					array( 'fa-regular fa-chart-radar' => 'chart-radar' ),
					array( 'fa-regular fa-chart-scatter-3d' => 'chart-scatter-3d' ),
					array( 'fa-regular fa-chart-scatter-bubble' => 'chart-scatter-bubble' ),
					array( 'fa-regular fa-chart-scatter' => 'chart-scatter' ),
					array( 'fa-regular fa-chart-simple-horizontal' => 'chart-simple-horizontal' ),
					array( 'fa-regular fa-chart-simple' => 'chart-simple' ),
					array( 'fa-regular fa-chart-tree-map' => 'chart-tree-map' ),
					array( 'fa-regular fa-chart-user' => 'chart-user' ),
					array( 'fa-regular fa-chart-waterfall' => 'chart-waterfall' ),
					array( 'fa-regular fa-check-double' => 'check-double' ),
					array( 'fa-regular fa-check-to-slot' => 'check-to-slot' ),
					array( 'fa-regular fa-check' => 'check' ),
					array( 'fa-regular fa-cheese-swiss' => 'cheese-swiss' ),
					array( 'fa-regular fa-cheese' => 'cheese' ),
					array( 'fa-regular fa-cherries' => 'cherries' ),
					array( 'fa-regular fa-chess-bishop-piece' => 'chess-bishop-piece' ),
					array( 'fa-regular fa-chess-bishop' => 'chess-bishop' ),
					array( 'fa-regular fa-chess-board' => 'chess-board' ),
					array( 'fa-regular fa-chess-clock-flip' => 'chess-clock-flip' ),
					array( 'fa-regular fa-chess-clock' => 'chess-clock' ),
					array( 'fa-regular fa-chess-king-piece' => 'chess-king-piece' ),
					array( 'fa-regular fa-chess-king' => 'chess-king' ),
					array( 'fa-regular fa-chess-knight-piece' => 'chess-knight-piece' ),
					array( 'fa-regular fa-chess-knight' => 'chess-knight' ),
					array( 'fa-regular fa-chess-pawn-piece' => 'chess-pawn-piece' ),
					array( 'fa-regular fa-chess-pawn' => 'chess-pawn' ),
					array( 'fa-regular fa-chess-queen-piece' => 'chess-queen-piece' ),
					array( 'fa-regular fa-chess-queen' => 'chess-queen' ),
					array( 'fa-regular fa-chess-rook-piece' => 'chess-rook-piece' ),
					array( 'fa-regular fa-chess-rook' => 'chess-rook' ),
					array( 'fa-regular fa-chess' => 'chess' ),
					array( 'fa-regular fa-chestnut' => 'chestnut' ),
					array( 'fa-regular fa-chevron-down' => 'chevron-down' ),
					array( 'fa-regular fa-chevron-left' => 'chevron-left' ),
					array( 'fa-regular fa-chevron-right' => 'chevron-right' ),
					array( 'fa-regular fa-chevron-up' => 'chevron-up' ),
					array( 'fa-regular fa-chevrons-down' => 'chevrons-down' ),
					array( 'fa-regular fa-chevrons-left' => 'chevrons-left' ),
					array( 'fa-regular fa-chevrons-right' => 'chevrons-right' ),
					array( 'fa-regular fa-chevrons-up' => 'chevrons-up' ),
					array( 'fa-regular fa-chf-sign' => 'chf-sign' ),
					array( 'fa-regular fa-child-combatant' => 'child-combatant' ),
					array( 'fa-regular fa-child-dress' => 'child-dress' ),
					array( 'fa-regular fa-child-reaching' => 'child-reaching' ),
					array( 'fa-regular fa-child' => 'child' ),
					array( 'fa-regular fa-children' => 'children' ),
					array( 'fa-regular fa-chimney' => 'chimney' ),
					array( 'fa-regular fa-chopsticks' => 'chopsticks' ),
					array( 'fa-regular fa-church' => 'church' ),
					array( 'fa-regular fa-circle-0' => 'circle-0' ),
					array( 'fa-regular fa-circle-1' => 'circle-1' ),
					array( 'fa-regular fa-circle-2' => 'circle-2' ),
					array( 'fa-regular fa-circle-3' => 'circle-3' ),
					array( 'fa-regular fa-circle-4' => 'circle-4' ),
					array( 'fa-regular fa-circle-5' => 'circle-5' ),
					array( 'fa-regular fa-circle-6' => 'circle-6' ),
					array( 'fa-regular fa-circle-7' => 'circle-7' ),
					array( 'fa-regular fa-circle-8' => 'circle-8' ),
					array( 'fa-regular fa-circle-9' => 'circle-9' ),
					array( 'fa-regular fa-circle-a' => 'circle-a' ),
					array( 'fa-regular fa-circle-ampersand' => 'circle-ampersand' ),
					array( 'fa-regular fa-circle-arrow-down-left' => 'circle-arrow-down-left' ),
					array( 'fa-regular fa-circle-arrow-down-right' => 'circle-arrow-down-right' ),
					array( 'fa-regular fa-circle-arrow-down' => 'circle-arrow-down' ),
					array( 'fa-regular fa-circle-arrow-left' => 'circle-arrow-left' ),
					array( 'fa-regular fa-circle-arrow-right' => 'circle-arrow-right' ),
					array( 'fa-regular fa-circle-arrow-up-left' => 'circle-arrow-up-left' ),
					array( 'fa-regular fa-circle-arrow-up-right' => 'circle-arrow-up-right' ),
					array( 'fa-regular fa-circle-arrow-up' => 'circle-arrow-up' ),
					array( 'fa-regular fa-circle-b' => 'circle-b' ),
					array( 'fa-regular fa-circle-bolt' => 'circle-bolt' ),
					array( 'fa-regular fa-circle-book-open' => 'circle-book-open' ),
					array( 'fa-regular fa-circle-bookmark' => 'circle-bookmark' ),
					array( 'fa-regular fa-circle-c' => 'circle-c' ),
					array( 'fa-regular fa-circle-calendar' => 'circle-calendar' ),
					array( 'fa-regular fa-circle-camera' => 'circle-camera' ),
					array( 'fa-regular fa-circle-caret-down' => 'circle-caret-down' ),
					array( 'fa-regular fa-circle-caret-left' => 'circle-caret-left' ),
					array( 'fa-regular fa-circle-caret-right' => 'circle-caret-right' ),
					array( 'fa-regular fa-circle-caret-up' => 'circle-caret-up' ),
					array( 'fa-regular fa-circle-check' => 'circle-check' ),
					array( 'fa-regular fa-circle-chevron-down' => 'circle-chevron-down' ),
					array( 'fa-regular fa-circle-chevron-left' => 'circle-chevron-left' ),
					array( 'fa-regular fa-circle-chevron-right' => 'circle-chevron-right' ),
					array( 'fa-regular fa-circle-chevron-up' => 'circle-chevron-up' ),
					array( 'fa-regular fa-circle-d' => 'circle-d' ),
					array( 'fa-regular fa-circle-dashed' => 'circle-dashed' ),
					array( 'fa-regular fa-circle-divide' => 'circle-divide' ),
					array( 'fa-regular fa-circle-dollar-to-slot' => 'circle-dollar-to-slot' ),
					array( 'fa-regular fa-circle-dollar' => 'circle-dollar' ),
					array( 'fa-regular fa-circle-dot' => 'circle-dot' ),
					array( 'fa-regular fa-circle-down-left' => 'circle-down-left' ),
					array( 'fa-regular fa-circle-down-right' => 'circle-down-right' ),
					array( 'fa-regular fa-circle-down' => 'circle-down' ),
					array( 'fa-regular fa-circle-e' => 'circle-e' ),
					array( 'fa-regular fa-circle-ellipsis-vertical' => 'circle-ellipsis-vertical' ),
					array( 'fa-regular fa-circle-ellipsis' => 'circle-ellipsis' ),
					array( 'fa-regular fa-circle-envelope' => 'circle-envelope' ),
					array( 'fa-regular fa-circle-euro' => 'circle-euro' ),
					array( 'fa-regular fa-circle-exclamation-check' => 'circle-exclamation-check' ),
					array( 'fa-regular fa-circle-exclamation' => 'circle-exclamation' ),
					array( 'fa-regular fa-circle-f' => 'circle-f' ),
					array( 'fa-regular fa-circle-g' => 'circle-g' ),
					array( 'fa-regular fa-circle-h' => 'circle-h' ),
					array( 'fa-regular fa-circle-half-stroke' => 'circle-half-stroke' ),
					array( 'fa-regular fa-circle-half' => 'circle-half' ),
					array( 'fa-regular fa-circle-heart' => 'circle-heart' ),
					array( 'fa-regular fa-circle-i' => 'circle-i' ),
					array( 'fa-regular fa-circle-info' => 'circle-info' ),
					array( 'fa-regular fa-circle-j' => 'circle-j' ),
					array( 'fa-regular fa-circle-k' => 'circle-k' ),
					array( 'fa-regular fa-circle-l' => 'circle-l' ),
					array( 'fa-regular fa-circle-left' => 'circle-left' ),
					array( 'fa-regular fa-circle-location-arrow' => 'circle-location-arrow' ),
					array( 'fa-regular fa-circle-m' => 'circle-m' ),
					array( 'fa-regular fa-circle-microphone-lines' => 'circle-microphone-lines' ),
					array( 'fa-regular fa-circle-microphone' => 'circle-microphone' ),
					array( 'fa-regular fa-circle-minus' => 'circle-minus' ),
					array( 'fa-regular fa-circle-n' => 'circle-n' ),
					array( 'fa-regular fa-circle-nodes' => 'circle-nodes' ),
					array( 'fa-regular fa-circle-notch' => 'circle-notch' ),
					array( 'fa-regular fa-circle-o' => 'circle-o' ),
					array( 'fa-regular fa-circle-p' => 'circle-p' ),
					array( 'fa-regular fa-circle-parking' => 'circle-parking' ),
					array( 'fa-regular fa-circle-pause' => 'circle-pause' ),
					array( 'fa-regular fa-circle-phone-flip' => 'circle-phone-flip' ),
					array( 'fa-regular fa-circle-phone-hangup' => 'circle-phone-hangup' ),
					array( 'fa-regular fa-circle-phone' => 'circle-phone' ),
					array( 'fa-regular fa-circle-play' => 'circle-play' ),
					array( 'fa-regular fa-circle-plus' => 'circle-plus' ),
					array( 'fa-regular fa-circle-q' => 'circle-q' ),
					array( 'fa-regular fa-circle-quarter-stroke' => 'circle-quarter-stroke' ),
					array( 'fa-regular fa-circle-quarter' => 'circle-quarter' ),
					array( 'fa-regular fa-circle-quarters' => 'circle-quarters' ),
					array( 'fa-regular fa-circle-question' => 'circle-question' ),
					array( 'fa-regular fa-circle-r' => 'circle-r' ),
					array( 'fa-regular fa-circle-radiation' => 'circle-radiation' ),
					array( 'fa-regular fa-circle-right' => 'circle-right' ),
					array( 'fa-regular fa-circle-s' => 'circle-s' ),
					array( 'fa-regular fa-circle-small' => 'circle-small' ),
					array( 'fa-regular fa-circle-sort-down' => 'circle-sort-down' ),
					array( 'fa-regular fa-circle-sort-up' => 'circle-sort-up' ),
					array( 'fa-regular fa-circle-sort' => 'circle-sort' ),
					array( 'fa-regular fa-circle-star' => 'circle-star' ),
					array( 'fa-regular fa-circle-sterling' => 'circle-sterling' ),
					array( 'fa-regular fa-circle-stop' => 'circle-stop' ),
					array( 'fa-regular fa-circle-t' => 'circle-t' ),
					array( 'fa-regular fa-circle-three-quarters-stroke' => 'circle-three-quarters-stroke' ),
					array( 'fa-regular fa-circle-three-quarters' => 'circle-three-quarters' ),
					array( 'fa-regular fa-circle-trash' => 'circle-trash' ),
					array( 'fa-regular fa-circle-u' => 'circle-u' ),
					array( 'fa-regular fa-circle-up-left' => 'circle-up-left' ),
					array( 'fa-regular fa-circle-up-right' => 'circle-up-right' ),
					array( 'fa-regular fa-circle-up' => 'circle-up' ),
					array( 'fa-regular fa-circle-user' => 'circle-user' ),
					array( 'fa-regular fa-circle-v' => 'circle-v' ),
					array( 'fa-regular fa-circle-video' => 'circle-video' ),
					array( 'fa-regular fa-circle-w' => 'circle-w' ),
					array( 'fa-regular fa-circle-waveform-lines' => 'circle-waveform-lines' ),
					array( 'fa-regular fa-circle-x' => 'circle-x' ),
					array( 'fa-regular fa-circle-xmark' => 'circle-xmark' ),
					array( 'fa-regular fa-circle-y' => 'circle-y' ),
					array( 'fa-regular fa-circle-yen' => 'circle-yen' ),
					array( 'fa-regular fa-circle-z' => 'circle-z' ),
					array( 'fa-regular fa-circle' => 'circle' ),
					array( 'fa-regular fa-circles-overlap' => 'circles-overlap' ),
					array( 'fa-regular fa-citrus-slice' => 'citrus-slice' ),
					array( 'fa-regular fa-citrus' => 'citrus' ),
					array( 'fa-regular fa-city' => 'city' ),
					array( 'fa-regular fa-clapperboard-play' => 'clapperboard-play' ),
					array( 'fa-regular fa-clapperboard' => 'clapperboard' ),
					array( 'fa-regular fa-clarinet' => 'clarinet' ),
					array( 'fa-regular fa-claw-marks' => 'claw-marks' ),
					array( 'fa-regular fa-clipboard-check' => 'clipboard-check' ),
					array( 'fa-regular fa-clipboard-list-check' => 'clipboard-list-check' ),
					array( 'fa-regular fa-clipboard-list' => 'clipboard-list' ),
					array( 'fa-regular fa-clipboard-medical' => 'clipboard-medical' ),
					array( 'fa-regular fa-clipboard-prescription' => 'clipboard-prescription' ),
					array( 'fa-regular fa-clipboard-question' => 'clipboard-question' ),
					array( 'fa-regular fa-clipboard-user' => 'clipboard-user' ),
					array( 'fa-regular fa-clipboard' => 'clipboard' ),
					array( 'fa-regular fa-clock-desk' => 'clock-desk' ),
					array( 'fa-regular fa-clock-eight-thirty' => 'clock-eight-thirty' ),
					array( 'fa-regular fa-clock-eight' => 'clock-eight' ),
					array( 'fa-regular fa-clock-eleven-thirty' => 'clock-eleven-thirty' ),
					array( 'fa-regular fa-clock-eleven' => 'clock-eleven' ),
					array( 'fa-regular fa-clock-five-thirty' => 'clock-five-thirty' ),
					array( 'fa-regular fa-clock-five' => 'clock-five' ),
					array( 'fa-regular fa-clock-four-thirty' => 'clock-four-thirty' ),
					array( 'fa-regular fa-clock-nine-thirty' => 'clock-nine-thirty' ),
					array( 'fa-regular fa-clock-nine' => 'clock-nine' ),
					array( 'fa-regular fa-clock-one-thirty' => 'clock-one-thirty' ),
					array( 'fa-regular fa-clock-one' => 'clock-one' ),
					array( 'fa-regular fa-clock-rotate-left' => 'clock-rotate-left' ),
					array( 'fa-regular fa-clock-seven-thirty' => 'clock-seven-thirty' ),
					array( 'fa-regular fa-clock-seven' => 'clock-seven' ),
					array( 'fa-regular fa-clock-six-thirty' => 'clock-six-thirty' ),
					array( 'fa-regular fa-clock-six' => 'clock-six' ),
					array( 'fa-regular fa-clock-ten-thirty' => 'clock-ten-thirty' ),
					array( 'fa-regular fa-clock-ten' => 'clock-ten' ),
					array( 'fa-regular fa-clock-three-thirty' => 'clock-three-thirty' ),
					array( 'fa-regular fa-clock-three' => 'clock-three' ),
					array( 'fa-regular fa-clock-twelve-thirty' => 'clock-twelve-thirty' ),
					array( 'fa-regular fa-clock-twelve' => 'clock-twelve' ),
					array( 'fa-regular fa-clock-two-thirty' => 'clock-two-thirty' ),
					array( 'fa-regular fa-clock-two' => 'clock-two' ),
					array( 'fa-regular fa-clock' => 'clock' ),
					array( 'fa-regular fa-clone' => 'clone' ),
					array( 'fa-regular fa-closed-captioning-slash' => 'closed-captioning-slash' ),
					array( 'fa-regular fa-closed-captioning' => 'closed-captioning' ),
					array( 'fa-regular fa-clothes-hanger' => 'clothes-hanger' ),
					array( 'fa-regular fa-cloud-arrow-down' => 'cloud-arrow-down' ),
					array( 'fa-regular fa-cloud-arrow-up' => 'cloud-arrow-up' ),
					array( 'fa-regular fa-cloud-binary' => 'cloud-binary' ),
					array( 'fa-regular fa-cloud-bolt-moon' => 'cloud-bolt-moon' ),
					array( 'fa-regular fa-cloud-bolt-sun' => 'cloud-bolt-sun' ),
					array( 'fa-regular fa-cloud-bolt' => 'cloud-bolt' ),
					array( 'fa-regular fa-cloud-check' => 'cloud-check' ),
					array( 'fa-regular fa-cloud-drizzle' => 'cloud-drizzle' ),
					array( 'fa-regular fa-cloud-exclamation' => 'cloud-exclamation' ),
					array( 'fa-regular fa-cloud-fog' => 'cloud-fog' ),
					array( 'fa-regular fa-cloud-hail-mixed' => 'cloud-hail-mixed' ),
					array( 'fa-regular fa-cloud-hail' => 'cloud-hail' ),
					array( 'fa-regular fa-cloud-meatball' => 'cloud-meatball' ),
					array( 'fa-regular fa-cloud-minus' => 'cloud-minus' ),
					array( 'fa-regular fa-cloud-moon-rain' => 'cloud-moon-rain' ),
					array( 'fa-regular fa-cloud-moon' => 'cloud-moon' ),
					array( 'fa-regular fa-cloud-music' => 'cloud-music' ),
					array( 'fa-regular fa-cloud-plus' => 'cloud-plus' ),
					array( 'fa-regular fa-cloud-question' => 'cloud-question' ),
					array( 'fa-regular fa-cloud-rain' => 'cloud-rain' ),
					array( 'fa-regular fa-cloud-rainbow' => 'cloud-rainbow' ),
					array( 'fa-regular fa-cloud-showers-heavy' => 'cloud-showers-heavy' ),
					array( 'fa-regular fa-cloud-showers-water' => 'cloud-showers-water' ),
					array( 'fa-regular fa-cloud-showers' => 'cloud-showers' ),
					array( 'fa-regular fa-cloud-slash' => 'cloud-slash' ),
					array( 'fa-regular fa-cloud-sleet' => 'cloud-sleet' ),
					array( 'fa-regular fa-cloud-snow' => 'cloud-snow' ),
					array( 'fa-regular fa-cloud-sun-rain' => 'cloud-sun-rain' ),
					array( 'fa-regular fa-cloud-sun' => 'cloud-sun' ),
					array( 'fa-regular fa-cloud-word' => 'cloud-word' ),
					array( 'fa-regular fa-cloud-xmark' => 'cloud-xmark' ),
					array( 'fa-regular fa-cloud' => 'cloud' ),
					array( 'fa-regular fa-clouds-moon' => 'clouds-moon' ),
					array( 'fa-regular fa-clouds-sun' => 'clouds-sun' ),
					array( 'fa-regular fa-clouds' => 'clouds' ),
					array( 'fa-regular fa-clover' => 'clover' ),
					array( 'fa-regular fa-club' => 'club' ),
					array( 'fa-regular fa-coconut' => 'coconut' ),
					array( 'fa-regular fa-code-branch' => 'code-branch' ),
					array( 'fa-regular fa-code-commit' => 'code-commit' ),
					array( 'fa-regular fa-code-compare' => 'code-compare' ),
					array( 'fa-regular fa-code-fork' => 'code-fork' ),
					array( 'fa-regular fa-code-merge' => 'code-merge' ),
					array( 'fa-regular fa-code-pull-request-closed' => 'code-pull-request-closed' ),
					array( 'fa-regular fa-code-pull-request-draft' => 'code-pull-request-draft' ),
					array( 'fa-regular fa-code-pull-request' => 'code-pull-request' ),
					array( 'fa-regular fa-code-simple' => 'code-simple' ),
					array( 'fa-regular fa-code' => 'code' ),
					array( 'fa-regular fa-coffee-bean' => 'coffee-bean' ),
					array( 'fa-regular fa-coffee-beans' => 'coffee-beans' ),
					array( 'fa-regular fa-coffee-pot' => 'coffee-pot' ),
					array( 'fa-regular fa-coffin-cross' => 'coffin-cross' ),
					array( 'fa-regular fa-coffin' => 'coffin' ),
					array( 'fa-regular fa-coin-blank' => 'coin-blank' ),
					array( 'fa-regular fa-coin-front' => 'coin-front' ),
					array( 'fa-regular fa-coin-vertical' => 'coin-vertical' ),
					array( 'fa-regular fa-coin' => 'coin' ),
					array( 'fa-regular fa-coins' => 'coins' ),
					array( 'fa-regular fa-colon-sign' => 'colon-sign' ),
					array( 'fa-regular fa-colon' => 'colon' ),
					array( 'fa-regular fa-columns-3' => 'columns-3' ),
					array( 'fa-regular fa-comet' => 'comet' ),
					array( 'fa-regular fa-comma' => 'comma' ),
					array( 'fa-regular fa-command' => 'command' ),
					array( 'fa-regular fa-comment-arrow-down' => 'comment-arrow-down' ),
					array( 'fa-regular fa-comment-arrow-up-right' => 'comment-arrow-up-right' ),
					array( 'fa-regular fa-comment-arrow-up' => 'comment-arrow-up' ),
					array( 'fa-regular fa-comment-captions' => 'comment-captions' ),
					array( 'fa-regular fa-comment-check' => 'comment-check' ),
					array( 'fa-regular fa-comment-code' => 'comment-code' ),
					array( 'fa-regular fa-comment-dollar' => 'comment-dollar' ),
					array( 'fa-regular fa-comment-dots' => 'comment-dots' ),
					array( 'fa-regular fa-comment-exclamation' => 'comment-exclamation' ),
					array( 'fa-regular fa-comment-heart' => 'comment-heart' ),
					array( 'fa-regular fa-comment-image' => 'comment-image' ),
					array( 'fa-regular fa-comment-lines' => 'comment-lines' ),
					array( 'fa-regular fa-comment-medical' => 'comment-medical' ),
					array( 'fa-regular fa-comment-middle-top' => 'comment-middle-top' ),
					array( 'fa-regular fa-comment-middle' => 'comment-middle' ),
					array( 'fa-regular fa-comment-minus' => 'comment-minus' ),
					array( 'fa-regular fa-comment-music' => 'comment-music' ),
					array( 'fa-regular fa-comment-pen' => 'comment-pen' ),
					array( 'fa-regular fa-comment-plus' => 'comment-plus' ),
					array( 'fa-regular fa-comment-question' => 'comment-question' ),
					array( 'fa-regular fa-comment-quote' => 'comment-quote' ),
					array( 'fa-regular fa-comment-slash' => 'comment-slash' ),
					array( 'fa-regular fa-comment-smile' => 'comment-smile' ),
					array( 'fa-regular fa-comment-sms' => 'comment-sms' ),
					array( 'fa-regular fa-comment-text' => 'comment-text' ),
					array( 'fa-regular fa-comment-xmark' => 'comment-xmark' ),
					array( 'fa-regular fa-comment' => 'comment' ),
					array( 'fa-regular fa-comments-dollar' => 'comments-dollar' ),
					array( 'fa-regular fa-comments-question-check' => 'comments-question-check' ),
					array( 'fa-regular fa-comments-question' => 'comments-question' ),
					array( 'fa-regular fa-comments' => 'comments' ),
					array( 'fa-regular fa-compact-disc' => 'compact-disc' ),
					array( 'fa-regular fa-compass-drafting' => 'compass-drafting' ),
					array( 'fa-regular fa-compass-slash' => 'compass-slash' ),
					array( 'fa-regular fa-compass' => 'compass' ),
					array( 'fa-regular fa-compress-wide' => 'compress-wide' ),
					array( 'fa-regular fa-compress' => 'compress' ),
					array( 'fa-regular fa-computer-classic' => 'computer-classic' ),
					array( 'fa-regular fa-computer-mouse-scrollwheel' => 'computer-mouse-scrollwheel' ),
					array( 'fa-regular fa-computer-mouse' => 'computer-mouse' ),
					array( 'fa-regular fa-computer-speaker' => 'computer-speaker' ),
					array( 'fa-regular fa-computer' => 'computer' ),
					array( 'fa-regular fa-container-storage' => 'container-storage' ),
					array( 'fa-regular fa-conveyor-belt-arm' => 'conveyor-belt-arm' ),
					array( 'fa-regular fa-conveyor-belt-boxes' => 'conveyor-belt-boxes' ),
					array( 'fa-regular fa-conveyor-belt-empty' => 'conveyor-belt-empty' ),
					array( 'fa-regular fa-conveyor-belt' => 'conveyor-belt' ),
					array( 'fa-regular fa-cookie-bite' => 'cookie-bite' ),
					array( 'fa-regular fa-cookie' => 'cookie' ),
					array( 'fa-regular fa-copy' => 'copy' ),
					array( 'fa-regular fa-copyright' => 'copyright' ),
					array( 'fa-regular fa-corn' => 'corn' ),
					array( 'fa-regular fa-corner' => 'corner' ),
					array( 'fa-regular fa-couch' => 'couch' ),
					array( 'fa-regular fa-cow' => 'cow' ),
					array( 'fa-regular fa-cowbell-circle-plus' => 'cowbell-circle-plus' ),
					array( 'fa-regular fa-cowbell' => 'cowbell' ),
					array( 'fa-regular fa-crab' => 'crab' ),
					array( 'fa-regular fa-crate-apple' => 'crate-apple' ),
					array( 'fa-regular fa-crate-empty' => 'crate-empty' ),
					array( 'fa-regular fa-credit-card-blank' => 'credit-card-blank' ),
					array( 'fa-regular fa-credit-card-front' => 'credit-card-front' ),
					array( 'fa-regular fa-credit-card' => 'credit-card' ),
					array( 'fa-regular fa-cricket-bat-ball' => 'cricket-bat-ball' ),
					array( 'fa-regular fa-croissant' => 'croissant' ),
					array( 'fa-regular fa-crop-simple' => 'crop-simple' ),
					array( 'fa-regular fa-crop' => 'crop' ),
					array( 'fa-regular fa-cross' => 'cross' ),
					array( 'fa-regular fa-crosshairs-simple' => 'crosshairs-simple' ),
					array( 'fa-regular fa-crosshairs' => 'crosshairs' ),
					array( 'fa-regular fa-crow' => 'crow' ),
					array( 'fa-regular fa-crown' => 'crown' ),
					array( 'fa-regular fa-crutch' => 'crutch' ),
					array( 'fa-regular fa-crutches' => 'crutches' ),
					array( 'fa-regular fa-cruzeiro-sign' => 'cruzeiro-sign' ),
					array( 'fa-regular fa-crystal-ball' => 'crystal-ball' ),
					array( 'fa-regular fa-cube' => 'cube' ),
					array( 'fa-regular fa-cubes-stacked' => 'cubes-stacked' ),
					array( 'fa-regular fa-cubes' => 'cubes' ),
					array( 'fa-regular fa-cucumber' => 'cucumber' ),
					array( 'fa-regular fa-cup-straw-swoosh' => 'cup-straw-swoosh' ),
					array( 'fa-regular fa-cup-straw' => 'cup-straw' ),
					array( 'fa-regular fa-cup-togo' => 'cup-togo' ),
					array( 'fa-regular fa-cupcake' => 'cupcake' ),
					array( 'fa-regular fa-curling-stone' => 'curling-stone' ),
					array( 'fa-regular fa-custard' => 'custard' ),
					array( 'fa-regular fa-d' => 'd' ),
					array( 'fa-regular fa-dagger' => 'dagger' ),
					array( 'fa-regular fa-dash' => 'dash' ),
					array( 'fa-regular fa-database' => 'database' ),
					array( 'fa-regular fa-deer-rudolph' => 'deer-rudolph' ),
					array( 'fa-regular fa-deer' => 'deer' ),
					array( 'fa-regular fa-delete-left' => 'delete-left' ),
					array( 'fa-regular fa-delete-right' => 'delete-right' ),
					array( 'fa-regular fa-democrat' => 'democrat' ),
					array( 'fa-regular fa-desktop-arrow-down' => 'desktop-arrow-down' ),
					array( 'fa-regular fa-desktop' => 'desktop' ),
					array( 'fa-regular fa-dharmachakra' => 'dharmachakra' ),
					array( 'fa-regular fa-diagram-cells' => 'diagram-cells' ),
					array( 'fa-regular fa-diagram-lean-canvas' => 'diagram-lean-canvas' ),
					array( 'fa-regular fa-diagram-nested' => 'diagram-nested' ),
					array( 'fa-regular fa-diagram-next' => 'diagram-next' ),
					array( 'fa-regular fa-diagram-predecessor' => 'diagram-predecessor' ),
					array( 'fa-regular fa-diagram-previous' => 'diagram-previous' ),
					array( 'fa-regular fa-diagram-project' => 'diagram-project' ),
					array( 'fa-regular fa-diagram-sankey' => 'diagram-sankey' ),
					array( 'fa-regular fa-diagram-subtask' => 'diagram-subtask' ),
					array( 'fa-regular fa-diagram-successor' => 'diagram-successor' ),
					array( 'fa-regular fa-diagram-venn' => 'diagram-venn' ),
					array( 'fa-regular fa-dial-high' => 'dial-high' ),
					array( 'fa-regular fa-dial-low' => 'dial-low' ),
					array( 'fa-regular fa-dial-max' => 'dial-max' ),
					array( 'fa-regular fa-dial-med-low' => 'dial-med-low' ),
					array( 'fa-regular fa-dial-med' => 'dial-med' ),
					array( 'fa-regular fa-dial-min' => 'dial-min' ),
					array( 'fa-regular fa-dial-off' => 'dial-off' ),
					array( 'fa-regular fa-dial' => 'dial' ),
					array( 'fa-regular fa-diamond-exclamation' => 'diamond-exclamation' ),
					array( 'fa-regular fa-diamond-half-stroke' => 'diamond-half-stroke' ),
					array( 'fa-regular fa-diamond-half' => 'diamond-half' ),
					array( 'fa-regular fa-diamond-turn-right' => 'diamond-turn-right' ),
					array( 'fa-regular fa-diamond' => 'diamond' ),
					array( 'fa-regular fa-dice-d4' => 'dice-d4' ),
					array( 'fa-regular fa-dice-d6' => 'dice-d6' ),
					array( 'fa-regular fa-dice-d8' => 'dice-d8' ),
					array( 'fa-regular fa-dice-d10' => 'dice-d10' ),
					array( 'fa-regular fa-dice-d12' => 'dice-d12' ),
					array( 'fa-regular fa-dice-d20' => 'dice-d20' ),
					array( 'fa-regular fa-dice-five' => 'dice-five' ),
					array( 'fa-regular fa-dice-four' => 'dice-four' ),
					array( 'fa-regular fa-dice-one' => 'dice-one' ),
					array( 'fa-regular fa-dice-six' => 'dice-six' ),
					array( 'fa-regular fa-dice-three' => 'dice-three' ),
					array( 'fa-regular fa-dice-two' => 'dice-two' ),
					array( 'fa-regular fa-dice' => 'dice' ),
					array( 'fa-regular fa-dinosaur' => 'dinosaur' ),
					array( 'fa-regular fa-diploma' => 'diploma' ),
					array( 'fa-regular fa-disc-drive' => 'disc-drive' ),
					array( 'fa-regular fa-disease' => 'disease' ),
					array( 'fa-regular fa-display-arrow-down' => 'display-arrow-down' ),
					array( 'fa-regular fa-display-chart-up-circle-currency' => 'display-chart-up-circle-currency' ),
					array( 'fa-regular fa-display-chart-up-circle-dollar' => 'display-chart-up-circle-dollar' ),
					array( 'fa-regular fa-display-chart-up' => 'display-chart-up' ),
					array( 'fa-regular fa-display-code' => 'display-code' ),
					array( 'fa-regular fa-display-medical' => 'display-medical' ),
					array( 'fa-regular fa-display-slash' => 'display-slash' ),
					array( 'fa-regular fa-display' => 'display' ),
					array( 'fa-regular fa-distribute-spacing-horizontal' => 'distribute-spacing-horizontal' ),
					array( 'fa-regular fa-distribute-spacing-vertical' => 'distribute-spacing-vertical' ),
					array( 'fa-regular fa-ditto' => 'ditto' ),
					array( 'fa-regular fa-divide' => 'divide' ),
					array( 'fa-regular fa-dna' => 'dna' ),
					array( 'fa-regular fa-do-not-enter' => 'do-not-enter' ),
					array( 'fa-regular fa-dog-leashed' => 'dog-leashed' ),
					array( 'fa-regular fa-dog' => 'dog' ),
					array( 'fa-regular fa-dollar-sign' => 'dollar-sign' ),
					array( 'fa-regular fa-dolly-empty' => 'dolly-empty' ),
					array( 'fa-regular fa-dolly' => 'dolly' ),
					array( 'fa-regular fa-dolphin' => 'dolphin' ),
					array( 'fa-regular fa-dong-sign' => 'dong-sign' ),
					array( 'fa-regular fa-donut' => 'donut' ),
					array( 'fa-regular fa-door-closed' => 'door-closed' ),
					array( 'fa-regular fa-door-open' => 'door-open' ),
					array( 'fa-regular fa-dove' => 'dove' ),
					array( 'fa-regular fa-down-from-dotted-line' => 'down-from-dotted-line' ),
					array( 'fa-regular fa-down-from-line' => 'down-from-line' ),
					array( 'fa-regular fa-down-left-and-up-right-to-center' => 'down-left-and-up-right-to-center' ),
					array( 'fa-regular fa-down-left' => 'down-left' ),
					array( 'fa-regular fa-down-long' => 'down-long' ),
					array( 'fa-regular fa-down-right' => 'down-right' ),
					array( 'fa-regular fa-down-to-bracket' => 'down-to-bracket' ),
					array( 'fa-regular fa-down-to-dotted-line' => 'down-to-dotted-line' ),
					array( 'fa-regular fa-down-to-line' => 'down-to-line' ),
					array( 'fa-regular fa-down' => 'down' ),
					array( 'fa-regular fa-download' => 'download' ),
					array( 'fa-regular fa-dragon' => 'dragon' ),
					array( 'fa-regular fa-draw-circle' => 'draw-circle' ),
					array( 'fa-regular fa-draw-polygon' => 'draw-polygon' ),
					array( 'fa-regular fa-draw-square' => 'draw-square' ),
					array( 'fa-regular fa-dreidel' => 'dreidel' ),
					array( 'fa-regular fa-drone-front' => 'drone-front' ),
					array( 'fa-regular fa-drone' => 'drone' ),
					array( 'fa-regular fa-droplet-degree' => 'droplet-degree' ),
					array( 'fa-regular fa-droplet-percent' => 'droplet-percent' ),
					array( 'fa-regular fa-droplet-slash' => 'droplet-slash' ),
					array( 'fa-regular fa-droplet' => 'droplet' ),
					array( 'fa-regular fa-drum-steelpan' => 'drum-steelpan' ),
					array( 'fa-regular fa-drum' => 'drum' ),
					array( 'fa-regular fa-drumstick-bite' => 'drumstick-bite' ),
					array( 'fa-regular fa-drumstick' => 'drumstick' ),
					array( 'fa-regular fa-dryer-heat' => 'dryer-heat' ),
					array( 'fa-regular fa-dryer' => 'dryer' ),
					array( 'fa-regular fa-duck' => 'duck' ),
					array( 'fa-regular fa-dumbbell' => 'dumbbell' ),
					array( 'fa-regular fa-dumpster-fire' => 'dumpster-fire' ),
					array( 'fa-regular fa-dumpster' => 'dumpster' ),
					array( 'fa-regular fa-dungeon' => 'dungeon' ),
					array( 'fa-regular fa-e' => 'e' ),
					array( 'fa-regular fa-ear-deaf' => 'ear-deaf' ),
					array( 'fa-regular fa-ear-listen' => 'ear-listen' ),
					array( 'fa-regular fa-ear-muffs' => 'ear-muffs' ),
					array( 'fa-regular fa-ear' => 'ear' ),
					array( 'fa-regular fa-earth-africa' => 'earth-africa' ),
					array( 'fa-regular fa-earth-americas' => 'earth-americas' ),
					array( 'fa-regular fa-earth-asia' => 'earth-asia' ),
					array( 'fa-regular fa-earth-europe' => 'earth-europe' ),
					array( 'fa-regular fa-earth-oceania' => 'earth-oceania' ),
					array( 'fa-regular fa-eclipse' => 'eclipse' ),
					array( 'fa-regular fa-egg-fried' => 'egg-fried' ),
					array( 'fa-regular fa-egg' => 'egg' ),
					array( 'fa-regular fa-eggplant' => 'eggplant' ),
					array( 'fa-regular fa-eject' => 'eject' ),
					array( 'fa-regular fa-elephant' => 'elephant' ),
					array( 'fa-regular fa-elevator' => 'elevator' ),
					array( 'fa-regular fa-ellipsis-stroke-vertical' => 'ellipsis-stroke-vertical' ),
					array( 'fa-regular fa-ellipsis-stroke' => 'ellipsis-stroke' ),
					array( 'fa-regular fa-ellipsis-vertical' => 'ellipsis-vertical' ),
					array( 'fa-regular fa-ellipsis' => 'ellipsis' ),
					array( 'fa-regular fa-empty-set' => 'empty-set' ),
					array( 'fa-regular fa-engine-warning' => 'engine-warning' ),
					array( 'fa-regular fa-engine' => 'engine' ),
					array( 'fa-regular fa-envelope-circle-check' => 'envelope-circle-check' ),
					array( 'fa-regular fa-envelope-dot' => 'envelope-dot' ),
					array( 'fa-regular fa-envelope-open-dollar' => 'envelope-open-dollar' ),
					array( 'fa-regular fa-envelope-open-text' => 'envelope-open-text' ),
					array( 'fa-regular fa-envelope-open' => 'envelope-open' ),
					array( 'fa-regular fa-envelope' => 'envelope' ),
					array( 'fa-regular fa-envelopes-bulk' => 'envelopes-bulk' ),
					array( 'fa-regular fa-envelopes' => 'envelopes' ),
					array( 'fa-regular fa-equals' => 'equals' ),
					array( 'fa-regular fa-eraser' => 'eraser' ),
					array( 'fa-regular fa-escalator' => 'escalator' ),
					array( 'fa-regular fa-ethernet' => 'ethernet' ),
					array( 'fa-regular fa-euro-sign' => 'euro-sign' ),
					array( 'fa-regular fa-exclamation' => 'exclamation' ),
					array( 'fa-regular fa-expand-wide' => 'expand-wide' ),
					array( 'fa-regular fa-expand' => 'expand' ),
					array( 'fa-regular fa-explosion' => 'explosion' ),
					array( 'fa-regular fa-eye-dropper-full' => 'eye-dropper-full' ),
					array( 'fa-regular fa-eye-dropper-half' => 'eye-dropper-half' ),
					array( 'fa-regular fa-eye-dropper' => 'eye-dropper' ),
					array( 'fa-regular fa-eye-evil' => 'eye-evil' ),
					array( 'fa-regular fa-eye-low-vision' => 'eye-low-vision' ),
					array( 'fa-regular fa-eye-slash' => 'eye-slash' ),
					array( 'fa-regular fa-eye' => 'eye' ),
					array( 'fa-regular fa-eyes' => 'eyes' ),
					array( 'fa-regular fa-f' => 'f' ),
					array( 'fa-regular fa-face-angry-horns' => 'face-angry-horns' ),
					array( 'fa-regular fa-face-angry' => 'face-angry' ),
					array( 'fa-regular fa-face-anguished' => 'face-anguished' ),
					array( 'fa-regular fa-face-anxious-sweat' => 'face-anxious-sweat' ),
					array( 'fa-regular fa-face-astonished' => 'face-astonished' ),
					array( 'fa-regular fa-face-awesome' => 'face-awesome' ),
					array( 'fa-regular fa-face-beam-hand-over-mouth' => 'face-beam-hand-over-mouth' ),
					array( 'fa-regular fa-face-clouds' => 'face-clouds' ),
					array( 'fa-regular fa-face-confounded' => 'face-confounded' ),
					array( 'fa-regular fa-face-confused' => 'face-confused' ),
					array( 'fa-regular fa-face-cowboy-hat' => 'face-cowboy-hat' ),
					array( 'fa-regular fa-face-diagonal-mouth' => 'face-diagonal-mouth' ),
					array( 'fa-regular fa-face-disappointed' => 'face-disappointed' ),
					array( 'fa-regular fa-face-disguise' => 'face-disguise' ),
					array( 'fa-regular fa-face-dizzy' => 'face-dizzy' ),
					array( 'fa-regular fa-face-dotted' => 'face-dotted' ),
					array( 'fa-regular fa-face-downcast-sweat' => 'face-downcast-sweat' ),
					array( 'fa-regular fa-face-drooling' => 'face-drooling' ),
					array( 'fa-regular fa-face-exhaling' => 'face-exhaling' ),
					array( 'fa-regular fa-face-explode' => 'face-explode' ),
					array( 'fa-regular fa-face-expressionless' => 'face-expressionless' ),
					array( 'fa-regular fa-face-eyes-xmarks' => 'face-eyes-xmarks' ),
					array( 'fa-regular fa-face-fearful' => 'face-fearful' ),
					array( 'fa-regular fa-face-flushed' => 'face-flushed' ),
					array( 'fa-regular fa-face-frown-open' => 'face-frown-open' ),
					array( 'fa-regular fa-face-frown-slight' => 'face-frown-slight' ),
					array( 'fa-regular fa-face-frown' => 'face-frown' ),
					array( 'fa-regular fa-face-glasses' => 'face-glasses' ),
					array( 'fa-regular fa-face-grimace' => 'face-grimace' ),
					array( 'fa-regular fa-face-grin-beam-sweat' => 'face-grin-beam-sweat' ),
					array( 'fa-regular fa-face-grin-beam' => 'face-grin-beam' ),
					array( 'fa-regular fa-face-grin-hearts' => 'face-grin-hearts' ),
					array( 'fa-regular fa-face-grin-squint-tears' => 'face-grin-squint-tears' ),
					array( 'fa-regular fa-face-grin-squint' => 'face-grin-squint' ),
					array( 'fa-regular fa-face-grin-stars' => 'face-grin-stars' ),
					array( 'fa-regular fa-face-grin-tears' => 'face-grin-tears' ),
					array( 'fa-regular fa-face-grin-tongue-squint' => 'face-grin-tongue-squint' ),
					array( 'fa-regular fa-face-grin-tongue-wink' => 'face-grin-tongue-wink' ),
					array( 'fa-regular fa-face-grin-tongue' => 'face-grin-tongue' ),
					array( 'fa-regular fa-face-grin-wide' => 'face-grin-wide' ),
					array( 'fa-regular fa-face-grin-wink' => 'face-grin-wink' ),
					array( 'fa-regular fa-face-grin' => 'face-grin' ),
					array( 'fa-regular fa-face-hand-over-mouth' => 'face-hand-over-mouth' ),
					array( 'fa-regular fa-face-hand-peeking' => 'face-hand-peeking' ),
					array( 'fa-regular fa-face-hand-yawn' => 'face-hand-yawn' ),
					array( 'fa-regular fa-face-head-bandage' => 'face-head-bandage' ),
					array( 'fa-regular fa-face-holding-back-tears' => 'face-holding-back-tears' ),
					array( 'fa-regular fa-face-hushed' => 'face-hushed' ),
					array( 'fa-regular fa-face-icicles' => 'face-icicles' ),
					array( 'fa-regular fa-face-kiss-beam' => 'face-kiss-beam' ),
					array( 'fa-regular fa-face-kiss-closed-eyes' => 'face-kiss-closed-eyes' ),
					array( 'fa-regular fa-face-kiss-wink-heart' => 'face-kiss-wink-heart' ),
					array( 'fa-regular fa-face-kiss' => 'face-kiss' ),
					array( 'fa-regular fa-face-laugh-beam' => 'face-laugh-beam' ),
					array( 'fa-regular fa-face-laugh-squint' => 'face-laugh-squint' ),
					array( 'fa-regular fa-face-laugh-wink' => 'face-laugh-wink' ),
					array( 'fa-regular fa-face-laugh' => 'face-laugh' ),
					array( 'fa-regular fa-face-lying' => 'face-lying' ),
					array( 'fa-regular fa-face-mask' => 'face-mask' ),
					array( 'fa-regular fa-face-meh-blank' => 'face-meh-blank' ),
					array( 'fa-regular fa-face-meh' => 'face-meh' ),
					array( 'fa-regular fa-face-melting' => 'face-melting' ),
					array( 'fa-regular fa-face-monocle' => 'face-monocle' ),
					array( 'fa-regular fa-face-nauseated' => 'face-nauseated' ),
					array( 'fa-regular fa-face-nose-steam' => 'face-nose-steam' ),
					array( 'fa-regular fa-face-party' => 'face-party' ),
					array( 'fa-regular fa-face-pensive' => 'face-pensive' ),
					array( 'fa-regular fa-face-persevering' => 'face-persevering' ),
					array( 'fa-regular fa-face-pleading' => 'face-pleading' ),
					array( 'fa-regular fa-face-pouting' => 'face-pouting' ),
					array( 'fa-regular fa-face-raised-eyebrow' => 'face-raised-eyebrow' ),
					array( 'fa-regular fa-face-relieved' => 'face-relieved' ),
					array( 'fa-regular fa-face-rolling-eyes' => 'face-rolling-eyes' ),
					array( 'fa-regular fa-face-sad-cry' => 'face-sad-cry' ),
					array( 'fa-regular fa-face-sad-sweat' => 'face-sad-sweat' ),
					array( 'fa-regular fa-face-sad-tear' => 'face-sad-tear' ),
					array( 'fa-regular fa-face-saluting' => 'face-saluting' ),
					array( 'fa-regular fa-face-scream' => 'face-scream' ),
					array( 'fa-regular fa-face-shush' => 'face-shush' ),
					array( 'fa-regular fa-face-sleeping' => 'face-sleeping' ),
					array( 'fa-regular fa-face-sleepy' => 'face-sleepy' ),
					array( 'fa-regular fa-face-smile-beam' => 'face-smile-beam' ),
					array( 'fa-regular fa-face-smile-halo' => 'face-smile-halo' ),
					array( 'fa-regular fa-face-smile-hearts' => 'face-smile-hearts' ),
					array( 'fa-regular fa-face-smile-horns' => 'face-smile-horns' ),
					array( 'fa-regular fa-face-smile-plus' => 'face-smile-plus' ),
					array( 'fa-regular fa-face-smile-relaxed' => 'face-smile-relaxed' ),
					array( 'fa-regular fa-face-smile-tear' => 'face-smile-tear' ),
					array( 'fa-regular fa-face-smile-tongue' => 'face-smile-tongue' ),
					array( 'fa-regular fa-face-smile-upside-down' => 'face-smile-upside-down' ),
					array( 'fa-regular fa-face-smile-wink' => 'face-smile-wink' ),
					array( 'fa-regular fa-face-smile' => 'face-smile' ),
					array( 'fa-regular fa-face-smiling-hands' => 'face-smiling-hands' ),
					array( 'fa-regular fa-face-smirking' => 'face-smirking' ),
					array( 'fa-regular fa-face-spiral-eyes' => 'face-spiral-eyes' ),
					array( 'fa-regular fa-face-sunglasses' => 'face-sunglasses' ),
					array( 'fa-regular fa-face-surprise' => 'face-surprise' ),
					array( 'fa-regular fa-face-swear' => 'face-swear' ),
					array( 'fa-regular fa-face-thermometer' => 'face-thermometer' ),
					array( 'fa-regular fa-face-thinking' => 'face-thinking' ),
					array( 'fa-regular fa-face-tired' => 'face-tired' ),
					array( 'fa-regular fa-face-tissue' => 'face-tissue' ),
					array( 'fa-regular fa-face-tongue-money' => 'face-tongue-money' ),
					array( 'fa-regular fa-face-tongue-sweat' => 'face-tongue-sweat' ),
					array( 'fa-regular fa-face-unamused' => 'face-unamused' ),
					array( 'fa-regular fa-face-viewfinder' => 'face-viewfinder' ),
					array( 'fa-regular fa-face-vomit' => 'face-vomit' ),
					array( 'fa-regular fa-face-weary' => 'face-weary' ),
					array( 'fa-regular fa-face-woozy' => 'face-woozy' ),
					array( 'fa-regular fa-face-worried' => 'face-worried' ),
					array( 'fa-regular fa-face-zany' => 'face-zany' ),
					array( 'fa-regular fa-face-zipper' => 'face-zipper' ),
					array( 'fa-regular fa-falafel' => 'falafel' ),
					array( 'fa-regular fa-family-dress' => 'family-dress' ),
					array( 'fa-regular fa-family-pants' => 'family-pants' ),
					array( 'fa-regular fa-family' => 'family' ),
					array( 'fa-regular fa-fan-table' => 'fan-table' ),
					array( 'fa-regular fa-fan' => 'fan' ),
					array( 'fa-regular fa-farm' => 'farm' ),
					array( 'fa-regular fa-faucet-drip' => 'faucet-drip' ),
					array( 'fa-regular fa-faucet' => 'faucet' ),
					array( 'fa-regular fa-fax' => 'fax' ),
					array( 'fa-regular fa-feather-pointed' => 'feather-pointed' ),
					array( 'fa-regular fa-feather' => 'feather' ),
					array( 'fa-regular fa-fence' => 'fence' ),
					array( 'fa-regular fa-ferris-wheel' => 'ferris-wheel' ),
					array( 'fa-regular fa-ferry' => 'ferry' ),
					array( 'fa-regular fa-field-hockey-stick-ball' => 'field-hockey-stick-ball' ),
					array( 'fa-regular fa-file-arrow-down' => 'file-arrow-down' ),
					array( 'fa-regular fa-file-arrow-up' => 'file-arrow-up' ),
					array( 'fa-regular fa-file-audio' => 'file-audio' ),
					array( 'fa-regular fa-file-binary' => 'file-binary' ),
					array( 'fa-regular fa-file-certificate' => 'file-certificate' ),
					array( 'fa-regular fa-file-chart-column' => 'file-chart-column' ),
					array( 'fa-regular fa-file-chart-pie' => 'file-chart-pie' ),
					array( 'fa-regular fa-file-check' => 'file-check' ),
					array( 'fa-regular fa-file-circle-check' => 'file-circle-check' ),
					array( 'fa-regular fa-file-circle-exclamation' => 'file-circle-exclamation' ),
					array( 'fa-regular fa-file-circle-info' => 'file-circle-info' ),
					array( 'fa-regular fa-file-circle-minus' => 'file-circle-minus' ),
					array( 'fa-regular fa-file-circle-plus' => 'file-circle-plus' ),
					array( 'fa-regular fa-file-circle-question' => 'file-circle-question' ),
					array( 'fa-regular fa-file-circle-xmark' => 'file-circle-xmark' ),
					array( 'fa-regular fa-file-code' => 'file-code' ),
					array( 'fa-regular fa-file-contract' => 'file-contract' ),
					array( 'fa-regular fa-file-csv' => 'file-csv' ),
					array( 'fa-regular fa-file-dashed-line' => 'file-dashed-line' ),
					array( 'fa-regular fa-file-doc' => 'file-doc' ),
					array( 'fa-regular fa-file-excel' => 'file-excel' ),
					array( 'fa-regular fa-file-exclamation' => 'file-exclamation' ),
					array( 'fa-regular fa-file-export' => 'file-export' ),
					array( 'fa-regular fa-file-heart' => 'file-heart' ),
					array( 'fa-regular fa-file-image' => 'file-image' ),
					array( 'fa-regular fa-file-import' => 'file-import' ),
					array( 'fa-regular fa-file-invoice-dollar' => 'file-invoice-dollar' ),
					array( 'fa-regular fa-file-invoice' => 'file-invoice' ),
					array( 'fa-regular fa-file-lines' => 'file-lines' ),
					array( 'fa-regular fa-file-lock' => 'file-lock' ),
					array( 'fa-regular fa-file-magnifying-glass' => 'file-magnifying-glass' ),
					array( 'fa-regular fa-file-medical' => 'file-medical' ),
					array( 'fa-regular fa-file-minus' => 'file-minus' ),
					array( 'fa-regular fa-file-music' => 'file-music' ),
					array( 'fa-regular fa-file-pdf' => 'file-pdf' ),
					array( 'fa-regular fa-file-pen' => 'file-pen' ),
					array( 'fa-regular fa-file-plus-minus' => 'file-plus-minus' ),
					array( 'fa-regular fa-file-plus' => 'file-plus' ),
					array( 'fa-regular fa-file-powerpoint' => 'file-powerpoint' ),
					array( 'fa-regular fa-file-prescription' => 'file-prescription' ),
					array( 'fa-regular fa-file-shield' => 'file-shield' ),
					array( 'fa-regular fa-file-signature' => 'file-signature' ),
					array( 'fa-regular fa-file-slash' => 'file-slash' ),
					array( 'fa-regular fa-file-spreadsheet' => 'file-spreadsheet' ),
					array( 'fa-regular fa-file-user' => 'file-user' ),
					array( 'fa-regular fa-file-video' => 'file-video' ),
					array( 'fa-regular fa-file-waveform' => 'file-waveform' ),
					array( 'fa-regular fa-file-word' => 'file-word' ),
					array( 'fa-regular fa-file-xmark' => 'file-xmark' ),
					array( 'fa-regular fa-file-zip' => 'file-zip' ),
					array( 'fa-regular fa-file-zipper' => 'file-zipper' ),
					array( 'fa-regular fa-file' => 'file' ),
					array( 'fa-regular fa-files-medical' => 'files-medical' ),
					array( 'fa-regular fa-files' => 'files' ),
					array( 'fa-regular fa-fill-drip' => 'fill-drip' ),
					array( 'fa-regular fa-fill' => 'fill' ),
					array( 'fa-regular fa-film-canister' => 'film-canister' ),
					array( 'fa-regular fa-film-simple' => 'film-simple' ),
					array( 'fa-regular fa-film-slash' => 'film-slash' ),
					array( 'fa-regular fa-film' => 'film' ),
					array( 'fa-regular fa-films' => 'films' ),
					array( 'fa-regular fa-filter-circle-dollar' => 'filter-circle-dollar' ),
					array( 'fa-regular fa-filter-circle-xmark' => 'filter-circle-xmark' ),
					array( 'fa-regular fa-filter-list' => 'filter-list' ),
					array( 'fa-regular fa-filter-slash' => 'filter-slash' ),
					array( 'fa-regular fa-filter' => 'filter' ),
					array( 'fa-regular fa-filters' => 'filters' ),
					array( 'fa-regular fa-fingerprint' => 'fingerprint' ),
					array( 'fa-regular fa-fire-burner' => 'fire-burner' ),
					array( 'fa-regular fa-fire-extinguisher' => 'fire-extinguisher' ),
					array( 'fa-regular fa-fire-flame-curved' => 'fire-flame-curved' ),
					array( 'fa-regular fa-fire-flame-simple' => 'fire-flame-simple' ),
					array( 'fa-regular fa-fire-flame' => 'fire-flame' ),
					array( 'fa-regular fa-fire-hydrant' => 'fire-hydrant' ),
					array( 'fa-regular fa-fire-smoke' => 'fire-smoke' ),
					array( 'fa-regular fa-fire' => 'fire' ),
					array( 'fa-regular fa-fireplace' => 'fireplace' ),
					array( 'fa-regular fa-fish-bones' => 'fish-bones' ),
					array( 'fa-regular fa-fish-cooked' => 'fish-cooked' ),
					array( 'fa-regular fa-fish-fins' => 'fish-fins' ),
					array( 'fa-regular fa-fish' => 'fish' ),
					array( 'fa-regular fa-fishing-rod' => 'fishing-rod' ),
					array( 'fa-regular fa-flag-checkered' => 'flag-checkered' ),
					array( 'fa-regular fa-flag-pennant' => 'flag-pennant' ),
					array( 'fa-regular fa-flag-swallowtail' => 'flag-swallowtail' ),
					array( 'fa-regular fa-flag-usa' => 'flag-usa' ),
					array( 'fa-regular fa-flag' => 'flag' ),
					array( 'fa-regular fa-flashlight' => 'flashlight' ),
					array( 'fa-regular fa-flask-gear' => 'flask-gear' ),
					array( 'fa-regular fa-flask-round-poison' => 'flask-round-poison' ),
					array( 'fa-regular fa-flask-round-potion' => 'flask-round-potion' ),
					array( 'fa-regular fa-flask-vial' => 'flask-vial' ),
					array( 'fa-regular fa-flask' => 'flask' ),
					array( 'fa-regular fa-flatbread-stuffed' => 'flatbread-stuffed' ),
					array( 'fa-regular fa-flatbread' => 'flatbread' ),
					array( 'fa-regular fa-floppy-disk-circle-arrow-right' => 'floppy-disk-circle-arrow-right' ),
					array( 'fa-regular fa-floppy-disk-circle-xmark' => 'floppy-disk-circle-xmark' ),
					array( 'fa-regular fa-floppy-disk-pen' => 'floppy-disk-pen' ),
					array( 'fa-regular fa-floppy-disk' => 'floppy-disk' ),
					array( 'fa-regular fa-floppy-disks' => 'floppy-disks' ),
					array( 'fa-regular fa-florin-sign' => 'florin-sign' ),
					array( 'fa-regular fa-flower-daffodil' => 'flower-daffodil' ),
					array( 'fa-regular fa-flower-tulip' => 'flower-tulip' ),
					array( 'fa-regular fa-flower' => 'flower' ),
					array( 'fa-regular fa-flute' => 'flute' ),
					array( 'fa-regular fa-flux-capacitor' => 'flux-capacitor' ),
					array( 'fa-regular fa-flying-disc' => 'flying-disc' ),
					array( 'fa-regular fa-folder-arrow-down' => 'folder-arrow-down' ),
					array( 'fa-regular fa-folder-arrow-up' => 'folder-arrow-up' ),
					array( 'fa-regular fa-folder-bookmark' => 'folder-bookmark' ),
					array( 'fa-regular fa-folder-closed' => 'folder-closed' ),
					array( 'fa-regular fa-folder-gear' => 'folder-gear' ),
					array( 'fa-regular fa-folder-grid' => 'folder-grid' ),
					array( 'fa-regular fa-folder-heart' => 'folder-heart' ),
					array( 'fa-regular fa-folder-image' => 'folder-image' ),
					array( 'fa-regular fa-folder-magnifying-glass' => 'folder-magnifying-glass' ),
					array( 'fa-regular fa-folder-medical' => 'folder-medical' ),
					array( 'fa-regular fa-folder-minus' => 'folder-minus' ),
					array( 'fa-regular fa-folder-music' => 'folder-music' ),
					array( 'fa-regular fa-folder-open' => 'folder-open' ),
					array( 'fa-regular fa-folder-plus' => 'folder-plus' ),
					array( 'fa-regular fa-folder-tree' => 'folder-tree' ),
					array( 'fa-regular fa-folder-user' => 'folder-user' ),
					array( 'fa-regular fa-folder-xmark' => 'folder-xmark' ),
					array( 'fa-regular fa-folder' => 'folder' ),
					array( 'fa-regular fa-folders' => 'folders' ),
					array( 'fa-regular fa-fondue-pot' => 'fondue-pot' ),
					array( 'fa-regular fa-font-awesome' => 'font-awesome' ),
					array( 'fa-regular fa-font-case' => 'font-case' ),
					array( 'fa-regular fa-font' => 'font' ),
					array( 'fa-regular fa-football-helmet' => 'football-helmet' ),
					array( 'fa-regular fa-football' => 'football' ),
					array( 'fa-regular fa-fork-knife' => 'fork-knife' ),
					array( 'fa-regular fa-fork' => 'fork' ),
					array( 'fa-regular fa-forklift' => 'forklift' ),
					array( 'fa-regular fa-fort' => 'fort' ),
					array( 'fa-regular fa-forward-fast' => 'forward-fast' ),
					array( 'fa-regular fa-forward-step' => 'forward-step' ),
					array( 'fa-regular fa-forward' => 'forward' ),
					array( 'fa-regular fa-frame' => 'frame' ),
					array( 'fa-regular fa-franc-sign' => 'franc-sign' ),
					array( 'fa-regular fa-french-fries' => 'french-fries' ),
					array( 'fa-regular fa-frog' => 'frog' ),
					array( 'fa-regular fa-function' => 'function' ),
					array( 'fa-regular fa-futbol' => 'futbol' ),
					array( 'fa-regular fa-g' => 'g' ),
					array( 'fa-regular fa-galaxy' => 'galaxy' ),
					array( 'fa-regular fa-gallery-thumbnails' => 'gallery-thumbnails' ),
					array( 'fa-regular fa-game-board-simple' => 'game-board-simple' ),
					array( 'fa-regular fa-game-board' => 'game-board' ),
					array( 'fa-regular fa-game-console-handheld-crank' => 'game-console-handheld-crank' ),
					array( 'fa-regular fa-game-console-handheld' => 'game-console-handheld' ),
					array( 'fa-regular fa-gamepad-modern' => 'gamepad-modern' ),
					array( 'fa-regular fa-gamepad' => 'gamepad' ),
					array( 'fa-regular fa-garage-car' => 'garage-car' ),
					array( 'fa-regular fa-garage-open' => 'garage-open' ),
					array( 'fa-regular fa-garage' => 'garage' ),
					array( 'fa-regular fa-garlic' => 'garlic' ),
					array( 'fa-regular fa-gas-pump-slash' => 'gas-pump-slash' ),
					array( 'fa-regular fa-gas-pump' => 'gas-pump' ),
					array( 'fa-regular fa-gauge-circle-bolt' => 'gauge-circle-bolt' ),
					array( 'fa-regular fa-gauge-circle-minus' => 'gauge-circle-minus' ),
					array( 'fa-regular fa-gauge-circle-plus' => 'gauge-circle-plus' ),
					array( 'fa-regular fa-gauge-high' => 'gauge-high' ),
					array( 'fa-regular fa-gauge-low' => 'gauge-low' ),
					array( 'fa-regular fa-gauge-max' => 'gauge-max' ),
					array( 'fa-regular fa-gauge-min' => 'gauge-min' ),
					array( 'fa-regular fa-gauge-simple-high' => 'gauge-simple-high' ),
					array( 'fa-regular fa-gauge-simple-low' => 'gauge-simple-low' ),
					array( 'fa-regular fa-gauge-simple-max' => 'gauge-simple-max' ),
					array( 'fa-regular fa-gauge-simple-min' => 'gauge-simple-min' ),
					array( 'fa-regular fa-gauge-simple' => 'gauge-simple' ),
					array( 'fa-regular fa-gauge' => 'gauge' ),
					array( 'fa-regular fa-gavel' => 'gavel' ),
					array( 'fa-regular fa-gear-code' => 'gear-code' ),
					array( 'fa-regular fa-gear-complex-code' => 'gear-complex-code' ),
					array( 'fa-regular fa-gear-complex' => 'gear-complex' ),
					array( 'fa-regular fa-gear' => 'gear' ),
					array( 'fa-regular fa-gears' => 'gears' ),
					array( 'fa-regular fa-gem' => 'gem' ),
					array( 'fa-regular fa-genderless' => 'genderless' ),
					array( 'fa-regular fa-ghost' => 'ghost' ),
					array( 'fa-regular fa-gif' => 'gif' ),
					array( 'fa-regular fa-gift-card' => 'gift-card' ),
					array( 'fa-regular fa-gift' => 'gift' ),
					array( 'fa-regular fa-gifts' => 'gifts' ),
					array( 'fa-regular fa-gingerbread-man' => 'gingerbread-man' ),
					array( 'fa-regular fa-glass-citrus' => 'glass-citrus' ),
					array( 'fa-regular fa-glass-empty' => 'glass-empty' ),
					array( 'fa-regular fa-glass-half' => 'glass-half' ),
					array( 'fa-regular fa-glass-water-droplet' => 'glass-water-droplet' ),
					array( 'fa-regular fa-glass-water' => 'glass-water' ),
					array( 'fa-regular fa-glass' => 'glass' ),
					array( 'fa-regular fa-glasses-round' => 'glasses-round' ),
					array( 'fa-regular fa-glasses' => 'glasses' ),
					array( 'fa-regular fa-globe-pointer' => 'globe-pointer' ),
					array( 'fa-regular fa-globe-snow' => 'globe-snow' ),
					array( 'fa-regular fa-globe-stand' => 'globe-stand' ),
					array( 'fa-regular fa-globe' => 'globe' ),
					array( 'fa-regular fa-goal-net' => 'goal-net' ),
					array( 'fa-regular fa-golf-ball-tee' => 'golf-ball-tee' ),
					array( 'fa-regular fa-golf-club' => 'golf-club' ),
					array( 'fa-regular fa-golf-flag-hole' => 'golf-flag-hole' ),
					array( 'fa-regular fa-gopuram' => 'gopuram' ),
					array( 'fa-regular fa-graduation-cap' => 'graduation-cap' ),
					array( 'fa-regular fa-gramophone' => 'gramophone' ),
					array( 'fa-regular fa-grapes' => 'grapes' ),
					array( 'fa-regular fa-grate-droplet' => 'grate-droplet' ),
					array( 'fa-regular fa-grate' => 'grate' ),
					array( 'fa-regular fa-greater-than-equal' => 'greater-than-equal' ),
					array( 'fa-regular fa-greater-than' => 'greater-than' ),
					array( 'fa-regular fa-grid-2-plus' => 'grid-2-plus' ),
					array( 'fa-regular fa-grid-2' => 'grid-2' ),
					array( 'fa-regular fa-grid-4' => 'grid-4' ),
					array( 'fa-regular fa-grid-5' => 'grid-5' ),
					array( 'fa-regular fa-grid-dividers' => 'grid-dividers' ),
					array( 'fa-regular fa-grid-horizontal' => 'grid-horizontal' ),
					array( 'fa-regular fa-grid-round-2-plus' => 'grid-round-2-plus' ),
					array( 'fa-regular fa-grid-round-2' => 'grid-round-2' ),
					array( 'fa-regular fa-grid-round-4' => 'grid-round-4' ),
					array( 'fa-regular fa-grid-round-5' => 'grid-round-5' ),
					array( 'fa-regular fa-grid-round' => 'grid-round' ),
					array( 'fa-regular fa-grid' => 'grid' ),
					array( 'fa-regular fa-grill-fire' => 'grill-fire' ),
					array( 'fa-regular fa-grill-hot' => 'grill-hot' ),
					array( 'fa-regular fa-grill' => 'grill' ),
					array( 'fa-regular fa-grip-dots-vertical' => 'grip-dots-vertical' ),
					array( 'fa-regular fa-grip-dots' => 'grip-dots' ),
					array( 'fa-regular fa-grip-lines-vertical' => 'grip-lines-vertical' ),
					array( 'fa-regular fa-grip-lines' => 'grip-lines' ),
					array( 'fa-regular fa-grip-vertical' => 'grip-vertical' ),
					array( 'fa-regular fa-grip' => 'grip' ),
					array( 'fa-regular fa-group-arrows-rotate' => 'group-arrows-rotate' ),
					array( 'fa-regular fa-guarani-sign' => 'guarani-sign' ),
					array( 'fa-regular fa-guitar-electric' => 'guitar-electric' ),
					array( 'fa-regular fa-guitar' => 'guitar' ),
					array( 'fa-regular fa-guitars' => 'guitars' ),
					array( 'fa-regular fa-gun-slash' => 'gun-slash' ),
					array( 'fa-regular fa-gun-squirt' => 'gun-squirt' ),
					array( 'fa-regular fa-gun' => 'gun' ),
					array( 'fa-regular fa-h' => 'h' ),
					array( 'fa-regular fa-h1' => 'h1' ),
					array( 'fa-regular fa-h2' => 'h2' ),
					array( 'fa-regular fa-h3' => 'h3' ),
					array( 'fa-regular fa-h4' => 'h4' ),
					array( 'fa-regular fa-h5' => 'h5' ),
					array( 'fa-regular fa-h6' => 'h6' ),
					array( 'fa-regular fa-hammer-crash' => 'hammer-crash' ),
					array( 'fa-regular fa-hammer-war' => 'hammer-war' ),
					array( 'fa-regular fa-hammer' => 'hammer' ),
					array( 'fa-regular fa-hamsa' => 'hamsa' ),
					array( 'fa-regular fa-hand-back-fist' => 'hand-back-fist' ),
					array( 'fa-regular fa-hand-back-point-down' => 'hand-back-point-down' ),
					array( 'fa-regular fa-hand-back-point-left' => 'hand-back-point-left' ),
					array( 'fa-regular fa-hand-back-point-ribbon' => 'hand-back-point-ribbon' ),
					array( 'fa-regular fa-hand-back-point-right' => 'hand-back-point-right' ),
					array( 'fa-regular fa-hand-back-point-up' => 'hand-back-point-up' ),
					array( 'fa-regular fa-hand-dots' => 'hand-dots' ),
					array( 'fa-regular fa-hand-fingers-crossed' => 'hand-fingers-crossed' ),
					array( 'fa-regular fa-hand-fist' => 'hand-fist' ),
					array( 'fa-regular fa-hand-heart' => 'hand-heart' ),
					array( 'fa-regular fa-hand-holding-box' => 'hand-holding-box' ),
					array( 'fa-regular fa-hand-holding-dollar' => 'hand-holding-dollar' ),
					array( 'fa-regular fa-hand-holding-droplet' => 'hand-holding-droplet' ),
					array( 'fa-regular fa-hand-holding-hand' => 'hand-holding-hand' ),
					array( 'fa-regular fa-hand-holding-heart' => 'hand-holding-heart' ),
					array( 'fa-regular fa-hand-holding-magic' => 'hand-holding-magic' ),
					array( 'fa-regular fa-hand-holding-medical' => 'hand-holding-medical' ),
					array( 'fa-regular fa-hand-holding-seedling' => 'hand-holding-seedling' ),
					array( 'fa-regular fa-hand-holding-skull' => 'hand-holding-skull' ),
					array( 'fa-regular fa-hand-holding' => 'hand-holding' ),
					array( 'fa-regular fa-hand-horns' => 'hand-horns' ),
					array( 'fa-regular fa-hand-lizard' => 'hand-lizard' ),
					array( 'fa-regular fa-hand-love' => 'hand-love' ),
					array( 'fa-regular fa-hand-middle-finger' => 'hand-middle-finger' ),
					array( 'fa-regular fa-hand-peace' => 'hand-peace' ),
					array( 'fa-regular fa-hand-point-down' => 'hand-point-down' ),
					array( 'fa-regular fa-hand-point-left' => 'hand-point-left' ),
					array( 'fa-regular fa-hand-point-ribbon' => 'hand-point-ribbon' ),
					array( 'fa-regular fa-hand-point-right' => 'hand-point-right' ),
					array( 'fa-regular fa-hand-point-up' => 'hand-point-up' ),
					array( 'fa-regular fa-hand-pointer' => 'hand-pointer' ),
					array( 'fa-regular fa-hand-scissors' => 'hand-scissors' ),
					array( 'fa-regular fa-hand-sparkles' => 'hand-sparkles' ),
					array( 'fa-regular fa-hand-spock' => 'hand-spock' ),
					array( 'fa-regular fa-hand-wave' => 'hand-wave' ),
					array( 'fa-regular fa-hand' => 'hand' ),
					array( 'fa-regular fa-handcuffs' => 'handcuffs' ),
					array( 'fa-regular fa-hands-asl-interpreting' => 'hands-asl-interpreting' ),
					array( 'fa-regular fa-hands-bound' => 'hands-bound' ),
					array( 'fa-regular fa-hands-bubbles' => 'hands-bubbles' ),
					array( 'fa-regular fa-hands-clapping' => 'hands-clapping' ),
					array( 'fa-regular fa-hands-holding-child' => 'hands-holding-child' ),
					array( 'fa-regular fa-hands-holding-circle' => 'hands-holding-circle' ),
					array( 'fa-regular fa-hands-holding-diamond' => 'hands-holding-diamond' ),
					array( 'fa-regular fa-hands-holding-dollar' => 'hands-holding-dollar' ),
					array( 'fa-regular fa-hands-holding-heart' => 'hands-holding-heart' ),
					array( 'fa-regular fa-hands-holding' => 'hands-holding' ),
					array( 'fa-regular fa-hands-praying' => 'hands-praying' ),
					array( 'fa-regular fa-hands' => 'hands' ),
					array( 'fa-regular fa-handshake-angle' => 'handshake-angle' ),
					array( 'fa-regular fa-handshake-simple-slash' => 'handshake-simple-slash' ),
					array( 'fa-regular fa-handshake-simple' => 'handshake-simple' ),
					array( 'fa-regular fa-handshake-slash' => 'handshake-slash' ),
					array( 'fa-regular fa-handshake' => 'handshake' ),
					array( 'fa-regular fa-hanukiah' => 'hanukiah' ),
					array( 'fa-regular fa-hard-drive' => 'hard-drive' ),
					array( 'fa-regular fa-hashtag-lock' => 'hashtag-lock' ),
					array( 'fa-regular fa-hashtag' => 'hashtag' ),
					array( 'fa-regular fa-hat-beach' => 'hat-beach' ),
					array( 'fa-regular fa-hat-chef' => 'hat-chef' ),
					array( 'fa-regular fa-hat-cowboy-side' => 'hat-cowboy-side' ),
					array( 'fa-regular fa-hat-cowboy' => 'hat-cowboy' ),
					array( 'fa-regular fa-hat-santa' => 'hat-santa' ),
					array( 'fa-regular fa-hat-winter' => 'hat-winter' ),
					array( 'fa-regular fa-hat-witch' => 'hat-witch' ),
					array( 'fa-regular fa-hat-wizard' => 'hat-wizard' ),
					array( 'fa-regular fa-head-side-brain' => 'head-side-brain' ),
					array( 'fa-regular fa-head-side-cough-slash' => 'head-side-cough-slash' ),
					array( 'fa-regular fa-head-side-cough' => 'head-side-cough' ),
					array( 'fa-regular fa-head-side-gear' => 'head-side-gear' ),
					array( 'fa-regular fa-head-side-goggles' => 'head-side-goggles' ),
					array( 'fa-regular fa-head-side-headphones' => 'head-side-headphones' ),
					array( 'fa-regular fa-head-side-heart' => 'head-side-heart' ),
					array( 'fa-regular fa-head-side-mask' => 'head-side-mask' ),
					array( 'fa-regular fa-head-side-medical' => 'head-side-medical' ),
					array( 'fa-regular fa-head-side-virus' => 'head-side-virus' ),
					array( 'fa-regular fa-head-side' => 'head-side' ),
					array( 'fa-regular fa-heading' => 'heading' ),
					array( 'fa-regular fa-headphones-simple' => 'headphones-simple' ),
					array( 'fa-regular fa-headphones' => 'headphones' ),
					array( 'fa-regular fa-headset' => 'headset' ),
					array( 'fa-regular fa-heart-circle-bolt' => 'heart-circle-bolt' ),
					array( 'fa-regular fa-heart-circle-check' => 'heart-circle-check' ),
					array( 'fa-regular fa-heart-circle-exclamation' => 'heart-circle-exclamation' ),
					array( 'fa-regular fa-heart-circle-minus' => 'heart-circle-minus' ),
					array( 'fa-regular fa-heart-circle-plus' => 'heart-circle-plus' ),
					array( 'fa-regular fa-heart-circle-xmark' => 'heart-circle-xmark' ),
					array( 'fa-regular fa-heart-crack' => 'heart-crack' ),
					array( 'fa-regular fa-heart-half-stroke' => 'heart-half-stroke' ),
					array( 'fa-regular fa-heart-half' => 'heart-half' ),
					array( 'fa-regular fa-heart-pulse' => 'heart-pulse' ),
					array( 'fa-regular fa-heart' => 'heart' ),
					array( 'fa-regular fa-heat' => 'heat' ),
					array( 'fa-regular fa-helicopter-symbol' => 'helicopter-symbol' ),
					array( 'fa-regular fa-helicopter' => 'helicopter' ),
					array( 'fa-regular fa-helmet-battle' => 'helmet-battle' ),
					array( 'fa-regular fa-helmet-safety' => 'helmet-safety' ),
					array( 'fa-regular fa-helmet-un' => 'helmet-un' ),
					array( 'fa-regular fa-hexagon-check' => 'hexagon-check' ),
					array( 'fa-regular fa-hexagon-divide' => 'hexagon-divide' ),
					array( 'fa-regular fa-hexagon-exclamation' => 'hexagon-exclamation' ),
					array( 'fa-regular fa-hexagon-image' => 'hexagon-image' ),
					array( 'fa-regular fa-hexagon-minus' => 'hexagon-minus' ),
					array( 'fa-regular fa-hexagon-plus' => 'hexagon-plus' ),
					array( 'fa-regular fa-hexagon-vertical-nft-slanted' => 'hexagon-vertical-nft-slanted' ),
					array( 'fa-regular fa-hexagon-vertical-nft' => 'hexagon-vertical-nft' ),
					array( 'fa-regular fa-hexagon-xmark' => 'hexagon-xmark' ),
					array( 'fa-regular fa-hexagon' => 'hexagon' ),
					array( 'fa-regular fa-high-definition' => 'high-definition' ),
					array( 'fa-regular fa-highlighter-line' => 'highlighter-line' ),
					array( 'fa-regular fa-highlighter' => 'highlighter' ),
					array( 'fa-regular fa-hill-avalanche' => 'hill-avalanche' ),
					array( 'fa-regular fa-hill-rockslide' => 'hill-rockslide' ),
					array( 'fa-regular fa-hippo' => 'hippo' ),
					array( 'fa-regular fa-hockey-mask' => 'hockey-mask' ),
					array( 'fa-regular fa-hockey-puck' => 'hockey-puck' ),
					array( 'fa-regular fa-hockey-stick-puck' => 'hockey-stick-puck' ),
					array( 'fa-regular fa-hockey-sticks' => 'hockey-sticks' ),
					array( 'fa-regular fa-holly-berry' => 'holly-berry' ),
					array( 'fa-regular fa-honey-pot' => 'honey-pot' ),
					array( 'fa-regular fa-hood-cloak' => 'hood-cloak' ),
					array( 'fa-regular fa-horizontal-rule' => 'horizontal-rule' ),
					array( 'fa-regular fa-horse-head' => 'horse-head' ),
					array( 'fa-regular fa-horse-saddle' => 'horse-saddle' ),
					array( 'fa-regular fa-horse' => 'horse' ),
					array( 'fa-regular fa-hose-reel' => 'hose-reel' ),
					array( 'fa-regular fa-hose' => 'hose' ),
					array( 'fa-regular fa-hospital-user' => 'hospital-user' ),
					array( 'fa-regular fa-hospital' => 'hospital' ),
					array( 'fa-regular fa-hospitals' => 'hospitals' ),
					array( 'fa-regular fa-hot-tub-person' => 'hot-tub-person' ),
					array( 'fa-regular fa-hotdog' => 'hotdog' ),
					array( 'fa-regular fa-hotel' => 'hotel' ),
					array( 'fa-regular fa-hourglass-clock' => 'hourglass-clock' ),
					array( 'fa-regular fa-hourglass-end' => 'hourglass-end' ),
					array( 'fa-regular fa-hourglass-half' => 'hourglass-half' ),
					array( 'fa-regular fa-hourglass-start' => 'hourglass-start' ),
					array( 'fa-regular fa-hourglass' => 'hourglass' ),
					array( 'fa-regular fa-house-blank' => 'house-blank' ),
					array( 'fa-regular fa-house-building' => 'house-building' ),
					array( 'fa-regular fa-house-chimney-blank' => 'house-chimney-blank' ),
					array( 'fa-regular fa-house-chimney-crack' => 'house-chimney-crack' ),
					array( 'fa-regular fa-house-chimney-heart' => 'house-chimney-heart' ),
					array( 'fa-regular fa-house-chimney-medical' => 'house-chimney-medical' ),
					array( 'fa-regular fa-house-chimney-user' => 'house-chimney-user' ),
					array( 'fa-regular fa-house-chimney-window' => 'house-chimney-window' ),
					array( 'fa-regular fa-house-chimney' => 'house-chimney' ),
					array( 'fa-regular fa-house-circle-check' => 'house-circle-check' ),
					array( 'fa-regular fa-house-circle-exclamation' => 'house-circle-exclamation' ),
					array( 'fa-regular fa-house-circle-xmark' => 'house-circle-xmark' ),
					array( 'fa-regular fa-house-crack' => 'house-crack' ),
					array( 'fa-regular fa-house-day' => 'house-day' ),
					array( 'fa-regular fa-house-fire' => 'house-fire' ),
					array( 'fa-regular fa-house-flag' => 'house-flag' ),
					array( 'fa-regular fa-house-flood-water-circle-arrow-right' => 'house-flood-water-circle-arrow-right' ),
					array( 'fa-regular fa-house-flood-water' => 'house-flood-water' ),
					array( 'fa-regular fa-house-heart' => 'house-heart' ),
					array( 'fa-regular fa-house-laptop' => 'house-laptop' ),
					array( 'fa-regular fa-house-lock' => 'house-lock' ),
					array( 'fa-regular fa-house-medical-circle-check' => 'house-medical-circle-check' ),
					array( 'fa-regular fa-house-medical-circle-exclamation' => 'house-medical-circle-exclamation' ),
					array( 'fa-regular fa-house-medical-circle-xmark' => 'house-medical-circle-xmark' ),
					array( 'fa-regular fa-house-medical-flag' => 'house-medical-flag' ),
					array( 'fa-regular fa-house-medical' => 'house-medical' ),
					array( 'fa-regular fa-house-night' => 'house-night' ),
					array( 'fa-regular fa-house-person-leave' => 'house-person-leave' ),
					array( 'fa-regular fa-house-person-return' => 'house-person-return' ),
					array( 'fa-regular fa-house-signal' => 'house-signal' ),
					array( 'fa-regular fa-house-tree' => 'house-tree' ),
					array( 'fa-regular fa-house-tsunami' => 'house-tsunami' ),
					array( 'fa-regular fa-house-turret' => 'house-turret' ),
					array( 'fa-regular fa-house-user' => 'house-user' ),
					array( 'fa-regular fa-house-water' => 'house-water' ),
					array( 'fa-regular fa-house-window' => 'house-window' ),
					array( 'fa-regular fa-house' => 'house' ),
					array( 'fa-regular fa-hryvnia-sign' => 'hryvnia-sign' ),
					array( 'fa-regular fa-hundred-points' => 'hundred-points' ),
					array( 'fa-regular fa-hurricane' => 'hurricane' ),
					array( 'fa-regular fa-hyphen' => 'hyphen' ),
					array( 'fa-regular fa-i-cursor' => 'i-cursor' ),
					array( 'fa-regular fa-i' => 'i' ),
					array( 'fa-regular fa-ice-cream' => 'ice-cream' ),
					array( 'fa-regular fa-ice-skate' => 'ice-skate' ),
					array( 'fa-regular fa-icicles' => 'icicles' ),
					array( 'fa-regular fa-icons' => 'icons' ),
					array( 'fa-regular fa-id-badge' => 'id-badge' ),
					array( 'fa-regular fa-id-card-clip' => 'id-card-clip' ),
					array( 'fa-regular fa-id-card' => 'id-card' ),
					array( 'fa-regular fa-igloo' => 'igloo' ),
					array( 'fa-regular fa-image-landscape' => 'image-landscape' ),
					array( 'fa-regular fa-image-polaroid-user' => 'image-polaroid-user' ),
					array( 'fa-regular fa-image-polaroid' => 'image-polaroid' ),
					array( 'fa-regular fa-image-portrait' => 'image-portrait' ),
					array( 'fa-regular fa-image-slash' => 'image-slash' ),
					array( 'fa-regular fa-image-user' => 'image-user' ),
					array( 'fa-regular fa-image' => 'image' ),
					array( 'fa-regular fa-images-user' => 'images-user' ),
					array( 'fa-regular fa-images' => 'images' ),
					array( 'fa-regular fa-inbox-full' => 'inbox-full' ),
					array( 'fa-regular fa-inbox-in' => 'inbox-in' ),
					array( 'fa-regular fa-inbox-out' => 'inbox-out' ),
					array( 'fa-regular fa-inbox' => 'inbox' ),
					array( 'fa-regular fa-inboxes' => 'inboxes' ),
					array( 'fa-regular fa-indent' => 'indent' ),
					array( 'fa-regular fa-indian-rupee-sign' => 'indian-rupee-sign' ),
					array( 'fa-regular fa-industry-windows' => 'industry-windows' ),
					array( 'fa-regular fa-industry' => 'industry' ),
					array( 'fa-regular fa-infinity' => 'infinity' ),
					array( 'fa-regular fa-info' => 'info' ),
					array( 'fa-regular fa-inhaler' => 'inhaler' ),
					array( 'fa-regular fa-input-numeric' => 'input-numeric' ),
					array( 'fa-regular fa-input-pipe' => 'input-pipe' ),
					array( 'fa-regular fa-input-text' => 'input-text' ),
					array( 'fa-regular fa-integral' => 'integral' ),
					array( 'fa-regular fa-interrobang' => 'interrobang' ),
					array( 'fa-regular fa-intersection' => 'intersection' ),
					array( 'fa-regular fa-island-tropical' => 'island-tropical' ),
					array( 'fa-regular fa-italic' => 'italic' ),
					array( 'fa-regular fa-j' => 'j' ),
					array( 'fa-regular fa-jack-o-lantern' => 'jack-o-lantern' ),
					array( 'fa-regular fa-jar-wheat' => 'jar-wheat' ),
					array( 'fa-regular fa-jar' => 'jar' ),
					array( 'fa-regular fa-jedi' => 'jedi' ),
					array( 'fa-regular fa-jet-fighter-up' => 'jet-fighter-up' ),
					array( 'fa-regular fa-jet-fighter' => 'jet-fighter' ),
					array( 'fa-regular fa-joint' => 'joint' ),
					array( 'fa-regular fa-joystick' => 'joystick' ),
					array( 'fa-regular fa-jug-bottle' => 'jug-bottle' ),
					array( 'fa-regular fa-jug-detergent' => 'jug-detergent' ),
					array( 'fa-regular fa-jug' => 'jug' ),
					array( 'fa-regular fa-k' => 'k' ),
					array( 'fa-regular fa-kaaba' => 'kaaba' ),
					array( 'fa-regular fa-kazoo' => 'kazoo' ),
					array( 'fa-regular fa-kerning' => 'kerning' ),
					array( 'fa-regular fa-key-skeleton-left-right' => 'key-skeleton-left-right' ),
					array( 'fa-regular fa-key-skeleton' => 'key-skeleton' ),
					array( 'fa-regular fa-key' => 'key' ),
					array( 'fa-regular fa-keyboard-brightness-low' => 'keyboard-brightness-low' ),
					array( 'fa-regular fa-keyboard-brightness' => 'keyboard-brightness' ),
					array( 'fa-regular fa-keyboard-down' => 'keyboard-down' ),
					array( 'fa-regular fa-keyboard-left' => 'keyboard-left' ),
					array( 'fa-regular fa-keyboard' => 'keyboard' ),
					array( 'fa-regular fa-keynote' => 'keynote' ),
					array( 'fa-regular fa-khanda' => 'khanda' ),
					array( 'fa-regular fa-kidneys' => 'kidneys' ),
					array( 'fa-regular fa-kip-sign' => 'kip-sign' ),
					array( 'fa-regular fa-kit-medical' => 'kit-medical' ),
					array( 'fa-regular fa-kitchen-set' => 'kitchen-set' ),
					array( 'fa-regular fa-kite' => 'kite' ),
					array( 'fa-regular fa-kiwi-bird' => 'kiwi-bird' ),
					array( 'fa-regular fa-kiwi-fruit' => 'kiwi-fruit' ),
					array( 'fa-regular fa-knife-kitchen' => 'knife-kitchen' ),
					array( 'fa-regular fa-knife' => 'knife' ),
					array( 'fa-regular fa-l' => 'l' ),
					array( 'fa-regular fa-lacrosse-stick-ball' => 'lacrosse-stick-ball' ),
					array( 'fa-regular fa-lacrosse-stick' => 'lacrosse-stick' ),
					array( 'fa-regular fa-lambda' => 'lambda' ),
					array( 'fa-regular fa-lamp-desk' => 'lamp-desk' ),
					array( 'fa-regular fa-lamp-floor' => 'lamp-floor' ),
					array( 'fa-regular fa-lamp-street' => 'lamp-street' ),
					array( 'fa-regular fa-lamp' => 'lamp' ),
					array( 'fa-regular fa-land-mine-on' => 'land-mine-on' ),
					array( 'fa-regular fa-landmark-dome' => 'landmark-dome' ),
					array( 'fa-regular fa-landmark-flag' => 'landmark-flag' ),
					array( 'fa-regular fa-landmark' => 'landmark' ),
					array( 'fa-regular fa-language' => 'language' ),
					array( 'fa-regular fa-laptop-arrow-down' => 'laptop-arrow-down' ),
					array( 'fa-regular fa-laptop-binary' => 'laptop-binary' ),
					array( 'fa-regular fa-laptop-code' => 'laptop-code' ),
					array( 'fa-regular fa-laptop-file' => 'laptop-file' ),
					array( 'fa-regular fa-laptop-medical' => 'laptop-medical' ),
					array( 'fa-regular fa-laptop-mobile' => 'laptop-mobile' ),
					array( 'fa-regular fa-laptop-slash' => 'laptop-slash' ),
					array( 'fa-regular fa-laptop' => 'laptop' ),
					array( 'fa-regular fa-lari-sign' => 'lari-sign' ),
					array( 'fa-regular fa-lasso-sparkles' => 'lasso-sparkles' ),
					array( 'fa-regular fa-lasso' => 'lasso' ),
					array( 'fa-regular fa-layer-group' => 'layer-group' ),
					array( 'fa-regular fa-layer-minus' => 'layer-minus' ),
					array( 'fa-regular fa-layer-plus' => 'layer-plus' ),
					array( 'fa-regular fa-leaf-heart' => 'leaf-heart' ),
					array( 'fa-regular fa-leaf-maple' => 'leaf-maple' ),
					array( 'fa-regular fa-leaf-oak' => 'leaf-oak' ),
					array( 'fa-regular fa-leaf' => 'leaf' ),
					array( 'fa-regular fa-leafy-green' => 'leafy-green' ),
					array( 'fa-regular fa-left-from-line' => 'left-from-line' ),
					array( 'fa-regular fa-left-long-to-line' => 'left-long-to-line' ),
					array( 'fa-regular fa-left-long' => 'left-long' ),
					array( 'fa-regular fa-left-right' => 'left-right' ),
					array( 'fa-regular fa-left-to-line' => 'left-to-line' ),
					array( 'fa-regular fa-left' => 'left' ),
					array( 'fa-regular fa-lemon' => 'lemon' ),
					array( 'fa-regular fa-less-than-equal' => 'less-than-equal' ),
					array( 'fa-regular fa-less-than' => 'less-than' ),
					array( 'fa-regular fa-life-ring' => 'life-ring' ),
					array( 'fa-regular fa-light-ceiling' => 'light-ceiling' ),
					array( 'fa-regular fa-light-emergency-on' => 'light-emergency-on' ),
					array( 'fa-regular fa-light-emergency' => 'light-emergency' ),
					array( 'fa-regular fa-light-switch-off' => 'light-switch-off' ),
					array( 'fa-regular fa-light-switch-on' => 'light-switch-on' ),
					array( 'fa-regular fa-light-switch' => 'light-switch' ),
					array( 'fa-regular fa-lightbulb-cfl-on' => 'lightbulb-cfl-on' ),
					array( 'fa-regular fa-lightbulb-cfl' => 'lightbulb-cfl' ),
					array( 'fa-regular fa-lightbulb-dollar' => 'lightbulb-dollar' ),
					array( 'fa-regular fa-lightbulb-exclamatin-on' => 'lightbulb-exclamatin-on' ),
					array( 'fa-regular fa-lightbulb-exclamation' => 'lightbulb-exclamation' ),
					array( 'fa-regular fa-lightbulb-gear' => 'lightbulb-gear' ),
					array( 'fa-regular fa-lightbulb-on' => 'lightbulb-on' ),
					array( 'fa-regular fa-lightbulb-slash' => 'lightbulb-slash' ),
					array( 'fa-regular fa-lightbulb' => 'lightbulb' ),
					array( 'fa-regular fa-lighthouse' => 'lighthouse' ),
					array( 'fa-regular fa-lights-holiday' => 'lights-holiday' ),
					array( 'fa-regular fa-line-columns' => 'line-columns' ),
					array( 'fa-regular fa-line-height' => 'line-height' ),
					array( 'fa-regular fa-lines-leaning' => 'lines-leaning' ),
					array( 'fa-regular fa-link-horizontal-slash' => 'link-horizontal-slash' ),
					array( 'fa-regular fa-link-horizontal' => 'link-horizontal' ),
					array( 'fa-regular fa-link-simple-slash' => 'link-simple-slash' ),
					array( 'fa-regular fa-link-simple' => 'link-simple' ),
					array( 'fa-regular fa-link-slash' => 'link-slash' ),
					array( 'fa-regular fa-link' => 'link' ),
					array( 'fa-regular fa-lips' => 'lips' ),
					array( 'fa-regular fa-lira-sign' => 'lira-sign' ),
					array( 'fa-regular fa-list-check' => 'list-check' ),
					array( 'fa-regular fa-list-dropdown' => 'list-dropdown' ),
					array( 'fa-regular fa-list-music' => 'list-music' ),
					array( 'fa-regular fa-list-ol' => 'list-ol' ),
					array( 'fa-regular fa-list-radio' => 'list-radio' ),
					array( 'fa-regular fa-list-timeline' => 'list-timeline' ),
					array( 'fa-regular fa-list-tree' => 'list-tree' ),
					array( 'fa-regular fa-list-ul' => 'list-ul' ),
					array( 'fa-regular fa-list' => 'list' ),
					array( 'fa-regular fa-litecoin-sign' => 'litecoin-sign' ),
					array( 'fa-regular fa-loader' => 'loader' ),
					array( 'fa-regular fa-lobster' => 'lobster' ),
					array( 'fa-regular fa-location-arrow' => 'location-arrow' ),
					array( 'fa-regular fa-location-check' => 'location-check' ),
					array( 'fa-regular fa-location-crosshairs-slash' => 'location-crosshairs-slash' ),
					array( 'fa-regular fa-location-crosshairs' => 'location-crosshairs' ),
					array( 'fa-regular fa-location-dot-slash' => 'location-dot-slash' ),
					array( 'fa-regular fa-location-dot' => 'location-dot' ),
					array( 'fa-regular fa-location-exclamation' => 'location-exclamation' ),
					array( 'fa-regular fa-location-minus' => 'location-minus' ),
					array( 'fa-regular fa-location-pen' => 'location-pen' ),
					array( 'fa-regular fa-location-pin-lock' => 'location-pin-lock' ),
					array( 'fa-regular fa-location-pin-slash' => 'location-pin-slash' ),
					array( 'fa-regular fa-location-pin' => 'location-pin' ),
					array( 'fa-regular fa-location-plus' => 'location-plus' ),
					array( 'fa-regular fa-location-question' => 'location-question' ),
					array( 'fa-regular fa-location-smile' => 'location-smile' ),
					array( 'fa-regular fa-location-xmark' => 'location-xmark' ),
					array( 'fa-regular fa-lock-a' => 'lock-a' ),
					array( 'fa-regular fa-lock-hashtag' => 'lock-hashtag' ),
					array( 'fa-regular fa-lock-keyhole-open' => 'lock-keyhole-open' ),
					array( 'fa-regular fa-lock-keyhole' => 'lock-keyhole' ),
					array( 'fa-regular fa-lock-open' => 'lock-open' ),
					array( 'fa-regular fa-lock' => 'lock' ),
					array( 'fa-regular fa-locust' => 'locust' ),
					array( 'fa-regular fa-lollipop' => 'lollipop' ),
					array( 'fa-regular fa-loveseat' => 'loveseat' ),
					array( 'fa-regular fa-luchador-mask' => 'luchador-mask' ),
					array( 'fa-regular fa-lungs-virus' => 'lungs-virus' ),
					array( 'fa-regular fa-lungs' => 'lungs' ),
					array( 'fa-regular fa-m' => 'm' ),
					array( 'fa-regular fa-mace' => 'mace' ),
					array( 'fa-regular fa-magnet' => 'magnet' ),
					array( 'fa-regular fa-magnifying-glass-arrow-right' => 'magnifying-glass-arrow-right' ),
					array( 'fa-regular fa-magnifying-glass-chart' => 'magnifying-glass-chart' ),
					array( 'fa-regular fa-magnifying-glass-dollar' => 'magnifying-glass-dollar' ),
					array( 'fa-regular fa-magnifying-glass-location' => 'magnifying-glass-location' ),
					array( 'fa-regular fa-magnifying-glass-minus' => 'magnifying-glass-minus' ),
					array( 'fa-regular fa-magnifying-glass-plus' => 'magnifying-glass-plus' ),
					array( 'fa-regular fa-magnifying-glass' => 'magnifying-glass' ),
					array( 'fa-regular fa-mailbox-flag-up' => 'mailbox-flag-up' ),
					array( 'fa-regular fa-mailbox' => 'mailbox' ),
					array( 'fa-regular fa-manat-sign' => 'manat-sign' ),
					array( 'fa-regular fa-mandolin' => 'mandolin' ),
					array( 'fa-regular fa-mango' => 'mango' ),
					array( 'fa-regular fa-manhole' => 'manhole' ),
					array( 'fa-regular fa-map-location-dot' => 'map-location-dot' ),
					array( 'fa-regular fa-map-location' => 'map-location' ),
					array( 'fa-regular fa-map-pin' => 'map-pin' ),
					array( 'fa-regular fa-map' => 'map' ),
					array( 'fa-regular fa-marker' => 'marker' ),
					array( 'fa-regular fa-mars-and-venus-burst' => 'mars-and-venus-burst' ),
					array( 'fa-regular fa-mars-and-venus' => 'mars-and-venus' ),
					array( 'fa-regular fa-mars-double' => 'mars-double' ),
					array( 'fa-regular fa-mars-stroke-right' => 'mars-stroke-right' ),
					array( 'fa-regular fa-mars-stroke-up' => 'mars-stroke-up' ),
					array( 'fa-regular fa-mars-stroke' => 'mars-stroke' ),
					array( 'fa-regular fa-mars' => 'mars' ),
					array( 'fa-regular fa-martini-glass-citrus' => 'martini-glass-citrus' ),
					array( 'fa-regular fa-martini-glass-empty' => 'martini-glass-empty' ),
					array( 'fa-regular fa-martini-glass' => 'martini-glass' ),
					array( 'fa-regular fa-mask-face' => 'mask-face' ),
					array( 'fa-regular fa-mask-snorkel' => 'mask-snorkel' ),
					array( 'fa-regular fa-mask-ventilator' => 'mask-ventilator' ),
					array( 'fa-regular fa-mask' => 'mask' ),
					array( 'fa-regular fa-masks-theater' => 'masks-theater' ),
					array( 'fa-regular fa-mattress-pillow' => 'mattress-pillow' ),
					array( 'fa-regular fa-maximize' => 'maximize' ),
					array( 'fa-regular fa-meat' => 'meat' ),
					array( 'fa-regular fa-medal' => 'medal' ),
					array( 'fa-regular fa-megaphone' => 'megaphone' ),
					array( 'fa-regular fa-melon-slice' => 'melon-slice' ),
					array( 'fa-regular fa-melon' => 'melon' ),
					array( 'fa-regular fa-memo-circle-check' => 'memo-circle-check' ),
					array( 'fa-regular fa-memo-circle-info' => 'memo-circle-info' ),
					array( 'fa-regular fa-memo-pad' => 'memo-pad' ),
					array( 'fa-regular fa-memo' => 'memo' ),
					array( 'fa-regular fa-memory' => 'memory' ),
					array( 'fa-regular fa-menorah' => 'menorah' ),
					array( 'fa-regular fa-mercury' => 'mercury' ),
					array( 'fa-regular fa-merge' => 'merge' ),
					array( 'fa-regular fa-message-arrow-down' => 'message-arrow-down' ),
					array( 'fa-regular fa-message-arrow-up-right' => 'message-arrow-up-right' ),
					array( 'fa-regular fa-message-arrow-up' => 'message-arrow-up' ),
					array( 'fa-regular fa-message-bot' => 'message-bot' ),
					array( 'fa-regular fa-message-captions' => 'message-captions' ),
					array( 'fa-regular fa-message-check' => 'message-check' ),
					array( 'fa-regular fa-message-code' => 'message-code' ),
					array( 'fa-regular fa-message-dollar' => 'message-dollar' ),
					array( 'fa-regular fa-message-dots' => 'message-dots' ),
					array( 'fa-regular fa-message-exclamation' => 'message-exclamation' ),
					array( 'fa-regular fa-message-heart' => 'message-heart' ),
					array( 'fa-regular fa-message-image' => 'message-image' ),
					array( 'fa-regular fa-message-lines' => 'message-lines' ),
					array( 'fa-regular fa-message-medical' => 'message-medical' ),
					array( 'fa-regular fa-message-middle-top' => 'message-middle-top' ),
					array( 'fa-regular fa-message-middle' => 'message-middle' ),
					array( 'fa-regular fa-message-minus' => 'message-minus' ),
					array( 'fa-regular fa-message-music' => 'message-music' ),
					array( 'fa-regular fa-message-pen' => 'message-pen' ),
					array( 'fa-regular fa-message-plus' => 'message-plus' ),
					array( 'fa-regular fa-message-question' => 'message-question' ),
					array( 'fa-regular fa-message-quote' => 'message-quote' ),
					array( 'fa-regular fa-message-slash' => 'message-slash' ),
					array( 'fa-regular fa-message-smile' => 'message-smile' ),
					array( 'fa-regular fa-message-sms' => 'message-sms' ),
					array( 'fa-regular fa-message-text' => 'message-text' ),
					array( 'fa-regular fa-message-xmark' => 'message-xmark' ),
					array( 'fa-regular fa-message' => 'message' ),
					array( 'fa-regular fa-messages-dollar' => 'messages-dollar' ),
					array( 'fa-regular fa-messages-question' => 'messages-question' ),
					array( 'fa-regular fa-messages' => 'messages' ),
					array( 'fa-regular fa-meteor' => 'meteor' ),
					array( 'fa-regular fa-meter-bolt' => 'meter-bolt' ),
					array( 'fa-regular fa-meter-droplet' => 'meter-droplet' ),
					array( 'fa-regular fa-meter-fire' => 'meter-fire' ),
					array( 'fa-regular fa-meter' => 'meter' ),
					array( 'fa-regular fa-microchip-ai' => 'microchip-ai' ),
					array( 'fa-regular fa-microchip' => 'microchip' ),
					array( 'fa-regular fa-microphone-lines-slash' => 'microphone-lines-slash' ),
					array( 'fa-regular fa-microphone-lines' => 'microphone-lines' ),
					array( 'fa-regular fa-microphone-slash' => 'microphone-slash' ),
					array( 'fa-regular fa-microphone-stand' => 'microphone-stand' ),
					array( 'fa-regular fa-microphone' => 'microphone' ),
					array( 'fa-regular fa-microscope' => 'microscope' ),
					array( 'fa-regular fa-microwave' => 'microwave' ),
					array( 'fa-regular fa-mill-sign' => 'mill-sign' ),
					array( 'fa-regular fa-minimize' => 'minimize' ),
					array( 'fa-regular fa-minus' => 'minus' ),
					array( 'fa-regular fa-mistletoe' => 'mistletoe' ),
					array( 'fa-regular fa-mitten' => 'mitten' ),
					array( 'fa-regular fa-mobile-button' => 'mobile-button' ),
					array( 'fa-regular fa-mobile-notch' => 'mobile-notch' ),
					array( 'fa-regular fa-mobile-retro' => 'mobile-retro' ),
					array( 'fa-regular fa-mobile-screen-button' => 'mobile-screen-button' ),
					array( 'fa-regular fa-mobile-screen' => 'mobile-screen' ),
					array( 'fa-regular fa-mobile-signal-out' => 'mobile-signal-out' ),
					array( 'fa-regular fa-mobile-signal' => 'mobile-signal' ),
					array( 'fa-regular fa-mobile' => 'mobile' ),
					array( 'fa-regular fa-money-bill-1-wave' => 'money-bill-1-wave' ),
					array( 'fa-regular fa-money-bill-1' => 'money-bill-1' ),
					array( 'fa-regular fa-money-bill-simple-wave' => 'money-bill-simple-wave' ),
					array( 'fa-regular fa-money-bill-simple' => 'money-bill-simple' ),
					array( 'fa-regular fa-money-bill-transfer' => 'money-bill-transfer' ),
					array( 'fa-regular fa-money-bill-trend-up' => 'money-bill-trend-up' ),
					array( 'fa-regular fa-money-bill-wave' => 'money-bill-wave' ),
					array( 'fa-regular fa-money-bill-wheat' => 'money-bill-wheat' ),
					array( 'fa-regular fa-money-bill' => 'money-bill' ),
					array( 'fa-regular fa-money-bills-simple' => 'money-bills-simple' ),
					array( 'fa-regular fa-money-bills' => 'money-bills' ),
					array( 'fa-regular fa-money-check-dollar-pen' => 'money-check-dollar-pen' ),
					array( 'fa-regular fa-money-check-dollar' => 'money-check-dollar' ),
					array( 'fa-regular fa-money-check-pen' => 'money-check-pen' ),
					array( 'fa-regular fa-money-check' => 'money-check' ),
					array( 'fa-regular fa-money-from-bracket' => 'money-from-bracket' ),
					array( 'fa-regular fa-money-simple-from-bracket' => 'money-simple-from-bracket' ),
					array( 'fa-regular fa-monitor-waveform' => 'monitor-waveform' ),
					array( 'fa-regular fa-monkey' => 'monkey' ),
					array( 'fa-regular fa-monument' => 'monument' ),
					array( 'fa-regular fa-moon-cloud' => 'moon-cloud' ),
					array( 'fa-regular fa-moon-over-sun' => 'moon-over-sun' ),
					array( 'fa-regular fa-moon-stars' => 'moon-stars' ),
					array( 'fa-regular fa-moon' => 'moon' ),
					array( 'fa-regular fa-moped' => 'moped' ),
					array( 'fa-regular fa-mortar-pestle' => 'mortar-pestle' ),
					array( 'fa-regular fa-mosque' => 'mosque' ),
					array( 'fa-regular fa-mosquito-net' => 'mosquito-net' ),
					array( 'fa-regular fa-mosquito' => 'mosquito' ),
					array( 'fa-regular fa-motorcycle' => 'motorcycle' ),
					array( 'fa-regular fa-mound' => 'mound' ),
					array( 'fa-regular fa-mountain-city' => 'mountain-city' ),
					array( 'fa-regular fa-mountain-sun' => 'mountain-sun' ),
					array( 'fa-regular fa-mountain' => 'mountain' ),
					array( 'fa-regular fa-mountains' => 'mountains' ),
					array( 'fa-regular fa-mouse-field' => 'mouse-field' ),
					array( 'fa-regular fa-mp3-player' => 'mp3-player' ),
					array( 'fa-regular fa-mug-hot' => 'mug-hot' ),
					array( 'fa-regular fa-mug-marshmallows' => 'mug-marshmallows' ),
					array( 'fa-regular fa-mug-saucer' => 'mug-saucer' ),
					array( 'fa-regular fa-mug-tea-saucer' => 'mug-tea-saucer' ),
					array( 'fa-regular fa-mug-tea' => 'mug-tea' ),
					array( 'fa-regular fa-mug' => 'mug' ),
					array( 'fa-regular fa-mushroom' => 'mushroom' ),
					array( 'fa-regular fa-music-note-slash' => 'music-note-slash' ),
					array( 'fa-regular fa-music-note' => 'music-note' ),
					array( 'fa-regular fa-music-slash' => 'music-slash' ),
					array( 'fa-regular fa-music' => 'music' ),
					array( 'fa-regular fa-mustache' => 'mustache' ),
					array( 'fa-regular fa-n' => 'n' ),
					array( 'fa-regular fa-naira-sign' => 'naira-sign' ),
					array( 'fa-regular fa-narwhal' => 'narwhal' ),
					array( 'fa-regular fa-nesting-dolls' => 'nesting-dolls' ),
					array( 'fa-regular fa-network-wired' => 'network-wired' ),
					array( 'fa-regular fa-neuter' => 'neuter' ),
					array( 'fa-regular fa-newspaper' => 'newspaper' ),
					array( 'fa-regular fa-nfc-lock' => 'nfc-lock' ),
					array( 'fa-regular fa-nfc-magnifying-glass' => 'nfc-magnifying-glass' ),
					array( 'fa-regular fa-nfc-pen' => 'nfc-pen' ),
					array( 'fa-regular fa-nfc-signal' => 'nfc-signal' ),
					array( 'fa-regular fa-nfc-slash' => 'nfc-slash' ),
					array( 'fa-regular fa-nfc-symbol' => 'nfc-symbol' ),
					array( 'fa-regular fa-nfc-trash' => 'nfc-trash' ),
					array( 'fa-regular fa-nfc' => 'nfc' ),
					array( 'fa-regular fa-nose' => 'nose' ),
					array( 'fa-regular fa-not-equal' => 'not-equal' ),
					array( 'fa-regular fa-notdef' => 'notdef' ),
					array( 'fa-regular fa-note-medical' => 'note-medical' ),
					array( 'fa-regular fa-note-sticky' => 'note-sticky' ),
					array( 'fa-regular fa-note' => 'note' ),
					array( 'fa-regular fa-notebook' => 'notebook' ),
					array( 'fa-regular fa-notes-medical' => 'notes-medical' ),
					array( 'fa-regular fa-notes' => 'notes' ),
					array( 'fa-regular fa-o' => 'o' ),
					array( 'fa-regular fa-object-exclude' => 'object-exclude' ),
					array( 'fa-regular fa-object-group' => 'object-group' ),
					array( 'fa-regular fa-object-intersect' => 'object-intersect' ),
					array( 'fa-regular fa-object-subtract' => 'object-subtract' ),
					array( 'fa-regular fa-object-ungroup' => 'object-ungroup' ),
					array( 'fa-regular fa-object-union' => 'object-union' ),
					array( 'fa-regular fa-objects-align-bottom' => 'objects-align-bottom' ),
					array( 'fa-regular fa-objects-align-center-horizontal' => 'objects-align-center-horizontal' ),
					array( 'fa-regular fa-objects-align-center-vertical' => 'objects-align-center-vertical' ),
					array( 'fa-regular fa-objects-align-left' => 'objects-align-left' ),
					array( 'fa-regular fa-objects-align-right' => 'objects-align-right' ),
					array( 'fa-regular fa-objects-align-top' => 'objects-align-top' ),
					array( 'fa-regular fa-objects-column' => 'objects-column' ),
					array( 'fa-regular fa-octagon-check' => 'octagon-check' ),
					array( 'fa-regular fa-octagon-divide' => 'octagon-divide' ),
					array( 'fa-regular fa-octagon-exclamation' => 'octagon-exclamation' ),
					array( 'fa-regular fa-octagon-minus' => 'octagon-minus' ),
					array( 'fa-regular fa-octagon-plus' => 'octagon-plus' ),
					array( 'fa-regular fa-octagon-xmark' => 'octagon-xmark' ),
					array( 'fa-regular fa-octagon' => 'octagon' ),
					array( 'fa-regular fa-oil-can-drip' => 'oil-can-drip' ),
					array( 'fa-regular fa-oil-can' => 'oil-can' ),
					array( 'fa-regular fa-oil-temperature' => 'oil-temperature' ),
					array( 'fa-regular fa-oil-well' => 'oil-well' ),
					array( 'fa-regular fa-olive-branch' => 'olive-branch' ),
					array( 'fa-regular fa-olive' => 'olive' ),
					array( 'fa-regular fa-om' => 'om' ),
					array( 'fa-regular fa-omega' => 'omega' ),
					array( 'fa-regular fa-onion' => 'onion' ),
					array( 'fa-regular fa-option' => 'option' ),
					array( 'fa-regular fa-ornament' => 'ornament' ),
					array( 'fa-regular fa-otter' => 'otter' ),
					array( 'fa-regular fa-outdent' => 'outdent' ),
					array( 'fa-regular fa-outlet' => 'outlet' ),
					array( 'fa-regular fa-oven' => 'oven' ),
					array( 'fa-regular fa-overline' => 'overline' ),
					array( 'fa-regular fa-p' => 'p' ),
					array( 'fa-regular fa-page-caret-down' => 'page-caret-down' ),
					array( 'fa-regular fa-page-caret-up' => 'page-caret-up' ),
					array( 'fa-regular fa-page' => 'page' ),
					array( 'fa-regular fa-pager' => 'pager' ),
					array( 'fa-regular fa-paint-roller' => 'paint-roller' ),
					array( 'fa-regular fa-paintbrush-fine' => 'paintbrush-fine' ),
					array( 'fa-regular fa-paintbrush-pencil' => 'paintbrush-pencil' ),
					array( 'fa-regular fa-paintbrush' => 'paintbrush' ),
					array( 'fa-regular fa-palette' => 'palette' ),
					array( 'fa-regular fa-pallet-box' => 'pallet-box' ),
					array( 'fa-regular fa-pallet-boxes' => 'pallet-boxes' ),
					array( 'fa-regular fa-pallet' => 'pallet' ),
					array( 'fa-regular fa-pan-food' => 'pan-food' ),
					array( 'fa-regular fa-pan-frying' => 'pan-frying' ),
					array( 'fa-regular fa-pancakes' => 'pancakes' ),
					array( 'fa-regular fa-panel-ews' => 'panel-ews' ),
					array( 'fa-regular fa-panel-fire' => 'panel-fire' ),
					array( 'fa-regular fa-panorama' => 'panorama' ),
					array( 'fa-regular fa-paper-plane-top' => 'paper-plane-top' ),
					array( 'fa-regular fa-paper-plane' => 'paper-plane' ),
					array( 'fa-regular fa-paperclip-vertical' => 'paperclip-vertical' ),
					array( 'fa-regular fa-paperclip' => 'paperclip' ),
					array( 'fa-regular fa-parachute-box' => 'parachute-box' ),
					array( 'fa-regular fa-paragraph-left' => 'paragraph-left' ),
					array( 'fa-regular fa-paragraph' => 'paragraph' ),
					array( 'fa-regular fa-party-bell' => 'party-bell' ),
					array( 'fa-regular fa-party-horn' => 'party-horn' ),
					array( 'fa-regular fa-passport' => 'passport' ),
					array( 'fa-regular fa-paste' => 'paste' ),
					array( 'fa-regular fa-pause' => 'pause' ),
					array( 'fa-regular fa-paw-claws' => 'paw-claws' ),
					array( 'fa-regular fa-paw-simple' => 'paw-simple' ),
					array( 'fa-regular fa-paw' => 'paw' ),
					array( 'fa-regular fa-peace' => 'peace' ),
					array( 'fa-regular fa-peach' => 'peach' ),
					array( 'fa-regular fa-peanut' => 'peanut' ),
					array( 'fa-regular fa-peanuts' => 'peanuts' ),
					array( 'fa-regular fa-peapod' => 'peapod' ),
					array( 'fa-regular fa-pear' => 'pear' ),
					array( 'fa-regular fa-pedestal' => 'pedestal' ),
					array( 'fa-regular fa-pegasus' => 'pegasus' ),
					array( 'fa-regular fa-pen-circle' => 'pen-circle' ),
					array( 'fa-regular fa-pen-clip-slash' => 'pen-clip-slash' ),
					array( 'fa-regular fa-pen-clip' => 'pen-clip' ),
					array( 'fa-regular fa-pen-fancy-slash' => 'pen-fancy-slash' ),
					array( 'fa-regular fa-pen-fancy' => 'pen-fancy' ),
					array( 'fa-regular fa-pen-field' => 'pen-field' ),
					array( 'fa-regular fa-pen-line' => 'pen-line' ),
					array( 'fa-regular fa-pen-nib-slash' => 'pen-nib-slash' ),
					array( 'fa-regular fa-pen-nib' => 'pen-nib' ),
					array( 'fa-regular fa-pen-paintbrush' => 'pen-paintbrush' ),
					array( 'fa-regular fa-pen-ruler' => 'pen-ruler' ),
					array( 'fa-regular fa-pen-slash' => 'pen-slash' ),
					array( 'fa-regular fa-pen-swirl' => 'pen-swirl' ),
					array( 'fa-regular fa-pen-to-square' => 'pen-to-square' ),
					array( 'fa-regular fa-pen' => 'pen' ),
					array( 'fa-regular fa-pencil-mechanical' => 'pencil-mechanical' ),
					array( 'fa-regular fa-pencil-slash' => 'pencil-slash' ),
					array( 'fa-regular fa-pencil' => 'pencil' ),
					array( 'fa-regular fa-people-arrows' => 'people-arrows' ),
					array( 'fa-regular fa-people-carry-box' => 'people-carry-box' ),
					array( 'fa-regular fa-people-dress-simple' => 'people-dress-simple' ),
					array( 'fa-regular fa-people-dress' => 'people-dress' ),
					array( 'fa-regular fa-people-group' => 'people-group' ),
					array( 'fa-regular fa-people-line' => 'people-line' ),
					array( 'fa-regular fa-people-pants-simple' => 'people-pants-simple' ),
					array( 'fa-regular fa-people-pants' => 'people-pants' ),
					array( 'fa-regular fa-people-pulling' => 'people-pulling' ),
					array( 'fa-regular fa-people-robbery' => 'people-robbery' ),
					array( 'fa-regular fa-people-roof' => 'people-roof' ),
					array( 'fa-regular fa-people-simple' => 'people-simple' ),
					array( 'fa-regular fa-people' => 'people' ),
					array( 'fa-regular fa-pepper-hot' => 'pepper-hot' ),
					array( 'fa-regular fa-pepper' => 'pepper' ),
					array( 'fa-regular fa-percent' => 'percent' ),
					array( 'fa-regular fa-period' => 'period' ),
					array( 'fa-regular fa-person-arrow-down-to-line' => 'person-arrow-down-to-line' ),
					array( 'fa-regular fa-person-arrow-up-from-line' => 'person-arrow-up-from-line' ),
					array( 'fa-regular fa-person-biking-mountain' => 'person-biking-mountain' ),
					array( 'fa-regular fa-person-biking' => 'person-biking' ),
					array( 'fa-regular fa-person-booth' => 'person-booth' ),
					array( 'fa-regular fa-person-breastfeeding' => 'person-breastfeeding' ),
					array( 'fa-regular fa-person-burst' => 'person-burst' ),
					array( 'fa-regular fa-person-cane' => 'person-cane' ),
					array( 'fa-regular fa-person-carry-box' => 'person-carry-box' ),
					array( 'fa-regular fa-person-chalkboard' => 'person-chalkboard' ),
					array( 'fa-regular fa-person-circle-check' => 'person-circle-check' ),
					array( 'fa-regular fa-person-circle-exclamation' => 'person-circle-exclamation' ),
					array( 'fa-regular fa-person-circle-minus' => 'person-circle-minus' ),
					array( 'fa-regular fa-person-circle-plus' => 'person-circle-plus' ),
					array( 'fa-regular fa-person-circle-question' => 'person-circle-question' ),
					array( 'fa-regular fa-person-circle-xmark' => 'person-circle-xmark' ),
					array( 'fa-regular fa-person-digging' => 'person-digging' ),
					array( 'fa-regular fa-person-dolly-empty' => 'person-dolly-empty' ),
					array( 'fa-regular fa-person-dolly' => 'person-dolly' ),
					array( 'fa-regular fa-person-dots-from-line' => 'person-dots-from-line' ),
					array( 'fa-regular fa-person-dress-burst' => 'person-dress-burst' ),
					array( 'fa-regular fa-person-dress-fairy' => 'person-dress-fairy' ),
					array( 'fa-regular fa-person-dress-simple' => 'person-dress-simple' ),
					array( 'fa-regular fa-person-dress' => 'person-dress' ),
					array( 'fa-regular fa-person-drowning' => 'person-drowning' ),
					array( 'fa-regular fa-person-fairy' => 'person-fairy' ),
					array( 'fa-regular fa-person-falling-burst' => 'person-falling-burst' ),
					array( 'fa-regular fa-person-falling' => 'person-falling' ),
					array( 'fa-regular fa-person-from-portal' => 'person-from-portal' ),
					array( 'fa-regular fa-person-half-dress' => 'person-half-dress' ),
					array( 'fa-regular fa-person-harassing' => 'person-harassing' ),
					array( 'fa-regular fa-person-hiking' => 'person-hiking' ),
					array( 'fa-regular fa-person-military-pointing' => 'person-military-pointing' ),
					array( 'fa-regular fa-person-military-rifle' => 'person-military-rifle' ),
					array( 'fa-regular fa-person-military-to-person' => 'person-military-to-person' ),
					array( 'fa-regular fa-person-pinball' => 'person-pinball' ),
					array( 'fa-regular fa-person-praying' => 'person-praying' ),
					array( 'fa-regular fa-person-pregnant' => 'person-pregnant' ),
					array( 'fa-regular fa-person-rays' => 'person-rays' ),
					array( 'fa-regular fa-person-rifle' => 'person-rifle' ),
					array( 'fa-regular fa-person-running-fast' => 'person-running-fast' ),
					array( 'fa-regular fa-person-running' => 'person-running' ),
					array( 'fa-regular fa-person-seat-reclined' => 'person-seat-reclined' ),
					array( 'fa-regular fa-person-seat' => 'person-seat' ),
					array( 'fa-regular fa-person-shelter' => 'person-shelter' ),
					array( 'fa-regular fa-person-sign' => 'person-sign' ),
					array( 'fa-regular fa-person-simple' => 'person-simple' ),
					array( 'fa-regular fa-person-skating' => 'person-skating' ),
					array( 'fa-regular fa-person-ski-jumping' => 'person-ski-jumping' ),
					array( 'fa-regular fa-person-ski-lift' => 'person-ski-lift' ),
					array( 'fa-regular fa-person-skiing-nordic' => 'person-skiing-nordic' ),
					array( 'fa-regular fa-person-skiing' => 'person-skiing' ),
					array( 'fa-regular fa-person-sledding' => 'person-sledding' ),
					array( 'fa-regular fa-person-snowboarding' => 'person-snowboarding' ),
					array( 'fa-regular fa-person-snowmobiling' => 'person-snowmobiling' ),
					array( 'fa-regular fa-person-swimming' => 'person-swimming' ),
					array( 'fa-regular fa-person-through-window' => 'person-through-window' ),
					array( 'fa-regular fa-person-to-door' => 'person-to-door' ),
					array( 'fa-regular fa-person-to-portal' => 'person-to-portal' ),
					array( 'fa-regular fa-person-walking-arrow-loop-left' => 'person-walking-arrow-loop-left' ),
					array( 'fa-regular fa-person-walking-arrow-right' => 'person-walking-arrow-right' ),
					array( 'fa-regular fa-person-walking-dashed-line-arrow-right' => 'person-walking-dashed-line-arrow-right' ),
					array( 'fa-regular fa-person-walking-luggage' => 'person-walking-luggage' ),
					array( 'fa-regular fa-person-walking-with-cane' => 'person-walking-with-cane' ),
					array( 'fa-regular fa-person-walking' => 'person-walking' ),
					array( 'fa-regular fa-person' => 'person' ),
					array( 'fa-regular fa-peseta-sign' => 'peseta-sign' ),
					array( 'fa-regular fa-peso-sign' => 'peso-sign' ),
					array( 'fa-regular fa-phone-arrow-down-left' => 'phone-arrow-down-left' ),
					array( 'fa-regular fa-phone-arrow-right' => 'phone-arrow-right' ),
					array( 'fa-regular fa-phone-arrow-up-right' => 'phone-arrow-up-right' ),
					array( 'fa-regular fa-phone-flip' => 'phone-flip' ),
					array( 'fa-regular fa-phone-hangup' => 'phone-hangup' ),
					array( 'fa-regular fa-phone-intercom' => 'phone-intercom' ),
					array( 'fa-regular fa-phone-missed' => 'phone-missed' ),
					array( 'fa-regular fa-phone-office' => 'phone-office' ),
					array( 'fa-regular fa-phone-plus' => 'phone-plus' ),
					array( 'fa-regular fa-phone-rotary' => 'phone-rotary' ),
					array( 'fa-regular fa-phone-slash' => 'phone-slash' ),
					array( 'fa-regular fa-phone-volume' => 'phone-volume' ),
					array( 'fa-regular fa-phone-xmark' => 'phone-xmark' ),
					array( 'fa-regular fa-phone' => 'phone' ),
					array( 'fa-regular fa-photo-film-music' => 'photo-film-music' ),
					array( 'fa-regular fa-photo-film' => 'photo-film' ),
					array( 'fa-regular fa-pi' => 'pi' ),
					array( 'fa-regular fa-piano-keyboard' => 'piano-keyboard' ),
					array( 'fa-regular fa-piano' => 'piano' ),
					array( 'fa-regular fa-pickaxe' => 'pickaxe' ),
					array( 'fa-regular fa-pickleball' => 'pickleball' ),
					array( 'fa-regular fa-pie' => 'pie' ),
					array( 'fa-regular fa-pig' => 'pig' ),
					array( 'fa-regular fa-piggy-bank' => 'piggy-bank' ),
					array( 'fa-regular fa-pills' => 'pills' ),
					array( 'fa-regular fa-pinata' => 'pinata' ),
					array( 'fa-regular fa-pinball' => 'pinball' ),
					array( 'fa-regular fa-pineapple' => 'pineapple' ),
					array( 'fa-regular fa-pipe-circle-check' => 'pipe-circle-check' ),
					array( 'fa-regular fa-pipe-collar' => 'pipe-collar' ),
					array( 'fa-regular fa-pipe-section' => 'pipe-section' ),
					array( 'fa-regular fa-pipe-smoking' => 'pipe-smoking' ),
					array( 'fa-regular fa-pipe-valve' => 'pipe-valve' ),
					array( 'fa-regular fa-pipe' => 'pipe' ),
					array( 'fa-regular fa-pizza-slice' => 'pizza-slice' ),
					array( 'fa-regular fa-pizza' => 'pizza' ),
					array( 'fa-regular fa-place-of-worship' => 'place-of-worship' ),
					array( 'fa-regular fa-plane-arrival' => 'plane-arrival' ),
					array( 'fa-regular fa-plane-circle-check' => 'plane-circle-check' ),
					array( 'fa-regular fa-plane-circle-exclamation' => 'plane-circle-exclamation' ),
					array( 'fa-regular fa-plane-circle-xmark' => 'plane-circle-xmark' ),
					array( 'fa-regular fa-plane-departure' => 'plane-departure' ),
					array( 'fa-regular fa-plane-engines' => 'plane-engines' ),
					array( 'fa-regular fa-plane-lock' => 'plane-lock' ),
					array( 'fa-regular fa-plane-prop' => 'plane-prop' ),
					array( 'fa-regular fa-plane-slash' => 'plane-slash' ),
					array( 'fa-regular fa-plane-tail' => 'plane-tail' ),
					array( 'fa-regular fa-plane-up-slash' => 'plane-up-slash' ),
					array( 'fa-regular fa-plane-up' => 'plane-up' ),
					array( 'fa-regular fa-plane' => 'plane' ),
					array( 'fa-regular fa-planet-moon' => 'planet-moon' ),
					array( 'fa-regular fa-planet-ringed' => 'planet-ringed' ),
					array( 'fa-regular fa-plant-wilt' => 'plant-wilt' ),
					array( 'fa-regular fa-plate-utensils' => 'plate-utensils' ),
					array( 'fa-regular fa-plate-wheat' => 'plate-wheat' ),
					array( 'fa-regular fa-play-pause' => 'play-pause' ),
					array( 'fa-regular fa-play' => 'play' ),
					array( 'fa-regular fa-plug-circle-bolt' => 'plug-circle-bolt' ),
					array( 'fa-regular fa-plug-circle-check' => 'plug-circle-check' ),
					array( 'fa-regular fa-plug-circle-exclamation' => 'plug-circle-exclamation' ),
					array( 'fa-regular fa-plug-circle-minus' => 'plug-circle-minus' ),
					array( 'fa-regular fa-plug-circle-plus' => 'plug-circle-plus' ),
					array( 'fa-regular fa-plug-circle-xmark' => 'plug-circle-xmark' ),
					array( 'fa-regular fa-plug' => 'plug' ),
					array( 'fa-regular fa-plus-large' => 'plus-large' ),
					array( 'fa-regular fa-plus-minus' => 'plus-minus' ),
					array( 'fa-regular fa-plus' => 'plus' ),
					array( 'fa-regular fa-podcast' => 'podcast' ),
					array( 'fa-regular fa-podium-star' => 'podium-star' ),
					array( 'fa-regular fa-podium' => 'podium' ),
					array( 'fa-regular fa-police-box' => 'police-box' ),
					array( 'fa-regular fa-poll-people' => 'poll-people' ),
					array( 'fa-regular fa-pompebled' => 'pompebled' ),
					array( 'fa-regular fa-poo-storm' => 'poo-storm' ),
					array( 'fa-regular fa-poo' => 'poo' ),
					array( 'fa-regular fa-pool-8-ball' => 'pool-8-ball' ),
					array( 'fa-regular fa-poop' => 'poop' ),
					array( 'fa-regular fa-popcorn' => 'popcorn' ),
					array( 'fa-regular fa-popsicle' => 'popsicle' ),
					array( 'fa-regular fa-pot-food' => 'pot-food' ),
					array( 'fa-regular fa-potato' => 'potato' ),
					array( 'fa-regular fa-power-off' => 'power-off' ),
					array( 'fa-regular fa-prescription-bottle-medical' => 'prescription-bottle-medical' ),
					array( 'fa-regular fa-prescription-bottle-pill' => 'prescription-bottle-pill' ),
					array( 'fa-regular fa-prescription-bottle' => 'prescription-bottle' ),
					array( 'fa-regular fa-prescription' => 'prescription' ),
					array( 'fa-regular fa-presentation-screen' => 'presentation-screen' ),
					array( 'fa-regular fa-pretzel' => 'pretzel' ),
					array( 'fa-regular fa-print-magnifying-glass' => 'print-magnifying-glass' ),
					array( 'fa-regular fa-print-slash' => 'print-slash' ),
					array( 'fa-regular fa-print' => 'print' ),
					array( 'fa-regular fa-projector' => 'projector' ),
					array( 'fa-regular fa-pump-medical' => 'pump-medical' ),
					array( 'fa-regular fa-pump-soap' => 'pump-soap' ),
					array( 'fa-regular fa-pump' => 'pump' ),
					array( 'fa-regular fa-pumpkin' => 'pumpkin' ),
					array( 'fa-regular fa-puzzle-piece-simple' => 'puzzle-piece-simple' ),
					array( 'fa-regular fa-puzzle-piece' => 'puzzle-piece' ),
					array( 'fa-regular fa-puzzle' => 'puzzle' ),
					array( 'fa-regular fa-q' => 'q' ),
					array( 'fa-regular fa-qrcode' => 'qrcode' ),
					array( 'fa-regular fa-question' => 'question' ),
					array( 'fa-regular fa-quote-left' => 'quote-left' ),
					array( 'fa-regular fa-quote-right' => 'quote-right' ),
					array( 'fa-regular fa-quotes' => 'quotes' ),
					array( 'fa-regular fa-r' => 'r' ),
					array( 'fa-regular fa-rabbit-running' => 'rabbit-running' ),
					array( 'fa-regular fa-rabbit' => 'rabbit' ),
					array( 'fa-regular fa-raccoon' => 'raccoon' ),
					array( 'fa-regular fa-racquet' => 'racquet' ),
					array( 'fa-regular fa-radar' => 'radar' ),
					array( 'fa-regular fa-radiation' => 'radiation' ),
					array( 'fa-regular fa-radio-tuner' => 'radio-tuner' ),
					array( 'fa-regular fa-radio' => 'radio' ),
					array( 'fa-regular fa-rainbow' => 'rainbow' ),
					array( 'fa-regular fa-raindrops' => 'raindrops' ),
					array( 'fa-regular fa-ram' => 'ram' ),
					array( 'fa-regular fa-ramp-loading' => 'ramp-loading' ),
					array( 'fa-regular fa-ranking-star' => 'ranking-star' ),
					array( 'fa-regular fa-raygun' => 'raygun' ),
					array( 'fa-regular fa-receipt' => 'receipt' ),
					array( 'fa-regular fa-record-vinyl' => 'record-vinyl' ),
					array( 'fa-regular fa-rectangle-ad' => 'rectangle-ad' ),
					array( 'fa-regular fa-rectangle-barcode' => 'rectangle-barcode' ),
					array( 'fa-regular fa-rectangle-code' => 'rectangle-code' ),
					array( 'fa-regular fa-rectangle-history-circle-plus' => 'rectangle-history-circle-plus' ),
					array( 'fa-regular fa-rectangle-history-circle-user' => 'rectangle-history-circle-user' ),
					array( 'fa-regular fa-rectangle-history' => 'rectangle-history' ),
					array( 'fa-regular fa-rectangle-list' => 'rectangle-list' ),
					array( 'fa-regular fa-rectangle-pro' => 'rectangle-pro' ),
					array( 'fa-regular fa-rectangle-terminal' => 'rectangle-terminal' ),
					array( 'fa-regular fa-rectangle-vertical-history' => 'rectangle-vertical-history' ),
					array( 'fa-regular fa-rectangle-vertical' => 'rectangle-vertical' ),
					array( 'fa-regular fa-rectangle-wide' => 'rectangle-wide' ),
					array( 'fa-regular fa-rectangle-xmark' => 'rectangle-xmark' ),
					array( 'fa-regular fa-rectangle' => 'rectangle' ),
					array( 'fa-regular fa-rectangles-mixed' => 'rectangles-mixed' ),
					array( 'fa-regular fa-recycle' => 'recycle' ),
					array( 'fa-regular fa-reel' => 'reel' ),
					array( 'fa-regular fa-refrigerator' => 'refrigerator' ),
					array( 'fa-regular fa-registered' => 'registered' ),
					array( 'fa-regular fa-repeat-1' => 'repeat-1' ),
					array( 'fa-regular fa-repeat' => 'repeat' ),
					array( 'fa-regular fa-reply-all' => 'reply-all' ),
					array( 'fa-regular fa-reply-clock' => 'reply-clock' ),
					array( 'fa-regular fa-reply' => 'reply' ),
					array( 'fa-regular fa-republican' => 'republican' ),
					array( 'fa-regular fa-restroom-simple' => 'restroom-simple' ),
					array( 'fa-regular fa-restroom' => 'restroom' ),
					array( 'fa-regular fa-retweet' => 'retweet' ),
					array( 'fa-regular fa-rhombus' => 'rhombus' ),
					array( 'fa-regular fa-ribbon' => 'ribbon' ),
					array( 'fa-regular fa-right-from-bracket' => 'right-from-bracket' ),
					array( 'fa-regular fa-right-from-line' => 'right-from-line' ),
					array( 'fa-regular fa-right-left-large' => 'right-left-large' ),
					array( 'fa-regular fa-right-left' => 'right-left' ),
					array( 'fa-regular fa-right-long-to-line' => 'right-long-to-line' ),
					array( 'fa-regular fa-right-long' => 'right-long' ),
					array( 'fa-regular fa-right-to-bracket' => 'right-to-bracket' ),
					array( 'fa-regular fa-right-to-line' => 'right-to-line' ),
					array( 'fa-regular fa-right' => 'right' ),
					array( 'fa-regular fa-ring-diamond' => 'ring-diamond' ),
					array( 'fa-regular fa-ring' => 'ring' ),
					array( 'fa-regular fa-rings-wedding' => 'rings-wedding' ),
					array( 'fa-regular fa-road-barrier' => 'road-barrier' ),
					array( 'fa-regular fa-road-bridge' => 'road-bridge' ),
					array( 'fa-regular fa-road-circle-check' => 'road-circle-check' ),
					array( 'fa-regular fa-road-circle-exclamation' => 'road-circle-exclamation' ),
					array( 'fa-regular fa-road-circle-xmark' => 'road-circle-xmark' ),
					array( 'fa-regular fa-road-lock' => 'road-lock' ),
					array( 'fa-regular fa-road-spikes' => 'road-spikes' ),
					array( 'fa-regular fa-road' => 'road' ),
					array( 'fa-regular fa-robot-astromech' => 'robot-astromech' ),
					array( 'fa-regular fa-robot' => 'robot' ),
					array( 'fa-regular fa-rocket-launch' => 'rocket-launch' ),
					array( 'fa-regular fa-rocket' => 'rocket' ),
					array( 'fa-regular fa-roller-coaster' => 'roller-coaster' ),
					array( 'fa-regular fa-rotate-exclamation' => 'rotate-exclamation' ),
					array( 'fa-regular fa-rotate-left' => 'rotate-left' ),
					array( 'fa-regular fa-rotate-right' => 'rotate-right' ),
					array( 'fa-regular fa-rotate' => 'rotate' ),
					array( 'fa-regular fa-route-highway' => 'route-highway' ),
					array( 'fa-regular fa-route-interstate' => 'route-interstate' ),
					array( 'fa-regular fa-route' => 'route' ),
					array( 'fa-regular fa-router' => 'router' ),
					array( 'fa-regular fa-rss' => 'rss' ),
					array( 'fa-regular fa-ruble-sign' => 'ruble-sign' ),
					array( 'fa-regular fa-rug' => 'rug' ),
					array( 'fa-regular fa-rugby-ball' => 'rugby-ball' ),
					array( 'fa-regular fa-ruler-combined' => 'ruler-combined' ),
					array( 'fa-regular fa-ruler-horizontal' => 'ruler-horizontal' ),
					array( 'fa-regular fa-ruler-triangle' => 'ruler-triangle' ),
					array( 'fa-regular fa-ruler-vertical' => 'ruler-vertical' ),
					array( 'fa-regular fa-ruler' => 'ruler' ),
					array( 'fa-regular fa-rupee-sign' => 'rupee-sign' ),
					array( 'fa-regular fa-rupiah-sign' => 'rupiah-sign' ),
					array( 'fa-regular fa-rv' => 'rv' ),
					array( 'fa-regular fa-s' => 's' ),
					array( 'fa-regular fa-sack-dollar' => 'sack-dollar' ),
					array( 'fa-regular fa-sack-xmark' => 'sack-xmark' ),
					array( 'fa-regular fa-sack' => 'sack' ),
					array( 'fa-regular fa-sailboat' => 'sailboat' ),
					array( 'fa-regular fa-salad' => 'salad' ),
					array( 'fa-regular fa-salt-shaker' => 'salt-shaker' ),
					array( 'fa-regular fa-sandwich' => 'sandwich' ),
					array( 'fa-regular fa-satellite-dish' => 'satellite-dish' ),
					array( 'fa-regular fa-satellite' => 'satellite' ),
					array( 'fa-regular fa-sausage' => 'sausage' ),
					array( 'fa-regular fa-saxophone-fire' => 'saxophone-fire' ),
					array( 'fa-regular fa-saxophone' => 'saxophone' ),
					array( 'fa-regular fa-scale-balanced' => 'scale-balanced' ),
					array( 'fa-regular fa-scale-unbalanced-flip' => 'scale-unbalanced-flip' ),
					array( 'fa-regular fa-scale-unbalanced' => 'scale-unbalanced' ),
					array( 'fa-regular fa-scalpel-line-dashed' => 'scalpel-line-dashed' ),
					array( 'fa-regular fa-scalpel' => 'scalpel' ),
					array( 'fa-regular fa-scanner-gun' => 'scanner-gun' ),
					array( 'fa-regular fa-scanner-image' => 'scanner-image' ),
					array( 'fa-regular fa-scanner-keyboard' => 'scanner-keyboard' ),
					array( 'fa-regular fa-scanner-touchscreen' => 'scanner-touchscreen' ),
					array( 'fa-regular fa-scarecrow' => 'scarecrow' ),
					array( 'fa-regular fa-scarf' => 'scarf' ),
					array( 'fa-regular fa-school-circle-check' => 'school-circle-check' ),
					array( 'fa-regular fa-school-circle-exclamation' => 'school-circle-exclamation' ),
					array( 'fa-regular fa-school-circle-xmark' => 'school-circle-xmark' ),
					array( 'fa-regular fa-school-flag' => 'school-flag' ),
					array( 'fa-regular fa-school-lock' => 'school-lock' ),
					array( 'fa-regular fa-school' => 'school' ),
					array( 'fa-regular fa-scissors' => 'scissors' ),
					array( 'fa-regular fa-screen-users' => 'screen-users' ),
					array( 'fa-regular fa-screencast' => 'screencast' ),
					array( 'fa-regular fa-screwdriver-wrench' => 'screwdriver-wrench' ),
					array( 'fa-regular fa-screwdriver' => 'screwdriver' ),
					array( 'fa-regular fa-scribble' => 'scribble' ),
					array( 'fa-regular fa-scroll-old' => 'scroll-old' ),
					array( 'fa-regular fa-scroll-torah' => 'scroll-torah' ),
					array( 'fa-regular fa-scroll' => 'scroll' ),
					array( 'fa-regular fa-scrubber' => 'scrubber' ),
					array( 'fa-regular fa-scythe' => 'scythe' ),
					array( 'fa-regular fa-sd-card' => 'sd-card' ),
					array( 'fa-regular fa-sd-cards' => 'sd-cards' ),
					array( 'fa-regular fa-seal-exclamation' => 'seal-exclamation' ),
					array( 'fa-regular fa-seal-question' => 'seal-question' ),
					array( 'fa-regular fa-seal' => 'seal' ),
					array( 'fa-regular fa-seat-airline' => 'seat-airline' ),
					array( 'fa-regular fa-section' => 'section' ),
					array( 'fa-regular fa-seedling' => 'seedling' ),
					array( 'fa-regular fa-semicolon' => 'semicolon' ),
					array( 'fa-regular fa-send-back' => 'send-back' ),
					array( 'fa-regular fa-send-backward' => 'send-backward' ),
					array( 'fa-regular fa-sensor-cloud' => 'sensor-cloud' ),
					array( 'fa-regular fa-sensor-fire' => 'sensor-fire' ),
					array( 'fa-regular fa-sensor-on' => 'sensor-on' ),
					array( 'fa-regular fa-sensor-triangle-exclamation' => 'sensor-triangle-exclamation' ),
					array( 'fa-regular fa-sensor' => 'sensor' ),
					array( 'fa-regular fa-server' => 'server' ),
					array( 'fa-regular fa-shapes' => 'shapes' ),
					array( 'fa-regular fa-share-all' => 'share-all' ),
					array( 'fa-regular fa-share-from-square' => 'share-from-square' ),
					array( 'fa-regular fa-share-nodes' => 'share-nodes' ),
					array( 'fa-regular fa-share' => 'share' ),
					array( 'fa-regular fa-sheep' => 'sheep' ),
					array( 'fa-regular fa-sheet-plastic' => 'sheet-plastic' ),
					array( 'fa-regular fa-shekel-sign' => 'shekel-sign' ),
					array( 'fa-regular fa-shelves-empty' => 'shelves-empty' ),
					array( 'fa-regular fa-shelves' => 'shelves' ),
					array( 'fa-regular fa-shield-cat' => 'shield-cat' ),
					array( 'fa-regular fa-shield-check' => 'shield-check' ),
					array( 'fa-regular fa-shield-cross' => 'shield-cross' ),
					array( 'fa-regular fa-shield-dog' => 'shield-dog' ),
					array( 'fa-regular fa-shield-exclamation' => 'shield-exclamation' ),
					array( 'fa-regular fa-shield-halved' => 'shield-halved' ),
					array( 'fa-regular fa-shield-heart' => 'shield-heart' ),
					array( 'fa-regular fa-shield-keyhole' => 'shield-keyhole' ),
					array( 'fa-regular fa-shield-minus' => 'shield-minus' ),
					array( 'fa-regular fa-shield-plus' => 'shield-plus' ),
					array( 'fa-regular fa-shield-quartered' => 'shield-quartered' ),
					array( 'fa-regular fa-shield-slash' => 'shield-slash' ),
					array( 'fa-regular fa-shield-virus' => 'shield-virus' ),
					array( 'fa-regular fa-shield-xmark' => 'shield-xmark' ),
					array( 'fa-regular fa-shield' => 'shield' ),
					array( 'fa-regular fa-ship' => 'ship' ),
					array( 'fa-regular fa-shirt-long-sleeve' => 'shirt-long-sleeve' ),
					array( 'fa-regular fa-shirt-running' => 'shirt-running' ),
					array( 'fa-regular fa-shirt-tank-top' => 'shirt-tank-top' ),
					array( 'fa-regular fa-shirt' => 'shirt' ),
					array( 'fa-regular fa-shish-kebab' => 'shish-kebab' ),
					array( 'fa-regular fa-shoe-prints' => 'shoe-prints' ),
					array( 'fa-regular fa-shop-lock' => 'shop-lock' ),
					array( 'fa-regular fa-shop-slash' => 'shop-slash' ),
					array( 'fa-regular fa-shop' => 'shop' ),
					array( 'fa-regular fa-shovel-snow' => 'shovel-snow' ),
					array( 'fa-regular fa-shovel' => 'shovel' ),
					array( 'fa-regular fa-shower-down' => 'shower-down' ),
					array( 'fa-regular fa-shower' => 'shower' ),
					array( 'fa-regular fa-shredder' => 'shredder' ),
					array( 'fa-regular fa-shrimp' => 'shrimp' ),
					array( 'fa-regular fa-shuffle' => 'shuffle' ),
					array( 'fa-regular fa-shutters' => 'shutters' ),
					array( 'fa-regular fa-shuttle-space' => 'shuttle-space' ),
					array( 'fa-regular fa-shuttlecock' => 'shuttlecock' ),
					array( 'fa-regular fa-sickle' => 'sickle' ),
					array( 'fa-regular fa-sidebar-flip' => 'sidebar-flip' ),
					array( 'fa-regular fa-sidebar' => 'sidebar' ),
					array( 'fa-regular fa-sigma' => 'sigma' ),
					array( 'fa-regular fa-sign-hanging' => 'sign-hanging' ),
					array( 'fa-regular fa-signal-bars-fair' => 'signal-bars-fair' ),
					array( 'fa-regular fa-signal-bars-good' => 'signal-bars-good' ),
					array( 'fa-regular fa-signal-bars-slash' => 'signal-bars-slash' ),
					array( 'fa-regular fa-signal-bars-weak' => 'signal-bars-weak' ),
					array( 'fa-regular fa-signal-bars' => 'signal-bars' ),
					array( 'fa-regular fa-signal-fair' => 'signal-fair' ),
					array( 'fa-regular fa-signal-good' => 'signal-good' ),
					array( 'fa-regular fa-signal-slash' => 'signal-slash' ),
					array( 'fa-regular fa-signal-stream-slash' => 'signal-stream-slash' ),
					array( 'fa-regular fa-signal-stream' => 'signal-stream' ),
					array( 'fa-regular fa-signal-strong' => 'signal-strong' ),
					array( 'fa-regular fa-signal-weak' => 'signal-weak' ),
					array( 'fa-regular fa-signal' => 'signal' ),
					array( 'fa-regular fa-signature-lock' => 'signature-lock' ),
					array( 'fa-regular fa-signature-slash' => 'signature-slash' ),
					array( 'fa-regular fa-signature' => 'signature' ),
					array( 'fa-regular fa-signs-post' => 'signs-post' ),
					array( 'fa-regular fa-sim-card' => 'sim-card' ),
					array( 'fa-regular fa-sim-cards' => 'sim-cards' ),
					array( 'fa-regular fa-sink' => 'sink' ),
					array( 'fa-regular fa-siren-on' => 'siren-on' ),
					array( 'fa-regular fa-siren' => 'siren' ),
					array( 'fa-regular fa-sitemap' => 'sitemap' ),
					array( 'fa-regular fa-skeleton-ribs' => 'skeleton-ribs' ),
					array( 'fa-regular fa-skeleton' => 'skeleton' ),
					array( 'fa-regular fa-ski-boot-ski' => 'ski-boot-ski' ),
					array( 'fa-regular fa-ski-boot' => 'ski-boot' ),
					array( 'fa-regular fa-skull-cow' => 'skull-cow' ),
					array( 'fa-regular fa-skull-crossbones' => 'skull-crossbones' ),
					array( 'fa-regular fa-skull' => 'skull' ),
					array( 'fa-regular fa-slash-back' => 'slash-back' ),
					array( 'fa-regular fa-slash-forward' => 'slash-forward' ),
					array( 'fa-regular fa-slash' => 'slash' ),
					array( 'fa-regular fa-sleigh' => 'sleigh' ),
					array( 'fa-regular fa-slider' => 'slider' ),
					array( 'fa-regular fa-sliders-simple' => 'sliders-simple' ),
					array( 'fa-regular fa-sliders-up' => 'sliders-up' ),
					array( 'fa-regular fa-sliders' => 'sliders' ),
					array( 'fa-regular fa-slot-machine' => 'slot-machine' ),
					array( 'fa-regular fa-smog' => 'smog' ),
					array( 'fa-regular fa-smoke' => 'smoke' ),
					array( 'fa-regular fa-smoking' => 'smoking' ),
					array( 'fa-regular fa-snake' => 'snake' ),
					array( 'fa-regular fa-snooze' => 'snooze' ),
					array( 'fa-regular fa-snow-blowing' => 'snow-blowing' ),
					array( 'fa-regular fa-snowflake-droplets' => 'snowflake-droplets' ),
					array( 'fa-regular fa-snowflake' => 'snowflake' ),
					array( 'fa-regular fa-snowflakes' => 'snowflakes' ),
					array( 'fa-regular fa-snowman-head' => 'snowman-head' ),
					array( 'fa-regular fa-snowman' => 'snowman' ),
					array( 'fa-regular fa-snowplow' => 'snowplow' ),
					array( 'fa-regular fa-soap' => 'soap' ),
					array( 'fa-regular fa-socks' => 'socks' ),
					array( 'fa-regular fa-soft-serve' => 'soft-serve' ),
					array( 'fa-regular fa-solar-panel' => 'solar-panel' ),
					array( 'fa-regular fa-solar-system' => 'solar-system' ),
					array( 'fa-regular fa-sort-down' => 'sort-down' ),
					array( 'fa-regular fa-sort-up' => 'sort-up' ),
					array( 'fa-regular fa-sort' => 'sort' ),
					array( 'fa-regular fa-spa' => 'spa' ),
					array( 'fa-regular fa-space-station-moon-construction' => 'space-station-moon-construction' ),
					array( 'fa-regular fa-space-station-moon' => 'space-station-moon' ),
					array( 'fa-regular fa-spade' => 'spade' ),
					array( 'fa-regular fa-spaghetti-monster-flying' => 'spaghetti-monster-flying' ),
					array( 'fa-regular fa-sparkle' => 'sparkle' ),
					array( 'fa-regular fa-sparkles' => 'sparkles' ),
					array( 'fa-regular fa-speaker' => 'speaker' ),
					array( 'fa-regular fa-speakers' => 'speakers' ),
					array( 'fa-regular fa-spell-check' => 'spell-check' ),
					array( 'fa-regular fa-spider-black-widow' => 'spider-black-widow' ),
					array( 'fa-regular fa-spider-web' => 'spider-web' ),
					array( 'fa-regular fa-spider' => 'spider' ),
					array( 'fa-regular fa-spinner-third' => 'spinner-third' ),
					array( 'fa-regular fa-spinner' => 'spinner' ),
					array( 'fa-regular fa-split' => 'split' ),
					array( 'fa-regular fa-splotch' => 'splotch' ),
					array( 'fa-regular fa-spoon' => 'spoon' ),
					array( 'fa-regular fa-sportsball' => 'sportsball' ),
					array( 'fa-regular fa-spray-can-sparkles' => 'spray-can-sparkles' ),
					array( 'fa-regular fa-spray-can' => 'spray-can' ),
					array( 'fa-regular fa-sprinkler-ceiling' => 'sprinkler-ceiling' ),
					array( 'fa-regular fa-sprinkler' => 'sprinkler' ),
					array( 'fa-regular fa-square-0' => 'square-0' ),
					array( 'fa-regular fa-square-1' => 'square-1' ),
					array( 'fa-regular fa-square-2' => 'square-2' ),
					array( 'fa-regular fa-square-3' => 'square-3' ),
					array( 'fa-regular fa-square-4' => 'square-4' ),
					array( 'fa-regular fa-square-5' => 'square-5' ),
					array( 'fa-regular fa-square-6' => 'square-6' ),
					array( 'fa-regular fa-square-7' => 'square-7' ),
					array( 'fa-regular fa-square-8' => 'square-8' ),
					array( 'fa-regular fa-square-9' => 'square-9' ),
					array( 'fa-regular fa-square-a-lock' => 'square-a-lock' ),
					array( 'fa-regular fa-square-a' => 'square-a' ),
					array( 'fa-regular fa-square-ampersand' => 'square-ampersand' ),
					array( 'fa-regular fa-square-arrow-down-left' => 'square-arrow-down-left' ),
					array( 'fa-regular fa-square-arrow-down-right' => 'square-arrow-down-right' ),
					array( 'fa-regular fa-square-arrow-down' => 'square-arrow-down' ),
					array( 'fa-regular fa-square-arrow-left' => 'square-arrow-left' ),
					array( 'fa-regular fa-square-arrow-right' => 'square-arrow-right' ),
					array( 'fa-regular fa-square-arrow-up-left' => 'square-arrow-up-left' ),
					array( 'fa-regular fa-square-arrow-up-right' => 'square-arrow-up-right' ),
					array( 'fa-regular fa-square-arrow-up' => 'square-arrow-up' ),
					array( 'fa-regular fa-square-b' => 'square-b' ),
					array( 'fa-regular fa-square-bolt' => 'square-bolt' ),
					array( 'fa-regular fa-square-c' => 'square-c' ),
					array( 'fa-regular fa-square-caret-down' => 'square-caret-down' ),
					array( 'fa-regular fa-square-caret-left' => 'square-caret-left' ),
					array( 'fa-regular fa-square-caret-right' => 'square-caret-right' ),
					array( 'fa-regular fa-square-caret-up' => 'square-caret-up' ),
					array( 'fa-regular fa-square-check' => 'square-check' ),
					array( 'fa-regular fa-square-chevron-down' => 'square-chevron-down' ),
					array( 'fa-regular fa-square-chevron-left' => 'square-chevron-left' ),
					array( 'fa-regular fa-square-chevron-right' => 'square-chevron-right' ),
					array( 'fa-regular fa-square-chevron-up' => 'square-chevron-up' ),
					array( 'fa-regular fa-square-code' => 'square-code' ),
					array( 'fa-regular fa-square-d' => 'square-d' ),
					array( 'fa-regular fa-square-dashed-circle-plus' => 'square-dashed-circle-plus' ),
					array( 'fa-regular fa-square-dashed' => 'square-dashed' ),
					array( 'fa-regular fa-square-divide' => 'square-divide' ),
					array( 'fa-regular fa-square-dollar' => 'square-dollar' ),
					array( 'fa-regular fa-square-down-left' => 'square-down-left' ),
					array( 'fa-regular fa-square-down-right' => 'square-down-right' ),
					array( 'fa-regular fa-square-down' => 'square-down' ),
					array( 'fa-regular fa-square-e' => 'square-e' ),
					array( 'fa-regular fa-square-ellipsis-vertical' => 'square-ellipsis-vertical' ),
					array( 'fa-regular fa-square-ellipsis' => 'square-ellipsis' ),
					array( 'fa-regular fa-square-envelope' => 'square-envelope' ),
					array( 'fa-regular fa-square-exclamation' => 'square-exclamation' ),
					array( 'fa-regular fa-square-f' => 'square-f' ),
					array( 'fa-regular fa-square-fragile' => 'square-fragile' ),
					array( 'fa-regular fa-square-full' => 'square-full' ),
					array( 'fa-regular fa-square-g' => 'square-g' ),
					array( 'fa-regular fa-square-h' => 'square-h' ),
					array( 'fa-regular fa-square-heart' => 'square-heart' ),
					array( 'fa-regular fa-square-i' => 'square-i' ),
					array( 'fa-regular fa-square-info' => 'square-info' ),
					array( 'fa-regular fa-square-j' => 'square-j' ),
					array( 'fa-regular fa-square-k' => 'square-k' ),
					array( 'fa-regular fa-square-kanban' => 'square-kanban' ),
					array( 'fa-regular fa-square-l' => 'square-l' ),
					array( 'fa-regular fa-square-left' => 'square-left' ),
					array( 'fa-regular fa-square-list' => 'square-list' ),
					array( 'fa-regular fa-square-m' => 'square-m' ),
					array( 'fa-regular fa-square-minus' => 'square-minus' ),
					array( 'fa-regular fa-square-n' => 'square-n' ),
					array( 'fa-regular fa-square-nfi' => 'square-nfi' ),
					array( 'fa-regular fa-square-o' => 'square-o' ),
					array( 'fa-regular fa-square-p' => 'square-p' ),
					array( 'fa-regular fa-square-parking-slash' => 'square-parking-slash' ),
					array( 'fa-regular fa-square-parking' => 'square-parking' ),
					array( 'fa-regular fa-square-pen' => 'square-pen' ),
					array( 'fa-regular fa-square-person-confined' => 'square-person-confined' ),
					array( 'fa-regular fa-square-phone-flip' => 'square-phone-flip' ),
					array( 'fa-regular fa-square-phone-hangup' => 'square-phone-hangup' ),
					array( 'fa-regular fa-square-phone' => 'square-phone' ),
					array( 'fa-regular fa-square-plus' => 'square-plus' ),
					array( 'fa-regular fa-square-poll-horizontal' => 'square-poll-horizontal' ),
					array( 'fa-regular fa-square-poll-vertical' => 'square-poll-vertical' ),
					array( 'fa-regular fa-square-q' => 'square-q' ),
					array( 'fa-regular fa-square-quarters' => 'square-quarters' ),
					array( 'fa-regular fa-square-question' => 'square-question' ),
					array( 'fa-regular fa-square-quote' => 'square-quote' ),
					array( 'fa-regular fa-square-r' => 'square-r' ),
					array( 'fa-regular fa-square-right' => 'square-right' ),
					array( 'fa-regular fa-square-ring' => 'square-ring' ),
					array( 'fa-regular fa-square-root-variable' => 'square-root-variable' ),
					array( 'fa-regular fa-square-root' => 'square-root' ),
					array( 'fa-regular fa-square-rss' => 'square-rss' ),
					array( 'fa-regular fa-square-s' => 'square-s' ),
					array( 'fa-regular fa-square-share-nodes' => 'square-share-nodes' ),
					array( 'fa-regular fa-square-sliders-vertical' => 'square-sliders-vertical' ),
					array( 'fa-regular fa-square-sliders' => 'square-sliders' ),
					array( 'fa-regular fa-square-small' => 'square-small' ),
					array( 'fa-regular fa-square-star' => 'square-star' ),
					array( 'fa-regular fa-square-t' => 'square-t' ),
					array( 'fa-regular fa-square-terminal' => 'square-terminal' ),
					array( 'fa-regular fa-square-this-way-up' => 'square-this-way-up' ),
					array( 'fa-regular fa-square-u' => 'square-u' ),
					array( 'fa-regular fa-square-up-left' => 'square-up-left' ),
					array( 'fa-regular fa-square-up-right' => 'square-up-right' ),
					array( 'fa-regular fa-square-up' => 'square-up' ),
					array( 'fa-regular fa-square-user' => 'square-user' ),
					array( 'fa-regular fa-square-v' => 'square-v' ),
					array( 'fa-regular fa-square-virus' => 'square-virus' ),
					array( 'fa-regular fa-square-w' => 'square-w' ),
					array( 'fa-regular fa-square-x' => 'square-x' ),
					array( 'fa-regular fa-square-xmark' => 'square-xmark' ),
					array( 'fa-regular fa-square-y' => 'square-y' ),
					array( 'fa-regular fa-square-z' => 'square-z' ),
					array( 'fa-regular fa-square' => 'square' ),
					array( 'fa-regular fa-squid' => 'squid' ),
					array( 'fa-regular fa-squirrel' => 'squirrel' ),
					array( 'fa-regular fa-staff-snake' => 'staff-snake' ),
					array( 'fa-regular fa-staff' => 'staff' ),
					array( 'fa-regular fa-stairs' => 'stairs' ),
					array( 'fa-regular fa-stamp' => 'stamp' ),
					array( 'fa-regular fa-standard-definition' => 'standard-definition' ),
					array( 'fa-regular fa-stapler' => 'stapler' ),
					array( 'fa-regular fa-star-and-crescent' => 'star-and-crescent' ),
					array( 'fa-regular fa-star-christmas' => 'star-christmas' ),
					array( 'fa-regular fa-star-exclamation' => 'star-exclamation' ),
					array( 'fa-regular fa-star-half-stroke' => 'star-half-stroke' ),
					array( 'fa-regular fa-star-half' => 'star-half' ),
					array( 'fa-regular fa-star-of-david' => 'star-of-david' ),
					array( 'fa-regular fa-star-of-life' => 'star-of-life' ),
					array( 'fa-regular fa-star-sharp-half-stroke' => 'star-sharp-half-stroke' ),
					array( 'fa-regular fa-star-sharp-half' => 'star-sharp-half' ),
					array( 'fa-regular fa-star-sharp' => 'star-sharp' ),
					array( 'fa-regular fa-star-shooting' => 'star-shooting' ),
					array( 'fa-regular fa-star' => 'star' ),
					array( 'fa-regular fa-starfighter-twin-ion-engine-advanced' => 'starfighter-twin-ion-engine-advanced' ),
					array( 'fa-regular fa-starfighter-twin-ion-engine' => 'starfighter-twin-ion-engine' ),
					array( 'fa-regular fa-starfighter' => 'starfighter' ),
					array( 'fa-regular fa-stars' => 'stars' ),
					array( 'fa-regular fa-starship-freighter' => 'starship-freighter' ),
					array( 'fa-regular fa-starship' => 'starship' ),
					array( 'fa-regular fa-steak' => 'steak' ),
					array( 'fa-regular fa-steering-wheel' => 'steering-wheel' ),
					array( 'fa-regular fa-sterling-sign' => 'sterling-sign' ),
					array( 'fa-regular fa-stethoscope' => 'stethoscope' ),
					array( 'fa-regular fa-stocking' => 'stocking' ),
					array( 'fa-regular fa-stomach' => 'stomach' ),
					array( 'fa-regular fa-stop' => 'stop' ),
					array( 'fa-regular fa-stopwatch-20' => 'stopwatch-20' ),
					array( 'fa-regular fa-stopwatch' => 'stopwatch' ),
					array( 'fa-regular fa-store-lock' => 'store-lock' ),
					array( 'fa-regular fa-store-slash' => 'store-slash' ),
					array( 'fa-regular fa-store' => 'store' ),
					array( 'fa-regular fa-strawberry' => 'strawberry' ),
					array( 'fa-regular fa-street-view' => 'street-view' ),
					array( 'fa-regular fa-stretcher' => 'stretcher' ),
					array( 'fa-regular fa-strikethrough' => 'strikethrough' ),
					array( 'fa-regular fa-stroopwafel' => 'stroopwafel' ),
					array( 'fa-regular fa-subscript' => 'subscript' ),
					array( 'fa-regular fa-subtitles-slash' => 'subtitles-slash' ),
					array( 'fa-regular fa-subtitles' => 'subtitles' ),
					array( 'fa-regular fa-suitcase-medical' => 'suitcase-medical' ),
					array( 'fa-regular fa-suitcase-rolling' => 'suitcase-rolling' ),
					array( 'fa-regular fa-suitcase' => 'suitcase' ),
					array( 'fa-regular fa-sun-bright' => 'sun-bright' ),
					array( 'fa-regular fa-sun-cloud' => 'sun-cloud' ),
					array( 'fa-regular fa-sun-dust' => 'sun-dust' ),
					array( 'fa-regular fa-sun-haze' => 'sun-haze' ),
					array( 'fa-regular fa-sun-plant-wilt' => 'sun-plant-wilt' ),
					array( 'fa-regular fa-sun' => 'sun' ),
					array( 'fa-regular fa-sunglasses' => 'sunglasses' ),
					array( 'fa-regular fa-sunrise' => 'sunrise' ),
					array( 'fa-regular fa-sunset' => 'sunset' ),
					array( 'fa-regular fa-superscript' => 'superscript' ),
					array( 'fa-regular fa-sushi-roll' => 'sushi-roll' ),
					array( 'fa-regular fa-sushi' => 'sushi' ),
					array( 'fa-regular fa-swap-arrows' => 'swap-arrows' ),
					array( 'fa-regular fa-swap' => 'swap' ),
					array( 'fa-regular fa-swatchbook' => 'swatchbook' ),
					array( 'fa-regular fa-sword-laser-alt' => 'sword-laser-alt' ),
					array( 'fa-regular fa-sword-laser' => 'sword-laser' ),
					array( 'fa-regular fa-sword' => 'sword' ),
					array( 'fa-regular fa-swords-laser' => 'swords-laser' ),
					array( 'fa-regular fa-swords' => 'swords' ),
					array( 'fa-regular fa-symbols' => 'symbols' ),
					array( 'fa-regular fa-synagogue' => 'synagogue' ),
					array( 'fa-regular fa-syringe' => 'syringe' ),
					array( 'fa-regular fa-t' => 't' ),
					array( 'fa-regular fa-table-cells-large' => 'table-cells-large' ),
					array( 'fa-regular fa-table-cells' => 'table-cells' ),
					array( 'fa-regular fa-table-columns' => 'table-columns' ),
					array( 'fa-regular fa-table-layout' => 'table-layout' ),
					array( 'fa-regular fa-table-list' => 'table-list' ),
					array( 'fa-regular fa-table-picnic' => 'table-picnic' ),
					array( 'fa-regular fa-table-pivot' => 'table-pivot' ),
					array( 'fa-regular fa-table-rows' => 'table-rows' ),
					array( 'fa-regular fa-table-tennis-paddle-ball' => 'table-tennis-paddle-ball' ),
					array( 'fa-regular fa-table-tree' => 'table-tree' ),
					array( 'fa-regular fa-table' => 'table' ),
					array( 'fa-regular fa-tablet-button' => 'tablet-button' ),
					array( 'fa-regular fa-tablet-rugged' => 'tablet-rugged' ),
					array( 'fa-regular fa-tablet-screen-button' => 'tablet-screen-button' ),
					array( 'fa-regular fa-tablet-screen' => 'tablet-screen' ),
					array( 'fa-regular fa-tablet' => 'tablet' ),
					array( 'fa-regular fa-tablets' => 'tablets' ),
					array( 'fa-regular fa-tachograph-digital' => 'tachograph-digital' ),
					array( 'fa-regular fa-taco' => 'taco' ),
					array( 'fa-regular fa-tag' => 'tag' ),
					array( 'fa-regular fa-tags' => 'tags' ),
					array( 'fa-regular fa-tally-1' => 'tally-1' ),
					array( 'fa-regular fa-tally-2' => 'tally-2' ),
					array( 'fa-regular fa-tally-3' => 'tally-3' ),
					array( 'fa-regular fa-tally-4' => 'tally-4' ),
					array( 'fa-regular fa-tally' => 'tally' ),
					array( 'fa-regular fa-tamale' => 'tamale' ),
					array( 'fa-regular fa-tank-water' => 'tank-water' ),
					array( 'fa-regular fa-tape' => 'tape' ),
					array( 'fa-regular fa-tarp-droplet' => 'tarp-droplet' ),
					array( 'fa-regular fa-tarp' => 'tarp' ),
					array( 'fa-regular fa-taxi-bus' => 'taxi-bus' ),
					array( 'fa-regular fa-taxi' => 'taxi' ),
					array( 'fa-regular fa-teddy-bear' => 'teddy-bear' ),
					array( 'fa-regular fa-teeth-open' => 'teeth-open' ),
					array( 'fa-regular fa-teeth' => 'teeth' ),
					array( 'fa-regular fa-telescope' => 'telescope' ),
					array( 'fa-regular fa-temperature-arrow-down' => 'temperature-arrow-down' ),
					array( 'fa-regular fa-temperature-arrow-up' => 'temperature-arrow-up' ),
					array( 'fa-regular fa-temperature-empty' => 'temperature-empty' ),
					array( 'fa-regular fa-temperature-full' => 'temperature-full' ),
					array( 'fa-regular fa-temperature-half' => 'temperature-half' ),
					array( 'fa-regular fa-temperature-high' => 'temperature-high' ),
					array( 'fa-regular fa-temperature-list' => 'temperature-list' ),
					array( 'fa-regular fa-temperature-low' => 'temperature-low' ),
					array( 'fa-regular fa-temperature-quarter' => 'temperature-quarter' ),
					array( 'fa-regular fa-temperature-snow' => 'temperature-snow' ),
					array( 'fa-regular fa-temperature-sun' => 'temperature-sun' ),
					array( 'fa-regular fa-temperature-three-quarters' => 'temperature-three-quarters' ),
					array( 'fa-regular fa-tenge-sign' => 'tenge-sign' ),
					array( 'fa-regular fa-tennis-ball' => 'tennis-ball' ),
					array( 'fa-regular fa-tent-arrow-down-to-line' => 'tent-arrow-down-to-line' ),
					array( 'fa-regular fa-tent-arrow-left-right' => 'tent-arrow-left-right' ),
					array( 'fa-regular fa-tent-arrow-turn-left' => 'tent-arrow-turn-left' ),
					array( 'fa-regular fa-tent-arrows-down' => 'tent-arrows-down' ),
					array( 'fa-regular fa-tent' => 'tent' ),
					array( 'fa-regular fa-tents' => 'tents' ),
					array( 'fa-regular fa-terminal' => 'terminal' ),
					array( 'fa-regular fa-text-height' => 'text-height' ),
					array( 'fa-regular fa-text-size' => 'text-size' ),
					array( 'fa-regular fa-text-slash' => 'text-slash' ),
					array( 'fa-regular fa-text-width' => 'text-width' ),
					array( 'fa-regular fa-text' => 'text' ),
					array( 'fa-regular fa-thermometer' => 'thermometer' ),
					array( 'fa-regular fa-theta' => 'theta' ),
					array( 'fa-regular fa-thought-bubble' => 'thought-bubble' ),
					array( 'fa-regular fa-thumbs-down' => 'thumbs-down' ),
					array( 'fa-regular fa-thumbs-up' => 'thumbs-up' ),
					array( 'fa-regular fa-thumbtack' => 'thumbtack' ),
					array( 'fa-regular fa-tick' => 'tick' ),
					array( 'fa-regular fa-ticket-airline' => 'ticket-airline' ),
					array( 'fa-regular fa-ticket-simple' => 'ticket-simple' ),
					array( 'fa-regular fa-ticket' => 'ticket' ),
					array( 'fa-regular fa-tickets-airline' => 'tickets-airline' ),
					array( 'fa-regular fa-tilde' => 'tilde' ),
					array( 'fa-regular fa-timeline-arrow' => 'timeline-arrow' ),
					array( 'fa-regular fa-timeline' => 'timeline' ),
					array( 'fa-regular fa-timer' => 'timer' ),
					array( 'fa-regular fa-tire-flat' => 'tire-flat' ),
					array( 'fa-regular fa-tire-pressure-warning' => 'tire-pressure-warning' ),
					array( 'fa-regular fa-tire-rugged' => 'tire-rugged' ),
					array( 'fa-regular fa-tire' => 'tire' ),
					array( 'fa-regular fa-toggle-large-off' => 'toggle-large-off' ),
					array( 'fa-regular fa-toggle-large-on' => 'toggle-large-on' ),
					array( 'fa-regular fa-toggle-off' => 'toggle-off' ),
					array( 'fa-regular fa-toggle-on' => 'toggle-on' ),
					array( 'fa-regular fa-toilet-paper-blank-under' => 'toilet-paper-blank-under' ),
					array( 'fa-regular fa-toilet-paper-blank' => 'toilet-paper-blank' ),
					array( 'fa-regular fa-toilet-paper-check' => 'toilet-paper-check' ),
					array( 'fa-regular fa-toilet-paper-slash' => 'toilet-paper-slash' ),
					array( 'fa-regular fa-toilet-paper-under-slash' => 'toilet-paper-under-slash' ),
					array( 'fa-regular fa-toilet-paper-under' => 'toilet-paper-under' ),
					array( 'fa-regular fa-toilet-paper-xmark' => 'toilet-paper-xmark' ),
					array( 'fa-regular fa-toilet-paper' => 'toilet-paper' ),
					array( 'fa-regular fa-toilet-portable' => 'toilet-portable' ),
					array( 'fa-regular fa-toilet' => 'toilet' ),
					array( 'fa-regular fa-toilets-portable' => 'toilets-portable' ),
					array( 'fa-regular fa-tomato' => 'tomato' ),
					array( 'fa-regular fa-tombstone-blank' => 'tombstone-blank' ),
					array( 'fa-regular fa-tombstone' => 'tombstone' ),
					array( 'fa-regular fa-toolbox' => 'toolbox' ),
					array( 'fa-regular fa-tooth' => 'tooth' ),
					array( 'fa-regular fa-toothbrush' => 'toothbrush' ),
					array( 'fa-regular fa-torii-gate' => 'torii-gate' ),
					array( 'fa-regular fa-tornado' => 'tornado' ),
					array( 'fa-regular fa-tower-broadcast' => 'tower-broadcast' ),
					array( 'fa-regular fa-tower-cell' => 'tower-cell' ),
					array( 'fa-regular fa-tower-control' => 'tower-control' ),
					array( 'fa-regular fa-tower-observation' => 'tower-observation' ),
					array( 'fa-regular fa-tractor' => 'tractor' ),
					array( 'fa-regular fa-trademark' => 'trademark' ),
					array( 'fa-regular fa-traffic-cone' => 'traffic-cone' ),
					array( 'fa-regular fa-traffic-light-go' => 'traffic-light-go' ),
					array( 'fa-regular fa-traffic-light-slow' => 'traffic-light-slow' ),
					array( 'fa-regular fa-traffic-light-stop' => 'traffic-light-stop' ),
					array( 'fa-regular fa-traffic-light' => 'traffic-light' ),
					array( 'fa-regular fa-trailer' => 'trailer' ),
					array( 'fa-regular fa-train-subway-tunnel' => 'train-subway-tunnel' ),
					array( 'fa-regular fa-train-subway' => 'train-subway' ),
					array( 'fa-regular fa-train-track' => 'train-track' ),
					array( 'fa-regular fa-train-tram' => 'train-tram' ),
					array( 'fa-regular fa-train-tunnel' => 'train-tunnel' ),
					array( 'fa-regular fa-train' => 'train' ),
					array( 'fa-regular fa-transformer-bolt' => 'transformer-bolt' ),
					array( 'fa-regular fa-transgender' => 'transgender' ),
					array( 'fa-regular fa-transporter-1' => 'transporter-1' ),
					array( 'fa-regular fa-transporter-2' => 'transporter-2' ),
					array( 'fa-regular fa-transporter-3' => 'transporter-3' ),
					array( 'fa-regular fa-transporter-4' => 'transporter-4' ),
					array( 'fa-regular fa-transporter-5' => 'transporter-5' ),
					array( 'fa-regular fa-transporter-6' => 'transporter-6' ),
					array( 'fa-regular fa-transporter-7' => 'transporter-7' ),
					array( 'fa-regular fa-transporter-empty' => 'transporter-empty' ),
					array( 'fa-regular fa-transporter' => 'transporter' ),
					array( 'fa-regular fa-trash-arrow-up' => 'trash-arrow-up' ),
					array( 'fa-regular fa-trash-can-arrow-up' => 'trash-can-arrow-up' ),
					array( 'fa-regular fa-trash-can-check' => 'trash-can-check' ),
					array( 'fa-regular fa-trash-can-clock' => 'trash-can-clock' ),
					array( 'fa-regular fa-trash-can-list' => 'trash-can-list' ),
					array( 'fa-regular fa-trash-can-plus' => 'trash-can-plus' ),
					array( 'fa-regular fa-trash-can-slash' => 'trash-can-slash' ),
					array( 'fa-regular fa-trash-can-undo' => 'trash-can-undo' ),
					array( 'fa-regular fa-trash-can-xmark' => 'trash-can-xmark' ),
					array( 'fa-regular fa-trash-can' => 'trash-can' ),
					array( 'fa-regular fa-trash-check' => 'trash-check' ),
					array( 'fa-regular fa-trash-clock' => 'trash-clock' ),
					array( 'fa-regular fa-trash-list' => 'trash-list' ),
					array( 'fa-regular fa-trash-plus' => 'trash-plus' ),
					array( 'fa-regular fa-trash-slash' => 'trash-slash' ),
					array( 'fa-regular fa-trash-undo' => 'trash-undo' ),
					array( 'fa-regular fa-trash-xmark' => 'trash-xmark' ),
					array( 'fa-regular fa-trash' => 'trash' ),
					array( 'fa-regular fa-treasure-chest' => 'treasure-chest' ),
					array( 'fa-regular fa-tree-christmas' => 'tree-christmas' ),
					array( 'fa-regular fa-tree-city' => 'tree-city' ),
					array( 'fa-regular fa-tree-deciduous' => 'tree-deciduous' ),
					array( 'fa-regular fa-tree-decorated' => 'tree-decorated' ),
					array( 'fa-regular fa-tree-large' => 'tree-large' ),
					array( 'fa-regular fa-tree-palm' => 'tree-palm' ),
					array( 'fa-regular fa-tree' => 'tree' ),
					array( 'fa-regular fa-trees' => 'trees' ),
					array( 'fa-regular fa-triangle-exclamation' => 'triangle-exclamation' ),
					array( 'fa-regular fa-triangle-instrument' => 'triangle-instrument' ),
					array( 'fa-regular fa-triangle-person-digging' => 'triangle-person-digging' ),
					array( 'fa-regular fa-triangle' => 'triangle' ),
					array( 'fa-regular fa-tricycle-adult' => 'tricycle-adult' ),
					array( 'fa-regular fa-tricycle' => 'tricycle' ),
					array( 'fa-regular fa-trillium' => 'trillium' ),
					array( 'fa-regular fa-trophy-star' => 'trophy-star' ),
					array( 'fa-regular fa-trophy' => 'trophy' ),
					array( 'fa-regular fa-trowel-bricks' => 'trowel-bricks' ),
					array( 'fa-regular fa-trowel' => 'trowel' ),
					array( 'fa-regular fa-truck-arrow-right' => 'truck-arrow-right' ),
					array( 'fa-regular fa-truck-bolt' => 'truck-bolt' ),
					array( 'fa-regular fa-truck-clock' => 'truck-clock' ),
					array( 'fa-regular fa-truck-container-empty' => 'truck-container-empty' ),
					array( 'fa-regular fa-truck-container' => 'truck-container' ),
					array( 'fa-regular fa-truck-droplet' => 'truck-droplet' ),
					array( 'fa-regular fa-truck-fast' => 'truck-fast' ),
					array( 'fa-regular fa-truck-field-un' => 'truck-field-un' ),
					array( 'fa-regular fa-truck-field' => 'truck-field' ),
					array( 'fa-regular fa-truck-flatbed' => 'truck-flatbed' ),
					array( 'fa-regular fa-truck-front' => 'truck-front' ),
					array( 'fa-regular fa-truck-medical' => 'truck-medical' ),
					array( 'fa-regular fa-truck-monster' => 'truck-monster' ),
					array( 'fa-regular fa-truck-moving' => 'truck-moving' ),
					array( 'fa-regular fa-truck-pickup' => 'truck-pickup' ),
					array( 'fa-regular fa-truck-plane' => 'truck-plane' ),
					array( 'fa-regular fa-truck-plow' => 'truck-plow' ),
					array( 'fa-regular fa-truck-ramp-box' => 'truck-ramp-box' ),
					array( 'fa-regular fa-truck-ramp-couch' => 'truck-ramp-couch' ),
					array( 'fa-regular fa-truck-ramp' => 'truck-ramp' ),
					array( 'fa-regular fa-truck-tow' => 'truck-tow' ),
					array( 'fa-regular fa-truck' => 'truck' ),
					array( 'fa-regular fa-trumpet' => 'trumpet' ),
					array( 'fa-regular fa-tty-answer' => 'tty-answer' ),
					array( 'fa-regular fa-tty' => 'tty' ),
					array( 'fa-regular fa-tugrik-sign' => 'tugrik-sign' ),
					array( 'fa-regular fa-turkey' => 'turkey' ),
					array( 'fa-regular fa-turkish-lira-sign' => 'turkish-lira-sign' ),
					array( 'fa-regular fa-turn-down-left' => 'turn-down-left' ),
					array( 'fa-regular fa-turn-down-right' => 'turn-down-right' ),
					array( 'fa-regular fa-turn-down' => 'turn-down' ),
					array( 'fa-regular fa-turn-up' => 'turn-up' ),
					array( 'fa-regular fa-turntable' => 'turntable' ),
					array( 'fa-regular fa-turtle' => 'turtle' ),
					array( 'fa-regular fa-tv-music' => 'tv-music' ),
					array( 'fa-regular fa-tv-retro' => 'tv-retro' ),
					array( 'fa-regular fa-tv' => 'tv' ),
					array( 'fa-regular fa-typewriter' => 'typewriter' ),
					array( 'fa-regular fa-u' => 'u' ),
					array( 'fa-regular fa-ufo-beam' => 'ufo-beam' ),
					array( 'fa-regular fa-ufo' => 'ufo' ),
					array( 'fa-regular fa-umbrella-beach' => 'umbrella-beach' ),
					array( 'fa-regular fa-umbrella-simple' => 'umbrella-simple' ),
					array( 'fa-regular fa-umbrella' => 'umbrella' ),
					array( 'fa-regular fa-underline' => 'underline' ),
					array( 'fa-regular fa-unicorn' => 'unicorn' ),
					array( 'fa-regular fa-uniform-martial-arts' => 'uniform-martial-arts' ),
					array( 'fa-regular fa-union' => 'union' ),
					array( 'fa-regular fa-universal-access' => 'universal-access' ),
					array( 'fa-regular fa-unlock-keyhole' => 'unlock-keyhole' ),
					array( 'fa-regular fa-unlock' => 'unlock' ),
					array( 'fa-regular fa-up-down-left-right' => 'up-down-left-right' ),
					array( 'fa-regular fa-up-down' => 'up-down' ),
					array( 'fa-regular fa-up-from-bracket' => 'up-from-bracket' ),
					array( 'fa-regular fa-up-from-dotted-line' => 'up-from-dotted-line' ),
					array( 'fa-regular fa-up-from-line' => 'up-from-line' ),
					array( 'fa-regular fa-up-left' => 'up-left' ),
					array( 'fa-regular fa-up-long' => 'up-long' ),
					array( 'fa-regular fa-up-right-and-down-left-from-center' => 'up-right-and-down-left-from-center' ),
					array( 'fa-regular fa-up-right-from-square' => 'up-right-from-square' ),
					array( 'fa-regular fa-up-right' => 'up-right' ),
					array( 'fa-regular fa-up-to-dotted-line' => 'up-to-dotted-line' ),
					array( 'fa-regular fa-up-to-line' => 'up-to-line' ),
					array( 'fa-regular fa-up' => 'up' ),
					array( 'fa-regular fa-upload' => 'upload' ),
					array( 'fa-regular fa-usb-drive' => 'usb-drive' ),
					array( 'fa-regular fa-user-alien' => 'user-alien' ),
					array( 'fa-regular fa-user-astronaut' => 'user-astronaut' ),
					array( 'fa-regular fa-user-bounty-hunter' => 'user-bounty-hunter' ),
					array( 'fa-regular fa-user-check' => 'user-check' ),
					array( 'fa-regular fa-user-chef' => 'user-chef' ),
					array( 'fa-regular fa-user-clock' => 'user-clock' ),
					array( 'fa-regular fa-user-cowboy' => 'user-cowboy' ),
					array( 'fa-regular fa-user-crown' => 'user-crown' ),
					array( 'fa-regular fa-user-doctor-hair-long' => 'user-doctor-hair-long' ),
					array( 'fa-regular fa-user-doctor-hair' => 'user-doctor-hair' ),
					array( 'fa-regular fa-user-doctor-message' => 'user-doctor-message' ),
					array( 'fa-regular fa-user-doctor' => 'user-doctor' ),
					array( 'fa-regular fa-user-gear' => 'user-gear' ),
					array( 'fa-regular fa-user-graduate' => 'user-graduate' ),
					array( 'fa-regular fa-user-group-crown' => 'user-group-crown' ),
					array( 'fa-regular fa-user-group-simple' => 'user-group-simple' ),
					array( 'fa-regular fa-user-group' => 'user-group' ),
					array( 'fa-regular fa-user-hair-buns' => 'user-hair-buns' ),
					array( 'fa-regular fa-user-hair-long' => 'user-hair-long' ),
					array( 'fa-regular fa-user-hair-mullet' => 'user-hair-mullet' ),
					array( 'fa-regular fa-user-hair' => 'user-hair' ),
					array( 'fa-regular fa-user-headset' => 'user-headset' ),
					array( 'fa-regular fa-user-helmet-safety' => 'user-helmet-safety' ),
					array( 'fa-regular fa-user-injured' => 'user-injured' ),
					array( 'fa-regular fa-user-large-slash' => 'user-large-slash' ),
					array( 'fa-regular fa-user-large' => 'user-large' ),
					array( 'fa-regular fa-user-lock' => 'user-lock' ),
					array( 'fa-regular fa-user-magnifying-glass' => 'user-magnifying-glass' ),
					array( 'fa-regular fa-user-minus' => 'user-minus' ),
					array( 'fa-regular fa-user-music' => 'user-music' ),
					array( 'fa-regular fa-user-ninja' => 'user-ninja' ),
					array( 'fa-regular fa-user-nurse-hair-long' => 'user-nurse-hair-long' ),
					array( 'fa-regular fa-user-nurse-hair' => 'user-nurse-hair' ),
					array( 'fa-regular fa-user-nurse' => 'user-nurse' ),
					array( 'fa-regular fa-user-pen' => 'user-pen' ),
					array( 'fa-regular fa-user-pilot-tie' => 'user-pilot-tie' ),
					array( 'fa-regular fa-user-pilot' => 'user-pilot' ),
					array( 'fa-regular fa-user-plus' => 'user-plus' ),
					array( 'fa-regular fa-user-police-tie' => 'user-police-tie' ),
					array( 'fa-regular fa-user-police' => 'user-police' ),
					array( 'fa-regular fa-user-robot-xmarks' => 'user-robot-xmarks' ),
					array( 'fa-regular fa-user-robot' => 'user-robot' ),
					array( 'fa-regular fa-user-secret' => 'user-secret' ),
					array( 'fa-regular fa-user-shakespeare' => 'user-shakespeare' ),
					array( 'fa-regular fa-user-shield' => 'user-shield' ),
					array( 'fa-regular fa-user-slash' => 'user-slash' ),
					array( 'fa-regular fa-user-tag' => 'user-tag' ),
					array( 'fa-regular fa-user-tie-hair-long' => 'user-tie-hair-long' ),
					array( 'fa-regular fa-user-tie-hair' => 'user-tie-hair' ),
					array( 'fa-regular fa-user-tie' => 'user-tie' ),
					array( 'fa-regular fa-user-unlock' => 'user-unlock' ),
					array( 'fa-regular fa-user-visor' => 'user-visor' ),
					array( 'fa-regular fa-user-vneck-hair-long' => 'user-vneck-hair-long' ),
					array( 'fa-regular fa-user-vneck-hair' => 'user-vneck-hair' ),
					array( 'fa-regular fa-user-vneck' => 'user-vneck' ),
					array( 'fa-regular fa-user-xmark' => 'user-xmark' ),
					array( 'fa-regular fa-user' => 'user' ),
					array( 'fa-regular fa-users-between-lines' => 'users-between-lines' ),
					array( 'fa-regular fa-users-gear' => 'users-gear' ),
					array( 'fa-regular fa-users-line' => 'users-line' ),
					array( 'fa-regular fa-users-medical' => 'users-medical' ),
					array( 'fa-regular fa-users-rays' => 'users-rays' ),
					array( 'fa-regular fa-users-rectangle' => 'users-rectangle' ),
					array( 'fa-regular fa-users-slash' => 'users-slash' ),
					array( 'fa-regular fa-users-viewfinder' => 'users-viewfinder' ),
					array( 'fa-regular fa-users' => 'users' ),
					array( 'fa-regular fa-utensils-slash' => 'utensils-slash' ),
					array( 'fa-regular fa-utensils' => 'utensils' ),
					array( 'fa-regular fa-utility-pole-double' => 'utility-pole-double' ),
					array( 'fa-regular fa-utility-pole' => 'utility-pole' ),
					array( 'fa-regular fa-v' => 'v' ),
					array( 'fa-regular fa-vacuum-robot' => 'vacuum-robot' ),
					array( 'fa-regular fa-vacuum' => 'vacuum' ),
					array( 'fa-regular fa-value-absolute' => 'value-absolute' ),
					array( 'fa-regular fa-van-shuttle' => 'van-shuttle' ),
					array( 'fa-regular fa-vault' => 'vault' ),
					array( 'fa-regular fa-vector-circle' => 'vector-circle' ),
					array( 'fa-regular fa-vector-polygon' => 'vector-polygon' ),
					array( 'fa-regular fa-vector-square' => 'vector-square' ),
					array( 'fa-regular fa-vent-damper' => 'vent-damper' ),
					array( 'fa-regular fa-venus-double' => 'venus-double' ),
					array( 'fa-regular fa-venus-mars' => 'venus-mars' ),
					array( 'fa-regular fa-venus' => 'venus' ),
					array( 'fa-regular fa-vest-patches' => 'vest-patches' ),
					array( 'fa-regular fa-vest' => 'vest' ),
					array( 'fa-regular fa-vial-circle-check' => 'vial-circle-check' ),
					array( 'fa-regular fa-vial-virus' => 'vial-virus' ),
					array( 'fa-regular fa-vial' => 'vial' ),
					array( 'fa-regular fa-vials' => 'vials' ),
					array( 'fa-regular fa-video-arrow-down-left' => 'video-arrow-down-left' ),
					array( 'fa-regular fa-video-arrow-up-right' => 'video-arrow-up-right' ),
					array( 'fa-regular fa-video-plus' => 'video-plus' ),
					array( 'fa-regular fa-video-slash' => 'video-slash' ),
					array( 'fa-regular fa-video' => 'video' ),
					array( 'fa-regular fa-vihara' => 'vihara' ),
					array( 'fa-regular fa-violin' => 'violin' ),
					array( 'fa-regular fa-virus-covid-slash' => 'virus-covid-slash' ),
					array( 'fa-regular fa-virus-covid' => 'virus-covid' ),
					array( 'fa-regular fa-virus-slash' => 'virus-slash' ),
					array( 'fa-regular fa-virus' => 'virus' ),
					array( 'fa-regular fa-viruses' => 'viruses' ),
					array( 'fa-regular fa-voicemail' => 'voicemail' ),
					array( 'fa-regular fa-volcano' => 'volcano' ),
					array( 'fa-regular fa-volleyball' => 'volleyball' ),
					array( 'fa-regular fa-volume-high' => 'volume-high' ),
					array( 'fa-regular fa-volume-low' => 'volume-low' ),
					array( 'fa-regular fa-volume-off' => 'volume-off' ),
					array( 'fa-regular fa-volume-slash' => 'volume-slash' ),
					array( 'fa-regular fa-volume-xmark' => 'volume-xmark' ),
					array( 'fa-regular fa-volume' => 'volume' ),
					array( 'fa-regular fa-vr-cardboard' => 'vr-cardboard' ),
					array( 'fa-regular fa-w' => 'w' ),
					array( 'fa-regular fa-waffle' => 'waffle' ),
					array( 'fa-regular fa-wagon-covered' => 'wagon-covered' ),
					array( 'fa-regular fa-walker' => 'walker' ),
					array( 'fa-regular fa-walkie-talkie' => 'walkie-talkie' ),
					array( 'fa-regular fa-wallet' => 'wallet' ),
					array( 'fa-regular fa-wand-magic-sparkles' => 'wand-magic-sparkles' ),
					array( 'fa-regular fa-wand-magic' => 'wand-magic' ),
					array( 'fa-regular fa-wand-sparkles' => 'wand-sparkles' ),
					array( 'fa-regular fa-wand' => 'wand' ),
					array( 'fa-regular fa-warehouse-full' => 'warehouse-full' ),
					array( 'fa-regular fa-warehouse' => 'warehouse' ),
					array( 'fa-regular fa-washing-machine' => 'washing-machine' ),
					array( 'fa-regular fa-watch-apple' => 'watch-apple' ),
					array( 'fa-regular fa-watch-calculator' => 'watch-calculator' ),
					array( 'fa-regular fa-watch-fitness' => 'watch-fitness' ),
					array( 'fa-regular fa-watch-smart' => 'watch-smart' ),
					array( 'fa-regular fa-watch' => 'watch' ),
					array( 'fa-regular fa-water-arrow-down' => 'water-arrow-down' ),
					array( 'fa-regular fa-water-arrow-up' => 'water-arrow-up' ),
					array( 'fa-regular fa-water-ladder' => 'water-ladder' ),
					array( 'fa-regular fa-water' => 'water' ),
					array( 'fa-regular fa-watermelon-slice' => 'watermelon-slice' ),
					array( 'fa-regular fa-wave-pulse' => 'wave-pulse' ),
					array( 'fa-regular fa-wave-sine' => 'wave-sine' ),
					array( 'fa-regular fa-wave-square' => 'wave-square' ),
					array( 'fa-regular fa-wave-triangle' => 'wave-triangle' ),
					array( 'fa-regular fa-waveform-lines' => 'waveform-lines' ),
					array( 'fa-regular fa-waveform' => 'waveform' ),
					array( 'fa-regular fa-webhook' => 'webhook' ),
					array( 'fa-regular fa-weight-hanging' => 'weight-hanging' ),
					array( 'fa-regular fa-weight-scale' => 'weight-scale' ),
					array( 'fa-regular fa-whale' => 'whale' ),
					array( 'fa-regular fa-wheat-awn-circle-exclamation' => 'wheat-awn-circle-exclamation' ),
					array( 'fa-regular fa-wheat-awn-slash' => 'wheat-awn-slash' ),
					array( 'fa-regular fa-wheat-awn' => 'wheat-awn' ),
					array( 'fa-regular fa-wheat-slash' => 'wheat-slash' ),
					array( 'fa-regular fa-wheat' => 'wheat' ),
					array( 'fa-regular fa-wheelchair-move' => 'wheelchair-move' ),
					array( 'fa-regular fa-wheelchair' => 'wheelchair' ),
					array( 'fa-regular fa-whiskey-glass-ice' => 'whiskey-glass-ice' ),
					array( 'fa-regular fa-whiskey-glass' => 'whiskey-glass' ),
					array( 'fa-regular fa-whistle' => 'whistle' ),
					array( 'fa-regular fa-wifi-exclamation' => 'wifi-exclamation' ),
					array( 'fa-regular fa-wifi-fair' => 'wifi-fair' ),
					array( 'fa-regular fa-wifi-slash' => 'wifi-slash' ),
					array( 'fa-regular fa-wifi-weak' => 'wifi-weak' ),
					array( 'fa-regular fa-wifi' => 'wifi' ),
					array( 'fa-regular fa-wind-turbine' => 'wind-turbine' ),
					array( 'fa-regular fa-wind-warning' => 'wind-warning' ),
					array( 'fa-regular fa-wind' => 'wind' ),
					array( 'fa-regular fa-window-flip' => 'window-flip' ),
					array( 'fa-regular fa-window-frame-open' => 'window-frame-open' ),
					array( 'fa-regular fa-window-frame' => 'window-frame' ),
					array( 'fa-regular fa-window-maximize' => 'window-maximize' ),
					array( 'fa-regular fa-window-minimize' => 'window-minimize' ),
					array( 'fa-regular fa-window-restore' => 'window-restore' ),
					array( 'fa-regular fa-window' => 'window' ),
					array( 'fa-regular fa-windsock' => 'windsock' ),
					array( 'fa-regular fa-wine-bottle' => 'wine-bottle' ),
					array( 'fa-regular fa-wine-glass-crack' => 'wine-glass-crack' ),
					array( 'fa-regular fa-wine-glass-empty' => 'wine-glass-empty' ),
					array( 'fa-regular fa-wine-glass' => 'wine-glass' ),
					array( 'fa-regular fa-won-sign' => 'won-sign' ),
					array( 'fa-regular fa-worm' => 'worm' ),
					array( 'fa-regular fa-wreath-laurel' => 'wreath-laurel' ),
					array( 'fa-regular fa-wreath' => 'wreath' ),
					array( 'fa-regular fa-wrench-simple' => 'wrench-simple' ),
					array( 'fa-regular fa-wrench' => 'wrench' ),
					array( 'fa-regular fa-x-ray' => 'x-ray' ),
					array( 'fa-regular fa-x' => 'x' ),
					array( 'fa-regular fa-xmark-large' => 'xmark-large' ),
					array( 'fa-regular fa-xmark-to-slot' => 'xmark-to-slot' ),
					array( 'fa-regular fa-xmark' => 'xmark' ),
					array( 'fa-regular fa-xmarks-lines' => 'xmarks-lines' ),
					array( 'fa-regular fa-y' => 'y' ),
					array( 'fa-regular fa-yen-sign' => 'yen-sign' ),
					array( 'fa-regular fa-yin-yang' => 'yin-yang' ),
					array( 'fa-regular fa-z' => 'z' ),
				),
				esc_html__( 'Solid', 'smilepure' )   => array(
					array( 'fa-solid fa-0' => '0' ),
					array( 'fa-solid fa-00' => '00' ),
					array( 'fa-solid fa-1' => '1' ),
					array( 'fa-solid fa-2' => '2' ),
					array( 'fa-solid fa-3' => '3' ),
					array( 'fa-solid fa-4' => '4' ),
					array( 'fa-solid fa-5' => '5' ),
					array( 'fa-solid fa-6' => '6' ),
					array( 'fa-solid fa-7' => '7' ),
					array( 'fa-solid fa-8' => '8' ),
					array( 'fa-solid fa-9' => '9' ),
					array( 'fa-solid fa-360-degrees' => '360-degrees' ),
					array( 'fa-solid fa-a' => 'a' ),
					array( 'fa-solid fa-abacus' => 'abacus' ),
					array( 'fa-solid fa-accent-grave' => 'accent-grave' ),
					array( 'fa-solid fa-acorn' => 'acorn' ),
					array( 'fa-solid fa-address-book' => 'address-book' ),
					array( 'fa-solid fa-address-card' => 'address-card' ),
					array( 'fa-solid fa-air-conditioner' => 'air-conditioner' ),
					array( 'fa-solid fa-airplay' => 'airplay' ),
					array( 'fa-solid fa-alarm-clock' => 'alarm-clock' ),
					array( 'fa-solid fa-alarm-exclamation' => 'alarm-exclamation' ),
					array( 'fa-solid fa-alarm-plus' => 'alarm-plus' ),
					array( 'fa-solid fa-alarm-snooze' => 'alarm-snooze' ),
					array( 'fa-solid fa-album-circle-plus' => 'album-circle-plus' ),
					array( 'fa-solid fa-album-circle-user' => 'album-circle-user' ),
					array( 'fa-solid fa-album-collection-circle-plus' => 'album-collection-circle-plus' ),
					array( 'fa-solid fa-album-collection-circle-user' => 'album-collection-circle-user' ),
					array( 'fa-solid fa-album-collection' => 'album-collection' ),
					array( 'fa-solid fa-album' => 'album' ),
					array( 'fa-solid fa-alicorn' => 'alicorn' ),
					array( 'fa-solid fa-alien-8bit' => 'alien-8bit' ),
					array( 'fa-solid fa-alien' => 'alien' ),
					array( 'fa-solid fa-align-center' => 'align-center' ),
					array( 'fa-solid fa-align-justify' => 'align-justify' ),
					array( 'fa-solid fa-align-left' => 'align-left' ),
					array( 'fa-solid fa-align-right' => 'align-right' ),
					array( 'fa-solid fa-align-slash' => 'align-slash' ),
					array( 'fa-solid fa-alt' => 'alt' ),
					array( 'fa-solid fa-amp-guitar' => 'amp-guitar' ),
					array( 'fa-solid fa-ampersand' => 'ampersand' ),
					array( 'fa-solid fa-anchor-circle-check' => 'anchor-circle-check' ),
					array( 'fa-solid fa-anchor-circle-exclamation' => 'anchor-circle-exclamation' ),
					array( 'fa-solid fa-anchor-circle-xmark' => 'anchor-circle-xmark' ),
					array( 'fa-solid fa-anchor-lock' => 'anchor-lock' ),
					array( 'fa-solid fa-anchor' => 'anchor' ),
					array( 'fa-solid fa-angel' => 'angel' ),
					array( 'fa-solid fa-angle-90' => 'angle-90' ),
					array( 'fa-solid fa-angle-down' => 'angle-down' ),
					array( 'fa-solid fa-angle-left' => 'angle-left' ),
					array( 'fa-solid fa-angle-right' => 'angle-right' ),
					array( 'fa-solid fa-angle-up' => 'angle-up' ),
					array( 'fa-solid fa-angle' => 'angle' ),
					array( 'fa-solid fa-angles-down' => 'angles-down' ),
					array( 'fa-solid fa-angles-left' => 'angles-left' ),
					array( 'fa-solid fa-angles-right' => 'angles-right' ),
					array( 'fa-solid fa-angles-up-down' => 'angles-up-down' ),
					array( 'fa-solid fa-angles-up' => 'angles-up' ),
					array( 'fa-solid fa-ankh' => 'ankh' ),
					array( 'fa-solid fa-apartment' => 'apartment' ),
					array( 'fa-solid fa-aperture' => 'aperture' ),
					array( 'fa-solid fa-apostrophe' => 'apostrophe' ),
					array( 'fa-solid fa-apple-core' => 'apple-core' ),
					array( 'fa-solid fa-apple-whole' => 'apple-whole' ),
					array( 'fa-solid fa-archway' => 'archway' ),
					array( 'fa-solid fa-arrow-down-1-9' => 'arrow-down-1-9' ),
					array( 'fa-solid fa-arrow-down-9-1' => 'arrow-down-9-1' ),
					array( 'fa-solid fa-arrow-down-a-z' => 'arrow-down-a-z' ),
					array( 'fa-solid fa-arrow-down-arrow-up' => 'arrow-down-arrow-up' ),
					array( 'fa-solid fa-arrow-down-big-small' => 'arrow-down-big-small' ),
					array( 'fa-solid fa-arrow-down-from-arc' => 'arrow-down-from-arc' ),
					array( 'fa-solid fa-arrow-down-from-dotted-line' => 'arrow-down-from-dotted-line' ),
					array( 'fa-solid fa-arrow-down-from-line' => 'arrow-down-from-line' ),
					array( 'fa-solid fa-arrow-down-left-and-arrow-up-right-to-center' => 'arrow-down-left-and-arrow-up-right-to-center' ),
					array( 'fa-solid fa-arrow-down-left' => 'arrow-down-left' ),
					array( 'fa-solid fa-arrow-down-long' => 'arrow-down-long' ),
					array( 'fa-solid fa-arrow-down-right' => 'arrow-down-right' ),
					array( 'fa-solid fa-arrow-down-short-wide' => 'arrow-down-short-wide' ),
					array( 'fa-solid fa-arrow-down-small-big' => 'arrow-down-small-big' ),
					array( 'fa-solid fa-arrow-down-square-triangle' => 'arrow-down-square-triangle' ),
					array( 'fa-solid fa-arrow-down-to-arc' => 'arrow-down-to-arc' ),
					array( 'fa-solid fa-arrow-down-to-bracket' => 'arrow-down-to-bracket' ),
					array( 'fa-solid fa-arrow-down-to-dotted-line' => 'arrow-down-to-dotted-line' ),
					array( 'fa-solid fa-arrow-down-to-line' => 'arrow-down-to-line' ),
					array( 'fa-solid fa-arrow-down-to-square' => 'arrow-down-to-square' ),
					array( 'fa-solid fa-arrow-down-triangle-square' => 'arrow-down-triangle-square' ),
					array( 'fa-solid fa-arrow-down-up-across-line' => 'arrow-down-up-across-line' ),
					array( 'fa-solid fa-arrow-down-up-lock' => 'arrow-down-up-lock' ),
					array( 'fa-solid fa-arrow-down-wide-short' => 'arrow-down-wide-short' ),
					array( 'fa-solid fa-arrow-down-z-a' => 'arrow-down-z-a' ),
					array( 'fa-solid fa-arrow-down' => 'arrow-down' ),
					array( 'fa-solid fa-arrow-left-from-arc' => 'arrow-left-from-arc' ),
					array( 'fa-solid fa-arrow-left-from-line' => 'arrow-left-from-line' ),
					array( 'fa-solid fa-arrow-left-long-to-line' => 'arrow-left-long-to-line' ),
					array( 'fa-solid fa-arrow-left-long' => 'arrow-left-long' ),
					array( 'fa-solid fa-arrow-left-to-arc' => 'arrow-left-to-arc' ),
					array( 'fa-solid fa-arrow-left-to-line' => 'arrow-left-to-line' ),
					array( 'fa-solid fa-arrow-left' => 'arrow-left' ),
					array( 'fa-solid fa-arrow-pointer' => 'arrow-pointer' ),
					array( 'fa-solid fa-arrow-progress' => 'arrow-progress' ),
					array( 'fa-solid fa-arrow-right-arrow-left' => 'arrow-right-arrow-left' ),
					array( 'fa-solid fa-arrow-right-from-arc' => 'arrow-right-from-arc' ),
					array( 'fa-solid fa-arrow-right-from-bracket' => 'arrow-right-from-bracket' ),
					array( 'fa-solid fa-arrow-right-from-line' => 'arrow-right-from-line' ),
					array( 'fa-solid fa-arrow-right-long-to-line' => 'arrow-right-long-to-line' ),
					array( 'fa-solid fa-arrow-right-long' => 'arrow-right-long' ),
					array( 'fa-solid fa-arrow-right-to-arc' => 'arrow-right-to-arc' ),
					array( 'fa-solid fa-arrow-right-to-bracket' => 'arrow-right-to-bracket' ),
					array( 'fa-solid fa-arrow-right-to-city' => 'arrow-right-to-city' ),
					array( 'fa-solid fa-arrow-right-to-line' => 'arrow-right-to-line' ),
					array( 'fa-solid fa-arrow-right' => 'arrow-right' ),
					array( 'fa-solid fa-arrow-rotate-left' => 'arrow-rotate-left' ),
					array( 'fa-solid fa-arrow-rotate-right' => 'arrow-rotate-right' ),
					array( 'fa-solid fa-arrow-trend-down' => 'arrow-trend-down' ),
					array( 'fa-solid fa-arrow-trend-up' => 'arrow-trend-up' ),
					array( 'fa-solid fa-arrow-turn-down-left' => 'arrow-turn-down-left' ),
					array( 'fa-solid fa-arrow-turn-down-right' => 'arrow-turn-down-right' ),
					array( 'fa-solid fa-arrow-turn-down' => 'arrow-turn-down' ),
					array( 'fa-solid fa-arrow-turn-up' => 'arrow-turn-up' ),
					array( 'fa-solid fa-arrow-up-1-9' => 'arrow-up-1-9' ),
					array( 'fa-solid fa-arrow-up-9-1' => 'arrow-up-9-1' ),
					array( 'fa-solid fa-arrow-up-a-z' => 'arrow-up-a-z' ),
					array( 'fa-solid fa-arrow-up-arrow-down' => 'arrow-up-arrow-down' ),
					array( 'fa-solid fa-arrow-up-big-small' => 'arrow-up-big-small' ),
					array( 'fa-solid fa-arrow-up-from-arc' => 'arrow-up-from-arc' ),
					array( 'fa-solid fa-arrow-up-from-bracket' => 'arrow-up-from-bracket' ),
					array( 'fa-solid fa-arrow-up-from-dotted-line' => 'arrow-up-from-dotted-line' ),
					array( 'fa-solid fa-arrow-up-from-ground-water' => 'arrow-up-from-ground-water' ),
					array( 'fa-solid fa-arrow-up-from-line' => 'arrow-up-from-line' ),
					array( 'fa-solid fa-arrow-up-from-square' => 'arrow-up-from-square' ),
					array( 'fa-solid fa-arrow-up-from-water-pump' => 'arrow-up-from-water-pump' ),
					array( 'fa-solid fa-arrow-up-left-from-circle' => 'arrow-up-left-from-circle' ),
					array( 'fa-solid fa-arrow-up-left' => 'arrow-up-left' ),
					array( 'fa-solid fa-arrow-up-long' => 'arrow-up-long' ),
					array( 'fa-solid fa-arrow-up-right-and-arrow-down-left-from-center' => 'arrow-up-right-and-arrow-down-left-from-center' ),
					array( 'fa-solid fa-arrow-up-right-dots' => 'arrow-up-right-dots' ),
					array( 'fa-solid fa-arrow-up-right-from-square' => 'arrow-up-right-from-square' ),
					array( 'fa-solid fa-arrow-up-right' => 'arrow-up-right' ),
					array( 'fa-solid fa-arrow-up-short-wide' => 'arrow-up-short-wide' ),
					array( 'fa-solid fa-arrow-up-small-big' => 'arrow-up-small-big' ),
					array( 'fa-solid fa-arrow-up-square-triangle' => 'arrow-up-square-triangle' ),
					array( 'fa-solid fa-arrow-up-to-arc' => 'arrow-up-to-arc' ),
					array( 'fa-solid fa-arrow-up-to-dotted-line' => 'arrow-up-to-dotted-line' ),
					array( 'fa-solid fa-arrow-up-to-line' => 'arrow-up-to-line' ),
					array( 'fa-solid fa-arrow-up-triangle-square' => 'arrow-up-triangle-square' ),
					array( 'fa-solid fa-arrow-up-wide-short' => 'arrow-up-wide-short' ),
					array( 'fa-solid fa-arrow-up-z-a' => 'arrow-up-z-a' ),
					array( 'fa-solid fa-arrow-up' => 'arrow-up' ),
					array( 'fa-solid fa-arrows-cross' => 'arrows-cross' ),
					array( 'fa-solid fa-arrows-down-to-line' => 'arrows-down-to-line' ),
					array( 'fa-solid fa-arrows-down-to-people' => 'arrows-down-to-people' ),
					array( 'fa-solid fa-arrows-from-dotted-line' => 'arrows-from-dotted-line' ),
					array( 'fa-solid fa-arrows-from-line' => 'arrows-from-line' ),
					array( 'fa-solid fa-arrows-left-right-to-line' => 'arrows-left-right-to-line' ),
					array( 'fa-solid fa-arrows-left-right' => 'arrows-left-right' ),
					array( 'fa-solid fa-arrows-maximize' => 'arrows-maximize' ),
					array( 'fa-solid fa-arrows-minimize' => 'arrows-minimize' ),
					array( 'fa-solid fa-arrows-repeat-1' => 'arrows-repeat-1' ),
					array( 'fa-solid fa-arrows-repeat' => 'arrows-repeat' ),
					array( 'fa-solid fa-arrows-retweet' => 'arrows-retweet' ),
					array( 'fa-solid fa-arrows-rotate' => 'arrows-rotate' ),
					array( 'fa-solid fa-arrows-spin' => 'arrows-spin' ),
					array( 'fa-solid fa-arrows-split-up-and-left' => 'arrows-split-up-and-left' ),
					array( 'fa-solid fa-arrows-to-circle' => 'arrows-to-circle' ),
					array( 'fa-solid fa-arrows-to-dot' => 'arrows-to-dot' ),
					array( 'fa-solid fa-arrows-to-dotted-line' => 'arrows-to-dotted-line' ),
					array( 'fa-solid fa-arrows-to-eye' => 'arrows-to-eye' ),
					array( 'fa-solid fa-arrows-to-line' => 'arrows-to-line' ),
					array( 'fa-solid fa-arrows-turn-right' => 'arrows-turn-right' ),
					array( 'fa-solid fa-arrows-turn-to-dots' => 'arrows-turn-to-dots' ),
					array( 'fa-solid fa-arrows-up-down-left-right' => 'arrows-up-down-left-right' ),
					array( 'fa-solid fa-arrows-up-down' => 'arrows-up-down' ),
					array( 'fa-solid fa-arrows-up-to-line' => 'arrows-up-to-line' ),
					array( 'fa-solid fa-asterisk' => 'asterisk' ),
					array( 'fa-solid fa-at' => 'at' ),
					array( 'fa-solid fa-atom-simple' => 'atom-simple' ),
					array( 'fa-solid fa-atom' => 'atom' ),
					array( 'fa-solid fa-audio-description-slash' => 'audio-description-slash' ),
					array( 'fa-solid fa-audio-description' => 'audio-description' ),
					array( 'fa-solid fa-austral-sign' => 'austral-sign' ),
					array( 'fa-solid fa-avocado' => 'avocado' ),
					array( 'fa-solid fa-award-simple' => 'award-simple' ),
					array( 'fa-solid fa-award' => 'award' ),
					array( 'fa-solid fa-axe-battle' => 'axe-battle' ),
					array( 'fa-solid fa-axe' => 'axe' ),
					array( 'fa-solid fa-b' => 'b' ),
					array( 'fa-solid fa-baby-carriage' => 'baby-carriage' ),
					array( 'fa-solid fa-baby' => 'baby' ),
					array( 'fa-solid fa-backpack' => 'backpack' ),
					array( 'fa-solid fa-backward-fast' => 'backward-fast' ),
					array( 'fa-solid fa-backward-step' => 'backward-step' ),
					array( 'fa-solid fa-backward' => 'backward' ),
					array( 'fa-solid fa-bacon' => 'bacon' ),
					array( 'fa-solid fa-bacteria' => 'bacteria' ),
					array( 'fa-solid fa-bacterium' => 'bacterium' ),
					array( 'fa-solid fa-badge-check' => 'badge-check' ),
					array( 'fa-solid fa-badge-dollar' => 'badge-dollar' ),
					array( 'fa-solid fa-badge-percent' => 'badge-percent' ),
					array( 'fa-solid fa-badge-sheriff' => 'badge-sheriff' ),
					array( 'fa-solid fa-badge' => 'badge' ),
					array( 'fa-solid fa-badger-honey' => 'badger-honey' ),
					array( 'fa-solid fa-badminton' => 'badminton' ),
					array( 'fa-solid fa-bag-seedling' => 'bag-seedling' ),
					array( 'fa-solid fa-bag-shopping' => 'bag-shopping' ),
					array( 'fa-solid fa-bagel' => 'bagel' ),
					array( 'fa-solid fa-bags-shopping' => 'bags-shopping' ),
					array( 'fa-solid fa-baguette' => 'baguette' ),
					array( 'fa-solid fa-bahai' => 'bahai' ),
					array( 'fa-solid fa-baht-sign' => 'baht-sign' ),
					array( 'fa-solid fa-ball-pile' => 'ball-pile' ),
					array( 'fa-solid fa-balloon' => 'balloon' ),
					array( 'fa-solid fa-balloons' => 'balloons' ),
					array( 'fa-solid fa-ballot-check' => 'ballot-check' ),
					array( 'fa-solid fa-ballot' => 'ballot' ),
					array( 'fa-solid fa-ban-bug' => 'ban-bug' ),
					array( 'fa-solid fa-ban-parking' => 'ban-parking' ),
					array( 'fa-solid fa-ban-smoking' => 'ban-smoking' ),
					array( 'fa-solid fa-ban' => 'ban' ),
					array( 'fa-solid fa-banana' => 'banana' ),
					array( 'fa-solid fa-bandage' => 'bandage' ),
					array( 'fa-solid fa-bangladeshi-taka-sign' => 'bangladeshi-taka-sign' ),
					array( 'fa-solid fa-banjo' => 'banjo' ),
					array( 'fa-solid fa-barcode-read' => 'barcode-read' ),
					array( 'fa-solid fa-barcode-scan' => 'barcode-scan' ),
					array( 'fa-solid fa-barcode' => 'barcode' ),
					array( 'fa-solid fa-bars-filter' => 'bars-filter' ),
					array( 'fa-solid fa-bars-progress' => 'bars-progress' ),
					array( 'fa-solid fa-bars-sort' => 'bars-sort' ),
					array( 'fa-solid fa-bars-staggered' => 'bars-staggered' ),
					array( 'fa-solid fa-bars' => 'bars' ),
					array( 'fa-solid fa-baseball-bat-ball' => 'baseball-bat-ball' ),
					array( 'fa-solid fa-baseball' => 'baseball' ),
					array( 'fa-solid fa-basket-shopping-simple' => 'basket-shopping-simple' ),
					array( 'fa-solid fa-basket-shopping' => 'basket-shopping' ),
					array( 'fa-solid fa-basketball-hoop' => 'basketball-hoop' ),
					array( 'fa-solid fa-basketball' => 'basketball' ),
					array( 'fa-solid fa-bat' => 'bat' ),
					array( 'fa-solid fa-bath' => 'bath' ),
					array( 'fa-solid fa-battery-bolt' => 'battery-bolt' ),
					array( 'fa-solid fa-battery-empty' => 'battery-empty' ),
					array( 'fa-solid fa-battery-exclamation' => 'battery-exclamation' ),
					array( 'fa-solid fa-battery-full' => 'battery-full' ),
					array( 'fa-solid fa-battery-half' => 'battery-half' ),
					array( 'fa-solid fa-battery-low' => 'battery-low' ),
					array( 'fa-solid fa-battery-quarter' => 'battery-quarter' ),
					array( 'fa-solid fa-battery-slash' => 'battery-slash' ),
					array( 'fa-solid fa-battery-three-quarters' => 'battery-three-quarters' ),
					array( 'fa-solid fa-bed-bunk' => 'bed-bunk' ),
					array( 'fa-solid fa-bed-empty' => 'bed-empty' ),
					array( 'fa-solid fa-bed-front' => 'bed-front' ),
					array( 'fa-solid fa-bed-pulse' => 'bed-pulse' ),
					array( 'fa-solid fa-bed' => 'bed' ),
					array( 'fa-solid fa-bee' => 'bee' ),
					array( 'fa-solid fa-beer-mug-empty' => 'beer-mug-empty' ),
					array( 'fa-solid fa-beer-mug' => 'beer-mug' ),
					array( 'fa-solid fa-bell-concierge' => 'bell-concierge' ),
					array( 'fa-solid fa-bell-exclamation' => 'bell-exclamation' ),
					array( 'fa-solid fa-bell-on' => 'bell-on' ),
					array( 'fa-solid fa-bell-plus' => 'bell-plus' ),
					array( 'fa-solid fa-bell-school-slash' => 'bell-school-slash' ),
					array( 'fa-solid fa-bell-school' => 'bell-school' ),
					array( 'fa-solid fa-bell-slash' => 'bell-slash' ),
					array( 'fa-solid fa-bell' => 'bell' ),
					array( 'fa-solid fa-bells' => 'bells' ),
					array( 'fa-solid fa-bench-tree' => 'bench-tree' ),
					array( 'fa-solid fa-bezier-curve' => 'bezier-curve' ),
					array( 'fa-solid fa-bicycle' => 'bicycle' ),
					array( 'fa-solid fa-billboard' => 'billboard' ),
					array( 'fa-solid fa-bin-bottles-recycle' => 'bin-bottles-recycle' ),
					array( 'fa-solid fa-bin-bottles' => 'bin-bottles' ),
					array( 'fa-solid fa-bin-recycle' => 'bin-recycle' ),
					array( 'fa-solid fa-binary-circle-check' => 'binary-circle-check' ),
					array( 'fa-solid fa-binary-lock' => 'binary-lock' ),
					array( 'fa-solid fa-binary-slash' => 'binary-slash' ),
					array( 'fa-solid fa-binary' => 'binary' ),
					array( 'fa-solid fa-binoculars' => 'binoculars' ),
					array( 'fa-solid fa-biohazard' => 'biohazard' ),
					array( 'fa-solid fa-bird' => 'bird' ),
					array( 'fa-solid fa-bitcoin-sign' => 'bitcoin-sign' ),
					array( 'fa-solid fa-blanket-fire' => 'blanket-fire' ),
					array( 'fa-solid fa-blanket' => 'blanket' ),
					array( 'fa-solid fa-blender-phone' => 'blender-phone' ),
					array( 'fa-solid fa-blender' => 'blender' ),
					array( 'fa-solid fa-blinds-open' => 'blinds-open' ),
					array( 'fa-solid fa-blinds-raised' => 'blinds-raised' ),
					array( 'fa-solid fa-blinds' => 'blinds' ),
					array( 'fa-solid fa-block-brick-fire' => 'block-brick-fire' ),
					array( 'fa-solid fa-block-brick' => 'block-brick' ),
					array( 'fa-solid fa-block-question' => 'block-question' ),
					array( 'fa-solid fa-block-quote' => 'block-quote' ),
					array( 'fa-solid fa-block' => 'block' ),
					array( 'fa-solid fa-blog' => 'blog' ),
					array( 'fa-solid fa-blueberries' => 'blueberries' ),
					array( 'fa-solid fa-bluetooth' => 'bluetooth' ),
					array( 'fa-solid fa-bold' => 'bold' ),
					array( 'fa-solid fa-bolt-auto' => 'bolt-auto' ),
					array( 'fa-solid fa-bolt-lightning' => 'bolt-lightning' ),
					array( 'fa-solid fa-bolt-slash' => 'bolt-slash' ),
					array( 'fa-solid fa-bolt' => 'bolt' ),
					array( 'fa-solid fa-bomb' => 'bomb' ),
					array( 'fa-solid fa-bone-break' => 'bone-break' ),
					array( 'fa-solid fa-bone' => 'bone' ),
					array( 'fa-solid fa-bong' => 'bong' ),
					array( 'fa-solid fa-book-arrow-right' => 'book-arrow-right' ),
					array( 'fa-solid fa-book-arrow-up' => 'book-arrow-up' ),
					array( 'fa-solid fa-book-atlas' => 'book-atlas' ),
					array( 'fa-solid fa-book-bible' => 'book-bible' ),
					array( 'fa-solid fa-book-blank' => 'book-blank' ),
					array( 'fa-solid fa-book-bookmark' => 'book-bookmark' ),
					array( 'fa-solid fa-book-circle-arrow-right' => 'book-circle-arrow-right' ),
					array( 'fa-solid fa-book-circle-arrow-up' => 'book-circle-arrow-up' ),
					array( 'fa-solid fa-book-copy' => 'book-copy' ),
					array( 'fa-solid fa-book-font' => 'book-font' ),
					array( 'fa-solid fa-book-heart' => 'book-heart' ),
					array( 'fa-solid fa-book-journal-whills' => 'book-journal-whills' ),
					array( 'fa-solid fa-book-medical' => 'book-medical' ),
					array( 'fa-solid fa-book-open-cover' => 'book-open-cover' ),
					array( 'fa-solid fa-book-open-reader' => 'book-open-reader' ),
					array( 'fa-solid fa-book-open' => 'book-open' ),
					array( 'fa-solid fa-book-quran' => 'book-quran' ),
					array( 'fa-solid fa-book-section' => 'book-section' ),
					array( 'fa-solid fa-book-skull' => 'book-skull' ),
					array( 'fa-solid fa-book-sparkles' => 'book-sparkles' ),
					array( 'fa-solid fa-book-tanakh' => 'book-tanakh' ),
					array( 'fa-solid fa-book-user' => 'book-user' ),
					array( 'fa-solid fa-book' => 'book' ),
					array( 'fa-solid fa-bookmark-slash' => 'bookmark-slash' ),
					array( 'fa-solid fa-bookmark' => 'bookmark' ),
					array( 'fa-solid fa-books-medical' => 'books-medical' ),
					array( 'fa-solid fa-books' => 'books' ),
					array( 'fa-solid fa-boombox' => 'boombox' ),
					array( 'fa-solid fa-boot-heeled' => 'boot-heeled' ),
					array( 'fa-solid fa-boot' => 'boot' ),
					array( 'fa-solid fa-booth-curtain' => 'booth-curtain' ),
					array( 'fa-solid fa-border-all' => 'border-all' ),
					array( 'fa-solid fa-border-bottom-right' => 'border-bottom-right' ),
					array( 'fa-solid fa-border-bottom' => 'border-bottom' ),
					array( 'fa-solid fa-border-center-h' => 'border-center-h' ),
					array( 'fa-solid fa-border-center-v' => 'border-center-v' ),
					array( 'fa-solid fa-border-inner' => 'border-inner' ),
					array( 'fa-solid fa-border-left' => 'border-left' ),
					array( 'fa-solid fa-border-none' => 'border-none' ),
					array( 'fa-solid fa-border-outer' => 'border-outer' ),
					array( 'fa-solid fa-border-right' => 'border-right' ),
					array( 'fa-solid fa-border-top-left' => 'border-top-left' ),
					array( 'fa-solid fa-border-top' => 'border-top' ),
					array( 'fa-solid fa-bore-hole' => 'bore-hole' ),
					array( 'fa-solid fa-bottle-droplet' => 'bottle-droplet' ),
					array( 'fa-solid fa-bottle-water' => 'bottle-water' ),
					array( 'fa-solid fa-bow-arrow' => 'bow-arrow' ),
					array( 'fa-solid fa-bowl-chopsticks-noodles' => 'bowl-chopsticks-noodles' ),
					array( 'fa-solid fa-bowl-chopsticks' => 'bowl-chopsticks' ),
					array( 'fa-solid fa-bowl-food' => 'bowl-food' ),
					array( 'fa-solid fa-bowl-hot' => 'bowl-hot' ),
					array( 'fa-solid fa-bowl-rice' => 'bowl-rice' ),
					array( 'fa-solid fa-bowl-scoop' => 'bowl-scoop' ),
					array( 'fa-solid fa-bowl-scoops' => 'bowl-scoops' ),
					array( 'fa-solid fa-bowl-soft-serve' => 'bowl-soft-serve' ),
					array( 'fa-solid fa-bowl-spoon' => 'bowl-spoon' ),
					array( 'fa-solid fa-bowling-ball-pin' => 'bowling-ball-pin' ),
					array( 'fa-solid fa-bowling-ball' => 'bowling-ball' ),
					array( 'fa-solid fa-bowling-pins' => 'bowling-pins' ),
					array( 'fa-solid fa-box-archive' => 'box-archive' ),
					array( 'fa-solid fa-box-ballot' => 'box-ballot' ),
					array( 'fa-solid fa-box-check' => 'box-check' ),
					array( 'fa-solid fa-box-circle-check' => 'box-circle-check' ),
					array( 'fa-solid fa-box-dollar' => 'box-dollar' ),
					array( 'fa-solid fa-box-heart' => 'box-heart' ),
					array( 'fa-solid fa-box-open-full' => 'box-open-full' ),
					array( 'fa-solid fa-box-open' => 'box-open' ),
					array( 'fa-solid fa-box-taped' => 'box-taped' ),
					array( 'fa-solid fa-box-tissue' => 'box-tissue' ),
					array( 'fa-solid fa-box' => 'box' ),
					array( 'fa-solid fa-boxes-packing' => 'boxes-packing' ),
					array( 'fa-solid fa-boxes-stacked' => 'boxes-stacked' ),
					array( 'fa-solid fa-boxing-glove' => 'boxing-glove' ),
					array( 'fa-solid fa-bracket-curly-right' => 'bracket-curly-right' ),
					array( 'fa-solid fa-bracket-curly' => 'bracket-curly' ),
					array( 'fa-solid fa-bracket-round-right' => 'bracket-round-right' ),
					array( 'fa-solid fa-bracket-round' => 'bracket-round' ),
					array( 'fa-solid fa-bracket-square-right' => 'bracket-square-right' ),
					array( 'fa-solid fa-bracket-square' => 'bracket-square' ),
					array( 'fa-solid fa-brackets-curly' => 'brackets-curly' ),
					array( 'fa-solid fa-brackets-round' => 'brackets-round' ),
					array( 'fa-solid fa-brackets-square' => 'brackets-square' ),
					array( 'fa-solid fa-braille' => 'braille' ),
					array( 'fa-solid fa-brain-arrow-curved-right' => 'brain-arrow-curved-right' ),
					array( 'fa-solid fa-brain-circuit' => 'brain-circuit' ),
					array( 'fa-solid fa-brain' => 'brain' ),
					array( 'fa-solid fa-brake-warning' => 'brake-warning' ),
					array( 'fa-solid fa-brazilian-real-sign' => 'brazilian-real-sign' ),
					array( 'fa-solid fa-bread-loaf' => 'bread-loaf' ),
					array( 'fa-solid fa-bread-slice-butter' => 'bread-slice-butter' ),
					array( 'fa-solid fa-bread-slice' => 'bread-slice' ),
					array( 'fa-solid fa-bridge-circle-check' => 'bridge-circle-check' ),
					array( 'fa-solid fa-bridge-circle-exclamation' => 'bridge-circle-exclamation' ),
					array( 'fa-solid fa-bridge-circle-xmark' => 'bridge-circle-xmark' ),
					array( 'fa-solid fa-bridge-lock' => 'bridge-lock' ),
					array( 'fa-solid fa-bridge-suspension' => 'bridge-suspension' ),
					array( 'fa-solid fa-bridge-water' => 'bridge-water' ),
					array( 'fa-solid fa-bridge' => 'bridge' ),
					array( 'fa-solid fa-briefcase-arrow-right' => 'briefcase-arrow-right' ),
					array( 'fa-solid fa-briefcase-blank' => 'briefcase-blank' ),
					array( 'fa-solid fa-briefcase-medical' => 'briefcase-medical' ),
					array( 'fa-solid fa-briefcase' => 'briefcase' ),
					array( 'fa-solid fa-brightness-low' => 'brightness-low' ),
					array( 'fa-solid fa-brightness' => 'brightness' ),
					array( 'fa-solid fa-bring-forward' => 'bring-forward' ),
					array( 'fa-solid fa-bring-front' => 'bring-front' ),
					array( 'fa-solid fa-broccoli' => 'broccoli' ),
					array( 'fa-solid fa-broom-ball' => 'broom-ball' ),
					array( 'fa-solid fa-broom-wide' => 'broom-wide' ),
					array( 'fa-solid fa-broom' => 'broom' ),
					array( 'fa-solid fa-browser' => 'browser' ),
					array( 'fa-solid fa-browsers' => 'browsers' ),
					array( 'fa-solid fa-brush' => 'brush' ),
					array( 'fa-solid fa-bucket' => 'bucket' ),
					array( 'fa-solid fa-bug-slash' => 'bug-slash' ),
					array( 'fa-solid fa-bug' => 'bug' ),
					array( 'fa-solid fa-bugs' => 'bugs' ),
					array( 'fa-solid fa-building-circle-arrow-right' => 'building-circle-arrow-right' ),
					array( 'fa-solid fa-building-circle-check' => 'building-circle-check' ),
					array( 'fa-solid fa-building-circle-exclamation' => 'building-circle-exclamation' ),
					array( 'fa-solid fa-building-circle-xmark' => 'building-circle-xmark' ),
					array( 'fa-solid fa-building-columns' => 'building-columns' ),
					array( 'fa-solid fa-building-flag' => 'building-flag' ),
					array( 'fa-solid fa-building-lock' => 'building-lock' ),
					array( 'fa-solid fa-building-ngo' => 'building-ngo' ),
					array( 'fa-solid fa-building-shield' => 'building-shield' ),
					array( 'fa-solid fa-building-un' => 'building-un' ),
					array( 'fa-solid fa-building-user' => 'building-user' ),
					array( 'fa-solid fa-building-wheat' => 'building-wheat' ),
					array( 'fa-solid fa-building' => 'building' ),
					array( 'fa-solid fa-buildings' => 'buildings' ),
					array( 'fa-solid fa-bullhorn' => 'bullhorn' ),
					array( 'fa-solid fa-bullseye-arrow' => 'bullseye-arrow' ),
					array( 'fa-solid fa-bullseye-pointer' => 'bullseye-pointer' ),
					array( 'fa-solid fa-bullseye' => 'bullseye' ),
					array( 'fa-solid fa-buoy-mooring' => 'buoy-mooring' ),
					array( 'fa-solid fa-buoy' => 'buoy' ),
					array( 'fa-solid fa-burger-cheese' => 'burger-cheese' ),
					array( 'fa-solid fa-burger-fries' => 'burger-fries' ),
					array( 'fa-solid fa-burger-glass' => 'burger-glass' ),
					array( 'fa-solid fa-burger-lettuce' => 'burger-lettuce' ),
					array( 'fa-solid fa-burger-soda' => 'burger-soda' ),
					array( 'fa-solid fa-burger' => 'burger' ),
					array( 'fa-solid fa-burrito' => 'burrito' ),
					array( 'fa-solid fa-burst' => 'burst' ),
					array( 'fa-solid fa-bus-school' => 'bus-school' ),
					array( 'fa-solid fa-bus-simple' => 'bus-simple' ),
					array( 'fa-solid fa-bus' => 'bus' ),
					array( 'fa-solid fa-business-time' => 'business-time' ),
					array( 'fa-solid fa-butter' => 'butter' ),
					array( 'fa-solid fa-c' => 'c' ),
					array( 'fa-solid fa-cabin' => 'cabin' ),
					array( 'fa-solid fa-cabinet-filing' => 'cabinet-filing' ),
					array( 'fa-solid fa-cable-car' => 'cable-car' ),
					array( 'fa-solid fa-cactus' => 'cactus' ),
					array( 'fa-solid fa-cake-candles' => 'cake-candles' ),
					array( 'fa-solid fa-cake-slice' => 'cake-slice' ),
					array( 'fa-solid fa-calculator-simple' => 'calculator-simple' ),
					array( 'fa-solid fa-calculator' => 'calculator' ),
					array( 'fa-solid fa-calendar-arrow-down' => 'calendar-arrow-down' ),
					array( 'fa-solid fa-calendar-arrow-up' => 'calendar-arrow-up' ),
					array( 'fa-solid fa-calendar-check' => 'calendar-check' ),
					array( 'fa-solid fa-calendar-circle-exclamation' => 'calendar-circle-exclamation' ),
					array( 'fa-solid fa-calendar-circle-minus' => 'calendar-circle-minus' ),
					array( 'fa-solid fa-calendar-circle-plus' => 'calendar-circle-plus' ),
					array( 'fa-solid fa-calendar-circle-user' => 'calendar-circle-user' ),
					array( 'fa-solid fa-calendar-clock' => 'calendar-clock' ),
					array( 'fa-solid fa-calendar-day' => 'calendar-day' ),
					array( 'fa-solid fa-calendar-days' => 'calendar-days' ),
					array( 'fa-solid fa-calendar-exclamation' => 'calendar-exclamation' ),
					array( 'fa-solid fa-calendar-heart' => 'calendar-heart' ),
					array( 'fa-solid fa-calendar-image' => 'calendar-image' ),
					array( 'fa-solid fa-calendar-lines-pen' => 'calendar-lines-pen' ),
					array( 'fa-solid fa-calendar-lines' => 'calendar-lines' ),
					array( 'fa-solid fa-calendar-minus' => 'calendar-minus' ),
					array( 'fa-solid fa-calendar-pen' => 'calendar-pen' ),
					array( 'fa-solid fa-calendar-plus' => 'calendar-plus' ),
					array( 'fa-solid fa-calendar-range' => 'calendar-range' ),
					array( 'fa-solid fa-calendar-star' => 'calendar-star' ),
					array( 'fa-solid fa-calendar-users' => 'calendar-users' ),
					array( 'fa-solid fa-calendar-week' => 'calendar-week' ),
					array( 'fa-solid fa-calendar-xmark' => 'calendar-xmark' ),
					array( 'fa-solid fa-calendar' => 'calendar' ),
					array( 'fa-solid fa-calendars' => 'calendars' ),
					array( 'fa-solid fa-camcorder' => 'camcorder' ),
					array( 'fa-solid fa-camera-cctv' => 'camera-cctv' ),
					array( 'fa-solid fa-camera-movie' => 'camera-movie' ),
					array( 'fa-solid fa-camera-polaroid' => 'camera-polaroid' ),
					array( 'fa-solid fa-camera-retro' => 'camera-retro' ),
					array( 'fa-solid fa-camera-rotate' => 'camera-rotate' ),
					array( 'fa-solid fa-camera-security' => 'camera-security' ),
					array( 'fa-solid fa-camera-slash' => 'camera-slash' ),
					array( 'fa-solid fa-camera-viewfinder' => 'camera-viewfinder' ),
					array( 'fa-solid fa-camera-web-slash' => 'camera-web-slash' ),
					array( 'fa-solid fa-camera-web' => 'camera-web' ),
					array( 'fa-solid fa-camera' => 'camera' ),
					array( 'fa-solid fa-campfire' => 'campfire' ),
					array( 'fa-solid fa-campground' => 'campground' ),
					array( 'fa-solid fa-can-food' => 'can-food' ),
					array( 'fa-solid fa-candle-holder' => 'candle-holder' ),
					array( 'fa-solid fa-candy-bar' => 'candy-bar' ),
					array( 'fa-solid fa-candy-cane' => 'candy-cane' ),
					array( 'fa-solid fa-candy-corn' => 'candy-corn' ),
					array( 'fa-solid fa-candy' => 'candy' ),
					array( 'fa-solid fa-cannabis' => 'cannabis' ),
					array( 'fa-solid fa-capsules' => 'capsules' ),
					array( 'fa-solid fa-car-battery' => 'car-battery' ),
					array( 'fa-solid fa-car-bolt' => 'car-bolt' ),
					array( 'fa-solid fa-car-building' => 'car-building' ),
					array( 'fa-solid fa-car-bump' => 'car-bump' ),
					array( 'fa-solid fa-car-burst' => 'car-burst' ),
					array( 'fa-solid fa-car-bus' => 'car-bus' ),
					array( 'fa-solid fa-car-circle-bolt' => 'car-circle-bolt' ),
					array( 'fa-solid fa-car-garage' => 'car-garage' ),
					array( 'fa-solid fa-car-mirrors' => 'car-mirrors' ),
					array( 'fa-solid fa-car-on' => 'car-on' ),
					array( 'fa-solid fa-car-rear' => 'car-rear' ),
					array( 'fa-solid fa-car-side-bolt' => 'car-side-bolt' ),
					array( 'fa-solid fa-car-side' => 'car-side' ),
					array( 'fa-solid fa-car-tilt' => 'car-tilt' ),
					array( 'fa-solid fa-car-tunnel' => 'car-tunnel' ),
					array( 'fa-solid fa-car-wash' => 'car-wash' ),
					array( 'fa-solid fa-car-wrench' => 'car-wrench' ),
					array( 'fa-solid fa-car' => 'car' ),
					array( 'fa-solid fa-caravan-simple' => 'caravan-simple' ),
					array( 'fa-solid fa-caravan' => 'caravan' ),
					array( 'fa-solid fa-card-club' => 'card-club' ),
					array( 'fa-solid fa-card-diamond' => 'card-diamond' ),
					array( 'fa-solid fa-card-heart' => 'card-heart' ),
					array( 'fa-solid fa-card-spade' => 'card-spade' ),
					array( 'fa-solid fa-cards-blank' => 'cards-blank' ),
					array( 'fa-solid fa-cards' => 'cards' ),
					array( 'fa-solid fa-caret-down' => 'caret-down' ),
					array( 'fa-solid fa-caret-left' => 'caret-left' ),
					array( 'fa-solid fa-caret-right' => 'caret-right' ),
					array( 'fa-solid fa-caret-up' => 'caret-up' ),
					array( 'fa-solid fa-carrot' => 'carrot' ),
					array( 'fa-solid fa-cars' => 'cars' ),
					array( 'fa-solid fa-cart-arrow-down' => 'cart-arrow-down' ),
					array( 'fa-solid fa-cart-arrow-up' => 'cart-arrow-up' ),
					array( 'fa-solid fa-cart-circle-arrow-down' => 'cart-circle-arrow-down' ),
					array( 'fa-solid fa-cart-circle-arrow-up' => 'cart-circle-arrow-up' ),
					array( 'fa-solid fa-cart-circle-check' => 'cart-circle-check' ),
					array( 'fa-solid fa-cart-circle-exclamation' => 'cart-circle-exclamation' ),
					array( 'fa-solid fa-cart-circle-plus' => 'cart-circle-plus' ),
					array( 'fa-solid fa-cart-circle-xmark' => 'cart-circle-xmark' ),
					array( 'fa-solid fa-cart-flatbed-boxes' => 'cart-flatbed-boxes' ),
					array( 'fa-solid fa-cart-flatbed-empty' => 'cart-flatbed-empty' ),
					array( 'fa-solid fa-cart-flatbed-suitcase' => 'cart-flatbed-suitcase' ),
					array( 'fa-solid fa-cart-flatbed' => 'cart-flatbed' ),
					array( 'fa-solid fa-cart-minus' => 'cart-minus' ),
					array( 'fa-solid fa-cart-plus' => 'cart-plus' ),
					array( 'fa-solid fa-cart-shopping-fast' => 'cart-shopping-fast' ),
					array( 'fa-solid fa-cart-shopping' => 'cart-shopping' ),
					array( 'fa-solid fa-cart-xmark' => 'cart-xmark' ),
					array( 'fa-solid fa-cash-register' => 'cash-register' ),
					array( 'fa-solid fa-cassette-betamax' => 'cassette-betamax' ),
					array( 'fa-solid fa-cassette-tape' => 'cassette-tape' ),
					array( 'fa-solid fa-cassette-vhs' => 'cassette-vhs' ),
					array( 'fa-solid fa-castle' => 'castle' ),
					array( 'fa-solid fa-cat-space' => 'cat-space' ),
					array( 'fa-solid fa-cat' => 'cat' ),
					array( 'fa-solid fa-cauldron' => 'cauldron' ),
					array( 'fa-solid fa-cedi-sign' => 'cedi-sign' ),
					array( 'fa-solid fa-cent-sign' => 'cent-sign' ),
					array( 'fa-solid fa-certificate' => 'certificate' ),
					array( 'fa-solid fa-chair-office' => 'chair-office' ),
					array( 'fa-solid fa-chair' => 'chair' ),
					array( 'fa-solid fa-chalkboard-user' => 'chalkboard-user' ),
					array( 'fa-solid fa-chalkboard' => 'chalkboard' ),
					array( 'fa-solid fa-champagne-glass' => 'champagne-glass' ),
					array( 'fa-solid fa-champagne-glasses' => 'champagne-glasses' ),
					array( 'fa-solid fa-charging-station' => 'charging-station' ),
					array( 'fa-solid fa-chart-area' => 'chart-area' ),
					array( 'fa-solid fa-chart-bar' => 'chart-bar' ),
					array( 'fa-solid fa-chart-bullet' => 'chart-bullet' ),
					array( 'fa-solid fa-chart-candlestick' => 'chart-candlestick' ),
					array( 'fa-solid fa-chart-column' => 'chart-column' ),
					array( 'fa-solid fa-chart-gantt' => 'chart-gantt' ),
					array( 'fa-solid fa-chart-line-down' => 'chart-line-down' ),
					array( 'fa-solid fa-chart-line-up-down' => 'chart-line-up-down' ),
					array( 'fa-solid fa-chart-line-up' => 'chart-line-up' ),
					array( 'fa-solid fa-chart-line' => 'chart-line' ),
					array( 'fa-solid fa-chart-mixed-up-circle-currency' => 'chart-mixed-up-circle-currency' ),
					array( 'fa-solid fa-chart-mixed-up-circle-dollar' => 'chart-mixed-up-circle-dollar' ),
					array( 'fa-solid fa-chart-mixed' => 'chart-mixed' ),
					array( 'fa-solid fa-chart-network' => 'chart-network' ),
					array( 'fa-solid fa-chart-pie-simple-circle-currency' => 'chart-pie-simple-circle-currency' ),
					array( 'fa-solid fa-chart-pie-simple-circle-dollar' => 'chart-pie-simple-circle-dollar' ),
					array( 'fa-solid fa-chart-pie-simple' => 'chart-pie-simple' ),
					array( 'fa-solid fa-chart-pie' => 'chart-pie' ),
					array( 'fa-solid fa-chart-pyramid' => 'chart-pyramid' ),
					array( 'fa-solid fa-chart-radar' => 'chart-radar' ),
					array( 'fa-solid fa-chart-scatter-3d' => 'chart-scatter-3d' ),
					array( 'fa-solid fa-chart-scatter-bubble' => 'chart-scatter-bubble' ),
					array( 'fa-solid fa-chart-scatter' => 'chart-scatter' ),
					array( 'fa-solid fa-chart-simple-horizontal' => 'chart-simple-horizontal' ),
					array( 'fa-solid fa-chart-simple' => 'chart-simple' ),
					array( 'fa-solid fa-chart-tree-map' => 'chart-tree-map' ),
					array( 'fa-solid fa-chart-user' => 'chart-user' ),
					array( 'fa-solid fa-chart-waterfall' => 'chart-waterfall' ),
					array( 'fa-solid fa-check-double' => 'check-double' ),
					array( 'fa-solid fa-check-to-slot' => 'check-to-slot' ),
					array( 'fa-solid fa-check' => 'check' ),
					array( 'fa-solid fa-cheese-swiss' => 'cheese-swiss' ),
					array( 'fa-solid fa-cheese' => 'cheese' ),
					array( 'fa-solid fa-cherries' => 'cherries' ),
					array( 'fa-solid fa-chess-bishop-piece' => 'chess-bishop-piece' ),
					array( 'fa-solid fa-chess-bishop' => 'chess-bishop' ),
					array( 'fa-solid fa-chess-board' => 'chess-board' ),
					array( 'fa-solid fa-chess-clock-flip' => 'chess-clock-flip' ),
					array( 'fa-solid fa-chess-clock' => 'chess-clock' ),
					array( 'fa-solid fa-chess-king-piece' => 'chess-king-piece' ),
					array( 'fa-solid fa-chess-king' => 'chess-king' ),
					array( 'fa-solid fa-chess-knight-piece' => 'chess-knight-piece' ),
					array( 'fa-solid fa-chess-knight' => 'chess-knight' ),
					array( 'fa-solid fa-chess-pawn-piece' => 'chess-pawn-piece' ),
					array( 'fa-solid fa-chess-pawn' => 'chess-pawn' ),
					array( 'fa-solid fa-chess-queen-piece' => 'chess-queen-piece' ),
					array( 'fa-solid fa-chess-queen' => 'chess-queen' ),
					array( 'fa-solid fa-chess-rook-piece' => 'chess-rook-piece' ),
					array( 'fa-solid fa-chess-rook' => 'chess-rook' ),
					array( 'fa-solid fa-chess' => 'chess' ),
					array( 'fa-solid fa-chestnut' => 'chestnut' ),
					array( 'fa-solid fa-chevron-down' => 'chevron-down' ),
					array( 'fa-solid fa-chevron-left' => 'chevron-left' ),
					array( 'fa-solid fa-chevron-right' => 'chevron-right' ),
					array( 'fa-solid fa-chevron-up' => 'chevron-up' ),
					array( 'fa-solid fa-chevrons-down' => 'chevrons-down' ),
					array( 'fa-solid fa-chevrons-left' => 'chevrons-left' ),
					array( 'fa-solid fa-chevrons-right' => 'chevrons-right' ),
					array( 'fa-solid fa-chevrons-up' => 'chevrons-up' ),
					array( 'fa-solid fa-chf-sign' => 'chf-sign' ),
					array( 'fa-solid fa-child-combatant' => 'child-combatant' ),
					array( 'fa-solid fa-child-dress' => 'child-dress' ),
					array( 'fa-solid fa-child-reaching' => 'child-reaching' ),
					array( 'fa-solid fa-child' => 'child' ),
					array( 'fa-solid fa-children' => 'children' ),
					array( 'fa-solid fa-chimney' => 'chimney' ),
					array( 'fa-solid fa-chopsticks' => 'chopsticks' ),
					array( 'fa-solid fa-church' => 'church' ),
					array( 'fa-solid fa-circle-0' => 'circle-0' ),
					array( 'fa-solid fa-circle-1' => 'circle-1' ),
					array( 'fa-solid fa-circle-2' => 'circle-2' ),
					array( 'fa-solid fa-circle-3' => 'circle-3' ),
					array( 'fa-solid fa-circle-4' => 'circle-4' ),
					array( 'fa-solid fa-circle-5' => 'circle-5' ),
					array( 'fa-solid fa-circle-6' => 'circle-6' ),
					array( 'fa-solid fa-circle-7' => 'circle-7' ),
					array( 'fa-solid fa-circle-8' => 'circle-8' ),
					array( 'fa-solid fa-circle-9' => 'circle-9' ),
					array( 'fa-solid fa-circle-a' => 'circle-a' ),
					array( 'fa-solid fa-circle-ampersand' => 'circle-ampersand' ),
					array( 'fa-solid fa-circle-arrow-down-left' => 'circle-arrow-down-left' ),
					array( 'fa-solid fa-circle-arrow-down-right' => 'circle-arrow-down-right' ),
					array( 'fa-solid fa-circle-arrow-down' => 'circle-arrow-down' ),
					array( 'fa-solid fa-circle-arrow-left' => 'circle-arrow-left' ),
					array( 'fa-solid fa-circle-arrow-right' => 'circle-arrow-right' ),
					array( 'fa-solid fa-circle-arrow-up-left' => 'circle-arrow-up-left' ),
					array( 'fa-solid fa-circle-arrow-up-right' => 'circle-arrow-up-right' ),
					array( 'fa-solid fa-circle-arrow-up' => 'circle-arrow-up' ),
					array( 'fa-solid fa-circle-b' => 'circle-b' ),
					array( 'fa-solid fa-circle-bolt' => 'circle-bolt' ),
					array( 'fa-solid fa-circle-book-open' => 'circle-book-open' ),
					array( 'fa-solid fa-circle-bookmark' => 'circle-bookmark' ),
					array( 'fa-solid fa-circle-c' => 'circle-c' ),
					array( 'fa-solid fa-circle-calendar' => 'circle-calendar' ),
					array( 'fa-solid fa-circle-camera' => 'circle-camera' ),
					array( 'fa-solid fa-circle-caret-down' => 'circle-caret-down' ),
					array( 'fa-solid fa-circle-caret-left' => 'circle-caret-left' ),
					array( 'fa-solid fa-circle-caret-right' => 'circle-caret-right' ),
					array( 'fa-solid fa-circle-caret-up' => 'circle-caret-up' ),
					array( 'fa-solid fa-circle-check' => 'circle-check' ),
					array( 'fa-solid fa-circle-chevron-down' => 'circle-chevron-down' ),
					array( 'fa-solid fa-circle-chevron-left' => 'circle-chevron-left' ),
					array( 'fa-solid fa-circle-chevron-right' => 'circle-chevron-right' ),
					array( 'fa-solid fa-circle-chevron-up' => 'circle-chevron-up' ),
					array( 'fa-solid fa-circle-d' => 'circle-d' ),
					array( 'fa-solid fa-circle-dashed' => 'circle-dashed' ),
					array( 'fa-solid fa-circle-divide' => 'circle-divide' ),
					array( 'fa-solid fa-circle-dollar-to-slot' => 'circle-dollar-to-slot' ),
					array( 'fa-solid fa-circle-dollar' => 'circle-dollar' ),
					array( 'fa-solid fa-circle-dot' => 'circle-dot' ),
					array( 'fa-solid fa-circle-down-left' => 'circle-down-left' ),
					array( 'fa-solid fa-circle-down-right' => 'circle-down-right' ),
					array( 'fa-solid fa-circle-down' => 'circle-down' ),
					array( 'fa-solid fa-circle-e' => 'circle-e' ),
					array( 'fa-solid fa-circle-ellipsis-vertical' => 'circle-ellipsis-vertical' ),
					array( 'fa-solid fa-circle-ellipsis' => 'circle-ellipsis' ),
					array( 'fa-solid fa-circle-envelope' => 'circle-envelope' ),
					array( 'fa-solid fa-circle-euro' => 'circle-euro' ),
					array( 'fa-solid fa-circle-exclamation-check' => 'circle-exclamation-check' ),
					array( 'fa-solid fa-circle-exclamation' => 'circle-exclamation' ),
					array( 'fa-solid fa-circle-f' => 'circle-f' ),
					array( 'fa-solid fa-circle-g' => 'circle-g' ),
					array( 'fa-solid fa-circle-h' => 'circle-h' ),
					array( 'fa-solid fa-circle-half-stroke' => 'circle-half-stroke' ),
					array( 'fa-solid fa-circle-half' => 'circle-half' ),
					array( 'fa-solid fa-circle-heart' => 'circle-heart' ),
					array( 'fa-solid fa-circle-i' => 'circle-i' ),
					array( 'fa-solid fa-circle-info' => 'circle-info' ),
					array( 'fa-solid fa-circle-j' => 'circle-j' ),
					array( 'fa-solid fa-circle-k' => 'circle-k' ),
					array( 'fa-solid fa-circle-l' => 'circle-l' ),
					array( 'fa-solid fa-circle-left' => 'circle-left' ),
					array( 'fa-solid fa-circle-location-arrow' => 'circle-location-arrow' ),
					array( 'fa-solid fa-circle-m' => 'circle-m' ),
					array( 'fa-solid fa-circle-microphone-lines' => 'circle-microphone-lines' ),
					array( 'fa-solid fa-circle-microphone' => 'circle-microphone' ),
					array( 'fa-solid fa-circle-minus' => 'circle-minus' ),
					array( 'fa-solid fa-circle-n' => 'circle-n' ),
					array( 'fa-solid fa-circle-nodes' => 'circle-nodes' ),
					array( 'fa-solid fa-circle-notch' => 'circle-notch' ),
					array( 'fa-solid fa-circle-o' => 'circle-o' ),
					array( 'fa-solid fa-circle-p' => 'circle-p' ),
					array( 'fa-solid fa-circle-parking' => 'circle-parking' ),
					array( 'fa-solid fa-circle-pause' => 'circle-pause' ),
					array( 'fa-solid fa-circle-phone-flip' => 'circle-phone-flip' ),
					array( 'fa-solid fa-circle-phone-hangup' => 'circle-phone-hangup' ),
					array( 'fa-solid fa-circle-phone' => 'circle-phone' ),
					array( 'fa-solid fa-circle-play' => 'circle-play' ),
					array( 'fa-solid fa-circle-plus' => 'circle-plus' ),
					array( 'fa-solid fa-circle-q' => 'circle-q' ),
					array( 'fa-solid fa-circle-quarter-stroke' => 'circle-quarter-stroke' ),
					array( 'fa-solid fa-circle-quarter' => 'circle-quarter' ),
					array( 'fa-solid fa-circle-quarters' => 'circle-quarters' ),
					array( 'fa-solid fa-circle-question' => 'circle-question' ),
					array( 'fa-solid fa-circle-r' => 'circle-r' ),
					array( 'fa-solid fa-circle-radiation' => 'circle-radiation' ),
					array( 'fa-solid fa-circle-right' => 'circle-right' ),
					array( 'fa-solid fa-circle-s' => 'circle-s' ),
					array( 'fa-solid fa-circle-small' => 'circle-small' ),
					array( 'fa-solid fa-circle-sort-down' => 'circle-sort-down' ),
					array( 'fa-solid fa-circle-sort-up' => 'circle-sort-up' ),
					array( 'fa-solid fa-circle-sort' => 'circle-sort' ),
					array( 'fa-solid fa-circle-star' => 'circle-star' ),
					array( 'fa-solid fa-circle-sterling' => 'circle-sterling' ),
					array( 'fa-solid fa-circle-stop' => 'circle-stop' ),
					array( 'fa-solid fa-circle-t' => 'circle-t' ),
					array( 'fa-solid fa-circle-three-quarters-stroke' => 'circle-three-quarters-stroke' ),
					array( 'fa-solid fa-circle-three-quarters' => 'circle-three-quarters' ),
					array( 'fa-solid fa-circle-trash' => 'circle-trash' ),
					array( 'fa-solid fa-circle-u' => 'circle-u' ),
					array( 'fa-solid fa-circle-up-left' => 'circle-up-left' ),
					array( 'fa-solid fa-circle-up-right' => 'circle-up-right' ),
					array( 'fa-solid fa-circle-up' => 'circle-up' ),
					array( 'fa-solid fa-circle-user' => 'circle-user' ),
					array( 'fa-solid fa-circle-v' => 'circle-v' ),
					array( 'fa-solid fa-circle-video' => 'circle-video' ),
					array( 'fa-solid fa-circle-w' => 'circle-w' ),
					array( 'fa-solid fa-circle-waveform-lines' => 'circle-waveform-lines' ),
					array( 'fa-solid fa-circle-x' => 'circle-x' ),
					array( 'fa-solid fa-circle-xmark' => 'circle-xmark' ),
					array( 'fa-solid fa-circle-y' => 'circle-y' ),
					array( 'fa-solid fa-circle-yen' => 'circle-yen' ),
					array( 'fa-solid fa-circle-z' => 'circle-z' ),
					array( 'fa-solid fa-circle' => 'circle' ),
					array( 'fa-solid fa-circles-overlap' => 'circles-overlap' ),
					array( 'fa-solid fa-citrus-slice' => 'citrus-slice' ),
					array( 'fa-solid fa-citrus' => 'citrus' ),
					array( 'fa-solid fa-city' => 'city' ),
					array( 'fa-solid fa-clapperboard-play' => 'clapperboard-play' ),
					array( 'fa-solid fa-clapperboard' => 'clapperboard' ),
					array( 'fa-solid fa-clarinet' => 'clarinet' ),
					array( 'fa-solid fa-claw-marks' => 'claw-marks' ),
					array( 'fa-solid fa-clipboard-check' => 'clipboard-check' ),
					array( 'fa-solid fa-clipboard-list-check' => 'clipboard-list-check' ),
					array( 'fa-solid fa-clipboard-list' => 'clipboard-list' ),
					array( 'fa-solid fa-clipboard-medical' => 'clipboard-medical' ),
					array( 'fa-solid fa-clipboard-prescription' => 'clipboard-prescription' ),
					array( 'fa-solid fa-clipboard-question' => 'clipboard-question' ),
					array( 'fa-solid fa-clipboard-user' => 'clipboard-user' ),
					array( 'fa-solid fa-clipboard' => 'clipboard' ),
					array( 'fa-solid fa-clock-desk' => 'clock-desk' ),
					array( 'fa-solid fa-clock-eight-thirty' => 'clock-eight-thirty' ),
					array( 'fa-solid fa-clock-eight' => 'clock-eight' ),
					array( 'fa-solid fa-clock-eleven-thirty' => 'clock-eleven-thirty' ),
					array( 'fa-solid fa-clock-eleven' => 'clock-eleven' ),
					array( 'fa-solid fa-clock-five-thirty' => 'clock-five-thirty' ),
					array( 'fa-solid fa-clock-five' => 'clock-five' ),
					array( 'fa-solid fa-clock-four-thirty' => 'clock-four-thirty' ),
					array( 'fa-solid fa-clock-nine-thirty' => 'clock-nine-thirty' ),
					array( 'fa-solid fa-clock-nine' => 'clock-nine' ),
					array( 'fa-solid fa-clock-one-thirty' => 'clock-one-thirty' ),
					array( 'fa-solid fa-clock-one' => 'clock-one' ),
					array( 'fa-solid fa-clock-rotate-left' => 'clock-rotate-left' ),
					array( 'fa-solid fa-clock-seven-thirty' => 'clock-seven-thirty' ),
					array( 'fa-solid fa-clock-seven' => 'clock-seven' ),
					array( 'fa-solid fa-clock-six-thirty' => 'clock-six-thirty' ),
					array( 'fa-solid fa-clock-six' => 'clock-six' ),
					array( 'fa-solid fa-clock-ten-thirty' => 'clock-ten-thirty' ),
					array( 'fa-solid fa-clock-ten' => 'clock-ten' ),
					array( 'fa-solid fa-clock-three-thirty' => 'clock-three-thirty' ),
					array( 'fa-solid fa-clock-three' => 'clock-three' ),
					array( 'fa-solid fa-clock-twelve-thirty' => 'clock-twelve-thirty' ),
					array( 'fa-solid fa-clock-twelve' => 'clock-twelve' ),
					array( 'fa-solid fa-clock-two-thirty' => 'clock-two-thirty' ),
					array( 'fa-solid fa-clock-two' => 'clock-two' ),
					array( 'fa-solid fa-clock' => 'clock' ),
					array( 'fa-solid fa-clone' => 'clone' ),
					array( 'fa-solid fa-closed-captioning-slash' => 'closed-captioning-slash' ),
					array( 'fa-solid fa-closed-captioning' => 'closed-captioning' ),
					array( 'fa-solid fa-clothes-hanger' => 'clothes-hanger' ),
					array( 'fa-solid fa-cloud-arrow-down' => 'cloud-arrow-down' ),
					array( 'fa-solid fa-cloud-arrow-up' => 'cloud-arrow-up' ),
					array( 'fa-solid fa-cloud-binary' => 'cloud-binary' ),
					array( 'fa-solid fa-cloud-bolt-moon' => 'cloud-bolt-moon' ),
					array( 'fa-solid fa-cloud-bolt-sun' => 'cloud-bolt-sun' ),
					array( 'fa-solid fa-cloud-bolt' => 'cloud-bolt' ),
					array( 'fa-solid fa-cloud-check' => 'cloud-check' ),
					array( 'fa-solid fa-cloud-drizzle' => 'cloud-drizzle' ),
					array( 'fa-solid fa-cloud-exclamation' => 'cloud-exclamation' ),
					array( 'fa-solid fa-cloud-fog' => 'cloud-fog' ),
					array( 'fa-solid fa-cloud-hail-mixed' => 'cloud-hail-mixed' ),
					array( 'fa-solid fa-cloud-hail' => 'cloud-hail' ),
					array( 'fa-solid fa-cloud-meatball' => 'cloud-meatball' ),
					array( 'fa-solid fa-cloud-minus' => 'cloud-minus' ),
					array( 'fa-solid fa-cloud-moon-rain' => 'cloud-moon-rain' ),
					array( 'fa-solid fa-cloud-moon' => 'cloud-moon' ),
					array( 'fa-solid fa-cloud-music' => 'cloud-music' ),
					array( 'fa-solid fa-cloud-plus' => 'cloud-plus' ),
					array( 'fa-solid fa-cloud-question' => 'cloud-question' ),
					array( 'fa-solid fa-cloud-rain' => 'cloud-rain' ),
					array( 'fa-solid fa-cloud-rainbow' => 'cloud-rainbow' ),
					array( 'fa-solid fa-cloud-showers-heavy' => 'cloud-showers-heavy' ),
					array( 'fa-solid fa-cloud-showers-water' => 'cloud-showers-water' ),
					array( 'fa-solid fa-cloud-showers' => 'cloud-showers' ),
					array( 'fa-solid fa-cloud-slash' => 'cloud-slash' ),
					array( 'fa-solid fa-cloud-sleet' => 'cloud-sleet' ),
					array( 'fa-solid fa-cloud-snow' => 'cloud-snow' ),
					array( 'fa-solid fa-cloud-sun-rain' => 'cloud-sun-rain' ),
					array( 'fa-solid fa-cloud-sun' => 'cloud-sun' ),
					array( 'fa-solid fa-cloud-word' => 'cloud-word' ),
					array( 'fa-solid fa-cloud-xmark' => 'cloud-xmark' ),
					array( 'fa-solid fa-cloud' => 'cloud' ),
					array( 'fa-solid fa-clouds-moon' => 'clouds-moon' ),
					array( 'fa-solid fa-clouds-sun' => 'clouds-sun' ),
					array( 'fa-solid fa-clouds' => 'clouds' ),
					array( 'fa-solid fa-clover' => 'clover' ),
					array( 'fa-solid fa-club' => 'club' ),
					array( 'fa-solid fa-coconut' => 'coconut' ),
					array( 'fa-solid fa-code-branch' => 'code-branch' ),
					array( 'fa-solid fa-code-commit' => 'code-commit' ),
					array( 'fa-solid fa-code-compare' => 'code-compare' ),
					array( 'fa-solid fa-code-fork' => 'code-fork' ),
					array( 'fa-solid fa-code-merge' => 'code-merge' ),
					array( 'fa-solid fa-code-pull-request-closed' => 'code-pull-request-closed' ),
					array( 'fa-solid fa-code-pull-request-draft' => 'code-pull-request-draft' ),
					array( 'fa-solid fa-code-pull-request' => 'code-pull-request' ),
					array( 'fa-solid fa-code-simple' => 'code-simple' ),
					array( 'fa-solid fa-code' => 'code' ),
					array( 'fa-solid fa-coffee-bean' => 'coffee-bean' ),
					array( 'fa-solid fa-coffee-beans' => 'coffee-beans' ),
					array( 'fa-solid fa-coffee-pot' => 'coffee-pot' ),
					array( 'fa-solid fa-coffin-cross' => 'coffin-cross' ),
					array( 'fa-solid fa-coffin' => 'coffin' ),
					array( 'fa-solid fa-coin-blank' => 'coin-blank' ),
					array( 'fa-solid fa-coin-front' => 'coin-front' ),
					array( 'fa-solid fa-coin-vertical' => 'coin-vertical' ),
					array( 'fa-solid fa-coin' => 'coin' ),
					array( 'fa-solid fa-coins' => 'coins' ),
					array( 'fa-solid fa-colon-sign' => 'colon-sign' ),
					array( 'fa-solid fa-colon' => 'colon' ),
					array( 'fa-solid fa-columns-3' => 'columns-3' ),
					array( 'fa-solid fa-comet' => 'comet' ),
					array( 'fa-solid fa-comma' => 'comma' ),
					array( 'fa-solid fa-command' => 'command' ),
					array( 'fa-solid fa-comment-arrow-down' => 'comment-arrow-down' ),
					array( 'fa-solid fa-comment-arrow-up-right' => 'comment-arrow-up-right' ),
					array( 'fa-solid fa-comment-arrow-up' => 'comment-arrow-up' ),
					array( 'fa-solid fa-comment-captions' => 'comment-captions' ),
					array( 'fa-solid fa-comment-check' => 'comment-check' ),
					array( 'fa-solid fa-comment-code' => 'comment-code' ),
					array( 'fa-solid fa-comment-dollar' => 'comment-dollar' ),
					array( 'fa-solid fa-comment-dots' => 'comment-dots' ),
					array( 'fa-solid fa-comment-exclamation' => 'comment-exclamation' ),
					array( 'fa-solid fa-comment-heart' => 'comment-heart' ),
					array( 'fa-solid fa-comment-image' => 'comment-image' ),
					array( 'fa-solid fa-comment-lines' => 'comment-lines' ),
					array( 'fa-solid fa-comment-medical' => 'comment-medical' ),
					array( 'fa-solid fa-comment-middle-top' => 'comment-middle-top' ),
					array( 'fa-solid fa-comment-middle' => 'comment-middle' ),
					array( 'fa-solid fa-comment-minus' => 'comment-minus' ),
					array( 'fa-solid fa-comment-music' => 'comment-music' ),
					array( 'fa-solid fa-comment-pen' => 'comment-pen' ),
					array( 'fa-solid fa-comment-plus' => 'comment-plus' ),
					array( 'fa-solid fa-comment-question' => 'comment-question' ),
					array( 'fa-solid fa-comment-quote' => 'comment-quote' ),
					array( 'fa-solid fa-comment-slash' => 'comment-slash' ),
					array( 'fa-solid fa-comment-smile' => 'comment-smile' ),
					array( 'fa-solid fa-comment-sms' => 'comment-sms' ),
					array( 'fa-solid fa-comment-text' => 'comment-text' ),
					array( 'fa-solid fa-comment-xmark' => 'comment-xmark' ),
					array( 'fa-solid fa-comment' => 'comment' ),
					array( 'fa-solid fa-comments-dollar' => 'comments-dollar' ),
					array( 'fa-solid fa-comments-question-check' => 'comments-question-check' ),
					array( 'fa-solid fa-comments-question' => 'comments-question' ),
					array( 'fa-solid fa-comments' => 'comments' ),
					array( 'fa-solid fa-compact-disc' => 'compact-disc' ),
					array( 'fa-solid fa-compass-drafting' => 'compass-drafting' ),
					array( 'fa-solid fa-compass-slash' => 'compass-slash' ),
					array( 'fa-solid fa-compass' => 'compass' ),
					array( 'fa-solid fa-compress-wide' => 'compress-wide' ),
					array( 'fa-solid fa-compress' => 'compress' ),
					array( 'fa-solid fa-computer-classic' => 'computer-classic' ),
					array( 'fa-solid fa-computer-mouse-scrollwheel' => 'computer-mouse-scrollwheel' ),
					array( 'fa-solid fa-computer-mouse' => 'computer-mouse' ),
					array( 'fa-solid fa-computer-speaker' => 'computer-speaker' ),
					array( 'fa-solid fa-computer' => 'computer' ),
					array( 'fa-solid fa-container-storage' => 'container-storage' ),
					array( 'fa-solid fa-conveyor-belt-arm' => 'conveyor-belt-arm' ),
					array( 'fa-solid fa-conveyor-belt-boxes' => 'conveyor-belt-boxes' ),
					array( 'fa-solid fa-conveyor-belt-empty' => 'conveyor-belt-empty' ),
					array( 'fa-solid fa-conveyor-belt' => 'conveyor-belt' ),
					array( 'fa-solid fa-cookie-bite' => 'cookie-bite' ),
					array( 'fa-solid fa-cookie' => 'cookie' ),
					array( 'fa-solid fa-copy' => 'copy' ),
					array( 'fa-solid fa-copyright' => 'copyright' ),
					array( 'fa-solid fa-corn' => 'corn' ),
					array( 'fa-solid fa-corner' => 'corner' ),
					array( 'fa-solid fa-couch' => 'couch' ),
					array( 'fa-solid fa-cow' => 'cow' ),
					array( 'fa-solid fa-cowbell-circle-plus' => 'cowbell-circle-plus' ),
					array( 'fa-solid fa-cowbell' => 'cowbell' ),
					array( 'fa-solid fa-crab' => 'crab' ),
					array( 'fa-solid fa-crate-apple' => 'crate-apple' ),
					array( 'fa-solid fa-crate-empty' => 'crate-empty' ),
					array( 'fa-solid fa-credit-card-blank' => 'credit-card-blank' ),
					array( 'fa-solid fa-credit-card-front' => 'credit-card-front' ),
					array( 'fa-solid fa-credit-card' => 'credit-card' ),
					array( 'fa-solid fa-cricket-bat-ball' => 'cricket-bat-ball' ),
					array( 'fa-solid fa-croissant' => 'croissant' ),
					array( 'fa-solid fa-crop-simple' => 'crop-simple' ),
					array( 'fa-solid fa-crop' => 'crop' ),
					array( 'fa-solid fa-cross' => 'cross' ),
					array( 'fa-solid fa-crosshairs-simple' => 'crosshairs-simple' ),
					array( 'fa-solid fa-crosshairs' => 'crosshairs' ),
					array( 'fa-solid fa-crow' => 'crow' ),
					array( 'fa-solid fa-crown' => 'crown' ),
					array( 'fa-solid fa-crutch' => 'crutch' ),
					array( 'fa-solid fa-crutches' => 'crutches' ),
					array( 'fa-solid fa-cruzeiro-sign' => 'cruzeiro-sign' ),
					array( 'fa-solid fa-crystal-ball' => 'crystal-ball' ),
					array( 'fa-solid fa-cube' => 'cube' ),
					array( 'fa-solid fa-cubes-stacked' => 'cubes-stacked' ),
					array( 'fa-solid fa-cubes' => 'cubes' ),
					array( 'fa-solid fa-cucumber' => 'cucumber' ),
					array( 'fa-solid fa-cup-straw-swoosh' => 'cup-straw-swoosh' ),
					array( 'fa-solid fa-cup-straw' => 'cup-straw' ),
					array( 'fa-solid fa-cup-togo' => 'cup-togo' ),
					array( 'fa-solid fa-cupcake' => 'cupcake' ),
					array( 'fa-solid fa-curling-stone' => 'curling-stone' ),
					array( 'fa-solid fa-custard' => 'custard' ),
					array( 'fa-solid fa-d' => 'd' ),
					array( 'fa-solid fa-dagger' => 'dagger' ),
					array( 'fa-solid fa-dash' => 'dash' ),
					array( 'fa-solid fa-database' => 'database' ),
					array( 'fa-solid fa-deer-rudolph' => 'deer-rudolph' ),
					array( 'fa-solid fa-deer' => 'deer' ),
					array( 'fa-solid fa-delete-left' => 'delete-left' ),
					array( 'fa-solid fa-delete-right' => 'delete-right' ),
					array( 'fa-solid fa-democrat' => 'democrat' ),
					array( 'fa-solid fa-desktop-arrow-down' => 'desktop-arrow-down' ),
					array( 'fa-solid fa-desktop' => 'desktop' ),
					array( 'fa-solid fa-dharmachakra' => 'dharmachakra' ),
					array( 'fa-solid fa-diagram-cells' => 'diagram-cells' ),
					array( 'fa-solid fa-diagram-lean-canvas' => 'diagram-lean-canvas' ),
					array( 'fa-solid fa-diagram-nested' => 'diagram-nested' ),
					array( 'fa-solid fa-diagram-next' => 'diagram-next' ),
					array( 'fa-solid fa-diagram-predecessor' => 'diagram-predecessor' ),
					array( 'fa-solid fa-diagram-previous' => 'diagram-previous' ),
					array( 'fa-solid fa-diagram-project' => 'diagram-project' ),
					array( 'fa-solid fa-diagram-sankey' => 'diagram-sankey' ),
					array( 'fa-solid fa-diagram-subtask' => 'diagram-subtask' ),
					array( 'fa-solid fa-diagram-successor' => 'diagram-successor' ),
					array( 'fa-solid fa-diagram-venn' => 'diagram-venn' ),
					array( 'fa-solid fa-dial-high' => 'dial-high' ),
					array( 'fa-solid fa-dial-low' => 'dial-low' ),
					array( 'fa-solid fa-dial-max' => 'dial-max' ),
					array( 'fa-solid fa-dial-med-low' => 'dial-med-low' ),
					array( 'fa-solid fa-dial-med' => 'dial-med' ),
					array( 'fa-solid fa-dial-min' => 'dial-min' ),
					array( 'fa-solid fa-dial-off' => 'dial-off' ),
					array( 'fa-solid fa-dial' => 'dial' ),
					array( 'fa-solid fa-diamond-exclamation' => 'diamond-exclamation' ),
					array( 'fa-solid fa-diamond-half-stroke' => 'diamond-half-stroke' ),
					array( 'fa-solid fa-diamond-half' => 'diamond-half' ),
					array( 'fa-solid fa-diamond-turn-right' => 'diamond-turn-right' ),
					array( 'fa-solid fa-diamond' => 'diamond' ),
					array( 'fa-solid fa-dice-d4' => 'dice-d4' ),
					array( 'fa-solid fa-dice-d6' => 'dice-d6' ),
					array( 'fa-solid fa-dice-d8' => 'dice-d8' ),
					array( 'fa-solid fa-dice-d10' => 'dice-d10' ),
					array( 'fa-solid fa-dice-d12' => 'dice-d12' ),
					array( 'fa-solid fa-dice-d20' => 'dice-d20' ),
					array( 'fa-solid fa-dice-five' => 'dice-five' ),
					array( 'fa-solid fa-dice-four' => 'dice-four' ),
					array( 'fa-solid fa-dice-one' => 'dice-one' ),
					array( 'fa-solid fa-dice-six' => 'dice-six' ),
					array( 'fa-solid fa-dice-three' => 'dice-three' ),
					array( 'fa-solid fa-dice-two' => 'dice-two' ),
					array( 'fa-solid fa-dice' => 'dice' ),
					array( 'fa-solid fa-dinosaur' => 'dinosaur' ),
					array( 'fa-solid fa-diploma' => 'diploma' ),
					array( 'fa-solid fa-disc-drive' => 'disc-drive' ),
					array( 'fa-solid fa-disease' => 'disease' ),
					array( 'fa-solid fa-display-arrow-down' => 'display-arrow-down' ),
					array( 'fa-solid fa-display-chart-up-circle-currency' => 'display-chart-up-circle-currency' ),
					array( 'fa-solid fa-display-chart-up-circle-dollar' => 'display-chart-up-circle-dollar' ),
					array( 'fa-solid fa-display-chart-up' => 'display-chart-up' ),
					array( 'fa-solid fa-display-code' => 'display-code' ),
					array( 'fa-solid fa-display-medical' => 'display-medical' ),
					array( 'fa-solid fa-display-slash' => 'display-slash' ),
					array( 'fa-solid fa-display' => 'display' ),
					array( 'fa-solid fa-distribute-spacing-horizontal' => 'distribute-spacing-horizontal' ),
					array( 'fa-solid fa-distribute-spacing-vertical' => 'distribute-spacing-vertical' ),
					array( 'fa-solid fa-ditto' => 'ditto' ),
					array( 'fa-solid fa-divide' => 'divide' ),
					array( 'fa-solid fa-dna' => 'dna' ),
					array( 'fa-solid fa-do-not-enter' => 'do-not-enter' ),
					array( 'fa-solid fa-dog-leashed' => 'dog-leashed' ),
					array( 'fa-solid fa-dog' => 'dog' ),
					array( 'fa-solid fa-dollar-sign' => 'dollar-sign' ),
					array( 'fa-solid fa-dolly-empty' => 'dolly-empty' ),
					array( 'fa-solid fa-dolly' => 'dolly' ),
					array( 'fa-solid fa-dolphin' => 'dolphin' ),
					array( 'fa-solid fa-dong-sign' => 'dong-sign' ),
					array( 'fa-solid fa-donut' => 'donut' ),
					array( 'fa-solid fa-door-closed' => 'door-closed' ),
					array( 'fa-solid fa-door-open' => 'door-open' ),
					array( 'fa-solid fa-dove' => 'dove' ),
					array( 'fa-solid fa-down-from-dotted-line' => 'down-from-dotted-line' ),
					array( 'fa-solid fa-down-from-line' => 'down-from-line' ),
					array( 'fa-solid fa-down-left-and-up-right-to-center' => 'down-left-and-up-right-to-center' ),
					array( 'fa-solid fa-down-left' => 'down-left' ),
					array( 'fa-solid fa-down-long' => 'down-long' ),
					array( 'fa-solid fa-down-right' => 'down-right' ),
					array( 'fa-solid fa-down-to-bracket' => 'down-to-bracket' ),
					array( 'fa-solid fa-down-to-dotted-line' => 'down-to-dotted-line' ),
					array( 'fa-solid fa-down-to-line' => 'down-to-line' ),
					array( 'fa-solid fa-down' => 'down' ),
					array( 'fa-solid fa-download' => 'download' ),
					array( 'fa-solid fa-dragon' => 'dragon' ),
					array( 'fa-solid fa-draw-circle' => 'draw-circle' ),
					array( 'fa-solid fa-draw-polygon' => 'draw-polygon' ),
					array( 'fa-solid fa-draw-square' => 'draw-square' ),
					array( 'fa-solid fa-dreidel' => 'dreidel' ),
					array( 'fa-solid fa-drone-front' => 'drone-front' ),
					array( 'fa-solid fa-drone' => 'drone' ),
					array( 'fa-solid fa-droplet-degree' => 'droplet-degree' ),
					array( 'fa-solid fa-droplet-percent' => 'droplet-percent' ),
					array( 'fa-solid fa-droplet-slash' => 'droplet-slash' ),
					array( 'fa-solid fa-droplet' => 'droplet' ),
					array( 'fa-solid fa-drum-steelpan' => 'drum-steelpan' ),
					array( 'fa-solid fa-drum' => 'drum' ),
					array( 'fa-solid fa-drumstick-bite' => 'drumstick-bite' ),
					array( 'fa-solid fa-drumstick' => 'drumstick' ),
					array( 'fa-solid fa-dryer-heat' => 'dryer-heat' ),
					array( 'fa-solid fa-dryer' => 'dryer' ),
					array( 'fa-solid fa-duck' => 'duck' ),
					array( 'fa-solid fa-dumbbell' => 'dumbbell' ),
					array( 'fa-solid fa-dumpster-fire' => 'dumpster-fire' ),
					array( 'fa-solid fa-dumpster' => 'dumpster' ),
					array( 'fa-solid fa-dungeon' => 'dungeon' ),
					array( 'fa-solid fa-e' => 'e' ),
					array( 'fa-solid fa-ear-deaf' => 'ear-deaf' ),
					array( 'fa-solid fa-ear-listen' => 'ear-listen' ),
					array( 'fa-solid fa-ear-muffs' => 'ear-muffs' ),
					array( 'fa-solid fa-ear' => 'ear' ),
					array( 'fa-solid fa-earth-africa' => 'earth-africa' ),
					array( 'fa-solid fa-earth-americas' => 'earth-americas' ),
					array( 'fa-solid fa-earth-asia' => 'earth-asia' ),
					array( 'fa-solid fa-earth-europe' => 'earth-europe' ),
					array( 'fa-solid fa-earth-oceania' => 'earth-oceania' ),
					array( 'fa-solid fa-eclipse' => 'eclipse' ),
					array( 'fa-solid fa-egg-fried' => 'egg-fried' ),
					array( 'fa-solid fa-egg' => 'egg' ),
					array( 'fa-solid fa-eggplant' => 'eggplant' ),
					array( 'fa-solid fa-eject' => 'eject' ),
					array( 'fa-solid fa-elephant' => 'elephant' ),
					array( 'fa-solid fa-elevator' => 'elevator' ),
					array( 'fa-solid fa-ellipsis-stroke-vertical' => 'ellipsis-stroke-vertical' ),
					array( 'fa-solid fa-ellipsis-stroke' => 'ellipsis-stroke' ),
					array( 'fa-solid fa-ellipsis-vertical' => 'ellipsis-vertical' ),
					array( 'fa-solid fa-ellipsis' => 'ellipsis' ),
					array( 'fa-solid fa-empty-set' => 'empty-set' ),
					array( 'fa-solid fa-engine-warning' => 'engine-warning' ),
					array( 'fa-solid fa-engine' => 'engine' ),
					array( 'fa-solid fa-envelope-circle-check' => 'envelope-circle-check' ),
					array( 'fa-solid fa-envelope-dot' => 'envelope-dot' ),
					array( 'fa-solid fa-envelope-open-dollar' => 'envelope-open-dollar' ),
					array( 'fa-solid fa-envelope-open-text' => 'envelope-open-text' ),
					array( 'fa-solid fa-envelope-open' => 'envelope-open' ),
					array( 'fa-solid fa-envelope' => 'envelope' ),
					array( 'fa-solid fa-envelopes-bulk' => 'envelopes-bulk' ),
					array( 'fa-solid fa-envelopes' => 'envelopes' ),
					array( 'fa-solid fa-equals' => 'equals' ),
					array( 'fa-solid fa-eraser' => 'eraser' ),
					array( 'fa-solid fa-escalator' => 'escalator' ),
					array( 'fa-solid fa-ethernet' => 'ethernet' ),
					array( 'fa-solid fa-euro-sign' => 'euro-sign' ),
					array( 'fa-solid fa-exclamation' => 'exclamation' ),
					array( 'fa-solid fa-expand-wide' => 'expand-wide' ),
					array( 'fa-solid fa-expand' => 'expand' ),
					array( 'fa-solid fa-explosion' => 'explosion' ),
					array( 'fa-solid fa-eye-dropper-full' => 'eye-dropper-full' ),
					array( 'fa-solid fa-eye-dropper-half' => 'eye-dropper-half' ),
					array( 'fa-solid fa-eye-dropper' => 'eye-dropper' ),
					array( 'fa-solid fa-eye-evil' => 'eye-evil' ),
					array( 'fa-solid fa-eye-low-vision' => 'eye-low-vision' ),
					array( 'fa-solid fa-eye-slash' => 'eye-slash' ),
					array( 'fa-solid fa-eye' => 'eye' ),
					array( 'fa-solid fa-eyes' => 'eyes' ),
					array( 'fa-solid fa-f' => 'f' ),
					array( 'fa-solid fa-face-angry-horns' => 'face-angry-horns' ),
					array( 'fa-solid fa-face-angry' => 'face-angry' ),
					array( 'fa-solid fa-face-anguished' => 'face-anguished' ),
					array( 'fa-solid fa-face-anxious-sweat' => 'face-anxious-sweat' ),
					array( 'fa-solid fa-face-astonished' => 'face-astonished' ),
					array( 'fa-solid fa-face-awesome' => 'face-awesome' ),
					array( 'fa-solid fa-face-beam-hand-over-mouth' => 'face-beam-hand-over-mouth' ),
					array( 'fa-solid fa-face-clouds' => 'face-clouds' ),
					array( 'fa-solid fa-face-confounded' => 'face-confounded' ),
					array( 'fa-solid fa-face-confused' => 'face-confused' ),
					array( 'fa-solid fa-face-cowboy-hat' => 'face-cowboy-hat' ),
					array( 'fa-solid fa-face-diagonal-mouth' => 'face-diagonal-mouth' ),
					array( 'fa-solid fa-face-disappointed' => 'face-disappointed' ),
					array( 'fa-solid fa-face-disguise' => 'face-disguise' ),
					array( 'fa-solid fa-face-dizzy' => 'face-dizzy' ),
					array( 'fa-solid fa-face-dotted' => 'face-dotted' ),
					array( 'fa-solid fa-face-downcast-sweat' => 'face-downcast-sweat' ),
					array( 'fa-solid fa-face-drooling' => 'face-drooling' ),
					array( 'fa-solid fa-face-exhaling' => 'face-exhaling' ),
					array( 'fa-solid fa-face-explode' => 'face-explode' ),
					array( 'fa-solid fa-face-expressionless' => 'face-expressionless' ),
					array( 'fa-solid fa-face-eyes-xmarks' => 'face-eyes-xmarks' ),
					array( 'fa-solid fa-face-fearful' => 'face-fearful' ),
					array( 'fa-solid fa-face-flushed' => 'face-flushed' ),
					array( 'fa-solid fa-face-frown-open' => 'face-frown-open' ),
					array( 'fa-solid fa-face-frown-slight' => 'face-frown-slight' ),
					array( 'fa-solid fa-face-frown' => 'face-frown' ),
					array( 'fa-solid fa-face-glasses' => 'face-glasses' ),
					array( 'fa-solid fa-face-grimace' => 'face-grimace' ),
					array( 'fa-solid fa-face-grin-beam-sweat' => 'face-grin-beam-sweat' ),
					array( 'fa-solid fa-face-grin-beam' => 'face-grin-beam' ),
					array( 'fa-solid fa-face-grin-hearts' => 'face-grin-hearts' ),
					array( 'fa-solid fa-face-grin-squint-tears' => 'face-grin-squint-tears' ),
					array( 'fa-solid fa-face-grin-squint' => 'face-grin-squint' ),
					array( 'fa-solid fa-face-grin-stars' => 'face-grin-stars' ),
					array( 'fa-solid fa-face-grin-tears' => 'face-grin-tears' ),
					array( 'fa-solid fa-face-grin-tongue-squint' => 'face-grin-tongue-squint' ),
					array( 'fa-solid fa-face-grin-tongue-wink' => 'face-grin-tongue-wink' ),
					array( 'fa-solid fa-face-grin-tongue' => 'face-grin-tongue' ),
					array( 'fa-solid fa-face-grin-wide' => 'face-grin-wide' ),
					array( 'fa-solid fa-face-grin-wink' => 'face-grin-wink' ),
					array( 'fa-solid fa-face-grin' => 'face-grin' ),
					array( 'fa-solid fa-face-hand-over-mouth' => 'face-hand-over-mouth' ),
					array( 'fa-solid fa-face-hand-peeking' => 'face-hand-peeking' ),
					array( 'fa-solid fa-face-hand-yawn' => 'face-hand-yawn' ),
					array( 'fa-solid fa-face-head-bandage' => 'face-head-bandage' ),
					array( 'fa-solid fa-face-holding-back-tears' => 'face-holding-back-tears' ),
					array( 'fa-solid fa-face-hushed' => 'face-hushed' ),
					array( 'fa-solid fa-face-icicles' => 'face-icicles' ),
					array( 'fa-solid fa-face-kiss-beam' => 'face-kiss-beam' ),
					array( 'fa-solid fa-face-kiss-closed-eyes' => 'face-kiss-closed-eyes' ),
					array( 'fa-solid fa-face-kiss-wink-heart' => 'face-kiss-wink-heart' ),
					array( 'fa-solid fa-face-kiss' => 'face-kiss' ),
					array( 'fa-solid fa-face-laugh-beam' => 'face-laugh-beam' ),
					array( 'fa-solid fa-face-laugh-squint' => 'face-laugh-squint' ),
					array( 'fa-solid fa-face-laugh-wink' => 'face-laugh-wink' ),
					array( 'fa-solid fa-face-laugh' => 'face-laugh' ),
					array( 'fa-solid fa-face-lying' => 'face-lying' ),
					array( 'fa-solid fa-face-mask' => 'face-mask' ),
					array( 'fa-solid fa-face-meh-blank' => 'face-meh-blank' ),
					array( 'fa-solid fa-face-meh' => 'face-meh' ),
					array( 'fa-solid fa-face-melting' => 'face-melting' ),
					array( 'fa-solid fa-face-monocle' => 'face-monocle' ),
					array( 'fa-solid fa-face-nauseated' => 'face-nauseated' ),
					array( 'fa-solid fa-face-nose-steam' => 'face-nose-steam' ),
					array( 'fa-solid fa-face-party' => 'face-party' ),
					array( 'fa-solid fa-face-pensive' => 'face-pensive' ),
					array( 'fa-solid fa-face-persevering' => 'face-persevering' ),
					array( 'fa-solid fa-face-pleading' => 'face-pleading' ),
					array( 'fa-solid fa-face-pouting' => 'face-pouting' ),
					array( 'fa-solid fa-face-raised-eyebrow' => 'face-raised-eyebrow' ),
					array( 'fa-solid fa-face-relieved' => 'face-relieved' ),
					array( 'fa-solid fa-face-rolling-eyes' => 'face-rolling-eyes' ),
					array( 'fa-solid fa-face-sad-cry' => 'face-sad-cry' ),
					array( 'fa-solid fa-face-sad-sweat' => 'face-sad-sweat' ),
					array( 'fa-solid fa-face-sad-tear' => 'face-sad-tear' ),
					array( 'fa-solid fa-face-saluting' => 'face-saluting' ),
					array( 'fa-solid fa-face-scream' => 'face-scream' ),
					array( 'fa-solid fa-face-shush' => 'face-shush' ),
					array( 'fa-solid fa-face-sleeping' => 'face-sleeping' ),
					array( 'fa-solid fa-face-sleepy' => 'face-sleepy' ),
					array( 'fa-solid fa-face-smile-beam' => 'face-smile-beam' ),
					array( 'fa-solid fa-face-smile-halo' => 'face-smile-halo' ),
					array( 'fa-solid fa-face-smile-hearts' => 'face-smile-hearts' ),
					array( 'fa-solid fa-face-smile-horns' => 'face-smile-horns' ),
					array( 'fa-solid fa-face-smile-plus' => 'face-smile-plus' ),
					array( 'fa-solid fa-face-smile-relaxed' => 'face-smile-relaxed' ),
					array( 'fa-solid fa-face-smile-tear' => 'face-smile-tear' ),
					array( 'fa-solid fa-face-smile-tongue' => 'face-smile-tongue' ),
					array( 'fa-solid fa-face-smile-upside-down' => 'face-smile-upside-down' ),
					array( 'fa-solid fa-face-smile-wink' => 'face-smile-wink' ),
					array( 'fa-solid fa-face-smile' => 'face-smile' ),
					array( 'fa-solid fa-face-smiling-hands' => 'face-smiling-hands' ),
					array( 'fa-solid fa-face-smirking' => 'face-smirking' ),
					array( 'fa-solid fa-face-spiral-eyes' => 'face-spiral-eyes' ),
					array( 'fa-solid fa-face-sunglasses' => 'face-sunglasses' ),
					array( 'fa-solid fa-face-surprise' => 'face-surprise' ),
					array( 'fa-solid fa-face-swear' => 'face-swear' ),
					array( 'fa-solid fa-face-thermometer' => 'face-thermometer' ),
					array( 'fa-solid fa-face-thinking' => 'face-thinking' ),
					array( 'fa-solid fa-face-tired' => 'face-tired' ),
					array( 'fa-solid fa-face-tissue' => 'face-tissue' ),
					array( 'fa-solid fa-face-tongue-money' => 'face-tongue-money' ),
					array( 'fa-solid fa-face-tongue-sweat' => 'face-tongue-sweat' ),
					array( 'fa-solid fa-face-unamused' => 'face-unamused' ),
					array( 'fa-solid fa-face-viewfinder' => 'face-viewfinder' ),
					array( 'fa-solid fa-face-vomit' => 'face-vomit' ),
					array( 'fa-solid fa-face-weary' => 'face-weary' ),
					array( 'fa-solid fa-face-woozy' => 'face-woozy' ),
					array( 'fa-solid fa-face-worried' => 'face-worried' ),
					array( 'fa-solid fa-face-zany' => 'face-zany' ),
					array( 'fa-solid fa-face-zipper' => 'face-zipper' ),
					array( 'fa-solid fa-falafel' => 'falafel' ),
					array( 'fa-solid fa-family-dress' => 'family-dress' ),
					array( 'fa-solid fa-family-pants' => 'family-pants' ),
					array( 'fa-solid fa-family' => 'family' ),
					array( 'fa-solid fa-fan-table' => 'fan-table' ),
					array( 'fa-solid fa-fan' => 'fan' ),
					array( 'fa-solid fa-farm' => 'farm' ),
					array( 'fa-solid fa-faucet-drip' => 'faucet-drip' ),
					array( 'fa-solid fa-faucet' => 'faucet' ),
					array( 'fa-solid fa-fax' => 'fax' ),
					array( 'fa-solid fa-feather-pointed' => 'feather-pointed' ),
					array( 'fa-solid fa-feather' => 'feather' ),
					array( 'fa-solid fa-fence' => 'fence' ),
					array( 'fa-solid fa-ferris-wheel' => 'ferris-wheel' ),
					array( 'fa-solid fa-ferry' => 'ferry' ),
					array( 'fa-solid fa-field-hockey-stick-ball' => 'field-hockey-stick-ball' ),
					array( 'fa-solid fa-file-arrow-down' => 'file-arrow-down' ),
					array( 'fa-solid fa-file-arrow-up' => 'file-arrow-up' ),
					array( 'fa-solid fa-file-audio' => 'file-audio' ),
					array( 'fa-solid fa-file-binary' => 'file-binary' ),
					array( 'fa-solid fa-file-certificate' => 'file-certificate' ),
					array( 'fa-solid fa-file-chart-column' => 'file-chart-column' ),
					array( 'fa-solid fa-file-chart-pie' => 'file-chart-pie' ),
					array( 'fa-solid fa-file-check' => 'file-check' ),
					array( 'fa-solid fa-file-circle-check' => 'file-circle-check' ),
					array( 'fa-solid fa-file-circle-exclamation' => 'file-circle-exclamation' ),
					array( 'fa-solid fa-file-circle-info' => 'file-circle-info' ),
					array( 'fa-solid fa-file-circle-minus' => 'file-circle-minus' ),
					array( 'fa-solid fa-file-circle-plus' => 'file-circle-plus' ),
					array( 'fa-solid fa-file-circle-question' => 'file-circle-question' ),
					array( 'fa-solid fa-file-circle-xmark' => 'file-circle-xmark' ),
					array( 'fa-solid fa-file-code' => 'file-code' ),
					array( 'fa-solid fa-file-contract' => 'file-contract' ),
					array( 'fa-solid fa-file-csv' => 'file-csv' ),
					array( 'fa-solid fa-file-dashed-line' => 'file-dashed-line' ),
					array( 'fa-solid fa-file-doc' => 'file-doc' ),
					array( 'fa-solid fa-file-excel' => 'file-excel' ),
					array( 'fa-solid fa-file-exclamation' => 'file-exclamation' ),
					array( 'fa-solid fa-file-export' => 'file-export' ),
					array( 'fa-solid fa-file-heart' => 'file-heart' ),
					array( 'fa-solid fa-file-image' => 'file-image' ),
					array( 'fa-solid fa-file-import' => 'file-import' ),
					array( 'fa-solid fa-file-invoice-dollar' => 'file-invoice-dollar' ),
					array( 'fa-solid fa-file-invoice' => 'file-invoice' ),
					array( 'fa-solid fa-file-lines' => 'file-lines' ),
					array( 'fa-solid fa-file-lock' => 'file-lock' ),
					array( 'fa-solid fa-file-magnifying-glass' => 'file-magnifying-glass' ),
					array( 'fa-solid fa-file-medical' => 'file-medical' ),
					array( 'fa-solid fa-file-minus' => 'file-minus' ),
					array( 'fa-solid fa-file-music' => 'file-music' ),
					array( 'fa-solid fa-file-pdf' => 'file-pdf' ),
					array( 'fa-solid fa-file-pen' => 'file-pen' ),
					array( 'fa-solid fa-file-plus-minus' => 'file-plus-minus' ),
					array( 'fa-solid fa-file-plus' => 'file-plus' ),
					array( 'fa-solid fa-file-powerpoint' => 'file-powerpoint' ),
					array( 'fa-solid fa-file-prescription' => 'file-prescription' ),
					array( 'fa-solid fa-file-shield' => 'file-shield' ),
					array( 'fa-solid fa-file-signature' => 'file-signature' ),
					array( 'fa-solid fa-file-slash' => 'file-slash' ),
					array( 'fa-solid fa-file-spreadsheet' => 'file-spreadsheet' ),
					array( 'fa-solid fa-file-user' => 'file-user' ),
					array( 'fa-solid fa-file-video' => 'file-video' ),
					array( 'fa-solid fa-file-waveform' => 'file-waveform' ),
					array( 'fa-solid fa-file-word' => 'file-word' ),
					array( 'fa-solid fa-file-xmark' => 'file-xmark' ),
					array( 'fa-solid fa-file-zip' => 'file-zip' ),
					array( 'fa-solid fa-file-zipper' => 'file-zipper' ),
					array( 'fa-solid fa-file' => 'file' ),
					array( 'fa-solid fa-files-medical' => 'files-medical' ),
					array( 'fa-solid fa-files' => 'files' ),
					array( 'fa-solid fa-fill-drip' => 'fill-drip' ),
					array( 'fa-solid fa-fill' => 'fill' ),
					array( 'fa-solid fa-film-canister' => 'film-canister' ),
					array( 'fa-solid fa-film-simple' => 'film-simple' ),
					array( 'fa-solid fa-film-slash' => 'film-slash' ),
					array( 'fa-solid fa-film' => 'film' ),
					array( 'fa-solid fa-films' => 'films' ),
					array( 'fa-solid fa-filter-circle-dollar' => 'filter-circle-dollar' ),
					array( 'fa-solid fa-filter-circle-xmark' => 'filter-circle-xmark' ),
					array( 'fa-solid fa-filter-list' => 'filter-list' ),
					array( 'fa-solid fa-filter-slash' => 'filter-slash' ),
					array( 'fa-solid fa-filter' => 'filter' ),
					array( 'fa-solid fa-filters' => 'filters' ),
					array( 'fa-solid fa-fingerprint' => 'fingerprint' ),
					array( 'fa-solid fa-fire-burner' => 'fire-burner' ),
					array( 'fa-solid fa-fire-extinguisher' => 'fire-extinguisher' ),
					array( 'fa-solid fa-fire-flame-curved' => 'fire-flame-curved' ),
					array( 'fa-solid fa-fire-flame-simple' => 'fire-flame-simple' ),
					array( 'fa-solid fa-fire-flame' => 'fire-flame' ),
					array( 'fa-solid fa-fire-hydrant' => 'fire-hydrant' ),
					array( 'fa-solid fa-fire-smoke' => 'fire-smoke' ),
					array( 'fa-solid fa-fire' => 'fire' ),
					array( 'fa-solid fa-fireplace' => 'fireplace' ),
					array( 'fa-solid fa-fish-bones' => 'fish-bones' ),
					array( 'fa-solid fa-fish-cooked' => 'fish-cooked' ),
					array( 'fa-solid fa-fish-fins' => 'fish-fins' ),
					array( 'fa-solid fa-fish' => 'fish' ),
					array( 'fa-solid fa-fishing-rod' => 'fishing-rod' ),
					array( 'fa-solid fa-flag-checkered' => 'flag-checkered' ),
					array( 'fa-solid fa-flag-pennant' => 'flag-pennant' ),
					array( 'fa-solid fa-flag-swallowtail' => 'flag-swallowtail' ),
					array( 'fa-solid fa-flag-usa' => 'flag-usa' ),
					array( 'fa-solid fa-flag' => 'flag' ),
					array( 'fa-solid fa-flashlight' => 'flashlight' ),
					array( 'fa-solid fa-flask-gear' => 'flask-gear' ),
					array( 'fa-solid fa-flask-round-poison' => 'flask-round-poison' ),
					array( 'fa-solid fa-flask-round-potion' => 'flask-round-potion' ),
					array( 'fa-solid fa-flask-vial' => 'flask-vial' ),
					array( 'fa-solid fa-flask' => 'flask' ),
					array( 'fa-solid fa-flatbread-stuffed' => 'flatbread-stuffed' ),
					array( 'fa-solid fa-flatbread' => 'flatbread' ),
					array( 'fa-solid fa-floppy-disk-circle-arrow-right' => 'floppy-disk-circle-arrow-right' ),
					array( 'fa-solid fa-floppy-disk-circle-xmark' => 'floppy-disk-circle-xmark' ),
					array( 'fa-solid fa-floppy-disk-pen' => 'floppy-disk-pen' ),
					array( 'fa-solid fa-floppy-disk' => 'floppy-disk' ),
					array( 'fa-solid fa-floppy-disks' => 'floppy-disks' ),
					array( 'fa-solid fa-florin-sign' => 'florin-sign' ),
					array( 'fa-solid fa-flower-daffodil' => 'flower-daffodil' ),
					array( 'fa-solid fa-flower-tulip' => 'flower-tulip' ),
					array( 'fa-solid fa-flower' => 'flower' ),
					array( 'fa-solid fa-flute' => 'flute' ),
					array( 'fa-solid fa-flux-capacitor' => 'flux-capacitor' ),
					array( 'fa-solid fa-flying-disc' => 'flying-disc' ),
					array( 'fa-solid fa-folder-arrow-down' => 'folder-arrow-down' ),
					array( 'fa-solid fa-folder-arrow-up' => 'folder-arrow-up' ),
					array( 'fa-solid fa-folder-bookmark' => 'folder-bookmark' ),
					array( 'fa-solid fa-folder-closed' => 'folder-closed' ),
					array( 'fa-solid fa-folder-gear' => 'folder-gear' ),
					array( 'fa-solid fa-folder-grid' => 'folder-grid' ),
					array( 'fa-solid fa-folder-heart' => 'folder-heart' ),
					array( 'fa-solid fa-folder-image' => 'folder-image' ),
					array( 'fa-solid fa-folder-magnifying-glass' => 'folder-magnifying-glass' ),
					array( 'fa-solid fa-folder-medical' => 'folder-medical' ),
					array( 'fa-solid fa-folder-minus' => 'folder-minus' ),
					array( 'fa-solid fa-folder-music' => 'folder-music' ),
					array( 'fa-solid fa-folder-open' => 'folder-open' ),
					array( 'fa-solid fa-folder-plus' => 'folder-plus' ),
					array( 'fa-solid fa-folder-tree' => 'folder-tree' ),
					array( 'fa-solid fa-folder-user' => 'folder-user' ),
					array( 'fa-solid fa-folder-xmark' => 'folder-xmark' ),
					array( 'fa-solid fa-folder' => 'folder' ),
					array( 'fa-solid fa-folders' => 'folders' ),
					array( 'fa-solid fa-fondue-pot' => 'fondue-pot' ),
					array( 'fa-solid fa-font-awesome' => 'font-awesome' ),
					array( 'fa-solid fa-font-case' => 'font-case' ),
					array( 'fa-solid fa-font' => 'font' ),
					array( 'fa-solid fa-football-helmet' => 'football-helmet' ),
					array( 'fa-solid fa-football' => 'football' ),
					array( 'fa-solid fa-fork-knife' => 'fork-knife' ),
					array( 'fa-solid fa-fork' => 'fork' ),
					array( 'fa-solid fa-forklift' => 'forklift' ),
					array( 'fa-solid fa-fort' => 'fort' ),
					array( 'fa-solid fa-forward-fast' => 'forward-fast' ),
					array( 'fa-solid fa-forward-step' => 'forward-step' ),
					array( 'fa-solid fa-forward' => 'forward' ),
					array( 'fa-solid fa-frame' => 'frame' ),
					array( 'fa-solid fa-franc-sign' => 'franc-sign' ),
					array( 'fa-solid fa-french-fries' => 'french-fries' ),
					array( 'fa-solid fa-frog' => 'frog' ),
					array( 'fa-solid fa-function' => 'function' ),
					array( 'fa-solid fa-futbol' => 'futbol' ),
					array( 'fa-solid fa-g' => 'g' ),
					array( 'fa-solid fa-galaxy' => 'galaxy' ),
					array( 'fa-solid fa-gallery-thumbnails' => 'gallery-thumbnails' ),
					array( 'fa-solid fa-game-board-simple' => 'game-board-simple' ),
					array( 'fa-solid fa-game-board' => 'game-board' ),
					array( 'fa-solid fa-game-console-handheld-crank' => 'game-console-handheld-crank' ),
					array( 'fa-solid fa-game-console-handheld' => 'game-console-handheld' ),
					array( 'fa-solid fa-gamepad-modern' => 'gamepad-modern' ),
					array( 'fa-solid fa-gamepad' => 'gamepad' ),
					array( 'fa-solid fa-garage-car' => 'garage-car' ),
					array( 'fa-solid fa-garage-open' => 'garage-open' ),
					array( 'fa-solid fa-garage' => 'garage' ),
					array( 'fa-solid fa-garlic' => 'garlic' ),
					array( 'fa-solid fa-gas-pump-slash' => 'gas-pump-slash' ),
					array( 'fa-solid fa-gas-pump' => 'gas-pump' ),
					array( 'fa-solid fa-gauge-circle-bolt' => 'gauge-circle-bolt' ),
					array( 'fa-solid fa-gauge-circle-minus' => 'gauge-circle-minus' ),
					array( 'fa-solid fa-gauge-circle-plus' => 'gauge-circle-plus' ),
					array( 'fa-solid fa-gauge-high' => 'gauge-high' ),
					array( 'fa-solid fa-gauge-low' => 'gauge-low' ),
					array( 'fa-solid fa-gauge-max' => 'gauge-max' ),
					array( 'fa-solid fa-gauge-min' => 'gauge-min' ),
					array( 'fa-solid fa-gauge-simple-high' => 'gauge-simple-high' ),
					array( 'fa-solid fa-gauge-simple-low' => 'gauge-simple-low' ),
					array( 'fa-solid fa-gauge-simple-max' => 'gauge-simple-max' ),
					array( 'fa-solid fa-gauge-simple-min' => 'gauge-simple-min' ),
					array( 'fa-solid fa-gauge-simple' => 'gauge-simple' ),
					array( 'fa-solid fa-gauge' => 'gauge' ),
					array( 'fa-solid fa-gavel' => 'gavel' ),
					array( 'fa-solid fa-gear-code' => 'gear-code' ),
					array( 'fa-solid fa-gear-complex-code' => 'gear-complex-code' ),
					array( 'fa-solid fa-gear-complex' => 'gear-complex' ),
					array( 'fa-solid fa-gear' => 'gear' ),
					array( 'fa-solid fa-gears' => 'gears' ),
					array( 'fa-solid fa-gem' => 'gem' ),
					array( 'fa-solid fa-genderless' => 'genderless' ),
					array( 'fa-solid fa-ghost' => 'ghost' ),
					array( 'fa-solid fa-gif' => 'gif' ),
					array( 'fa-solid fa-gift-card' => 'gift-card' ),
					array( 'fa-solid fa-gift' => 'gift' ),
					array( 'fa-solid fa-gifts' => 'gifts' ),
					array( 'fa-solid fa-gingerbread-man' => 'gingerbread-man' ),
					array( 'fa-solid fa-glass-citrus' => 'glass-citrus' ),
					array( 'fa-solid fa-glass-empty' => 'glass-empty' ),
					array( 'fa-solid fa-glass-half' => 'glass-half' ),
					array( 'fa-solid fa-glass-water-droplet' => 'glass-water-droplet' ),
					array( 'fa-solid fa-glass-water' => 'glass-water' ),
					array( 'fa-solid fa-glass' => 'glass' ),
					array( 'fa-solid fa-glasses-round' => 'glasses-round' ),
					array( 'fa-solid fa-glasses' => 'glasses' ),
					array( 'fa-solid fa-globe-pointer' => 'globe-pointer' ),
					array( 'fa-solid fa-globe-snow' => 'globe-snow' ),
					array( 'fa-solid fa-globe-stand' => 'globe-stand' ),
					array( 'fa-solid fa-globe' => 'globe' ),
					array( 'fa-solid fa-goal-net' => 'goal-net' ),
					array( 'fa-solid fa-golf-ball-tee' => 'golf-ball-tee' ),
					array( 'fa-solid fa-golf-club' => 'golf-club' ),
					array( 'fa-solid fa-golf-flag-hole' => 'golf-flag-hole' ),
					array( 'fa-solid fa-gopuram' => 'gopuram' ),
					array( 'fa-solid fa-graduation-cap' => 'graduation-cap' ),
					array( 'fa-solid fa-gramophone' => 'gramophone' ),
					array( 'fa-solid fa-grapes' => 'grapes' ),
					array( 'fa-solid fa-grate-droplet' => 'grate-droplet' ),
					array( 'fa-solid fa-grate' => 'grate' ),
					array( 'fa-solid fa-greater-than-equal' => 'greater-than-equal' ),
					array( 'fa-solid fa-greater-than' => 'greater-than' ),
					array( 'fa-solid fa-grid-2-plus' => 'grid-2-plus' ),
					array( 'fa-solid fa-grid-2' => 'grid-2' ),
					array( 'fa-solid fa-grid-4' => 'grid-4' ),
					array( 'fa-solid fa-grid-5' => 'grid-5' ),
					array( 'fa-solid fa-grid-dividers' => 'grid-dividers' ),
					array( 'fa-solid fa-grid-horizontal' => 'grid-horizontal' ),
					array( 'fa-solid fa-grid-round-2-plus' => 'grid-round-2-plus' ),
					array( 'fa-solid fa-grid-round-2' => 'grid-round-2' ),
					array( 'fa-solid fa-grid-round-4' => 'grid-round-4' ),
					array( 'fa-solid fa-grid-round-5' => 'grid-round-5' ),
					array( 'fa-solid fa-grid-round' => 'grid-round' ),
					array( 'fa-solid fa-grid' => 'grid' ),
					array( 'fa-solid fa-grill-fire' => 'grill-fire' ),
					array( 'fa-solid fa-grill-hot' => 'grill-hot' ),
					array( 'fa-solid fa-grill' => 'grill' ),
					array( 'fa-solid fa-grip-dots-vertical' => 'grip-dots-vertical' ),
					array( 'fa-solid fa-grip-dots' => 'grip-dots' ),
					array( 'fa-solid fa-grip-lines-vertical' => 'grip-lines-vertical' ),
					array( 'fa-solid fa-grip-lines' => 'grip-lines' ),
					array( 'fa-solid fa-grip-vertical' => 'grip-vertical' ),
					array( 'fa-solid fa-grip' => 'grip' ),
					array( 'fa-solid fa-group-arrows-rotate' => 'group-arrows-rotate' ),
					array( 'fa-solid fa-guarani-sign' => 'guarani-sign' ),
					array( 'fa-solid fa-guitar-electric' => 'guitar-electric' ),
					array( 'fa-solid fa-guitar' => 'guitar' ),
					array( 'fa-solid fa-guitars' => 'guitars' ),
					array( 'fa-solid fa-gun-slash' => 'gun-slash' ),
					array( 'fa-solid fa-gun-squirt' => 'gun-squirt' ),
					array( 'fa-solid fa-gun' => 'gun' ),
					array( 'fa-solid fa-h' => 'h' ),
					array( 'fa-solid fa-h1' => 'h1' ),
					array( 'fa-solid fa-h2' => 'h2' ),
					array( 'fa-solid fa-h3' => 'h3' ),
					array( 'fa-solid fa-h4' => 'h4' ),
					array( 'fa-solid fa-h5' => 'h5' ),
					array( 'fa-solid fa-h6' => 'h6' ),
					array( 'fa-solid fa-hammer-crash' => 'hammer-crash' ),
					array( 'fa-solid fa-hammer-war' => 'hammer-war' ),
					array( 'fa-solid fa-hammer' => 'hammer' ),
					array( 'fa-solid fa-hamsa' => 'hamsa' ),
					array( 'fa-solid fa-hand-back-fist' => 'hand-back-fist' ),
					array( 'fa-solid fa-hand-back-point-down' => 'hand-back-point-down' ),
					array( 'fa-solid fa-hand-back-point-left' => 'hand-back-point-left' ),
					array( 'fa-solid fa-hand-back-point-ribbon' => 'hand-back-point-ribbon' ),
					array( 'fa-solid fa-hand-back-point-right' => 'hand-back-point-right' ),
					array( 'fa-solid fa-hand-back-point-up' => 'hand-back-point-up' ),
					array( 'fa-solid fa-hand-dots' => 'hand-dots' ),
					array( 'fa-solid fa-hand-fingers-crossed' => 'hand-fingers-crossed' ),
					array( 'fa-solid fa-hand-fist' => 'hand-fist' ),
					array( 'fa-solid fa-hand-heart' => 'hand-heart' ),
					array( 'fa-solid fa-hand-holding-box' => 'hand-holding-box' ),
					array( 'fa-solid fa-hand-holding-dollar' => 'hand-holding-dollar' ),
					array( 'fa-solid fa-hand-holding-droplet' => 'hand-holding-droplet' ),
					array( 'fa-solid fa-hand-holding-hand' => 'hand-holding-hand' ),
					array( 'fa-solid fa-hand-holding-heart' => 'hand-holding-heart' ),
					array( 'fa-solid fa-hand-holding-magic' => 'hand-holding-magic' ),
					array( 'fa-solid fa-hand-holding-medical' => 'hand-holding-medical' ),
					array( 'fa-solid fa-hand-holding-seedling' => 'hand-holding-seedling' ),
					array( 'fa-solid fa-hand-holding-skull' => 'hand-holding-skull' ),
					array( 'fa-solid fa-hand-holding' => 'hand-holding' ),
					array( 'fa-solid fa-hand-horns' => 'hand-horns' ),
					array( 'fa-solid fa-hand-lizard' => 'hand-lizard' ),
					array( 'fa-solid fa-hand-love' => 'hand-love' ),
					array( 'fa-solid fa-hand-middle-finger' => 'hand-middle-finger' ),
					array( 'fa-solid fa-hand-peace' => 'hand-peace' ),
					array( 'fa-solid fa-hand-point-down' => 'hand-point-down' ),
					array( 'fa-solid fa-hand-point-left' => 'hand-point-left' ),
					array( 'fa-solid fa-hand-point-ribbon' => 'hand-point-ribbon' ),
					array( 'fa-solid fa-hand-point-right' => 'hand-point-right' ),
					array( 'fa-solid fa-hand-point-up' => 'hand-point-up' ),
					array( 'fa-solid fa-hand-pointer' => 'hand-pointer' ),
					array( 'fa-solid fa-hand-scissors' => 'hand-scissors' ),
					array( 'fa-solid fa-hand-sparkles' => 'hand-sparkles' ),
					array( 'fa-solid fa-hand-spock' => 'hand-spock' ),
					array( 'fa-solid fa-hand-wave' => 'hand-wave' ),
					array( 'fa-solid fa-hand' => 'hand' ),
					array( 'fa-solid fa-handcuffs' => 'handcuffs' ),
					array( 'fa-solid fa-hands-asl-interpreting' => 'hands-asl-interpreting' ),
					array( 'fa-solid fa-hands-bound' => 'hands-bound' ),
					array( 'fa-solid fa-hands-bubbles' => 'hands-bubbles' ),
					array( 'fa-solid fa-hands-clapping' => 'hands-clapping' ),
					array( 'fa-solid fa-hands-holding-child' => 'hands-holding-child' ),
					array( 'fa-solid fa-hands-holding-circle' => 'hands-holding-circle' ),
					array( 'fa-solid fa-hands-holding-diamond' => 'hands-holding-diamond' ),
					array( 'fa-solid fa-hands-holding-dollar' => 'hands-holding-dollar' ),
					array( 'fa-solid fa-hands-holding-heart' => 'hands-holding-heart' ),
					array( 'fa-solid fa-hands-holding' => 'hands-holding' ),
					array( 'fa-solid fa-hands-praying' => 'hands-praying' ),
					array( 'fa-solid fa-hands' => 'hands' ),
					array( 'fa-solid fa-handshake-angle' => 'handshake-angle' ),
					array( 'fa-solid fa-handshake-simple-slash' => 'handshake-simple-slash' ),
					array( 'fa-solid fa-handshake-simple' => 'handshake-simple' ),
					array( 'fa-solid fa-handshake-slash' => 'handshake-slash' ),
					array( 'fa-solid fa-handshake' => 'handshake' ),
					array( 'fa-solid fa-hanukiah' => 'hanukiah' ),
					array( 'fa-solid fa-hard-drive' => 'hard-drive' ),
					array( 'fa-solid fa-hashtag-lock' => 'hashtag-lock' ),
					array( 'fa-solid fa-hashtag' => 'hashtag' ),
					array( 'fa-solid fa-hat-beach' => 'hat-beach' ),
					array( 'fa-solid fa-hat-chef' => 'hat-chef' ),
					array( 'fa-solid fa-hat-cowboy-side' => 'hat-cowboy-side' ),
					array( 'fa-solid fa-hat-cowboy' => 'hat-cowboy' ),
					array( 'fa-solid fa-hat-santa' => 'hat-santa' ),
					array( 'fa-solid fa-hat-winter' => 'hat-winter' ),
					array( 'fa-solid fa-hat-witch' => 'hat-witch' ),
					array( 'fa-solid fa-hat-wizard' => 'hat-wizard' ),
					array( 'fa-solid fa-head-side-brain' => 'head-side-brain' ),
					array( 'fa-solid fa-head-side-cough-slash' => 'head-side-cough-slash' ),
					array( 'fa-solid fa-head-side-cough' => 'head-side-cough' ),
					array( 'fa-solid fa-head-side-gear' => 'head-side-gear' ),
					array( 'fa-solid fa-head-side-goggles' => 'head-side-goggles' ),
					array( 'fa-solid fa-head-side-headphones' => 'head-side-headphones' ),
					array( 'fa-solid fa-head-side-heart' => 'head-side-heart' ),
					array( 'fa-solid fa-head-side-mask' => 'head-side-mask' ),
					array( 'fa-solid fa-head-side-medical' => 'head-side-medical' ),
					array( 'fa-solid fa-head-side-virus' => 'head-side-virus' ),
					array( 'fa-solid fa-head-side' => 'head-side' ),
					array( 'fa-solid fa-heading' => 'heading' ),
					array( 'fa-solid fa-headphones-simple' => 'headphones-simple' ),
					array( 'fa-solid fa-headphones' => 'headphones' ),
					array( 'fa-solid fa-headset' => 'headset' ),
					array( 'fa-solid fa-heart-circle-bolt' => 'heart-circle-bolt' ),
					array( 'fa-solid fa-heart-circle-check' => 'heart-circle-check' ),
					array( 'fa-solid fa-heart-circle-exclamation' => 'heart-circle-exclamation' ),
					array( 'fa-solid fa-heart-circle-minus' => 'heart-circle-minus' ),
					array( 'fa-solid fa-heart-circle-plus' => 'heart-circle-plus' ),
					array( 'fa-solid fa-heart-circle-xmark' => 'heart-circle-xmark' ),
					array( 'fa-solid fa-heart-crack' => 'heart-crack' ),
					array( 'fa-solid fa-heart-half-stroke' => 'heart-half-stroke' ),
					array( 'fa-solid fa-heart-half' => 'heart-half' ),
					array( 'fa-solid fa-heart-pulse' => 'heart-pulse' ),
					array( 'fa-solid fa-heart' => 'heart' ),
					array( 'fa-solid fa-heat' => 'heat' ),
					array( 'fa-solid fa-helicopter-symbol' => 'helicopter-symbol' ),
					array( 'fa-solid fa-helicopter' => 'helicopter' ),
					array( 'fa-solid fa-helmet-battle' => 'helmet-battle' ),
					array( 'fa-solid fa-helmet-safety' => 'helmet-safety' ),
					array( 'fa-solid fa-helmet-un' => 'helmet-un' ),
					array( 'fa-solid fa-hexagon-check' => 'hexagon-check' ),
					array( 'fa-solid fa-hexagon-divide' => 'hexagon-divide' ),
					array( 'fa-solid fa-hexagon-exclamation' => 'hexagon-exclamation' ),
					array( 'fa-solid fa-hexagon-image' => 'hexagon-image' ),
					array( 'fa-solid fa-hexagon-minus' => 'hexagon-minus' ),
					array( 'fa-solid fa-hexagon-plus' => 'hexagon-plus' ),
					array( 'fa-solid fa-hexagon-vertical-nft-slanted' => 'hexagon-vertical-nft-slanted' ),
					array( 'fa-solid fa-hexagon-vertical-nft' => 'hexagon-vertical-nft' ),
					array( 'fa-solid fa-hexagon-xmark' => 'hexagon-xmark' ),
					array( 'fa-solid fa-hexagon' => 'hexagon' ),
					array( 'fa-solid fa-high-definition' => 'high-definition' ),
					array( 'fa-solid fa-highlighter-line' => 'highlighter-line' ),
					array( 'fa-solid fa-highlighter' => 'highlighter' ),
					array( 'fa-solid fa-hill-avalanche' => 'hill-avalanche' ),
					array( 'fa-solid fa-hill-rockslide' => 'hill-rockslide' ),
					array( 'fa-solid fa-hippo' => 'hippo' ),
					array( 'fa-solid fa-hockey-mask' => 'hockey-mask' ),
					array( 'fa-solid fa-hockey-puck' => 'hockey-puck' ),
					array( 'fa-solid fa-hockey-stick-puck' => 'hockey-stick-puck' ),
					array( 'fa-solid fa-hockey-sticks' => 'hockey-sticks' ),
					array( 'fa-solid fa-holly-berry' => 'holly-berry' ),
					array( 'fa-solid fa-honey-pot' => 'honey-pot' ),
					array( 'fa-solid fa-hood-cloak' => 'hood-cloak' ),
					array( 'fa-solid fa-horizontal-rule' => 'horizontal-rule' ),
					array( 'fa-solid fa-horse-head' => 'horse-head' ),
					array( 'fa-solid fa-horse-saddle' => 'horse-saddle' ),
					array( 'fa-solid fa-horse' => 'horse' ),
					array( 'fa-solid fa-hose-reel' => 'hose-reel' ),
					array( 'fa-solid fa-hose' => 'hose' ),
					array( 'fa-solid fa-hospital-user' => 'hospital-user' ),
					array( 'fa-solid fa-hospital' => 'hospital' ),
					array( 'fa-solid fa-hospitals' => 'hospitals' ),
					array( 'fa-solid fa-hot-tub-person' => 'hot-tub-person' ),
					array( 'fa-solid fa-hotdog' => 'hotdog' ),
					array( 'fa-solid fa-hotel' => 'hotel' ),
					array( 'fa-solid fa-hourglass-clock' => 'hourglass-clock' ),
					array( 'fa-solid fa-hourglass-end' => 'hourglass-end' ),
					array( 'fa-solid fa-hourglass-half' => 'hourglass-half' ),
					array( 'fa-solid fa-hourglass-start' => 'hourglass-start' ),
					array( 'fa-solid fa-hourglass' => 'hourglass' ),
					array( 'fa-solid fa-house-blank' => 'house-blank' ),
					array( 'fa-solid fa-house-building' => 'house-building' ),
					array( 'fa-solid fa-house-chimney-blank' => 'house-chimney-blank' ),
					array( 'fa-solid fa-house-chimney-crack' => 'house-chimney-crack' ),
					array( 'fa-solid fa-house-chimney-heart' => 'house-chimney-heart' ),
					array( 'fa-solid fa-house-chimney-medical' => 'house-chimney-medical' ),
					array( 'fa-solid fa-house-chimney-user' => 'house-chimney-user' ),
					array( 'fa-solid fa-house-chimney-window' => 'house-chimney-window' ),
					array( 'fa-solid fa-house-chimney' => 'house-chimney' ),
					array( 'fa-solid fa-house-circle-check' => 'house-circle-check' ),
					array( 'fa-solid fa-house-circle-exclamation' => 'house-circle-exclamation' ),
					array( 'fa-solid fa-house-circle-xmark' => 'house-circle-xmark' ),
					array( 'fa-solid fa-house-crack' => 'house-crack' ),
					array( 'fa-solid fa-house-day' => 'house-day' ),
					array( 'fa-solid fa-house-fire' => 'house-fire' ),
					array( 'fa-solid fa-house-flag' => 'house-flag' ),
					array( 'fa-solid fa-house-flood-water-circle-arrow-right' => 'house-flood-water-circle-arrow-right' ),
					array( 'fa-solid fa-house-flood-water' => 'house-flood-water' ),
					array( 'fa-solid fa-house-heart' => 'house-heart' ),
					array( 'fa-solid fa-house-laptop' => 'house-laptop' ),
					array( 'fa-solid fa-house-lock' => 'house-lock' ),
					array( 'fa-solid fa-house-medical-circle-check' => 'house-medical-circle-check' ),
					array( 'fa-solid fa-house-medical-circle-exclamation' => 'house-medical-circle-exclamation' ),
					array( 'fa-solid fa-house-medical-circle-xmark' => 'house-medical-circle-xmark' ),
					array( 'fa-solid fa-house-medical-flag' => 'house-medical-flag' ),
					array( 'fa-solid fa-house-medical' => 'house-medical' ),
					array( 'fa-solid fa-house-night' => 'house-night' ),
					array( 'fa-solid fa-house-person-leave' => 'house-person-leave' ),
					array( 'fa-solid fa-house-person-return' => 'house-person-return' ),
					array( 'fa-solid fa-house-signal' => 'house-signal' ),
					array( 'fa-solid fa-house-tree' => 'house-tree' ),
					array( 'fa-solid fa-house-tsunami' => 'house-tsunami' ),
					array( 'fa-solid fa-house-turret' => 'house-turret' ),
					array( 'fa-solid fa-house-user' => 'house-user' ),
					array( 'fa-solid fa-house-water' => 'house-water' ),
					array( 'fa-solid fa-house-window' => 'house-window' ),
					array( 'fa-solid fa-house' => 'house' ),
					array( 'fa-solid fa-hryvnia-sign' => 'hryvnia-sign' ),
					array( 'fa-solid fa-hundred-points' => 'hundred-points' ),
					array( 'fa-solid fa-hurricane' => 'hurricane' ),
					array( 'fa-solid fa-hyphen' => 'hyphen' ),
					array( 'fa-solid fa-i-cursor' => 'i-cursor' ),
					array( 'fa-solid fa-i' => 'i' ),
					array( 'fa-solid fa-ice-cream' => 'ice-cream' ),
					array( 'fa-solid fa-ice-skate' => 'ice-skate' ),
					array( 'fa-solid fa-icicles' => 'icicles' ),
					array( 'fa-solid fa-icons' => 'icons' ),
					array( 'fa-solid fa-id-badge' => 'id-badge' ),
					array( 'fa-solid fa-id-card-clip' => 'id-card-clip' ),
					array( 'fa-solid fa-id-card' => 'id-card' ),
					array( 'fa-solid fa-igloo' => 'igloo' ),
					array( 'fa-solid fa-image-landscape' => 'image-landscape' ),
					array( 'fa-solid fa-image-polaroid-user' => 'image-polaroid-user' ),
					array( 'fa-solid fa-image-polaroid' => 'image-polaroid' ),
					array( 'fa-solid fa-image-portrait' => 'image-portrait' ),
					array( 'fa-solid fa-image-slash' => 'image-slash' ),
					array( 'fa-solid fa-image-user' => 'image-user' ),
					array( 'fa-solid fa-image' => 'image' ),
					array( 'fa-solid fa-images-user' => 'images-user' ),
					array( 'fa-solid fa-images' => 'images' ),
					array( 'fa-solid fa-inbox-full' => 'inbox-full' ),
					array( 'fa-solid fa-inbox-in' => 'inbox-in' ),
					array( 'fa-solid fa-inbox-out' => 'inbox-out' ),
					array( 'fa-solid fa-inbox' => 'inbox' ),
					array( 'fa-solid fa-inboxes' => 'inboxes' ),
					array( 'fa-solid fa-indent' => 'indent' ),
					array( 'fa-solid fa-indian-rupee-sign' => 'indian-rupee-sign' ),
					array( 'fa-solid fa-industry-windows' => 'industry-windows' ),
					array( 'fa-solid fa-industry' => 'industry' ),
					array( 'fa-solid fa-infinity' => 'infinity' ),
					array( 'fa-solid fa-info' => 'info' ),
					array( 'fa-solid fa-inhaler' => 'inhaler' ),
					array( 'fa-solid fa-input-numeric' => 'input-numeric' ),
					array( 'fa-solid fa-input-pipe' => 'input-pipe' ),
					array( 'fa-solid fa-input-text' => 'input-text' ),
					array( 'fa-solid fa-integral' => 'integral' ),
					array( 'fa-solid fa-interrobang' => 'interrobang' ),
					array( 'fa-solid fa-intersection' => 'intersection' ),
					array( 'fa-solid fa-island-tropical' => 'island-tropical' ),
					array( 'fa-solid fa-italic' => 'italic' ),
					array( 'fa-solid fa-j' => 'j' ),
					array( 'fa-solid fa-jack-o-lantern' => 'jack-o-lantern' ),
					array( 'fa-solid fa-jar-wheat' => 'jar-wheat' ),
					array( 'fa-solid fa-jar' => 'jar' ),
					array( 'fa-solid fa-jedi' => 'jedi' ),
					array( 'fa-solid fa-jet-fighter-up' => 'jet-fighter-up' ),
					array( 'fa-solid fa-jet-fighter' => 'jet-fighter' ),
					array( 'fa-solid fa-joint' => 'joint' ),
					array( 'fa-solid fa-joystick' => 'joystick' ),
					array( 'fa-solid fa-jug-bottle' => 'jug-bottle' ),
					array( 'fa-solid fa-jug-detergent' => 'jug-detergent' ),
					array( 'fa-solid fa-jug' => 'jug' ),
					array( 'fa-solid fa-k' => 'k' ),
					array( 'fa-solid fa-kaaba' => 'kaaba' ),
					array( 'fa-solid fa-kazoo' => 'kazoo' ),
					array( 'fa-solid fa-kerning' => 'kerning' ),
					array( 'fa-solid fa-key-skeleton-left-right' => 'key-skeleton-left-right' ),
					array( 'fa-solid fa-key-skeleton' => 'key-skeleton' ),
					array( 'fa-solid fa-key' => 'key' ),
					array( 'fa-solid fa-keyboard-brightness-low' => 'keyboard-brightness-low' ),
					array( 'fa-solid fa-keyboard-brightness' => 'keyboard-brightness' ),
					array( 'fa-solid fa-keyboard-down' => 'keyboard-down' ),
					array( 'fa-solid fa-keyboard-left' => 'keyboard-left' ),
					array( 'fa-solid fa-keyboard' => 'keyboard' ),
					array( 'fa-solid fa-keynote' => 'keynote' ),
					array( 'fa-solid fa-khanda' => 'khanda' ),
					array( 'fa-solid fa-kidneys' => 'kidneys' ),
					array( 'fa-solid fa-kip-sign' => 'kip-sign' ),
					array( 'fa-solid fa-kit-medical' => 'kit-medical' ),
					array( 'fa-solid fa-kitchen-set' => 'kitchen-set' ),
					array( 'fa-solid fa-kite' => 'kite' ),
					array( 'fa-solid fa-kiwi-bird' => 'kiwi-bird' ),
					array( 'fa-solid fa-kiwi-fruit' => 'kiwi-fruit' ),
					array( 'fa-solid fa-knife-kitchen' => 'knife-kitchen' ),
					array( 'fa-solid fa-knife' => 'knife' ),
					array( 'fa-solid fa-l' => 'l' ),
					array( 'fa-solid fa-lacrosse-stick-ball' => 'lacrosse-stick-ball' ),
					array( 'fa-solid fa-lacrosse-stick' => 'lacrosse-stick' ),
					array( 'fa-solid fa-lambda' => 'lambda' ),
					array( 'fa-solid fa-lamp-desk' => 'lamp-desk' ),
					array( 'fa-solid fa-lamp-floor' => 'lamp-floor' ),
					array( 'fa-solid fa-lamp-street' => 'lamp-street' ),
					array( 'fa-solid fa-lamp' => 'lamp' ),
					array( 'fa-solid fa-land-mine-on' => 'land-mine-on' ),
					array( 'fa-solid fa-landmark-dome' => 'landmark-dome' ),
					array( 'fa-solid fa-landmark-flag' => 'landmark-flag' ),
					array( 'fa-solid fa-landmark' => 'landmark' ),
					array( 'fa-solid fa-language' => 'language' ),
					array( 'fa-solid fa-laptop-arrow-down' => 'laptop-arrow-down' ),
					array( 'fa-solid fa-laptop-binary' => 'laptop-binary' ),
					array( 'fa-solid fa-laptop-code' => 'laptop-code' ),
					array( 'fa-solid fa-laptop-file' => 'laptop-file' ),
					array( 'fa-solid fa-laptop-medical' => 'laptop-medical' ),
					array( 'fa-solid fa-laptop-mobile' => 'laptop-mobile' ),
					array( 'fa-solid fa-laptop-slash' => 'laptop-slash' ),
					array( 'fa-solid fa-laptop' => 'laptop' ),
					array( 'fa-solid fa-lari-sign' => 'lari-sign' ),
					array( 'fa-solid fa-lasso-sparkles' => 'lasso-sparkles' ),
					array( 'fa-solid fa-lasso' => 'lasso' ),
					array( 'fa-solid fa-layer-group' => 'layer-group' ),
					array( 'fa-solid fa-layer-minus' => 'layer-minus' ),
					array( 'fa-solid fa-layer-plus' => 'layer-plus' ),
					array( 'fa-solid fa-leaf-heart' => 'leaf-heart' ),
					array( 'fa-solid fa-leaf-maple' => 'leaf-maple' ),
					array( 'fa-solid fa-leaf-oak' => 'leaf-oak' ),
					array( 'fa-solid fa-leaf' => 'leaf' ),
					array( 'fa-solid fa-leafy-green' => 'leafy-green' ),
					array( 'fa-solid fa-left-from-line' => 'left-from-line' ),
					array( 'fa-solid fa-left-long-to-line' => 'left-long-to-line' ),
					array( 'fa-solid fa-left-long' => 'left-long' ),
					array( 'fa-solid fa-left-right' => 'left-right' ),
					array( 'fa-solid fa-left-to-line' => 'left-to-line' ),
					array( 'fa-solid fa-left' => 'left' ),
					array( 'fa-solid fa-lemon' => 'lemon' ),
					array( 'fa-solid fa-less-than-equal' => 'less-than-equal' ),
					array( 'fa-solid fa-less-than' => 'less-than' ),
					array( 'fa-solid fa-life-ring' => 'life-ring' ),
					array( 'fa-solid fa-light-ceiling' => 'light-ceiling' ),
					array( 'fa-solid fa-light-emergency-on' => 'light-emergency-on' ),
					array( 'fa-solid fa-light-emergency' => 'light-emergency' ),
					array( 'fa-solid fa-light-switch-off' => 'light-switch-off' ),
					array( 'fa-solid fa-light-switch-on' => 'light-switch-on' ),
					array( 'fa-solid fa-light-switch' => 'light-switch' ),
					array( 'fa-solid fa-lightbulb-cfl-on' => 'lightbulb-cfl-on' ),
					array( 'fa-solid fa-lightbulb-cfl' => 'lightbulb-cfl' ),
					array( 'fa-solid fa-lightbulb-dollar' => 'lightbulb-dollar' ),
					array( 'fa-solid fa-lightbulb-exclamatin-on' => 'lightbulb-exclamatin-on' ),
					array( 'fa-solid fa-lightbulb-exclamation' => 'lightbulb-exclamation' ),
					array( 'fa-solid fa-lightbulb-gear' => 'lightbulb-gear' ),
					array( 'fa-solid fa-lightbulb-on' => 'lightbulb-on' ),
					array( 'fa-solid fa-lightbulb-slash' => 'lightbulb-slash' ),
					array( 'fa-solid fa-lightbulb' => 'lightbulb' ),
					array( 'fa-solid fa-lighthouse' => 'lighthouse' ),
					array( 'fa-solid fa-lights-holiday' => 'lights-holiday' ),
					array( 'fa-solid fa-line-columns' => 'line-columns' ),
					array( 'fa-solid fa-line-height' => 'line-height' ),
					array( 'fa-solid fa-lines-leaning' => 'lines-leaning' ),
					array( 'fa-solid fa-link-horizontal-slash' => 'link-horizontal-slash' ),
					array( 'fa-solid fa-link-horizontal' => 'link-horizontal' ),
					array( 'fa-solid fa-link-simple-slash' => 'link-simple-slash' ),
					array( 'fa-solid fa-link-simple' => 'link-simple' ),
					array( 'fa-solid fa-link-slash' => 'link-slash' ),
					array( 'fa-solid fa-link' => 'link' ),
					array( 'fa-solid fa-lips' => 'lips' ),
					array( 'fa-solid fa-lira-sign' => 'lira-sign' ),
					array( 'fa-solid fa-list-check' => 'list-check' ),
					array( 'fa-solid fa-list-dropdown' => 'list-dropdown' ),
					array( 'fa-solid fa-list-music' => 'list-music' ),
					array( 'fa-solid fa-list-ol' => 'list-ol' ),
					array( 'fa-solid fa-list-radio' => 'list-radio' ),
					array( 'fa-solid fa-list-timeline' => 'list-timeline' ),
					array( 'fa-solid fa-list-tree' => 'list-tree' ),
					array( 'fa-solid fa-list-ul' => 'list-ul' ),
					array( 'fa-solid fa-list' => 'list' ),
					array( 'fa-solid fa-litecoin-sign' => 'litecoin-sign' ),
					array( 'fa-solid fa-loader' => 'loader' ),
					array( 'fa-solid fa-lobster' => 'lobster' ),
					array( 'fa-solid fa-location-arrow' => 'location-arrow' ),
					array( 'fa-solid fa-location-check' => 'location-check' ),
					array( 'fa-solid fa-location-crosshairs-slash' => 'location-crosshairs-slash' ),
					array( 'fa-solid fa-location-crosshairs' => 'location-crosshairs' ),
					array( 'fa-solid fa-location-dot-slash' => 'location-dot-slash' ),
					array( 'fa-solid fa-location-dot' => 'location-dot' ),
					array( 'fa-solid fa-location-exclamation' => 'location-exclamation' ),
					array( 'fa-solid fa-location-minus' => 'location-minus' ),
					array( 'fa-solid fa-location-pen' => 'location-pen' ),
					array( 'fa-solid fa-location-pin-lock' => 'location-pin-lock' ),
					array( 'fa-solid fa-location-pin-slash' => 'location-pin-slash' ),
					array( 'fa-solid fa-location-pin' => 'location-pin' ),
					array( 'fa-solid fa-location-plus' => 'location-plus' ),
					array( 'fa-solid fa-location-question' => 'location-question' ),
					array( 'fa-solid fa-location-smile' => 'location-smile' ),
					array( 'fa-solid fa-location-xmark' => 'location-xmark' ),
					array( 'fa-solid fa-lock-a' => 'lock-a' ),
					array( 'fa-solid fa-lock-hashtag' => 'lock-hashtag' ),
					array( 'fa-solid fa-lock-keyhole-open' => 'lock-keyhole-open' ),
					array( 'fa-solid fa-lock-keyhole' => 'lock-keyhole' ),
					array( 'fa-solid fa-lock-open' => 'lock-open' ),
					array( 'fa-solid fa-lock' => 'lock' ),
					array( 'fa-solid fa-locust' => 'locust' ),
					array( 'fa-solid fa-lollipop' => 'lollipop' ),
					array( 'fa-solid fa-loveseat' => 'loveseat' ),
					array( 'fa-solid fa-luchador-mask' => 'luchador-mask' ),
					array( 'fa-solid fa-lungs-virus' => 'lungs-virus' ),
					array( 'fa-solid fa-lungs' => 'lungs' ),
					array( 'fa-solid fa-m' => 'm' ),
					array( 'fa-solid fa-mace' => 'mace' ),
					array( 'fa-solid fa-magnet' => 'magnet' ),
					array( 'fa-solid fa-magnifying-glass-arrow-right' => 'magnifying-glass-arrow-right' ),
					array( 'fa-solid fa-magnifying-glass-chart' => 'magnifying-glass-chart' ),
					array( 'fa-solid fa-magnifying-glass-dollar' => 'magnifying-glass-dollar' ),
					array( 'fa-solid fa-magnifying-glass-location' => 'magnifying-glass-location' ),
					array( 'fa-solid fa-magnifying-glass-minus' => 'magnifying-glass-minus' ),
					array( 'fa-solid fa-magnifying-glass-plus' => 'magnifying-glass-plus' ),
					array( 'fa-solid fa-magnifying-glass' => 'magnifying-glass' ),
					array( 'fa-solid fa-mailbox-flag-up' => 'mailbox-flag-up' ),
					array( 'fa-solid fa-mailbox' => 'mailbox' ),
					array( 'fa-solid fa-manat-sign' => 'manat-sign' ),
					array( 'fa-solid fa-mandolin' => 'mandolin' ),
					array( 'fa-solid fa-mango' => 'mango' ),
					array( 'fa-solid fa-manhole' => 'manhole' ),
					array( 'fa-solid fa-map-location-dot' => 'map-location-dot' ),
					array( 'fa-solid fa-map-location' => 'map-location' ),
					array( 'fa-solid fa-map-pin' => 'map-pin' ),
					array( 'fa-solid fa-map' => 'map' ),
					array( 'fa-solid fa-marker' => 'marker' ),
					array( 'fa-solid fa-mars-and-venus-burst' => 'mars-and-venus-burst' ),
					array( 'fa-solid fa-mars-and-venus' => 'mars-and-venus' ),
					array( 'fa-solid fa-mars-double' => 'mars-double' ),
					array( 'fa-solid fa-mars-stroke-right' => 'mars-stroke-right' ),
					array( 'fa-solid fa-mars-stroke-up' => 'mars-stroke-up' ),
					array( 'fa-solid fa-mars-stroke' => 'mars-stroke' ),
					array( 'fa-solid fa-mars' => 'mars' ),
					array( 'fa-solid fa-martini-glass-citrus' => 'martini-glass-citrus' ),
					array( 'fa-solid fa-martini-glass-empty' => 'martini-glass-empty' ),
					array( 'fa-solid fa-martini-glass' => 'martini-glass' ),
					array( 'fa-solid fa-mask-face' => 'mask-face' ),
					array( 'fa-solid fa-mask-snorkel' => 'mask-snorkel' ),
					array( 'fa-solid fa-mask-ventilator' => 'mask-ventilator' ),
					array( 'fa-solid fa-mask' => 'mask' ),
					array( 'fa-solid fa-masks-theater' => 'masks-theater' ),
					array( 'fa-solid fa-mattress-pillow' => 'mattress-pillow' ),
					array( 'fa-solid fa-maximize' => 'maximize' ),
					array( 'fa-solid fa-meat' => 'meat' ),
					array( 'fa-solid fa-medal' => 'medal' ),
					array( 'fa-solid fa-megaphone' => 'megaphone' ),
					array( 'fa-solid fa-melon-slice' => 'melon-slice' ),
					array( 'fa-solid fa-melon' => 'melon' ),
					array( 'fa-solid fa-memo-circle-check' => 'memo-circle-check' ),
					array( 'fa-solid fa-memo-circle-info' => 'memo-circle-info' ),
					array( 'fa-solid fa-memo-pad' => 'memo-pad' ),
					array( 'fa-solid fa-memo' => 'memo' ),
					array( 'fa-solid fa-memory' => 'memory' ),
					array( 'fa-solid fa-menorah' => 'menorah' ),
					array( 'fa-solid fa-mercury' => 'mercury' ),
					array( 'fa-solid fa-merge' => 'merge' ),
					array( 'fa-solid fa-message-arrow-down' => 'message-arrow-down' ),
					array( 'fa-solid fa-message-arrow-up-right' => 'message-arrow-up-right' ),
					array( 'fa-solid fa-message-arrow-up' => 'message-arrow-up' ),
					array( 'fa-solid fa-message-bot' => 'message-bot' ),
					array( 'fa-solid fa-message-captions' => 'message-captions' ),
					array( 'fa-solid fa-message-check' => 'message-check' ),
					array( 'fa-solid fa-message-code' => 'message-code' ),
					array( 'fa-solid fa-message-dollar' => 'message-dollar' ),
					array( 'fa-solid fa-message-dots' => 'message-dots' ),
					array( 'fa-solid fa-message-exclamation' => 'message-exclamation' ),
					array( 'fa-solid fa-message-heart' => 'message-heart' ),
					array( 'fa-solid fa-message-image' => 'message-image' ),
					array( 'fa-solid fa-message-lines' => 'message-lines' ),
					array( 'fa-solid fa-message-medical' => 'message-medical' ),
					array( 'fa-solid fa-message-middle-top' => 'message-middle-top' ),
					array( 'fa-solid fa-message-middle' => 'message-middle' ),
					array( 'fa-solid fa-message-minus' => 'message-minus' ),
					array( 'fa-solid fa-message-music' => 'message-music' ),
					array( 'fa-solid fa-message-pen' => 'message-pen' ),
					array( 'fa-solid fa-message-plus' => 'message-plus' ),
					array( 'fa-solid fa-message-question' => 'message-question' ),
					array( 'fa-solid fa-message-quote' => 'message-quote' ),
					array( 'fa-solid fa-message-slash' => 'message-slash' ),
					array( 'fa-solid fa-message-smile' => 'message-smile' ),
					array( 'fa-solid fa-message-sms' => 'message-sms' ),
					array( 'fa-solid fa-message-text' => 'message-text' ),
					array( 'fa-solid fa-message-xmark' => 'message-xmark' ),
					array( 'fa-solid fa-message' => 'message' ),
					array( 'fa-solid fa-messages-dollar' => 'messages-dollar' ),
					array( 'fa-solid fa-messages-question' => 'messages-question' ),
					array( 'fa-solid fa-messages' => 'messages' ),
					array( 'fa-solid fa-meteor' => 'meteor' ),
					array( 'fa-solid fa-meter-bolt' => 'meter-bolt' ),
					array( 'fa-solid fa-meter-droplet' => 'meter-droplet' ),
					array( 'fa-solid fa-meter-fire' => 'meter-fire' ),
					array( 'fa-solid fa-meter' => 'meter' ),
					array( 'fa-solid fa-microchip-ai' => 'microchip-ai' ),
					array( 'fa-solid fa-microchip' => 'microchip' ),
					array( 'fa-solid fa-microphone-lines-slash' => 'microphone-lines-slash' ),
					array( 'fa-solid fa-microphone-lines' => 'microphone-lines' ),
					array( 'fa-solid fa-microphone-slash' => 'microphone-slash' ),
					array( 'fa-solid fa-microphone-stand' => 'microphone-stand' ),
					array( 'fa-solid fa-microphone' => 'microphone' ),
					array( 'fa-solid fa-microscope' => 'microscope' ),
					array( 'fa-solid fa-microwave' => 'microwave' ),
					array( 'fa-solid fa-mill-sign' => 'mill-sign' ),
					array( 'fa-solid fa-minimize' => 'minimize' ),
					array( 'fa-solid fa-minus' => 'minus' ),
					array( 'fa-solid fa-mistletoe' => 'mistletoe' ),
					array( 'fa-solid fa-mitten' => 'mitten' ),
					array( 'fa-solid fa-mobile-button' => 'mobile-button' ),
					array( 'fa-solid fa-mobile-notch' => 'mobile-notch' ),
					array( 'fa-solid fa-mobile-retro' => 'mobile-retro' ),
					array( 'fa-solid fa-mobile-screen-button' => 'mobile-screen-button' ),
					array( 'fa-solid fa-mobile-screen' => 'mobile-screen' ),
					array( 'fa-solid fa-mobile-signal-out' => 'mobile-signal-out' ),
					array( 'fa-solid fa-mobile-signal' => 'mobile-signal' ),
					array( 'fa-solid fa-mobile' => 'mobile' ),
					array( 'fa-solid fa-money-bill-1-wave' => 'money-bill-1-wave' ),
					array( 'fa-solid fa-money-bill-1' => 'money-bill-1' ),
					array( 'fa-solid fa-money-bill-simple-wave' => 'money-bill-simple-wave' ),
					array( 'fa-solid fa-money-bill-simple' => 'money-bill-simple' ),
					array( 'fa-solid fa-money-bill-transfer' => 'money-bill-transfer' ),
					array( 'fa-solid fa-money-bill-trend-up' => 'money-bill-trend-up' ),
					array( 'fa-solid fa-money-bill-wave' => 'money-bill-wave' ),
					array( 'fa-solid fa-money-bill-wheat' => 'money-bill-wheat' ),
					array( 'fa-solid fa-money-bill' => 'money-bill' ),
					array( 'fa-solid fa-money-bills-simple' => 'money-bills-simple' ),
					array( 'fa-solid fa-money-bills' => 'money-bills' ),
					array( 'fa-solid fa-money-check-dollar-pen' => 'money-check-dollar-pen' ),
					array( 'fa-solid fa-money-check-dollar' => 'money-check-dollar' ),
					array( 'fa-solid fa-money-check-pen' => 'money-check-pen' ),
					array( 'fa-solid fa-money-check' => 'money-check' ),
					array( 'fa-solid fa-money-from-bracket' => 'money-from-bracket' ),
					array( 'fa-solid fa-money-simple-from-bracket' => 'money-simple-from-bracket' ),
					array( 'fa-solid fa-monitor-waveform' => 'monitor-waveform' ),
					array( 'fa-solid fa-monkey' => 'monkey' ),
					array( 'fa-solid fa-monument' => 'monument' ),
					array( 'fa-solid fa-moon-cloud' => 'moon-cloud' ),
					array( 'fa-solid fa-moon-over-sun' => 'moon-over-sun' ),
					array( 'fa-solid fa-moon-stars' => 'moon-stars' ),
					array( 'fa-solid fa-moon' => 'moon' ),
					array( 'fa-solid fa-moped' => 'moped' ),
					array( 'fa-solid fa-mortar-pestle' => 'mortar-pestle' ),
					array( 'fa-solid fa-mosque' => 'mosque' ),
					array( 'fa-solid fa-mosquito-net' => 'mosquito-net' ),
					array( 'fa-solid fa-mosquito' => 'mosquito' ),
					array( 'fa-solid fa-motorcycle' => 'motorcycle' ),
					array( 'fa-solid fa-mound' => 'mound' ),
					array( 'fa-solid fa-mountain-city' => 'mountain-city' ),
					array( 'fa-solid fa-mountain-sun' => 'mountain-sun' ),
					array( 'fa-solid fa-mountain' => 'mountain' ),
					array( 'fa-solid fa-mountains' => 'mountains' ),
					array( 'fa-solid fa-mouse-field' => 'mouse-field' ),
					array( 'fa-solid fa-mp3-player' => 'mp3-player' ),
					array( 'fa-solid fa-mug-hot' => 'mug-hot' ),
					array( 'fa-solid fa-mug-marshmallows' => 'mug-marshmallows' ),
					array( 'fa-solid fa-mug-saucer' => 'mug-saucer' ),
					array( 'fa-solid fa-mug-tea-saucer' => 'mug-tea-saucer' ),
					array( 'fa-solid fa-mug-tea' => 'mug-tea' ),
					array( 'fa-solid fa-mug' => 'mug' ),
					array( 'fa-solid fa-mushroom' => 'mushroom' ),
					array( 'fa-solid fa-music-note-slash' => 'music-note-slash' ),
					array( 'fa-solid fa-music-note' => 'music-note' ),
					array( 'fa-solid fa-music-slash' => 'music-slash' ),
					array( 'fa-solid fa-music' => 'music' ),
					array( 'fa-solid fa-mustache' => 'mustache' ),
					array( 'fa-solid fa-n' => 'n' ),
					array( 'fa-solid fa-naira-sign' => 'naira-sign' ),
					array( 'fa-solid fa-narwhal' => 'narwhal' ),
					array( 'fa-solid fa-nesting-dolls' => 'nesting-dolls' ),
					array( 'fa-solid fa-network-wired' => 'network-wired' ),
					array( 'fa-solid fa-neuter' => 'neuter' ),
					array( 'fa-solid fa-newspaper' => 'newspaper' ),
					array( 'fa-solid fa-nfc-lock' => 'nfc-lock' ),
					array( 'fa-solid fa-nfc-magnifying-glass' => 'nfc-magnifying-glass' ),
					array( 'fa-solid fa-nfc-pen' => 'nfc-pen' ),
					array( 'fa-solid fa-nfc-signal' => 'nfc-signal' ),
					array( 'fa-solid fa-nfc-slash' => 'nfc-slash' ),
					array( 'fa-solid fa-nfc-symbol' => 'nfc-symbol' ),
					array( 'fa-solid fa-nfc-trash' => 'nfc-trash' ),
					array( 'fa-solid fa-nfc' => 'nfc' ),
					array( 'fa-solid fa-nose' => 'nose' ),
					array( 'fa-solid fa-not-equal' => 'not-equal' ),
					array( 'fa-solid fa-notdef' => 'notdef' ),
					array( 'fa-solid fa-note-medical' => 'note-medical' ),
					array( 'fa-solid fa-note-sticky' => 'note-sticky' ),
					array( 'fa-solid fa-note' => 'note' ),
					array( 'fa-solid fa-notebook' => 'notebook' ),
					array( 'fa-solid fa-notes-medical' => 'notes-medical' ),
					array( 'fa-solid fa-notes' => 'notes' ),
					array( 'fa-solid fa-o' => 'o' ),
					array( 'fa-solid fa-object-exclude' => 'object-exclude' ),
					array( 'fa-solid fa-object-group' => 'object-group' ),
					array( 'fa-solid fa-object-intersect' => 'object-intersect' ),
					array( 'fa-solid fa-object-subtract' => 'object-subtract' ),
					array( 'fa-solid fa-object-ungroup' => 'object-ungroup' ),
					array( 'fa-solid fa-object-union' => 'object-union' ),
					array( 'fa-solid fa-objects-align-bottom' => 'objects-align-bottom' ),
					array( 'fa-solid fa-objects-align-center-horizontal' => 'objects-align-center-horizontal' ),
					array( 'fa-solid fa-objects-align-center-vertical' => 'objects-align-center-vertical' ),
					array( 'fa-solid fa-objects-align-left' => 'objects-align-left' ),
					array( 'fa-solid fa-objects-align-right' => 'objects-align-right' ),
					array( 'fa-solid fa-objects-align-top' => 'objects-align-top' ),
					array( 'fa-solid fa-objects-column' => 'objects-column' ),
					array( 'fa-solid fa-octagon-check' => 'octagon-check' ),
					array( 'fa-solid fa-octagon-divide' => 'octagon-divide' ),
					array( 'fa-solid fa-octagon-exclamation' => 'octagon-exclamation' ),
					array( 'fa-solid fa-octagon-minus' => 'octagon-minus' ),
					array( 'fa-solid fa-octagon-plus' => 'octagon-plus' ),
					array( 'fa-solid fa-octagon-xmark' => 'octagon-xmark' ),
					array( 'fa-solid fa-octagon' => 'octagon' ),
					array( 'fa-solid fa-oil-can-drip' => 'oil-can-drip' ),
					array( 'fa-solid fa-oil-can' => 'oil-can' ),
					array( 'fa-solid fa-oil-temperature' => 'oil-temperature' ),
					array( 'fa-solid fa-oil-well' => 'oil-well' ),
					array( 'fa-solid fa-olive-branch' => 'olive-branch' ),
					array( 'fa-solid fa-olive' => 'olive' ),
					array( 'fa-solid fa-om' => 'om' ),
					array( 'fa-solid fa-omega' => 'omega' ),
					array( 'fa-solid fa-onion' => 'onion' ),
					array( 'fa-solid fa-option' => 'option' ),
					array( 'fa-solid fa-ornament' => 'ornament' ),
					array( 'fa-solid fa-otter' => 'otter' ),
					array( 'fa-solid fa-outdent' => 'outdent' ),
					array( 'fa-solid fa-outlet' => 'outlet' ),
					array( 'fa-solid fa-oven' => 'oven' ),
					array( 'fa-solid fa-overline' => 'overline' ),
					array( 'fa-solid fa-p' => 'p' ),
					array( 'fa-solid fa-page-caret-down' => 'page-caret-down' ),
					array( 'fa-solid fa-page-caret-up' => 'page-caret-up' ),
					array( 'fa-solid fa-page' => 'page' ),
					array( 'fa-solid fa-pager' => 'pager' ),
					array( 'fa-solid fa-paint-roller' => 'paint-roller' ),
					array( 'fa-solid fa-paintbrush-fine' => 'paintbrush-fine' ),
					array( 'fa-solid fa-paintbrush-pencil' => 'paintbrush-pencil' ),
					array( 'fa-solid fa-paintbrush' => 'paintbrush' ),
					array( 'fa-solid fa-palette' => 'palette' ),
					array( 'fa-solid fa-pallet-box' => 'pallet-box' ),
					array( 'fa-solid fa-pallet-boxes' => 'pallet-boxes' ),
					array( 'fa-solid fa-pallet' => 'pallet' ),
					array( 'fa-solid fa-pan-food' => 'pan-food' ),
					array( 'fa-solid fa-pan-frying' => 'pan-frying' ),
					array( 'fa-solid fa-pancakes' => 'pancakes' ),
					array( 'fa-solid fa-panel-ews' => 'panel-ews' ),
					array( 'fa-solid fa-panel-fire' => 'panel-fire' ),
					array( 'fa-solid fa-panorama' => 'panorama' ),
					array( 'fa-solid fa-paper-plane-top' => 'paper-plane-top' ),
					array( 'fa-solid fa-paper-plane' => 'paper-plane' ),
					array( 'fa-solid fa-paperclip-vertical' => 'paperclip-vertical' ),
					array( 'fa-solid fa-paperclip' => 'paperclip' ),
					array( 'fa-solid fa-parachute-box' => 'parachute-box' ),
					array( 'fa-solid fa-paragraph-left' => 'paragraph-left' ),
					array( 'fa-solid fa-paragraph' => 'paragraph' ),
					array( 'fa-solid fa-party-bell' => 'party-bell' ),
					array( 'fa-solid fa-party-horn' => 'party-horn' ),
					array( 'fa-solid fa-passport' => 'passport' ),
					array( 'fa-solid fa-paste' => 'paste' ),
					array( 'fa-solid fa-pause' => 'pause' ),
					array( 'fa-solid fa-paw-claws' => 'paw-claws' ),
					array( 'fa-solid fa-paw-simple' => 'paw-simple' ),
					array( 'fa-solid fa-paw' => 'paw' ),
					array( 'fa-solid fa-peace' => 'peace' ),
					array( 'fa-solid fa-peach' => 'peach' ),
					array( 'fa-solid fa-peanut' => 'peanut' ),
					array( 'fa-solid fa-peanuts' => 'peanuts' ),
					array( 'fa-solid fa-peapod' => 'peapod' ),
					array( 'fa-solid fa-pear' => 'pear' ),
					array( 'fa-solid fa-pedestal' => 'pedestal' ),
					array( 'fa-solid fa-pegasus' => 'pegasus' ),
					array( 'fa-solid fa-pen-circle' => 'pen-circle' ),
					array( 'fa-solid fa-pen-clip-slash' => 'pen-clip-slash' ),
					array( 'fa-solid fa-pen-clip' => 'pen-clip' ),
					array( 'fa-solid fa-pen-fancy-slash' => 'pen-fancy-slash' ),
					array( 'fa-solid fa-pen-fancy' => 'pen-fancy' ),
					array( 'fa-solid fa-pen-field' => 'pen-field' ),
					array( 'fa-solid fa-pen-line' => 'pen-line' ),
					array( 'fa-solid fa-pen-nib-slash' => 'pen-nib-slash' ),
					array( 'fa-solid fa-pen-nib' => 'pen-nib' ),
					array( 'fa-solid fa-pen-paintbrush' => 'pen-paintbrush' ),
					array( 'fa-solid fa-pen-ruler' => 'pen-ruler' ),
					array( 'fa-solid fa-pen-slash' => 'pen-slash' ),
					array( 'fa-solid fa-pen-swirl' => 'pen-swirl' ),
					array( 'fa-solid fa-pen-to-square' => 'pen-to-square' ),
					array( 'fa-solid fa-pen' => 'pen' ),
					array( 'fa-solid fa-pencil-mechanical' => 'pencil-mechanical' ),
					array( 'fa-solid fa-pencil-slash' => 'pencil-slash' ),
					array( 'fa-solid fa-pencil' => 'pencil' ),
					array( 'fa-solid fa-people-arrows' => 'people-arrows' ),
					array( 'fa-solid fa-people-carry-box' => 'people-carry-box' ),
					array( 'fa-solid fa-people-dress-simple' => 'people-dress-simple' ),
					array( 'fa-solid fa-people-dress' => 'people-dress' ),
					array( 'fa-solid fa-people-group' => 'people-group' ),
					array( 'fa-solid fa-people-line' => 'people-line' ),
					array( 'fa-solid fa-people-pants-simple' => 'people-pants-simple' ),
					array( 'fa-solid fa-people-pants' => 'people-pants' ),
					array( 'fa-solid fa-people-pulling' => 'people-pulling' ),
					array( 'fa-solid fa-people-robbery' => 'people-robbery' ),
					array( 'fa-solid fa-people-roof' => 'people-roof' ),
					array( 'fa-solid fa-people-simple' => 'people-simple' ),
					array( 'fa-solid fa-people' => 'people' ),
					array( 'fa-solid fa-pepper-hot' => 'pepper-hot' ),
					array( 'fa-solid fa-pepper' => 'pepper' ),
					array( 'fa-solid fa-percent' => 'percent' ),
					array( 'fa-solid fa-period' => 'period' ),
					array( 'fa-solid fa-person-arrow-down-to-line' => 'person-arrow-down-to-line' ),
					array( 'fa-solid fa-person-arrow-up-from-line' => 'person-arrow-up-from-line' ),
					array( 'fa-solid fa-person-biking-mountain' => 'person-biking-mountain' ),
					array( 'fa-solid fa-person-biking' => 'person-biking' ),
					array( 'fa-solid fa-person-booth' => 'person-booth' ),
					array( 'fa-solid fa-person-breastfeeding' => 'person-breastfeeding' ),
					array( 'fa-solid fa-person-burst' => 'person-burst' ),
					array( 'fa-solid fa-person-cane' => 'person-cane' ),
					array( 'fa-solid fa-person-carry-box' => 'person-carry-box' ),
					array( 'fa-solid fa-person-chalkboard' => 'person-chalkboard' ),
					array( 'fa-solid fa-person-circle-check' => 'person-circle-check' ),
					array( 'fa-solid fa-person-circle-exclamation' => 'person-circle-exclamation' ),
					array( 'fa-solid fa-person-circle-minus' => 'person-circle-minus' ),
					array( 'fa-solid fa-person-circle-plus' => 'person-circle-plus' ),
					array( 'fa-solid fa-person-circle-question' => 'person-circle-question' ),
					array( 'fa-solid fa-person-circle-xmark' => 'person-circle-xmark' ),
					array( 'fa-solid fa-person-digging' => 'person-digging' ),
					array( 'fa-solid fa-person-dolly-empty' => 'person-dolly-empty' ),
					array( 'fa-solid fa-person-dolly' => 'person-dolly' ),
					array( 'fa-solid fa-person-dots-from-line' => 'person-dots-from-line' ),
					array( 'fa-solid fa-person-dress-burst' => 'person-dress-burst' ),
					array( 'fa-solid fa-person-dress-fairy' => 'person-dress-fairy' ),
					array( 'fa-solid fa-person-dress-simple' => 'person-dress-simple' ),
					array( 'fa-solid fa-person-dress' => 'person-dress' ),
					array( 'fa-solid fa-person-drowning' => 'person-drowning' ),
					array( 'fa-solid fa-person-fairy' => 'person-fairy' ),
					array( 'fa-solid fa-person-falling-burst' => 'person-falling-burst' ),
					array( 'fa-solid fa-person-falling' => 'person-falling' ),
					array( 'fa-solid fa-person-from-portal' => 'person-from-portal' ),
					array( 'fa-solid fa-person-half-dress' => 'person-half-dress' ),
					array( 'fa-solid fa-person-harassing' => 'person-harassing' ),
					array( 'fa-solid fa-person-hiking' => 'person-hiking' ),
					array( 'fa-solid fa-person-military-pointing' => 'person-military-pointing' ),
					array( 'fa-solid fa-person-military-rifle' => 'person-military-rifle' ),
					array( 'fa-solid fa-person-military-to-person' => 'person-military-to-person' ),
					array( 'fa-solid fa-person-pinball' => 'person-pinball' ),
					array( 'fa-solid fa-person-praying' => 'person-praying' ),
					array( 'fa-solid fa-person-pregnant' => 'person-pregnant' ),
					array( 'fa-solid fa-person-rays' => 'person-rays' ),
					array( 'fa-solid fa-person-rifle' => 'person-rifle' ),
					array( 'fa-solid fa-person-running-fast' => 'person-running-fast' ),
					array( 'fa-solid fa-person-running' => 'person-running' ),
					array( 'fa-solid fa-person-seat-reclined' => 'person-seat-reclined' ),
					array( 'fa-solid fa-person-seat' => 'person-seat' ),
					array( 'fa-solid fa-person-shelter' => 'person-shelter' ),
					array( 'fa-solid fa-person-sign' => 'person-sign' ),
					array( 'fa-solid fa-person-simple' => 'person-simple' ),
					array( 'fa-solid fa-person-skating' => 'person-skating' ),
					array( 'fa-solid fa-person-ski-jumping' => 'person-ski-jumping' ),
					array( 'fa-solid fa-person-ski-lift' => 'person-ski-lift' ),
					array( 'fa-solid fa-person-skiing-nordic' => 'person-skiing-nordic' ),
					array( 'fa-solid fa-person-skiing' => 'person-skiing' ),
					array( 'fa-solid fa-person-sledding' => 'person-sledding' ),
					array( 'fa-solid fa-person-snowboarding' => 'person-snowboarding' ),
					array( 'fa-solid fa-person-snowmobiling' => 'person-snowmobiling' ),
					array( 'fa-solid fa-person-swimming' => 'person-swimming' ),
					array( 'fa-solid fa-person-through-window' => 'person-through-window' ),
					array( 'fa-solid fa-person-to-door' => 'person-to-door' ),
					array( 'fa-solid fa-person-to-portal' => 'person-to-portal' ),
					array( 'fa-solid fa-person-walking-arrow-loop-left' => 'person-walking-arrow-loop-left' ),
					array( 'fa-solid fa-person-walking-arrow-right' => 'person-walking-arrow-right' ),
					array( 'fa-solid fa-person-walking-dashed-line-arrow-right' => 'person-walking-dashed-line-arrow-right' ),
					array( 'fa-solid fa-person-walking-luggage' => 'person-walking-luggage' ),
					array( 'fa-solid fa-person-walking-with-cane' => 'person-walking-with-cane' ),
					array( 'fa-solid fa-person-walking' => 'person-walking' ),
					array( 'fa-solid fa-person' => 'person' ),
					array( 'fa-solid fa-peseta-sign' => 'peseta-sign' ),
					array( 'fa-solid fa-peso-sign' => 'peso-sign' ),
					array( 'fa-solid fa-phone-arrow-down-left' => 'phone-arrow-down-left' ),
					array( 'fa-solid fa-phone-arrow-right' => 'phone-arrow-right' ),
					array( 'fa-solid fa-phone-arrow-up-right' => 'phone-arrow-up-right' ),
					array( 'fa-solid fa-phone-flip' => 'phone-flip' ),
					array( 'fa-solid fa-phone-hangup' => 'phone-hangup' ),
					array( 'fa-solid fa-phone-intercom' => 'phone-intercom' ),
					array( 'fa-solid fa-phone-missed' => 'phone-missed' ),
					array( 'fa-solid fa-phone-office' => 'phone-office' ),
					array( 'fa-solid fa-phone-plus' => 'phone-plus' ),
					array( 'fa-solid fa-phone-rotary' => 'phone-rotary' ),
					array( 'fa-solid fa-phone-slash' => 'phone-slash' ),
					array( 'fa-solid fa-phone-volume' => 'phone-volume' ),
					array( 'fa-solid fa-phone-xmark' => 'phone-xmark' ),
					array( 'fa-solid fa-phone' => 'phone' ),
					array( 'fa-solid fa-photo-film-music' => 'photo-film-music' ),
					array( 'fa-solid fa-photo-film' => 'photo-film' ),
					array( 'fa-solid fa-pi' => 'pi' ),
					array( 'fa-solid fa-piano-keyboard' => 'piano-keyboard' ),
					array( 'fa-solid fa-piano' => 'piano' ),
					array( 'fa-solid fa-pickaxe' => 'pickaxe' ),
					array( 'fa-solid fa-pickleball' => 'pickleball' ),
					array( 'fa-solid fa-pie' => 'pie' ),
					array( 'fa-solid fa-pig' => 'pig' ),
					array( 'fa-solid fa-piggy-bank' => 'piggy-bank' ),
					array( 'fa-solid fa-pills' => 'pills' ),
					array( 'fa-solid fa-pinata' => 'pinata' ),
					array( 'fa-solid fa-pinball' => 'pinball' ),
					array( 'fa-solid fa-pineapple' => 'pineapple' ),
					array( 'fa-solid fa-pipe-circle-check' => 'pipe-circle-check' ),
					array( 'fa-solid fa-pipe-collar' => 'pipe-collar' ),
					array( 'fa-solid fa-pipe-section' => 'pipe-section' ),
					array( 'fa-solid fa-pipe-smoking' => 'pipe-smoking' ),
					array( 'fa-solid fa-pipe-valve' => 'pipe-valve' ),
					array( 'fa-solid fa-pipe' => 'pipe' ),
					array( 'fa-solid fa-pizza-slice' => 'pizza-slice' ),
					array( 'fa-solid fa-pizza' => 'pizza' ),
					array( 'fa-solid fa-place-of-worship' => 'place-of-worship' ),
					array( 'fa-solid fa-plane-arrival' => 'plane-arrival' ),
					array( 'fa-solid fa-plane-circle-check' => 'plane-circle-check' ),
					array( 'fa-solid fa-plane-circle-exclamation' => 'plane-circle-exclamation' ),
					array( 'fa-solid fa-plane-circle-xmark' => 'plane-circle-xmark' ),
					array( 'fa-solid fa-plane-departure' => 'plane-departure' ),
					array( 'fa-solid fa-plane-engines' => 'plane-engines' ),
					array( 'fa-solid fa-plane-lock' => 'plane-lock' ),
					array( 'fa-solid fa-plane-prop' => 'plane-prop' ),
					array( 'fa-solid fa-plane-slash' => 'plane-slash' ),
					array( 'fa-solid fa-plane-tail' => 'plane-tail' ),
					array( 'fa-solid fa-plane-up-slash' => 'plane-up-slash' ),
					array( 'fa-solid fa-plane-up' => 'plane-up' ),
					array( 'fa-solid fa-plane' => 'plane' ),
					array( 'fa-solid fa-planet-moon' => 'planet-moon' ),
					array( 'fa-solid fa-planet-ringed' => 'planet-ringed' ),
					array( 'fa-solid fa-plant-wilt' => 'plant-wilt' ),
					array( 'fa-solid fa-plate-utensils' => 'plate-utensils' ),
					array( 'fa-solid fa-plate-wheat' => 'plate-wheat' ),
					array( 'fa-solid fa-play-pause' => 'play-pause' ),
					array( 'fa-solid fa-play' => 'play' ),
					array( 'fa-solid fa-plug-circle-bolt' => 'plug-circle-bolt' ),
					array( 'fa-solid fa-plug-circle-check' => 'plug-circle-check' ),
					array( 'fa-solid fa-plug-circle-exclamation' => 'plug-circle-exclamation' ),
					array( 'fa-solid fa-plug-circle-minus' => 'plug-circle-minus' ),
					array( 'fa-solid fa-plug-circle-plus' => 'plug-circle-plus' ),
					array( 'fa-solid fa-plug-circle-xmark' => 'plug-circle-xmark' ),
					array( 'fa-solid fa-plug' => 'plug' ),
					array( 'fa-solid fa-plus-large' => 'plus-large' ),
					array( 'fa-solid fa-plus-minus' => 'plus-minus' ),
					array( 'fa-solid fa-plus' => 'plus' ),
					array( 'fa-solid fa-podcast' => 'podcast' ),
					array( 'fa-solid fa-podium-star' => 'podium-star' ),
					array( 'fa-solid fa-podium' => 'podium' ),
					array( 'fa-solid fa-police-box' => 'police-box' ),
					array( 'fa-solid fa-poll-people' => 'poll-people' ),
					array( 'fa-solid fa-pompebled' => 'pompebled' ),
					array( 'fa-solid fa-poo-storm' => 'poo-storm' ),
					array( 'fa-solid fa-poo' => 'poo' ),
					array( 'fa-solid fa-pool-8-ball' => 'pool-8-ball' ),
					array( 'fa-solid fa-poop' => 'poop' ),
					array( 'fa-solid fa-popcorn' => 'popcorn' ),
					array( 'fa-solid fa-popsicle' => 'popsicle' ),
					array( 'fa-solid fa-pot-food' => 'pot-food' ),
					array( 'fa-solid fa-potato' => 'potato' ),
					array( 'fa-solid fa-power-off' => 'power-off' ),
					array( 'fa-solid fa-prescription-bottle-medical' => 'prescription-bottle-medical' ),
					array( 'fa-solid fa-prescription-bottle-pill' => 'prescription-bottle-pill' ),
					array( 'fa-solid fa-prescription-bottle' => 'prescription-bottle' ),
					array( 'fa-solid fa-prescription' => 'prescription' ),
					array( 'fa-solid fa-presentation-screen' => 'presentation-screen' ),
					array( 'fa-solid fa-pretzel' => 'pretzel' ),
					array( 'fa-solid fa-print-magnifying-glass' => 'print-magnifying-glass' ),
					array( 'fa-solid fa-print-slash' => 'print-slash' ),
					array( 'fa-solid fa-print' => 'print' ),
					array( 'fa-solid fa-projector' => 'projector' ),
					array( 'fa-solid fa-pump-medical' => 'pump-medical' ),
					array( 'fa-solid fa-pump-soap' => 'pump-soap' ),
					array( 'fa-solid fa-pump' => 'pump' ),
					array( 'fa-solid fa-pumpkin' => 'pumpkin' ),
					array( 'fa-solid fa-puzzle-piece-simple' => 'puzzle-piece-simple' ),
					array( 'fa-solid fa-puzzle-piece' => 'puzzle-piece' ),
					array( 'fa-solid fa-puzzle' => 'puzzle' ),
					array( 'fa-solid fa-q' => 'q' ),
					array( 'fa-solid fa-qrcode' => 'qrcode' ),
					array( 'fa-solid fa-question' => 'question' ),
					array( 'fa-solid fa-quote-left' => 'quote-left' ),
					array( 'fa-solid fa-quote-right' => 'quote-right' ),
					array( 'fa-solid fa-quotes' => 'quotes' ),
					array( 'fa-solid fa-r' => 'r' ),
					array( 'fa-solid fa-rabbit-running' => 'rabbit-running' ),
					array( 'fa-solid fa-rabbit' => 'rabbit' ),
					array( 'fa-solid fa-raccoon' => 'raccoon' ),
					array( 'fa-solid fa-racquet' => 'racquet' ),
					array( 'fa-solid fa-radar' => 'radar' ),
					array( 'fa-solid fa-radiation' => 'radiation' ),
					array( 'fa-solid fa-radio-tuner' => 'radio-tuner' ),
					array( 'fa-solid fa-radio' => 'radio' ),
					array( 'fa-solid fa-rainbow' => 'rainbow' ),
					array( 'fa-solid fa-raindrops' => 'raindrops' ),
					array( 'fa-solid fa-ram' => 'ram' ),
					array( 'fa-solid fa-ramp-loading' => 'ramp-loading' ),
					array( 'fa-solid fa-ranking-star' => 'ranking-star' ),
					array( 'fa-solid fa-raygun' => 'raygun' ),
					array( 'fa-solid fa-receipt' => 'receipt' ),
					array( 'fa-solid fa-record-vinyl' => 'record-vinyl' ),
					array( 'fa-solid fa-rectangle-ad' => 'rectangle-ad' ),
					array( 'fa-solid fa-rectangle-barcode' => 'rectangle-barcode' ),
					array( 'fa-solid fa-rectangle-code' => 'rectangle-code' ),
					array( 'fa-solid fa-rectangle-history-circle-plus' => 'rectangle-history-circle-plus' ),
					array( 'fa-solid fa-rectangle-history-circle-user' => 'rectangle-history-circle-user' ),
					array( 'fa-solid fa-rectangle-history' => 'rectangle-history' ),
					array( 'fa-solid fa-rectangle-list' => 'rectangle-list' ),
					array( 'fa-solid fa-rectangle-pro' => 'rectangle-pro' ),
					array( 'fa-solid fa-rectangle-terminal' => 'rectangle-terminal' ),
					array( 'fa-solid fa-rectangle-vertical-history' => 'rectangle-vertical-history' ),
					array( 'fa-solid fa-rectangle-vertical' => 'rectangle-vertical' ),
					array( 'fa-solid fa-rectangle-wide' => 'rectangle-wide' ),
					array( 'fa-solid fa-rectangle-xmark' => 'rectangle-xmark' ),
					array( 'fa-solid fa-rectangle' => 'rectangle' ),
					array( 'fa-solid fa-rectangles-mixed' => 'rectangles-mixed' ),
					array( 'fa-solid fa-recycle' => 'recycle' ),
					array( 'fa-solid fa-reel' => 'reel' ),
					array( 'fa-solid fa-refrigerator' => 'refrigerator' ),
					array( 'fa-solid fa-registered' => 'registered' ),
					array( 'fa-solid fa-repeat-1' => 'repeat-1' ),
					array( 'fa-solid fa-repeat' => 'repeat' ),
					array( 'fa-solid fa-reply-all' => 'reply-all' ),
					array( 'fa-solid fa-reply-clock' => 'reply-clock' ),
					array( 'fa-solid fa-reply' => 'reply' ),
					array( 'fa-solid fa-republican' => 'republican' ),
					array( 'fa-solid fa-restroom-simple' => 'restroom-simple' ),
					array( 'fa-solid fa-restroom' => 'restroom' ),
					array( 'fa-solid fa-retweet' => 'retweet' ),
					array( 'fa-solid fa-rhombus' => 'rhombus' ),
					array( 'fa-solid fa-ribbon' => 'ribbon' ),
					array( 'fa-solid fa-right-from-bracket' => 'right-from-bracket' ),
					array( 'fa-solid fa-right-from-line' => 'right-from-line' ),
					array( 'fa-solid fa-right-left-large' => 'right-left-large' ),
					array( 'fa-solid fa-right-left' => 'right-left' ),
					array( 'fa-solid fa-right-long-to-line' => 'right-long-to-line' ),
					array( 'fa-solid fa-right-long' => 'right-long' ),
					array( 'fa-solid fa-right-to-bracket' => 'right-to-bracket' ),
					array( 'fa-solid fa-right-to-line' => 'right-to-line' ),
					array( 'fa-solid fa-right' => 'right' ),
					array( 'fa-solid fa-ring-diamond' => 'ring-diamond' ),
					array( 'fa-solid fa-ring' => 'ring' ),
					array( 'fa-solid fa-rings-wedding' => 'rings-wedding' ),
					array( 'fa-solid fa-road-barrier' => 'road-barrier' ),
					array( 'fa-solid fa-road-bridge' => 'road-bridge' ),
					array( 'fa-solid fa-road-circle-check' => 'road-circle-check' ),
					array( 'fa-solid fa-road-circle-exclamation' => 'road-circle-exclamation' ),
					array( 'fa-solid fa-road-circle-xmark' => 'road-circle-xmark' ),
					array( 'fa-solid fa-road-lock' => 'road-lock' ),
					array( 'fa-solid fa-road-spikes' => 'road-spikes' ),
					array( 'fa-solid fa-road' => 'road' ),
					array( 'fa-solid fa-robot-astromech' => 'robot-astromech' ),
					array( 'fa-solid fa-robot' => 'robot' ),
					array( 'fa-solid fa-rocket-launch' => 'rocket-launch' ),
					array( 'fa-solid fa-rocket' => 'rocket' ),
					array( 'fa-solid fa-roller-coaster' => 'roller-coaster' ),
					array( 'fa-solid fa-rotate-exclamation' => 'rotate-exclamation' ),
					array( 'fa-solid fa-rotate-left' => 'rotate-left' ),
					array( 'fa-solid fa-rotate-right' => 'rotate-right' ),
					array( 'fa-solid fa-rotate' => 'rotate' ),
					array( 'fa-solid fa-route-highway' => 'route-highway' ),
					array( 'fa-solid fa-route-interstate' => 'route-interstate' ),
					array( 'fa-solid fa-route' => 'route' ),
					array( 'fa-solid fa-router' => 'router' ),
					array( 'fa-solid fa-rss' => 'rss' ),
					array( 'fa-solid fa-ruble-sign' => 'ruble-sign' ),
					array( 'fa-solid fa-rug' => 'rug' ),
					array( 'fa-solid fa-rugby-ball' => 'rugby-ball' ),
					array( 'fa-solid fa-ruler-combined' => 'ruler-combined' ),
					array( 'fa-solid fa-ruler-horizontal' => 'ruler-horizontal' ),
					array( 'fa-solid fa-ruler-triangle' => 'ruler-triangle' ),
					array( 'fa-solid fa-ruler-vertical' => 'ruler-vertical' ),
					array( 'fa-solid fa-ruler' => 'ruler' ),
					array( 'fa-solid fa-rupee-sign' => 'rupee-sign' ),
					array( 'fa-solid fa-rupiah-sign' => 'rupiah-sign' ),
					array( 'fa-solid fa-rv' => 'rv' ),
					array( 'fa-solid fa-s' => 's' ),
					array( 'fa-solid fa-sack-dollar' => 'sack-dollar' ),
					array( 'fa-solid fa-sack-xmark' => 'sack-xmark' ),
					array( 'fa-solid fa-sack' => 'sack' ),
					array( 'fa-solid fa-sailboat' => 'sailboat' ),
					array( 'fa-solid fa-salad' => 'salad' ),
					array( 'fa-solid fa-salt-shaker' => 'salt-shaker' ),
					array( 'fa-solid fa-sandwich' => 'sandwich' ),
					array( 'fa-solid fa-satellite-dish' => 'satellite-dish' ),
					array( 'fa-solid fa-satellite' => 'satellite' ),
					array( 'fa-solid fa-sausage' => 'sausage' ),
					array( 'fa-solid fa-saxophone-fire' => 'saxophone-fire' ),
					array( 'fa-solid fa-saxophone' => 'saxophone' ),
					array( 'fa-solid fa-scale-balanced' => 'scale-balanced' ),
					array( 'fa-solid fa-scale-unbalanced-flip' => 'scale-unbalanced-flip' ),
					array( 'fa-solid fa-scale-unbalanced' => 'scale-unbalanced' ),
					array( 'fa-solid fa-scalpel-line-dashed' => 'scalpel-line-dashed' ),
					array( 'fa-solid fa-scalpel' => 'scalpel' ),
					array( 'fa-solid fa-scanner-gun' => 'scanner-gun' ),
					array( 'fa-solid fa-scanner-image' => 'scanner-image' ),
					array( 'fa-solid fa-scanner-keyboard' => 'scanner-keyboard' ),
					array( 'fa-solid fa-scanner-touchscreen' => 'scanner-touchscreen' ),
					array( 'fa-solid fa-scarecrow' => 'scarecrow' ),
					array( 'fa-solid fa-scarf' => 'scarf' ),
					array( 'fa-solid fa-school-circle-check' => 'school-circle-check' ),
					array( 'fa-solid fa-school-circle-exclamation' => 'school-circle-exclamation' ),
					array( 'fa-solid fa-school-circle-xmark' => 'school-circle-xmark' ),
					array( 'fa-solid fa-school-flag' => 'school-flag' ),
					array( 'fa-solid fa-school-lock' => 'school-lock' ),
					array( 'fa-solid fa-school' => 'school' ),
					array( 'fa-solid fa-scissors' => 'scissors' ),
					array( 'fa-solid fa-screen-users' => 'screen-users' ),
					array( 'fa-solid fa-screencast' => 'screencast' ),
					array( 'fa-solid fa-screwdriver-wrench' => 'screwdriver-wrench' ),
					array( 'fa-solid fa-screwdriver' => 'screwdriver' ),
					array( 'fa-solid fa-scribble' => 'scribble' ),
					array( 'fa-solid fa-scroll-old' => 'scroll-old' ),
					array( 'fa-solid fa-scroll-torah' => 'scroll-torah' ),
					array( 'fa-solid fa-scroll' => 'scroll' ),
					array( 'fa-solid fa-scrubber' => 'scrubber' ),
					array( 'fa-solid fa-scythe' => 'scythe' ),
					array( 'fa-solid fa-sd-card' => 'sd-card' ),
					array( 'fa-solid fa-sd-cards' => 'sd-cards' ),
					array( 'fa-solid fa-seal-exclamation' => 'seal-exclamation' ),
					array( 'fa-solid fa-seal-question' => 'seal-question' ),
					array( 'fa-solid fa-seal' => 'seal' ),
					array( 'fa-solid fa-seat-airline' => 'seat-airline' ),
					array( 'fa-solid fa-section' => 'section' ),
					array( 'fa-solid fa-seedling' => 'seedling' ),
					array( 'fa-solid fa-semicolon' => 'semicolon' ),
					array( 'fa-solid fa-send-back' => 'send-back' ),
					array( 'fa-solid fa-send-backward' => 'send-backward' ),
					array( 'fa-solid fa-sensor-cloud' => 'sensor-cloud' ),
					array( 'fa-solid fa-sensor-fire' => 'sensor-fire' ),
					array( 'fa-solid fa-sensor-on' => 'sensor-on' ),
					array( 'fa-solid fa-sensor-triangle-exclamation' => 'sensor-triangle-exclamation' ),
					array( 'fa-solid fa-sensor' => 'sensor' ),
					array( 'fa-solid fa-server' => 'server' ),
					array( 'fa-solid fa-shapes' => 'shapes' ),
					array( 'fa-solid fa-share-all' => 'share-all' ),
					array( 'fa-solid fa-share-from-square' => 'share-from-square' ),
					array( 'fa-solid fa-share-nodes' => 'share-nodes' ),
					array( 'fa-solid fa-share' => 'share' ),
					array( 'fa-solid fa-sheep' => 'sheep' ),
					array( 'fa-solid fa-sheet-plastic' => 'sheet-plastic' ),
					array( 'fa-solid fa-shekel-sign' => 'shekel-sign' ),
					array( 'fa-solid fa-shelves-empty' => 'shelves-empty' ),
					array( 'fa-solid fa-shelves' => 'shelves' ),
					array( 'fa-solid fa-shield-cat' => 'shield-cat' ),
					array( 'fa-solid fa-shield-check' => 'shield-check' ),
					array( 'fa-solid fa-shield-cross' => 'shield-cross' ),
					array( 'fa-solid fa-shield-dog' => 'shield-dog' ),
					array( 'fa-solid fa-shield-exclamation' => 'shield-exclamation' ),
					array( 'fa-solid fa-shield-halved' => 'shield-halved' ),
					array( 'fa-solid fa-shield-heart' => 'shield-heart' ),
					array( 'fa-solid fa-shield-keyhole' => 'shield-keyhole' ),
					array( 'fa-solid fa-shield-minus' => 'shield-minus' ),
					array( 'fa-solid fa-shield-plus' => 'shield-plus' ),
					array( 'fa-solid fa-shield-quartered' => 'shield-quartered' ),
					array( 'fa-solid fa-shield-slash' => 'shield-slash' ),
					array( 'fa-solid fa-shield-virus' => 'shield-virus' ),
					array( 'fa-solid fa-shield-xmark' => 'shield-xmark' ),
					array( 'fa-solid fa-shield' => 'shield' ),
					array( 'fa-solid fa-ship' => 'ship' ),
					array( 'fa-solid fa-shirt-long-sleeve' => 'shirt-long-sleeve' ),
					array( 'fa-solid fa-shirt-running' => 'shirt-running' ),
					array( 'fa-solid fa-shirt-tank-top' => 'shirt-tank-top' ),
					array( 'fa-solid fa-shirt' => 'shirt' ),
					array( 'fa-solid fa-shish-kebab' => 'shish-kebab' ),
					array( 'fa-solid fa-shoe-prints' => 'shoe-prints' ),
					array( 'fa-solid fa-shop-lock' => 'shop-lock' ),
					array( 'fa-solid fa-shop-slash' => 'shop-slash' ),
					array( 'fa-solid fa-shop' => 'shop' ),
					array( 'fa-solid fa-shovel-snow' => 'shovel-snow' ),
					array( 'fa-solid fa-shovel' => 'shovel' ),
					array( 'fa-solid fa-shower-down' => 'shower-down' ),
					array( 'fa-solid fa-shower' => 'shower' ),
					array( 'fa-solid fa-shredder' => 'shredder' ),
					array( 'fa-solid fa-shrimp' => 'shrimp' ),
					array( 'fa-solid fa-shuffle' => 'shuffle' ),
					array( 'fa-solid fa-shutters' => 'shutters' ),
					array( 'fa-solid fa-shuttle-space' => 'shuttle-space' ),
					array( 'fa-solid fa-shuttlecock' => 'shuttlecock' ),
					array( 'fa-solid fa-sickle' => 'sickle' ),
					array( 'fa-solid fa-sidebar-flip' => 'sidebar-flip' ),
					array( 'fa-solid fa-sidebar' => 'sidebar' ),
					array( 'fa-solid fa-sigma' => 'sigma' ),
					array( 'fa-solid fa-sign-hanging' => 'sign-hanging' ),
					array( 'fa-solid fa-signal-bars-fair' => 'signal-bars-fair' ),
					array( 'fa-solid fa-signal-bars-good' => 'signal-bars-good' ),
					array( 'fa-solid fa-signal-bars-slash' => 'signal-bars-slash' ),
					array( 'fa-solid fa-signal-bars-weak' => 'signal-bars-weak' ),
					array( 'fa-solid fa-signal-bars' => 'signal-bars' ),
					array( 'fa-solid fa-signal-fair' => 'signal-fair' ),
					array( 'fa-solid fa-signal-good' => 'signal-good' ),
					array( 'fa-solid fa-signal-slash' => 'signal-slash' ),
					array( 'fa-solid fa-signal-stream-slash' => 'signal-stream-slash' ),
					array( 'fa-solid fa-signal-stream' => 'signal-stream' ),
					array( 'fa-solid fa-signal-strong' => 'signal-strong' ),
					array( 'fa-solid fa-signal-weak' => 'signal-weak' ),
					array( 'fa-solid fa-signal' => 'signal' ),
					array( 'fa-solid fa-signature-lock' => 'signature-lock' ),
					array( 'fa-solid fa-signature-slash' => 'signature-slash' ),
					array( 'fa-solid fa-signature' => 'signature' ),
					array( 'fa-solid fa-signs-post' => 'signs-post' ),
					array( 'fa-solid fa-sim-card' => 'sim-card' ),
					array( 'fa-solid fa-sim-cards' => 'sim-cards' ),
					array( 'fa-solid fa-sink' => 'sink' ),
					array( 'fa-solid fa-siren-on' => 'siren-on' ),
					array( 'fa-solid fa-siren' => 'siren' ),
					array( 'fa-solid fa-sitemap' => 'sitemap' ),
					array( 'fa-solid fa-skeleton-ribs' => 'skeleton-ribs' ),
					array( 'fa-solid fa-skeleton' => 'skeleton' ),
					array( 'fa-solid fa-ski-boot-ski' => 'ski-boot-ski' ),
					array( 'fa-solid fa-ski-boot' => 'ski-boot' ),
					array( 'fa-solid fa-skull-cow' => 'skull-cow' ),
					array( 'fa-solid fa-skull-crossbones' => 'skull-crossbones' ),
					array( 'fa-solid fa-skull' => 'skull' ),
					array( 'fa-solid fa-slash-back' => 'slash-back' ),
					array( 'fa-solid fa-slash-forward' => 'slash-forward' ),
					array( 'fa-solid fa-slash' => 'slash' ),
					array( 'fa-solid fa-sleigh' => 'sleigh' ),
					array( 'fa-solid fa-slider' => 'slider' ),
					array( 'fa-solid fa-sliders-simple' => 'sliders-simple' ),
					array( 'fa-solid fa-sliders-up' => 'sliders-up' ),
					array( 'fa-solid fa-sliders' => 'sliders' ),
					array( 'fa-solid fa-slot-machine' => 'slot-machine' ),
					array( 'fa-solid fa-smog' => 'smog' ),
					array( 'fa-solid fa-smoke' => 'smoke' ),
					array( 'fa-solid fa-smoking' => 'smoking' ),
					array( 'fa-solid fa-snake' => 'snake' ),
					array( 'fa-solid fa-snooze' => 'snooze' ),
					array( 'fa-solid fa-snow-blowing' => 'snow-blowing' ),
					array( 'fa-solid fa-snowflake-droplets' => 'snowflake-droplets' ),
					array( 'fa-solid fa-snowflake' => 'snowflake' ),
					array( 'fa-solid fa-snowflakes' => 'snowflakes' ),
					array( 'fa-solid fa-snowman-head' => 'snowman-head' ),
					array( 'fa-solid fa-snowman' => 'snowman' ),
					array( 'fa-solid fa-snowplow' => 'snowplow' ),
					array( 'fa-solid fa-soap' => 'soap' ),
					array( 'fa-solid fa-socks' => 'socks' ),
					array( 'fa-solid fa-soft-serve' => 'soft-serve' ),
					array( 'fa-solid fa-solar-panel' => 'solar-panel' ),
					array( 'fa-solid fa-solar-system' => 'solar-system' ),
					array( 'fa-solid fa-sort-down' => 'sort-down' ),
					array( 'fa-solid fa-sort-up' => 'sort-up' ),
					array( 'fa-solid fa-sort' => 'sort' ),
					array( 'fa-solid fa-spa' => 'spa' ),
					array( 'fa-solid fa-space-station-moon-construction' => 'space-station-moon-construction' ),
					array( 'fa-solid fa-space-station-moon' => 'space-station-moon' ),
					array( 'fa-solid fa-spade' => 'spade' ),
					array( 'fa-solid fa-spaghetti-monster-flying' => 'spaghetti-monster-flying' ),
					array( 'fa-solid fa-sparkle' => 'sparkle' ),
					array( 'fa-solid fa-sparkles' => 'sparkles' ),
					array( 'fa-solid fa-speaker' => 'speaker' ),
					array( 'fa-solid fa-speakers' => 'speakers' ),
					array( 'fa-solid fa-spell-check' => 'spell-check' ),
					array( 'fa-solid fa-spider-black-widow' => 'spider-black-widow' ),
					array( 'fa-solid fa-spider-web' => 'spider-web' ),
					array( 'fa-solid fa-spider' => 'spider' ),
					array( 'fa-solid fa-spinner-third' => 'spinner-third' ),
					array( 'fa-solid fa-spinner' => 'spinner' ),
					array( 'fa-solid fa-split' => 'split' ),
					array( 'fa-solid fa-splotch' => 'splotch' ),
					array( 'fa-solid fa-spoon' => 'spoon' ),
					array( 'fa-solid fa-sportsball' => 'sportsball' ),
					array( 'fa-solid fa-spray-can-sparkles' => 'spray-can-sparkles' ),
					array( 'fa-solid fa-spray-can' => 'spray-can' ),
					array( 'fa-solid fa-sprinkler-ceiling' => 'sprinkler-ceiling' ),
					array( 'fa-solid fa-sprinkler' => 'sprinkler' ),
					array( 'fa-solid fa-square-0' => 'square-0' ),
					array( 'fa-solid fa-square-1' => 'square-1' ),
					array( 'fa-solid fa-square-2' => 'square-2' ),
					array( 'fa-solid fa-square-3' => 'square-3' ),
					array( 'fa-solid fa-square-4' => 'square-4' ),
					array( 'fa-solid fa-square-5' => 'square-5' ),
					array( 'fa-solid fa-square-6' => 'square-6' ),
					array( 'fa-solid fa-square-7' => 'square-7' ),
					array( 'fa-solid fa-square-8' => 'square-8' ),
					array( 'fa-solid fa-square-9' => 'square-9' ),
					array( 'fa-solid fa-square-a-lock' => 'square-a-lock' ),
					array( 'fa-solid fa-square-a' => 'square-a' ),
					array( 'fa-solid fa-square-ampersand' => 'square-ampersand' ),
					array( 'fa-solid fa-square-arrow-down-left' => 'square-arrow-down-left' ),
					array( 'fa-solid fa-square-arrow-down-right' => 'square-arrow-down-right' ),
					array( 'fa-solid fa-square-arrow-down' => 'square-arrow-down' ),
					array( 'fa-solid fa-square-arrow-left' => 'square-arrow-left' ),
					array( 'fa-solid fa-square-arrow-right' => 'square-arrow-right' ),
					array( 'fa-solid fa-square-arrow-up-left' => 'square-arrow-up-left' ),
					array( 'fa-solid fa-square-arrow-up-right' => 'square-arrow-up-right' ),
					array( 'fa-solid fa-square-arrow-up' => 'square-arrow-up' ),
					array( 'fa-solid fa-square-b' => 'square-b' ),
					array( 'fa-solid fa-square-bolt' => 'square-bolt' ),
					array( 'fa-solid fa-square-c' => 'square-c' ),
					array( 'fa-solid fa-square-caret-down' => 'square-caret-down' ),
					array( 'fa-solid fa-square-caret-left' => 'square-caret-left' ),
					array( 'fa-solid fa-square-caret-right' => 'square-caret-right' ),
					array( 'fa-solid fa-square-caret-up' => 'square-caret-up' ),
					array( 'fa-solid fa-square-check' => 'square-check' ),
					array( 'fa-solid fa-square-chevron-down' => 'square-chevron-down' ),
					array( 'fa-solid fa-square-chevron-left' => 'square-chevron-left' ),
					array( 'fa-solid fa-square-chevron-right' => 'square-chevron-right' ),
					array( 'fa-solid fa-square-chevron-up' => 'square-chevron-up' ),
					array( 'fa-solid fa-square-code' => 'square-code' ),
					array( 'fa-solid fa-square-d' => 'square-d' ),
					array( 'fa-solid fa-square-dashed-circle-plus' => 'square-dashed-circle-plus' ),
					array( 'fa-solid fa-square-dashed' => 'square-dashed' ),
					array( 'fa-solid fa-square-divide' => 'square-divide' ),
					array( 'fa-solid fa-square-dollar' => 'square-dollar' ),
					array( 'fa-solid fa-square-down-left' => 'square-down-left' ),
					array( 'fa-solid fa-square-down-right' => 'square-down-right' ),
					array( 'fa-solid fa-square-down' => 'square-down' ),
					array( 'fa-solid fa-square-e' => 'square-e' ),
					array( 'fa-solid fa-square-ellipsis-vertical' => 'square-ellipsis-vertical' ),
					array( 'fa-solid fa-square-ellipsis' => 'square-ellipsis' ),
					array( 'fa-solid fa-square-envelope' => 'square-envelope' ),
					array( 'fa-solid fa-square-exclamation' => 'square-exclamation' ),
					array( 'fa-solid fa-square-f' => 'square-f' ),
					array( 'fa-solid fa-square-fragile' => 'square-fragile' ),
					array( 'fa-solid fa-square-full' => 'square-full' ),
					array( 'fa-solid fa-square-g' => 'square-g' ),
					array( 'fa-solid fa-square-h' => 'square-h' ),
					array( 'fa-solid fa-square-heart' => 'square-heart' ),
					array( 'fa-solid fa-square-i' => 'square-i' ),
					array( 'fa-solid fa-square-info' => 'square-info' ),
					array( 'fa-solid fa-square-j' => 'square-j' ),
					array( 'fa-solid fa-square-k' => 'square-k' ),
					array( 'fa-solid fa-square-kanban' => 'square-kanban' ),
					array( 'fa-solid fa-square-l' => 'square-l' ),
					array( 'fa-solid fa-square-left' => 'square-left' ),
					array( 'fa-solid fa-square-list' => 'square-list' ),
					array( 'fa-solid fa-square-m' => 'square-m' ),
					array( 'fa-solid fa-square-minus' => 'square-minus' ),
					array( 'fa-solid fa-square-n' => 'square-n' ),
					array( 'fa-solid fa-square-nfi' => 'square-nfi' ),
					array( 'fa-solid fa-square-o' => 'square-o' ),
					array( 'fa-solid fa-square-p' => 'square-p' ),
					array( 'fa-solid fa-square-parking-slash' => 'square-parking-slash' ),
					array( 'fa-solid fa-square-parking' => 'square-parking' ),
					array( 'fa-solid fa-square-pen' => 'square-pen' ),
					array( 'fa-solid fa-square-person-confined' => 'square-person-confined' ),
					array( 'fa-solid fa-square-phone-flip' => 'square-phone-flip' ),
					array( 'fa-solid fa-square-phone-hangup' => 'square-phone-hangup' ),
					array( 'fa-solid fa-square-phone' => 'square-phone' ),
					array( 'fa-solid fa-square-plus' => 'square-plus' ),
					array( 'fa-solid fa-square-poll-horizontal' => 'square-poll-horizontal' ),
					array( 'fa-solid fa-square-poll-vertical' => 'square-poll-vertical' ),
					array( 'fa-solid fa-square-q' => 'square-q' ),
					array( 'fa-solid fa-square-quarters' => 'square-quarters' ),
					array( 'fa-solid fa-square-question' => 'square-question' ),
					array( 'fa-solid fa-square-quote' => 'square-quote' ),
					array( 'fa-solid fa-square-r' => 'square-r' ),
					array( 'fa-solid fa-square-right' => 'square-right' ),
					array( 'fa-solid fa-square-ring' => 'square-ring' ),
					array( 'fa-solid fa-square-root-variable' => 'square-root-variable' ),
					array( 'fa-solid fa-square-root' => 'square-root' ),
					array( 'fa-solid fa-square-rss' => 'square-rss' ),
					array( 'fa-solid fa-square-s' => 'square-s' ),
					array( 'fa-solid fa-square-share-nodes' => 'square-share-nodes' ),
					array( 'fa-solid fa-square-sliders-vertical' => 'square-sliders-vertical' ),
					array( 'fa-solid fa-square-sliders' => 'square-sliders' ),
					array( 'fa-solid fa-square-small' => 'square-small' ),
					array( 'fa-solid fa-square-star' => 'square-star' ),
					array( 'fa-solid fa-square-t' => 'square-t' ),
					array( 'fa-solid fa-square-terminal' => 'square-terminal' ),
					array( 'fa-solid fa-square-this-way-up' => 'square-this-way-up' ),
					array( 'fa-solid fa-square-u' => 'square-u' ),
					array( 'fa-solid fa-square-up-left' => 'square-up-left' ),
					array( 'fa-solid fa-square-up-right' => 'square-up-right' ),
					array( 'fa-solid fa-square-up' => 'square-up' ),
					array( 'fa-solid fa-square-user' => 'square-user' ),
					array( 'fa-solid fa-square-v' => 'square-v' ),
					array( 'fa-solid fa-square-virus' => 'square-virus' ),
					array( 'fa-solid fa-square-w' => 'square-w' ),
					array( 'fa-solid fa-square-x' => 'square-x' ),
					array( 'fa-solid fa-square-xmark' => 'square-xmark' ),
					array( 'fa-solid fa-square-y' => 'square-y' ),
					array( 'fa-solid fa-square-z' => 'square-z' ),
					array( 'fa-solid fa-square' => 'square' ),
					array( 'fa-solid fa-squid' => 'squid' ),
					array( 'fa-solid fa-squirrel' => 'squirrel' ),
					array( 'fa-solid fa-staff-snake' => 'staff-snake' ),
					array( 'fa-solid fa-staff' => 'staff' ),
					array( 'fa-solid fa-stairs' => 'stairs' ),
					array( 'fa-solid fa-stamp' => 'stamp' ),
					array( 'fa-solid fa-standard-definition' => 'standard-definition' ),
					array( 'fa-solid fa-stapler' => 'stapler' ),
					array( 'fa-solid fa-star-and-crescent' => 'star-and-crescent' ),
					array( 'fa-solid fa-star-christmas' => 'star-christmas' ),
					array( 'fa-solid fa-star-exclamation' => 'star-exclamation' ),
					array( 'fa-solid fa-star-half-stroke' => 'star-half-stroke' ),
					array( 'fa-solid fa-star-half' => 'star-half' ),
					array( 'fa-solid fa-star-of-david' => 'star-of-david' ),
					array( 'fa-solid fa-star-of-life' => 'star-of-life' ),
					array( 'fa-solid fa-star-sharp-half-stroke' => 'star-sharp-half-stroke' ),
					array( 'fa-solid fa-star-sharp-half' => 'star-sharp-half' ),
					array( 'fa-solid fa-star-sharp' => 'star-sharp' ),
					array( 'fa-solid fa-star-shooting' => 'star-shooting' ),
					array( 'fa-solid fa-star' => 'star' ),
					array( 'fa-solid fa-starfighter-twin-ion-engine-advanced' => 'starfighter-twin-ion-engine-advanced' ),
					array( 'fa-solid fa-starfighter-twin-ion-engine' => 'starfighter-twin-ion-engine' ),
					array( 'fa-solid fa-starfighter' => 'starfighter' ),
					array( 'fa-solid fa-stars' => 'stars' ),
					array( 'fa-solid fa-starship-freighter' => 'starship-freighter' ),
					array( 'fa-solid fa-starship' => 'starship' ),
					array( 'fa-solid fa-steak' => 'steak' ),
					array( 'fa-solid fa-steering-wheel' => 'steering-wheel' ),
					array( 'fa-solid fa-sterling-sign' => 'sterling-sign' ),
					array( 'fa-solid fa-stethoscope' => 'stethoscope' ),
					array( 'fa-solid fa-stocking' => 'stocking' ),
					array( 'fa-solid fa-stomach' => 'stomach' ),
					array( 'fa-solid fa-stop' => 'stop' ),
					array( 'fa-solid fa-stopwatch-20' => 'stopwatch-20' ),
					array( 'fa-solid fa-stopwatch' => 'stopwatch' ),
					array( 'fa-solid fa-store-lock' => 'store-lock' ),
					array( 'fa-solid fa-store-slash' => 'store-slash' ),
					array( 'fa-solid fa-store' => 'store' ),
					array( 'fa-solid fa-strawberry' => 'strawberry' ),
					array( 'fa-solid fa-street-view' => 'street-view' ),
					array( 'fa-solid fa-stretcher' => 'stretcher' ),
					array( 'fa-solid fa-strikethrough' => 'strikethrough' ),
					array( 'fa-solid fa-stroopwafel' => 'stroopwafel' ),
					array( 'fa-solid fa-subscript' => 'subscript' ),
					array( 'fa-solid fa-subtitles-slash' => 'subtitles-slash' ),
					array( 'fa-solid fa-subtitles' => 'subtitles' ),
					array( 'fa-solid fa-suitcase-medical' => 'suitcase-medical' ),
					array( 'fa-solid fa-suitcase-rolling' => 'suitcase-rolling' ),
					array( 'fa-solid fa-suitcase' => 'suitcase' ),
					array( 'fa-solid fa-sun-bright' => 'sun-bright' ),
					array( 'fa-solid fa-sun-cloud' => 'sun-cloud' ),
					array( 'fa-solid fa-sun-dust' => 'sun-dust' ),
					array( 'fa-solid fa-sun-haze' => 'sun-haze' ),
					array( 'fa-solid fa-sun-plant-wilt' => 'sun-plant-wilt' ),
					array( 'fa-solid fa-sun' => 'sun' ),
					array( 'fa-solid fa-sunglasses' => 'sunglasses' ),
					array( 'fa-solid fa-sunrise' => 'sunrise' ),
					array( 'fa-solid fa-sunset' => 'sunset' ),
					array( 'fa-solid fa-superscript' => 'superscript' ),
					array( 'fa-solid fa-sushi-roll' => 'sushi-roll' ),
					array( 'fa-solid fa-sushi' => 'sushi' ),
					array( 'fa-solid fa-swap-arrows' => 'swap-arrows' ),
					array( 'fa-solid fa-swap' => 'swap' ),
					array( 'fa-solid fa-swatchbook' => 'swatchbook' ),
					array( 'fa-solid fa-sword-laser-alt' => 'sword-laser-alt' ),
					array( 'fa-solid fa-sword-laser' => 'sword-laser' ),
					array( 'fa-solid fa-sword' => 'sword' ),
					array( 'fa-solid fa-swords-laser' => 'swords-laser' ),
					array( 'fa-solid fa-swords' => 'swords' ),
					array( 'fa-solid fa-symbols' => 'symbols' ),
					array( 'fa-solid fa-synagogue' => 'synagogue' ),
					array( 'fa-solid fa-syringe' => 'syringe' ),
					array( 'fa-solid fa-t' => 't' ),
					array( 'fa-solid fa-table-cells-large' => 'table-cells-large' ),
					array( 'fa-solid fa-table-cells' => 'table-cells' ),
					array( 'fa-solid fa-table-columns' => 'table-columns' ),
					array( 'fa-solid fa-table-layout' => 'table-layout' ),
					array( 'fa-solid fa-table-list' => 'table-list' ),
					array( 'fa-solid fa-table-picnic' => 'table-picnic' ),
					array( 'fa-solid fa-table-pivot' => 'table-pivot' ),
					array( 'fa-solid fa-table-rows' => 'table-rows' ),
					array( 'fa-solid fa-table-tennis-paddle-ball' => 'table-tennis-paddle-ball' ),
					array( 'fa-solid fa-table-tree' => 'table-tree' ),
					array( 'fa-solid fa-table' => 'table' ),
					array( 'fa-solid fa-tablet-button' => 'tablet-button' ),
					array( 'fa-solid fa-tablet-rugged' => 'tablet-rugged' ),
					array( 'fa-solid fa-tablet-screen-button' => 'tablet-screen-button' ),
					array( 'fa-solid fa-tablet-screen' => 'tablet-screen' ),
					array( 'fa-solid fa-tablet' => 'tablet' ),
					array( 'fa-solid fa-tablets' => 'tablets' ),
					array( 'fa-solid fa-tachograph-digital' => 'tachograph-digital' ),
					array( 'fa-solid fa-taco' => 'taco' ),
					array( 'fa-solid fa-tag' => 'tag' ),
					array( 'fa-solid fa-tags' => 'tags' ),
					array( 'fa-solid fa-tally-1' => 'tally-1' ),
					array( 'fa-solid fa-tally-2' => 'tally-2' ),
					array( 'fa-solid fa-tally-3' => 'tally-3' ),
					array( 'fa-solid fa-tally-4' => 'tally-4' ),
					array( 'fa-solid fa-tally' => 'tally' ),
					array( 'fa-solid fa-tamale' => 'tamale' ),
					array( 'fa-solid fa-tank-water' => 'tank-water' ),
					array( 'fa-solid fa-tape' => 'tape' ),
					array( 'fa-solid fa-tarp-droplet' => 'tarp-droplet' ),
					array( 'fa-solid fa-tarp' => 'tarp' ),
					array( 'fa-solid fa-taxi-bus' => 'taxi-bus' ),
					array( 'fa-solid fa-taxi' => 'taxi' ),
					array( 'fa-solid fa-teddy-bear' => 'teddy-bear' ),
					array( 'fa-solid fa-teeth-open' => 'teeth-open' ),
					array( 'fa-solid fa-teeth' => 'teeth' ),
					array( 'fa-solid fa-telescope' => 'telescope' ),
					array( 'fa-solid fa-temperature-arrow-down' => 'temperature-arrow-down' ),
					array( 'fa-solid fa-temperature-arrow-up' => 'temperature-arrow-up' ),
					array( 'fa-solid fa-temperature-empty' => 'temperature-empty' ),
					array( 'fa-solid fa-temperature-full' => 'temperature-full' ),
					array( 'fa-solid fa-temperature-half' => 'temperature-half' ),
					array( 'fa-solid fa-temperature-high' => 'temperature-high' ),
					array( 'fa-solid fa-temperature-list' => 'temperature-list' ),
					array( 'fa-solid fa-temperature-low' => 'temperature-low' ),
					array( 'fa-solid fa-temperature-quarter' => 'temperature-quarter' ),
					array( 'fa-solid fa-temperature-snow' => 'temperature-snow' ),
					array( 'fa-solid fa-temperature-sun' => 'temperature-sun' ),
					array( 'fa-solid fa-temperature-three-quarters' => 'temperature-three-quarters' ),
					array( 'fa-solid fa-tenge-sign' => 'tenge-sign' ),
					array( 'fa-solid fa-tennis-ball' => 'tennis-ball' ),
					array( 'fa-solid fa-tent-arrow-down-to-line' => 'tent-arrow-down-to-line' ),
					array( 'fa-solid fa-tent-arrow-left-right' => 'tent-arrow-left-right' ),
					array( 'fa-solid fa-tent-arrow-turn-left' => 'tent-arrow-turn-left' ),
					array( 'fa-solid fa-tent-arrows-down' => 'tent-arrows-down' ),
					array( 'fa-solid fa-tent' => 'tent' ),
					array( 'fa-solid fa-tents' => 'tents' ),
					array( 'fa-solid fa-terminal' => 'terminal' ),
					array( 'fa-solid fa-text-height' => 'text-height' ),
					array( 'fa-solid fa-text-size' => 'text-size' ),
					array( 'fa-solid fa-text-slash' => 'text-slash' ),
					array( 'fa-solid fa-text-width' => 'text-width' ),
					array( 'fa-solid fa-text' => 'text' ),
					array( 'fa-solid fa-thermometer' => 'thermometer' ),
					array( 'fa-solid fa-theta' => 'theta' ),
					array( 'fa-solid fa-thought-bubble' => 'thought-bubble' ),
					array( 'fa-solid fa-thumbs-down' => 'thumbs-down' ),
					array( 'fa-solid fa-thumbs-up' => 'thumbs-up' ),
					array( 'fa-solid fa-thumbtack' => 'thumbtack' ),
					array( 'fa-solid fa-tick' => 'tick' ),
					array( 'fa-solid fa-ticket-airline' => 'ticket-airline' ),
					array( 'fa-solid fa-ticket-simple' => 'ticket-simple' ),
					array( 'fa-solid fa-ticket' => 'ticket' ),
					array( 'fa-solid fa-tickets-airline' => 'tickets-airline' ),
					array( 'fa-solid fa-tilde' => 'tilde' ),
					array( 'fa-solid fa-timeline-arrow' => 'timeline-arrow' ),
					array( 'fa-solid fa-timeline' => 'timeline' ),
					array( 'fa-solid fa-timer' => 'timer' ),
					array( 'fa-solid fa-tire-flat' => 'tire-flat' ),
					array( 'fa-solid fa-tire-pressure-warning' => 'tire-pressure-warning' ),
					array( 'fa-solid fa-tire-rugged' => 'tire-rugged' ),
					array( 'fa-solid fa-tire' => 'tire' ),
					array( 'fa-solid fa-toggle-large-off' => 'toggle-large-off' ),
					array( 'fa-solid fa-toggle-large-on' => 'toggle-large-on' ),
					array( 'fa-solid fa-toggle-off' => 'toggle-off' ),
					array( 'fa-solid fa-toggle-on' => 'toggle-on' ),
					array( 'fa-solid fa-toilet-paper-blank-under' => 'toilet-paper-blank-under' ),
					array( 'fa-solid fa-toilet-paper-blank' => 'toilet-paper-blank' ),
					array( 'fa-solid fa-toilet-paper-check' => 'toilet-paper-check' ),
					array( 'fa-solid fa-toilet-paper-slash' => 'toilet-paper-slash' ),
					array( 'fa-solid fa-toilet-paper-under-slash' => 'toilet-paper-under-slash' ),
					array( 'fa-solid fa-toilet-paper-under' => 'toilet-paper-under' ),
					array( 'fa-solid fa-toilet-paper-xmark' => 'toilet-paper-xmark' ),
					array( 'fa-solid fa-toilet-paper' => 'toilet-paper' ),
					array( 'fa-solid fa-toilet-portable' => 'toilet-portable' ),
					array( 'fa-solid fa-toilet' => 'toilet' ),
					array( 'fa-solid fa-toilets-portable' => 'toilets-portable' ),
					array( 'fa-solid fa-tomato' => 'tomato' ),
					array( 'fa-solid fa-tombstone-blank' => 'tombstone-blank' ),
					array( 'fa-solid fa-tombstone' => 'tombstone' ),
					array( 'fa-solid fa-toolbox' => 'toolbox' ),
					array( 'fa-solid fa-tooth' => 'tooth' ),
					array( 'fa-solid fa-toothbrush' => 'toothbrush' ),
					array( 'fa-solid fa-torii-gate' => 'torii-gate' ),
					array( 'fa-solid fa-tornado' => 'tornado' ),
					array( 'fa-solid fa-tower-broadcast' => 'tower-broadcast' ),
					array( 'fa-solid fa-tower-cell' => 'tower-cell' ),
					array( 'fa-solid fa-tower-control' => 'tower-control' ),
					array( 'fa-solid fa-tower-observation' => 'tower-observation' ),
					array( 'fa-solid fa-tractor' => 'tractor' ),
					array( 'fa-solid fa-trademark' => 'trademark' ),
					array( 'fa-solid fa-traffic-cone' => 'traffic-cone' ),
					array( 'fa-solid fa-traffic-light-go' => 'traffic-light-go' ),
					array( 'fa-solid fa-traffic-light-slow' => 'traffic-light-slow' ),
					array( 'fa-solid fa-traffic-light-stop' => 'traffic-light-stop' ),
					array( 'fa-solid fa-traffic-light' => 'traffic-light' ),
					array( 'fa-solid fa-trailer' => 'trailer' ),
					array( 'fa-solid fa-train-subway-tunnel' => 'train-subway-tunnel' ),
					array( 'fa-solid fa-train-subway' => 'train-subway' ),
					array( 'fa-solid fa-train-track' => 'train-track' ),
					array( 'fa-solid fa-train-tram' => 'train-tram' ),
					array( 'fa-solid fa-train-tunnel' => 'train-tunnel' ),
					array( 'fa-solid fa-train' => 'train' ),
					array( 'fa-solid fa-transformer-bolt' => 'transformer-bolt' ),
					array( 'fa-solid fa-transgender' => 'transgender' ),
					array( 'fa-solid fa-transporter-1' => 'transporter-1' ),
					array( 'fa-solid fa-transporter-2' => 'transporter-2' ),
					array( 'fa-solid fa-transporter-3' => 'transporter-3' ),
					array( 'fa-solid fa-transporter-4' => 'transporter-4' ),
					array( 'fa-solid fa-transporter-5' => 'transporter-5' ),
					array( 'fa-solid fa-transporter-6' => 'transporter-6' ),
					array( 'fa-solid fa-transporter-7' => 'transporter-7' ),
					array( 'fa-solid fa-transporter-empty' => 'transporter-empty' ),
					array( 'fa-solid fa-transporter' => 'transporter' ),
					array( 'fa-solid fa-trash-arrow-up' => 'trash-arrow-up' ),
					array( 'fa-solid fa-trash-can-arrow-up' => 'trash-can-arrow-up' ),
					array( 'fa-solid fa-trash-can-check' => 'trash-can-check' ),
					array( 'fa-solid fa-trash-can-clock' => 'trash-can-clock' ),
					array( 'fa-solid fa-trash-can-list' => 'trash-can-list' ),
					array( 'fa-solid fa-trash-can-plus' => 'trash-can-plus' ),
					array( 'fa-solid fa-trash-can-slash' => 'trash-can-slash' ),
					array( 'fa-solid fa-trash-can-undo' => 'trash-can-undo' ),
					array( 'fa-solid fa-trash-can-xmark' => 'trash-can-xmark' ),
					array( 'fa-solid fa-trash-can' => 'trash-can' ),
					array( 'fa-solid fa-trash-check' => 'trash-check' ),
					array( 'fa-solid fa-trash-clock' => 'trash-clock' ),
					array( 'fa-solid fa-trash-list' => 'trash-list' ),
					array( 'fa-solid fa-trash-plus' => 'trash-plus' ),
					array( 'fa-solid fa-trash-slash' => 'trash-slash' ),
					array( 'fa-solid fa-trash-undo' => 'trash-undo' ),
					array( 'fa-solid fa-trash-xmark' => 'trash-xmark' ),
					array( 'fa-solid fa-trash' => 'trash' ),
					array( 'fa-solid fa-treasure-chest' => 'treasure-chest' ),
					array( 'fa-solid fa-tree-christmas' => 'tree-christmas' ),
					array( 'fa-solid fa-tree-city' => 'tree-city' ),
					array( 'fa-solid fa-tree-deciduous' => 'tree-deciduous' ),
					array( 'fa-solid fa-tree-decorated' => 'tree-decorated' ),
					array( 'fa-solid fa-tree-large' => 'tree-large' ),
					array( 'fa-solid fa-tree-palm' => 'tree-palm' ),
					array( 'fa-solid fa-tree' => 'tree' ),
					array( 'fa-solid fa-trees' => 'trees' ),
					array( 'fa-solid fa-triangle-exclamation' => 'triangle-exclamation' ),
					array( 'fa-solid fa-triangle-instrument' => 'triangle-instrument' ),
					array( 'fa-solid fa-triangle-person-digging' => 'triangle-person-digging' ),
					array( 'fa-solid fa-triangle' => 'triangle' ),
					array( 'fa-solid fa-tricycle-adult' => 'tricycle-adult' ),
					array( 'fa-solid fa-tricycle' => 'tricycle' ),
					array( 'fa-solid fa-trillium' => 'trillium' ),
					array( 'fa-solid fa-trophy-star' => 'trophy-star' ),
					array( 'fa-solid fa-trophy' => 'trophy' ),
					array( 'fa-solid fa-trowel-bricks' => 'trowel-bricks' ),
					array( 'fa-solid fa-trowel' => 'trowel' ),
					array( 'fa-solid fa-truck-arrow-right' => 'truck-arrow-right' ),
					array( 'fa-solid fa-truck-bolt' => 'truck-bolt' ),
					array( 'fa-solid fa-truck-clock' => 'truck-clock' ),
					array( 'fa-solid fa-truck-container-empty' => 'truck-container-empty' ),
					array( 'fa-solid fa-truck-container' => 'truck-container' ),
					array( 'fa-solid fa-truck-droplet' => 'truck-droplet' ),
					array( 'fa-solid fa-truck-fast' => 'truck-fast' ),
					array( 'fa-solid fa-truck-field-un' => 'truck-field-un' ),
					array( 'fa-solid fa-truck-field' => 'truck-field' ),
					array( 'fa-solid fa-truck-flatbed' => 'truck-flatbed' ),
					array( 'fa-solid fa-truck-front' => 'truck-front' ),
					array( 'fa-solid fa-truck-medical' => 'truck-medical' ),
					array( 'fa-solid fa-truck-monster' => 'truck-monster' ),
					array( 'fa-solid fa-truck-moving' => 'truck-moving' ),
					array( 'fa-solid fa-truck-pickup' => 'truck-pickup' ),
					array( 'fa-solid fa-truck-plane' => 'truck-plane' ),
					array( 'fa-solid fa-truck-plow' => 'truck-plow' ),
					array( 'fa-solid fa-truck-ramp-box' => 'truck-ramp-box' ),
					array( 'fa-solid fa-truck-ramp-couch' => 'truck-ramp-couch' ),
					array( 'fa-solid fa-truck-ramp' => 'truck-ramp' ),
					array( 'fa-solid fa-truck-tow' => 'truck-tow' ),
					array( 'fa-solid fa-truck' => 'truck' ),
					array( 'fa-solid fa-trumpet' => 'trumpet' ),
					array( 'fa-solid fa-tty-answer' => 'tty-answer' ),
					array( 'fa-solid fa-tty' => 'tty' ),
					array( 'fa-solid fa-tugrik-sign' => 'tugrik-sign' ),
					array( 'fa-solid fa-turkey' => 'turkey' ),
					array( 'fa-solid fa-turkish-lira-sign' => 'turkish-lira-sign' ),
					array( 'fa-solid fa-turn-down-left' => 'turn-down-left' ),
					array( 'fa-solid fa-turn-down-right' => 'turn-down-right' ),
					array( 'fa-solid fa-turn-down' => 'turn-down' ),
					array( 'fa-solid fa-turn-up' => 'turn-up' ),
					array( 'fa-solid fa-turntable' => 'turntable' ),
					array( 'fa-solid fa-turtle' => 'turtle' ),
					array( 'fa-solid fa-tv-music' => 'tv-music' ),
					array( 'fa-solid fa-tv-retro' => 'tv-retro' ),
					array( 'fa-solid fa-tv' => 'tv' ),
					array( 'fa-solid fa-typewriter' => 'typewriter' ),
					array( 'fa-solid fa-u' => 'u' ),
					array( 'fa-solid fa-ufo-beam' => 'ufo-beam' ),
					array( 'fa-solid fa-ufo' => 'ufo' ),
					array( 'fa-solid fa-umbrella-beach' => 'umbrella-beach' ),
					array( 'fa-solid fa-umbrella-simple' => 'umbrella-simple' ),
					array( 'fa-solid fa-umbrella' => 'umbrella' ),
					array( 'fa-solid fa-underline' => 'underline' ),
					array( 'fa-solid fa-unicorn' => 'unicorn' ),
					array( 'fa-solid fa-uniform-martial-arts' => 'uniform-martial-arts' ),
					array( 'fa-solid fa-union' => 'union' ),
					array( 'fa-solid fa-universal-access' => 'universal-access' ),
					array( 'fa-solid fa-unlock-keyhole' => 'unlock-keyhole' ),
					array( 'fa-solid fa-unlock' => 'unlock' ),
					array( 'fa-solid fa-up-down-left-right' => 'up-down-left-right' ),
					array( 'fa-solid fa-up-down' => 'up-down' ),
					array( 'fa-solid fa-up-from-bracket' => 'up-from-bracket' ),
					array( 'fa-solid fa-up-from-dotted-line' => 'up-from-dotted-line' ),
					array( 'fa-solid fa-up-from-line' => 'up-from-line' ),
					array( 'fa-solid fa-up-left' => 'up-left' ),
					array( 'fa-solid fa-up-long' => 'up-long' ),
					array( 'fa-solid fa-up-right-and-down-left-from-center' => 'up-right-and-down-left-from-center' ),
					array( 'fa-solid fa-up-right-from-square' => 'up-right-from-square' ),
					array( 'fa-solid fa-up-right' => 'up-right' ),
					array( 'fa-solid fa-up-to-dotted-line' => 'up-to-dotted-line' ),
					array( 'fa-solid fa-up-to-line' => 'up-to-line' ),
					array( 'fa-solid fa-up' => 'up' ),
					array( 'fa-solid fa-upload' => 'upload' ),
					array( 'fa-solid fa-usb-drive' => 'usb-drive' ),
					array( 'fa-solid fa-user-alien' => 'user-alien' ),
					array( 'fa-solid fa-user-astronaut' => 'user-astronaut' ),
					array( 'fa-solid fa-user-bounty-hunter' => 'user-bounty-hunter' ),
					array( 'fa-solid fa-user-check' => 'user-check' ),
					array( 'fa-solid fa-user-chef' => 'user-chef' ),
					array( 'fa-solid fa-user-clock' => 'user-clock' ),
					array( 'fa-solid fa-user-cowboy' => 'user-cowboy' ),
					array( 'fa-solid fa-user-crown' => 'user-crown' ),
					array( 'fa-solid fa-user-doctor-hair-long' => 'user-doctor-hair-long' ),
					array( 'fa-solid fa-user-doctor-hair' => 'user-doctor-hair' ),
					array( 'fa-solid fa-user-doctor-message' => 'user-doctor-message' ),
					array( 'fa-solid fa-user-doctor' => 'user-doctor' ),
					array( 'fa-solid fa-user-gear' => 'user-gear' ),
					array( 'fa-solid fa-user-graduate' => 'user-graduate' ),
					array( 'fa-solid fa-user-group-crown' => 'user-group-crown' ),
					array( 'fa-solid fa-user-group-simple' => 'user-group-simple' ),
					array( 'fa-solid fa-user-group' => 'user-group' ),
					array( 'fa-solid fa-user-hair-buns' => 'user-hair-buns' ),
					array( 'fa-solid fa-user-hair-long' => 'user-hair-long' ),
					array( 'fa-solid fa-user-hair-mullet' => 'user-hair-mullet' ),
					array( 'fa-solid fa-user-hair' => 'user-hair' ),
					array( 'fa-solid fa-user-headset' => 'user-headset' ),
					array( 'fa-solid fa-user-helmet-safety' => 'user-helmet-safety' ),
					array( 'fa-solid fa-user-injured' => 'user-injured' ),
					array( 'fa-solid fa-user-large-slash' => 'user-large-slash' ),
					array( 'fa-solid fa-user-large' => 'user-large' ),
					array( 'fa-solid fa-user-lock' => 'user-lock' ),
					array( 'fa-solid fa-user-magnifying-glass' => 'user-magnifying-glass' ),
					array( 'fa-solid fa-user-minus' => 'user-minus' ),
					array( 'fa-solid fa-user-music' => 'user-music' ),
					array( 'fa-solid fa-user-ninja' => 'user-ninja' ),
					array( 'fa-solid fa-user-nurse-hair-long' => 'user-nurse-hair-long' ),
					array( 'fa-solid fa-user-nurse-hair' => 'user-nurse-hair' ),
					array( 'fa-solid fa-user-nurse' => 'user-nurse' ),
					array( 'fa-solid fa-user-pen' => 'user-pen' ),
					array( 'fa-solid fa-user-pilot-tie' => 'user-pilot-tie' ),
					array( 'fa-solid fa-user-pilot' => 'user-pilot' ),
					array( 'fa-solid fa-user-plus' => 'user-plus' ),
					array( 'fa-solid fa-user-police-tie' => 'user-police-tie' ),
					array( 'fa-solid fa-user-police' => 'user-police' ),
					array( 'fa-solid fa-user-robot-xmarks' => 'user-robot-xmarks' ),
					array( 'fa-solid fa-user-robot' => 'user-robot' ),
					array( 'fa-solid fa-user-secret' => 'user-secret' ),
					array( 'fa-solid fa-user-shakespeare' => 'user-shakespeare' ),
					array( 'fa-solid fa-user-shield' => 'user-shield' ),
					array( 'fa-solid fa-user-slash' => 'user-slash' ),
					array( 'fa-solid fa-user-tag' => 'user-tag' ),
					array( 'fa-solid fa-user-tie-hair-long' => 'user-tie-hair-long' ),
					array( 'fa-solid fa-user-tie-hair' => 'user-tie-hair' ),
					array( 'fa-solid fa-user-tie' => 'user-tie' ),
					array( 'fa-solid fa-user-unlock' => 'user-unlock' ),
					array( 'fa-solid fa-user-visor' => 'user-visor' ),
					array( 'fa-solid fa-user-vneck-hair-long' => 'user-vneck-hair-long' ),
					array( 'fa-solid fa-user-vneck-hair' => 'user-vneck-hair' ),
					array( 'fa-solid fa-user-vneck' => 'user-vneck' ),
					array( 'fa-solid fa-user-xmark' => 'user-xmark' ),
					array( 'fa-solid fa-user' => 'user' ),
					array( 'fa-solid fa-users-between-lines' => 'users-between-lines' ),
					array( 'fa-solid fa-users-gear' => 'users-gear' ),
					array( 'fa-solid fa-users-line' => 'users-line' ),
					array( 'fa-solid fa-users-medical' => 'users-medical' ),
					array( 'fa-solid fa-users-rays' => 'users-rays' ),
					array( 'fa-solid fa-users-rectangle' => 'users-rectangle' ),
					array( 'fa-solid fa-users-slash' => 'users-slash' ),
					array( 'fa-solid fa-users-viewfinder' => 'users-viewfinder' ),
					array( 'fa-solid fa-users' => 'users' ),
					array( 'fa-solid fa-utensils-slash' => 'utensils-slash' ),
					array( 'fa-solid fa-utensils' => 'utensils' ),
					array( 'fa-solid fa-utility-pole-double' => 'utility-pole-double' ),
					array( 'fa-solid fa-utility-pole' => 'utility-pole' ),
					array( 'fa-solid fa-v' => 'v' ),
					array( 'fa-solid fa-vacuum-robot' => 'vacuum-robot' ),
					array( 'fa-solid fa-vacuum' => 'vacuum' ),
					array( 'fa-solid fa-value-absolute' => 'value-absolute' ),
					array( 'fa-solid fa-van-shuttle' => 'van-shuttle' ),
					array( 'fa-solid fa-vault' => 'vault' ),
					array( 'fa-solid fa-vector-circle' => 'vector-circle' ),
					array( 'fa-solid fa-vector-polygon' => 'vector-polygon' ),
					array( 'fa-solid fa-vector-square' => 'vector-square' ),
					array( 'fa-solid fa-vent-damper' => 'vent-damper' ),
					array( 'fa-solid fa-venus-double' => 'venus-double' ),
					array( 'fa-solid fa-venus-mars' => 'venus-mars' ),
					array( 'fa-solid fa-venus' => 'venus' ),
					array( 'fa-solid fa-vest-patches' => 'vest-patches' ),
					array( 'fa-solid fa-vest' => 'vest' ),
					array( 'fa-solid fa-vial-circle-check' => 'vial-circle-check' ),
					array( 'fa-solid fa-vial-virus' => 'vial-virus' ),
					array( 'fa-solid fa-vial' => 'vial' ),
					array( 'fa-solid fa-vials' => 'vials' ),
					array( 'fa-solid fa-video-arrow-down-left' => 'video-arrow-down-left' ),
					array( 'fa-solid fa-video-arrow-up-right' => 'video-arrow-up-right' ),
					array( 'fa-solid fa-video-plus' => 'video-plus' ),
					array( 'fa-solid fa-video-slash' => 'video-slash' ),
					array( 'fa-solid fa-video' => 'video' ),
					array( 'fa-solid fa-vihara' => 'vihara' ),
					array( 'fa-solid fa-violin' => 'violin' ),
					array( 'fa-solid fa-virus-covid-slash' => 'virus-covid-slash' ),
					array( 'fa-solid fa-virus-covid' => 'virus-covid' ),
					array( 'fa-solid fa-virus-slash' => 'virus-slash' ),
					array( 'fa-solid fa-virus' => 'virus' ),
					array( 'fa-solid fa-viruses' => 'viruses' ),
					array( 'fa-solid fa-voicemail' => 'voicemail' ),
					array( 'fa-solid fa-volcano' => 'volcano' ),
					array( 'fa-solid fa-volleyball' => 'volleyball' ),
					array( 'fa-solid fa-volume-high' => 'volume-high' ),
					array( 'fa-solid fa-volume-low' => 'volume-low' ),
					array( 'fa-solid fa-volume-off' => 'volume-off' ),
					array( 'fa-solid fa-volume-slash' => 'volume-slash' ),
					array( 'fa-solid fa-volume-xmark' => 'volume-xmark' ),
					array( 'fa-solid fa-volume' => 'volume' ),
					array( 'fa-solid fa-vr-cardboard' => 'vr-cardboard' ),
					array( 'fa-solid fa-w' => 'w' ),
					array( 'fa-solid fa-waffle' => 'waffle' ),
					array( 'fa-solid fa-wagon-covered' => 'wagon-covered' ),
					array( 'fa-solid fa-walker' => 'walker' ),
					array( 'fa-solid fa-walkie-talkie' => 'walkie-talkie' ),
					array( 'fa-solid fa-wallet' => 'wallet' ),
					array( 'fa-solid fa-wand-magic-sparkles' => 'wand-magic-sparkles' ),
					array( 'fa-solid fa-wand-magic' => 'wand-magic' ),
					array( 'fa-solid fa-wand-sparkles' => 'wand-sparkles' ),
					array( 'fa-solid fa-wand' => 'wand' ),
					array( 'fa-solid fa-warehouse-full' => 'warehouse-full' ),
					array( 'fa-solid fa-warehouse' => 'warehouse' ),
					array( 'fa-solid fa-washing-machine' => 'washing-machine' ),
					array( 'fa-solid fa-watch-apple' => 'watch-apple' ),
					array( 'fa-solid fa-watch-calculator' => 'watch-calculator' ),
					array( 'fa-solid fa-watch-fitness' => 'watch-fitness' ),
					array( 'fa-solid fa-watch-smart' => 'watch-smart' ),
					array( 'fa-solid fa-watch' => 'watch' ),
					array( 'fa-solid fa-water-arrow-down' => 'water-arrow-down' ),
					array( 'fa-solid fa-water-arrow-up' => 'water-arrow-up' ),
					array( 'fa-solid fa-water-ladder' => 'water-ladder' ),
					array( 'fa-solid fa-water' => 'water' ),
					array( 'fa-solid fa-watermelon-slice' => 'watermelon-slice' ),
					array( 'fa-solid fa-wave-pulse' => 'wave-pulse' ),
					array( 'fa-solid fa-wave-sine' => 'wave-sine' ),
					array( 'fa-solid fa-wave-square' => 'wave-square' ),
					array( 'fa-solid fa-wave-triangle' => 'wave-triangle' ),
					array( 'fa-solid fa-waveform-lines' => 'waveform-lines' ),
					array( 'fa-solid fa-waveform' => 'waveform' ),
					array( 'fa-solid fa-webhook' => 'webhook' ),
					array( 'fa-solid fa-weight-hanging' => 'weight-hanging' ),
					array( 'fa-solid fa-weight-scale' => 'weight-scale' ),
					array( 'fa-solid fa-whale' => 'whale' ),
					array( 'fa-solid fa-wheat-awn-circle-exclamation' => 'wheat-awn-circle-exclamation' ),
					array( 'fa-solid fa-wheat-awn-slash' => 'wheat-awn-slash' ),
					array( 'fa-solid fa-wheat-awn' => 'wheat-awn' ),
					array( 'fa-solid fa-wheat-slash' => 'wheat-slash' ),
					array( 'fa-solid fa-wheat' => 'wheat' ),
					array( 'fa-solid fa-wheelchair-move' => 'wheelchair-move' ),
					array( 'fa-solid fa-wheelchair' => 'wheelchair' ),
					array( 'fa-solid fa-whiskey-glass-ice' => 'whiskey-glass-ice' ),
					array( 'fa-solid fa-whiskey-glass' => 'whiskey-glass' ),
					array( 'fa-solid fa-whistle' => 'whistle' ),
					array( 'fa-solid fa-wifi-exclamation' => 'wifi-exclamation' ),
					array( 'fa-solid fa-wifi-fair' => 'wifi-fair' ),
					array( 'fa-solid fa-wifi-slash' => 'wifi-slash' ),
					array( 'fa-solid fa-wifi-weak' => 'wifi-weak' ),
					array( 'fa-solid fa-wifi' => 'wifi' ),
					array( 'fa-solid fa-wind-turbine' => 'wind-turbine' ),
					array( 'fa-solid fa-wind-warning' => 'wind-warning' ),
					array( 'fa-solid fa-wind' => 'wind' ),
					array( 'fa-solid fa-window-flip' => 'window-flip' ),
					array( 'fa-solid fa-window-frame-open' => 'window-frame-open' ),
					array( 'fa-solid fa-window-frame' => 'window-frame' ),
					array( 'fa-solid fa-window-maximize' => 'window-maximize' ),
					array( 'fa-solid fa-window-minimize' => 'window-minimize' ),
					array( 'fa-solid fa-window-restore' => 'window-restore' ),
					array( 'fa-solid fa-window' => 'window' ),
					array( 'fa-solid fa-windsock' => 'windsock' ),
					array( 'fa-solid fa-wine-bottle' => 'wine-bottle' ),
					array( 'fa-solid fa-wine-glass-crack' => 'wine-glass-crack' ),
					array( 'fa-solid fa-wine-glass-empty' => 'wine-glass-empty' ),
					array( 'fa-solid fa-wine-glass' => 'wine-glass' ),
					array( 'fa-solid fa-won-sign' => 'won-sign' ),
					array( 'fa-solid fa-worm' => 'worm' ),
					array( 'fa-solid fa-wreath-laurel' => 'wreath-laurel' ),
					array( 'fa-solid fa-wreath' => 'wreath' ),
					array( 'fa-solid fa-wrench-simple' => 'wrench-simple' ),
					array( 'fa-solid fa-wrench' => 'wrench' ),
					array( 'fa-solid fa-x-ray' => 'x-ray' ),
					array( 'fa-solid fa-x' => 'x' ),
					array( 'fa-solid fa-xmark-large' => 'xmark-large' ),
					array( 'fa-solid fa-xmark-to-slot' => 'xmark-to-slot' ),
					array( 'fa-solid fa-xmark' => 'xmark' ),
					array( 'fa-solid fa-xmarks-lines' => 'xmarks-lines' ),
					array( 'fa-solid fa-y' => 'y' ),
					array( 'fa-solid fa-yen-sign' => 'yen-sign' ),
					array( 'fa-solid fa-yin-yang' => 'yin-yang' ),
					array( 'fa-solid fa-z' => 'z' ),
				),
				esc_html__( 'Light', 'smilepure' )   => array(
					array( 'fa-light fa-0' => '0' ),
					array( 'fa-light fa-00' => '00' ),
					array( 'fa-light fa-1' => '1' ),
					array( 'fa-light fa-2' => '2' ),
					array( 'fa-light fa-3' => '3' ),
					array( 'fa-light fa-4' => '4' ),
					array( 'fa-light fa-5' => '5' ),
					array( 'fa-light fa-6' => '6' ),
					array( 'fa-light fa-7' => '7' ),
					array( 'fa-light fa-8' => '8' ),
					array( 'fa-light fa-9' => '9' ),
					array( 'fa-light fa-360-degrees' => '360-degrees' ),
					array( 'fa-light fa-a' => 'a' ),
					array( 'fa-light fa-abacus' => 'abacus' ),
					array( 'fa-light fa-accent-grave' => 'accent-grave' ),
					array( 'fa-light fa-acorn' => 'acorn' ),
					array( 'fa-light fa-address-book' => 'address-book' ),
					array( 'fa-light fa-address-card' => 'address-card' ),
					array( 'fa-light fa-air-conditioner' => 'air-conditioner' ),
					array( 'fa-light fa-airplay' => 'airplay' ),
					array( 'fa-light fa-alarm-clock' => 'alarm-clock' ),
					array( 'fa-light fa-alarm-exclamation' => 'alarm-exclamation' ),
					array( 'fa-light fa-alarm-plus' => 'alarm-plus' ),
					array( 'fa-light fa-alarm-snooze' => 'alarm-snooze' ),
					array( 'fa-light fa-album-circle-plus' => 'album-circle-plus' ),
					array( 'fa-light fa-album-circle-user' => 'album-circle-user' ),
					array( 'fa-light fa-album-collection-circle-plus' => 'album-collection-circle-plus' ),
					array( 'fa-light fa-album-collection-circle-user' => 'album-collection-circle-user' ),
					array( 'fa-light fa-album-collection' => 'album-collection' ),
					array( 'fa-light fa-album' => 'album' ),
					array( 'fa-light fa-alicorn' => 'alicorn' ),
					array( 'fa-light fa-alien-8bit' => 'alien-8bit' ),
					array( 'fa-light fa-alien' => 'alien' ),
					array( 'fa-light fa-align-center' => 'align-center' ),
					array( 'fa-light fa-align-justify' => 'align-justify' ),
					array( 'fa-light fa-align-left' => 'align-left' ),
					array( 'fa-light fa-align-right' => 'align-right' ),
					array( 'fa-light fa-align-slash' => 'align-slash' ),
					array( 'fa-light fa-alt' => 'alt' ),
					array( 'fa-light fa-amp-guitar' => 'amp-guitar' ),
					array( 'fa-light fa-ampersand' => 'ampersand' ),
					array( 'fa-light fa-anchor-circle-check' => 'anchor-circle-check' ),
					array( 'fa-light fa-anchor-circle-exclamation' => 'anchor-circle-exclamation' ),
					array( 'fa-light fa-anchor-circle-xmark' => 'anchor-circle-xmark' ),
					array( 'fa-light fa-anchor-lock' => 'anchor-lock' ),
					array( 'fa-light fa-anchor' => 'anchor' ),
					array( 'fa-light fa-angel' => 'angel' ),
					array( 'fa-light fa-angle-90' => 'angle-90' ),
					array( 'fa-light fa-angle-down' => 'angle-down' ),
					array( 'fa-light fa-angle-left' => 'angle-left' ),
					array( 'fa-light fa-angle-right' => 'angle-right' ),
					array( 'fa-light fa-angle-up' => 'angle-up' ),
					array( 'fa-light fa-angle' => 'angle' ),
					array( 'fa-light fa-angles-down' => 'angles-down' ),
					array( 'fa-light fa-angles-left' => 'angles-left' ),
					array( 'fa-light fa-angles-right' => 'angles-right' ),
					array( 'fa-light fa-angles-up-down' => 'angles-up-down' ),
					array( 'fa-light fa-angles-up' => 'angles-up' ),
					array( 'fa-light fa-ankh' => 'ankh' ),
					array( 'fa-light fa-apartment' => 'apartment' ),
					array( 'fa-light fa-aperture' => 'aperture' ),
					array( 'fa-light fa-apostrophe' => 'apostrophe' ),
					array( 'fa-light fa-apple-core' => 'apple-core' ),
					array( 'fa-light fa-apple-whole' => 'apple-whole' ),
					array( 'fa-light fa-archway' => 'archway' ),
					array( 'fa-light fa-arrow-down-1-9' => 'arrow-down-1-9' ),
					array( 'fa-light fa-arrow-down-9-1' => 'arrow-down-9-1' ),
					array( 'fa-light fa-arrow-down-a-z' => 'arrow-down-a-z' ),
					array( 'fa-light fa-arrow-down-arrow-up' => 'arrow-down-arrow-up' ),
					array( 'fa-light fa-arrow-down-big-small' => 'arrow-down-big-small' ),
					array( 'fa-light fa-arrow-down-from-arc' => 'arrow-down-from-arc' ),
					array( 'fa-light fa-arrow-down-from-dotted-line' => 'arrow-down-from-dotted-line' ),
					array( 'fa-light fa-arrow-down-from-line' => 'arrow-down-from-line' ),
					array( 'fa-light fa-arrow-down-left-and-arrow-up-right-to-center' => 'arrow-down-left-and-arrow-up-right-to-center' ),
					array( 'fa-light fa-arrow-down-left' => 'arrow-down-left' ),
					array( 'fa-light fa-arrow-down-long' => 'arrow-down-long' ),
					array( 'fa-light fa-arrow-down-right' => 'arrow-down-right' ),
					array( 'fa-light fa-arrow-down-short-wide' => 'arrow-down-short-wide' ),
					array( 'fa-light fa-arrow-down-small-big' => 'arrow-down-small-big' ),
					array( 'fa-light fa-arrow-down-square-triangle' => 'arrow-down-square-triangle' ),
					array( 'fa-light fa-arrow-down-to-arc' => 'arrow-down-to-arc' ),
					array( 'fa-light fa-arrow-down-to-bracket' => 'arrow-down-to-bracket' ),
					array( 'fa-light fa-arrow-down-to-dotted-line' => 'arrow-down-to-dotted-line' ),
					array( 'fa-light fa-arrow-down-to-line' => 'arrow-down-to-line' ),
					array( 'fa-light fa-arrow-down-to-square' => 'arrow-down-to-square' ),
					array( 'fa-light fa-arrow-down-triangle-square' => 'arrow-down-triangle-square' ),
					array( 'fa-light fa-arrow-down-up-across-line' => 'arrow-down-up-across-line' ),
					array( 'fa-light fa-arrow-down-up-lock' => 'arrow-down-up-lock' ),
					array( 'fa-light fa-arrow-down-wide-short' => 'arrow-down-wide-short' ),
					array( 'fa-light fa-arrow-down-z-a' => 'arrow-down-z-a' ),
					array( 'fa-light fa-arrow-down' => 'arrow-down' ),
					array( 'fa-light fa-arrow-left-from-arc' => 'arrow-left-from-arc' ),
					array( 'fa-light fa-arrow-left-from-line' => 'arrow-left-from-line' ),
					array( 'fa-light fa-arrow-left-long-to-line' => 'arrow-left-long-to-line' ),
					array( 'fa-light fa-arrow-left-long' => 'arrow-left-long' ),
					array( 'fa-light fa-arrow-left-to-arc' => 'arrow-left-to-arc' ),
					array( 'fa-light fa-arrow-left-to-line' => 'arrow-left-to-line' ),
					array( 'fa-light fa-arrow-left' => 'arrow-left' ),
					array( 'fa-light fa-arrow-pointer' => 'arrow-pointer' ),
					array( 'fa-light fa-arrow-progress' => 'arrow-progress' ),
					array( 'fa-light fa-arrow-right-arrow-left' => 'arrow-right-arrow-left' ),
					array( 'fa-light fa-arrow-right-from-arc' => 'arrow-right-from-arc' ),
					array( 'fa-light fa-arrow-right-from-bracket' => 'arrow-right-from-bracket' ),
					array( 'fa-light fa-arrow-right-from-line' => 'arrow-right-from-line' ),
					array( 'fa-light fa-arrow-right-long-to-line' => 'arrow-right-long-to-line' ),
					array( 'fa-light fa-arrow-right-long' => 'arrow-right-long' ),
					array( 'fa-light fa-arrow-right-to-arc' => 'arrow-right-to-arc' ),
					array( 'fa-light fa-arrow-right-to-bracket' => 'arrow-right-to-bracket' ),
					array( 'fa-light fa-arrow-right-to-city' => 'arrow-right-to-city' ),
					array( 'fa-light fa-arrow-right-to-line' => 'arrow-right-to-line' ),
					array( 'fa-light fa-arrow-right' => 'arrow-right' ),
					array( 'fa-light fa-arrow-rotate-left' => 'arrow-rotate-left' ),
					array( 'fa-light fa-arrow-rotate-right' => 'arrow-rotate-right' ),
					array( 'fa-light fa-arrow-trend-down' => 'arrow-trend-down' ),
					array( 'fa-light fa-arrow-trend-up' => 'arrow-trend-up' ),
					array( 'fa-light fa-arrow-turn-down-left' => 'arrow-turn-down-left' ),
					array( 'fa-light fa-arrow-turn-down-right' => 'arrow-turn-down-right' ),
					array( 'fa-light fa-arrow-turn-down' => 'arrow-turn-down' ),
					array( 'fa-light fa-arrow-turn-up' => 'arrow-turn-up' ),
					array( 'fa-light fa-arrow-up-1-9' => 'arrow-up-1-9' ),
					array( 'fa-light fa-arrow-up-9-1' => 'arrow-up-9-1' ),
					array( 'fa-light fa-arrow-up-a-z' => 'arrow-up-a-z' ),
					array( 'fa-light fa-arrow-up-arrow-down' => 'arrow-up-arrow-down' ),
					array( 'fa-light fa-arrow-up-big-small' => 'arrow-up-big-small' ),
					array( 'fa-light fa-arrow-up-from-arc' => 'arrow-up-from-arc' ),
					array( 'fa-light fa-arrow-up-from-bracket' => 'arrow-up-from-bracket' ),
					array( 'fa-light fa-arrow-up-from-dotted-line' => 'arrow-up-from-dotted-line' ),
					array( 'fa-light fa-arrow-up-from-ground-water' => 'arrow-up-from-ground-water' ),
					array( 'fa-light fa-arrow-up-from-line' => 'arrow-up-from-line' ),
					array( 'fa-light fa-arrow-up-from-square' => 'arrow-up-from-square' ),
					array( 'fa-light fa-arrow-up-from-water-pump' => 'arrow-up-from-water-pump' ),
					array( 'fa-light fa-arrow-up-left-from-circle' => 'arrow-up-left-from-circle' ),
					array( 'fa-light fa-arrow-up-left' => 'arrow-up-left' ),
					array( 'fa-light fa-arrow-up-long' => 'arrow-up-long' ),
					array( 'fa-light fa-arrow-up-right-and-arrow-down-left-from-center' => 'arrow-up-right-and-arrow-down-left-from-center' ),
					array( 'fa-light fa-arrow-up-right-dots' => 'arrow-up-right-dots' ),
					array( 'fa-light fa-arrow-up-right-from-square' => 'arrow-up-right-from-square' ),
					array( 'fa-light fa-arrow-up-right' => 'arrow-up-right' ),
					array( 'fa-light fa-arrow-up-short-wide' => 'arrow-up-short-wide' ),
					array( 'fa-light fa-arrow-up-small-big' => 'arrow-up-small-big' ),
					array( 'fa-light fa-arrow-up-square-triangle' => 'arrow-up-square-triangle' ),
					array( 'fa-light fa-arrow-up-to-arc' => 'arrow-up-to-arc' ),
					array( 'fa-light fa-arrow-up-to-dotted-line' => 'arrow-up-to-dotted-line' ),
					array( 'fa-light fa-arrow-up-to-line' => 'arrow-up-to-line' ),
					array( 'fa-light fa-arrow-up-triangle-square' => 'arrow-up-triangle-square' ),
					array( 'fa-light fa-arrow-up-wide-short' => 'arrow-up-wide-short' ),
					array( 'fa-light fa-arrow-up-z-a' => 'arrow-up-z-a' ),
					array( 'fa-light fa-arrow-up' => 'arrow-up' ),
					array( 'fa-light fa-arrows-cross' => 'arrows-cross' ),
					array( 'fa-light fa-arrows-down-to-line' => 'arrows-down-to-line' ),
					array( 'fa-light fa-arrows-down-to-people' => 'arrows-down-to-people' ),
					array( 'fa-light fa-arrows-from-dotted-line' => 'arrows-from-dotted-line' ),
					array( 'fa-light fa-arrows-from-line' => 'arrows-from-line' ),
					array( 'fa-light fa-arrows-left-right-to-line' => 'arrows-left-right-to-line' ),
					array( 'fa-light fa-arrows-left-right' => 'arrows-left-right' ),
					array( 'fa-light fa-arrows-maximize' => 'arrows-maximize' ),
					array( 'fa-light fa-arrows-minimize' => 'arrows-minimize' ),
					array( 'fa-light fa-arrows-repeat-1' => 'arrows-repeat-1' ),
					array( 'fa-light fa-arrows-repeat' => 'arrows-repeat' ),
					array( 'fa-light fa-arrows-retweet' => 'arrows-retweet' ),
					array( 'fa-light fa-arrows-rotate' => 'arrows-rotate' ),
					array( 'fa-light fa-arrows-spin' => 'arrows-spin' ),
					array( 'fa-light fa-arrows-split-up-and-left' => 'arrows-split-up-and-left' ),
					array( 'fa-light fa-arrows-to-circle' => 'arrows-to-circle' ),
					array( 'fa-light fa-arrows-to-dot' => 'arrows-to-dot' ),
					array( 'fa-light fa-arrows-to-dotted-line' => 'arrows-to-dotted-line' ),
					array( 'fa-light fa-arrows-to-eye' => 'arrows-to-eye' ),
					array( 'fa-light fa-arrows-to-line' => 'arrows-to-line' ),
					array( 'fa-light fa-arrows-turn-right' => 'arrows-turn-right' ),
					array( 'fa-light fa-arrows-turn-to-dots' => 'arrows-turn-to-dots' ),
					array( 'fa-light fa-arrows-up-down-left-right' => 'arrows-up-down-left-right' ),
					array( 'fa-light fa-arrows-up-down' => 'arrows-up-down' ),
					array( 'fa-light fa-arrows-up-to-line' => 'arrows-up-to-line' ),
					array( 'fa-light fa-asterisk' => 'asterisk' ),
					array( 'fa-light fa-at' => 'at' ),
					array( 'fa-light fa-atom-simple' => 'atom-simple' ),
					array( 'fa-light fa-atom' => 'atom' ),
					array( 'fa-light fa-audio-description-slash' => 'audio-description-slash' ),
					array( 'fa-light fa-audio-description' => 'audio-description' ),
					array( 'fa-light fa-austral-sign' => 'austral-sign' ),
					array( 'fa-light fa-avocado' => 'avocado' ),
					array( 'fa-light fa-award-simple' => 'award-simple' ),
					array( 'fa-light fa-award' => 'award' ),
					array( 'fa-light fa-axe-battle' => 'axe-battle' ),
					array( 'fa-light fa-axe' => 'axe' ),
					array( 'fa-light fa-b' => 'b' ),
					array( 'fa-light fa-baby-carriage' => 'baby-carriage' ),
					array( 'fa-light fa-baby' => 'baby' ),
					array( 'fa-light fa-backpack' => 'backpack' ),
					array( 'fa-light fa-backward-fast' => 'backward-fast' ),
					array( 'fa-light fa-backward-step' => 'backward-step' ),
					array( 'fa-light fa-backward' => 'backward' ),
					array( 'fa-light fa-bacon' => 'bacon' ),
					array( 'fa-light fa-bacteria' => 'bacteria' ),
					array( 'fa-light fa-bacterium' => 'bacterium' ),
					array( 'fa-light fa-badge-check' => 'badge-check' ),
					array( 'fa-light fa-badge-dollar' => 'badge-dollar' ),
					array( 'fa-light fa-badge-percent' => 'badge-percent' ),
					array( 'fa-light fa-badge-sheriff' => 'badge-sheriff' ),
					array( 'fa-light fa-badge' => 'badge' ),
					array( 'fa-light fa-badger-honey' => 'badger-honey' ),
					array( 'fa-light fa-badminton' => 'badminton' ),
					array( 'fa-light fa-bag-seedling' => 'bag-seedling' ),
					array( 'fa-light fa-bag-shopping' => 'bag-shopping' ),
					array( 'fa-light fa-bagel' => 'bagel' ),
					array( 'fa-light fa-bags-shopping' => 'bags-shopping' ),
					array( 'fa-light fa-baguette' => 'baguette' ),
					array( 'fa-light fa-bahai' => 'bahai' ),
					array( 'fa-light fa-baht-sign' => 'baht-sign' ),
					array( 'fa-light fa-ball-pile' => 'ball-pile' ),
					array( 'fa-light fa-balloon' => 'balloon' ),
					array( 'fa-light fa-balloons' => 'balloons' ),
					array( 'fa-light fa-ballot-check' => 'ballot-check' ),
					array( 'fa-light fa-ballot' => 'ballot' ),
					array( 'fa-light fa-ban-bug' => 'ban-bug' ),
					array( 'fa-light fa-ban-parking' => 'ban-parking' ),
					array( 'fa-light fa-ban-smoking' => 'ban-smoking' ),
					array( 'fa-light fa-ban' => 'ban' ),
					array( 'fa-light fa-banana' => 'banana' ),
					array( 'fa-light fa-bandage' => 'bandage' ),
					array( 'fa-light fa-bangladeshi-taka-sign' => 'bangladeshi-taka-sign' ),
					array( 'fa-light fa-banjo' => 'banjo' ),
					array( 'fa-light fa-barcode-read' => 'barcode-read' ),
					array( 'fa-light fa-barcode-scan' => 'barcode-scan' ),
					array( 'fa-light fa-barcode' => 'barcode' ),
					array( 'fa-light fa-bars-filter' => 'bars-filter' ),
					array( 'fa-light fa-bars-progress' => 'bars-progress' ),
					array( 'fa-light fa-bars-sort' => 'bars-sort' ),
					array( 'fa-light fa-bars-staggered' => 'bars-staggered' ),
					array( 'fa-light fa-bars' => 'bars' ),
					array( 'fa-light fa-baseball-bat-ball' => 'baseball-bat-ball' ),
					array( 'fa-light fa-baseball' => 'baseball' ),
					array( 'fa-light fa-basket-shopping-simple' => 'basket-shopping-simple' ),
					array( 'fa-light fa-basket-shopping' => 'basket-shopping' ),
					array( 'fa-light fa-basketball-hoop' => 'basketball-hoop' ),
					array( 'fa-light fa-basketball' => 'basketball' ),
					array( 'fa-light fa-bat' => 'bat' ),
					array( 'fa-light fa-bath' => 'bath' ),
					array( 'fa-light fa-battery-bolt' => 'battery-bolt' ),
					array( 'fa-light fa-battery-empty' => 'battery-empty' ),
					array( 'fa-light fa-battery-exclamation' => 'battery-exclamation' ),
					array( 'fa-light fa-battery-full' => 'battery-full' ),
					array( 'fa-light fa-battery-half' => 'battery-half' ),
					array( 'fa-light fa-battery-low' => 'battery-low' ),
					array( 'fa-light fa-battery-quarter' => 'battery-quarter' ),
					array( 'fa-light fa-battery-slash' => 'battery-slash' ),
					array( 'fa-light fa-battery-three-quarters' => 'battery-three-quarters' ),
					array( 'fa-light fa-bed-bunk' => 'bed-bunk' ),
					array( 'fa-light fa-bed-empty' => 'bed-empty' ),
					array( 'fa-light fa-bed-front' => 'bed-front' ),
					array( 'fa-light fa-bed-pulse' => 'bed-pulse' ),
					array( 'fa-light fa-bed' => 'bed' ),
					array( 'fa-light fa-bee' => 'bee' ),
					array( 'fa-light fa-beer-mug-empty' => 'beer-mug-empty' ),
					array( 'fa-light fa-beer-mug' => 'beer-mug' ),
					array( 'fa-light fa-bell-concierge' => 'bell-concierge' ),
					array( 'fa-light fa-bell-exclamation' => 'bell-exclamation' ),
					array( 'fa-light fa-bell-on' => 'bell-on' ),
					array( 'fa-light fa-bell-plus' => 'bell-plus' ),
					array( 'fa-light fa-bell-school-slash' => 'bell-school-slash' ),
					array( 'fa-light fa-bell-school' => 'bell-school' ),
					array( 'fa-light fa-bell-slash' => 'bell-slash' ),
					array( 'fa-light fa-bell' => 'bell' ),
					array( 'fa-light fa-bells' => 'bells' ),
					array( 'fa-light fa-bench-tree' => 'bench-tree' ),
					array( 'fa-light fa-bezier-curve' => 'bezier-curve' ),
					array( 'fa-light fa-bicycle' => 'bicycle' ),
					array( 'fa-light fa-billboard' => 'billboard' ),
					array( 'fa-light fa-bin-bottles-recycle' => 'bin-bottles-recycle' ),
					array( 'fa-light fa-bin-bottles' => 'bin-bottles' ),
					array( 'fa-light fa-bin-recycle' => 'bin-recycle' ),
					array( 'fa-light fa-binary-circle-check' => 'binary-circle-check' ),
					array( 'fa-light fa-binary-lock' => 'binary-lock' ),
					array( 'fa-light fa-binary-slash' => 'binary-slash' ),
					array( 'fa-light fa-binary' => 'binary' ),
					array( 'fa-light fa-binoculars' => 'binoculars' ),
					array( 'fa-light fa-biohazard' => 'biohazard' ),
					array( 'fa-light fa-bird' => 'bird' ),
					array( 'fa-light fa-bitcoin-sign' => 'bitcoin-sign' ),
					array( 'fa-light fa-blanket-fire' => 'blanket-fire' ),
					array( 'fa-light fa-blanket' => 'blanket' ),
					array( 'fa-light fa-blender-phone' => 'blender-phone' ),
					array( 'fa-light fa-blender' => 'blender' ),
					array( 'fa-light fa-blinds-open' => 'blinds-open' ),
					array( 'fa-light fa-blinds-raised' => 'blinds-raised' ),
					array( 'fa-light fa-blinds' => 'blinds' ),
					array( 'fa-light fa-block-brick-fire' => 'block-brick-fire' ),
					array( 'fa-light fa-block-brick' => 'block-brick' ),
					array( 'fa-light fa-block-question' => 'block-question' ),
					array( 'fa-light fa-block-quote' => 'block-quote' ),
					array( 'fa-light fa-block' => 'block' ),
					array( 'fa-light fa-blog' => 'blog' ),
					array( 'fa-light fa-blueberries' => 'blueberries' ),
					array( 'fa-light fa-bluetooth' => 'bluetooth' ),
					array( 'fa-light fa-bold' => 'bold' ),
					array( 'fa-light fa-bolt-auto' => 'bolt-auto' ),
					array( 'fa-light fa-bolt-lightning' => 'bolt-lightning' ),
					array( 'fa-light fa-bolt-slash' => 'bolt-slash' ),
					array( 'fa-light fa-bolt' => 'bolt' ),
					array( 'fa-light fa-bomb' => 'bomb' ),
					array( 'fa-light fa-bone-break' => 'bone-break' ),
					array( 'fa-light fa-bone' => 'bone' ),
					array( 'fa-light fa-bong' => 'bong' ),
					array( 'fa-light fa-book-arrow-right' => 'book-arrow-right' ),
					array( 'fa-light fa-book-arrow-up' => 'book-arrow-up' ),
					array( 'fa-light fa-book-atlas' => 'book-atlas' ),
					array( 'fa-light fa-book-bible' => 'book-bible' ),
					array( 'fa-light fa-book-blank' => 'book-blank' ),
					array( 'fa-light fa-book-bookmark' => 'book-bookmark' ),
					array( 'fa-light fa-book-circle-arrow-right' => 'book-circle-arrow-right' ),
					array( 'fa-light fa-book-circle-arrow-up' => 'book-circle-arrow-up' ),
					array( 'fa-light fa-book-copy' => 'book-copy' ),
					array( 'fa-light fa-book-font' => 'book-font' ),
					array( 'fa-light fa-book-heart' => 'book-heart' ),
					array( 'fa-light fa-book-journal-whills' => 'book-journal-whills' ),
					array( 'fa-light fa-book-medical' => 'book-medical' ),
					array( 'fa-light fa-book-open-cover' => 'book-open-cover' ),
					array( 'fa-light fa-book-open-reader' => 'book-open-reader' ),
					array( 'fa-light fa-book-open' => 'book-open' ),
					array( 'fa-light fa-book-quran' => 'book-quran' ),
					array( 'fa-light fa-book-section' => 'book-section' ),
					array( 'fa-light fa-book-skull' => 'book-skull' ),
					array( 'fa-light fa-book-sparkles' => 'book-sparkles' ),
					array( 'fa-light fa-book-tanakh' => 'book-tanakh' ),
					array( 'fa-light fa-book-user' => 'book-user' ),
					array( 'fa-light fa-book' => 'book' ),
					array( 'fa-light fa-bookmark-slash' => 'bookmark-slash' ),
					array( 'fa-light fa-bookmark' => 'bookmark' ),
					array( 'fa-light fa-books-medical' => 'books-medical' ),
					array( 'fa-light fa-books' => 'books' ),
					array( 'fa-light fa-boombox' => 'boombox' ),
					array( 'fa-light fa-boot-heeled' => 'boot-heeled' ),
					array( 'fa-light fa-boot' => 'boot' ),
					array( 'fa-light fa-booth-curtain' => 'booth-curtain' ),
					array( 'fa-light fa-border-all' => 'border-all' ),
					array( 'fa-light fa-border-bottom-right' => 'border-bottom-right' ),
					array( 'fa-light fa-border-bottom' => 'border-bottom' ),
					array( 'fa-light fa-border-center-h' => 'border-center-h' ),
					array( 'fa-light fa-border-center-v' => 'border-center-v' ),
					array( 'fa-light fa-border-inner' => 'border-inner' ),
					array( 'fa-light fa-border-left' => 'border-left' ),
					array( 'fa-light fa-border-none' => 'border-none' ),
					array( 'fa-light fa-border-outer' => 'border-outer' ),
					array( 'fa-light fa-border-right' => 'border-right' ),
					array( 'fa-light fa-border-top-left' => 'border-top-left' ),
					array( 'fa-light fa-border-top' => 'border-top' ),
					array( 'fa-light fa-bore-hole' => 'bore-hole' ),
					array( 'fa-light fa-bottle-droplet' => 'bottle-droplet' ),
					array( 'fa-light fa-bottle-water' => 'bottle-water' ),
					array( 'fa-light fa-bow-arrow' => 'bow-arrow' ),
					array( 'fa-light fa-bowl-chopsticks-noodles' => 'bowl-chopsticks-noodles' ),
					array( 'fa-light fa-bowl-chopsticks' => 'bowl-chopsticks' ),
					array( 'fa-light fa-bowl-food' => 'bowl-food' ),
					array( 'fa-light fa-bowl-hot' => 'bowl-hot' ),
					array( 'fa-light fa-bowl-rice' => 'bowl-rice' ),
					array( 'fa-light fa-bowl-scoop' => 'bowl-scoop' ),
					array( 'fa-light fa-bowl-scoops' => 'bowl-scoops' ),
					array( 'fa-light fa-bowl-soft-serve' => 'bowl-soft-serve' ),
					array( 'fa-light fa-bowl-spoon' => 'bowl-spoon' ),
					array( 'fa-light fa-bowling-ball-pin' => 'bowling-ball-pin' ),
					array( 'fa-light fa-bowling-ball' => 'bowling-ball' ),
					array( 'fa-light fa-bowling-pins' => 'bowling-pins' ),
					array( 'fa-light fa-box-archive' => 'box-archive' ),
					array( 'fa-light fa-box-ballot' => 'box-ballot' ),
					array( 'fa-light fa-box-check' => 'box-check' ),
					array( 'fa-light fa-box-circle-check' => 'box-circle-check' ),
					array( 'fa-light fa-box-dollar' => 'box-dollar' ),
					array( 'fa-light fa-box-heart' => 'box-heart' ),
					array( 'fa-light fa-box-open-full' => 'box-open-full' ),
					array( 'fa-light fa-box-open' => 'box-open' ),
					array( 'fa-light fa-box-taped' => 'box-taped' ),
					array( 'fa-light fa-box-tissue' => 'box-tissue' ),
					array( 'fa-light fa-box' => 'box' ),
					array( 'fa-light fa-boxes-packing' => 'boxes-packing' ),
					array( 'fa-light fa-boxes-stacked' => 'boxes-stacked' ),
					array( 'fa-light fa-boxing-glove' => 'boxing-glove' ),
					array( 'fa-light fa-bracket-curly-right' => 'bracket-curly-right' ),
					array( 'fa-light fa-bracket-curly' => 'bracket-curly' ),
					array( 'fa-light fa-bracket-round-right' => 'bracket-round-right' ),
					array( 'fa-light fa-bracket-round' => 'bracket-round' ),
					array( 'fa-light fa-bracket-square-right' => 'bracket-square-right' ),
					array( 'fa-light fa-bracket-square' => 'bracket-square' ),
					array( 'fa-light fa-brackets-curly' => 'brackets-curly' ),
					array( 'fa-light fa-brackets-round' => 'brackets-round' ),
					array( 'fa-light fa-brackets-square' => 'brackets-square' ),
					array( 'fa-light fa-braille' => 'braille' ),
					array( 'fa-light fa-brain-arrow-curved-right' => 'brain-arrow-curved-right' ),
					array( 'fa-light fa-brain-circuit' => 'brain-circuit' ),
					array( 'fa-light fa-brain' => 'brain' ),
					array( 'fa-light fa-brake-warning' => 'brake-warning' ),
					array( 'fa-light fa-brazilian-real-sign' => 'brazilian-real-sign' ),
					array( 'fa-light fa-bread-loaf' => 'bread-loaf' ),
					array( 'fa-light fa-bread-slice-butter' => 'bread-slice-butter' ),
					array( 'fa-light fa-bread-slice' => 'bread-slice' ),
					array( 'fa-light fa-bridge-circle-check' => 'bridge-circle-check' ),
					array( 'fa-light fa-bridge-circle-exclamation' => 'bridge-circle-exclamation' ),
					array( 'fa-light fa-bridge-circle-xmark' => 'bridge-circle-xmark' ),
					array( 'fa-light fa-bridge-lock' => 'bridge-lock' ),
					array( 'fa-light fa-bridge-suspension' => 'bridge-suspension' ),
					array( 'fa-light fa-bridge-water' => 'bridge-water' ),
					array( 'fa-light fa-bridge' => 'bridge' ),
					array( 'fa-light fa-briefcase-arrow-right' => 'briefcase-arrow-right' ),
					array( 'fa-light fa-briefcase-blank' => 'briefcase-blank' ),
					array( 'fa-light fa-briefcase-medical' => 'briefcase-medical' ),
					array( 'fa-light fa-briefcase' => 'briefcase' ),
					array( 'fa-light fa-brightness-low' => 'brightness-low' ),
					array( 'fa-light fa-brightness' => 'brightness' ),
					array( 'fa-light fa-bring-forward' => 'bring-forward' ),
					array( 'fa-light fa-bring-front' => 'bring-front' ),
					array( 'fa-light fa-broccoli' => 'broccoli' ),
					array( 'fa-light fa-broom-ball' => 'broom-ball' ),
					array( 'fa-light fa-broom-wide' => 'broom-wide' ),
					array( 'fa-light fa-broom' => 'broom' ),
					array( 'fa-light fa-browser' => 'browser' ),
					array( 'fa-light fa-browsers' => 'browsers' ),
					array( 'fa-light fa-brush' => 'brush' ),
					array( 'fa-light fa-bucket' => 'bucket' ),
					array( 'fa-light fa-bug-slash' => 'bug-slash' ),
					array( 'fa-light fa-bug' => 'bug' ),
					array( 'fa-light fa-bugs' => 'bugs' ),
					array( 'fa-light fa-building-circle-arrow-right' => 'building-circle-arrow-right' ),
					array( 'fa-light fa-building-circle-check' => 'building-circle-check' ),
					array( 'fa-light fa-building-circle-exclamation' => 'building-circle-exclamation' ),
					array( 'fa-light fa-building-circle-xmark' => 'building-circle-xmark' ),
					array( 'fa-light fa-building-columns' => 'building-columns' ),
					array( 'fa-light fa-building-flag' => 'building-flag' ),
					array( 'fa-light fa-building-lock' => 'building-lock' ),
					array( 'fa-light fa-building-ngo' => 'building-ngo' ),
					array( 'fa-light fa-building-shield' => 'building-shield' ),
					array( 'fa-light fa-building-un' => 'building-un' ),
					array( 'fa-light fa-building-user' => 'building-user' ),
					array( 'fa-light fa-building-wheat' => 'building-wheat' ),
					array( 'fa-light fa-building' => 'building' ),
					array( 'fa-light fa-buildings' => 'buildings' ),
					array( 'fa-light fa-bullhorn' => 'bullhorn' ),
					array( 'fa-light fa-bullseye-arrow' => 'bullseye-arrow' ),
					array( 'fa-light fa-bullseye-pointer' => 'bullseye-pointer' ),
					array( 'fa-light fa-bullseye' => 'bullseye' ),
					array( 'fa-light fa-buoy-mooring' => 'buoy-mooring' ),
					array( 'fa-light fa-buoy' => 'buoy' ),
					array( 'fa-light fa-burger-cheese' => 'burger-cheese' ),
					array( 'fa-light fa-burger-fries' => 'burger-fries' ),
					array( 'fa-light fa-burger-glass' => 'burger-glass' ),
					array( 'fa-light fa-burger-lettuce' => 'burger-lettuce' ),
					array( 'fa-light fa-burger-soda' => 'burger-soda' ),
					array( 'fa-light fa-burger' => 'burger' ),
					array( 'fa-light fa-burrito' => 'burrito' ),
					array( 'fa-light fa-burst' => 'burst' ),
					array( 'fa-light fa-bus-school' => 'bus-school' ),
					array( 'fa-light fa-bus-simple' => 'bus-simple' ),
					array( 'fa-light fa-bus' => 'bus' ),
					array( 'fa-light fa-business-time' => 'business-time' ),
					array( 'fa-light fa-butter' => 'butter' ),
					array( 'fa-light fa-c' => 'c' ),
					array( 'fa-light fa-cabin' => 'cabin' ),
					array( 'fa-light fa-cabinet-filing' => 'cabinet-filing' ),
					array( 'fa-light fa-cable-car' => 'cable-car' ),
					array( 'fa-light fa-cactus' => 'cactus' ),
					array( 'fa-light fa-cake-candles' => 'cake-candles' ),
					array( 'fa-light fa-cake-slice' => 'cake-slice' ),
					array( 'fa-light fa-calculator-simple' => 'calculator-simple' ),
					array( 'fa-light fa-calculator' => 'calculator' ),
					array( 'fa-light fa-calendar-arrow-down' => 'calendar-arrow-down' ),
					array( 'fa-light fa-calendar-arrow-up' => 'calendar-arrow-up' ),
					array( 'fa-light fa-calendar-check' => 'calendar-check' ),
					array( 'fa-light fa-calendar-circle-exclamation' => 'calendar-circle-exclamation' ),
					array( 'fa-light fa-calendar-circle-minus' => 'calendar-circle-minus' ),
					array( 'fa-light fa-calendar-circle-plus' => 'calendar-circle-plus' ),
					array( 'fa-light fa-calendar-circle-user' => 'calendar-circle-user' ),
					array( 'fa-light fa-calendar-clock' => 'calendar-clock' ),
					array( 'fa-light fa-calendar-day' => 'calendar-day' ),
					array( 'fa-light fa-calendar-days' => 'calendar-days' ),
					array( 'fa-light fa-calendar-exclamation' => 'calendar-exclamation' ),
					array( 'fa-light fa-calendar-heart' => 'calendar-heart' ),
					array( 'fa-light fa-calendar-image' => 'calendar-image' ),
					array( 'fa-light fa-calendar-lines-pen' => 'calendar-lines-pen' ),
					array( 'fa-light fa-calendar-lines' => 'calendar-lines' ),
					array( 'fa-light fa-calendar-minus' => 'calendar-minus' ),
					array( 'fa-light fa-calendar-pen' => 'calendar-pen' ),
					array( 'fa-light fa-calendar-plus' => 'calendar-plus' ),
					array( 'fa-light fa-calendar-range' => 'calendar-range' ),
					array( 'fa-light fa-calendar-star' => 'calendar-star' ),
					array( 'fa-light fa-calendar-users' => 'calendar-users' ),
					array( 'fa-light fa-calendar-week' => 'calendar-week' ),
					array( 'fa-light fa-calendar-xmark' => 'calendar-xmark' ),
					array( 'fa-light fa-calendar' => 'calendar' ),
					array( 'fa-light fa-calendars' => 'calendars' ),
					array( 'fa-light fa-camcorder' => 'camcorder' ),
					array( 'fa-light fa-camera-cctv' => 'camera-cctv' ),
					array( 'fa-light fa-camera-movie' => 'camera-movie' ),
					array( 'fa-light fa-camera-polaroid' => 'camera-polaroid' ),
					array( 'fa-light fa-camera-retro' => 'camera-retro' ),
					array( 'fa-light fa-camera-rotate' => 'camera-rotate' ),
					array( 'fa-light fa-camera-security' => 'camera-security' ),
					array( 'fa-light fa-camera-slash' => 'camera-slash' ),
					array( 'fa-light fa-camera-viewfinder' => 'camera-viewfinder' ),
					array( 'fa-light fa-camera-web-slash' => 'camera-web-slash' ),
					array( 'fa-light fa-camera-web' => 'camera-web' ),
					array( 'fa-light fa-camera' => 'camera' ),
					array( 'fa-light fa-campfire' => 'campfire' ),
					array( 'fa-light fa-campground' => 'campground' ),
					array( 'fa-light fa-can-food' => 'can-food' ),
					array( 'fa-light fa-candle-holder' => 'candle-holder' ),
					array( 'fa-light fa-candy-bar' => 'candy-bar' ),
					array( 'fa-light fa-candy-cane' => 'candy-cane' ),
					array( 'fa-light fa-candy-corn' => 'candy-corn' ),
					array( 'fa-light fa-candy' => 'candy' ),
					array( 'fa-light fa-cannabis' => 'cannabis' ),
					array( 'fa-light fa-capsules' => 'capsules' ),
					array( 'fa-light fa-car-battery' => 'car-battery' ),
					array( 'fa-light fa-car-bolt' => 'car-bolt' ),
					array( 'fa-light fa-car-building' => 'car-building' ),
					array( 'fa-light fa-car-bump' => 'car-bump' ),
					array( 'fa-light fa-car-burst' => 'car-burst' ),
					array( 'fa-light fa-car-bus' => 'car-bus' ),
					array( 'fa-light fa-car-circle-bolt' => 'car-circle-bolt' ),
					array( 'fa-light fa-car-garage' => 'car-garage' ),
					array( 'fa-light fa-car-mirrors' => 'car-mirrors' ),
					array( 'fa-light fa-car-on' => 'car-on' ),
					array( 'fa-light fa-car-rear' => 'car-rear' ),
					array( 'fa-light fa-car-side-bolt' => 'car-side-bolt' ),
					array( 'fa-light fa-car-side' => 'car-side' ),
					array( 'fa-light fa-car-tilt' => 'car-tilt' ),
					array( 'fa-light fa-car-tunnel' => 'car-tunnel' ),
					array( 'fa-light fa-car-wash' => 'car-wash' ),
					array( 'fa-light fa-car-wrench' => 'car-wrench' ),
					array( 'fa-light fa-car' => 'car' ),
					array( 'fa-light fa-caravan-simple' => 'caravan-simple' ),
					array( 'fa-light fa-caravan' => 'caravan' ),
					array( 'fa-light fa-card-club' => 'card-club' ),
					array( 'fa-light fa-card-diamond' => 'card-diamond' ),
					array( 'fa-light fa-card-heart' => 'card-heart' ),
					array( 'fa-light fa-card-spade' => 'card-spade' ),
					array( 'fa-light fa-cards-blank' => 'cards-blank' ),
					array( 'fa-light fa-cards' => 'cards' ),
					array( 'fa-light fa-caret-down' => 'caret-down' ),
					array( 'fa-light fa-caret-left' => 'caret-left' ),
					array( 'fa-light fa-caret-right' => 'caret-right' ),
					array( 'fa-light fa-caret-up' => 'caret-up' ),
					array( 'fa-light fa-carrot' => 'carrot' ),
					array( 'fa-light fa-cars' => 'cars' ),
					array( 'fa-light fa-cart-arrow-down' => 'cart-arrow-down' ),
					array( 'fa-light fa-cart-arrow-up' => 'cart-arrow-up' ),
					array( 'fa-light fa-cart-circle-arrow-down' => 'cart-circle-arrow-down' ),
					array( 'fa-light fa-cart-circle-arrow-up' => 'cart-circle-arrow-up' ),
					array( 'fa-light fa-cart-circle-check' => 'cart-circle-check' ),
					array( 'fa-light fa-cart-circle-exclamation' => 'cart-circle-exclamation' ),
					array( 'fa-light fa-cart-circle-plus' => 'cart-circle-plus' ),
					array( 'fa-light fa-cart-circle-xmark' => 'cart-circle-xmark' ),
					array( 'fa-light fa-cart-flatbed-boxes' => 'cart-flatbed-boxes' ),
					array( 'fa-light fa-cart-flatbed-empty' => 'cart-flatbed-empty' ),
					array( 'fa-light fa-cart-flatbed-suitcase' => 'cart-flatbed-suitcase' ),
					array( 'fa-light fa-cart-flatbed' => 'cart-flatbed' ),
					array( 'fa-light fa-cart-minus' => 'cart-minus' ),
					array( 'fa-light fa-cart-plus' => 'cart-plus' ),
					array( 'fa-light fa-cart-shopping-fast' => 'cart-shopping-fast' ),
					array( 'fa-light fa-cart-shopping' => 'cart-shopping' ),
					array( 'fa-light fa-cart-xmark' => 'cart-xmark' ),
					array( 'fa-light fa-cash-register' => 'cash-register' ),
					array( 'fa-light fa-cassette-betamax' => 'cassette-betamax' ),
					array( 'fa-light fa-cassette-tape' => 'cassette-tape' ),
					array( 'fa-light fa-cassette-vhs' => 'cassette-vhs' ),
					array( 'fa-light fa-castle' => 'castle' ),
					array( 'fa-light fa-cat-space' => 'cat-space' ),
					array( 'fa-light fa-cat' => 'cat' ),
					array( 'fa-light fa-cauldron' => 'cauldron' ),
					array( 'fa-light fa-cedi-sign' => 'cedi-sign' ),
					array( 'fa-light fa-cent-sign' => 'cent-sign' ),
					array( 'fa-light fa-certificate' => 'certificate' ),
					array( 'fa-light fa-chair-office' => 'chair-office' ),
					array( 'fa-light fa-chair' => 'chair' ),
					array( 'fa-light fa-chalkboard-user' => 'chalkboard-user' ),
					array( 'fa-light fa-chalkboard' => 'chalkboard' ),
					array( 'fa-light fa-champagne-glass' => 'champagne-glass' ),
					array( 'fa-light fa-champagne-glasses' => 'champagne-glasses' ),
					array( 'fa-light fa-charging-station' => 'charging-station' ),
					array( 'fa-light fa-chart-area' => 'chart-area' ),
					array( 'fa-light fa-chart-bar' => 'chart-bar' ),
					array( 'fa-light fa-chart-bullet' => 'chart-bullet' ),
					array( 'fa-light fa-chart-candlestick' => 'chart-candlestick' ),
					array( 'fa-light fa-chart-column' => 'chart-column' ),
					array( 'fa-light fa-chart-gantt' => 'chart-gantt' ),
					array( 'fa-light fa-chart-line-down' => 'chart-line-down' ),
					array( 'fa-light fa-chart-line-up-down' => 'chart-line-up-down' ),
					array( 'fa-light fa-chart-line-up' => 'chart-line-up' ),
					array( 'fa-light fa-chart-line' => 'chart-line' ),
					array( 'fa-light fa-chart-mixed-up-circle-currency' => 'chart-mixed-up-circle-currency' ),
					array( 'fa-light fa-chart-mixed-up-circle-dollar' => 'chart-mixed-up-circle-dollar' ),
					array( 'fa-light fa-chart-mixed' => 'chart-mixed' ),
					array( 'fa-light fa-chart-network' => 'chart-network' ),
					array( 'fa-light fa-chart-pie-simple-circle-currency' => 'chart-pie-simple-circle-currency' ),
					array( 'fa-light fa-chart-pie-simple-circle-dollar' => 'chart-pie-simple-circle-dollar' ),
					array( 'fa-light fa-chart-pie-simple' => 'chart-pie-simple' ),
					array( 'fa-light fa-chart-pie' => 'chart-pie' ),
					array( 'fa-light fa-chart-pyramid' => 'chart-pyramid' ),
					array( 'fa-light fa-chart-radar' => 'chart-radar' ),
					array( 'fa-light fa-chart-scatter-3d' => 'chart-scatter-3d' ),
					array( 'fa-light fa-chart-scatter-bubble' => 'chart-scatter-bubble' ),
					array( 'fa-light fa-chart-scatter' => 'chart-scatter' ),
					array( 'fa-light fa-chart-simple-horizontal' => 'chart-simple-horizontal' ),
					array( 'fa-light fa-chart-simple' => 'chart-simple' ),
					array( 'fa-light fa-chart-tree-map' => 'chart-tree-map' ),
					array( 'fa-light fa-chart-user' => 'chart-user' ),
					array( 'fa-light fa-chart-waterfall' => 'chart-waterfall' ),
					array( 'fa-light fa-check-double' => 'check-double' ),
					array( 'fa-light fa-check-to-slot' => 'check-to-slot' ),
					array( 'fa-light fa-check' => 'check' ),
					array( 'fa-light fa-cheese-swiss' => 'cheese-swiss' ),
					array( 'fa-light fa-cheese' => 'cheese' ),
					array( 'fa-light fa-cherries' => 'cherries' ),
					array( 'fa-light fa-chess-bishop-piece' => 'chess-bishop-piece' ),
					array( 'fa-light fa-chess-bishop' => 'chess-bishop' ),
					array( 'fa-light fa-chess-board' => 'chess-board' ),
					array( 'fa-light fa-chess-clock-flip' => 'chess-clock-flip' ),
					array( 'fa-light fa-chess-clock' => 'chess-clock' ),
					array( 'fa-light fa-chess-king-piece' => 'chess-king-piece' ),
					array( 'fa-light fa-chess-king' => 'chess-king' ),
					array( 'fa-light fa-chess-knight-piece' => 'chess-knight-piece' ),
					array( 'fa-light fa-chess-knight' => 'chess-knight' ),
					array( 'fa-light fa-chess-pawn-piece' => 'chess-pawn-piece' ),
					array( 'fa-light fa-chess-pawn' => 'chess-pawn' ),
					array( 'fa-light fa-chess-queen-piece' => 'chess-queen-piece' ),
					array( 'fa-light fa-chess-queen' => 'chess-queen' ),
					array( 'fa-light fa-chess-rook-piece' => 'chess-rook-piece' ),
					array( 'fa-light fa-chess-rook' => 'chess-rook' ),
					array( 'fa-light fa-chess' => 'chess' ),
					array( 'fa-light fa-chestnut' => 'chestnut' ),
					array( 'fa-light fa-chevron-down' => 'chevron-down' ),
					array( 'fa-light fa-chevron-left' => 'chevron-left' ),
					array( 'fa-light fa-chevron-right' => 'chevron-right' ),
					array( 'fa-light fa-chevron-up' => 'chevron-up' ),
					array( 'fa-light fa-chevrons-down' => 'chevrons-down' ),
					array( 'fa-light fa-chevrons-left' => 'chevrons-left' ),
					array( 'fa-light fa-chevrons-right' => 'chevrons-right' ),
					array( 'fa-light fa-chevrons-up' => 'chevrons-up' ),
					array( 'fa-light fa-chf-sign' => 'chf-sign' ),
					array( 'fa-light fa-child-combatant' => 'child-combatant' ),
					array( 'fa-light fa-child-dress' => 'child-dress' ),
					array( 'fa-light fa-child-reaching' => 'child-reaching' ),
					array( 'fa-light fa-child' => 'child' ),
					array( 'fa-light fa-children' => 'children' ),
					array( 'fa-light fa-chimney' => 'chimney' ),
					array( 'fa-light fa-chopsticks' => 'chopsticks' ),
					array( 'fa-light fa-church' => 'church' ),
					array( 'fa-light fa-circle-0' => 'circle-0' ),
					array( 'fa-light fa-circle-1' => 'circle-1' ),
					array( 'fa-light fa-circle-2' => 'circle-2' ),
					array( 'fa-light fa-circle-3' => 'circle-3' ),
					array( 'fa-light fa-circle-4' => 'circle-4' ),
					array( 'fa-light fa-circle-5' => 'circle-5' ),
					array( 'fa-light fa-circle-6' => 'circle-6' ),
					array( 'fa-light fa-circle-7' => 'circle-7' ),
					array( 'fa-light fa-circle-8' => 'circle-8' ),
					array( 'fa-light fa-circle-9' => 'circle-9' ),
					array( 'fa-light fa-circle-a' => 'circle-a' ),
					array( 'fa-light fa-circle-ampersand' => 'circle-ampersand' ),
					array( 'fa-light fa-circle-arrow-down-left' => 'circle-arrow-down-left' ),
					array( 'fa-light fa-circle-arrow-down-right' => 'circle-arrow-down-right' ),
					array( 'fa-light fa-circle-arrow-down' => 'circle-arrow-down' ),
					array( 'fa-light fa-circle-arrow-left' => 'circle-arrow-left' ),
					array( 'fa-light fa-circle-arrow-right' => 'circle-arrow-right' ),
					array( 'fa-light fa-circle-arrow-up-left' => 'circle-arrow-up-left' ),
					array( 'fa-light fa-circle-arrow-up-right' => 'circle-arrow-up-right' ),
					array( 'fa-light fa-circle-arrow-up' => 'circle-arrow-up' ),
					array( 'fa-light fa-circle-b' => 'circle-b' ),
					array( 'fa-light fa-circle-bolt' => 'circle-bolt' ),
					array( 'fa-light fa-circle-book-open' => 'circle-book-open' ),
					array( 'fa-light fa-circle-bookmark' => 'circle-bookmark' ),
					array( 'fa-light fa-circle-c' => 'circle-c' ),
					array( 'fa-light fa-circle-calendar' => 'circle-calendar' ),
					array( 'fa-light fa-circle-camera' => 'circle-camera' ),
					array( 'fa-light fa-circle-caret-down' => 'circle-caret-down' ),
					array( 'fa-light fa-circle-caret-left' => 'circle-caret-left' ),
					array( 'fa-light fa-circle-caret-right' => 'circle-caret-right' ),
					array( 'fa-light fa-circle-caret-up' => 'circle-caret-up' ),
					array( 'fa-light fa-circle-check' => 'circle-check' ),
					array( 'fa-light fa-circle-chevron-down' => 'circle-chevron-down' ),
					array( 'fa-light fa-circle-chevron-left' => 'circle-chevron-left' ),
					array( 'fa-light fa-circle-chevron-right' => 'circle-chevron-right' ),
					array( 'fa-light fa-circle-chevron-up' => 'circle-chevron-up' ),
					array( 'fa-light fa-circle-d' => 'circle-d' ),
					array( 'fa-light fa-circle-dashed' => 'circle-dashed' ),
					array( 'fa-light fa-circle-divide' => 'circle-divide' ),
					array( 'fa-light fa-circle-dollar-to-slot' => 'circle-dollar-to-slot' ),
					array( 'fa-light fa-circle-dollar' => 'circle-dollar' ),
					array( 'fa-light fa-circle-dot' => 'circle-dot' ),
					array( 'fa-light fa-circle-down-left' => 'circle-down-left' ),
					array( 'fa-light fa-circle-down-right' => 'circle-down-right' ),
					array( 'fa-light fa-circle-down' => 'circle-down' ),
					array( 'fa-light fa-circle-e' => 'circle-e' ),
					array( 'fa-light fa-circle-ellipsis-vertical' => 'circle-ellipsis-vertical' ),
					array( 'fa-light fa-circle-ellipsis' => 'circle-ellipsis' ),
					array( 'fa-light fa-circle-envelope' => 'circle-envelope' ),
					array( 'fa-light fa-circle-euro' => 'circle-euro' ),
					array( 'fa-light fa-circle-exclamation-check' => 'circle-exclamation-check' ),
					array( 'fa-light fa-circle-exclamation' => 'circle-exclamation' ),
					array( 'fa-light fa-circle-f' => 'circle-f' ),
					array( 'fa-light fa-circle-g' => 'circle-g' ),
					array( 'fa-light fa-circle-h' => 'circle-h' ),
					array( 'fa-light fa-circle-half-stroke' => 'circle-half-stroke' ),
					array( 'fa-light fa-circle-half' => 'circle-half' ),
					array( 'fa-light fa-circle-heart' => 'circle-heart' ),
					array( 'fa-light fa-circle-i' => 'circle-i' ),
					array( 'fa-light fa-circle-info' => 'circle-info' ),
					array( 'fa-light fa-circle-j' => 'circle-j' ),
					array( 'fa-light fa-circle-k' => 'circle-k' ),
					array( 'fa-light fa-circle-l' => 'circle-l' ),
					array( 'fa-light fa-circle-left' => 'circle-left' ),
					array( 'fa-light fa-circle-location-arrow' => 'circle-location-arrow' ),
					array( 'fa-light fa-circle-m' => 'circle-m' ),
					array( 'fa-light fa-circle-microphone-lines' => 'circle-microphone-lines' ),
					array( 'fa-light fa-circle-microphone' => 'circle-microphone' ),
					array( 'fa-light fa-circle-minus' => 'circle-minus' ),
					array( 'fa-light fa-circle-n' => 'circle-n' ),
					array( 'fa-light fa-circle-nodes' => 'circle-nodes' ),
					array( 'fa-light fa-circle-notch' => 'circle-notch' ),
					array( 'fa-light fa-circle-o' => 'circle-o' ),
					array( 'fa-light fa-circle-p' => 'circle-p' ),
					array( 'fa-light fa-circle-parking' => 'circle-parking' ),
					array( 'fa-light fa-circle-pause' => 'circle-pause' ),
					array( 'fa-light fa-circle-phone-flip' => 'circle-phone-flip' ),
					array( 'fa-light fa-circle-phone-hangup' => 'circle-phone-hangup' ),
					array( 'fa-light fa-circle-phone' => 'circle-phone' ),
					array( 'fa-light fa-circle-play' => 'circle-play' ),
					array( 'fa-light fa-circle-plus' => 'circle-plus' ),
					array( 'fa-light fa-circle-q' => 'circle-q' ),
					array( 'fa-light fa-circle-quarter-stroke' => 'circle-quarter-stroke' ),
					array( 'fa-light fa-circle-quarter' => 'circle-quarter' ),
					array( 'fa-light fa-circle-quarters' => 'circle-quarters' ),
					array( 'fa-light fa-circle-question' => 'circle-question' ),
					array( 'fa-light fa-circle-r' => 'circle-r' ),
					array( 'fa-light fa-circle-radiation' => 'circle-radiation' ),
					array( 'fa-light fa-circle-right' => 'circle-right' ),
					array( 'fa-light fa-circle-s' => 'circle-s' ),
					array( 'fa-light fa-circle-small' => 'circle-small' ),
					array( 'fa-light fa-circle-sort-down' => 'circle-sort-down' ),
					array( 'fa-light fa-circle-sort-up' => 'circle-sort-up' ),
					array( 'fa-light fa-circle-sort' => 'circle-sort' ),
					array( 'fa-light fa-circle-star' => 'circle-star' ),
					array( 'fa-light fa-circle-sterling' => 'circle-sterling' ),
					array( 'fa-light fa-circle-stop' => 'circle-stop' ),
					array( 'fa-light fa-circle-t' => 'circle-t' ),
					array( 'fa-light fa-circle-three-quarters-stroke' => 'circle-three-quarters-stroke' ),
					array( 'fa-light fa-circle-three-quarters' => 'circle-three-quarters' ),
					array( 'fa-light fa-circle-trash' => 'circle-trash' ),
					array( 'fa-light fa-circle-u' => 'circle-u' ),
					array( 'fa-light fa-circle-up-left' => 'circle-up-left' ),
					array( 'fa-light fa-circle-up-right' => 'circle-up-right' ),
					array( 'fa-light fa-circle-up' => 'circle-up' ),
					array( 'fa-light fa-circle-user' => 'circle-user' ),
					array( 'fa-light fa-circle-v' => 'circle-v' ),
					array( 'fa-light fa-circle-video' => 'circle-video' ),
					array( 'fa-light fa-circle-w' => 'circle-w' ),
					array( 'fa-light fa-circle-waveform-lines' => 'circle-waveform-lines' ),
					array( 'fa-light fa-circle-x' => 'circle-x' ),
					array( 'fa-light fa-circle-xmark' => 'circle-xmark' ),
					array( 'fa-light fa-circle-y' => 'circle-y' ),
					array( 'fa-light fa-circle-yen' => 'circle-yen' ),
					array( 'fa-light fa-circle-z' => 'circle-z' ),
					array( 'fa-light fa-circle' => 'circle' ),
					array( 'fa-light fa-circles-overlap' => 'circles-overlap' ),
					array( 'fa-light fa-citrus-slice' => 'citrus-slice' ),
					array( 'fa-light fa-citrus' => 'citrus' ),
					array( 'fa-light fa-city' => 'city' ),
					array( 'fa-light fa-clapperboard-play' => 'clapperboard-play' ),
					array( 'fa-light fa-clapperboard' => 'clapperboard' ),
					array( 'fa-light fa-clarinet' => 'clarinet' ),
					array( 'fa-light fa-claw-marks' => 'claw-marks' ),
					array( 'fa-light fa-clipboard-check' => 'clipboard-check' ),
					array( 'fa-light fa-clipboard-list-check' => 'clipboard-list-check' ),
					array( 'fa-light fa-clipboard-list' => 'clipboard-list' ),
					array( 'fa-light fa-clipboard-medical' => 'clipboard-medical' ),
					array( 'fa-light fa-clipboard-prescription' => 'clipboard-prescription' ),
					array( 'fa-light fa-clipboard-question' => 'clipboard-question' ),
					array( 'fa-light fa-clipboard-user' => 'clipboard-user' ),
					array( 'fa-light fa-clipboard' => 'clipboard' ),
					array( 'fa-light fa-clock-desk' => 'clock-desk' ),
					array( 'fa-light fa-clock-eight-thirty' => 'clock-eight-thirty' ),
					array( 'fa-light fa-clock-eight' => 'clock-eight' ),
					array( 'fa-light fa-clock-eleven-thirty' => 'clock-eleven-thirty' ),
					array( 'fa-light fa-clock-eleven' => 'clock-eleven' ),
					array( 'fa-light fa-clock-five-thirty' => 'clock-five-thirty' ),
					array( 'fa-light fa-clock-five' => 'clock-five' ),
					array( 'fa-light fa-clock-four-thirty' => 'clock-four-thirty' ),
					array( 'fa-light fa-clock-nine-thirty' => 'clock-nine-thirty' ),
					array( 'fa-light fa-clock-nine' => 'clock-nine' ),
					array( 'fa-light fa-clock-one-thirty' => 'clock-one-thirty' ),
					array( 'fa-light fa-clock-one' => 'clock-one' ),
					array( 'fa-light fa-clock-rotate-left' => 'clock-rotate-left' ),
					array( 'fa-light fa-clock-seven-thirty' => 'clock-seven-thirty' ),
					array( 'fa-light fa-clock-seven' => 'clock-seven' ),
					array( 'fa-light fa-clock-six-thirty' => 'clock-six-thirty' ),
					array( 'fa-light fa-clock-six' => 'clock-six' ),
					array( 'fa-light fa-clock-ten-thirty' => 'clock-ten-thirty' ),
					array( 'fa-light fa-clock-ten' => 'clock-ten' ),
					array( 'fa-light fa-clock-three-thirty' => 'clock-three-thirty' ),
					array( 'fa-light fa-clock-three' => 'clock-three' ),
					array( 'fa-light fa-clock-twelve-thirty' => 'clock-twelve-thirty' ),
					array( 'fa-light fa-clock-twelve' => 'clock-twelve' ),
					array( 'fa-light fa-clock-two-thirty' => 'clock-two-thirty' ),
					array( 'fa-light fa-clock-two' => 'clock-two' ),
					array( 'fa-light fa-clock' => 'clock' ),
					array( 'fa-light fa-clone' => 'clone' ),
					array( 'fa-light fa-closed-captioning-slash' => 'closed-captioning-slash' ),
					array( 'fa-light fa-closed-captioning' => 'closed-captioning' ),
					array( 'fa-light fa-clothes-hanger' => 'clothes-hanger' ),
					array( 'fa-light fa-cloud-arrow-down' => 'cloud-arrow-down' ),
					array( 'fa-light fa-cloud-arrow-up' => 'cloud-arrow-up' ),
					array( 'fa-light fa-cloud-binary' => 'cloud-binary' ),
					array( 'fa-light fa-cloud-bolt-moon' => 'cloud-bolt-moon' ),
					array( 'fa-light fa-cloud-bolt-sun' => 'cloud-bolt-sun' ),
					array( 'fa-light fa-cloud-bolt' => 'cloud-bolt' ),
					array( 'fa-light fa-cloud-check' => 'cloud-check' ),
					array( 'fa-light fa-cloud-drizzle' => 'cloud-drizzle' ),
					array( 'fa-light fa-cloud-exclamation' => 'cloud-exclamation' ),
					array( 'fa-light fa-cloud-fog' => 'cloud-fog' ),
					array( 'fa-light fa-cloud-hail-mixed' => 'cloud-hail-mixed' ),
					array( 'fa-light fa-cloud-hail' => 'cloud-hail' ),
					array( 'fa-light fa-cloud-meatball' => 'cloud-meatball' ),
					array( 'fa-light fa-cloud-minus' => 'cloud-minus' ),
					array( 'fa-light fa-cloud-moon-rain' => 'cloud-moon-rain' ),
					array( 'fa-light fa-cloud-moon' => 'cloud-moon' ),
					array( 'fa-light fa-cloud-music' => 'cloud-music' ),
					array( 'fa-light fa-cloud-plus' => 'cloud-plus' ),
					array( 'fa-light fa-cloud-question' => 'cloud-question' ),
					array( 'fa-light fa-cloud-rain' => 'cloud-rain' ),
					array( 'fa-light fa-cloud-rainbow' => 'cloud-rainbow' ),
					array( 'fa-light fa-cloud-showers-heavy' => 'cloud-showers-heavy' ),
					array( 'fa-light fa-cloud-showers-water' => 'cloud-showers-water' ),
					array( 'fa-light fa-cloud-showers' => 'cloud-showers' ),
					array( 'fa-light fa-cloud-slash' => 'cloud-slash' ),
					array( 'fa-light fa-cloud-sleet' => 'cloud-sleet' ),
					array( 'fa-light fa-cloud-snow' => 'cloud-snow' ),
					array( 'fa-light fa-cloud-sun-rain' => 'cloud-sun-rain' ),
					array( 'fa-light fa-cloud-sun' => 'cloud-sun' ),
					array( 'fa-light fa-cloud-word' => 'cloud-word' ),
					array( 'fa-light fa-cloud-xmark' => 'cloud-xmark' ),
					array( 'fa-light fa-cloud' => 'cloud' ),
					array( 'fa-light fa-clouds-moon' => 'clouds-moon' ),
					array( 'fa-light fa-clouds-sun' => 'clouds-sun' ),
					array( 'fa-light fa-clouds' => 'clouds' ),
					array( 'fa-light fa-clover' => 'clover' ),
					array( 'fa-light fa-club' => 'club' ),
					array( 'fa-light fa-coconut' => 'coconut' ),
					array( 'fa-light fa-code-branch' => 'code-branch' ),
					array( 'fa-light fa-code-commit' => 'code-commit' ),
					array( 'fa-light fa-code-compare' => 'code-compare' ),
					array( 'fa-light fa-code-fork' => 'code-fork' ),
					array( 'fa-light fa-code-merge' => 'code-merge' ),
					array( 'fa-light fa-code-pull-request-closed' => 'code-pull-request-closed' ),
					array( 'fa-light fa-code-pull-request-draft' => 'code-pull-request-draft' ),
					array( 'fa-light fa-code-pull-request' => 'code-pull-request' ),
					array( 'fa-light fa-code-simple' => 'code-simple' ),
					array( 'fa-light fa-code' => 'code' ),
					array( 'fa-light fa-coffee-bean' => 'coffee-bean' ),
					array( 'fa-light fa-coffee-beans' => 'coffee-beans' ),
					array( 'fa-light fa-coffee-pot' => 'coffee-pot' ),
					array( 'fa-light fa-coffin-cross' => 'coffin-cross' ),
					array( 'fa-light fa-coffin' => 'coffin' ),
					array( 'fa-light fa-coin-blank' => 'coin-blank' ),
					array( 'fa-light fa-coin-front' => 'coin-front' ),
					array( 'fa-light fa-coin-vertical' => 'coin-vertical' ),
					array( 'fa-light fa-coin' => 'coin' ),
					array( 'fa-light fa-coins' => 'coins' ),
					array( 'fa-light fa-colon-sign' => 'colon-sign' ),
					array( 'fa-light fa-colon' => 'colon' ),
					array( 'fa-light fa-columns-3' => 'columns-3' ),
					array( 'fa-light fa-comet' => 'comet' ),
					array( 'fa-light fa-comma' => 'comma' ),
					array( 'fa-light fa-command' => 'command' ),
					array( 'fa-light fa-comment-arrow-down' => 'comment-arrow-down' ),
					array( 'fa-light fa-comment-arrow-up-right' => 'comment-arrow-up-right' ),
					array( 'fa-light fa-comment-arrow-up' => 'comment-arrow-up' ),
					array( 'fa-light fa-comment-captions' => 'comment-captions' ),
					array( 'fa-light fa-comment-check' => 'comment-check' ),
					array( 'fa-light fa-comment-code' => 'comment-code' ),
					array( 'fa-light fa-comment-dollar' => 'comment-dollar' ),
					array( 'fa-light fa-comment-dots' => 'comment-dots' ),
					array( 'fa-light fa-comment-exclamation' => 'comment-exclamation' ),
					array( 'fa-light fa-comment-heart' => 'comment-heart' ),
					array( 'fa-light fa-comment-image' => 'comment-image' ),
					array( 'fa-light fa-comment-lines' => 'comment-lines' ),
					array( 'fa-light fa-comment-medical' => 'comment-medical' ),
					array( 'fa-light fa-comment-middle-top' => 'comment-middle-top' ),
					array( 'fa-light fa-comment-middle' => 'comment-middle' ),
					array( 'fa-light fa-comment-minus' => 'comment-minus' ),
					array( 'fa-light fa-comment-music' => 'comment-music' ),
					array( 'fa-light fa-comment-pen' => 'comment-pen' ),
					array( 'fa-light fa-comment-plus' => 'comment-plus' ),
					array( 'fa-light fa-comment-question' => 'comment-question' ),
					array( 'fa-light fa-comment-quote' => 'comment-quote' ),
					array( 'fa-light fa-comment-slash' => 'comment-slash' ),
					array( 'fa-light fa-comment-smile' => 'comment-smile' ),
					array( 'fa-light fa-comment-sms' => 'comment-sms' ),
					array( 'fa-light fa-comment-text' => 'comment-text' ),
					array( 'fa-light fa-comment-xmark' => 'comment-xmark' ),
					array( 'fa-light fa-comment' => 'comment' ),
					array( 'fa-light fa-comments-dollar' => 'comments-dollar' ),
					array( 'fa-light fa-comments-question-check' => 'comments-question-check' ),
					array( 'fa-light fa-comments-question' => 'comments-question' ),
					array( 'fa-light fa-comments' => 'comments' ),
					array( 'fa-light fa-compact-disc' => 'compact-disc' ),
					array( 'fa-light fa-compass-drafting' => 'compass-drafting' ),
					array( 'fa-light fa-compass-slash' => 'compass-slash' ),
					array( 'fa-light fa-compass' => 'compass' ),
					array( 'fa-light fa-compress-wide' => 'compress-wide' ),
					array( 'fa-light fa-compress' => 'compress' ),
					array( 'fa-light fa-computer-classic' => 'computer-classic' ),
					array( 'fa-light fa-computer-mouse-scrollwheel' => 'computer-mouse-scrollwheel' ),
					array( 'fa-light fa-computer-mouse' => 'computer-mouse' ),
					array( 'fa-light fa-computer-speaker' => 'computer-speaker' ),
					array( 'fa-light fa-computer' => 'computer' ),
					array( 'fa-light fa-container-storage' => 'container-storage' ),
					array( 'fa-light fa-conveyor-belt-arm' => 'conveyor-belt-arm' ),
					array( 'fa-light fa-conveyor-belt-boxes' => 'conveyor-belt-boxes' ),
					array( 'fa-light fa-conveyor-belt-empty' => 'conveyor-belt-empty' ),
					array( 'fa-light fa-conveyor-belt' => 'conveyor-belt' ),
					array( 'fa-light fa-cookie-bite' => 'cookie-bite' ),
					array( 'fa-light fa-cookie' => 'cookie' ),
					array( 'fa-light fa-copy' => 'copy' ),
					array( 'fa-light fa-copyright' => 'copyright' ),
					array( 'fa-light fa-corn' => 'corn' ),
					array( 'fa-light fa-corner' => 'corner' ),
					array( 'fa-light fa-couch' => 'couch' ),
					array( 'fa-light fa-cow' => 'cow' ),
					array( 'fa-light fa-cowbell-circle-plus' => 'cowbell-circle-plus' ),
					array( 'fa-light fa-cowbell' => 'cowbell' ),
					array( 'fa-light fa-crab' => 'crab' ),
					array( 'fa-light fa-crate-apple' => 'crate-apple' ),
					array( 'fa-light fa-crate-empty' => 'crate-empty' ),
					array( 'fa-light fa-credit-card-blank' => 'credit-card-blank' ),
					array( 'fa-light fa-credit-card-front' => 'credit-card-front' ),
					array( 'fa-light fa-credit-card' => 'credit-card' ),
					array( 'fa-light fa-cricket-bat-ball' => 'cricket-bat-ball' ),
					array( 'fa-light fa-croissant' => 'croissant' ),
					array( 'fa-light fa-crop-simple' => 'crop-simple' ),
					array( 'fa-light fa-crop' => 'crop' ),
					array( 'fa-light fa-cross' => 'cross' ),
					array( 'fa-light fa-crosshairs-simple' => 'crosshairs-simple' ),
					array( 'fa-light fa-crosshairs' => 'crosshairs' ),
					array( 'fa-light fa-crow' => 'crow' ),
					array( 'fa-light fa-crown' => 'crown' ),
					array( 'fa-light fa-crutch' => 'crutch' ),
					array( 'fa-light fa-crutches' => 'crutches' ),
					array( 'fa-light fa-cruzeiro-sign' => 'cruzeiro-sign' ),
					array( 'fa-light fa-crystal-ball' => 'crystal-ball' ),
					array( 'fa-light fa-cube' => 'cube' ),
					array( 'fa-light fa-cubes-stacked' => 'cubes-stacked' ),
					array( 'fa-light fa-cubes' => 'cubes' ),
					array( 'fa-light fa-cucumber' => 'cucumber' ),
					array( 'fa-light fa-cup-straw-swoosh' => 'cup-straw-swoosh' ),
					array( 'fa-light fa-cup-straw' => 'cup-straw' ),
					array( 'fa-light fa-cup-togo' => 'cup-togo' ),
					array( 'fa-light fa-cupcake' => 'cupcake' ),
					array( 'fa-light fa-curling-stone' => 'curling-stone' ),
					array( 'fa-light fa-custard' => 'custard' ),
					array( 'fa-light fa-d' => 'd' ),
					array( 'fa-light fa-dagger' => 'dagger' ),
					array( 'fa-light fa-dash' => 'dash' ),
					array( 'fa-light fa-database' => 'database' ),
					array( 'fa-light fa-deer-rudolph' => 'deer-rudolph' ),
					array( 'fa-light fa-deer' => 'deer' ),
					array( 'fa-light fa-delete-left' => 'delete-left' ),
					array( 'fa-light fa-delete-right' => 'delete-right' ),
					array( 'fa-light fa-democrat' => 'democrat' ),
					array( 'fa-light fa-desktop-arrow-down' => 'desktop-arrow-down' ),
					array( 'fa-light fa-desktop' => 'desktop' ),
					array( 'fa-light fa-dharmachakra' => 'dharmachakra' ),
					array( 'fa-light fa-diagram-cells' => 'diagram-cells' ),
					array( 'fa-light fa-diagram-lean-canvas' => 'diagram-lean-canvas' ),
					array( 'fa-light fa-diagram-nested' => 'diagram-nested' ),
					array( 'fa-light fa-diagram-next' => 'diagram-next' ),
					array( 'fa-light fa-diagram-predecessor' => 'diagram-predecessor' ),
					array( 'fa-light fa-diagram-previous' => 'diagram-previous' ),
					array( 'fa-light fa-diagram-project' => 'diagram-project' ),
					array( 'fa-light fa-diagram-sankey' => 'diagram-sankey' ),
					array( 'fa-light fa-diagram-subtask' => 'diagram-subtask' ),
					array( 'fa-light fa-diagram-successor' => 'diagram-successor' ),
					array( 'fa-light fa-diagram-venn' => 'diagram-venn' ),
					array( 'fa-light fa-dial-high' => 'dial-high' ),
					array( 'fa-light fa-dial-low' => 'dial-low' ),
					array( 'fa-light fa-dial-max' => 'dial-max' ),
					array( 'fa-light fa-dial-med-low' => 'dial-med-low' ),
					array( 'fa-light fa-dial-med' => 'dial-med' ),
					array( 'fa-light fa-dial-min' => 'dial-min' ),
					array( 'fa-light fa-dial-off' => 'dial-off' ),
					array( 'fa-light fa-dial' => 'dial' ),
					array( 'fa-light fa-diamond-exclamation' => 'diamond-exclamation' ),
					array( 'fa-light fa-diamond-half-stroke' => 'diamond-half-stroke' ),
					array( 'fa-light fa-diamond-half' => 'diamond-half' ),
					array( 'fa-light fa-diamond-turn-right' => 'diamond-turn-right' ),
					array( 'fa-light fa-diamond' => 'diamond' ),
					array( 'fa-light fa-dice-d4' => 'dice-d4' ),
					array( 'fa-light fa-dice-d6' => 'dice-d6' ),
					array( 'fa-light fa-dice-d8' => 'dice-d8' ),
					array( 'fa-light fa-dice-d10' => 'dice-d10' ),
					array( 'fa-light fa-dice-d12' => 'dice-d12' ),
					array( 'fa-light fa-dice-d20' => 'dice-d20' ),
					array( 'fa-light fa-dice-five' => 'dice-five' ),
					array( 'fa-light fa-dice-four' => 'dice-four' ),
					array( 'fa-light fa-dice-one' => 'dice-one' ),
					array( 'fa-light fa-dice-six' => 'dice-six' ),
					array( 'fa-light fa-dice-three' => 'dice-three' ),
					array( 'fa-light fa-dice-two' => 'dice-two' ),
					array( 'fa-light fa-dice' => 'dice' ),
					array( 'fa-light fa-dinosaur' => 'dinosaur' ),
					array( 'fa-light fa-diploma' => 'diploma' ),
					array( 'fa-light fa-disc-drive' => 'disc-drive' ),
					array( 'fa-light fa-disease' => 'disease' ),
					array( 'fa-light fa-display-arrow-down' => 'display-arrow-down' ),
					array( 'fa-light fa-display-chart-up-circle-currency' => 'display-chart-up-circle-currency' ),
					array( 'fa-light fa-display-chart-up-circle-dollar' => 'display-chart-up-circle-dollar' ),
					array( 'fa-light fa-display-chart-up' => 'display-chart-up' ),
					array( 'fa-light fa-display-code' => 'display-code' ),
					array( 'fa-light fa-display-medical' => 'display-medical' ),
					array( 'fa-light fa-display-slash' => 'display-slash' ),
					array( 'fa-light fa-display' => 'display' ),
					array( 'fa-light fa-distribute-spacing-horizontal' => 'distribute-spacing-horizontal' ),
					array( 'fa-light fa-distribute-spacing-vertical' => 'distribute-spacing-vertical' ),
					array( 'fa-light fa-ditto' => 'ditto' ),
					array( 'fa-light fa-divide' => 'divide' ),
					array( 'fa-light fa-dna' => 'dna' ),
					array( 'fa-light fa-do-not-enter' => 'do-not-enter' ),
					array( 'fa-light fa-dog-leashed' => 'dog-leashed' ),
					array( 'fa-light fa-dog' => 'dog' ),
					array( 'fa-light fa-dollar-sign' => 'dollar-sign' ),
					array( 'fa-light fa-dolly-empty' => 'dolly-empty' ),
					array( 'fa-light fa-dolly' => 'dolly' ),
					array( 'fa-light fa-dolphin' => 'dolphin' ),
					array( 'fa-light fa-dong-sign' => 'dong-sign' ),
					array( 'fa-light fa-donut' => 'donut' ),
					array( 'fa-light fa-door-closed' => 'door-closed' ),
					array( 'fa-light fa-door-open' => 'door-open' ),
					array( 'fa-light fa-dove' => 'dove' ),
					array( 'fa-light fa-down-from-dotted-line' => 'down-from-dotted-line' ),
					array( 'fa-light fa-down-from-line' => 'down-from-line' ),
					array( 'fa-light fa-down-left-and-up-right-to-center' => 'down-left-and-up-right-to-center' ),
					array( 'fa-light fa-down-left' => 'down-left' ),
					array( 'fa-light fa-down-long' => 'down-long' ),
					array( 'fa-light fa-down-right' => 'down-right' ),
					array( 'fa-light fa-down-to-bracket' => 'down-to-bracket' ),
					array( 'fa-light fa-down-to-dotted-line' => 'down-to-dotted-line' ),
					array( 'fa-light fa-down-to-line' => 'down-to-line' ),
					array( 'fa-light fa-down' => 'down' ),
					array( 'fa-light fa-download' => 'download' ),
					array( 'fa-light fa-dragon' => 'dragon' ),
					array( 'fa-light fa-draw-circle' => 'draw-circle' ),
					array( 'fa-light fa-draw-polygon' => 'draw-polygon' ),
					array( 'fa-light fa-draw-square' => 'draw-square' ),
					array( 'fa-light fa-dreidel' => 'dreidel' ),
					array( 'fa-light fa-drone-front' => 'drone-front' ),
					array( 'fa-light fa-drone' => 'drone' ),
					array( 'fa-light fa-droplet-degree' => 'droplet-degree' ),
					array( 'fa-light fa-droplet-percent' => 'droplet-percent' ),
					array( 'fa-light fa-droplet-slash' => 'droplet-slash' ),
					array( 'fa-light fa-droplet' => 'droplet' ),
					array( 'fa-light fa-drum-steelpan' => 'drum-steelpan' ),
					array( 'fa-light fa-drum' => 'drum' ),
					array( 'fa-light fa-drumstick-bite' => 'drumstick-bite' ),
					array( 'fa-light fa-drumstick' => 'drumstick' ),
					array( 'fa-light fa-dryer-heat' => 'dryer-heat' ),
					array( 'fa-light fa-dryer' => 'dryer' ),
					array( 'fa-light fa-duck' => 'duck' ),
					array( 'fa-light fa-dumbbell' => 'dumbbell' ),
					array( 'fa-light fa-dumpster-fire' => 'dumpster-fire' ),
					array( 'fa-light fa-dumpster' => 'dumpster' ),
					array( 'fa-light fa-dungeon' => 'dungeon' ),
					array( 'fa-light fa-e' => 'e' ),
					array( 'fa-light fa-ear-deaf' => 'ear-deaf' ),
					array( 'fa-light fa-ear-listen' => 'ear-listen' ),
					array( 'fa-light fa-ear-muffs' => 'ear-muffs' ),
					array( 'fa-light fa-ear' => 'ear' ),
					array( 'fa-light fa-earth-africa' => 'earth-africa' ),
					array( 'fa-light fa-earth-americas' => 'earth-americas' ),
					array( 'fa-light fa-earth-asia' => 'earth-asia' ),
					array( 'fa-light fa-earth-europe' => 'earth-europe' ),
					array( 'fa-light fa-earth-oceania' => 'earth-oceania' ),
					array( 'fa-light fa-eclipse' => 'eclipse' ),
					array( 'fa-light fa-egg-fried' => 'egg-fried' ),
					array( 'fa-light fa-egg' => 'egg' ),
					array( 'fa-light fa-eggplant' => 'eggplant' ),
					array( 'fa-light fa-eject' => 'eject' ),
					array( 'fa-light fa-elephant' => 'elephant' ),
					array( 'fa-light fa-elevator' => 'elevator' ),
					array( 'fa-light fa-ellipsis-stroke-vertical' => 'ellipsis-stroke-vertical' ),
					array( 'fa-light fa-ellipsis-stroke' => 'ellipsis-stroke' ),
					array( 'fa-light fa-ellipsis-vertical' => 'ellipsis-vertical' ),
					array( 'fa-light fa-ellipsis' => 'ellipsis' ),
					array( 'fa-light fa-empty-set' => 'empty-set' ),
					array( 'fa-light fa-engine-warning' => 'engine-warning' ),
					array( 'fa-light fa-engine' => 'engine' ),
					array( 'fa-light fa-envelope-circle-check' => 'envelope-circle-check' ),
					array( 'fa-light fa-envelope-dot' => 'envelope-dot' ),
					array( 'fa-light fa-envelope-open-dollar' => 'envelope-open-dollar' ),
					array( 'fa-light fa-envelope-open-text' => 'envelope-open-text' ),
					array( 'fa-light fa-envelope-open' => 'envelope-open' ),
					array( 'fa-light fa-envelope' => 'envelope' ),
					array( 'fa-light fa-envelopes-bulk' => 'envelopes-bulk' ),
					array( 'fa-light fa-envelopes' => 'envelopes' ),
					array( 'fa-light fa-equals' => 'equals' ),
					array( 'fa-light fa-eraser' => 'eraser' ),
					array( 'fa-light fa-escalator' => 'escalator' ),
					array( 'fa-light fa-ethernet' => 'ethernet' ),
					array( 'fa-light fa-euro-sign' => 'euro-sign' ),
					array( 'fa-light fa-exclamation' => 'exclamation' ),
					array( 'fa-light fa-expand-wide' => 'expand-wide' ),
					array( 'fa-light fa-expand' => 'expand' ),
					array( 'fa-light fa-explosion' => 'explosion' ),
					array( 'fa-light fa-eye-dropper-full' => 'eye-dropper-full' ),
					array( 'fa-light fa-eye-dropper-half' => 'eye-dropper-half' ),
					array( 'fa-light fa-eye-dropper' => 'eye-dropper' ),
					array( 'fa-light fa-eye-evil' => 'eye-evil' ),
					array( 'fa-light fa-eye-low-vision' => 'eye-low-vision' ),
					array( 'fa-light fa-eye-slash' => 'eye-slash' ),
					array( 'fa-light fa-eye' => 'eye' ),
					array( 'fa-light fa-eyes' => 'eyes' ),
					array( 'fa-light fa-f' => 'f' ),
					array( 'fa-light fa-face-angry-horns' => 'face-angry-horns' ),
					array( 'fa-light fa-face-angry' => 'face-angry' ),
					array( 'fa-light fa-face-anguished' => 'face-anguished' ),
					array( 'fa-light fa-face-anxious-sweat' => 'face-anxious-sweat' ),
					array( 'fa-light fa-face-astonished' => 'face-astonished' ),
					array( 'fa-light fa-face-awesome' => 'face-awesome' ),
					array( 'fa-light fa-face-beam-hand-over-mouth' => 'face-beam-hand-over-mouth' ),
					array( 'fa-light fa-face-clouds' => 'face-clouds' ),
					array( 'fa-light fa-face-confounded' => 'face-confounded' ),
					array( 'fa-light fa-face-confused' => 'face-confused' ),
					array( 'fa-light fa-face-cowboy-hat' => 'face-cowboy-hat' ),
					array( 'fa-light fa-face-diagonal-mouth' => 'face-diagonal-mouth' ),
					array( 'fa-light fa-face-disappointed' => 'face-disappointed' ),
					array( 'fa-light fa-face-disguise' => 'face-disguise' ),
					array( 'fa-light fa-face-dizzy' => 'face-dizzy' ),
					array( 'fa-light fa-face-dotted' => 'face-dotted' ),
					array( 'fa-light fa-face-downcast-sweat' => 'face-downcast-sweat' ),
					array( 'fa-light fa-face-drooling' => 'face-drooling' ),
					array( 'fa-light fa-face-exhaling' => 'face-exhaling' ),
					array( 'fa-light fa-face-explode' => 'face-explode' ),
					array( 'fa-light fa-face-expressionless' => 'face-expressionless' ),
					array( 'fa-light fa-face-eyes-xmarks' => 'face-eyes-xmarks' ),
					array( 'fa-light fa-face-fearful' => 'face-fearful' ),
					array( 'fa-light fa-face-flushed' => 'face-flushed' ),
					array( 'fa-light fa-face-frown-open' => 'face-frown-open' ),
					array( 'fa-light fa-face-frown-slight' => 'face-frown-slight' ),
					array( 'fa-light fa-face-frown' => 'face-frown' ),
					array( 'fa-light fa-face-glasses' => 'face-glasses' ),
					array( 'fa-light fa-face-grimace' => 'face-grimace' ),
					array( 'fa-light fa-face-grin-beam-sweat' => 'face-grin-beam-sweat' ),
					array( 'fa-light fa-face-grin-beam' => 'face-grin-beam' ),
					array( 'fa-light fa-face-grin-hearts' => 'face-grin-hearts' ),
					array( 'fa-light fa-face-grin-squint-tears' => 'face-grin-squint-tears' ),
					array( 'fa-light fa-face-grin-squint' => 'face-grin-squint' ),
					array( 'fa-light fa-face-grin-stars' => 'face-grin-stars' ),
					array( 'fa-light fa-face-grin-tears' => 'face-grin-tears' ),
					array( 'fa-light fa-face-grin-tongue-squint' => 'face-grin-tongue-squint' ),
					array( 'fa-light fa-face-grin-tongue-wink' => 'face-grin-tongue-wink' ),
					array( 'fa-light fa-face-grin-tongue' => 'face-grin-tongue' ),
					array( 'fa-light fa-face-grin-wide' => 'face-grin-wide' ),
					array( 'fa-light fa-face-grin-wink' => 'face-grin-wink' ),
					array( 'fa-light fa-face-grin' => 'face-grin' ),
					array( 'fa-light fa-face-hand-over-mouth' => 'face-hand-over-mouth' ),
					array( 'fa-light fa-face-hand-peeking' => 'face-hand-peeking' ),
					array( 'fa-light fa-face-hand-yawn' => 'face-hand-yawn' ),
					array( 'fa-light fa-face-head-bandage' => 'face-head-bandage' ),
					array( 'fa-light fa-face-holding-back-tears' => 'face-holding-back-tears' ),
					array( 'fa-light fa-face-hushed' => 'face-hushed' ),
					array( 'fa-light fa-face-icicles' => 'face-icicles' ),
					array( 'fa-light fa-face-kiss-beam' => 'face-kiss-beam' ),
					array( 'fa-light fa-face-kiss-closed-eyes' => 'face-kiss-closed-eyes' ),
					array( 'fa-light fa-face-kiss-wink-heart' => 'face-kiss-wink-heart' ),
					array( 'fa-light fa-face-kiss' => 'face-kiss' ),
					array( 'fa-light fa-face-laugh-beam' => 'face-laugh-beam' ),
					array( 'fa-light fa-face-laugh-squint' => 'face-laugh-squint' ),
					array( 'fa-light fa-face-laugh-wink' => 'face-laugh-wink' ),
					array( 'fa-light fa-face-laugh' => 'face-laugh' ),
					array( 'fa-light fa-face-lying' => 'face-lying' ),
					array( 'fa-light fa-face-mask' => 'face-mask' ),
					array( 'fa-light fa-face-meh-blank' => 'face-meh-blank' ),
					array( 'fa-light fa-face-meh' => 'face-meh' ),
					array( 'fa-light fa-face-melting' => 'face-melting' ),
					array( 'fa-light fa-face-monocle' => 'face-monocle' ),
					array( 'fa-light fa-face-nauseated' => 'face-nauseated' ),
					array( 'fa-light fa-face-nose-steam' => 'face-nose-steam' ),
					array( 'fa-light fa-face-party' => 'face-party' ),
					array( 'fa-light fa-face-pensive' => 'face-pensive' ),
					array( 'fa-light fa-face-persevering' => 'face-persevering' ),
					array( 'fa-light fa-face-pleading' => 'face-pleading' ),
					array( 'fa-light fa-face-pouting' => 'face-pouting' ),
					array( 'fa-light fa-face-raised-eyebrow' => 'face-raised-eyebrow' ),
					array( 'fa-light fa-face-relieved' => 'face-relieved' ),
					array( 'fa-light fa-face-rolling-eyes' => 'face-rolling-eyes' ),
					array( 'fa-light fa-face-sad-cry' => 'face-sad-cry' ),
					array( 'fa-light fa-face-sad-sweat' => 'face-sad-sweat' ),
					array( 'fa-light fa-face-sad-tear' => 'face-sad-tear' ),
					array( 'fa-light fa-face-saluting' => 'face-saluting' ),
					array( 'fa-light fa-face-scream' => 'face-scream' ),
					array( 'fa-light fa-face-shush' => 'face-shush' ),
					array( 'fa-light fa-face-sleeping' => 'face-sleeping' ),
					array( 'fa-light fa-face-sleepy' => 'face-sleepy' ),
					array( 'fa-light fa-face-smile-beam' => 'face-smile-beam' ),
					array( 'fa-light fa-face-smile-halo' => 'face-smile-halo' ),
					array( 'fa-light fa-face-smile-hearts' => 'face-smile-hearts' ),
					array( 'fa-light fa-face-smile-horns' => 'face-smile-horns' ),
					array( 'fa-light fa-face-smile-plus' => 'face-smile-plus' ),
					array( 'fa-light fa-face-smile-relaxed' => 'face-smile-relaxed' ),
					array( 'fa-light fa-face-smile-tear' => 'face-smile-tear' ),
					array( 'fa-light fa-face-smile-tongue' => 'face-smile-tongue' ),
					array( 'fa-light fa-face-smile-upside-down' => 'face-smile-upside-down' ),
					array( 'fa-light fa-face-smile-wink' => 'face-smile-wink' ),
					array( 'fa-light fa-face-smile' => 'face-smile' ),
					array( 'fa-light fa-face-smiling-hands' => 'face-smiling-hands' ),
					array( 'fa-light fa-face-smirking' => 'face-smirking' ),
					array( 'fa-light fa-face-spiral-eyes' => 'face-spiral-eyes' ),
					array( 'fa-light fa-face-sunglasses' => 'face-sunglasses' ),
					array( 'fa-light fa-face-surprise' => 'face-surprise' ),
					array( 'fa-light fa-face-swear' => 'face-swear' ),
					array( 'fa-light fa-face-thermometer' => 'face-thermometer' ),
					array( 'fa-light fa-face-thinking' => 'face-thinking' ),
					array( 'fa-light fa-face-tired' => 'face-tired' ),
					array( 'fa-light fa-face-tissue' => 'face-tissue' ),
					array( 'fa-light fa-face-tongue-money' => 'face-tongue-money' ),
					array( 'fa-light fa-face-tongue-sweat' => 'face-tongue-sweat' ),
					array( 'fa-light fa-face-unamused' => 'face-unamused' ),
					array( 'fa-light fa-face-viewfinder' => 'face-viewfinder' ),
					array( 'fa-light fa-face-vomit' => 'face-vomit' ),
					array( 'fa-light fa-face-weary' => 'face-weary' ),
					array( 'fa-light fa-face-woozy' => 'face-woozy' ),
					array( 'fa-light fa-face-worried' => 'face-worried' ),
					array( 'fa-light fa-face-zany' => 'face-zany' ),
					array( 'fa-light fa-face-zipper' => 'face-zipper' ),
					array( 'fa-light fa-falafel' => 'falafel' ),
					array( 'fa-light fa-family-dress' => 'family-dress' ),
					array( 'fa-light fa-family-pants' => 'family-pants' ),
					array( 'fa-light fa-family' => 'family' ),
					array( 'fa-light fa-fan-table' => 'fan-table' ),
					array( 'fa-light fa-fan' => 'fan' ),
					array( 'fa-light fa-farm' => 'farm' ),
					array( 'fa-light fa-faucet-drip' => 'faucet-drip' ),
					array( 'fa-light fa-faucet' => 'faucet' ),
					array( 'fa-light fa-fax' => 'fax' ),
					array( 'fa-light fa-feather-pointed' => 'feather-pointed' ),
					array( 'fa-light fa-feather' => 'feather' ),
					array( 'fa-light fa-fence' => 'fence' ),
					array( 'fa-light fa-ferris-wheel' => 'ferris-wheel' ),
					array( 'fa-light fa-ferry' => 'ferry' ),
					array( 'fa-light fa-field-hockey-stick-ball' => 'field-hockey-stick-ball' ),
					array( 'fa-light fa-file-arrow-down' => 'file-arrow-down' ),
					array( 'fa-light fa-file-arrow-up' => 'file-arrow-up' ),
					array( 'fa-light fa-file-audio' => 'file-audio' ),
					array( 'fa-light fa-file-binary' => 'file-binary' ),
					array( 'fa-light fa-file-certificate' => 'file-certificate' ),
					array( 'fa-light fa-file-chart-column' => 'file-chart-column' ),
					array( 'fa-light fa-file-chart-pie' => 'file-chart-pie' ),
					array( 'fa-light fa-file-check' => 'file-check' ),
					array( 'fa-light fa-file-circle-check' => 'file-circle-check' ),
					array( 'fa-light fa-file-circle-exclamation' => 'file-circle-exclamation' ),
					array( 'fa-light fa-file-circle-info' => 'file-circle-info' ),
					array( 'fa-light fa-file-circle-minus' => 'file-circle-minus' ),
					array( 'fa-light fa-file-circle-plus' => 'file-circle-plus' ),
					array( 'fa-light fa-file-circle-question' => 'file-circle-question' ),
					array( 'fa-light fa-file-circle-xmark' => 'file-circle-xmark' ),
					array( 'fa-light fa-file-code' => 'file-code' ),
					array( 'fa-light fa-file-contract' => 'file-contract' ),
					array( 'fa-light fa-file-csv' => 'file-csv' ),
					array( 'fa-light fa-file-dashed-line' => 'file-dashed-line' ),
					array( 'fa-light fa-file-doc' => 'file-doc' ),
					array( 'fa-light fa-file-excel' => 'file-excel' ),
					array( 'fa-light fa-file-exclamation' => 'file-exclamation' ),
					array( 'fa-light fa-file-export' => 'file-export' ),
					array( 'fa-light fa-file-heart' => 'file-heart' ),
					array( 'fa-light fa-file-image' => 'file-image' ),
					array( 'fa-light fa-file-import' => 'file-import' ),
					array( 'fa-light fa-file-invoice-dollar' => 'file-invoice-dollar' ),
					array( 'fa-light fa-file-invoice' => 'file-invoice' ),
					array( 'fa-light fa-file-lines' => 'file-lines' ),
					array( 'fa-light fa-file-lock' => 'file-lock' ),
					array( 'fa-light fa-file-magnifying-glass' => 'file-magnifying-glass' ),
					array( 'fa-light fa-file-medical' => 'file-medical' ),
					array( 'fa-light fa-file-minus' => 'file-minus' ),
					array( 'fa-light fa-file-music' => 'file-music' ),
					array( 'fa-light fa-file-pdf' => 'file-pdf' ),
					array( 'fa-light fa-file-pen' => 'file-pen' ),
					array( 'fa-light fa-file-plus-minus' => 'file-plus-minus' ),
					array( 'fa-light fa-file-plus' => 'file-plus' ),
					array( 'fa-light fa-file-powerpoint' => 'file-powerpoint' ),
					array( 'fa-light fa-file-prescription' => 'file-prescription' ),
					array( 'fa-light fa-file-shield' => 'file-shield' ),
					array( 'fa-light fa-file-signature' => 'file-signature' ),
					array( 'fa-light fa-file-slash' => 'file-slash' ),
					array( 'fa-light fa-file-spreadsheet' => 'file-spreadsheet' ),
					array( 'fa-light fa-file-user' => 'file-user' ),
					array( 'fa-light fa-file-video' => 'file-video' ),
					array( 'fa-light fa-file-waveform' => 'file-waveform' ),
					array( 'fa-light fa-file-word' => 'file-word' ),
					array( 'fa-light fa-file-xmark' => 'file-xmark' ),
					array( 'fa-light fa-file-zip' => 'file-zip' ),
					array( 'fa-light fa-file-zipper' => 'file-zipper' ),
					array( 'fa-light fa-file' => 'file' ),
					array( 'fa-light fa-files-medical' => 'files-medical' ),
					array( 'fa-light fa-files' => 'files' ),
					array( 'fa-light fa-fill-drip' => 'fill-drip' ),
					array( 'fa-light fa-fill' => 'fill' ),
					array( 'fa-light fa-film-canister' => 'film-canister' ),
					array( 'fa-light fa-film-simple' => 'film-simple' ),
					array( 'fa-light fa-film-slash' => 'film-slash' ),
					array( 'fa-light fa-film' => 'film' ),
					array( 'fa-light fa-films' => 'films' ),
					array( 'fa-light fa-filter-circle-dollar' => 'filter-circle-dollar' ),
					array( 'fa-light fa-filter-circle-xmark' => 'filter-circle-xmark' ),
					array( 'fa-light fa-filter-list' => 'filter-list' ),
					array( 'fa-light fa-filter-slash' => 'filter-slash' ),
					array( 'fa-light fa-filter' => 'filter' ),
					array( 'fa-light fa-filters' => 'filters' ),
					array( 'fa-light fa-fingerprint' => 'fingerprint' ),
					array( 'fa-light fa-fire-burner' => 'fire-burner' ),
					array( 'fa-light fa-fire-extinguisher' => 'fire-extinguisher' ),
					array( 'fa-light fa-fire-flame-curved' => 'fire-flame-curved' ),
					array( 'fa-light fa-fire-flame-simple' => 'fire-flame-simple' ),
					array( 'fa-light fa-fire-flame' => 'fire-flame' ),
					array( 'fa-light fa-fire-hydrant' => 'fire-hydrant' ),
					array( 'fa-light fa-fire-smoke' => 'fire-smoke' ),
					array( 'fa-light fa-fire' => 'fire' ),
					array( 'fa-light fa-fireplace' => 'fireplace' ),
					array( 'fa-light fa-fish-bones' => 'fish-bones' ),
					array( 'fa-light fa-fish-cooked' => 'fish-cooked' ),
					array( 'fa-light fa-fish-fins' => 'fish-fins' ),
					array( 'fa-light fa-fish' => 'fish' ),
					array( 'fa-light fa-fishing-rod' => 'fishing-rod' ),
					array( 'fa-light fa-flag-checkered' => 'flag-checkered' ),
					array( 'fa-light fa-flag-pennant' => 'flag-pennant' ),
					array( 'fa-light fa-flag-swallowtail' => 'flag-swallowtail' ),
					array( 'fa-light fa-flag-usa' => 'flag-usa' ),
					array( 'fa-light fa-flag' => 'flag' ),
					array( 'fa-light fa-flashlight' => 'flashlight' ),
					array( 'fa-light fa-flask-gear' => 'flask-gear' ),
					array( 'fa-light fa-flask-round-poison' => 'flask-round-poison' ),
					array( 'fa-light fa-flask-round-potion' => 'flask-round-potion' ),
					array( 'fa-light fa-flask-vial' => 'flask-vial' ),
					array( 'fa-light fa-flask' => 'flask' ),
					array( 'fa-light fa-flatbread-stuffed' => 'flatbread-stuffed' ),
					array( 'fa-light fa-flatbread' => 'flatbread' ),
					array( 'fa-light fa-floppy-disk-circle-arrow-right' => 'floppy-disk-circle-arrow-right' ),
					array( 'fa-light fa-floppy-disk-circle-xmark' => 'floppy-disk-circle-xmark' ),
					array( 'fa-light fa-floppy-disk-pen' => 'floppy-disk-pen' ),
					array( 'fa-light fa-floppy-disk' => 'floppy-disk' ),
					array( 'fa-light fa-floppy-disks' => 'floppy-disks' ),
					array( 'fa-light fa-florin-sign' => 'florin-sign' ),
					array( 'fa-light fa-flower-daffodil' => 'flower-daffodil' ),
					array( 'fa-light fa-flower-tulip' => 'flower-tulip' ),
					array( 'fa-light fa-flower' => 'flower' ),
					array( 'fa-light fa-flute' => 'flute' ),
					array( 'fa-light fa-flux-capacitor' => 'flux-capacitor' ),
					array( 'fa-light fa-flying-disc' => 'flying-disc' ),
					array( 'fa-light fa-folder-arrow-down' => 'folder-arrow-down' ),
					array( 'fa-light fa-folder-arrow-up' => 'folder-arrow-up' ),
					array( 'fa-light fa-folder-bookmark' => 'folder-bookmark' ),
					array( 'fa-light fa-folder-closed' => 'folder-closed' ),
					array( 'fa-light fa-folder-gear' => 'folder-gear' ),
					array( 'fa-light fa-folder-grid' => 'folder-grid' ),
					array( 'fa-light fa-folder-heart' => 'folder-heart' ),
					array( 'fa-light fa-folder-image' => 'folder-image' ),
					array( 'fa-light fa-folder-magnifying-glass' => 'folder-magnifying-glass' ),
					array( 'fa-light fa-folder-medical' => 'folder-medical' ),
					array( 'fa-light fa-folder-minus' => 'folder-minus' ),
					array( 'fa-light fa-folder-music' => 'folder-music' ),
					array( 'fa-light fa-folder-open' => 'folder-open' ),
					array( 'fa-light fa-folder-plus' => 'folder-plus' ),
					array( 'fa-light fa-folder-tree' => 'folder-tree' ),
					array( 'fa-light fa-folder-user' => 'folder-user' ),
					array( 'fa-light fa-folder-xmark' => 'folder-xmark' ),
					array( 'fa-light fa-folder' => 'folder' ),
					array( 'fa-light fa-folders' => 'folders' ),
					array( 'fa-light fa-fondue-pot' => 'fondue-pot' ),
					array( 'fa-light fa-font-awesome' => 'font-awesome' ),
					array( 'fa-light fa-font-case' => 'font-case' ),
					array( 'fa-light fa-font' => 'font' ),
					array( 'fa-light fa-football-helmet' => 'football-helmet' ),
					array( 'fa-light fa-football' => 'football' ),
					array( 'fa-light fa-fork-knife' => 'fork-knife' ),
					array( 'fa-light fa-fork' => 'fork' ),
					array( 'fa-light fa-forklift' => 'forklift' ),
					array( 'fa-light fa-fort' => 'fort' ),
					array( 'fa-light fa-forward-fast' => 'forward-fast' ),
					array( 'fa-light fa-forward-step' => 'forward-step' ),
					array( 'fa-light fa-forward' => 'forward' ),
					array( 'fa-light fa-frame' => 'frame' ),
					array( 'fa-light fa-franc-sign' => 'franc-sign' ),
					array( 'fa-light fa-french-fries' => 'french-fries' ),
					array( 'fa-light fa-frog' => 'frog' ),
					array( 'fa-light fa-function' => 'function' ),
					array( 'fa-light fa-futbol' => 'futbol' ),
					array( 'fa-light fa-g' => 'g' ),
					array( 'fa-light fa-galaxy' => 'galaxy' ),
					array( 'fa-light fa-gallery-thumbnails' => 'gallery-thumbnails' ),
					array( 'fa-light fa-game-board-simple' => 'game-board-simple' ),
					array( 'fa-light fa-game-board' => 'game-board' ),
					array( 'fa-light fa-game-console-handheld-crank' => 'game-console-handheld-crank' ),
					array( 'fa-light fa-game-console-handheld' => 'game-console-handheld' ),
					array( 'fa-light fa-gamepad-modern' => 'gamepad-modern' ),
					array( 'fa-light fa-gamepad' => 'gamepad' ),
					array( 'fa-light fa-garage-car' => 'garage-car' ),
					array( 'fa-light fa-garage-open' => 'garage-open' ),
					array( 'fa-light fa-garage' => 'garage' ),
					array( 'fa-light fa-garlic' => 'garlic' ),
					array( 'fa-light fa-gas-pump-slash' => 'gas-pump-slash' ),
					array( 'fa-light fa-gas-pump' => 'gas-pump' ),
					array( 'fa-light fa-gauge-circle-bolt' => 'gauge-circle-bolt' ),
					array( 'fa-light fa-gauge-circle-minus' => 'gauge-circle-minus' ),
					array( 'fa-light fa-gauge-circle-plus' => 'gauge-circle-plus' ),
					array( 'fa-light fa-gauge-high' => 'gauge-high' ),
					array( 'fa-light fa-gauge-low' => 'gauge-low' ),
					array( 'fa-light fa-gauge-max' => 'gauge-max' ),
					array( 'fa-light fa-gauge-min' => 'gauge-min' ),
					array( 'fa-light fa-gauge-simple-high' => 'gauge-simple-high' ),
					array( 'fa-light fa-gauge-simple-low' => 'gauge-simple-low' ),
					array( 'fa-light fa-gauge-simple-max' => 'gauge-simple-max' ),
					array( 'fa-light fa-gauge-simple-min' => 'gauge-simple-min' ),
					array( 'fa-light fa-gauge-simple' => 'gauge-simple' ),
					array( 'fa-light fa-gauge' => 'gauge' ),
					array( 'fa-light fa-gavel' => 'gavel' ),
					array( 'fa-light fa-gear-code' => 'gear-code' ),
					array( 'fa-light fa-gear-complex-code' => 'gear-complex-code' ),
					array( 'fa-light fa-gear-complex' => 'gear-complex' ),
					array( 'fa-light fa-gear' => 'gear' ),
					array( 'fa-light fa-gears' => 'gears' ),
					array( 'fa-light fa-gem' => 'gem' ),
					array( 'fa-light fa-genderless' => 'genderless' ),
					array( 'fa-light fa-ghost' => 'ghost' ),
					array( 'fa-light fa-gif' => 'gif' ),
					array( 'fa-light fa-gift-card' => 'gift-card' ),
					array( 'fa-light fa-gift' => 'gift' ),
					array( 'fa-light fa-gifts' => 'gifts' ),
					array( 'fa-light fa-gingerbread-man' => 'gingerbread-man' ),
					array( 'fa-light fa-glass-citrus' => 'glass-citrus' ),
					array( 'fa-light fa-glass-empty' => 'glass-empty' ),
					array( 'fa-light fa-glass-half' => 'glass-half' ),
					array( 'fa-light fa-glass-water-droplet' => 'glass-water-droplet' ),
					array( 'fa-light fa-glass-water' => 'glass-water' ),
					array( 'fa-light fa-glass' => 'glass' ),
					array( 'fa-light fa-glasses-round' => 'glasses-round' ),
					array( 'fa-light fa-glasses' => 'glasses' ),
					array( 'fa-light fa-globe-pointer' => 'globe-pointer' ),
					array( 'fa-light fa-globe-snow' => 'globe-snow' ),
					array( 'fa-light fa-globe-stand' => 'globe-stand' ),
					array( 'fa-light fa-globe' => 'globe' ),
					array( 'fa-light fa-goal-net' => 'goal-net' ),
					array( 'fa-light fa-golf-ball-tee' => 'golf-ball-tee' ),
					array( 'fa-light fa-golf-club' => 'golf-club' ),
					array( 'fa-light fa-golf-flag-hole' => 'golf-flag-hole' ),
					array( 'fa-light fa-gopuram' => 'gopuram' ),
					array( 'fa-light fa-graduation-cap' => 'graduation-cap' ),
					array( 'fa-light fa-gramophone' => 'gramophone' ),
					array( 'fa-light fa-grapes' => 'grapes' ),
					array( 'fa-light fa-grate-droplet' => 'grate-droplet' ),
					array( 'fa-light fa-grate' => 'grate' ),
					array( 'fa-light fa-greater-than-equal' => 'greater-than-equal' ),
					array( 'fa-light fa-greater-than' => 'greater-than' ),
					array( 'fa-light fa-grid-2-plus' => 'grid-2-plus' ),
					array( 'fa-light fa-grid-2' => 'grid-2' ),
					array( 'fa-light fa-grid-4' => 'grid-4' ),
					array( 'fa-light fa-grid-5' => 'grid-5' ),
					array( 'fa-light fa-grid-dividers' => 'grid-dividers' ),
					array( 'fa-light fa-grid-horizontal' => 'grid-horizontal' ),
					array( 'fa-light fa-grid-round-2-plus' => 'grid-round-2-plus' ),
					array( 'fa-light fa-grid-round-2' => 'grid-round-2' ),
					array( 'fa-light fa-grid-round-4' => 'grid-round-4' ),
					array( 'fa-light fa-grid-round-5' => 'grid-round-5' ),
					array( 'fa-light fa-grid-round' => 'grid-round' ),
					array( 'fa-light fa-grid' => 'grid' ),
					array( 'fa-light fa-grill-fire' => 'grill-fire' ),
					array( 'fa-light fa-grill-hot' => 'grill-hot' ),
					array( 'fa-light fa-grill' => 'grill' ),
					array( 'fa-light fa-grip-dots-vertical' => 'grip-dots-vertical' ),
					array( 'fa-light fa-grip-dots' => 'grip-dots' ),
					array( 'fa-light fa-grip-lines-vertical' => 'grip-lines-vertical' ),
					array( 'fa-light fa-grip-lines' => 'grip-lines' ),
					array( 'fa-light fa-grip-vertical' => 'grip-vertical' ),
					array( 'fa-light fa-grip' => 'grip' ),
					array( 'fa-light fa-group-arrows-rotate' => 'group-arrows-rotate' ),
					array( 'fa-light fa-guarani-sign' => 'guarani-sign' ),
					array( 'fa-light fa-guitar-electric' => 'guitar-electric' ),
					array( 'fa-light fa-guitar' => 'guitar' ),
					array( 'fa-light fa-guitars' => 'guitars' ),
					array( 'fa-light fa-gun-slash' => 'gun-slash' ),
					array( 'fa-light fa-gun-squirt' => 'gun-squirt' ),
					array( 'fa-light fa-gun' => 'gun' ),
					array( 'fa-light fa-h' => 'h' ),
					array( 'fa-light fa-h1' => 'h1' ),
					array( 'fa-light fa-h2' => 'h2' ),
					array( 'fa-light fa-h3' => 'h3' ),
					array( 'fa-light fa-h4' => 'h4' ),
					array( 'fa-light fa-h5' => 'h5' ),
					array( 'fa-light fa-h6' => 'h6' ),
					array( 'fa-light fa-hammer-crash' => 'hammer-crash' ),
					array( 'fa-light fa-hammer-war' => 'hammer-war' ),
					array( 'fa-light fa-hammer' => 'hammer' ),
					array( 'fa-light fa-hamsa' => 'hamsa' ),
					array( 'fa-light fa-hand-back-fist' => 'hand-back-fist' ),
					array( 'fa-light fa-hand-back-point-down' => 'hand-back-point-down' ),
					array( 'fa-light fa-hand-back-point-left' => 'hand-back-point-left' ),
					array( 'fa-light fa-hand-back-point-ribbon' => 'hand-back-point-ribbon' ),
					array( 'fa-light fa-hand-back-point-right' => 'hand-back-point-right' ),
					array( 'fa-light fa-hand-back-point-up' => 'hand-back-point-up' ),
					array( 'fa-light fa-hand-dots' => 'hand-dots' ),
					array( 'fa-light fa-hand-fingers-crossed' => 'hand-fingers-crossed' ),
					array( 'fa-light fa-hand-fist' => 'hand-fist' ),
					array( 'fa-light fa-hand-heart' => 'hand-heart' ),
					array( 'fa-light fa-hand-holding-box' => 'hand-holding-box' ),
					array( 'fa-light fa-hand-holding-dollar' => 'hand-holding-dollar' ),
					array( 'fa-light fa-hand-holding-droplet' => 'hand-holding-droplet' ),
					array( 'fa-light fa-hand-holding-hand' => 'hand-holding-hand' ),
					array( 'fa-light fa-hand-holding-heart' => 'hand-holding-heart' ),
					array( 'fa-light fa-hand-holding-magic' => 'hand-holding-magic' ),
					array( 'fa-light fa-hand-holding-medical' => 'hand-holding-medical' ),
					array( 'fa-light fa-hand-holding-seedling' => 'hand-holding-seedling' ),
					array( 'fa-light fa-hand-holding-skull' => 'hand-holding-skull' ),
					array( 'fa-light fa-hand-holding' => 'hand-holding' ),
					array( 'fa-light fa-hand-horns' => 'hand-horns' ),
					array( 'fa-light fa-hand-lizard' => 'hand-lizard' ),
					array( 'fa-light fa-hand-love' => 'hand-love' ),
					array( 'fa-light fa-hand-middle-finger' => 'hand-middle-finger' ),
					array( 'fa-light fa-hand-peace' => 'hand-peace' ),
					array( 'fa-light fa-hand-point-down' => 'hand-point-down' ),
					array( 'fa-light fa-hand-point-left' => 'hand-point-left' ),
					array( 'fa-light fa-hand-point-ribbon' => 'hand-point-ribbon' ),
					array( 'fa-light fa-hand-point-right' => 'hand-point-right' ),
					array( 'fa-light fa-hand-point-up' => 'hand-point-up' ),
					array( 'fa-light fa-hand-pointer' => 'hand-pointer' ),
					array( 'fa-light fa-hand-scissors' => 'hand-scissors' ),
					array( 'fa-light fa-hand-sparkles' => 'hand-sparkles' ),
					array( 'fa-light fa-hand-spock' => 'hand-spock' ),
					array( 'fa-light fa-hand-wave' => 'hand-wave' ),
					array( 'fa-light fa-hand' => 'hand' ),
					array( 'fa-light fa-handcuffs' => 'handcuffs' ),
					array( 'fa-light fa-hands-asl-interpreting' => 'hands-asl-interpreting' ),
					array( 'fa-light fa-hands-bound' => 'hands-bound' ),
					array( 'fa-light fa-hands-bubbles' => 'hands-bubbles' ),
					array( 'fa-light fa-hands-clapping' => 'hands-clapping' ),
					array( 'fa-light fa-hands-holding-child' => 'hands-holding-child' ),
					array( 'fa-light fa-hands-holding-circle' => 'hands-holding-circle' ),
					array( 'fa-light fa-hands-holding-diamond' => 'hands-holding-diamond' ),
					array( 'fa-light fa-hands-holding-dollar' => 'hands-holding-dollar' ),
					array( 'fa-light fa-hands-holding-heart' => 'hands-holding-heart' ),
					array( 'fa-light fa-hands-holding' => 'hands-holding' ),
					array( 'fa-light fa-hands-praying' => 'hands-praying' ),
					array( 'fa-light fa-hands' => 'hands' ),
					array( 'fa-light fa-handshake-angle' => 'handshake-angle' ),
					array( 'fa-light fa-handshake-simple-slash' => 'handshake-simple-slash' ),
					array( 'fa-light fa-handshake-simple' => 'handshake-simple' ),
					array( 'fa-light fa-handshake-slash' => 'handshake-slash' ),
					array( 'fa-light fa-handshake' => 'handshake' ),
					array( 'fa-light fa-hanukiah' => 'hanukiah' ),
					array( 'fa-light fa-hard-drive' => 'hard-drive' ),
					array( 'fa-light fa-hashtag-lock' => 'hashtag-lock' ),
					array( 'fa-light fa-hashtag' => 'hashtag' ),
					array( 'fa-light fa-hat-beach' => 'hat-beach' ),
					array( 'fa-light fa-hat-chef' => 'hat-chef' ),
					array( 'fa-light fa-hat-cowboy-side' => 'hat-cowboy-side' ),
					array( 'fa-light fa-hat-cowboy' => 'hat-cowboy' ),
					array( 'fa-light fa-hat-santa' => 'hat-santa' ),
					array( 'fa-light fa-hat-winter' => 'hat-winter' ),
					array( 'fa-light fa-hat-witch' => 'hat-witch' ),
					array( 'fa-light fa-hat-wizard' => 'hat-wizard' ),
					array( 'fa-light fa-head-side-brain' => 'head-side-brain' ),
					array( 'fa-light fa-head-side-cough-slash' => 'head-side-cough-slash' ),
					array( 'fa-light fa-head-side-cough' => 'head-side-cough' ),
					array( 'fa-light fa-head-side-gear' => 'head-side-gear' ),
					array( 'fa-light fa-head-side-goggles' => 'head-side-goggles' ),
					array( 'fa-light fa-head-side-headphones' => 'head-side-headphones' ),
					array( 'fa-light fa-head-side-heart' => 'head-side-heart' ),
					array( 'fa-light fa-head-side-mask' => 'head-side-mask' ),
					array( 'fa-light fa-head-side-medical' => 'head-side-medical' ),
					array( 'fa-light fa-head-side-virus' => 'head-side-virus' ),
					array( 'fa-light fa-head-side' => 'head-side' ),
					array( 'fa-light fa-heading' => 'heading' ),
					array( 'fa-light fa-headphones-simple' => 'headphones-simple' ),
					array( 'fa-light fa-headphones' => 'headphones' ),
					array( 'fa-light fa-headset' => 'headset' ),
					array( 'fa-light fa-heart-circle-bolt' => 'heart-circle-bolt' ),
					array( 'fa-light fa-heart-circle-check' => 'heart-circle-check' ),
					array( 'fa-light fa-heart-circle-exclamation' => 'heart-circle-exclamation' ),
					array( 'fa-light fa-heart-circle-minus' => 'heart-circle-minus' ),
					array( 'fa-light fa-heart-circle-plus' => 'heart-circle-plus' ),
					array( 'fa-light fa-heart-circle-xmark' => 'heart-circle-xmark' ),
					array( 'fa-light fa-heart-crack' => 'heart-crack' ),
					array( 'fa-light fa-heart-half-stroke' => 'heart-half-stroke' ),
					array( 'fa-light fa-heart-half' => 'heart-half' ),
					array( 'fa-light fa-heart-pulse' => 'heart-pulse' ),
					array( 'fa-light fa-heart' => 'heart' ),
					array( 'fa-light fa-heat' => 'heat' ),
					array( 'fa-light fa-helicopter-symbol' => 'helicopter-symbol' ),
					array( 'fa-light fa-helicopter' => 'helicopter' ),
					array( 'fa-light fa-helmet-battle' => 'helmet-battle' ),
					array( 'fa-light fa-helmet-safety' => 'helmet-safety' ),
					array( 'fa-light fa-helmet-un' => 'helmet-un' ),
					array( 'fa-light fa-hexagon-check' => 'hexagon-check' ),
					array( 'fa-light fa-hexagon-divide' => 'hexagon-divide' ),
					array( 'fa-light fa-hexagon-exclamation' => 'hexagon-exclamation' ),
					array( 'fa-light fa-hexagon-image' => 'hexagon-image' ),
					array( 'fa-light fa-hexagon-minus' => 'hexagon-minus' ),
					array( 'fa-light fa-hexagon-plus' => 'hexagon-plus' ),
					array( 'fa-light fa-hexagon-vertical-nft-slanted' => 'hexagon-vertical-nft-slanted' ),
					array( 'fa-light fa-hexagon-vertical-nft' => 'hexagon-vertical-nft' ),
					array( 'fa-light fa-hexagon-xmark' => 'hexagon-xmark' ),
					array( 'fa-light fa-hexagon' => 'hexagon' ),
					array( 'fa-light fa-high-definition' => 'high-definition' ),
					array( 'fa-light fa-highlighter-line' => 'highlighter-line' ),
					array( 'fa-light fa-highlighter' => 'highlighter' ),
					array( 'fa-light fa-hill-avalanche' => 'hill-avalanche' ),
					array( 'fa-light fa-hill-rockslide' => 'hill-rockslide' ),
					array( 'fa-light fa-hippo' => 'hippo' ),
					array( 'fa-light fa-hockey-mask' => 'hockey-mask' ),
					array( 'fa-light fa-hockey-puck' => 'hockey-puck' ),
					array( 'fa-light fa-hockey-stick-puck' => 'hockey-stick-puck' ),
					array( 'fa-light fa-hockey-sticks' => 'hockey-sticks' ),
					array( 'fa-light fa-holly-berry' => 'holly-berry' ),
					array( 'fa-light fa-honey-pot' => 'honey-pot' ),
					array( 'fa-light fa-hood-cloak' => 'hood-cloak' ),
					array( 'fa-light fa-horizontal-rule' => 'horizontal-rule' ),
					array( 'fa-light fa-horse-head' => 'horse-head' ),
					array( 'fa-light fa-horse-saddle' => 'horse-saddle' ),
					array( 'fa-light fa-horse' => 'horse' ),
					array( 'fa-light fa-hose-reel' => 'hose-reel' ),
					array( 'fa-light fa-hose' => 'hose' ),
					array( 'fa-light fa-hospital-user' => 'hospital-user' ),
					array( 'fa-light fa-hospital' => 'hospital' ),
					array( 'fa-light fa-hospitals' => 'hospitals' ),
					array( 'fa-light fa-hot-tub-person' => 'hot-tub-person' ),
					array( 'fa-light fa-hotdog' => 'hotdog' ),
					array( 'fa-light fa-hotel' => 'hotel' ),
					array( 'fa-light fa-hourglass-clock' => 'hourglass-clock' ),
					array( 'fa-light fa-hourglass-end' => 'hourglass-end' ),
					array( 'fa-light fa-hourglass-half' => 'hourglass-half' ),
					array( 'fa-light fa-hourglass-start' => 'hourglass-start' ),
					array( 'fa-light fa-hourglass' => 'hourglass' ),
					array( 'fa-light fa-house-blank' => 'house-blank' ),
					array( 'fa-light fa-house-building' => 'house-building' ),
					array( 'fa-light fa-house-chimney-blank' => 'house-chimney-blank' ),
					array( 'fa-light fa-house-chimney-crack' => 'house-chimney-crack' ),
					array( 'fa-light fa-house-chimney-heart' => 'house-chimney-heart' ),
					array( 'fa-light fa-house-chimney-medical' => 'house-chimney-medical' ),
					array( 'fa-light fa-house-chimney-user' => 'house-chimney-user' ),
					array( 'fa-light fa-house-chimney-window' => 'house-chimney-window' ),
					array( 'fa-light fa-house-chimney' => 'house-chimney' ),
					array( 'fa-light fa-house-circle-check' => 'house-circle-check' ),
					array( 'fa-light fa-house-circle-exclamation' => 'house-circle-exclamation' ),
					array( 'fa-light fa-house-circle-xmark' => 'house-circle-xmark' ),
					array( 'fa-light fa-house-crack' => 'house-crack' ),
					array( 'fa-light fa-house-day' => 'house-day' ),
					array( 'fa-light fa-house-fire' => 'house-fire' ),
					array( 'fa-light fa-house-flag' => 'house-flag' ),
					array( 'fa-light fa-house-flood-water-circle-arrow-right' => 'house-flood-water-circle-arrow-right' ),
					array( 'fa-light fa-house-flood-water' => 'house-flood-water' ),
					array( 'fa-light fa-house-heart' => 'house-heart' ),
					array( 'fa-light fa-house-laptop' => 'house-laptop' ),
					array( 'fa-light fa-house-lock' => 'house-lock' ),
					array( 'fa-light fa-house-medical-circle-check' => 'house-medical-circle-check' ),
					array( 'fa-light fa-house-medical-circle-exclamation' => 'house-medical-circle-exclamation' ),
					array( 'fa-light fa-house-medical-circle-xmark' => 'house-medical-circle-xmark' ),
					array( 'fa-light fa-house-medical-flag' => 'house-medical-flag' ),
					array( 'fa-light fa-house-medical' => 'house-medical' ),
					array( 'fa-light fa-house-night' => 'house-night' ),
					array( 'fa-light fa-house-person-leave' => 'house-person-leave' ),
					array( 'fa-light fa-house-person-return' => 'house-person-return' ),
					array( 'fa-light fa-house-signal' => 'house-signal' ),
					array( 'fa-light fa-house-tree' => 'house-tree' ),
					array( 'fa-light fa-house-tsunami' => 'house-tsunami' ),
					array( 'fa-light fa-house-turret' => 'house-turret' ),
					array( 'fa-light fa-house-user' => 'house-user' ),
					array( 'fa-light fa-house-water' => 'house-water' ),
					array( 'fa-light fa-house-window' => 'house-window' ),
					array( 'fa-light fa-house' => 'house' ),
					array( 'fa-light fa-hryvnia-sign' => 'hryvnia-sign' ),
					array( 'fa-light fa-hundred-points' => 'hundred-points' ),
					array( 'fa-light fa-hurricane' => 'hurricane' ),
					array( 'fa-light fa-hyphen' => 'hyphen' ),
					array( 'fa-light fa-i-cursor' => 'i-cursor' ),
					array( 'fa-light fa-i' => 'i' ),
					array( 'fa-light fa-ice-cream' => 'ice-cream' ),
					array( 'fa-light fa-ice-skate' => 'ice-skate' ),
					array( 'fa-light fa-icicles' => 'icicles' ),
					array( 'fa-light fa-icons' => 'icons' ),
					array( 'fa-light fa-id-badge' => 'id-badge' ),
					array( 'fa-light fa-id-card-clip' => 'id-card-clip' ),
					array( 'fa-light fa-id-card' => 'id-card' ),
					array( 'fa-light fa-igloo' => 'igloo' ),
					array( 'fa-light fa-image-landscape' => 'image-landscape' ),
					array( 'fa-light fa-image-polaroid-user' => 'image-polaroid-user' ),
					array( 'fa-light fa-image-polaroid' => 'image-polaroid' ),
					array( 'fa-light fa-image-portrait' => 'image-portrait' ),
					array( 'fa-light fa-image-slash' => 'image-slash' ),
					array( 'fa-light fa-image-user' => 'image-user' ),
					array( 'fa-light fa-image' => 'image' ),
					array( 'fa-light fa-images-user' => 'images-user' ),
					array( 'fa-light fa-images' => 'images' ),
					array( 'fa-light fa-inbox-full' => 'inbox-full' ),
					array( 'fa-light fa-inbox-in' => 'inbox-in' ),
					array( 'fa-light fa-inbox-out' => 'inbox-out' ),
					array( 'fa-light fa-inbox' => 'inbox' ),
					array( 'fa-light fa-inboxes' => 'inboxes' ),
					array( 'fa-light fa-indent' => 'indent' ),
					array( 'fa-light fa-indian-rupee-sign' => 'indian-rupee-sign' ),
					array( 'fa-light fa-industry-windows' => 'industry-windows' ),
					array( 'fa-light fa-industry' => 'industry' ),
					array( 'fa-light fa-infinity' => 'infinity' ),
					array( 'fa-light fa-info' => 'info' ),
					array( 'fa-light fa-inhaler' => 'inhaler' ),
					array( 'fa-light fa-input-numeric' => 'input-numeric' ),
					array( 'fa-light fa-input-pipe' => 'input-pipe' ),
					array( 'fa-light fa-input-text' => 'input-text' ),
					array( 'fa-light fa-integral' => 'integral' ),
					array( 'fa-light fa-interrobang' => 'interrobang' ),
					array( 'fa-light fa-intersection' => 'intersection' ),
					array( 'fa-light fa-island-tropical' => 'island-tropical' ),
					array( 'fa-light fa-italic' => 'italic' ),
					array( 'fa-light fa-j' => 'j' ),
					array( 'fa-light fa-jack-o-lantern' => 'jack-o-lantern' ),
					array( 'fa-light fa-jar-wheat' => 'jar-wheat' ),
					array( 'fa-light fa-jar' => 'jar' ),
					array( 'fa-light fa-jedi' => 'jedi' ),
					array( 'fa-light fa-jet-fighter-up' => 'jet-fighter-up' ),
					array( 'fa-light fa-jet-fighter' => 'jet-fighter' ),
					array( 'fa-light fa-joint' => 'joint' ),
					array( 'fa-light fa-joystick' => 'joystick' ),
					array( 'fa-light fa-jug-bottle' => 'jug-bottle' ),
					array( 'fa-light fa-jug-detergent' => 'jug-detergent' ),
					array( 'fa-light fa-jug' => 'jug' ),
					array( 'fa-light fa-k' => 'k' ),
					array( 'fa-light fa-kaaba' => 'kaaba' ),
					array( 'fa-light fa-kazoo' => 'kazoo' ),
					array( 'fa-light fa-kerning' => 'kerning' ),
					array( 'fa-light fa-key-skeleton-left-right' => 'key-skeleton-left-right' ),
					array( 'fa-light fa-key-skeleton' => 'key-skeleton' ),
					array( 'fa-light fa-key' => 'key' ),
					array( 'fa-light fa-keyboard-brightness-low' => 'keyboard-brightness-low' ),
					array( 'fa-light fa-keyboard-brightness' => 'keyboard-brightness' ),
					array( 'fa-light fa-keyboard-down' => 'keyboard-down' ),
					array( 'fa-light fa-keyboard-left' => 'keyboard-left' ),
					array( 'fa-light fa-keyboard' => 'keyboard' ),
					array( 'fa-light fa-keynote' => 'keynote' ),
					array( 'fa-light fa-khanda' => 'khanda' ),
					array( 'fa-light fa-kidneys' => 'kidneys' ),
					array( 'fa-light fa-kip-sign' => 'kip-sign' ),
					array( 'fa-light fa-kit-medical' => 'kit-medical' ),
					array( 'fa-light fa-kitchen-set' => 'kitchen-set' ),
					array( 'fa-light fa-kite' => 'kite' ),
					array( 'fa-light fa-kiwi-bird' => 'kiwi-bird' ),
					array( 'fa-light fa-kiwi-fruit' => 'kiwi-fruit' ),
					array( 'fa-light fa-knife-kitchen' => 'knife-kitchen' ),
					array( 'fa-light fa-knife' => 'knife' ),
					array( 'fa-light fa-l' => 'l' ),
					array( 'fa-light fa-lacrosse-stick-ball' => 'lacrosse-stick-ball' ),
					array( 'fa-light fa-lacrosse-stick' => 'lacrosse-stick' ),
					array( 'fa-light fa-lambda' => 'lambda' ),
					array( 'fa-light fa-lamp-desk' => 'lamp-desk' ),
					array( 'fa-light fa-lamp-floor' => 'lamp-floor' ),
					array( 'fa-light fa-lamp-street' => 'lamp-street' ),
					array( 'fa-light fa-lamp' => 'lamp' ),
					array( 'fa-light fa-land-mine-on' => 'land-mine-on' ),
					array( 'fa-light fa-landmark-dome' => 'landmark-dome' ),
					array( 'fa-light fa-landmark-flag' => 'landmark-flag' ),
					array( 'fa-light fa-landmark' => 'landmark' ),
					array( 'fa-light fa-language' => 'language' ),
					array( 'fa-light fa-laptop-arrow-down' => 'laptop-arrow-down' ),
					array( 'fa-light fa-laptop-binary' => 'laptop-binary' ),
					array( 'fa-light fa-laptop-code' => 'laptop-code' ),
					array( 'fa-light fa-laptop-file' => 'laptop-file' ),
					array( 'fa-light fa-laptop-medical' => 'laptop-medical' ),
					array( 'fa-light fa-laptop-mobile' => 'laptop-mobile' ),
					array( 'fa-light fa-laptop-slash' => 'laptop-slash' ),
					array( 'fa-light fa-laptop' => 'laptop' ),
					array( 'fa-light fa-lari-sign' => 'lari-sign' ),
					array( 'fa-light fa-lasso-sparkles' => 'lasso-sparkles' ),
					array( 'fa-light fa-lasso' => 'lasso' ),
					array( 'fa-light fa-layer-group' => 'layer-group' ),
					array( 'fa-light fa-layer-minus' => 'layer-minus' ),
					array( 'fa-light fa-layer-plus' => 'layer-plus' ),
					array( 'fa-light fa-leaf-heart' => 'leaf-heart' ),
					array( 'fa-light fa-leaf-maple' => 'leaf-maple' ),
					array( 'fa-light fa-leaf-oak' => 'leaf-oak' ),
					array( 'fa-light fa-leaf' => 'leaf' ),
					array( 'fa-light fa-leafy-green' => 'leafy-green' ),
					array( 'fa-light fa-left-from-line' => 'left-from-line' ),
					array( 'fa-light fa-left-long-to-line' => 'left-long-to-line' ),
					array( 'fa-light fa-left-long' => 'left-long' ),
					array( 'fa-light fa-left-right' => 'left-right' ),
					array( 'fa-light fa-left-to-line' => 'left-to-line' ),
					array( 'fa-light fa-left' => 'left' ),
					array( 'fa-light fa-lemon' => 'lemon' ),
					array( 'fa-light fa-less-than-equal' => 'less-than-equal' ),
					array( 'fa-light fa-less-than' => 'less-than' ),
					array( 'fa-light fa-life-ring' => 'life-ring' ),
					array( 'fa-light fa-light-ceiling' => 'light-ceiling' ),
					array( 'fa-light fa-light-emergency-on' => 'light-emergency-on' ),
					array( 'fa-light fa-light-emergency' => 'light-emergency' ),
					array( 'fa-light fa-light-switch-off' => 'light-switch-off' ),
					array( 'fa-light fa-light-switch-on' => 'light-switch-on' ),
					array( 'fa-light fa-light-switch' => 'light-switch' ),
					array( 'fa-light fa-lightbulb-cfl-on' => 'lightbulb-cfl-on' ),
					array( 'fa-light fa-lightbulb-cfl' => 'lightbulb-cfl' ),
					array( 'fa-light fa-lightbulb-dollar' => 'lightbulb-dollar' ),
					array( 'fa-light fa-lightbulb-exclamatin-on' => 'lightbulb-exclamatin-on' ),
					array( 'fa-light fa-lightbulb-exclamation' => 'lightbulb-exclamation' ),
					array( 'fa-light fa-lightbulb-gear' => 'lightbulb-gear' ),
					array( 'fa-light fa-lightbulb-on' => 'lightbulb-on' ),
					array( 'fa-light fa-lightbulb-slash' => 'lightbulb-slash' ),
					array( 'fa-light fa-lightbulb' => 'lightbulb' ),
					array( 'fa-light fa-lighthouse' => 'lighthouse' ),
					array( 'fa-light fa-lights-holiday' => 'lights-holiday' ),
					array( 'fa-light fa-line-columns' => 'line-columns' ),
					array( 'fa-light fa-line-height' => 'line-height' ),
					array( 'fa-light fa-lines-leaning' => 'lines-leaning' ),
					array( 'fa-light fa-link-horizontal-slash' => 'link-horizontal-slash' ),
					array( 'fa-light fa-link-horizontal' => 'link-horizontal' ),
					array( 'fa-light fa-link-simple-slash' => 'link-simple-slash' ),
					array( 'fa-light fa-link-simple' => 'link-simple' ),
					array( 'fa-light fa-link-slash' => 'link-slash' ),
					array( 'fa-light fa-link' => 'link' ),
					array( 'fa-light fa-lips' => 'lips' ),
					array( 'fa-light fa-lira-sign' => 'lira-sign' ),
					array( 'fa-light fa-list-check' => 'list-check' ),
					array( 'fa-light fa-list-dropdown' => 'list-dropdown' ),
					array( 'fa-light fa-list-music' => 'list-music' ),
					array( 'fa-light fa-list-ol' => 'list-ol' ),
					array( 'fa-light fa-list-radio' => 'list-radio' ),
					array( 'fa-light fa-list-timeline' => 'list-timeline' ),
					array( 'fa-light fa-list-tree' => 'list-tree' ),
					array( 'fa-light fa-list-ul' => 'list-ul' ),
					array( 'fa-light fa-list' => 'list' ),
					array( 'fa-light fa-litecoin-sign' => 'litecoin-sign' ),
					array( 'fa-light fa-loader' => 'loader' ),
					array( 'fa-light fa-lobster' => 'lobster' ),
					array( 'fa-light fa-location-arrow' => 'location-arrow' ),
					array( 'fa-light fa-location-check' => 'location-check' ),
					array( 'fa-light fa-location-crosshairs-slash' => 'location-crosshairs-slash' ),
					array( 'fa-light fa-location-crosshairs' => 'location-crosshairs' ),
					array( 'fa-light fa-location-dot-slash' => 'location-dot-slash' ),
					array( 'fa-light fa-location-dot' => 'location-dot' ),
					array( 'fa-light fa-location-exclamation' => 'location-exclamation' ),
					array( 'fa-light fa-location-minus' => 'location-minus' ),
					array( 'fa-light fa-location-pen' => 'location-pen' ),
					array( 'fa-light fa-location-pin-lock' => 'location-pin-lock' ),
					array( 'fa-light fa-location-pin-slash' => 'location-pin-slash' ),
					array( 'fa-light fa-location-pin' => 'location-pin' ),
					array( 'fa-light fa-location-plus' => 'location-plus' ),
					array( 'fa-light fa-location-question' => 'location-question' ),
					array( 'fa-light fa-location-smile' => 'location-smile' ),
					array( 'fa-light fa-location-xmark' => 'location-xmark' ),
					array( 'fa-light fa-lock-a' => 'lock-a' ),
					array( 'fa-light fa-lock-hashtag' => 'lock-hashtag' ),
					array( 'fa-light fa-lock-keyhole-open' => 'lock-keyhole-open' ),
					array( 'fa-light fa-lock-keyhole' => 'lock-keyhole' ),
					array( 'fa-light fa-lock-open' => 'lock-open' ),
					array( 'fa-light fa-lock' => 'lock' ),
					array( 'fa-light fa-locust' => 'locust' ),
					array( 'fa-light fa-lollipop' => 'lollipop' ),
					array( 'fa-light fa-loveseat' => 'loveseat' ),
					array( 'fa-light fa-luchador-mask' => 'luchador-mask' ),
					array( 'fa-light fa-lungs-virus' => 'lungs-virus' ),
					array( 'fa-light fa-lungs' => 'lungs' ),
					array( 'fa-light fa-m' => 'm' ),
					array( 'fa-light fa-mace' => 'mace' ),
					array( 'fa-light fa-magnet' => 'magnet' ),
					array( 'fa-light fa-magnifying-glass-arrow-right' => 'magnifying-glass-arrow-right' ),
					array( 'fa-light fa-magnifying-glass-chart' => 'magnifying-glass-chart' ),
					array( 'fa-light fa-magnifying-glass-dollar' => 'magnifying-glass-dollar' ),
					array( 'fa-light fa-magnifying-glass-location' => 'magnifying-glass-location' ),
					array( 'fa-light fa-magnifying-glass-minus' => 'magnifying-glass-minus' ),
					array( 'fa-light fa-magnifying-glass-plus' => 'magnifying-glass-plus' ),
					array( 'fa-light fa-magnifying-glass' => 'magnifying-glass' ),
					array( 'fa-light fa-mailbox-flag-up' => 'mailbox-flag-up' ),
					array( 'fa-light fa-mailbox' => 'mailbox' ),
					array( 'fa-light fa-manat-sign' => 'manat-sign' ),
					array( 'fa-light fa-mandolin' => 'mandolin' ),
					array( 'fa-light fa-mango' => 'mango' ),
					array( 'fa-light fa-manhole' => 'manhole' ),
					array( 'fa-light fa-map-location-dot' => 'map-location-dot' ),
					array( 'fa-light fa-map-location' => 'map-location' ),
					array( 'fa-light fa-map-pin' => 'map-pin' ),
					array( 'fa-light fa-map' => 'map' ),
					array( 'fa-light fa-marker' => 'marker' ),
					array( 'fa-light fa-mars-and-venus-burst' => 'mars-and-venus-burst' ),
					array( 'fa-light fa-mars-and-venus' => 'mars-and-venus' ),
					array( 'fa-light fa-mars-double' => 'mars-double' ),
					array( 'fa-light fa-mars-stroke-right' => 'mars-stroke-right' ),
					array( 'fa-light fa-mars-stroke-up' => 'mars-stroke-up' ),
					array( 'fa-light fa-mars-stroke' => 'mars-stroke' ),
					array( 'fa-light fa-mars' => 'mars' ),
					array( 'fa-light fa-martini-glass-citrus' => 'martini-glass-citrus' ),
					array( 'fa-light fa-martini-glass-empty' => 'martini-glass-empty' ),
					array( 'fa-light fa-martini-glass' => 'martini-glass' ),
					array( 'fa-light fa-mask-face' => 'mask-face' ),
					array( 'fa-light fa-mask-snorkel' => 'mask-snorkel' ),
					array( 'fa-light fa-mask-ventilator' => 'mask-ventilator' ),
					array( 'fa-light fa-mask' => 'mask' ),
					array( 'fa-light fa-masks-theater' => 'masks-theater' ),
					array( 'fa-light fa-mattress-pillow' => 'mattress-pillow' ),
					array( 'fa-light fa-maximize' => 'maximize' ),
					array( 'fa-light fa-meat' => 'meat' ),
					array( 'fa-light fa-medal' => 'medal' ),
					array( 'fa-light fa-megaphone' => 'megaphone' ),
					array( 'fa-light fa-melon-slice' => 'melon-slice' ),
					array( 'fa-light fa-melon' => 'melon' ),
					array( 'fa-light fa-memo-circle-check' => 'memo-circle-check' ),
					array( 'fa-light fa-memo-circle-info' => 'memo-circle-info' ),
					array( 'fa-light fa-memo-pad' => 'memo-pad' ),
					array( 'fa-light fa-memo' => 'memo' ),
					array( 'fa-light fa-memory' => 'memory' ),
					array( 'fa-light fa-menorah' => 'menorah' ),
					array( 'fa-light fa-mercury' => 'mercury' ),
					array( 'fa-light fa-merge' => 'merge' ),
					array( 'fa-light fa-message-arrow-down' => 'message-arrow-down' ),
					array( 'fa-light fa-message-arrow-up-right' => 'message-arrow-up-right' ),
					array( 'fa-light fa-message-arrow-up' => 'message-arrow-up' ),
					array( 'fa-light fa-message-bot' => 'message-bot' ),
					array( 'fa-light fa-message-captions' => 'message-captions' ),
					array( 'fa-light fa-message-check' => 'message-check' ),
					array( 'fa-light fa-message-code' => 'message-code' ),
					array( 'fa-light fa-message-dollar' => 'message-dollar' ),
					array( 'fa-light fa-message-dots' => 'message-dots' ),
					array( 'fa-light fa-message-exclamation' => 'message-exclamation' ),
					array( 'fa-light fa-message-heart' => 'message-heart' ),
					array( 'fa-light fa-message-image' => 'message-image' ),
					array( 'fa-light fa-message-lines' => 'message-lines' ),
					array( 'fa-light fa-message-medical' => 'message-medical' ),
					array( 'fa-light fa-message-middle-top' => 'message-middle-top' ),
					array( 'fa-light fa-message-middle' => 'message-middle' ),
					array( 'fa-light fa-message-minus' => 'message-minus' ),
					array( 'fa-light fa-message-music' => 'message-music' ),
					array( 'fa-light fa-message-pen' => 'message-pen' ),
					array( 'fa-light fa-message-plus' => 'message-plus' ),
					array( 'fa-light fa-message-question' => 'message-question' ),
					array( 'fa-light fa-message-quote' => 'message-quote' ),
					array( 'fa-light fa-message-slash' => 'message-slash' ),
					array( 'fa-light fa-message-smile' => 'message-smile' ),
					array( 'fa-light fa-message-sms' => 'message-sms' ),
					array( 'fa-light fa-message-text' => 'message-text' ),
					array( 'fa-light fa-message-xmark' => 'message-xmark' ),
					array( 'fa-light fa-message' => 'message' ),
					array( 'fa-light fa-messages-dollar' => 'messages-dollar' ),
					array( 'fa-light fa-messages-question' => 'messages-question' ),
					array( 'fa-light fa-messages' => 'messages' ),
					array( 'fa-light fa-meteor' => 'meteor' ),
					array( 'fa-light fa-meter-bolt' => 'meter-bolt' ),
					array( 'fa-light fa-meter-droplet' => 'meter-droplet' ),
					array( 'fa-light fa-meter-fire' => 'meter-fire' ),
					array( 'fa-light fa-meter' => 'meter' ),
					array( 'fa-light fa-microchip-ai' => 'microchip-ai' ),
					array( 'fa-light fa-microchip' => 'microchip' ),
					array( 'fa-light fa-microphone-lines-slash' => 'microphone-lines-slash' ),
					array( 'fa-light fa-microphone-lines' => 'microphone-lines' ),
					array( 'fa-light fa-microphone-slash' => 'microphone-slash' ),
					array( 'fa-light fa-microphone-stand' => 'microphone-stand' ),
					array( 'fa-light fa-microphone' => 'microphone' ),
					array( 'fa-light fa-microscope' => 'microscope' ),
					array( 'fa-light fa-microwave' => 'microwave' ),
					array( 'fa-light fa-mill-sign' => 'mill-sign' ),
					array( 'fa-light fa-minimize' => 'minimize' ),
					array( 'fa-light fa-minus' => 'minus' ),
					array( 'fa-light fa-mistletoe' => 'mistletoe' ),
					array( 'fa-light fa-mitten' => 'mitten' ),
					array( 'fa-light fa-mobile-button' => 'mobile-button' ),
					array( 'fa-light fa-mobile-notch' => 'mobile-notch' ),
					array( 'fa-light fa-mobile-retro' => 'mobile-retro' ),
					array( 'fa-light fa-mobile-screen-button' => 'mobile-screen-button' ),
					array( 'fa-light fa-mobile-screen' => 'mobile-screen' ),
					array( 'fa-light fa-mobile-signal-out' => 'mobile-signal-out' ),
					array( 'fa-light fa-mobile-signal' => 'mobile-signal' ),
					array( 'fa-light fa-mobile' => 'mobile' ),
					array( 'fa-light fa-money-bill-1-wave' => 'money-bill-1-wave' ),
					array( 'fa-light fa-money-bill-1' => 'money-bill-1' ),
					array( 'fa-light fa-money-bill-simple-wave' => 'money-bill-simple-wave' ),
					array( 'fa-light fa-money-bill-simple' => 'money-bill-simple' ),
					array( 'fa-light fa-money-bill-transfer' => 'money-bill-transfer' ),
					array( 'fa-light fa-money-bill-trend-up' => 'money-bill-trend-up' ),
					array( 'fa-light fa-money-bill-wave' => 'money-bill-wave' ),
					array( 'fa-light fa-money-bill-wheat' => 'money-bill-wheat' ),
					array( 'fa-light fa-money-bill' => 'money-bill' ),
					array( 'fa-light fa-money-bills-simple' => 'money-bills-simple' ),
					array( 'fa-light fa-money-bills' => 'money-bills' ),
					array( 'fa-light fa-money-check-dollar-pen' => 'money-check-dollar-pen' ),
					array( 'fa-light fa-money-check-dollar' => 'money-check-dollar' ),
					array( 'fa-light fa-money-check-pen' => 'money-check-pen' ),
					array( 'fa-light fa-money-check' => 'money-check' ),
					array( 'fa-light fa-money-from-bracket' => 'money-from-bracket' ),
					array( 'fa-light fa-money-simple-from-bracket' => 'money-simple-from-bracket' ),
					array( 'fa-light fa-monitor-waveform' => 'monitor-waveform' ),
					array( 'fa-light fa-monkey' => 'monkey' ),
					array( 'fa-light fa-monument' => 'monument' ),
					array( 'fa-light fa-moon-cloud' => 'moon-cloud' ),
					array( 'fa-light fa-moon-over-sun' => 'moon-over-sun' ),
					array( 'fa-light fa-moon-stars' => 'moon-stars' ),
					array( 'fa-light fa-moon' => 'moon' ),
					array( 'fa-light fa-moped' => 'moped' ),
					array( 'fa-light fa-mortar-pestle' => 'mortar-pestle' ),
					array( 'fa-light fa-mosque' => 'mosque' ),
					array( 'fa-light fa-mosquito-net' => 'mosquito-net' ),
					array( 'fa-light fa-mosquito' => 'mosquito' ),
					array( 'fa-light fa-motorcycle' => 'motorcycle' ),
					array( 'fa-light fa-mound' => 'mound' ),
					array( 'fa-light fa-mountain-city' => 'mountain-city' ),
					array( 'fa-light fa-mountain-sun' => 'mountain-sun' ),
					array( 'fa-light fa-mountain' => 'mountain' ),
					array( 'fa-light fa-mountains' => 'mountains' ),
					array( 'fa-light fa-mouse-field' => 'mouse-field' ),
					array( 'fa-light fa-mp3-player' => 'mp3-player' ),
					array( 'fa-light fa-mug-hot' => 'mug-hot' ),
					array( 'fa-light fa-mug-marshmallows' => 'mug-marshmallows' ),
					array( 'fa-light fa-mug-saucer' => 'mug-saucer' ),
					array( 'fa-light fa-mug-tea-saucer' => 'mug-tea-saucer' ),
					array( 'fa-light fa-mug-tea' => 'mug-tea' ),
					array( 'fa-light fa-mug' => 'mug' ),
					array( 'fa-light fa-mushroom' => 'mushroom' ),
					array( 'fa-light fa-music-note-slash' => 'music-note-slash' ),
					array( 'fa-light fa-music-note' => 'music-note' ),
					array( 'fa-light fa-music-slash' => 'music-slash' ),
					array( 'fa-light fa-music' => 'music' ),
					array( 'fa-light fa-mustache' => 'mustache' ),
					array( 'fa-light fa-n' => 'n' ),
					array( 'fa-light fa-naira-sign' => 'naira-sign' ),
					array( 'fa-light fa-narwhal' => 'narwhal' ),
					array( 'fa-light fa-nesting-dolls' => 'nesting-dolls' ),
					array( 'fa-light fa-network-wired' => 'network-wired' ),
					array( 'fa-light fa-neuter' => 'neuter' ),
					array( 'fa-light fa-newspaper' => 'newspaper' ),
					array( 'fa-light fa-nfc-lock' => 'nfc-lock' ),
					array( 'fa-light fa-nfc-magnifying-glass' => 'nfc-magnifying-glass' ),
					array( 'fa-light fa-nfc-pen' => 'nfc-pen' ),
					array( 'fa-light fa-nfc-signal' => 'nfc-signal' ),
					array( 'fa-light fa-nfc-slash' => 'nfc-slash' ),
					array( 'fa-light fa-nfc-symbol' => 'nfc-symbol' ),
					array( 'fa-light fa-nfc-trash' => 'nfc-trash' ),
					array( 'fa-light fa-nfc' => 'nfc' ),
					array( 'fa-light fa-nose' => 'nose' ),
					array( 'fa-light fa-not-equal' => 'not-equal' ),
					array( 'fa-light fa-notdef' => 'notdef' ),
					array( 'fa-light fa-note-medical' => 'note-medical' ),
					array( 'fa-light fa-note-sticky' => 'note-sticky' ),
					array( 'fa-light fa-note' => 'note' ),
					array( 'fa-light fa-notebook' => 'notebook' ),
					array( 'fa-light fa-notes-medical' => 'notes-medical' ),
					array( 'fa-light fa-notes' => 'notes' ),
					array( 'fa-light fa-o' => 'o' ),
					array( 'fa-light fa-object-exclude' => 'object-exclude' ),
					array( 'fa-light fa-object-group' => 'object-group' ),
					array( 'fa-light fa-object-intersect' => 'object-intersect' ),
					array( 'fa-light fa-object-subtract' => 'object-subtract' ),
					array( 'fa-light fa-object-ungroup' => 'object-ungroup' ),
					array( 'fa-light fa-object-union' => 'object-union' ),
					array( 'fa-light fa-objects-align-bottom' => 'objects-align-bottom' ),
					array( 'fa-light fa-objects-align-center-horizontal' => 'objects-align-center-horizontal' ),
					array( 'fa-light fa-objects-align-center-vertical' => 'objects-align-center-vertical' ),
					array( 'fa-light fa-objects-align-left' => 'objects-align-left' ),
					array( 'fa-light fa-objects-align-right' => 'objects-align-right' ),
					array( 'fa-light fa-objects-align-top' => 'objects-align-top' ),
					array( 'fa-light fa-objects-column' => 'objects-column' ),
					array( 'fa-light fa-octagon-check' => 'octagon-check' ),
					array( 'fa-light fa-octagon-divide' => 'octagon-divide' ),
					array( 'fa-light fa-octagon-exclamation' => 'octagon-exclamation' ),
					array( 'fa-light fa-octagon-minus' => 'octagon-minus' ),
					array( 'fa-light fa-octagon-plus' => 'octagon-plus' ),
					array( 'fa-light fa-octagon-xmark' => 'octagon-xmark' ),
					array( 'fa-light fa-octagon' => 'octagon' ),
					array( 'fa-light fa-oil-can-drip' => 'oil-can-drip' ),
					array( 'fa-light fa-oil-can' => 'oil-can' ),
					array( 'fa-light fa-oil-temperature' => 'oil-temperature' ),
					array( 'fa-light fa-oil-well' => 'oil-well' ),
					array( 'fa-light fa-olive-branch' => 'olive-branch' ),
					array( 'fa-light fa-olive' => 'olive' ),
					array( 'fa-light fa-om' => 'om' ),
					array( 'fa-light fa-omega' => 'omega' ),
					array( 'fa-light fa-onion' => 'onion' ),
					array( 'fa-light fa-option' => 'option' ),
					array( 'fa-light fa-ornament' => 'ornament' ),
					array( 'fa-light fa-otter' => 'otter' ),
					array( 'fa-light fa-outdent' => 'outdent' ),
					array( 'fa-light fa-outlet' => 'outlet' ),
					array( 'fa-light fa-oven' => 'oven' ),
					array( 'fa-light fa-overline' => 'overline' ),
					array( 'fa-light fa-p' => 'p' ),
					array( 'fa-light fa-page-caret-down' => 'page-caret-down' ),
					array( 'fa-light fa-page-caret-up' => 'page-caret-up' ),
					array( 'fa-light fa-page' => 'page' ),
					array( 'fa-light fa-pager' => 'pager' ),
					array( 'fa-light fa-paint-roller' => 'paint-roller' ),
					array( 'fa-light fa-paintbrush-fine' => 'paintbrush-fine' ),
					array( 'fa-light fa-paintbrush-pencil' => 'paintbrush-pencil' ),
					array( 'fa-light fa-paintbrush' => 'paintbrush' ),
					array( 'fa-light fa-palette' => 'palette' ),
					array( 'fa-light fa-pallet-box' => 'pallet-box' ),
					array( 'fa-light fa-pallet-boxes' => 'pallet-boxes' ),
					array( 'fa-light fa-pallet' => 'pallet' ),
					array( 'fa-light fa-pan-food' => 'pan-food' ),
					array( 'fa-light fa-pan-frying' => 'pan-frying' ),
					array( 'fa-light fa-pancakes' => 'pancakes' ),
					array( 'fa-light fa-panel-ews' => 'panel-ews' ),
					array( 'fa-light fa-panel-fire' => 'panel-fire' ),
					array( 'fa-light fa-panorama' => 'panorama' ),
					array( 'fa-light fa-paper-plane-top' => 'paper-plane-top' ),
					array( 'fa-light fa-paper-plane' => 'paper-plane' ),
					array( 'fa-light fa-paperclip-vertical' => 'paperclip-vertical' ),
					array( 'fa-light fa-paperclip' => 'paperclip' ),
					array( 'fa-light fa-parachute-box' => 'parachute-box' ),
					array( 'fa-light fa-paragraph-left' => 'paragraph-left' ),
					array( 'fa-light fa-paragraph' => 'paragraph' ),
					array( 'fa-light fa-party-bell' => 'party-bell' ),
					array( 'fa-light fa-party-horn' => 'party-horn' ),
					array( 'fa-light fa-passport' => 'passport' ),
					array( 'fa-light fa-paste' => 'paste' ),
					array( 'fa-light fa-pause' => 'pause' ),
					array( 'fa-light fa-paw-claws' => 'paw-claws' ),
					array( 'fa-light fa-paw-simple' => 'paw-simple' ),
					array( 'fa-light fa-paw' => 'paw' ),
					array( 'fa-light fa-peace' => 'peace' ),
					array( 'fa-light fa-peach' => 'peach' ),
					array( 'fa-light fa-peanut' => 'peanut' ),
					array( 'fa-light fa-peanuts' => 'peanuts' ),
					array( 'fa-light fa-peapod' => 'peapod' ),
					array( 'fa-light fa-pear' => 'pear' ),
					array( 'fa-light fa-pedestal' => 'pedestal' ),
					array( 'fa-light fa-pegasus' => 'pegasus' ),
					array( 'fa-light fa-pen-circle' => 'pen-circle' ),
					array( 'fa-light fa-pen-clip-slash' => 'pen-clip-slash' ),
					array( 'fa-light fa-pen-clip' => 'pen-clip' ),
					array( 'fa-light fa-pen-fancy-slash' => 'pen-fancy-slash' ),
					array( 'fa-light fa-pen-fancy' => 'pen-fancy' ),
					array( 'fa-light fa-pen-field' => 'pen-field' ),
					array( 'fa-light fa-pen-line' => 'pen-line' ),
					array( 'fa-light fa-pen-nib-slash' => 'pen-nib-slash' ),
					array( 'fa-light fa-pen-nib' => 'pen-nib' ),
					array( 'fa-light fa-pen-paintbrush' => 'pen-paintbrush' ),
					array( 'fa-light fa-pen-ruler' => 'pen-ruler' ),
					array( 'fa-light fa-pen-slash' => 'pen-slash' ),
					array( 'fa-light fa-pen-swirl' => 'pen-swirl' ),
					array( 'fa-light fa-pen-to-square' => 'pen-to-square' ),
					array( 'fa-light fa-pen' => 'pen' ),
					array( 'fa-light fa-pencil-mechanical' => 'pencil-mechanical' ),
					array( 'fa-light fa-pencil-slash' => 'pencil-slash' ),
					array( 'fa-light fa-pencil' => 'pencil' ),
					array( 'fa-light fa-people-arrows' => 'people-arrows' ),
					array( 'fa-light fa-people-carry-box' => 'people-carry-box' ),
					array( 'fa-light fa-people-dress-simple' => 'people-dress-simple' ),
					array( 'fa-light fa-people-dress' => 'people-dress' ),
					array( 'fa-light fa-people-group' => 'people-group' ),
					array( 'fa-light fa-people-line' => 'people-line' ),
					array( 'fa-light fa-people-pants-simple' => 'people-pants-simple' ),
					array( 'fa-light fa-people-pants' => 'people-pants' ),
					array( 'fa-light fa-people-pulling' => 'people-pulling' ),
					array( 'fa-light fa-people-robbery' => 'people-robbery' ),
					array( 'fa-light fa-people-roof' => 'people-roof' ),
					array( 'fa-light fa-people-simple' => 'people-simple' ),
					array( 'fa-light fa-people' => 'people' ),
					array( 'fa-light fa-pepper-hot' => 'pepper-hot' ),
					array( 'fa-light fa-pepper' => 'pepper' ),
					array( 'fa-light fa-percent' => 'percent' ),
					array( 'fa-light fa-period' => 'period' ),
					array( 'fa-light fa-person-arrow-down-to-line' => 'person-arrow-down-to-line' ),
					array( 'fa-light fa-person-arrow-up-from-line' => 'person-arrow-up-from-line' ),
					array( 'fa-light fa-person-biking-mountain' => 'person-biking-mountain' ),
					array( 'fa-light fa-person-biking' => 'person-biking' ),
					array( 'fa-light fa-person-booth' => 'person-booth' ),
					array( 'fa-light fa-person-breastfeeding' => 'person-breastfeeding' ),
					array( 'fa-light fa-person-burst' => 'person-burst' ),
					array( 'fa-light fa-person-cane' => 'person-cane' ),
					array( 'fa-light fa-person-carry-box' => 'person-carry-box' ),
					array( 'fa-light fa-person-chalkboard' => 'person-chalkboard' ),
					array( 'fa-light fa-person-circle-check' => 'person-circle-check' ),
					array( 'fa-light fa-person-circle-exclamation' => 'person-circle-exclamation' ),
					array( 'fa-light fa-person-circle-minus' => 'person-circle-minus' ),
					array( 'fa-light fa-person-circle-plus' => 'person-circle-plus' ),
					array( 'fa-light fa-person-circle-question' => 'person-circle-question' ),
					array( 'fa-light fa-person-circle-xmark' => 'person-circle-xmark' ),
					array( 'fa-light fa-person-digging' => 'person-digging' ),
					array( 'fa-light fa-person-dolly-empty' => 'person-dolly-empty' ),
					array( 'fa-light fa-person-dolly' => 'person-dolly' ),
					array( 'fa-light fa-person-dots-from-line' => 'person-dots-from-line' ),
					array( 'fa-light fa-person-dress-burst' => 'person-dress-burst' ),
					array( 'fa-light fa-person-dress-fairy' => 'person-dress-fairy' ),
					array( 'fa-light fa-person-dress-simple' => 'person-dress-simple' ),
					array( 'fa-light fa-person-dress' => 'person-dress' ),
					array( 'fa-light fa-person-drowning' => 'person-drowning' ),
					array( 'fa-light fa-person-fairy' => 'person-fairy' ),
					array( 'fa-light fa-person-falling-burst' => 'person-falling-burst' ),
					array( 'fa-light fa-person-falling' => 'person-falling' ),
					array( 'fa-light fa-person-from-portal' => 'person-from-portal' ),
					array( 'fa-light fa-person-half-dress' => 'person-half-dress' ),
					array( 'fa-light fa-person-harassing' => 'person-harassing' ),
					array( 'fa-light fa-person-hiking' => 'person-hiking' ),
					array( 'fa-light fa-person-military-pointing' => 'person-military-pointing' ),
					array( 'fa-light fa-person-military-rifle' => 'person-military-rifle' ),
					array( 'fa-light fa-person-military-to-person' => 'person-military-to-person' ),
					array( 'fa-light fa-person-pinball' => 'person-pinball' ),
					array( 'fa-light fa-person-praying' => 'person-praying' ),
					array( 'fa-light fa-person-pregnant' => 'person-pregnant' ),
					array( 'fa-light fa-person-rays' => 'person-rays' ),
					array( 'fa-light fa-person-rifle' => 'person-rifle' ),
					array( 'fa-light fa-person-running-fast' => 'person-running-fast' ),
					array( 'fa-light fa-person-running' => 'person-running' ),
					array( 'fa-light fa-person-seat-reclined' => 'person-seat-reclined' ),
					array( 'fa-light fa-person-seat' => 'person-seat' ),
					array( 'fa-light fa-person-shelter' => 'person-shelter' ),
					array( 'fa-light fa-person-sign' => 'person-sign' ),
					array( 'fa-light fa-person-simple' => 'person-simple' ),
					array( 'fa-light fa-person-skating' => 'person-skating' ),
					array( 'fa-light fa-person-ski-jumping' => 'person-ski-jumping' ),
					array( 'fa-light fa-person-ski-lift' => 'person-ski-lift' ),
					array( 'fa-light fa-person-skiing-nordic' => 'person-skiing-nordic' ),
					array( 'fa-light fa-person-skiing' => 'person-skiing' ),
					array( 'fa-light fa-person-sledding' => 'person-sledding' ),
					array( 'fa-light fa-person-snowboarding' => 'person-snowboarding' ),
					array( 'fa-light fa-person-snowmobiling' => 'person-snowmobiling' ),
					array( 'fa-light fa-person-swimming' => 'person-swimming' ),
					array( 'fa-light fa-person-through-window' => 'person-through-window' ),
					array( 'fa-light fa-person-to-door' => 'person-to-door' ),
					array( 'fa-light fa-person-to-portal' => 'person-to-portal' ),
					array( 'fa-light fa-person-walking-arrow-loop-left' => 'person-walking-arrow-loop-left' ),
					array( 'fa-light fa-person-walking-arrow-right' => 'person-walking-arrow-right' ),
					array( 'fa-light fa-person-walking-dashed-line-arrow-right' => 'person-walking-dashed-line-arrow-right' ),
					array( 'fa-light fa-person-walking-luggage' => 'person-walking-luggage' ),
					array( 'fa-light fa-person-walking-with-cane' => 'person-walking-with-cane' ),
					array( 'fa-light fa-person-walking' => 'person-walking' ),
					array( 'fa-light fa-person' => 'person' ),
					array( 'fa-light fa-peseta-sign' => 'peseta-sign' ),
					array( 'fa-light fa-peso-sign' => 'peso-sign' ),
					array( 'fa-light fa-phone-arrow-down-left' => 'phone-arrow-down-left' ),
					array( 'fa-light fa-phone-arrow-right' => 'phone-arrow-right' ),
					array( 'fa-light fa-phone-arrow-up-right' => 'phone-arrow-up-right' ),
					array( 'fa-light fa-phone-flip' => 'phone-flip' ),
					array( 'fa-light fa-phone-hangup' => 'phone-hangup' ),
					array( 'fa-light fa-phone-intercom' => 'phone-intercom' ),
					array( 'fa-light fa-phone-missed' => 'phone-missed' ),
					array( 'fa-light fa-phone-office' => 'phone-office' ),
					array( 'fa-light fa-phone-plus' => 'phone-plus' ),
					array( 'fa-light fa-phone-rotary' => 'phone-rotary' ),
					array( 'fa-light fa-phone-slash' => 'phone-slash' ),
					array( 'fa-light fa-phone-volume' => 'phone-volume' ),
					array( 'fa-light fa-phone-xmark' => 'phone-xmark' ),
					array( 'fa-light fa-phone' => 'phone' ),
					array( 'fa-light fa-photo-film-music' => 'photo-film-music' ),
					array( 'fa-light fa-photo-film' => 'photo-film' ),
					array( 'fa-light fa-pi' => 'pi' ),
					array( 'fa-light fa-piano-keyboard' => 'piano-keyboard' ),
					array( 'fa-light fa-piano' => 'piano' ),
					array( 'fa-light fa-pickaxe' => 'pickaxe' ),
					array( 'fa-light fa-pickleball' => 'pickleball' ),
					array( 'fa-light fa-pie' => 'pie' ),
					array( 'fa-light fa-pig' => 'pig' ),
					array( 'fa-light fa-piggy-bank' => 'piggy-bank' ),
					array( 'fa-light fa-pills' => 'pills' ),
					array( 'fa-light fa-pinata' => 'pinata' ),
					array( 'fa-light fa-pinball' => 'pinball' ),
					array( 'fa-light fa-pineapple' => 'pineapple' ),
					array( 'fa-light fa-pipe-circle-check' => 'pipe-circle-check' ),
					array( 'fa-light fa-pipe-collar' => 'pipe-collar' ),
					array( 'fa-light fa-pipe-section' => 'pipe-section' ),
					array( 'fa-light fa-pipe-smoking' => 'pipe-smoking' ),
					array( 'fa-light fa-pipe-valve' => 'pipe-valve' ),
					array( 'fa-light fa-pipe' => 'pipe' ),
					array( 'fa-light fa-pizza-slice' => 'pizza-slice' ),
					array( 'fa-light fa-pizza' => 'pizza' ),
					array( 'fa-light fa-place-of-worship' => 'place-of-worship' ),
					array( 'fa-light fa-plane-arrival' => 'plane-arrival' ),
					array( 'fa-light fa-plane-circle-check' => 'plane-circle-check' ),
					array( 'fa-light fa-plane-circle-exclamation' => 'plane-circle-exclamation' ),
					array( 'fa-light fa-plane-circle-xmark' => 'plane-circle-xmark' ),
					array( 'fa-light fa-plane-departure' => 'plane-departure' ),
					array( 'fa-light fa-plane-engines' => 'plane-engines' ),
					array( 'fa-light fa-plane-lock' => 'plane-lock' ),
					array( 'fa-light fa-plane-prop' => 'plane-prop' ),
					array( 'fa-light fa-plane-slash' => 'plane-slash' ),
					array( 'fa-light fa-plane-tail' => 'plane-tail' ),
					array( 'fa-light fa-plane-up-slash' => 'plane-up-slash' ),
					array( 'fa-light fa-plane-up' => 'plane-up' ),
					array( 'fa-light fa-plane' => 'plane' ),
					array( 'fa-light fa-planet-moon' => 'planet-moon' ),
					array( 'fa-light fa-planet-ringed' => 'planet-ringed' ),
					array( 'fa-light fa-plant-wilt' => 'plant-wilt' ),
					array( 'fa-light fa-plate-utensils' => 'plate-utensils' ),
					array( 'fa-light fa-plate-wheat' => 'plate-wheat' ),
					array( 'fa-light fa-play-pause' => 'play-pause' ),
					array( 'fa-light fa-play' => 'play' ),
					array( 'fa-light fa-plug-circle-bolt' => 'plug-circle-bolt' ),
					array( 'fa-light fa-plug-circle-check' => 'plug-circle-check' ),
					array( 'fa-light fa-plug-circle-exclamation' => 'plug-circle-exclamation' ),
					array( 'fa-light fa-plug-circle-minus' => 'plug-circle-minus' ),
					array( 'fa-light fa-plug-circle-plus' => 'plug-circle-plus' ),
					array( 'fa-light fa-plug-circle-xmark' => 'plug-circle-xmark' ),
					array( 'fa-light fa-plug' => 'plug' ),
					array( 'fa-light fa-plus-large' => 'plus-large' ),
					array( 'fa-light fa-plus-minus' => 'plus-minus' ),
					array( 'fa-light fa-plus' => 'plus' ),
					array( 'fa-light fa-podcast' => 'podcast' ),
					array( 'fa-light fa-podium-star' => 'podium-star' ),
					array( 'fa-light fa-podium' => 'podium' ),
					array( 'fa-light fa-police-box' => 'police-box' ),
					array( 'fa-light fa-poll-people' => 'poll-people' ),
					array( 'fa-light fa-pompebled' => 'pompebled' ),
					array( 'fa-light fa-poo-storm' => 'poo-storm' ),
					array( 'fa-light fa-poo' => 'poo' ),
					array( 'fa-light fa-pool-8-ball' => 'pool-8-ball' ),
					array( 'fa-light fa-poop' => 'poop' ),
					array( 'fa-light fa-popcorn' => 'popcorn' ),
					array( 'fa-light fa-popsicle' => 'popsicle' ),
					array( 'fa-light fa-pot-food' => 'pot-food' ),
					array( 'fa-light fa-potato' => 'potato' ),
					array( 'fa-light fa-power-off' => 'power-off' ),
					array( 'fa-light fa-prescription-bottle-medical' => 'prescription-bottle-medical' ),
					array( 'fa-light fa-prescription-bottle-pill' => 'prescription-bottle-pill' ),
					array( 'fa-light fa-prescription-bottle' => 'prescription-bottle' ),
					array( 'fa-light fa-prescription' => 'prescription' ),
					array( 'fa-light fa-presentation-screen' => 'presentation-screen' ),
					array( 'fa-light fa-pretzel' => 'pretzel' ),
					array( 'fa-light fa-print-magnifying-glass' => 'print-magnifying-glass' ),
					array( 'fa-light fa-print-slash' => 'print-slash' ),
					array( 'fa-light fa-print' => 'print' ),
					array( 'fa-light fa-projector' => 'projector' ),
					array( 'fa-light fa-pump-medical' => 'pump-medical' ),
					array( 'fa-light fa-pump-soap' => 'pump-soap' ),
					array( 'fa-light fa-pump' => 'pump' ),
					array( 'fa-light fa-pumpkin' => 'pumpkin' ),
					array( 'fa-light fa-puzzle-piece-simple' => 'puzzle-piece-simple' ),
					array( 'fa-light fa-puzzle-piece' => 'puzzle-piece' ),
					array( 'fa-light fa-puzzle' => 'puzzle' ),
					array( 'fa-light fa-q' => 'q' ),
					array( 'fa-light fa-qrcode' => 'qrcode' ),
					array( 'fa-light fa-question' => 'question' ),
					array( 'fa-light fa-quote-left' => 'quote-left' ),
					array( 'fa-light fa-quote-right' => 'quote-right' ),
					array( 'fa-light fa-quotes' => 'quotes' ),
					array( 'fa-light fa-r' => 'r' ),
					array( 'fa-light fa-rabbit-running' => 'rabbit-running' ),
					array( 'fa-light fa-rabbit' => 'rabbit' ),
					array( 'fa-light fa-raccoon' => 'raccoon' ),
					array( 'fa-light fa-racquet' => 'racquet' ),
					array( 'fa-light fa-radar' => 'radar' ),
					array( 'fa-light fa-radiation' => 'radiation' ),
					array( 'fa-light fa-radio-tuner' => 'radio-tuner' ),
					array( 'fa-light fa-radio' => 'radio' ),
					array( 'fa-light fa-rainbow' => 'rainbow' ),
					array( 'fa-light fa-raindrops' => 'raindrops' ),
					array( 'fa-light fa-ram' => 'ram' ),
					array( 'fa-light fa-ramp-loading' => 'ramp-loading' ),
					array( 'fa-light fa-ranking-star' => 'ranking-star' ),
					array( 'fa-light fa-raygun' => 'raygun' ),
					array( 'fa-light fa-receipt' => 'receipt' ),
					array( 'fa-light fa-record-vinyl' => 'record-vinyl' ),
					array( 'fa-light fa-rectangle-ad' => 'rectangle-ad' ),
					array( 'fa-light fa-rectangle-barcode' => 'rectangle-barcode' ),
					array( 'fa-light fa-rectangle-code' => 'rectangle-code' ),
					array( 'fa-light fa-rectangle-history-circle-plus' => 'rectangle-history-circle-plus' ),
					array( 'fa-light fa-rectangle-history-circle-user' => 'rectangle-history-circle-user' ),
					array( 'fa-light fa-rectangle-history' => 'rectangle-history' ),
					array( 'fa-light fa-rectangle-list' => 'rectangle-list' ),
					array( 'fa-light fa-rectangle-pro' => 'rectangle-pro' ),
					array( 'fa-light fa-rectangle-terminal' => 'rectangle-terminal' ),
					array( 'fa-light fa-rectangle-vertical-history' => 'rectangle-vertical-history' ),
					array( 'fa-light fa-rectangle-vertical' => 'rectangle-vertical' ),
					array( 'fa-light fa-rectangle-wide' => 'rectangle-wide' ),
					array( 'fa-light fa-rectangle-xmark' => 'rectangle-xmark' ),
					array( 'fa-light fa-rectangle' => 'rectangle' ),
					array( 'fa-light fa-rectangles-mixed' => 'rectangles-mixed' ),
					array( 'fa-light fa-recycle' => 'recycle' ),
					array( 'fa-light fa-reel' => 'reel' ),
					array( 'fa-light fa-refrigerator' => 'refrigerator' ),
					array( 'fa-light fa-registered' => 'registered' ),
					array( 'fa-light fa-repeat-1' => 'repeat-1' ),
					array( 'fa-light fa-repeat' => 'repeat' ),
					array( 'fa-light fa-reply-all' => 'reply-all' ),
					array( 'fa-light fa-reply-clock' => 'reply-clock' ),
					array( 'fa-light fa-reply' => 'reply' ),
					array( 'fa-light fa-republican' => 'republican' ),
					array( 'fa-light fa-restroom-simple' => 'restroom-simple' ),
					array( 'fa-light fa-restroom' => 'restroom' ),
					array( 'fa-light fa-retweet' => 'retweet' ),
					array( 'fa-light fa-rhombus' => 'rhombus' ),
					array( 'fa-light fa-ribbon' => 'ribbon' ),
					array( 'fa-light fa-right-from-bracket' => 'right-from-bracket' ),
					array( 'fa-light fa-right-from-line' => 'right-from-line' ),
					array( 'fa-light fa-right-left-large' => 'right-left-large' ),
					array( 'fa-light fa-right-left' => 'right-left' ),
					array( 'fa-light fa-right-long-to-line' => 'right-long-to-line' ),
					array( 'fa-light fa-right-long' => 'right-long' ),
					array( 'fa-light fa-right-to-bracket' => 'right-to-bracket' ),
					array( 'fa-light fa-right-to-line' => 'right-to-line' ),
					array( 'fa-light fa-right' => 'right' ),
					array( 'fa-light fa-ring-diamond' => 'ring-diamond' ),
					array( 'fa-light fa-ring' => 'ring' ),
					array( 'fa-light fa-rings-wedding' => 'rings-wedding' ),
					array( 'fa-light fa-road-barrier' => 'road-barrier' ),
					array( 'fa-light fa-road-bridge' => 'road-bridge' ),
					array( 'fa-light fa-road-circle-check' => 'road-circle-check' ),
					array( 'fa-light fa-road-circle-exclamation' => 'road-circle-exclamation' ),
					array( 'fa-light fa-road-circle-xmark' => 'road-circle-xmark' ),
					array( 'fa-light fa-road-lock' => 'road-lock' ),
					array( 'fa-light fa-road-spikes' => 'road-spikes' ),
					array( 'fa-light fa-road' => 'road' ),
					array( 'fa-light fa-robot-astromech' => 'robot-astromech' ),
					array( 'fa-light fa-robot' => 'robot' ),
					array( 'fa-light fa-rocket-launch' => 'rocket-launch' ),
					array( 'fa-light fa-rocket' => 'rocket' ),
					array( 'fa-light fa-roller-coaster' => 'roller-coaster' ),
					array( 'fa-light fa-rotate-exclamation' => 'rotate-exclamation' ),
					array( 'fa-light fa-rotate-left' => 'rotate-left' ),
					array( 'fa-light fa-rotate-right' => 'rotate-right' ),
					array( 'fa-light fa-rotate' => 'rotate' ),
					array( 'fa-light fa-route-highway' => 'route-highway' ),
					array( 'fa-light fa-route-interstate' => 'route-interstate' ),
					array( 'fa-light fa-route' => 'route' ),
					array( 'fa-light fa-router' => 'router' ),
					array( 'fa-light fa-rss' => 'rss' ),
					array( 'fa-light fa-ruble-sign' => 'ruble-sign' ),
					array( 'fa-light fa-rug' => 'rug' ),
					array( 'fa-light fa-rugby-ball' => 'rugby-ball' ),
					array( 'fa-light fa-ruler-combined' => 'ruler-combined' ),
					array( 'fa-light fa-ruler-horizontal' => 'ruler-horizontal' ),
					array( 'fa-light fa-ruler-triangle' => 'ruler-triangle' ),
					array( 'fa-light fa-ruler-vertical' => 'ruler-vertical' ),
					array( 'fa-light fa-ruler' => 'ruler' ),
					array( 'fa-light fa-rupee-sign' => 'rupee-sign' ),
					array( 'fa-light fa-rupiah-sign' => 'rupiah-sign' ),
					array( 'fa-light fa-rv' => 'rv' ),
					array( 'fa-light fa-s' => 's' ),
					array( 'fa-light fa-sack-dollar' => 'sack-dollar' ),
					array( 'fa-light fa-sack-xmark' => 'sack-xmark' ),
					array( 'fa-light fa-sack' => 'sack' ),
					array( 'fa-light fa-sailboat' => 'sailboat' ),
					array( 'fa-light fa-salad' => 'salad' ),
					array( 'fa-light fa-salt-shaker' => 'salt-shaker' ),
					array( 'fa-light fa-sandwich' => 'sandwich' ),
					array( 'fa-light fa-satellite-dish' => 'satellite-dish' ),
					array( 'fa-light fa-satellite' => 'satellite' ),
					array( 'fa-light fa-sausage' => 'sausage' ),
					array( 'fa-light fa-saxophone-fire' => 'saxophone-fire' ),
					array( 'fa-light fa-saxophone' => 'saxophone' ),
					array( 'fa-light fa-scale-balanced' => 'scale-balanced' ),
					array( 'fa-light fa-scale-unbalanced-flip' => 'scale-unbalanced-flip' ),
					array( 'fa-light fa-scale-unbalanced' => 'scale-unbalanced' ),
					array( 'fa-light fa-scalpel-line-dashed' => 'scalpel-line-dashed' ),
					array( 'fa-light fa-scalpel' => 'scalpel' ),
					array( 'fa-light fa-scanner-gun' => 'scanner-gun' ),
					array( 'fa-light fa-scanner-image' => 'scanner-image' ),
					array( 'fa-light fa-scanner-keyboard' => 'scanner-keyboard' ),
					array( 'fa-light fa-scanner-touchscreen' => 'scanner-touchscreen' ),
					array( 'fa-light fa-scarecrow' => 'scarecrow' ),
					array( 'fa-light fa-scarf' => 'scarf' ),
					array( 'fa-light fa-school-circle-check' => 'school-circle-check' ),
					array( 'fa-light fa-school-circle-exclamation' => 'school-circle-exclamation' ),
					array( 'fa-light fa-school-circle-xmark' => 'school-circle-xmark' ),
					array( 'fa-light fa-school-flag' => 'school-flag' ),
					array( 'fa-light fa-school-lock' => 'school-lock' ),
					array( 'fa-light fa-school' => 'school' ),
					array( 'fa-light fa-scissors' => 'scissors' ),
					array( 'fa-light fa-screen-users' => 'screen-users' ),
					array( 'fa-light fa-screencast' => 'screencast' ),
					array( 'fa-light fa-screwdriver-wrench' => 'screwdriver-wrench' ),
					array( 'fa-light fa-screwdriver' => 'screwdriver' ),
					array( 'fa-light fa-scribble' => 'scribble' ),
					array( 'fa-light fa-scroll-old' => 'scroll-old' ),
					array( 'fa-light fa-scroll-torah' => 'scroll-torah' ),
					array( 'fa-light fa-scroll' => 'scroll' ),
					array( 'fa-light fa-scrubber' => 'scrubber' ),
					array( 'fa-light fa-scythe' => 'scythe' ),
					array( 'fa-light fa-sd-card' => 'sd-card' ),
					array( 'fa-light fa-sd-cards' => 'sd-cards' ),
					array( 'fa-light fa-seal-exclamation' => 'seal-exclamation' ),
					array( 'fa-light fa-seal-question' => 'seal-question' ),
					array( 'fa-light fa-seal' => 'seal' ),
					array( 'fa-light fa-seat-airline' => 'seat-airline' ),
					array( 'fa-light fa-section' => 'section' ),
					array( 'fa-light fa-seedling' => 'seedling' ),
					array( 'fa-light fa-semicolon' => 'semicolon' ),
					array( 'fa-light fa-send-back' => 'send-back' ),
					array( 'fa-light fa-send-backward' => 'send-backward' ),
					array( 'fa-light fa-sensor-cloud' => 'sensor-cloud' ),
					array( 'fa-light fa-sensor-fire' => 'sensor-fire' ),
					array( 'fa-light fa-sensor-on' => 'sensor-on' ),
					array( 'fa-light fa-sensor-triangle-exclamation' => 'sensor-triangle-exclamation' ),
					array( 'fa-light fa-sensor' => 'sensor' ),
					array( 'fa-light fa-server' => 'server' ),
					array( 'fa-light fa-shapes' => 'shapes' ),
					array( 'fa-light fa-share-all' => 'share-all' ),
					array( 'fa-light fa-share-from-square' => 'share-from-square' ),
					array( 'fa-light fa-share-nodes' => 'share-nodes' ),
					array( 'fa-light fa-share' => 'share' ),
					array( 'fa-light fa-sheep' => 'sheep' ),
					array( 'fa-light fa-sheet-plastic' => 'sheet-plastic' ),
					array( 'fa-light fa-shekel-sign' => 'shekel-sign' ),
					array( 'fa-light fa-shelves-empty' => 'shelves-empty' ),
					array( 'fa-light fa-shelves' => 'shelves' ),
					array( 'fa-light fa-shield-cat' => 'shield-cat' ),
					array( 'fa-light fa-shield-check' => 'shield-check' ),
					array( 'fa-light fa-shield-cross' => 'shield-cross' ),
					array( 'fa-light fa-shield-dog' => 'shield-dog' ),
					array( 'fa-light fa-shield-exclamation' => 'shield-exclamation' ),
					array( 'fa-light fa-shield-halved' => 'shield-halved' ),
					array( 'fa-light fa-shield-heart' => 'shield-heart' ),
					array( 'fa-light fa-shield-keyhole' => 'shield-keyhole' ),
					array( 'fa-light fa-shield-minus' => 'shield-minus' ),
					array( 'fa-light fa-shield-plus' => 'shield-plus' ),
					array( 'fa-light fa-shield-quartered' => 'shield-quartered' ),
					array( 'fa-light fa-shield-slash' => 'shield-slash' ),
					array( 'fa-light fa-shield-virus' => 'shield-virus' ),
					array( 'fa-light fa-shield-xmark' => 'shield-xmark' ),
					array( 'fa-light fa-shield' => 'shield' ),
					array( 'fa-light fa-ship' => 'ship' ),
					array( 'fa-light fa-shirt-long-sleeve' => 'shirt-long-sleeve' ),
					array( 'fa-light fa-shirt-running' => 'shirt-running' ),
					array( 'fa-light fa-shirt-tank-top' => 'shirt-tank-top' ),
					array( 'fa-light fa-shirt' => 'shirt' ),
					array( 'fa-light fa-shish-kebab' => 'shish-kebab' ),
					array( 'fa-light fa-shoe-prints' => 'shoe-prints' ),
					array( 'fa-light fa-shop-lock' => 'shop-lock' ),
					array( 'fa-light fa-shop-slash' => 'shop-slash' ),
					array( 'fa-light fa-shop' => 'shop' ),
					array( 'fa-light fa-shovel-snow' => 'shovel-snow' ),
					array( 'fa-light fa-shovel' => 'shovel' ),
					array( 'fa-light fa-shower-down' => 'shower-down' ),
					array( 'fa-light fa-shower' => 'shower' ),
					array( 'fa-light fa-shredder' => 'shredder' ),
					array( 'fa-light fa-shrimp' => 'shrimp' ),
					array( 'fa-light fa-shuffle' => 'shuffle' ),
					array( 'fa-light fa-shutters' => 'shutters' ),
					array( 'fa-light fa-shuttle-space' => 'shuttle-space' ),
					array( 'fa-light fa-shuttlecock' => 'shuttlecock' ),
					array( 'fa-light fa-sickle' => 'sickle' ),
					array( 'fa-light fa-sidebar-flip' => 'sidebar-flip' ),
					array( 'fa-light fa-sidebar' => 'sidebar' ),
					array( 'fa-light fa-sigma' => 'sigma' ),
					array( 'fa-light fa-sign-hanging' => 'sign-hanging' ),
					array( 'fa-light fa-signal-bars-fair' => 'signal-bars-fair' ),
					array( 'fa-light fa-signal-bars-good' => 'signal-bars-good' ),
					array( 'fa-light fa-signal-bars-slash' => 'signal-bars-slash' ),
					array( 'fa-light fa-signal-bars-weak' => 'signal-bars-weak' ),
					array( 'fa-light fa-signal-bars' => 'signal-bars' ),
					array( 'fa-light fa-signal-fair' => 'signal-fair' ),
					array( 'fa-light fa-signal-good' => 'signal-good' ),
					array( 'fa-light fa-signal-slash' => 'signal-slash' ),
					array( 'fa-light fa-signal-stream-slash' => 'signal-stream-slash' ),
					array( 'fa-light fa-signal-stream' => 'signal-stream' ),
					array( 'fa-light fa-signal-strong' => 'signal-strong' ),
					array( 'fa-light fa-signal-weak' => 'signal-weak' ),
					array( 'fa-light fa-signal' => 'signal' ),
					array( 'fa-light fa-signature-lock' => 'signature-lock' ),
					array( 'fa-light fa-signature-slash' => 'signature-slash' ),
					array( 'fa-light fa-signature' => 'signature' ),
					array( 'fa-light fa-signs-post' => 'signs-post' ),
					array( 'fa-light fa-sim-card' => 'sim-card' ),
					array( 'fa-light fa-sim-cards' => 'sim-cards' ),
					array( 'fa-light fa-sink' => 'sink' ),
					array( 'fa-light fa-siren-on' => 'siren-on' ),
					array( 'fa-light fa-siren' => 'siren' ),
					array( 'fa-light fa-sitemap' => 'sitemap' ),
					array( 'fa-light fa-skeleton-ribs' => 'skeleton-ribs' ),
					array( 'fa-light fa-skeleton' => 'skeleton' ),
					array( 'fa-light fa-ski-boot-ski' => 'ski-boot-ski' ),
					array( 'fa-light fa-ski-boot' => 'ski-boot' ),
					array( 'fa-light fa-skull-cow' => 'skull-cow' ),
					array( 'fa-light fa-skull-crossbones' => 'skull-crossbones' ),
					array( 'fa-light fa-skull' => 'skull' ),
					array( 'fa-light fa-slash-back' => 'slash-back' ),
					array( 'fa-light fa-slash-forward' => 'slash-forward' ),
					array( 'fa-light fa-slash' => 'slash' ),
					array( 'fa-light fa-sleigh' => 'sleigh' ),
					array( 'fa-light fa-slider' => 'slider' ),
					array( 'fa-light fa-sliders-simple' => 'sliders-simple' ),
					array( 'fa-light fa-sliders-up' => 'sliders-up' ),
					array( 'fa-light fa-sliders' => 'sliders' ),
					array( 'fa-light fa-slot-machine' => 'slot-machine' ),
					array( 'fa-light fa-smog' => 'smog' ),
					array( 'fa-light fa-smoke' => 'smoke' ),
					array( 'fa-light fa-smoking' => 'smoking' ),
					array( 'fa-light fa-snake' => 'snake' ),
					array( 'fa-light fa-snooze' => 'snooze' ),
					array( 'fa-light fa-snow-blowing' => 'snow-blowing' ),
					array( 'fa-light fa-snowflake-droplets' => 'snowflake-droplets' ),
					array( 'fa-light fa-snowflake' => 'snowflake' ),
					array( 'fa-light fa-snowflakes' => 'snowflakes' ),
					array( 'fa-light fa-snowman-head' => 'snowman-head' ),
					array( 'fa-light fa-snowman' => 'snowman' ),
					array( 'fa-light fa-snowplow' => 'snowplow' ),
					array( 'fa-light fa-soap' => 'soap' ),
					array( 'fa-light fa-socks' => 'socks' ),
					array( 'fa-light fa-soft-serve' => 'soft-serve' ),
					array( 'fa-light fa-solar-panel' => 'solar-panel' ),
					array( 'fa-light fa-solar-system' => 'solar-system' ),
					array( 'fa-light fa-sort-down' => 'sort-down' ),
					array( 'fa-light fa-sort-up' => 'sort-up' ),
					array( 'fa-light fa-sort' => 'sort' ),
					array( 'fa-light fa-spa' => 'spa' ),
					array( 'fa-light fa-space-station-moon-construction' => 'space-station-moon-construction' ),
					array( 'fa-light fa-space-station-moon' => 'space-station-moon' ),
					array( 'fa-light fa-spade' => 'spade' ),
					array( 'fa-light fa-spaghetti-monster-flying' => 'spaghetti-monster-flying' ),
					array( 'fa-light fa-sparkle' => 'sparkle' ),
					array( 'fa-light fa-sparkles' => 'sparkles' ),
					array( 'fa-light fa-speaker' => 'speaker' ),
					array( 'fa-light fa-speakers' => 'speakers' ),
					array( 'fa-light fa-spell-check' => 'spell-check' ),
					array( 'fa-light fa-spider-black-widow' => 'spider-black-widow' ),
					array( 'fa-light fa-spider-web' => 'spider-web' ),
					array( 'fa-light fa-spider' => 'spider' ),
					array( 'fa-light fa-spinner-third' => 'spinner-third' ),
					array( 'fa-light fa-spinner' => 'spinner' ),
					array( 'fa-light fa-split' => 'split' ),
					array( 'fa-light fa-splotch' => 'splotch' ),
					array( 'fa-light fa-spoon' => 'spoon' ),
					array( 'fa-light fa-sportsball' => 'sportsball' ),
					array( 'fa-light fa-spray-can-sparkles' => 'spray-can-sparkles' ),
					array( 'fa-light fa-spray-can' => 'spray-can' ),
					array( 'fa-light fa-sprinkler-ceiling' => 'sprinkler-ceiling' ),
					array( 'fa-light fa-sprinkler' => 'sprinkler' ),
					array( 'fa-light fa-square-0' => 'square-0' ),
					array( 'fa-light fa-square-1' => 'square-1' ),
					array( 'fa-light fa-square-2' => 'square-2' ),
					array( 'fa-light fa-square-3' => 'square-3' ),
					array( 'fa-light fa-square-4' => 'square-4' ),
					array( 'fa-light fa-square-5' => 'square-5' ),
					array( 'fa-light fa-square-6' => 'square-6' ),
					array( 'fa-light fa-square-7' => 'square-7' ),
					array( 'fa-light fa-square-8' => 'square-8' ),
					array( 'fa-light fa-square-9' => 'square-9' ),
					array( 'fa-light fa-square-a-lock' => 'square-a-lock' ),
					array( 'fa-light fa-square-a' => 'square-a' ),
					array( 'fa-light fa-square-ampersand' => 'square-ampersand' ),
					array( 'fa-light fa-square-arrow-down-left' => 'square-arrow-down-left' ),
					array( 'fa-light fa-square-arrow-down-right' => 'square-arrow-down-right' ),
					array( 'fa-light fa-square-arrow-down' => 'square-arrow-down' ),
					array( 'fa-light fa-square-arrow-left' => 'square-arrow-left' ),
					array( 'fa-light fa-square-arrow-right' => 'square-arrow-right' ),
					array( 'fa-light fa-square-arrow-up-left' => 'square-arrow-up-left' ),
					array( 'fa-light fa-square-arrow-up-right' => 'square-arrow-up-right' ),
					array( 'fa-light fa-square-arrow-up' => 'square-arrow-up' ),
					array( 'fa-light fa-square-b' => 'square-b' ),
					array( 'fa-light fa-square-bolt' => 'square-bolt' ),
					array( 'fa-light fa-square-c' => 'square-c' ),
					array( 'fa-light fa-square-caret-down' => 'square-caret-down' ),
					array( 'fa-light fa-square-caret-left' => 'square-caret-left' ),
					array( 'fa-light fa-square-caret-right' => 'square-caret-right' ),
					array( 'fa-light fa-square-caret-up' => 'square-caret-up' ),
					array( 'fa-light fa-square-check' => 'square-check' ),
					array( 'fa-light fa-square-chevron-down' => 'square-chevron-down' ),
					array( 'fa-light fa-square-chevron-left' => 'square-chevron-left' ),
					array( 'fa-light fa-square-chevron-right' => 'square-chevron-right' ),
					array( 'fa-light fa-square-chevron-up' => 'square-chevron-up' ),
					array( 'fa-light fa-square-code' => 'square-code' ),
					array( 'fa-light fa-square-d' => 'square-d' ),
					array( 'fa-light fa-square-dashed-circle-plus' => 'square-dashed-circle-plus' ),
					array( 'fa-light fa-square-dashed' => 'square-dashed' ),
					array( 'fa-light fa-square-divide' => 'square-divide' ),
					array( 'fa-light fa-square-dollar' => 'square-dollar' ),
					array( 'fa-light fa-square-down-left' => 'square-down-left' ),
					array( 'fa-light fa-square-down-right' => 'square-down-right' ),
					array( 'fa-light fa-square-down' => 'square-down' ),
					array( 'fa-light fa-square-e' => 'square-e' ),
					array( 'fa-light fa-square-ellipsis-vertical' => 'square-ellipsis-vertical' ),
					array( 'fa-light fa-square-ellipsis' => 'square-ellipsis' ),
					array( 'fa-light fa-square-envelope' => 'square-envelope' ),
					array( 'fa-light fa-square-exclamation' => 'square-exclamation' ),
					array( 'fa-light fa-square-f' => 'square-f' ),
					array( 'fa-light fa-square-fragile' => 'square-fragile' ),
					array( 'fa-light fa-square-full' => 'square-full' ),
					array( 'fa-light fa-square-g' => 'square-g' ),
					array( 'fa-light fa-square-h' => 'square-h' ),
					array( 'fa-light fa-square-heart' => 'square-heart' ),
					array( 'fa-light fa-square-i' => 'square-i' ),
					array( 'fa-light fa-square-info' => 'square-info' ),
					array( 'fa-light fa-square-j' => 'square-j' ),
					array( 'fa-light fa-square-k' => 'square-k' ),
					array( 'fa-light fa-square-kanban' => 'square-kanban' ),
					array( 'fa-light fa-square-l' => 'square-l' ),
					array( 'fa-light fa-square-left' => 'square-left' ),
					array( 'fa-light fa-square-list' => 'square-list' ),
					array( 'fa-light fa-square-m' => 'square-m' ),
					array( 'fa-light fa-square-minus' => 'square-minus' ),
					array( 'fa-light fa-square-n' => 'square-n' ),
					array( 'fa-light fa-square-nfi' => 'square-nfi' ),
					array( 'fa-light fa-square-o' => 'square-o' ),
					array( 'fa-light fa-square-p' => 'square-p' ),
					array( 'fa-light fa-square-parking-slash' => 'square-parking-slash' ),
					array( 'fa-light fa-square-parking' => 'square-parking' ),
					array( 'fa-light fa-square-pen' => 'square-pen' ),
					array( 'fa-light fa-square-person-confined' => 'square-person-confined' ),
					array( 'fa-light fa-square-phone-flip' => 'square-phone-flip' ),
					array( 'fa-light fa-square-phone-hangup' => 'square-phone-hangup' ),
					array( 'fa-light fa-square-phone' => 'square-phone' ),
					array( 'fa-light fa-square-plus' => 'square-plus' ),
					array( 'fa-light fa-square-poll-horizontal' => 'square-poll-horizontal' ),
					array( 'fa-light fa-square-poll-vertical' => 'square-poll-vertical' ),
					array( 'fa-light fa-square-q' => 'square-q' ),
					array( 'fa-light fa-square-quarters' => 'square-quarters' ),
					array( 'fa-light fa-square-question' => 'square-question' ),
					array( 'fa-light fa-square-quote' => 'square-quote' ),
					array( 'fa-light fa-square-r' => 'square-r' ),
					array( 'fa-light fa-square-right' => 'square-right' ),
					array( 'fa-light fa-square-ring' => 'square-ring' ),
					array( 'fa-light fa-square-root-variable' => 'square-root-variable' ),
					array( 'fa-light fa-square-root' => 'square-root' ),
					array( 'fa-light fa-square-rss' => 'square-rss' ),
					array( 'fa-light fa-square-s' => 'square-s' ),
					array( 'fa-light fa-square-share-nodes' => 'square-share-nodes' ),
					array( 'fa-light fa-square-sliders-vertical' => 'square-sliders-vertical' ),
					array( 'fa-light fa-square-sliders' => 'square-sliders' ),
					array( 'fa-light fa-square-small' => 'square-small' ),
					array( 'fa-light fa-square-star' => 'square-star' ),
					array( 'fa-light fa-square-t' => 'square-t' ),
					array( 'fa-light fa-square-terminal' => 'square-terminal' ),
					array( 'fa-light fa-square-this-way-up' => 'square-this-way-up' ),
					array( 'fa-light fa-square-u' => 'square-u' ),
					array( 'fa-light fa-square-up-left' => 'square-up-left' ),
					array( 'fa-light fa-square-up-right' => 'square-up-right' ),
					array( 'fa-light fa-square-up' => 'square-up' ),
					array( 'fa-light fa-square-user' => 'square-user' ),
					array( 'fa-light fa-square-v' => 'square-v' ),
					array( 'fa-light fa-square-virus' => 'square-virus' ),
					array( 'fa-light fa-square-w' => 'square-w' ),
					array( 'fa-light fa-square-x' => 'square-x' ),
					array( 'fa-light fa-square-xmark' => 'square-xmark' ),
					array( 'fa-light fa-square-y' => 'square-y' ),
					array( 'fa-light fa-square-z' => 'square-z' ),
					array( 'fa-light fa-square' => 'square' ),
					array( 'fa-light fa-squid' => 'squid' ),
					array( 'fa-light fa-squirrel' => 'squirrel' ),
					array( 'fa-light fa-staff-snake' => 'staff-snake' ),
					array( 'fa-light fa-staff' => 'staff' ),
					array( 'fa-light fa-stairs' => 'stairs' ),
					array( 'fa-light fa-stamp' => 'stamp' ),
					array( 'fa-light fa-standard-definition' => 'standard-definition' ),
					array( 'fa-light fa-stapler' => 'stapler' ),
					array( 'fa-light fa-star-and-crescent' => 'star-and-crescent' ),
					array( 'fa-light fa-star-christmas' => 'star-christmas' ),
					array( 'fa-light fa-star-exclamation' => 'star-exclamation' ),
					array( 'fa-light fa-star-half-stroke' => 'star-half-stroke' ),
					array( 'fa-light fa-star-half' => 'star-half' ),
					array( 'fa-light fa-star-of-david' => 'star-of-david' ),
					array( 'fa-light fa-star-of-life' => 'star-of-life' ),
					array( 'fa-light fa-star-sharp-half-stroke' => 'star-sharp-half-stroke' ),
					array( 'fa-light fa-star-sharp-half' => 'star-sharp-half' ),
					array( 'fa-light fa-star-sharp' => 'star-sharp' ),
					array( 'fa-light fa-star-shooting' => 'star-shooting' ),
					array( 'fa-light fa-star' => 'star' ),
					array( 'fa-light fa-starfighter-twin-ion-engine-advanced' => 'starfighter-twin-ion-engine-advanced' ),
					array( 'fa-light fa-starfighter-twin-ion-engine' => 'starfighter-twin-ion-engine' ),
					array( 'fa-light fa-starfighter' => 'starfighter' ),
					array( 'fa-light fa-stars' => 'stars' ),
					array( 'fa-light fa-starship-freighter' => 'starship-freighter' ),
					array( 'fa-light fa-starship' => 'starship' ),
					array( 'fa-light fa-steak' => 'steak' ),
					array( 'fa-light fa-steering-wheel' => 'steering-wheel' ),
					array( 'fa-light fa-sterling-sign' => 'sterling-sign' ),
					array( 'fa-light fa-stethoscope' => 'stethoscope' ),
					array( 'fa-light fa-stocking' => 'stocking' ),
					array( 'fa-light fa-stomach' => 'stomach' ),
					array( 'fa-light fa-stop' => 'stop' ),
					array( 'fa-light fa-stopwatch-20' => 'stopwatch-20' ),
					array( 'fa-light fa-stopwatch' => 'stopwatch' ),
					array( 'fa-light fa-store-lock' => 'store-lock' ),
					array( 'fa-light fa-store-slash' => 'store-slash' ),
					array( 'fa-light fa-store' => 'store' ),
					array( 'fa-light fa-strawberry' => 'strawberry' ),
					array( 'fa-light fa-street-view' => 'street-view' ),
					array( 'fa-light fa-stretcher' => 'stretcher' ),
					array( 'fa-light fa-strikethrough' => 'strikethrough' ),
					array( 'fa-light fa-stroopwafel' => 'stroopwafel' ),
					array( 'fa-light fa-subscript' => 'subscript' ),
					array( 'fa-light fa-subtitles-slash' => 'subtitles-slash' ),
					array( 'fa-light fa-subtitles' => 'subtitles' ),
					array( 'fa-light fa-suitcase-medical' => 'suitcase-medical' ),
					array( 'fa-light fa-suitcase-rolling' => 'suitcase-rolling' ),
					array( 'fa-light fa-suitcase' => 'suitcase' ),
					array( 'fa-light fa-sun-bright' => 'sun-bright' ),
					array( 'fa-light fa-sun-cloud' => 'sun-cloud' ),
					array( 'fa-light fa-sun-dust' => 'sun-dust' ),
					array( 'fa-light fa-sun-haze' => 'sun-haze' ),
					array( 'fa-light fa-sun-plant-wilt' => 'sun-plant-wilt' ),
					array( 'fa-light fa-sun' => 'sun' ),
					array( 'fa-light fa-sunglasses' => 'sunglasses' ),
					array( 'fa-light fa-sunrise' => 'sunrise' ),
					array( 'fa-light fa-sunset' => 'sunset' ),
					array( 'fa-light fa-superscript' => 'superscript' ),
					array( 'fa-light fa-sushi-roll' => 'sushi-roll' ),
					array( 'fa-light fa-sushi' => 'sushi' ),
					array( 'fa-light fa-swap-arrows' => 'swap-arrows' ),
					array( 'fa-light fa-swap' => 'swap' ),
					array( 'fa-light fa-swatchbook' => 'swatchbook' ),
					array( 'fa-light fa-sword-laser-alt' => 'sword-laser-alt' ),
					array( 'fa-light fa-sword-laser' => 'sword-laser' ),
					array( 'fa-light fa-sword' => 'sword' ),
					array( 'fa-light fa-swords-laser' => 'swords-laser' ),
					array( 'fa-light fa-swords' => 'swords' ),
					array( 'fa-light fa-symbols' => 'symbols' ),
					array( 'fa-light fa-synagogue' => 'synagogue' ),
					array( 'fa-light fa-syringe' => 'syringe' ),
					array( 'fa-light fa-t' => 't' ),
					array( 'fa-light fa-table-cells-large' => 'table-cells-large' ),
					array( 'fa-light fa-table-cells' => 'table-cells' ),
					array( 'fa-light fa-table-columns' => 'table-columns' ),
					array( 'fa-light fa-table-layout' => 'table-layout' ),
					array( 'fa-light fa-table-list' => 'table-list' ),
					array( 'fa-light fa-table-picnic' => 'table-picnic' ),
					array( 'fa-light fa-table-pivot' => 'table-pivot' ),
					array( 'fa-light fa-table-rows' => 'table-rows' ),
					array( 'fa-light fa-table-tennis-paddle-ball' => 'table-tennis-paddle-ball' ),
					array( 'fa-light fa-table-tree' => 'table-tree' ),
					array( 'fa-light fa-table' => 'table' ),
					array( 'fa-light fa-tablet-button' => 'tablet-button' ),
					array( 'fa-light fa-tablet-rugged' => 'tablet-rugged' ),
					array( 'fa-light fa-tablet-screen-button' => 'tablet-screen-button' ),
					array( 'fa-light fa-tablet-screen' => 'tablet-screen' ),
					array( 'fa-light fa-tablet' => 'tablet' ),
					array( 'fa-light fa-tablets' => 'tablets' ),
					array( 'fa-light fa-tachograph-digital' => 'tachograph-digital' ),
					array( 'fa-light fa-taco' => 'taco' ),
					array( 'fa-light fa-tag' => 'tag' ),
					array( 'fa-light fa-tags' => 'tags' ),
					array( 'fa-light fa-tally-1' => 'tally-1' ),
					array( 'fa-light fa-tally-2' => 'tally-2' ),
					array( 'fa-light fa-tally-3' => 'tally-3' ),
					array( 'fa-light fa-tally-4' => 'tally-4' ),
					array( 'fa-light fa-tally' => 'tally' ),
					array( 'fa-light fa-tamale' => 'tamale' ),
					array( 'fa-light fa-tank-water' => 'tank-water' ),
					array( 'fa-light fa-tape' => 'tape' ),
					array( 'fa-light fa-tarp-droplet' => 'tarp-droplet' ),
					array( 'fa-light fa-tarp' => 'tarp' ),
					array( 'fa-light fa-taxi-bus' => 'taxi-bus' ),
					array( 'fa-light fa-taxi' => 'taxi' ),
					array( 'fa-light fa-teddy-bear' => 'teddy-bear' ),
					array( 'fa-light fa-teeth-open' => 'teeth-open' ),
					array( 'fa-light fa-teeth' => 'teeth' ),
					array( 'fa-light fa-telescope' => 'telescope' ),
					array( 'fa-light fa-temperature-arrow-down' => 'temperature-arrow-down' ),
					array( 'fa-light fa-temperature-arrow-up' => 'temperature-arrow-up' ),
					array( 'fa-light fa-temperature-empty' => 'temperature-empty' ),
					array( 'fa-light fa-temperature-full' => 'temperature-full' ),
					array( 'fa-light fa-temperature-half' => 'temperature-half' ),
					array( 'fa-light fa-temperature-high' => 'temperature-high' ),
					array( 'fa-light fa-temperature-list' => 'temperature-list' ),
					array( 'fa-light fa-temperature-low' => 'temperature-low' ),
					array( 'fa-light fa-temperature-quarter' => 'temperature-quarter' ),
					array( 'fa-light fa-temperature-snow' => 'temperature-snow' ),
					array( 'fa-light fa-temperature-sun' => 'temperature-sun' ),
					array( 'fa-light fa-temperature-three-quarters' => 'temperature-three-quarters' ),
					array( 'fa-light fa-tenge-sign' => 'tenge-sign' ),
					array( 'fa-light fa-tennis-ball' => 'tennis-ball' ),
					array( 'fa-light fa-tent-arrow-down-to-line' => 'tent-arrow-down-to-line' ),
					array( 'fa-light fa-tent-arrow-left-right' => 'tent-arrow-left-right' ),
					array( 'fa-light fa-tent-arrow-turn-left' => 'tent-arrow-turn-left' ),
					array( 'fa-light fa-tent-arrows-down' => 'tent-arrows-down' ),
					array( 'fa-light fa-tent' => 'tent' ),
					array( 'fa-light fa-tents' => 'tents' ),
					array( 'fa-light fa-terminal' => 'terminal' ),
					array( 'fa-light fa-text-height' => 'text-height' ),
					array( 'fa-light fa-text-size' => 'text-size' ),
					array( 'fa-light fa-text-slash' => 'text-slash' ),
					array( 'fa-light fa-text-width' => 'text-width' ),
					array( 'fa-light fa-text' => 'text' ),
					array( 'fa-light fa-thermometer' => 'thermometer' ),
					array( 'fa-light fa-theta' => 'theta' ),
					array( 'fa-light fa-thought-bubble' => 'thought-bubble' ),
					array( 'fa-light fa-thumbs-down' => 'thumbs-down' ),
					array( 'fa-light fa-thumbs-up' => 'thumbs-up' ),
					array( 'fa-light fa-thumbtack' => 'thumbtack' ),
					array( 'fa-light fa-tick' => 'tick' ),
					array( 'fa-light fa-ticket-airline' => 'ticket-airline' ),
					array( 'fa-light fa-ticket-simple' => 'ticket-simple' ),
					array( 'fa-light fa-ticket' => 'ticket' ),
					array( 'fa-light fa-tickets-airline' => 'tickets-airline' ),
					array( 'fa-light fa-tilde' => 'tilde' ),
					array( 'fa-light fa-timeline-arrow' => 'timeline-arrow' ),
					array( 'fa-light fa-timeline' => 'timeline' ),
					array( 'fa-light fa-timer' => 'timer' ),
					array( 'fa-light fa-tire-flat' => 'tire-flat' ),
					array( 'fa-light fa-tire-pressure-warning' => 'tire-pressure-warning' ),
					array( 'fa-light fa-tire-rugged' => 'tire-rugged' ),
					array( 'fa-light fa-tire' => 'tire' ),
					array( 'fa-light fa-toggle-large-off' => 'toggle-large-off' ),
					array( 'fa-light fa-toggle-large-on' => 'toggle-large-on' ),
					array( 'fa-light fa-toggle-off' => 'toggle-off' ),
					array( 'fa-light fa-toggle-on' => 'toggle-on' ),
					array( 'fa-light fa-toilet-paper-blank-under' => 'toilet-paper-blank-under' ),
					array( 'fa-light fa-toilet-paper-blank' => 'toilet-paper-blank' ),
					array( 'fa-light fa-toilet-paper-check' => 'toilet-paper-check' ),
					array( 'fa-light fa-toilet-paper-slash' => 'toilet-paper-slash' ),
					array( 'fa-light fa-toilet-paper-under-slash' => 'toilet-paper-under-slash' ),
					array( 'fa-light fa-toilet-paper-under' => 'toilet-paper-under' ),
					array( 'fa-light fa-toilet-paper-xmark' => 'toilet-paper-xmark' ),
					array( 'fa-light fa-toilet-paper' => 'toilet-paper' ),
					array( 'fa-light fa-toilet-portable' => 'toilet-portable' ),
					array( 'fa-light fa-toilet' => 'toilet' ),
					array( 'fa-light fa-toilets-portable' => 'toilets-portable' ),
					array( 'fa-light fa-tomato' => 'tomato' ),
					array( 'fa-light fa-tombstone-blank' => 'tombstone-blank' ),
					array( 'fa-light fa-tombstone' => 'tombstone' ),
					array( 'fa-light fa-toolbox' => 'toolbox' ),
					array( 'fa-light fa-tooth' => 'tooth' ),
					array( 'fa-light fa-toothbrush' => 'toothbrush' ),
					array( 'fa-light fa-torii-gate' => 'torii-gate' ),
					array( 'fa-light fa-tornado' => 'tornado' ),
					array( 'fa-light fa-tower-broadcast' => 'tower-broadcast' ),
					array( 'fa-light fa-tower-cell' => 'tower-cell' ),
					array( 'fa-light fa-tower-control' => 'tower-control' ),
					array( 'fa-light fa-tower-observation' => 'tower-observation' ),
					array( 'fa-light fa-tractor' => 'tractor' ),
					array( 'fa-light fa-trademark' => 'trademark' ),
					array( 'fa-light fa-traffic-cone' => 'traffic-cone' ),
					array( 'fa-light fa-traffic-light-go' => 'traffic-light-go' ),
					array( 'fa-light fa-traffic-light-slow' => 'traffic-light-slow' ),
					array( 'fa-light fa-traffic-light-stop' => 'traffic-light-stop' ),
					array( 'fa-light fa-traffic-light' => 'traffic-light' ),
					array( 'fa-light fa-trailer' => 'trailer' ),
					array( 'fa-light fa-train-subway-tunnel' => 'train-subway-tunnel' ),
					array( 'fa-light fa-train-subway' => 'train-subway' ),
					array( 'fa-light fa-train-track' => 'train-track' ),
					array( 'fa-light fa-train-tram' => 'train-tram' ),
					array( 'fa-light fa-train-tunnel' => 'train-tunnel' ),
					array( 'fa-light fa-train' => 'train' ),
					array( 'fa-light fa-transformer-bolt' => 'transformer-bolt' ),
					array( 'fa-light fa-transgender' => 'transgender' ),
					array( 'fa-light fa-transporter-1' => 'transporter-1' ),
					array( 'fa-light fa-transporter-2' => 'transporter-2' ),
					array( 'fa-light fa-transporter-3' => 'transporter-3' ),
					array( 'fa-light fa-transporter-4' => 'transporter-4' ),
					array( 'fa-light fa-transporter-5' => 'transporter-5' ),
					array( 'fa-light fa-transporter-6' => 'transporter-6' ),
					array( 'fa-light fa-transporter-7' => 'transporter-7' ),
					array( 'fa-light fa-transporter-empty' => 'transporter-empty' ),
					array( 'fa-light fa-transporter' => 'transporter' ),
					array( 'fa-light fa-trash-arrow-up' => 'trash-arrow-up' ),
					array( 'fa-light fa-trash-can-arrow-up' => 'trash-can-arrow-up' ),
					array( 'fa-light fa-trash-can-check' => 'trash-can-check' ),
					array( 'fa-light fa-trash-can-clock' => 'trash-can-clock' ),
					array( 'fa-light fa-trash-can-list' => 'trash-can-list' ),
					array( 'fa-light fa-trash-can-plus' => 'trash-can-plus' ),
					array( 'fa-light fa-trash-can-slash' => 'trash-can-slash' ),
					array( 'fa-light fa-trash-can-undo' => 'trash-can-undo' ),
					array( 'fa-light fa-trash-can-xmark' => 'trash-can-xmark' ),
					array( 'fa-light fa-trash-can' => 'trash-can' ),
					array( 'fa-light fa-trash-check' => 'trash-check' ),
					array( 'fa-light fa-trash-clock' => 'trash-clock' ),
					array( 'fa-light fa-trash-list' => 'trash-list' ),
					array( 'fa-light fa-trash-plus' => 'trash-plus' ),
					array( 'fa-light fa-trash-slash' => 'trash-slash' ),
					array( 'fa-light fa-trash-undo' => 'trash-undo' ),
					array( 'fa-light fa-trash-xmark' => 'trash-xmark' ),
					array( 'fa-light fa-trash' => 'trash' ),
					array( 'fa-light fa-treasure-chest' => 'treasure-chest' ),
					array( 'fa-light fa-tree-christmas' => 'tree-christmas' ),
					array( 'fa-light fa-tree-city' => 'tree-city' ),
					array( 'fa-light fa-tree-deciduous' => 'tree-deciduous' ),
					array( 'fa-light fa-tree-decorated' => 'tree-decorated' ),
					array( 'fa-light fa-tree-large' => 'tree-large' ),
					array( 'fa-light fa-tree-palm' => 'tree-palm' ),
					array( 'fa-light fa-tree' => 'tree' ),
					array( 'fa-light fa-trees' => 'trees' ),
					array( 'fa-light fa-triangle-exclamation' => 'triangle-exclamation' ),
					array( 'fa-light fa-triangle-instrument' => 'triangle-instrument' ),
					array( 'fa-light fa-triangle-person-digging' => 'triangle-person-digging' ),
					array( 'fa-light fa-triangle' => 'triangle' ),
					array( 'fa-light fa-tricycle-adult' => 'tricycle-adult' ),
					array( 'fa-light fa-tricycle' => 'tricycle' ),
					array( 'fa-light fa-trillium' => 'trillium' ),
					array( 'fa-light fa-trophy-star' => 'trophy-star' ),
					array( 'fa-light fa-trophy' => 'trophy' ),
					array( 'fa-light fa-trowel-bricks' => 'trowel-bricks' ),
					array( 'fa-light fa-trowel' => 'trowel' ),
					array( 'fa-light fa-truck-arrow-right' => 'truck-arrow-right' ),
					array( 'fa-light fa-truck-bolt' => 'truck-bolt' ),
					array( 'fa-light fa-truck-clock' => 'truck-clock' ),
					array( 'fa-light fa-truck-container-empty' => 'truck-container-empty' ),
					array( 'fa-light fa-truck-container' => 'truck-container' ),
					array( 'fa-light fa-truck-droplet' => 'truck-droplet' ),
					array( 'fa-light fa-truck-fast' => 'truck-fast' ),
					array( 'fa-light fa-truck-field-un' => 'truck-field-un' ),
					array( 'fa-light fa-truck-field' => 'truck-field' ),
					array( 'fa-light fa-truck-flatbed' => 'truck-flatbed' ),
					array( 'fa-light fa-truck-front' => 'truck-front' ),
					array( 'fa-light fa-truck-medical' => 'truck-medical' ),
					array( 'fa-light fa-truck-monster' => 'truck-monster' ),
					array( 'fa-light fa-truck-moving' => 'truck-moving' ),
					array( 'fa-light fa-truck-pickup' => 'truck-pickup' ),
					array( 'fa-light fa-truck-plane' => 'truck-plane' ),
					array( 'fa-light fa-truck-plow' => 'truck-plow' ),
					array( 'fa-light fa-truck-ramp-box' => 'truck-ramp-box' ),
					array( 'fa-light fa-truck-ramp-couch' => 'truck-ramp-couch' ),
					array( 'fa-light fa-truck-ramp' => 'truck-ramp' ),
					array( 'fa-light fa-truck-tow' => 'truck-tow' ),
					array( 'fa-light fa-truck' => 'truck' ),
					array( 'fa-light fa-trumpet' => 'trumpet' ),
					array( 'fa-light fa-tty-answer' => 'tty-answer' ),
					array( 'fa-light fa-tty' => 'tty' ),
					array( 'fa-light fa-tugrik-sign' => 'tugrik-sign' ),
					array( 'fa-light fa-turkey' => 'turkey' ),
					array( 'fa-light fa-turkish-lira-sign' => 'turkish-lira-sign' ),
					array( 'fa-light fa-turn-down-left' => 'turn-down-left' ),
					array( 'fa-light fa-turn-down-right' => 'turn-down-right' ),
					array( 'fa-light fa-turn-down' => 'turn-down' ),
					array( 'fa-light fa-turn-up' => 'turn-up' ),
					array( 'fa-light fa-turntable' => 'turntable' ),
					array( 'fa-light fa-turtle' => 'turtle' ),
					array( 'fa-light fa-tv-music' => 'tv-music' ),
					array( 'fa-light fa-tv-retro' => 'tv-retro' ),
					array( 'fa-light fa-tv' => 'tv' ),
					array( 'fa-light fa-typewriter' => 'typewriter' ),
					array( 'fa-light fa-u' => 'u' ),
					array( 'fa-light fa-ufo-beam' => 'ufo-beam' ),
					array( 'fa-light fa-ufo' => 'ufo' ),
					array( 'fa-light fa-umbrella-beach' => 'umbrella-beach' ),
					array( 'fa-light fa-umbrella-simple' => 'umbrella-simple' ),
					array( 'fa-light fa-umbrella' => 'umbrella' ),
					array( 'fa-light fa-underline' => 'underline' ),
					array( 'fa-light fa-unicorn' => 'unicorn' ),
					array( 'fa-light fa-uniform-martial-arts' => 'uniform-martial-arts' ),
					array( 'fa-light fa-union' => 'union' ),
					array( 'fa-light fa-universal-access' => 'universal-access' ),
					array( 'fa-light fa-unlock-keyhole' => 'unlock-keyhole' ),
					array( 'fa-light fa-unlock' => 'unlock' ),
					array( 'fa-light fa-up-down-left-right' => 'up-down-left-right' ),
					array( 'fa-light fa-up-down' => 'up-down' ),
					array( 'fa-light fa-up-from-bracket' => 'up-from-bracket' ),
					array( 'fa-light fa-up-from-dotted-line' => 'up-from-dotted-line' ),
					array( 'fa-light fa-up-from-line' => 'up-from-line' ),
					array( 'fa-light fa-up-left' => 'up-left' ),
					array( 'fa-light fa-up-long' => 'up-long' ),
					array( 'fa-light fa-up-right-and-down-left-from-center' => 'up-right-and-down-left-from-center' ),
					array( 'fa-light fa-up-right-from-square' => 'up-right-from-square' ),
					array( 'fa-light fa-up-right' => 'up-right' ),
					array( 'fa-light fa-up-to-dotted-line' => 'up-to-dotted-line' ),
					array( 'fa-light fa-up-to-line' => 'up-to-line' ),
					array( 'fa-light fa-up' => 'up' ),
					array( 'fa-light fa-upload' => 'upload' ),
					array( 'fa-light fa-usb-drive' => 'usb-drive' ),
					array( 'fa-light fa-user-alien' => 'user-alien' ),
					array( 'fa-light fa-user-astronaut' => 'user-astronaut' ),
					array( 'fa-light fa-user-bounty-hunter' => 'user-bounty-hunter' ),
					array( 'fa-light fa-user-check' => 'user-check' ),
					array( 'fa-light fa-user-chef' => 'user-chef' ),
					array( 'fa-light fa-user-clock' => 'user-clock' ),
					array( 'fa-light fa-user-cowboy' => 'user-cowboy' ),
					array( 'fa-light fa-user-crown' => 'user-crown' ),
					array( 'fa-light fa-user-doctor-hair-long' => 'user-doctor-hair-long' ),
					array( 'fa-light fa-user-doctor-hair' => 'user-doctor-hair' ),
					array( 'fa-light fa-user-doctor-message' => 'user-doctor-message' ),
					array( 'fa-light fa-user-doctor' => 'user-doctor' ),
					array( 'fa-light fa-user-gear' => 'user-gear' ),
					array( 'fa-light fa-user-graduate' => 'user-graduate' ),
					array( 'fa-light fa-user-group-crown' => 'user-group-crown' ),
					array( 'fa-light fa-user-group-simple' => 'user-group-simple' ),
					array( 'fa-light fa-user-group' => 'user-group' ),
					array( 'fa-light fa-user-hair-buns' => 'user-hair-buns' ),
					array( 'fa-light fa-user-hair-long' => 'user-hair-long' ),
					array( 'fa-light fa-user-hair-mullet' => 'user-hair-mullet' ),
					array( 'fa-light fa-user-hair' => 'user-hair' ),
					array( 'fa-light fa-user-headset' => 'user-headset' ),
					array( 'fa-light fa-user-helmet-safety' => 'user-helmet-safety' ),
					array( 'fa-light fa-user-injured' => 'user-injured' ),
					array( 'fa-light fa-user-large-slash' => 'user-large-slash' ),
					array( 'fa-light fa-user-large' => 'user-large' ),
					array( 'fa-light fa-user-lock' => 'user-lock' ),
					array( 'fa-light fa-user-magnifying-glass' => 'user-magnifying-glass' ),
					array( 'fa-light fa-user-minus' => 'user-minus' ),
					array( 'fa-light fa-user-music' => 'user-music' ),
					array( 'fa-light fa-user-ninja' => 'user-ninja' ),
					array( 'fa-light fa-user-nurse-hair-long' => 'user-nurse-hair-long' ),
					array( 'fa-light fa-user-nurse-hair' => 'user-nurse-hair' ),
					array( 'fa-light fa-user-nurse' => 'user-nurse' ),
					array( 'fa-light fa-user-pen' => 'user-pen' ),
					array( 'fa-light fa-user-pilot-tie' => 'user-pilot-tie' ),
					array( 'fa-light fa-user-pilot' => 'user-pilot' ),
					array( 'fa-light fa-user-plus' => 'user-plus' ),
					array( 'fa-light fa-user-police-tie' => 'user-police-tie' ),
					array( 'fa-light fa-user-police' => 'user-police' ),
					array( 'fa-light fa-user-robot-xmarks' => 'user-robot-xmarks' ),
					array( 'fa-light fa-user-robot' => 'user-robot' ),
					array( 'fa-light fa-user-secret' => 'user-secret' ),
					array( 'fa-light fa-user-shakespeare' => 'user-shakespeare' ),
					array( 'fa-light fa-user-shield' => 'user-shield' ),
					array( 'fa-light fa-user-slash' => 'user-slash' ),
					array( 'fa-light fa-user-tag' => 'user-tag' ),
					array( 'fa-light fa-user-tie-hair-long' => 'user-tie-hair-long' ),
					array( 'fa-light fa-user-tie-hair' => 'user-tie-hair' ),
					array( 'fa-light fa-user-tie' => 'user-tie' ),
					array( 'fa-light fa-user-unlock' => 'user-unlock' ),
					array( 'fa-light fa-user-visor' => 'user-visor' ),
					array( 'fa-light fa-user-vneck-hair-long' => 'user-vneck-hair-long' ),
					array( 'fa-light fa-user-vneck-hair' => 'user-vneck-hair' ),
					array( 'fa-light fa-user-vneck' => 'user-vneck' ),
					array( 'fa-light fa-user-xmark' => 'user-xmark' ),
					array( 'fa-light fa-user' => 'user' ),
					array( 'fa-light fa-users-between-lines' => 'users-between-lines' ),
					array( 'fa-light fa-users-gear' => 'users-gear' ),
					array( 'fa-light fa-users-line' => 'users-line' ),
					array( 'fa-light fa-users-medical' => 'users-medical' ),
					array( 'fa-light fa-users-rays' => 'users-rays' ),
					array( 'fa-light fa-users-rectangle' => 'users-rectangle' ),
					array( 'fa-light fa-users-slash' => 'users-slash' ),
					array( 'fa-light fa-users-viewfinder' => 'users-viewfinder' ),
					array( 'fa-light fa-users' => 'users' ),
					array( 'fa-light fa-utensils-slash' => 'utensils-slash' ),
					array( 'fa-light fa-utensils' => 'utensils' ),
					array( 'fa-light fa-utility-pole-double' => 'utility-pole-double' ),
					array( 'fa-light fa-utility-pole' => 'utility-pole' ),
					array( 'fa-light fa-v' => 'v' ),
					array( 'fa-light fa-vacuum-robot' => 'vacuum-robot' ),
					array( 'fa-light fa-vacuum' => 'vacuum' ),
					array( 'fa-light fa-value-absolute' => 'value-absolute' ),
					array( 'fa-light fa-van-shuttle' => 'van-shuttle' ),
					array( 'fa-light fa-vault' => 'vault' ),
					array( 'fa-light fa-vector-circle' => 'vector-circle' ),
					array( 'fa-light fa-vector-polygon' => 'vector-polygon' ),
					array( 'fa-light fa-vector-square' => 'vector-square' ),
					array( 'fa-light fa-vent-damper' => 'vent-damper' ),
					array( 'fa-light fa-venus-double' => 'venus-double' ),
					array( 'fa-light fa-venus-mars' => 'venus-mars' ),
					array( 'fa-light fa-venus' => 'venus' ),
					array( 'fa-light fa-vest-patches' => 'vest-patches' ),
					array( 'fa-light fa-vest' => 'vest' ),
					array( 'fa-light fa-vial-circle-check' => 'vial-circle-check' ),
					array( 'fa-light fa-vial-virus' => 'vial-virus' ),
					array( 'fa-light fa-vial' => 'vial' ),
					array( 'fa-light fa-vials' => 'vials' ),
					array( 'fa-light fa-video-arrow-down-left' => 'video-arrow-down-left' ),
					array( 'fa-light fa-video-arrow-up-right' => 'video-arrow-up-right' ),
					array( 'fa-light fa-video-plus' => 'video-plus' ),
					array( 'fa-light fa-video-slash' => 'video-slash' ),
					array( 'fa-light fa-video' => 'video' ),
					array( 'fa-light fa-vihara' => 'vihara' ),
					array( 'fa-light fa-violin' => 'violin' ),
					array( 'fa-light fa-virus-covid-slash' => 'virus-covid-slash' ),
					array( 'fa-light fa-virus-covid' => 'virus-covid' ),
					array( 'fa-light fa-virus-slash' => 'virus-slash' ),
					array( 'fa-light fa-virus' => 'virus' ),
					array( 'fa-light fa-viruses' => 'viruses' ),
					array( 'fa-light fa-voicemail' => 'voicemail' ),
					array( 'fa-light fa-volcano' => 'volcano' ),
					array( 'fa-light fa-volleyball' => 'volleyball' ),
					array( 'fa-light fa-volume-high' => 'volume-high' ),
					array( 'fa-light fa-volume-low' => 'volume-low' ),
					array( 'fa-light fa-volume-off' => 'volume-off' ),
					array( 'fa-light fa-volume-slash' => 'volume-slash' ),
					array( 'fa-light fa-volume-xmark' => 'volume-xmark' ),
					array( 'fa-light fa-volume' => 'volume' ),
					array( 'fa-light fa-vr-cardboard' => 'vr-cardboard' ),
					array( 'fa-light fa-w' => 'w' ),
					array( 'fa-light fa-waffle' => 'waffle' ),
					array( 'fa-light fa-wagon-covered' => 'wagon-covered' ),
					array( 'fa-light fa-walker' => 'walker' ),
					array( 'fa-light fa-walkie-talkie' => 'walkie-talkie' ),
					array( 'fa-light fa-wallet' => 'wallet' ),
					array( 'fa-light fa-wand-magic-sparkles' => 'wand-magic-sparkles' ),
					array( 'fa-light fa-wand-magic' => 'wand-magic' ),
					array( 'fa-light fa-wand-sparkles' => 'wand-sparkles' ),
					array( 'fa-light fa-wand' => 'wand' ),
					array( 'fa-light fa-warehouse-full' => 'warehouse-full' ),
					array( 'fa-light fa-warehouse' => 'warehouse' ),
					array( 'fa-light fa-washing-machine' => 'washing-machine' ),
					array( 'fa-light fa-watch-apple' => 'watch-apple' ),
					array( 'fa-light fa-watch-calculator' => 'watch-calculator' ),
					array( 'fa-light fa-watch-fitness' => 'watch-fitness' ),
					array( 'fa-light fa-watch-smart' => 'watch-smart' ),
					array( 'fa-light fa-watch' => 'watch' ),
					array( 'fa-light fa-water-arrow-down' => 'water-arrow-down' ),
					array( 'fa-light fa-water-arrow-up' => 'water-arrow-up' ),
					array( 'fa-light fa-water-ladder' => 'water-ladder' ),
					array( 'fa-light fa-water' => 'water' ),
					array( 'fa-light fa-watermelon-slice' => 'watermelon-slice' ),
					array( 'fa-light fa-wave-pulse' => 'wave-pulse' ),
					array( 'fa-light fa-wave-sine' => 'wave-sine' ),
					array( 'fa-light fa-wave-square' => 'wave-square' ),
					array( 'fa-light fa-wave-triangle' => 'wave-triangle' ),
					array( 'fa-light fa-waveform-lines' => 'waveform-lines' ),
					array( 'fa-light fa-waveform' => 'waveform' ),
					array( 'fa-light fa-webhook' => 'webhook' ),
					array( 'fa-light fa-weight-hanging' => 'weight-hanging' ),
					array( 'fa-light fa-weight-scale' => 'weight-scale' ),
					array( 'fa-light fa-whale' => 'whale' ),
					array( 'fa-light fa-wheat-awn-circle-exclamation' => 'wheat-awn-circle-exclamation' ),
					array( 'fa-light fa-wheat-awn-slash' => 'wheat-awn-slash' ),
					array( 'fa-light fa-wheat-awn' => 'wheat-awn' ),
					array( 'fa-light fa-wheat-slash' => 'wheat-slash' ),
					array( 'fa-light fa-wheat' => 'wheat' ),
					array( 'fa-light fa-wheelchair-move' => 'wheelchair-move' ),
					array( 'fa-light fa-wheelchair' => 'wheelchair' ),
					array( 'fa-light fa-whiskey-glass-ice' => 'whiskey-glass-ice' ),
					array( 'fa-light fa-whiskey-glass' => 'whiskey-glass' ),
					array( 'fa-light fa-whistle' => 'whistle' ),
					array( 'fa-light fa-wifi-exclamation' => 'wifi-exclamation' ),
					array( 'fa-light fa-wifi-fair' => 'wifi-fair' ),
					array( 'fa-light fa-wifi-slash' => 'wifi-slash' ),
					array( 'fa-light fa-wifi-weak' => 'wifi-weak' ),
					array( 'fa-light fa-wifi' => 'wifi' ),
					array( 'fa-light fa-wind-turbine' => 'wind-turbine' ),
					array( 'fa-light fa-wind-warning' => 'wind-warning' ),
					array( 'fa-light fa-wind' => 'wind' ),
					array( 'fa-light fa-window-flip' => 'window-flip' ),
					array( 'fa-light fa-window-frame-open' => 'window-frame-open' ),
					array( 'fa-light fa-window-frame' => 'window-frame' ),
					array( 'fa-light fa-window-maximize' => 'window-maximize' ),
					array( 'fa-light fa-window-minimize' => 'window-minimize' ),
					array( 'fa-light fa-window-restore' => 'window-restore' ),
					array( 'fa-light fa-window' => 'window' ),
					array( 'fa-light fa-windsock' => 'windsock' ),
					array( 'fa-light fa-wine-bottle' => 'wine-bottle' ),
					array( 'fa-light fa-wine-glass-crack' => 'wine-glass-crack' ),
					array( 'fa-light fa-wine-glass-empty' => 'wine-glass-empty' ),
					array( 'fa-light fa-wine-glass' => 'wine-glass' ),
					array( 'fa-light fa-won-sign' => 'won-sign' ),
					array( 'fa-light fa-worm' => 'worm' ),
					array( 'fa-light fa-wreath-laurel' => 'wreath-laurel' ),
					array( 'fa-light fa-wreath' => 'wreath' ),
					array( 'fa-light fa-wrench-simple' => 'wrench-simple' ),
					array( 'fa-light fa-wrench' => 'wrench' ),
					array( 'fa-light fa-x-ray' => 'x-ray' ),
					array( 'fa-light fa-x' => 'x' ),
					array( 'fa-light fa-xmark-large' => 'xmark-large' ),
					array( 'fa-light fa-xmark-to-slot' => 'xmark-to-slot' ),
					array( 'fa-light fa-xmark' => 'xmark' ),
					array( 'fa-light fa-xmarks-lines' => 'xmarks-lines' ),
					array( 'fa-light fa-y' => 'y' ),
					array( 'fa-light fa-yen-sign' => 'yen-sign' ),
					array( 'fa-light fa-yin-yang' => 'yin-yang' ),
					array( 'fa-light fa-z' => 'z' ),
				),
				esc_html__( 'Thin', 'smilepure' )    => array(
					array( 'fa-thin fa-0' => '0' ),
					array( 'fa-thin fa-00' => '00' ),
					array( 'fa-thin fa-1' => '1' ),
					array( 'fa-thin fa-2' => '2' ),
					array( 'fa-thin fa-3' => '3' ),
					array( 'fa-thin fa-4' => '4' ),
					array( 'fa-thin fa-5' => '5' ),
					array( 'fa-thin fa-6' => '6' ),
					array( 'fa-thin fa-7' => '7' ),
					array( 'fa-thin fa-8' => '8' ),
					array( 'fa-thin fa-9' => '9' ),
					array( 'fa-thin fa-360-degrees' => '360-degrees' ),
					array( 'fa-thin fa-a' => 'a' ),
					array( 'fa-thin fa-abacus' => 'abacus' ),
					array( 'fa-thin fa-accent-grave' => 'accent-grave' ),
					array( 'fa-thin fa-acorn' => 'acorn' ),
					array( 'fa-thin fa-address-book' => 'address-book' ),
					array( 'fa-thin fa-address-card' => 'address-card' ),
					array( 'fa-thin fa-air-conditioner' => 'air-conditioner' ),
					array( 'fa-thin fa-airplay' => 'airplay' ),
					array( 'fa-thin fa-alarm-clock' => 'alarm-clock' ),
					array( 'fa-thin fa-alarm-exclamation' => 'alarm-exclamation' ),
					array( 'fa-thin fa-alarm-plus' => 'alarm-plus' ),
					array( 'fa-thin fa-alarm-snooze' => 'alarm-snooze' ),
					array( 'fa-thin fa-album-circle-plus' => 'album-circle-plus' ),
					array( 'fa-thin fa-album-circle-user' => 'album-circle-user' ),
					array( 'fa-thin fa-album-collection-circle-plus' => 'album-collection-circle-plus' ),
					array( 'fa-thin fa-album-collection-circle-user' => 'album-collection-circle-user' ),
					array( 'fa-thin fa-album-collection' => 'album-collection' ),
					array( 'fa-thin fa-album' => 'album' ),
					array( 'fa-thin fa-alicorn' => 'alicorn' ),
					array( 'fa-thin fa-alien-8bit' => 'alien-8bit' ),
					array( 'fa-thin fa-alien' => 'alien' ),
					array( 'fa-thin fa-align-center' => 'align-center' ),
					array( 'fa-thin fa-align-justify' => 'align-justify' ),
					array( 'fa-thin fa-align-left' => 'align-left' ),
					array( 'fa-thin fa-align-right' => 'align-right' ),
					array( 'fa-thin fa-align-slash' => 'align-slash' ),
					array( 'fa-thin fa-alt' => 'alt' ),
					array( 'fa-thin fa-amp-guitar' => 'amp-guitar' ),
					array( 'fa-thin fa-ampersand' => 'ampersand' ),
					array( 'fa-thin fa-anchor-circle-check' => 'anchor-circle-check' ),
					array( 'fa-thin fa-anchor-circle-exclamation' => 'anchor-circle-exclamation' ),
					array( 'fa-thin fa-anchor-circle-xmark' => 'anchor-circle-xmark' ),
					array( 'fa-thin fa-anchor-lock' => 'anchor-lock' ),
					array( 'fa-thin fa-anchor' => 'anchor' ),
					array( 'fa-thin fa-angel' => 'angel' ),
					array( 'fa-thin fa-angle-90' => 'angle-90' ),
					array( 'fa-thin fa-angle-down' => 'angle-down' ),
					array( 'fa-thin fa-angle-left' => 'angle-left' ),
					array( 'fa-thin fa-angle-right' => 'angle-right' ),
					array( 'fa-thin fa-angle-up' => 'angle-up' ),
					array( 'fa-thin fa-angle' => 'angle' ),
					array( 'fa-thin fa-angles-down' => 'angles-down' ),
					array( 'fa-thin fa-angles-left' => 'angles-left' ),
					array( 'fa-thin fa-angles-right' => 'angles-right' ),
					array( 'fa-thin fa-angles-up-down' => 'angles-up-down' ),
					array( 'fa-thin fa-angles-up' => 'angles-up' ),
					array( 'fa-thin fa-ankh' => 'ankh' ),
					array( 'fa-thin fa-apartment' => 'apartment' ),
					array( 'fa-thin fa-aperture' => 'aperture' ),
					array( 'fa-thin fa-apostrophe' => 'apostrophe' ),
					array( 'fa-thin fa-apple-core' => 'apple-core' ),
					array( 'fa-thin fa-apple-whole' => 'apple-whole' ),
					array( 'fa-thin fa-archway' => 'archway' ),
					array( 'fa-thin fa-arrow-down-1-9' => 'arrow-down-1-9' ),
					array( 'fa-thin fa-arrow-down-9-1' => 'arrow-down-9-1' ),
					array( 'fa-thin fa-arrow-down-a-z' => 'arrow-down-a-z' ),
					array( 'fa-thin fa-arrow-down-arrow-up' => 'arrow-down-arrow-up' ),
					array( 'fa-thin fa-arrow-down-big-small' => 'arrow-down-big-small' ),
					array( 'fa-thin fa-arrow-down-from-arc' => 'arrow-down-from-arc' ),
					array( 'fa-thin fa-arrow-down-from-dotted-line' => 'arrow-down-from-dotted-line' ),
					array( 'fa-thin fa-arrow-down-from-line' => 'arrow-down-from-line' ),
					array( 'fa-thin fa-arrow-down-left-and-arrow-up-right-to-center' => 'arrow-down-left-and-arrow-up-right-to-center' ),
					array( 'fa-thin fa-arrow-down-left' => 'arrow-down-left' ),
					array( 'fa-thin fa-arrow-down-long' => 'arrow-down-long' ),
					array( 'fa-thin fa-arrow-down-right' => 'arrow-down-right' ),
					array( 'fa-thin fa-arrow-down-short-wide' => 'arrow-down-short-wide' ),
					array( 'fa-thin fa-arrow-down-small-big' => 'arrow-down-small-big' ),
					array( 'fa-thin fa-arrow-down-square-triangle' => 'arrow-down-square-triangle' ),
					array( 'fa-thin fa-arrow-down-to-arc' => 'arrow-down-to-arc' ),
					array( 'fa-thin fa-arrow-down-to-bracket' => 'arrow-down-to-bracket' ),
					array( 'fa-thin fa-arrow-down-to-dotted-line' => 'arrow-down-to-dotted-line' ),
					array( 'fa-thin fa-arrow-down-to-line' => 'arrow-down-to-line' ),
					array( 'fa-thin fa-arrow-down-to-square' => 'arrow-down-to-square' ),
					array( 'fa-thin fa-arrow-down-triangle-square' => 'arrow-down-triangle-square' ),
					array( 'fa-thin fa-arrow-down-up-across-line' => 'arrow-down-up-across-line' ),
					array( 'fa-thin fa-arrow-down-up-lock' => 'arrow-down-up-lock' ),
					array( 'fa-thin fa-arrow-down-wide-short' => 'arrow-down-wide-short' ),
					array( 'fa-thin fa-arrow-down-z-a' => 'arrow-down-z-a' ),
					array( 'fa-thin fa-arrow-down' => 'arrow-down' ),
					array( 'fa-thin fa-arrow-left-from-arc' => 'arrow-left-from-arc' ),
					array( 'fa-thin fa-arrow-left-from-line' => 'arrow-left-from-line' ),
					array( 'fa-thin fa-arrow-left-long-to-line' => 'arrow-left-long-to-line' ),
					array( 'fa-thin fa-arrow-left-long' => 'arrow-left-long' ),
					array( 'fa-thin fa-arrow-left-to-arc' => 'arrow-left-to-arc' ),
					array( 'fa-thin fa-arrow-left-to-line' => 'arrow-left-to-line' ),
					array( 'fa-thin fa-arrow-left' => 'arrow-left' ),
					array( 'fa-thin fa-arrow-pointer' => 'arrow-pointer' ),
					array( 'fa-thin fa-arrow-progress' => 'arrow-progress' ),
					array( 'fa-thin fa-arrow-right-arrow-left' => 'arrow-right-arrow-left' ),
					array( 'fa-thin fa-arrow-right-from-arc' => 'arrow-right-from-arc' ),
					array( 'fa-thin fa-arrow-right-from-bracket' => 'arrow-right-from-bracket' ),
					array( 'fa-thin fa-arrow-right-from-line' => 'arrow-right-from-line' ),
					array( 'fa-thin fa-arrow-right-long-to-line' => 'arrow-right-long-to-line' ),
					array( 'fa-thin fa-arrow-right-long' => 'arrow-right-long' ),
					array( 'fa-thin fa-arrow-right-to-arc' => 'arrow-right-to-arc' ),
					array( 'fa-thin fa-arrow-right-to-bracket' => 'arrow-right-to-bracket' ),
					array( 'fa-thin fa-arrow-right-to-city' => 'arrow-right-to-city' ),
					array( 'fa-thin fa-arrow-right-to-line' => 'arrow-right-to-line' ),
					array( 'fa-thin fa-arrow-right' => 'arrow-right' ),
					array( 'fa-thin fa-arrow-rotate-left' => 'arrow-rotate-left' ),
					array( 'fa-thin fa-arrow-rotate-right' => 'arrow-rotate-right' ),
					array( 'fa-thin fa-arrow-trend-down' => 'arrow-trend-down' ),
					array( 'fa-thin fa-arrow-trend-up' => 'arrow-trend-up' ),
					array( 'fa-thin fa-arrow-turn-down-left' => 'arrow-turn-down-left' ),
					array( 'fa-thin fa-arrow-turn-down-right' => 'arrow-turn-down-right' ),
					array( 'fa-thin fa-arrow-turn-down' => 'arrow-turn-down' ),
					array( 'fa-thin fa-arrow-turn-up' => 'arrow-turn-up' ),
					array( 'fa-thin fa-arrow-up-1-9' => 'arrow-up-1-9' ),
					array( 'fa-thin fa-arrow-up-9-1' => 'arrow-up-9-1' ),
					array( 'fa-thin fa-arrow-up-a-z' => 'arrow-up-a-z' ),
					array( 'fa-thin fa-arrow-up-arrow-down' => 'arrow-up-arrow-down' ),
					array( 'fa-thin fa-arrow-up-big-small' => 'arrow-up-big-small' ),
					array( 'fa-thin fa-arrow-up-from-arc' => 'arrow-up-from-arc' ),
					array( 'fa-thin fa-arrow-up-from-bracket' => 'arrow-up-from-bracket' ),
					array( 'fa-thin fa-arrow-up-from-dotted-line' => 'arrow-up-from-dotted-line' ),
					array( 'fa-thin fa-arrow-up-from-ground-water' => 'arrow-up-from-ground-water' ),
					array( 'fa-thin fa-arrow-up-from-line' => 'arrow-up-from-line' ),
					array( 'fa-thin fa-arrow-up-from-square' => 'arrow-up-from-square' ),
					array( 'fa-thin fa-arrow-up-from-water-pump' => 'arrow-up-from-water-pump' ),
					array( 'fa-thin fa-arrow-up-left-from-circle' => 'arrow-up-left-from-circle' ),
					array( 'fa-thin fa-arrow-up-left' => 'arrow-up-left' ),
					array( 'fa-thin fa-arrow-up-long' => 'arrow-up-long' ),
					array( 'fa-thin fa-arrow-up-right-and-arrow-down-left-from-center' => 'arrow-up-right-and-arrow-down-left-from-center' ),
					array( 'fa-thin fa-arrow-up-right-dots' => 'arrow-up-right-dots' ),
					array( 'fa-thin fa-arrow-up-right-from-square' => 'arrow-up-right-from-square' ),
					array( 'fa-thin fa-arrow-up-right' => 'arrow-up-right' ),
					array( 'fa-thin fa-arrow-up-short-wide' => 'arrow-up-short-wide' ),
					array( 'fa-thin fa-arrow-up-small-big' => 'arrow-up-small-big' ),
					array( 'fa-thin fa-arrow-up-square-triangle' => 'arrow-up-square-triangle' ),
					array( 'fa-thin fa-arrow-up-to-arc' => 'arrow-up-to-arc' ),
					array( 'fa-thin fa-arrow-up-to-dotted-line' => 'arrow-up-to-dotted-line' ),
					array( 'fa-thin fa-arrow-up-to-line' => 'arrow-up-to-line' ),
					array( 'fa-thin fa-arrow-up-triangle-square' => 'arrow-up-triangle-square' ),
					array( 'fa-thin fa-arrow-up-wide-short' => 'arrow-up-wide-short' ),
					array( 'fa-thin fa-arrow-up-z-a' => 'arrow-up-z-a' ),
					array( 'fa-thin fa-arrow-up' => 'arrow-up' ),
					array( 'fa-thin fa-arrows-cross' => 'arrows-cross' ),
					array( 'fa-thin fa-arrows-down-to-line' => 'arrows-down-to-line' ),
					array( 'fa-thin fa-arrows-down-to-people' => 'arrows-down-to-people' ),
					array( 'fa-thin fa-arrows-from-dotted-line' => 'arrows-from-dotted-line' ),
					array( 'fa-thin fa-arrows-from-line' => 'arrows-from-line' ),
					array( 'fa-thin fa-arrows-left-right-to-line' => 'arrows-left-right-to-line' ),
					array( 'fa-thin fa-arrows-left-right' => 'arrows-left-right' ),
					array( 'fa-thin fa-arrows-maximize' => 'arrows-maximize' ),
					array( 'fa-thin fa-arrows-minimize' => 'arrows-minimize' ),
					array( 'fa-thin fa-arrows-repeat-1' => 'arrows-repeat-1' ),
					array( 'fa-thin fa-arrows-repeat' => 'arrows-repeat' ),
					array( 'fa-thin fa-arrows-retweet' => 'arrows-retweet' ),
					array( 'fa-thin fa-arrows-rotate' => 'arrows-rotate' ),
					array( 'fa-thin fa-arrows-spin' => 'arrows-spin' ),
					array( 'fa-thin fa-arrows-split-up-and-left' => 'arrows-split-up-and-left' ),
					array( 'fa-thin fa-arrows-to-circle' => 'arrows-to-circle' ),
					array( 'fa-thin fa-arrows-to-dot' => 'arrows-to-dot' ),
					array( 'fa-thin fa-arrows-to-dotted-line' => 'arrows-to-dotted-line' ),
					array( 'fa-thin fa-arrows-to-eye' => 'arrows-to-eye' ),
					array( 'fa-thin fa-arrows-to-line' => 'arrows-to-line' ),
					array( 'fa-thin fa-arrows-turn-right' => 'arrows-turn-right' ),
					array( 'fa-thin fa-arrows-turn-to-dots' => 'arrows-turn-to-dots' ),
					array( 'fa-thin fa-arrows-up-down-left-right' => 'arrows-up-down-left-right' ),
					array( 'fa-thin fa-arrows-up-down' => 'arrows-up-down' ),
					array( 'fa-thin fa-arrows-up-to-line' => 'arrows-up-to-line' ),
					array( 'fa-thin fa-asterisk' => 'asterisk' ),
					array( 'fa-thin fa-at' => 'at' ),
					array( 'fa-thin fa-atom-simple' => 'atom-simple' ),
					array( 'fa-thin fa-atom' => 'atom' ),
					array( 'fa-thin fa-audio-description-slash' => 'audio-description-slash' ),
					array( 'fa-thin fa-audio-description' => 'audio-description' ),
					array( 'fa-thin fa-austral-sign' => 'austral-sign' ),
					array( 'fa-thin fa-avocado' => 'avocado' ),
					array( 'fa-thin fa-award-simple' => 'award-simple' ),
					array( 'fa-thin fa-award' => 'award' ),
					array( 'fa-thin fa-axe-battle' => 'axe-battle' ),
					array( 'fa-thin fa-axe' => 'axe' ),
					array( 'fa-thin fa-b' => 'b' ),
					array( 'fa-thin fa-baby-carriage' => 'baby-carriage' ),
					array( 'fa-thin fa-baby' => 'baby' ),
					array( 'fa-thin fa-backpack' => 'backpack' ),
					array( 'fa-thin fa-backward-fast' => 'backward-fast' ),
					array( 'fa-thin fa-backward-step' => 'backward-step' ),
					array( 'fa-thin fa-backward' => 'backward' ),
					array( 'fa-thin fa-bacon' => 'bacon' ),
					array( 'fa-thin fa-bacteria' => 'bacteria' ),
					array( 'fa-thin fa-bacterium' => 'bacterium' ),
					array( 'fa-thin fa-badge-check' => 'badge-check' ),
					array( 'fa-thin fa-badge-dollar' => 'badge-dollar' ),
					array( 'fa-thin fa-badge-percent' => 'badge-percent' ),
					array( 'fa-thin fa-badge-sheriff' => 'badge-sheriff' ),
					array( 'fa-thin fa-badge' => 'badge' ),
					array( 'fa-thin fa-badger-honey' => 'badger-honey' ),
					array( 'fa-thin fa-badminton' => 'badminton' ),
					array( 'fa-thin fa-bag-seedling' => 'bag-seedling' ),
					array( 'fa-thin fa-bag-shopping' => 'bag-shopping' ),
					array( 'fa-thin fa-bagel' => 'bagel' ),
					array( 'fa-thin fa-bags-shopping' => 'bags-shopping' ),
					array( 'fa-thin fa-baguette' => 'baguette' ),
					array( 'fa-thin fa-bahai' => 'bahai' ),
					array( 'fa-thin fa-baht-sign' => 'baht-sign' ),
					array( 'fa-thin fa-ball-pile' => 'ball-pile' ),
					array( 'fa-thin fa-balloon' => 'balloon' ),
					array( 'fa-thin fa-balloons' => 'balloons' ),
					array( 'fa-thin fa-ballot-check' => 'ballot-check' ),
					array( 'fa-thin fa-ballot' => 'ballot' ),
					array( 'fa-thin fa-ban-bug' => 'ban-bug' ),
					array( 'fa-thin fa-ban-parking' => 'ban-parking' ),
					array( 'fa-thin fa-ban-smoking' => 'ban-smoking' ),
					array( 'fa-thin fa-ban' => 'ban' ),
					array( 'fa-thin fa-banana' => 'banana' ),
					array( 'fa-thin fa-bandage' => 'bandage' ),
					array( 'fa-thin fa-bangladeshi-taka-sign' => 'bangladeshi-taka-sign' ),
					array( 'fa-thin fa-banjo' => 'banjo' ),
					array( 'fa-thin fa-barcode-read' => 'barcode-read' ),
					array( 'fa-thin fa-barcode-scan' => 'barcode-scan' ),
					array( 'fa-thin fa-barcode' => 'barcode' ),
					array( 'fa-thin fa-bars-filter' => 'bars-filter' ),
					array( 'fa-thin fa-bars-progress' => 'bars-progress' ),
					array( 'fa-thin fa-bars-sort' => 'bars-sort' ),
					array( 'fa-thin fa-bars-staggered' => 'bars-staggered' ),
					array( 'fa-thin fa-bars' => 'bars' ),
					array( 'fa-thin fa-baseball-bat-ball' => 'baseball-bat-ball' ),
					array( 'fa-thin fa-baseball' => 'baseball' ),
					array( 'fa-thin fa-basket-shopping-simple' => 'basket-shopping-simple' ),
					array( 'fa-thin fa-basket-shopping' => 'basket-shopping' ),
					array( 'fa-thin fa-basketball-hoop' => 'basketball-hoop' ),
					array( 'fa-thin fa-basketball' => 'basketball' ),
					array( 'fa-thin fa-bat' => 'bat' ),
					array( 'fa-thin fa-bath' => 'bath' ),
					array( 'fa-thin fa-battery-bolt' => 'battery-bolt' ),
					array( 'fa-thin fa-battery-empty' => 'battery-empty' ),
					array( 'fa-thin fa-battery-exclamation' => 'battery-exclamation' ),
					array( 'fa-thin fa-battery-full' => 'battery-full' ),
					array( 'fa-thin fa-battery-half' => 'battery-half' ),
					array( 'fa-thin fa-battery-low' => 'battery-low' ),
					array( 'fa-thin fa-battery-quarter' => 'battery-quarter' ),
					array( 'fa-thin fa-battery-slash' => 'battery-slash' ),
					array( 'fa-thin fa-battery-three-quarters' => 'battery-three-quarters' ),
					array( 'fa-thin fa-bed-bunk' => 'bed-bunk' ),
					array( 'fa-thin fa-bed-empty' => 'bed-empty' ),
					array( 'fa-thin fa-bed-front' => 'bed-front' ),
					array( 'fa-thin fa-bed-pulse' => 'bed-pulse' ),
					array( 'fa-thin fa-bed' => 'bed' ),
					array( 'fa-thin fa-bee' => 'bee' ),
					array( 'fa-thin fa-beer-mug-empty' => 'beer-mug-empty' ),
					array( 'fa-thin fa-beer-mug' => 'beer-mug' ),
					array( 'fa-thin fa-bell-concierge' => 'bell-concierge' ),
					array( 'fa-thin fa-bell-exclamation' => 'bell-exclamation' ),
					array( 'fa-thin fa-bell-on' => 'bell-on' ),
					array( 'fa-thin fa-bell-plus' => 'bell-plus' ),
					array( 'fa-thin fa-bell-school-slash' => 'bell-school-slash' ),
					array( 'fa-thin fa-bell-school' => 'bell-school' ),
					array( 'fa-thin fa-bell-slash' => 'bell-slash' ),
					array( 'fa-thin fa-bell' => 'bell' ),
					array( 'fa-thin fa-bells' => 'bells' ),
					array( 'fa-thin fa-bench-tree' => 'bench-tree' ),
					array( 'fa-thin fa-bezier-curve' => 'bezier-curve' ),
					array( 'fa-thin fa-bicycle' => 'bicycle' ),
					array( 'fa-thin fa-billboard' => 'billboard' ),
					array( 'fa-thin fa-bin-bottles-recycle' => 'bin-bottles-recycle' ),
					array( 'fa-thin fa-bin-bottles' => 'bin-bottles' ),
					array( 'fa-thin fa-bin-recycle' => 'bin-recycle' ),
					array( 'fa-thin fa-binary-circle-check' => 'binary-circle-check' ),
					array( 'fa-thin fa-binary-lock' => 'binary-lock' ),
					array( 'fa-thin fa-binary-slash' => 'binary-slash' ),
					array( 'fa-thin fa-binary' => 'binary' ),
					array( 'fa-thin fa-binoculars' => 'binoculars' ),
					array( 'fa-thin fa-biohazard' => 'biohazard' ),
					array( 'fa-thin fa-bird' => 'bird' ),
					array( 'fa-thin fa-bitcoin-sign' => 'bitcoin-sign' ),
					array( 'fa-thin fa-blanket-fire' => 'blanket-fire' ),
					array( 'fa-thin fa-blanket' => 'blanket' ),
					array( 'fa-thin fa-blender-phone' => 'blender-phone' ),
					array( 'fa-thin fa-blender' => 'blender' ),
					array( 'fa-thin fa-blinds-open' => 'blinds-open' ),
					array( 'fa-thin fa-blinds-raised' => 'blinds-raised' ),
					array( 'fa-thin fa-blinds' => 'blinds' ),
					array( 'fa-thin fa-block-brick-fire' => 'block-brick-fire' ),
					array( 'fa-thin fa-block-brick' => 'block-brick' ),
					array( 'fa-thin fa-block-question' => 'block-question' ),
					array( 'fa-thin fa-block-quote' => 'block-quote' ),
					array( 'fa-thin fa-block' => 'block' ),
					array( 'fa-thin fa-blog' => 'blog' ),
					array( 'fa-thin fa-blueberries' => 'blueberries' ),
					array( 'fa-thin fa-bluetooth' => 'bluetooth' ),
					array( 'fa-thin fa-bold' => 'bold' ),
					array( 'fa-thin fa-bolt-auto' => 'bolt-auto' ),
					array( 'fa-thin fa-bolt-lightning' => 'bolt-lightning' ),
					array( 'fa-thin fa-bolt-slash' => 'bolt-slash' ),
					array( 'fa-thin fa-bolt' => 'bolt' ),
					array( 'fa-thin fa-bomb' => 'bomb' ),
					array( 'fa-thin fa-bone-break' => 'bone-break' ),
					array( 'fa-thin fa-bone' => 'bone' ),
					array( 'fa-thin fa-bong' => 'bong' ),
					array( 'fa-thin fa-book-arrow-right' => 'book-arrow-right' ),
					array( 'fa-thin fa-book-arrow-up' => 'book-arrow-up' ),
					array( 'fa-thin fa-book-atlas' => 'book-atlas' ),
					array( 'fa-thin fa-book-bible' => 'book-bible' ),
					array( 'fa-thin fa-book-blank' => 'book-blank' ),
					array( 'fa-thin fa-book-bookmark' => 'book-bookmark' ),
					array( 'fa-thin fa-book-circle-arrow-right' => 'book-circle-arrow-right' ),
					array( 'fa-thin fa-book-circle-arrow-up' => 'book-circle-arrow-up' ),
					array( 'fa-thin fa-book-copy' => 'book-copy' ),
					array( 'fa-thin fa-book-font' => 'book-font' ),
					array( 'fa-thin fa-book-heart' => 'book-heart' ),
					array( 'fa-thin fa-book-journal-whills' => 'book-journal-whills' ),
					array( 'fa-thin fa-book-medical' => 'book-medical' ),
					array( 'fa-thin fa-book-open-cover' => 'book-open-cover' ),
					array( 'fa-thin fa-book-open-reader' => 'book-open-reader' ),
					array( 'fa-thin fa-book-open' => 'book-open' ),
					array( 'fa-thin fa-book-quran' => 'book-quran' ),
					array( 'fa-thin fa-book-section' => 'book-section' ),
					array( 'fa-thin fa-book-skull' => 'book-skull' ),
					array( 'fa-thin fa-book-sparkles' => 'book-sparkles' ),
					array( 'fa-thin fa-book-tanakh' => 'book-tanakh' ),
					array( 'fa-thin fa-book-user' => 'book-user' ),
					array( 'fa-thin fa-book' => 'book' ),
					array( 'fa-thin fa-bookmark-slash' => 'bookmark-slash' ),
					array( 'fa-thin fa-bookmark' => 'bookmark' ),
					array( 'fa-thin fa-books-medical' => 'books-medical' ),
					array( 'fa-thin fa-books' => 'books' ),
					array( 'fa-thin fa-boombox' => 'boombox' ),
					array( 'fa-thin fa-boot-heeled' => 'boot-heeled' ),
					array( 'fa-thin fa-boot' => 'boot' ),
					array( 'fa-thin fa-booth-curtain' => 'booth-curtain' ),
					array( 'fa-thin fa-border-all' => 'border-all' ),
					array( 'fa-thin fa-border-bottom-right' => 'border-bottom-right' ),
					array( 'fa-thin fa-border-bottom' => 'border-bottom' ),
					array( 'fa-thin fa-border-center-h' => 'border-center-h' ),
					array( 'fa-thin fa-border-center-v' => 'border-center-v' ),
					array( 'fa-thin fa-border-inner' => 'border-inner' ),
					array( 'fa-thin fa-border-left' => 'border-left' ),
					array( 'fa-thin fa-border-none' => 'border-none' ),
					array( 'fa-thin fa-border-outer' => 'border-outer' ),
					array( 'fa-thin fa-border-right' => 'border-right' ),
					array( 'fa-thin fa-border-top-left' => 'border-top-left' ),
					array( 'fa-thin fa-border-top' => 'border-top' ),
					array( 'fa-thin fa-bore-hole' => 'bore-hole' ),
					array( 'fa-thin fa-bottle-droplet' => 'bottle-droplet' ),
					array( 'fa-thin fa-bottle-water' => 'bottle-water' ),
					array( 'fa-thin fa-bow-arrow' => 'bow-arrow' ),
					array( 'fa-thin fa-bowl-chopsticks-noodles' => 'bowl-chopsticks-noodles' ),
					array( 'fa-thin fa-bowl-chopsticks' => 'bowl-chopsticks' ),
					array( 'fa-thin fa-bowl-food' => 'bowl-food' ),
					array( 'fa-thin fa-bowl-hot' => 'bowl-hot' ),
					array( 'fa-thin fa-bowl-rice' => 'bowl-rice' ),
					array( 'fa-thin fa-bowl-scoop' => 'bowl-scoop' ),
					array( 'fa-thin fa-bowl-scoops' => 'bowl-scoops' ),
					array( 'fa-thin fa-bowl-soft-serve' => 'bowl-soft-serve' ),
					array( 'fa-thin fa-bowl-spoon' => 'bowl-spoon' ),
					array( 'fa-thin fa-bowling-ball-pin' => 'bowling-ball-pin' ),
					array( 'fa-thin fa-bowling-ball' => 'bowling-ball' ),
					array( 'fa-thin fa-bowling-pins' => 'bowling-pins' ),
					array( 'fa-thin fa-box-archive' => 'box-archive' ),
					array( 'fa-thin fa-box-ballot' => 'box-ballot' ),
					array( 'fa-thin fa-box-check' => 'box-check' ),
					array( 'fa-thin fa-box-circle-check' => 'box-circle-check' ),
					array( 'fa-thin fa-box-dollar' => 'box-dollar' ),
					array( 'fa-thin fa-box-heart' => 'box-heart' ),
					array( 'fa-thin fa-box-open-full' => 'box-open-full' ),
					array( 'fa-thin fa-box-open' => 'box-open' ),
					array( 'fa-thin fa-box-taped' => 'box-taped' ),
					array( 'fa-thin fa-box-tissue' => 'box-tissue' ),
					array( 'fa-thin fa-box' => 'box' ),
					array( 'fa-thin fa-boxes-packing' => 'boxes-packing' ),
					array( 'fa-thin fa-boxes-stacked' => 'boxes-stacked' ),
					array( 'fa-thin fa-boxing-glove' => 'boxing-glove' ),
					array( 'fa-thin fa-bracket-curly-right' => 'bracket-curly-right' ),
					array( 'fa-thin fa-bracket-curly' => 'bracket-curly' ),
					array( 'fa-thin fa-bracket-round-right' => 'bracket-round-right' ),
					array( 'fa-thin fa-bracket-round' => 'bracket-round' ),
					array( 'fa-thin fa-bracket-square-right' => 'bracket-square-right' ),
					array( 'fa-thin fa-bracket-square' => 'bracket-square' ),
					array( 'fa-thin fa-brackets-curly' => 'brackets-curly' ),
					array( 'fa-thin fa-brackets-round' => 'brackets-round' ),
					array( 'fa-thin fa-brackets-square' => 'brackets-square' ),
					array( 'fa-thin fa-braille' => 'braille' ),
					array( 'fa-thin fa-brain-arrow-curved-right' => 'brain-arrow-curved-right' ),
					array( 'fa-thin fa-brain-circuit' => 'brain-circuit' ),
					array( 'fa-thin fa-brain' => 'brain' ),
					array( 'fa-thin fa-brake-warning' => 'brake-warning' ),
					array( 'fa-thin fa-brazilian-real-sign' => 'brazilian-real-sign' ),
					array( 'fa-thin fa-bread-loaf' => 'bread-loaf' ),
					array( 'fa-thin fa-bread-slice-butter' => 'bread-slice-butter' ),
					array( 'fa-thin fa-bread-slice' => 'bread-slice' ),
					array( 'fa-thin fa-bridge-circle-check' => 'bridge-circle-check' ),
					array( 'fa-thin fa-bridge-circle-exclamation' => 'bridge-circle-exclamation' ),
					array( 'fa-thin fa-bridge-circle-xmark' => 'bridge-circle-xmark' ),
					array( 'fa-thin fa-bridge-lock' => 'bridge-lock' ),
					array( 'fa-thin fa-bridge-suspension' => 'bridge-suspension' ),
					array( 'fa-thin fa-bridge-water' => 'bridge-water' ),
					array( 'fa-thin fa-bridge' => 'bridge' ),
					array( 'fa-thin fa-briefcase-arrow-right' => 'briefcase-arrow-right' ),
					array( 'fa-thin fa-briefcase-blank' => 'briefcase-blank' ),
					array( 'fa-thin fa-briefcase-medical' => 'briefcase-medical' ),
					array( 'fa-thin fa-briefcase' => 'briefcase' ),
					array( 'fa-thin fa-brightness-low' => 'brightness-low' ),
					array( 'fa-thin fa-brightness' => 'brightness' ),
					array( 'fa-thin fa-bring-forward' => 'bring-forward' ),
					array( 'fa-thin fa-bring-front' => 'bring-front' ),
					array( 'fa-thin fa-broccoli' => 'broccoli' ),
					array( 'fa-thin fa-broom-ball' => 'broom-ball' ),
					array( 'fa-thin fa-broom-wide' => 'broom-wide' ),
					array( 'fa-thin fa-broom' => 'broom' ),
					array( 'fa-thin fa-browser' => 'browser' ),
					array( 'fa-thin fa-browsers' => 'browsers' ),
					array( 'fa-thin fa-brush' => 'brush' ),
					array( 'fa-thin fa-bucket' => 'bucket' ),
					array( 'fa-thin fa-bug-slash' => 'bug-slash' ),
					array( 'fa-thin fa-bug' => 'bug' ),
					array( 'fa-thin fa-bugs' => 'bugs' ),
					array( 'fa-thin fa-building-circle-arrow-right' => 'building-circle-arrow-right' ),
					array( 'fa-thin fa-building-circle-check' => 'building-circle-check' ),
					array( 'fa-thin fa-building-circle-exclamation' => 'building-circle-exclamation' ),
					array( 'fa-thin fa-building-circle-xmark' => 'building-circle-xmark' ),
					array( 'fa-thin fa-building-columns' => 'building-columns' ),
					array( 'fa-thin fa-building-flag' => 'building-flag' ),
					array( 'fa-thin fa-building-lock' => 'building-lock' ),
					array( 'fa-thin fa-building-ngo' => 'building-ngo' ),
					array( 'fa-thin fa-building-shield' => 'building-shield' ),
					array( 'fa-thin fa-building-un' => 'building-un' ),
					array( 'fa-thin fa-building-user' => 'building-user' ),
					array( 'fa-thin fa-building-wheat' => 'building-wheat' ),
					array( 'fa-thin fa-building' => 'building' ),
					array( 'fa-thin fa-buildings' => 'buildings' ),
					array( 'fa-thin fa-bullhorn' => 'bullhorn' ),
					array( 'fa-thin fa-bullseye-arrow' => 'bullseye-arrow' ),
					array( 'fa-thin fa-bullseye-pointer' => 'bullseye-pointer' ),
					array( 'fa-thin fa-bullseye' => 'bullseye' ),
					array( 'fa-thin fa-buoy-mooring' => 'buoy-mooring' ),
					array( 'fa-thin fa-buoy' => 'buoy' ),
					array( 'fa-thin fa-burger-cheese' => 'burger-cheese' ),
					array( 'fa-thin fa-burger-fries' => 'burger-fries' ),
					array( 'fa-thin fa-burger-glass' => 'burger-glass' ),
					array( 'fa-thin fa-burger-lettuce' => 'burger-lettuce' ),
					array( 'fa-thin fa-burger-soda' => 'burger-soda' ),
					array( 'fa-thin fa-burger' => 'burger' ),
					array( 'fa-thin fa-burrito' => 'burrito' ),
					array( 'fa-thin fa-burst' => 'burst' ),
					array( 'fa-thin fa-bus-school' => 'bus-school' ),
					array( 'fa-thin fa-bus-simple' => 'bus-simple' ),
					array( 'fa-thin fa-bus' => 'bus' ),
					array( 'fa-thin fa-business-time' => 'business-time' ),
					array( 'fa-thin fa-butter' => 'butter' ),
					array( 'fa-thin fa-c' => 'c' ),
					array( 'fa-thin fa-cabin' => 'cabin' ),
					array( 'fa-thin fa-cabinet-filing' => 'cabinet-filing' ),
					array( 'fa-thin fa-cable-car' => 'cable-car' ),
					array( 'fa-thin fa-cactus' => 'cactus' ),
					array( 'fa-thin fa-cake-candles' => 'cake-candles' ),
					array( 'fa-thin fa-cake-slice' => 'cake-slice' ),
					array( 'fa-thin fa-calculator-simple' => 'calculator-simple' ),
					array( 'fa-thin fa-calculator' => 'calculator' ),
					array( 'fa-thin fa-calendar-arrow-down' => 'calendar-arrow-down' ),
					array( 'fa-thin fa-calendar-arrow-up' => 'calendar-arrow-up' ),
					array( 'fa-thin fa-calendar-check' => 'calendar-check' ),
					array( 'fa-thin fa-calendar-circle-exclamation' => 'calendar-circle-exclamation' ),
					array( 'fa-thin fa-calendar-circle-minus' => 'calendar-circle-minus' ),
					array( 'fa-thin fa-calendar-circle-plus' => 'calendar-circle-plus' ),
					array( 'fa-thin fa-calendar-circle-user' => 'calendar-circle-user' ),
					array( 'fa-thin fa-calendar-clock' => 'calendar-clock' ),
					array( 'fa-thin fa-calendar-day' => 'calendar-day' ),
					array( 'fa-thin fa-calendar-days' => 'calendar-days' ),
					array( 'fa-thin fa-calendar-exclamation' => 'calendar-exclamation' ),
					array( 'fa-thin fa-calendar-heart' => 'calendar-heart' ),
					array( 'fa-thin fa-calendar-image' => 'calendar-image' ),
					array( 'fa-thin fa-calendar-lines-pen' => 'calendar-lines-pen' ),
					array( 'fa-thin fa-calendar-lines' => 'calendar-lines' ),
					array( 'fa-thin fa-calendar-minus' => 'calendar-minus' ),
					array( 'fa-thin fa-calendar-pen' => 'calendar-pen' ),
					array( 'fa-thin fa-calendar-plus' => 'calendar-plus' ),
					array( 'fa-thin fa-calendar-range' => 'calendar-range' ),
					array( 'fa-thin fa-calendar-star' => 'calendar-star' ),
					array( 'fa-thin fa-calendar-users' => 'calendar-users' ),
					array( 'fa-thin fa-calendar-week' => 'calendar-week' ),
					array( 'fa-thin fa-calendar-xmark' => 'calendar-xmark' ),
					array( 'fa-thin fa-calendar' => 'calendar' ),
					array( 'fa-thin fa-calendars' => 'calendars' ),
					array( 'fa-thin fa-camcorder' => 'camcorder' ),
					array( 'fa-thin fa-camera-cctv' => 'camera-cctv' ),
					array( 'fa-thin fa-camera-movie' => 'camera-movie' ),
					array( 'fa-thin fa-camera-polaroid' => 'camera-polaroid' ),
					array( 'fa-thin fa-camera-retro' => 'camera-retro' ),
					array( 'fa-thin fa-camera-rotate' => 'camera-rotate' ),
					array( 'fa-thin fa-camera-security' => 'camera-security' ),
					array( 'fa-thin fa-camera-slash' => 'camera-slash' ),
					array( 'fa-thin fa-camera-viewfinder' => 'camera-viewfinder' ),
					array( 'fa-thin fa-camera-web-slash' => 'camera-web-slash' ),
					array( 'fa-thin fa-camera-web' => 'camera-web' ),
					array( 'fa-thin fa-camera' => 'camera' ),
					array( 'fa-thin fa-campfire' => 'campfire' ),
					array( 'fa-thin fa-campground' => 'campground' ),
					array( 'fa-thin fa-can-food' => 'can-food' ),
					array( 'fa-thin fa-candle-holder' => 'candle-holder' ),
					array( 'fa-thin fa-candy-bar' => 'candy-bar' ),
					array( 'fa-thin fa-candy-cane' => 'candy-cane' ),
					array( 'fa-thin fa-candy-corn' => 'candy-corn' ),
					array( 'fa-thin fa-candy' => 'candy' ),
					array( 'fa-thin fa-cannabis' => 'cannabis' ),
					array( 'fa-thin fa-capsules' => 'capsules' ),
					array( 'fa-thin fa-car-battery' => 'car-battery' ),
					array( 'fa-thin fa-car-bolt' => 'car-bolt' ),
					array( 'fa-thin fa-car-building' => 'car-building' ),
					array( 'fa-thin fa-car-bump' => 'car-bump' ),
					array( 'fa-thin fa-car-burst' => 'car-burst' ),
					array( 'fa-thin fa-car-bus' => 'car-bus' ),
					array( 'fa-thin fa-car-circle-bolt' => 'car-circle-bolt' ),
					array( 'fa-thin fa-car-garage' => 'car-garage' ),
					array( 'fa-thin fa-car-mirrors' => 'car-mirrors' ),
					array( 'fa-thin fa-car-on' => 'car-on' ),
					array( 'fa-thin fa-car-rear' => 'car-rear' ),
					array( 'fa-thin fa-car-side-bolt' => 'car-side-bolt' ),
					array( 'fa-thin fa-car-side' => 'car-side' ),
					array( 'fa-thin fa-car-tilt' => 'car-tilt' ),
					array( 'fa-thin fa-car-tunnel' => 'car-tunnel' ),
					array( 'fa-thin fa-car-wash' => 'car-wash' ),
					array( 'fa-thin fa-car-wrench' => 'car-wrench' ),
					array( 'fa-thin fa-car' => 'car' ),
					array( 'fa-thin fa-caravan-simple' => 'caravan-simple' ),
					array( 'fa-thin fa-caravan' => 'caravan' ),
					array( 'fa-thin fa-card-club' => 'card-club' ),
					array( 'fa-thin fa-card-diamond' => 'card-diamond' ),
					array( 'fa-thin fa-card-heart' => 'card-heart' ),
					array( 'fa-thin fa-card-spade' => 'card-spade' ),
					array( 'fa-thin fa-cards-blank' => 'cards-blank' ),
					array( 'fa-thin fa-cards' => 'cards' ),
					array( 'fa-thin fa-caret-down' => 'caret-down' ),
					array( 'fa-thin fa-caret-left' => 'caret-left' ),
					array( 'fa-thin fa-caret-right' => 'caret-right' ),
					array( 'fa-thin fa-caret-up' => 'caret-up' ),
					array( 'fa-thin fa-carrot' => 'carrot' ),
					array( 'fa-thin fa-cars' => 'cars' ),
					array( 'fa-thin fa-cart-arrow-down' => 'cart-arrow-down' ),
					array( 'fa-thin fa-cart-arrow-up' => 'cart-arrow-up' ),
					array( 'fa-thin fa-cart-circle-arrow-down' => 'cart-circle-arrow-down' ),
					array( 'fa-thin fa-cart-circle-arrow-up' => 'cart-circle-arrow-up' ),
					array( 'fa-thin fa-cart-circle-check' => 'cart-circle-check' ),
					array( 'fa-thin fa-cart-circle-exclamation' => 'cart-circle-exclamation' ),
					array( 'fa-thin fa-cart-circle-plus' => 'cart-circle-plus' ),
					array( 'fa-thin fa-cart-circle-xmark' => 'cart-circle-xmark' ),
					array( 'fa-thin fa-cart-flatbed-boxes' => 'cart-flatbed-boxes' ),
					array( 'fa-thin fa-cart-flatbed-empty' => 'cart-flatbed-empty' ),
					array( 'fa-thin fa-cart-flatbed-suitcase' => 'cart-flatbed-suitcase' ),
					array( 'fa-thin fa-cart-flatbed' => 'cart-flatbed' ),
					array( 'fa-thin fa-cart-minus' => 'cart-minus' ),
					array( 'fa-thin fa-cart-plus' => 'cart-plus' ),
					array( 'fa-thin fa-cart-shopping-fast' => 'cart-shopping-fast' ),
					array( 'fa-thin fa-cart-shopping' => 'cart-shopping' ),
					array( 'fa-thin fa-cart-xmark' => 'cart-xmark' ),
					array( 'fa-thin fa-cash-register' => 'cash-register' ),
					array( 'fa-thin fa-cassette-betamax' => 'cassette-betamax' ),
					array( 'fa-thin fa-cassette-tape' => 'cassette-tape' ),
					array( 'fa-thin fa-cassette-vhs' => 'cassette-vhs' ),
					array( 'fa-thin fa-castle' => 'castle' ),
					array( 'fa-thin fa-cat-space' => 'cat-space' ),
					array( 'fa-thin fa-cat' => 'cat' ),
					array( 'fa-thin fa-cauldron' => 'cauldron' ),
					array( 'fa-thin fa-cedi-sign' => 'cedi-sign' ),
					array( 'fa-thin fa-cent-sign' => 'cent-sign' ),
					array( 'fa-thin fa-certificate' => 'certificate' ),
					array( 'fa-thin fa-chair-office' => 'chair-office' ),
					array( 'fa-thin fa-chair' => 'chair' ),
					array( 'fa-thin fa-chalkboard-user' => 'chalkboard-user' ),
					array( 'fa-thin fa-chalkboard' => 'chalkboard' ),
					array( 'fa-thin fa-champagne-glass' => 'champagne-glass' ),
					array( 'fa-thin fa-champagne-glasses' => 'champagne-glasses' ),
					array( 'fa-thin fa-charging-station' => 'charging-station' ),
					array( 'fa-thin fa-chart-area' => 'chart-area' ),
					array( 'fa-thin fa-chart-bar' => 'chart-bar' ),
					array( 'fa-thin fa-chart-bullet' => 'chart-bullet' ),
					array( 'fa-thin fa-chart-candlestick' => 'chart-candlestick' ),
					array( 'fa-thin fa-chart-column' => 'chart-column' ),
					array( 'fa-thin fa-chart-gantt' => 'chart-gantt' ),
					array( 'fa-thin fa-chart-line-down' => 'chart-line-down' ),
					array( 'fa-thin fa-chart-line-up-down' => 'chart-line-up-down' ),
					array( 'fa-thin fa-chart-line-up' => 'chart-line-up' ),
					array( 'fa-thin fa-chart-line' => 'chart-line' ),
					array( 'fa-thin fa-chart-mixed-up-circle-currency' => 'chart-mixed-up-circle-currency' ),
					array( 'fa-thin fa-chart-mixed-up-circle-dollar' => 'chart-mixed-up-circle-dollar' ),
					array( 'fa-thin fa-chart-mixed' => 'chart-mixed' ),
					array( 'fa-thin fa-chart-network' => 'chart-network' ),
					array( 'fa-thin fa-chart-pie-simple-circle-currency' => 'chart-pie-simple-circle-currency' ),
					array( 'fa-thin fa-chart-pie-simple-circle-dollar' => 'chart-pie-simple-circle-dollar' ),
					array( 'fa-thin fa-chart-pie-simple' => 'chart-pie-simple' ),
					array( 'fa-thin fa-chart-pie' => 'chart-pie' ),
					array( 'fa-thin fa-chart-pyramid' => 'chart-pyramid' ),
					array( 'fa-thin fa-chart-radar' => 'chart-radar' ),
					array( 'fa-thin fa-chart-scatter-3d' => 'chart-scatter-3d' ),
					array( 'fa-thin fa-chart-scatter-bubble' => 'chart-scatter-bubble' ),
					array( 'fa-thin fa-chart-scatter' => 'chart-scatter' ),
					array( 'fa-thin fa-chart-simple-horizontal' => 'chart-simple-horizontal' ),
					array( 'fa-thin fa-chart-simple' => 'chart-simple' ),
					array( 'fa-thin fa-chart-tree-map' => 'chart-tree-map' ),
					array( 'fa-thin fa-chart-user' => 'chart-user' ),
					array( 'fa-thin fa-chart-waterfall' => 'chart-waterfall' ),
					array( 'fa-thin fa-check-double' => 'check-double' ),
					array( 'fa-thin fa-check-to-slot' => 'check-to-slot' ),
					array( 'fa-thin fa-check' => 'check' ),
					array( 'fa-thin fa-cheese-swiss' => 'cheese-swiss' ),
					array( 'fa-thin fa-cheese' => 'cheese' ),
					array( 'fa-thin fa-cherries' => 'cherries' ),
					array( 'fa-thin fa-chess-bishop-piece' => 'chess-bishop-piece' ),
					array( 'fa-thin fa-chess-bishop' => 'chess-bishop' ),
					array( 'fa-thin fa-chess-board' => 'chess-board' ),
					array( 'fa-thin fa-chess-clock-flip' => 'chess-clock-flip' ),
					array( 'fa-thin fa-chess-clock' => 'chess-clock' ),
					array( 'fa-thin fa-chess-king-piece' => 'chess-king-piece' ),
					array( 'fa-thin fa-chess-king' => 'chess-king' ),
					array( 'fa-thin fa-chess-knight-piece' => 'chess-knight-piece' ),
					array( 'fa-thin fa-chess-knight' => 'chess-knight' ),
					array( 'fa-thin fa-chess-pawn-piece' => 'chess-pawn-piece' ),
					array( 'fa-thin fa-chess-pawn' => 'chess-pawn' ),
					array( 'fa-thin fa-chess-queen-piece' => 'chess-queen-piece' ),
					array( 'fa-thin fa-chess-queen' => 'chess-queen' ),
					array( 'fa-thin fa-chess-rook-piece' => 'chess-rook-piece' ),
					array( 'fa-thin fa-chess-rook' => 'chess-rook' ),
					array( 'fa-thin fa-chess' => 'chess' ),
					array( 'fa-thin fa-chestnut' => 'chestnut' ),
					array( 'fa-thin fa-chevron-down' => 'chevron-down' ),
					array( 'fa-thin fa-chevron-left' => 'chevron-left' ),
					array( 'fa-thin fa-chevron-right' => 'chevron-right' ),
					array( 'fa-thin fa-chevron-up' => 'chevron-up' ),
					array( 'fa-thin fa-chevrons-down' => 'chevrons-down' ),
					array( 'fa-thin fa-chevrons-left' => 'chevrons-left' ),
					array( 'fa-thin fa-chevrons-right' => 'chevrons-right' ),
					array( 'fa-thin fa-chevrons-up' => 'chevrons-up' ),
					array( 'fa-thin fa-chf-sign' => 'chf-sign' ),
					array( 'fa-thin fa-child-combatant' => 'child-combatant' ),
					array( 'fa-thin fa-child-dress' => 'child-dress' ),
					array( 'fa-thin fa-child-reaching' => 'child-reaching' ),
					array( 'fa-thin fa-child' => 'child' ),
					array( 'fa-thin fa-children' => 'children' ),
					array( 'fa-thin fa-chimney' => 'chimney' ),
					array( 'fa-thin fa-chopsticks' => 'chopsticks' ),
					array( 'fa-thin fa-church' => 'church' ),
					array( 'fa-thin fa-circle-0' => 'circle-0' ),
					array( 'fa-thin fa-circle-1' => 'circle-1' ),
					array( 'fa-thin fa-circle-2' => 'circle-2' ),
					array( 'fa-thin fa-circle-3' => 'circle-3' ),
					array( 'fa-thin fa-circle-4' => 'circle-4' ),
					array( 'fa-thin fa-circle-5' => 'circle-5' ),
					array( 'fa-thin fa-circle-6' => 'circle-6' ),
					array( 'fa-thin fa-circle-7' => 'circle-7' ),
					array( 'fa-thin fa-circle-8' => 'circle-8' ),
					array( 'fa-thin fa-circle-9' => 'circle-9' ),
					array( 'fa-thin fa-circle-a' => 'circle-a' ),
					array( 'fa-thin fa-circle-ampersand' => 'circle-ampersand' ),
					array( 'fa-thin fa-circle-arrow-down-left' => 'circle-arrow-down-left' ),
					array( 'fa-thin fa-circle-arrow-down-right' => 'circle-arrow-down-right' ),
					array( 'fa-thin fa-circle-arrow-down' => 'circle-arrow-down' ),
					array( 'fa-thin fa-circle-arrow-left' => 'circle-arrow-left' ),
					array( 'fa-thin fa-circle-arrow-right' => 'circle-arrow-right' ),
					array( 'fa-thin fa-circle-arrow-up-left' => 'circle-arrow-up-left' ),
					array( 'fa-thin fa-circle-arrow-up-right' => 'circle-arrow-up-right' ),
					array( 'fa-thin fa-circle-arrow-up' => 'circle-arrow-up' ),
					array( 'fa-thin fa-circle-b' => 'circle-b' ),
					array( 'fa-thin fa-circle-bolt' => 'circle-bolt' ),
					array( 'fa-thin fa-circle-book-open' => 'circle-book-open' ),
					array( 'fa-thin fa-circle-bookmark' => 'circle-bookmark' ),
					array( 'fa-thin fa-circle-c' => 'circle-c' ),
					array( 'fa-thin fa-circle-calendar' => 'circle-calendar' ),
					array( 'fa-thin fa-circle-camera' => 'circle-camera' ),
					array( 'fa-thin fa-circle-caret-down' => 'circle-caret-down' ),
					array( 'fa-thin fa-circle-caret-left' => 'circle-caret-left' ),
					array( 'fa-thin fa-circle-caret-right' => 'circle-caret-right' ),
					array( 'fa-thin fa-circle-caret-up' => 'circle-caret-up' ),
					array( 'fa-thin fa-circle-check' => 'circle-check' ),
					array( 'fa-thin fa-circle-chevron-down' => 'circle-chevron-down' ),
					array( 'fa-thin fa-circle-chevron-left' => 'circle-chevron-left' ),
					array( 'fa-thin fa-circle-chevron-right' => 'circle-chevron-right' ),
					array( 'fa-thin fa-circle-chevron-up' => 'circle-chevron-up' ),
					array( 'fa-thin fa-circle-d' => 'circle-d' ),
					array( 'fa-thin fa-circle-dashed' => 'circle-dashed' ),
					array( 'fa-thin fa-circle-divide' => 'circle-divide' ),
					array( 'fa-thin fa-circle-dollar-to-slot' => 'circle-dollar-to-slot' ),
					array( 'fa-thin fa-circle-dollar' => 'circle-dollar' ),
					array( 'fa-thin fa-circle-dot' => 'circle-dot' ),
					array( 'fa-thin fa-circle-down-left' => 'circle-down-left' ),
					array( 'fa-thin fa-circle-down-right' => 'circle-down-right' ),
					array( 'fa-thin fa-circle-down' => 'circle-down' ),
					array( 'fa-thin fa-circle-e' => 'circle-e' ),
					array( 'fa-thin fa-circle-ellipsis-vertical' => 'circle-ellipsis-vertical' ),
					array( 'fa-thin fa-circle-ellipsis' => 'circle-ellipsis' ),
					array( 'fa-thin fa-circle-envelope' => 'circle-envelope' ),
					array( 'fa-thin fa-circle-euro' => 'circle-euro' ),
					array( 'fa-thin fa-circle-exclamation-check' => 'circle-exclamation-check' ),
					array( 'fa-thin fa-circle-exclamation' => 'circle-exclamation' ),
					array( 'fa-thin fa-circle-f' => 'circle-f' ),
					array( 'fa-thin fa-circle-g' => 'circle-g' ),
					array( 'fa-thin fa-circle-h' => 'circle-h' ),
					array( 'fa-thin fa-circle-half-stroke' => 'circle-half-stroke' ),
					array( 'fa-thin fa-circle-half' => 'circle-half' ),
					array( 'fa-thin fa-circle-heart' => 'circle-heart' ),
					array( 'fa-thin fa-circle-i' => 'circle-i' ),
					array( 'fa-thin fa-circle-info' => 'circle-info' ),
					array( 'fa-thin fa-circle-j' => 'circle-j' ),
					array( 'fa-thin fa-circle-k' => 'circle-k' ),
					array( 'fa-thin fa-circle-l' => 'circle-l' ),
					array( 'fa-thin fa-circle-left' => 'circle-left' ),
					array( 'fa-thin fa-circle-location-arrow' => 'circle-location-arrow' ),
					array( 'fa-thin fa-circle-m' => 'circle-m' ),
					array( 'fa-thin fa-circle-microphone-lines' => 'circle-microphone-lines' ),
					array( 'fa-thin fa-circle-microphone' => 'circle-microphone' ),
					array( 'fa-thin fa-circle-minus' => 'circle-minus' ),
					array( 'fa-thin fa-circle-n' => 'circle-n' ),
					array( 'fa-thin fa-circle-nodes' => 'circle-nodes' ),
					array( 'fa-thin fa-circle-notch' => 'circle-notch' ),
					array( 'fa-thin fa-circle-o' => 'circle-o' ),
					array( 'fa-thin fa-circle-p' => 'circle-p' ),
					array( 'fa-thin fa-circle-parking' => 'circle-parking' ),
					array( 'fa-thin fa-circle-pause' => 'circle-pause' ),
					array( 'fa-thin fa-circle-phone-flip' => 'circle-phone-flip' ),
					array( 'fa-thin fa-circle-phone-hangup' => 'circle-phone-hangup' ),
					array( 'fa-thin fa-circle-phone' => 'circle-phone' ),
					array( 'fa-thin fa-circle-play' => 'circle-play' ),
					array( 'fa-thin fa-circle-plus' => 'circle-plus' ),
					array( 'fa-thin fa-circle-q' => 'circle-q' ),
					array( 'fa-thin fa-circle-quarter-stroke' => 'circle-quarter-stroke' ),
					array( 'fa-thin fa-circle-quarter' => 'circle-quarter' ),
					array( 'fa-thin fa-circle-quarters' => 'circle-quarters' ),
					array( 'fa-thin fa-circle-question' => 'circle-question' ),
					array( 'fa-thin fa-circle-r' => 'circle-r' ),
					array( 'fa-thin fa-circle-radiation' => 'circle-radiation' ),
					array( 'fa-thin fa-circle-right' => 'circle-right' ),
					array( 'fa-thin fa-circle-s' => 'circle-s' ),
					array( 'fa-thin fa-circle-small' => 'circle-small' ),
					array( 'fa-thin fa-circle-sort-down' => 'circle-sort-down' ),
					array( 'fa-thin fa-circle-sort-up' => 'circle-sort-up' ),
					array( 'fa-thin fa-circle-sort' => 'circle-sort' ),
					array( 'fa-thin fa-circle-star' => 'circle-star' ),
					array( 'fa-thin fa-circle-sterling' => 'circle-sterling' ),
					array( 'fa-thin fa-circle-stop' => 'circle-stop' ),
					array( 'fa-thin fa-circle-t' => 'circle-t' ),
					array( 'fa-thin fa-circle-three-quarters-stroke' => 'circle-three-quarters-stroke' ),
					array( 'fa-thin fa-circle-three-quarters' => 'circle-three-quarters' ),
					array( 'fa-thin fa-circle-trash' => 'circle-trash' ),
					array( 'fa-thin fa-circle-u' => 'circle-u' ),
					array( 'fa-thin fa-circle-up-left' => 'circle-up-left' ),
					array( 'fa-thin fa-circle-up-right' => 'circle-up-right' ),
					array( 'fa-thin fa-circle-up' => 'circle-up' ),
					array( 'fa-thin fa-circle-user' => 'circle-user' ),
					array( 'fa-thin fa-circle-v' => 'circle-v' ),
					array( 'fa-thin fa-circle-video' => 'circle-video' ),
					array( 'fa-thin fa-circle-w' => 'circle-w' ),
					array( 'fa-thin fa-circle-waveform-lines' => 'circle-waveform-lines' ),
					array( 'fa-thin fa-circle-x' => 'circle-x' ),
					array( 'fa-thin fa-circle-xmark' => 'circle-xmark' ),
					array( 'fa-thin fa-circle-y' => 'circle-y' ),
					array( 'fa-thin fa-circle-yen' => 'circle-yen' ),
					array( 'fa-thin fa-circle-z' => 'circle-z' ),
					array( 'fa-thin fa-circle' => 'circle' ),
					array( 'fa-thin fa-circles-overlap' => 'circles-overlap' ),
					array( 'fa-thin fa-citrus-slice' => 'citrus-slice' ),
					array( 'fa-thin fa-citrus' => 'citrus' ),
					array( 'fa-thin fa-city' => 'city' ),
					array( 'fa-thin fa-clapperboard-play' => 'clapperboard-play' ),
					array( 'fa-thin fa-clapperboard' => 'clapperboard' ),
					array( 'fa-thin fa-clarinet' => 'clarinet' ),
					array( 'fa-thin fa-claw-marks' => 'claw-marks' ),
					array( 'fa-thin fa-clipboard-check' => 'clipboard-check' ),
					array( 'fa-thin fa-clipboard-list-check' => 'clipboard-list-check' ),
					array( 'fa-thin fa-clipboard-list' => 'clipboard-list' ),
					array( 'fa-thin fa-clipboard-medical' => 'clipboard-medical' ),
					array( 'fa-thin fa-clipboard-prescription' => 'clipboard-prescription' ),
					array( 'fa-thin fa-clipboard-question' => 'clipboard-question' ),
					array( 'fa-thin fa-clipboard-user' => 'clipboard-user' ),
					array( 'fa-thin fa-clipboard' => 'clipboard' ),
					array( 'fa-thin fa-clock-desk' => 'clock-desk' ),
					array( 'fa-thin fa-clock-eight-thirty' => 'clock-eight-thirty' ),
					array( 'fa-thin fa-clock-eight' => 'clock-eight' ),
					array( 'fa-thin fa-clock-eleven-thirty' => 'clock-eleven-thirty' ),
					array( 'fa-thin fa-clock-eleven' => 'clock-eleven' ),
					array( 'fa-thin fa-clock-five-thirty' => 'clock-five-thirty' ),
					array( 'fa-thin fa-clock-five' => 'clock-five' ),
					array( 'fa-thin fa-clock-four-thirty' => 'clock-four-thirty' ),
					array( 'fa-thin fa-clock-nine-thirty' => 'clock-nine-thirty' ),
					array( 'fa-thin fa-clock-nine' => 'clock-nine' ),
					array( 'fa-thin fa-clock-one-thirty' => 'clock-one-thirty' ),
					array( 'fa-thin fa-clock-one' => 'clock-one' ),
					array( 'fa-thin fa-clock-rotate-left' => 'clock-rotate-left' ),
					array( 'fa-thin fa-clock-seven-thirty' => 'clock-seven-thirty' ),
					array( 'fa-thin fa-clock-seven' => 'clock-seven' ),
					array( 'fa-thin fa-clock-six-thirty' => 'clock-six-thirty' ),
					array( 'fa-thin fa-clock-six' => 'clock-six' ),
					array( 'fa-thin fa-clock-ten-thirty' => 'clock-ten-thirty' ),
					array( 'fa-thin fa-clock-ten' => 'clock-ten' ),
					array( 'fa-thin fa-clock-three-thirty' => 'clock-three-thirty' ),
					array( 'fa-thin fa-clock-three' => 'clock-three' ),
					array( 'fa-thin fa-clock-twelve-thirty' => 'clock-twelve-thirty' ),
					array( 'fa-thin fa-clock-twelve' => 'clock-twelve' ),
					array( 'fa-thin fa-clock-two-thirty' => 'clock-two-thirty' ),
					array( 'fa-thin fa-clock-two' => 'clock-two' ),
					array( 'fa-thin fa-clock' => 'clock' ),
					array( 'fa-thin fa-clone' => 'clone' ),
					array( 'fa-thin fa-closed-captioning-slash' => 'closed-captioning-slash' ),
					array( 'fa-thin fa-closed-captioning' => 'closed-captioning' ),
					array( 'fa-thin fa-clothes-hanger' => 'clothes-hanger' ),
					array( 'fa-thin fa-cloud-arrow-down' => 'cloud-arrow-down' ),
					array( 'fa-thin fa-cloud-arrow-up' => 'cloud-arrow-up' ),
					array( 'fa-thin fa-cloud-binary' => 'cloud-binary' ),
					array( 'fa-thin fa-cloud-bolt-moon' => 'cloud-bolt-moon' ),
					array( 'fa-thin fa-cloud-bolt-sun' => 'cloud-bolt-sun' ),
					array( 'fa-thin fa-cloud-bolt' => 'cloud-bolt' ),
					array( 'fa-thin fa-cloud-check' => 'cloud-check' ),
					array( 'fa-thin fa-cloud-drizzle' => 'cloud-drizzle' ),
					array( 'fa-thin fa-cloud-exclamation' => 'cloud-exclamation' ),
					array( 'fa-thin fa-cloud-fog' => 'cloud-fog' ),
					array( 'fa-thin fa-cloud-hail-mixed' => 'cloud-hail-mixed' ),
					array( 'fa-thin fa-cloud-hail' => 'cloud-hail' ),
					array( 'fa-thin fa-cloud-meatball' => 'cloud-meatball' ),
					array( 'fa-thin fa-cloud-minus' => 'cloud-minus' ),
					array( 'fa-thin fa-cloud-moon-rain' => 'cloud-moon-rain' ),
					array( 'fa-thin fa-cloud-moon' => 'cloud-moon' ),
					array( 'fa-thin fa-cloud-music' => 'cloud-music' ),
					array( 'fa-thin fa-cloud-plus' => 'cloud-plus' ),
					array( 'fa-thin fa-cloud-question' => 'cloud-question' ),
					array( 'fa-thin fa-cloud-rain' => 'cloud-rain' ),
					array( 'fa-thin fa-cloud-rainbow' => 'cloud-rainbow' ),
					array( 'fa-thin fa-cloud-showers-heavy' => 'cloud-showers-heavy' ),
					array( 'fa-thin fa-cloud-showers-water' => 'cloud-showers-water' ),
					array( 'fa-thin fa-cloud-showers' => 'cloud-showers' ),
					array( 'fa-thin fa-cloud-slash' => 'cloud-slash' ),
					array( 'fa-thin fa-cloud-sleet' => 'cloud-sleet' ),
					array( 'fa-thin fa-cloud-snow' => 'cloud-snow' ),
					array( 'fa-thin fa-cloud-sun-rain' => 'cloud-sun-rain' ),
					array( 'fa-thin fa-cloud-sun' => 'cloud-sun' ),
					array( 'fa-thin fa-cloud-word' => 'cloud-word' ),
					array( 'fa-thin fa-cloud-xmark' => 'cloud-xmark' ),
					array( 'fa-thin fa-cloud' => 'cloud' ),
					array( 'fa-thin fa-clouds-moon' => 'clouds-moon' ),
					array( 'fa-thin fa-clouds-sun' => 'clouds-sun' ),
					array( 'fa-thin fa-clouds' => 'clouds' ),
					array( 'fa-thin fa-clover' => 'clover' ),
					array( 'fa-thin fa-club' => 'club' ),
					array( 'fa-thin fa-coconut' => 'coconut' ),
					array( 'fa-thin fa-code-branch' => 'code-branch' ),
					array( 'fa-thin fa-code-commit' => 'code-commit' ),
					array( 'fa-thin fa-code-compare' => 'code-compare' ),
					array( 'fa-thin fa-code-fork' => 'code-fork' ),
					array( 'fa-thin fa-code-merge' => 'code-merge' ),
					array( 'fa-thin fa-code-pull-request-closed' => 'code-pull-request-closed' ),
					array( 'fa-thin fa-code-pull-request-draft' => 'code-pull-request-draft' ),
					array( 'fa-thin fa-code-pull-request' => 'code-pull-request' ),
					array( 'fa-thin fa-code-simple' => 'code-simple' ),
					array( 'fa-thin fa-code' => 'code' ),
					array( 'fa-thin fa-coffee-bean' => 'coffee-bean' ),
					array( 'fa-thin fa-coffee-beans' => 'coffee-beans' ),
					array( 'fa-thin fa-coffee-pot' => 'coffee-pot' ),
					array( 'fa-thin fa-coffin-cross' => 'coffin-cross' ),
					array( 'fa-thin fa-coffin' => 'coffin' ),
					array( 'fa-thin fa-coin-blank' => 'coin-blank' ),
					array( 'fa-thin fa-coin-front' => 'coin-front' ),
					array( 'fa-thin fa-coin-vertical' => 'coin-vertical' ),
					array( 'fa-thin fa-coin' => 'coin' ),
					array( 'fa-thin fa-coins' => 'coins' ),
					array( 'fa-thin fa-colon-sign' => 'colon-sign' ),
					array( 'fa-thin fa-colon' => 'colon' ),
					array( 'fa-thin fa-columns-3' => 'columns-3' ),
					array( 'fa-thin fa-comet' => 'comet' ),
					array( 'fa-thin fa-comma' => 'comma' ),
					array( 'fa-thin fa-command' => 'command' ),
					array( 'fa-thin fa-comment-arrow-down' => 'comment-arrow-down' ),
					array( 'fa-thin fa-comment-arrow-up-right' => 'comment-arrow-up-right' ),
					array( 'fa-thin fa-comment-arrow-up' => 'comment-arrow-up' ),
					array( 'fa-thin fa-comment-captions' => 'comment-captions' ),
					array( 'fa-thin fa-comment-check' => 'comment-check' ),
					array( 'fa-thin fa-comment-code' => 'comment-code' ),
					array( 'fa-thin fa-comment-dollar' => 'comment-dollar' ),
					array( 'fa-thin fa-comment-dots' => 'comment-dots' ),
					array( 'fa-thin fa-comment-exclamation' => 'comment-exclamation' ),
					array( 'fa-thin fa-comment-heart' => 'comment-heart' ),
					array( 'fa-thin fa-comment-image' => 'comment-image' ),
					array( 'fa-thin fa-comment-lines' => 'comment-lines' ),
					array( 'fa-thin fa-comment-medical' => 'comment-medical' ),
					array( 'fa-thin fa-comment-middle-top' => 'comment-middle-top' ),
					array( 'fa-thin fa-comment-middle' => 'comment-middle' ),
					array( 'fa-thin fa-comment-minus' => 'comment-minus' ),
					array( 'fa-thin fa-comment-music' => 'comment-music' ),
					array( 'fa-thin fa-comment-pen' => 'comment-pen' ),
					array( 'fa-thin fa-comment-plus' => 'comment-plus' ),
					array( 'fa-thin fa-comment-question' => 'comment-question' ),
					array( 'fa-thin fa-comment-quote' => 'comment-quote' ),
					array( 'fa-thin fa-comment-slash' => 'comment-slash' ),
					array( 'fa-thin fa-comment-smile' => 'comment-smile' ),
					array( 'fa-thin fa-comment-sms' => 'comment-sms' ),
					array( 'fa-thin fa-comment-text' => 'comment-text' ),
					array( 'fa-thin fa-comment-xmark' => 'comment-xmark' ),
					array( 'fa-thin fa-comment' => 'comment' ),
					array( 'fa-thin fa-comments-dollar' => 'comments-dollar' ),
					array( 'fa-thin fa-comments-question-check' => 'comments-question-check' ),
					array( 'fa-thin fa-comments-question' => 'comments-question' ),
					array( 'fa-thin fa-comments' => 'comments' ),
					array( 'fa-thin fa-compact-disc' => 'compact-disc' ),
					array( 'fa-thin fa-compass-drafting' => 'compass-drafting' ),
					array( 'fa-thin fa-compass-slash' => 'compass-slash' ),
					array( 'fa-thin fa-compass' => 'compass' ),
					array( 'fa-thin fa-compress-wide' => 'compress-wide' ),
					array( 'fa-thin fa-compress' => 'compress' ),
					array( 'fa-thin fa-computer-classic' => 'computer-classic' ),
					array( 'fa-thin fa-computer-mouse-scrollwheel' => 'computer-mouse-scrollwheel' ),
					array( 'fa-thin fa-computer-mouse' => 'computer-mouse' ),
					array( 'fa-thin fa-computer-speaker' => 'computer-speaker' ),
					array( 'fa-thin fa-computer' => 'computer' ),
					array( 'fa-thin fa-container-storage' => 'container-storage' ),
					array( 'fa-thin fa-conveyor-belt-arm' => 'conveyor-belt-arm' ),
					array( 'fa-thin fa-conveyor-belt-boxes' => 'conveyor-belt-boxes' ),
					array( 'fa-thin fa-conveyor-belt-empty' => 'conveyor-belt-empty' ),
					array( 'fa-thin fa-conveyor-belt' => 'conveyor-belt' ),
					array( 'fa-thin fa-cookie-bite' => 'cookie-bite' ),
					array( 'fa-thin fa-cookie' => 'cookie' ),
					array( 'fa-thin fa-copy' => 'copy' ),
					array( 'fa-thin fa-copyright' => 'copyright' ),
					array( 'fa-thin fa-corn' => 'corn' ),
					array( 'fa-thin fa-corner' => 'corner' ),
					array( 'fa-thin fa-couch' => 'couch' ),
					array( 'fa-thin fa-cow' => 'cow' ),
					array( 'fa-thin fa-cowbell-circle-plus' => 'cowbell-circle-plus' ),
					array( 'fa-thin fa-cowbell' => 'cowbell' ),
					array( 'fa-thin fa-crab' => 'crab' ),
					array( 'fa-thin fa-crate-apple' => 'crate-apple' ),
					array( 'fa-thin fa-crate-empty' => 'crate-empty' ),
					array( 'fa-thin fa-credit-card-blank' => 'credit-card-blank' ),
					array( 'fa-thin fa-credit-card-front' => 'credit-card-front' ),
					array( 'fa-thin fa-credit-card' => 'credit-card' ),
					array( 'fa-thin fa-cricket-bat-ball' => 'cricket-bat-ball' ),
					array( 'fa-thin fa-croissant' => 'croissant' ),
					array( 'fa-thin fa-crop-simple' => 'crop-simple' ),
					array( 'fa-thin fa-crop' => 'crop' ),
					array( 'fa-thin fa-cross' => 'cross' ),
					array( 'fa-thin fa-crosshairs-simple' => 'crosshairs-simple' ),
					array( 'fa-thin fa-crosshairs' => 'crosshairs' ),
					array( 'fa-thin fa-crow' => 'crow' ),
					array( 'fa-thin fa-crown' => 'crown' ),
					array( 'fa-thin fa-crutch' => 'crutch' ),
					array( 'fa-thin fa-crutches' => 'crutches' ),
					array( 'fa-thin fa-cruzeiro-sign' => 'cruzeiro-sign' ),
					array( 'fa-thin fa-crystal-ball' => 'crystal-ball' ),
					array( 'fa-thin fa-cube' => 'cube' ),
					array( 'fa-thin fa-cubes-stacked' => 'cubes-stacked' ),
					array( 'fa-thin fa-cubes' => 'cubes' ),
					array( 'fa-thin fa-cucumber' => 'cucumber' ),
					array( 'fa-thin fa-cup-straw-swoosh' => 'cup-straw-swoosh' ),
					array( 'fa-thin fa-cup-straw' => 'cup-straw' ),
					array( 'fa-thin fa-cup-togo' => 'cup-togo' ),
					array( 'fa-thin fa-cupcake' => 'cupcake' ),
					array( 'fa-thin fa-curling-stone' => 'curling-stone' ),
					array( 'fa-thin fa-custard' => 'custard' ),
					array( 'fa-thin fa-d' => 'd' ),
					array( 'fa-thin fa-dagger' => 'dagger' ),
					array( 'fa-thin fa-dash' => 'dash' ),
					array( 'fa-thin fa-database' => 'database' ),
					array( 'fa-thin fa-deer-rudolph' => 'deer-rudolph' ),
					array( 'fa-thin fa-deer' => 'deer' ),
					array( 'fa-thin fa-delete-left' => 'delete-left' ),
					array( 'fa-thin fa-delete-right' => 'delete-right' ),
					array( 'fa-thin fa-democrat' => 'democrat' ),
					array( 'fa-thin fa-desktop-arrow-down' => 'desktop-arrow-down' ),
					array( 'fa-thin fa-desktop' => 'desktop' ),
					array( 'fa-thin fa-dharmachakra' => 'dharmachakra' ),
					array( 'fa-thin fa-diagram-cells' => 'diagram-cells' ),
					array( 'fa-thin fa-diagram-lean-canvas' => 'diagram-lean-canvas' ),
					array( 'fa-thin fa-diagram-nested' => 'diagram-nested' ),
					array( 'fa-thin fa-diagram-next' => 'diagram-next' ),
					array( 'fa-thin fa-diagram-predecessor' => 'diagram-predecessor' ),
					array( 'fa-thin fa-diagram-previous' => 'diagram-previous' ),
					array( 'fa-thin fa-diagram-project' => 'diagram-project' ),
					array( 'fa-thin fa-diagram-sankey' => 'diagram-sankey' ),
					array( 'fa-thin fa-diagram-subtask' => 'diagram-subtask' ),
					array( 'fa-thin fa-diagram-successor' => 'diagram-successor' ),
					array( 'fa-thin fa-diagram-venn' => 'diagram-venn' ),
					array( 'fa-thin fa-dial-high' => 'dial-high' ),
					array( 'fa-thin fa-dial-low' => 'dial-low' ),
					array( 'fa-thin fa-dial-max' => 'dial-max' ),
					array( 'fa-thin fa-dial-med-low' => 'dial-med-low' ),
					array( 'fa-thin fa-dial-med' => 'dial-med' ),
					array( 'fa-thin fa-dial-min' => 'dial-min' ),
					array( 'fa-thin fa-dial-off' => 'dial-off' ),
					array( 'fa-thin fa-dial' => 'dial' ),
					array( 'fa-thin fa-diamond-exclamation' => 'diamond-exclamation' ),
					array( 'fa-thin fa-diamond-half-stroke' => 'diamond-half-stroke' ),
					array( 'fa-thin fa-diamond-half' => 'diamond-half' ),
					array( 'fa-thin fa-diamond-turn-right' => 'diamond-turn-right' ),
					array( 'fa-thin fa-diamond' => 'diamond' ),
					array( 'fa-thin fa-dice-d4' => 'dice-d4' ),
					array( 'fa-thin fa-dice-d6' => 'dice-d6' ),
					array( 'fa-thin fa-dice-d8' => 'dice-d8' ),
					array( 'fa-thin fa-dice-d10' => 'dice-d10' ),
					array( 'fa-thin fa-dice-d12' => 'dice-d12' ),
					array( 'fa-thin fa-dice-d20' => 'dice-d20' ),
					array( 'fa-thin fa-dice-five' => 'dice-five' ),
					array( 'fa-thin fa-dice-four' => 'dice-four' ),
					array( 'fa-thin fa-dice-one' => 'dice-one' ),
					array( 'fa-thin fa-dice-six' => 'dice-six' ),
					array( 'fa-thin fa-dice-three' => 'dice-three' ),
					array( 'fa-thin fa-dice-two' => 'dice-two' ),
					array( 'fa-thin fa-dice' => 'dice' ),
					array( 'fa-thin fa-dinosaur' => 'dinosaur' ),
					array( 'fa-thin fa-diploma' => 'diploma' ),
					array( 'fa-thin fa-disc-drive' => 'disc-drive' ),
					array( 'fa-thin fa-disease' => 'disease' ),
					array( 'fa-thin fa-display-arrow-down' => 'display-arrow-down' ),
					array( 'fa-thin fa-display-chart-up-circle-currency' => 'display-chart-up-circle-currency' ),
					array( 'fa-thin fa-display-chart-up-circle-dollar' => 'display-chart-up-circle-dollar' ),
					array( 'fa-thin fa-display-chart-up' => 'display-chart-up' ),
					array( 'fa-thin fa-display-code' => 'display-code' ),
					array( 'fa-thin fa-display-medical' => 'display-medical' ),
					array( 'fa-thin fa-display-slash' => 'display-slash' ),
					array( 'fa-thin fa-display' => 'display' ),
					array( 'fa-thin fa-distribute-spacing-horizontal' => 'distribute-spacing-horizontal' ),
					array( 'fa-thin fa-distribute-spacing-vertical' => 'distribute-spacing-vertical' ),
					array( 'fa-thin fa-ditto' => 'ditto' ),
					array( 'fa-thin fa-divide' => 'divide' ),
					array( 'fa-thin fa-dna' => 'dna' ),
					array( 'fa-thin fa-do-not-enter' => 'do-not-enter' ),
					array( 'fa-thin fa-dog-leashed' => 'dog-leashed' ),
					array( 'fa-thin fa-dog' => 'dog' ),
					array( 'fa-thin fa-dollar-sign' => 'dollar-sign' ),
					array( 'fa-thin fa-dolly-empty' => 'dolly-empty' ),
					array( 'fa-thin fa-dolly' => 'dolly' ),
					array( 'fa-thin fa-dolphin' => 'dolphin' ),
					array( 'fa-thin fa-dong-sign' => 'dong-sign' ),
					array( 'fa-thin fa-donut' => 'donut' ),
					array( 'fa-thin fa-door-closed' => 'door-closed' ),
					array( 'fa-thin fa-door-open' => 'door-open' ),
					array( 'fa-thin fa-dove' => 'dove' ),
					array( 'fa-thin fa-down-from-dotted-line' => 'down-from-dotted-line' ),
					array( 'fa-thin fa-down-from-line' => 'down-from-line' ),
					array( 'fa-thin fa-down-left-and-up-right-to-center' => 'down-left-and-up-right-to-center' ),
					array( 'fa-thin fa-down-left' => 'down-left' ),
					array( 'fa-thin fa-down-long' => 'down-long' ),
					array( 'fa-thin fa-down-right' => 'down-right' ),
					array( 'fa-thin fa-down-to-bracket' => 'down-to-bracket' ),
					array( 'fa-thin fa-down-to-dotted-line' => 'down-to-dotted-line' ),
					array( 'fa-thin fa-down-to-line' => 'down-to-line' ),
					array( 'fa-thin fa-down' => 'down' ),
					array( 'fa-thin fa-download' => 'download' ),
					array( 'fa-thin fa-dragon' => 'dragon' ),
					array( 'fa-thin fa-draw-circle' => 'draw-circle' ),
					array( 'fa-thin fa-draw-polygon' => 'draw-polygon' ),
					array( 'fa-thin fa-draw-square' => 'draw-square' ),
					array( 'fa-thin fa-dreidel' => 'dreidel' ),
					array( 'fa-thin fa-drone-front' => 'drone-front' ),
					array( 'fa-thin fa-drone' => 'drone' ),
					array( 'fa-thin fa-droplet-degree' => 'droplet-degree' ),
					array( 'fa-thin fa-droplet-percent' => 'droplet-percent' ),
					array( 'fa-thin fa-droplet-slash' => 'droplet-slash' ),
					array( 'fa-thin fa-droplet' => 'droplet' ),
					array( 'fa-thin fa-drum-steelpan' => 'drum-steelpan' ),
					array( 'fa-thin fa-drum' => 'drum' ),
					array( 'fa-thin fa-drumstick-bite' => 'drumstick-bite' ),
					array( 'fa-thin fa-drumstick' => 'drumstick' ),
					array( 'fa-thin fa-dryer-heat' => 'dryer-heat' ),
					array( 'fa-thin fa-dryer' => 'dryer' ),
					array( 'fa-thin fa-duck' => 'duck' ),
					array( 'fa-thin fa-dumbbell' => 'dumbbell' ),
					array( 'fa-thin fa-dumpster-fire' => 'dumpster-fire' ),
					array( 'fa-thin fa-dumpster' => 'dumpster' ),
					array( 'fa-thin fa-dungeon' => 'dungeon' ),
					array( 'fa-thin fa-e' => 'e' ),
					array( 'fa-thin fa-ear-deaf' => 'ear-deaf' ),
					array( 'fa-thin fa-ear-listen' => 'ear-listen' ),
					array( 'fa-thin fa-ear-muffs' => 'ear-muffs' ),
					array( 'fa-thin fa-ear' => 'ear' ),
					array( 'fa-thin fa-earth-africa' => 'earth-africa' ),
					array( 'fa-thin fa-earth-americas' => 'earth-americas' ),
					array( 'fa-thin fa-earth-asia' => 'earth-asia' ),
					array( 'fa-thin fa-earth-europe' => 'earth-europe' ),
					array( 'fa-thin fa-earth-oceania' => 'earth-oceania' ),
					array( 'fa-thin fa-eclipse' => 'eclipse' ),
					array( 'fa-thin fa-egg-fried' => 'egg-fried' ),
					array( 'fa-thin fa-egg' => 'egg' ),
					array( 'fa-thin fa-eggplant' => 'eggplant' ),
					array( 'fa-thin fa-eject' => 'eject' ),
					array( 'fa-thin fa-elephant' => 'elephant' ),
					array( 'fa-thin fa-elevator' => 'elevator' ),
					array( 'fa-thin fa-ellipsis-stroke-vertical' => 'ellipsis-stroke-vertical' ),
					array( 'fa-thin fa-ellipsis-stroke' => 'ellipsis-stroke' ),
					array( 'fa-thin fa-ellipsis-vertical' => 'ellipsis-vertical' ),
					array( 'fa-thin fa-ellipsis' => 'ellipsis' ),
					array( 'fa-thin fa-empty-set' => 'empty-set' ),
					array( 'fa-thin fa-engine-warning' => 'engine-warning' ),
					array( 'fa-thin fa-engine' => 'engine' ),
					array( 'fa-thin fa-envelope-circle-check' => 'envelope-circle-check' ),
					array( 'fa-thin fa-envelope-dot' => 'envelope-dot' ),
					array( 'fa-thin fa-envelope-open-dollar' => 'envelope-open-dollar' ),
					array( 'fa-thin fa-envelope-open-text' => 'envelope-open-text' ),
					array( 'fa-thin fa-envelope-open' => 'envelope-open' ),
					array( 'fa-thin fa-envelope' => 'envelope' ),
					array( 'fa-thin fa-envelopes-bulk' => 'envelopes-bulk' ),
					array( 'fa-thin fa-envelopes' => 'envelopes' ),
					array( 'fa-thin fa-equals' => 'equals' ),
					array( 'fa-thin fa-eraser' => 'eraser' ),
					array( 'fa-thin fa-escalator' => 'escalator' ),
					array( 'fa-thin fa-ethernet' => 'ethernet' ),
					array( 'fa-thin fa-euro-sign' => 'euro-sign' ),
					array( 'fa-thin fa-exclamation' => 'exclamation' ),
					array( 'fa-thin fa-expand-wide' => 'expand-wide' ),
					array( 'fa-thin fa-expand' => 'expand' ),
					array( 'fa-thin fa-explosion' => 'explosion' ),
					array( 'fa-thin fa-eye-dropper-full' => 'eye-dropper-full' ),
					array( 'fa-thin fa-eye-dropper-half' => 'eye-dropper-half' ),
					array( 'fa-thin fa-eye-dropper' => 'eye-dropper' ),
					array( 'fa-thin fa-eye-evil' => 'eye-evil' ),
					array( 'fa-thin fa-eye-low-vision' => 'eye-low-vision' ),
					array( 'fa-thin fa-eye-slash' => 'eye-slash' ),
					array( 'fa-thin fa-eye' => 'eye' ),
					array( 'fa-thin fa-eyes' => 'eyes' ),
					array( 'fa-thin fa-f' => 'f' ),
					array( 'fa-thin fa-face-angry-horns' => 'face-angry-horns' ),
					array( 'fa-thin fa-face-angry' => 'face-angry' ),
					array( 'fa-thin fa-face-anguished' => 'face-anguished' ),
					array( 'fa-thin fa-face-anxious-sweat' => 'face-anxious-sweat' ),
					array( 'fa-thin fa-face-astonished' => 'face-astonished' ),
					array( 'fa-thin fa-face-awesome' => 'face-awesome' ),
					array( 'fa-thin fa-face-beam-hand-over-mouth' => 'face-beam-hand-over-mouth' ),
					array( 'fa-thin fa-face-clouds' => 'face-clouds' ),
					array( 'fa-thin fa-face-confounded' => 'face-confounded' ),
					array( 'fa-thin fa-face-confused' => 'face-confused' ),
					array( 'fa-thin fa-face-cowboy-hat' => 'face-cowboy-hat' ),
					array( 'fa-thin fa-face-diagonal-mouth' => 'face-diagonal-mouth' ),
					array( 'fa-thin fa-face-disappointed' => 'face-disappointed' ),
					array( 'fa-thin fa-face-disguise' => 'face-disguise' ),
					array( 'fa-thin fa-face-dizzy' => 'face-dizzy' ),
					array( 'fa-thin fa-face-dotted' => 'face-dotted' ),
					array( 'fa-thin fa-face-downcast-sweat' => 'face-downcast-sweat' ),
					array( 'fa-thin fa-face-drooling' => 'face-drooling' ),
					array( 'fa-thin fa-face-exhaling' => 'face-exhaling' ),
					array( 'fa-thin fa-face-explode' => 'face-explode' ),
					array( 'fa-thin fa-face-expressionless' => 'face-expressionless' ),
					array( 'fa-thin fa-face-eyes-xmarks' => 'face-eyes-xmarks' ),
					array( 'fa-thin fa-face-fearful' => 'face-fearful' ),
					array( 'fa-thin fa-face-flushed' => 'face-flushed' ),
					array( 'fa-thin fa-face-frown-open' => 'face-frown-open' ),
					array( 'fa-thin fa-face-frown-slight' => 'face-frown-slight' ),
					array( 'fa-thin fa-face-frown' => 'face-frown' ),
					array( 'fa-thin fa-face-glasses' => 'face-glasses' ),
					array( 'fa-thin fa-face-grimace' => 'face-grimace' ),
					array( 'fa-thin fa-face-grin-beam-sweat' => 'face-grin-beam-sweat' ),
					array( 'fa-thin fa-face-grin-beam' => 'face-grin-beam' ),
					array( 'fa-thin fa-face-grin-hearts' => 'face-grin-hearts' ),
					array( 'fa-thin fa-face-grin-squint-tears' => 'face-grin-squint-tears' ),
					array( 'fa-thin fa-face-grin-squint' => 'face-grin-squint' ),
					array( 'fa-thin fa-face-grin-stars' => 'face-grin-stars' ),
					array( 'fa-thin fa-face-grin-tears' => 'face-grin-tears' ),
					array( 'fa-thin fa-face-grin-tongue-squint' => 'face-grin-tongue-squint' ),
					array( 'fa-thin fa-face-grin-tongue-wink' => 'face-grin-tongue-wink' ),
					array( 'fa-thin fa-face-grin-tongue' => 'face-grin-tongue' ),
					array( 'fa-thin fa-face-grin-wide' => 'face-grin-wide' ),
					array( 'fa-thin fa-face-grin-wink' => 'face-grin-wink' ),
					array( 'fa-thin fa-face-grin' => 'face-grin' ),
					array( 'fa-thin fa-face-hand-over-mouth' => 'face-hand-over-mouth' ),
					array( 'fa-thin fa-face-hand-peeking' => 'face-hand-peeking' ),
					array( 'fa-thin fa-face-hand-yawn' => 'face-hand-yawn' ),
					array( 'fa-thin fa-face-head-bandage' => 'face-head-bandage' ),
					array( 'fa-thin fa-face-holding-back-tears' => 'face-holding-back-tears' ),
					array( 'fa-thin fa-face-hushed' => 'face-hushed' ),
					array( 'fa-thin fa-face-icicles' => 'face-icicles' ),
					array( 'fa-thin fa-face-kiss-beam' => 'face-kiss-beam' ),
					array( 'fa-thin fa-face-kiss-closed-eyes' => 'face-kiss-closed-eyes' ),
					array( 'fa-thin fa-face-kiss-wink-heart' => 'face-kiss-wink-heart' ),
					array( 'fa-thin fa-face-kiss' => 'face-kiss' ),
					array( 'fa-thin fa-face-laugh-beam' => 'face-laugh-beam' ),
					array( 'fa-thin fa-face-laugh-squint' => 'face-laugh-squint' ),
					array( 'fa-thin fa-face-laugh-wink' => 'face-laugh-wink' ),
					array( 'fa-thin fa-face-laugh' => 'face-laugh' ),
					array( 'fa-thin fa-face-lying' => 'face-lying' ),
					array( 'fa-thin fa-face-mask' => 'face-mask' ),
					array( 'fa-thin fa-face-meh-blank' => 'face-meh-blank' ),
					array( 'fa-thin fa-face-meh' => 'face-meh' ),
					array( 'fa-thin fa-face-melting' => 'face-melting' ),
					array( 'fa-thin fa-face-monocle' => 'face-monocle' ),
					array( 'fa-thin fa-face-nauseated' => 'face-nauseated' ),
					array( 'fa-thin fa-face-nose-steam' => 'face-nose-steam' ),
					array( 'fa-thin fa-face-party' => 'face-party' ),
					array( 'fa-thin fa-face-pensive' => 'face-pensive' ),
					array( 'fa-thin fa-face-persevering' => 'face-persevering' ),
					array( 'fa-thin fa-face-pleading' => 'face-pleading' ),
					array( 'fa-thin fa-face-pouting' => 'face-pouting' ),
					array( 'fa-thin fa-face-raised-eyebrow' => 'face-raised-eyebrow' ),
					array( 'fa-thin fa-face-relieved' => 'face-relieved' ),
					array( 'fa-thin fa-face-rolling-eyes' => 'face-rolling-eyes' ),
					array( 'fa-thin fa-face-sad-cry' => 'face-sad-cry' ),
					array( 'fa-thin fa-face-sad-sweat' => 'face-sad-sweat' ),
					array( 'fa-thin fa-face-sad-tear' => 'face-sad-tear' ),
					array( 'fa-thin fa-face-saluting' => 'face-saluting' ),
					array( 'fa-thin fa-face-scream' => 'face-scream' ),
					array( 'fa-thin fa-face-shush' => 'face-shush' ),
					array( 'fa-thin fa-face-sleeping' => 'face-sleeping' ),
					array( 'fa-thin fa-face-sleepy' => 'face-sleepy' ),
					array( 'fa-thin fa-face-smile-beam' => 'face-smile-beam' ),
					array( 'fa-thin fa-face-smile-halo' => 'face-smile-halo' ),
					array( 'fa-thin fa-face-smile-hearts' => 'face-smile-hearts' ),
					array( 'fa-thin fa-face-smile-horns' => 'face-smile-horns' ),
					array( 'fa-thin fa-face-smile-plus' => 'face-smile-plus' ),
					array( 'fa-thin fa-face-smile-relaxed' => 'face-smile-relaxed' ),
					array( 'fa-thin fa-face-smile-tear' => 'face-smile-tear' ),
					array( 'fa-thin fa-face-smile-tongue' => 'face-smile-tongue' ),
					array( 'fa-thin fa-face-smile-upside-down' => 'face-smile-upside-down' ),
					array( 'fa-thin fa-face-smile-wink' => 'face-smile-wink' ),
					array( 'fa-thin fa-face-smile' => 'face-smile' ),
					array( 'fa-thin fa-face-smiling-hands' => 'face-smiling-hands' ),
					array( 'fa-thin fa-face-smirking' => 'face-smirking' ),
					array( 'fa-thin fa-face-spiral-eyes' => 'face-spiral-eyes' ),
					array( 'fa-thin fa-face-sunglasses' => 'face-sunglasses' ),
					array( 'fa-thin fa-face-surprise' => 'face-surprise' ),
					array( 'fa-thin fa-face-swear' => 'face-swear' ),
					array( 'fa-thin fa-face-thermometer' => 'face-thermometer' ),
					array( 'fa-thin fa-face-thinking' => 'face-thinking' ),
					array( 'fa-thin fa-face-tired' => 'face-tired' ),
					array( 'fa-thin fa-face-tissue' => 'face-tissue' ),
					array( 'fa-thin fa-face-tongue-money' => 'face-tongue-money' ),
					array( 'fa-thin fa-face-tongue-sweat' => 'face-tongue-sweat' ),
					array( 'fa-thin fa-face-unamused' => 'face-unamused' ),
					array( 'fa-thin fa-face-viewfinder' => 'face-viewfinder' ),
					array( 'fa-thin fa-face-vomit' => 'face-vomit' ),
					array( 'fa-thin fa-face-weary' => 'face-weary' ),
					array( 'fa-thin fa-face-woozy' => 'face-woozy' ),
					array( 'fa-thin fa-face-worried' => 'face-worried' ),
					array( 'fa-thin fa-face-zany' => 'face-zany' ),
					array( 'fa-thin fa-face-zipper' => 'face-zipper' ),
					array( 'fa-thin fa-falafel' => 'falafel' ),
					array( 'fa-thin fa-family-dress' => 'family-dress' ),
					array( 'fa-thin fa-family-pants' => 'family-pants' ),
					array( 'fa-thin fa-family' => 'family' ),
					array( 'fa-thin fa-fan-table' => 'fan-table' ),
					array( 'fa-thin fa-fan' => 'fan' ),
					array( 'fa-thin fa-farm' => 'farm' ),
					array( 'fa-thin fa-faucet-drip' => 'faucet-drip' ),
					array( 'fa-thin fa-faucet' => 'faucet' ),
					array( 'fa-thin fa-fax' => 'fax' ),
					array( 'fa-thin fa-feather-pointed' => 'feather-pointed' ),
					array( 'fa-thin fa-feather' => 'feather' ),
					array( 'fa-thin fa-fence' => 'fence' ),
					array( 'fa-thin fa-ferris-wheel' => 'ferris-wheel' ),
					array( 'fa-thin fa-ferry' => 'ferry' ),
					array( 'fa-thin fa-field-hockey-stick-ball' => 'field-hockey-stick-ball' ),
					array( 'fa-thin fa-file-arrow-down' => 'file-arrow-down' ),
					array( 'fa-thin fa-file-arrow-up' => 'file-arrow-up' ),
					array( 'fa-thin fa-file-audio' => 'file-audio' ),
					array( 'fa-thin fa-file-binary' => 'file-binary' ),
					array( 'fa-thin fa-file-certificate' => 'file-certificate' ),
					array( 'fa-thin fa-file-chart-column' => 'file-chart-column' ),
					array( 'fa-thin fa-file-chart-pie' => 'file-chart-pie' ),
					array( 'fa-thin fa-file-check' => 'file-check' ),
					array( 'fa-thin fa-file-circle-check' => 'file-circle-check' ),
					array( 'fa-thin fa-file-circle-exclamation' => 'file-circle-exclamation' ),
					array( 'fa-thin fa-file-circle-info' => 'file-circle-info' ),
					array( 'fa-thin fa-file-circle-minus' => 'file-circle-minus' ),
					array( 'fa-thin fa-file-circle-plus' => 'file-circle-plus' ),
					array( 'fa-thin fa-file-circle-question' => 'file-circle-question' ),
					array( 'fa-thin fa-file-circle-xmark' => 'file-circle-xmark' ),
					array( 'fa-thin fa-file-code' => 'file-code' ),
					array( 'fa-thin fa-file-contract' => 'file-contract' ),
					array( 'fa-thin fa-file-csv' => 'file-csv' ),
					array( 'fa-thin fa-file-dashed-line' => 'file-dashed-line' ),
					array( 'fa-thin fa-file-doc' => 'file-doc' ),
					array( 'fa-thin fa-file-excel' => 'file-excel' ),
					array( 'fa-thin fa-file-exclamation' => 'file-exclamation' ),
					array( 'fa-thin fa-file-export' => 'file-export' ),
					array( 'fa-thin fa-file-heart' => 'file-heart' ),
					array( 'fa-thin fa-file-image' => 'file-image' ),
					array( 'fa-thin fa-file-import' => 'file-import' ),
					array( 'fa-thin fa-file-invoice-dollar' => 'file-invoice-dollar' ),
					array( 'fa-thin fa-file-invoice' => 'file-invoice' ),
					array( 'fa-thin fa-file-lines' => 'file-lines' ),
					array( 'fa-thin fa-file-lock' => 'file-lock' ),
					array( 'fa-thin fa-file-magnifying-glass' => 'file-magnifying-glass' ),
					array( 'fa-thin fa-file-medical' => 'file-medical' ),
					array( 'fa-thin fa-file-minus' => 'file-minus' ),
					array( 'fa-thin fa-file-music' => 'file-music' ),
					array( 'fa-thin fa-file-pdf' => 'file-pdf' ),
					array( 'fa-thin fa-file-pen' => 'file-pen' ),
					array( 'fa-thin fa-file-plus-minus' => 'file-plus-minus' ),
					array( 'fa-thin fa-file-plus' => 'file-plus' ),
					array( 'fa-thin fa-file-powerpoint' => 'file-powerpoint' ),
					array( 'fa-thin fa-file-prescription' => 'file-prescription' ),
					array( 'fa-thin fa-file-shield' => 'file-shield' ),
					array( 'fa-thin fa-file-signature' => 'file-signature' ),
					array( 'fa-thin fa-file-slash' => 'file-slash' ),
					array( 'fa-thin fa-file-spreadsheet' => 'file-spreadsheet' ),
					array( 'fa-thin fa-file-user' => 'file-user' ),
					array( 'fa-thin fa-file-video' => 'file-video' ),
					array( 'fa-thin fa-file-waveform' => 'file-waveform' ),
					array( 'fa-thin fa-file-word' => 'file-word' ),
					array( 'fa-thin fa-file-xmark' => 'file-xmark' ),
					array( 'fa-thin fa-file-zip' => 'file-zip' ),
					array( 'fa-thin fa-file-zipper' => 'file-zipper' ),
					array( 'fa-thin fa-file' => 'file' ),
					array( 'fa-thin fa-files-medical' => 'files-medical' ),
					array( 'fa-thin fa-files' => 'files' ),
					array( 'fa-thin fa-fill-drip' => 'fill-drip' ),
					array( 'fa-thin fa-fill' => 'fill' ),
					array( 'fa-thin fa-film-canister' => 'film-canister' ),
					array( 'fa-thin fa-film-simple' => 'film-simple' ),
					array( 'fa-thin fa-film-slash' => 'film-slash' ),
					array( 'fa-thin fa-film' => 'film' ),
					array( 'fa-thin fa-films' => 'films' ),
					array( 'fa-thin fa-filter-circle-dollar' => 'filter-circle-dollar' ),
					array( 'fa-thin fa-filter-circle-xmark' => 'filter-circle-xmark' ),
					array( 'fa-thin fa-filter-list' => 'filter-list' ),
					array( 'fa-thin fa-filter-slash' => 'filter-slash' ),
					array( 'fa-thin fa-filter' => 'filter' ),
					array( 'fa-thin fa-filters' => 'filters' ),
					array( 'fa-thin fa-fingerprint' => 'fingerprint' ),
					array( 'fa-thin fa-fire-burner' => 'fire-burner' ),
					array( 'fa-thin fa-fire-extinguisher' => 'fire-extinguisher' ),
					array( 'fa-thin fa-fire-flame-curved' => 'fire-flame-curved' ),
					array( 'fa-thin fa-fire-flame-simple' => 'fire-flame-simple' ),
					array( 'fa-thin fa-fire-flame' => 'fire-flame' ),
					array( 'fa-thin fa-fire-hydrant' => 'fire-hydrant' ),
					array( 'fa-thin fa-fire-smoke' => 'fire-smoke' ),
					array( 'fa-thin fa-fire' => 'fire' ),
					array( 'fa-thin fa-fireplace' => 'fireplace' ),
					array( 'fa-thin fa-fish-bones' => 'fish-bones' ),
					array( 'fa-thin fa-fish-cooked' => 'fish-cooked' ),
					array( 'fa-thin fa-fish-fins' => 'fish-fins' ),
					array( 'fa-thin fa-fish' => 'fish' ),
					array( 'fa-thin fa-fishing-rod' => 'fishing-rod' ),
					array( 'fa-thin fa-flag-checkered' => 'flag-checkered' ),
					array( 'fa-thin fa-flag-pennant' => 'flag-pennant' ),
					array( 'fa-thin fa-flag-swallowtail' => 'flag-swallowtail' ),
					array( 'fa-thin fa-flag-usa' => 'flag-usa' ),
					array( 'fa-thin fa-flag' => 'flag' ),
					array( 'fa-thin fa-flashlight' => 'flashlight' ),
					array( 'fa-thin fa-flask-gear' => 'flask-gear' ),
					array( 'fa-thin fa-flask-round-poison' => 'flask-round-poison' ),
					array( 'fa-thin fa-flask-round-potion' => 'flask-round-potion' ),
					array( 'fa-thin fa-flask-vial' => 'flask-vial' ),
					array( 'fa-thin fa-flask' => 'flask' ),
					array( 'fa-thin fa-flatbread-stuffed' => 'flatbread-stuffed' ),
					array( 'fa-thin fa-flatbread' => 'flatbread' ),
					array( 'fa-thin fa-floppy-disk-circle-arrow-right' => 'floppy-disk-circle-arrow-right' ),
					array( 'fa-thin fa-floppy-disk-circle-xmark' => 'floppy-disk-circle-xmark' ),
					array( 'fa-thin fa-floppy-disk-pen' => 'floppy-disk-pen' ),
					array( 'fa-thin fa-floppy-disk' => 'floppy-disk' ),
					array( 'fa-thin fa-floppy-disks' => 'floppy-disks' ),
					array( 'fa-thin fa-florin-sign' => 'florin-sign' ),
					array( 'fa-thin fa-flower-daffodil' => 'flower-daffodil' ),
					array( 'fa-thin fa-flower-tulip' => 'flower-tulip' ),
					array( 'fa-thin fa-flower' => 'flower' ),
					array( 'fa-thin fa-flute' => 'flute' ),
					array( 'fa-thin fa-flux-capacitor' => 'flux-capacitor' ),
					array( 'fa-thin fa-flying-disc' => 'flying-disc' ),
					array( 'fa-thin fa-folder-arrow-down' => 'folder-arrow-down' ),
					array( 'fa-thin fa-folder-arrow-up' => 'folder-arrow-up' ),
					array( 'fa-thin fa-folder-bookmark' => 'folder-bookmark' ),
					array( 'fa-thin fa-folder-closed' => 'folder-closed' ),
					array( 'fa-thin fa-folder-gear' => 'folder-gear' ),
					array( 'fa-thin fa-folder-grid' => 'folder-grid' ),
					array( 'fa-thin fa-folder-heart' => 'folder-heart' ),
					array( 'fa-thin fa-folder-image' => 'folder-image' ),
					array( 'fa-thin fa-folder-magnifying-glass' => 'folder-magnifying-glass' ),
					array( 'fa-thin fa-folder-medical' => 'folder-medical' ),
					array( 'fa-thin fa-folder-minus' => 'folder-minus' ),
					array( 'fa-thin fa-folder-music' => 'folder-music' ),
					array( 'fa-thin fa-folder-open' => 'folder-open' ),
					array( 'fa-thin fa-folder-plus' => 'folder-plus' ),
					array( 'fa-thin fa-folder-tree' => 'folder-tree' ),
					array( 'fa-thin fa-folder-user' => 'folder-user' ),
					array( 'fa-thin fa-folder-xmark' => 'folder-xmark' ),
					array( 'fa-thin fa-folder' => 'folder' ),
					array( 'fa-thin fa-folders' => 'folders' ),
					array( 'fa-thin fa-fondue-pot' => 'fondue-pot' ),
					array( 'fa-thin fa-font-awesome' => 'font-awesome' ),
					array( 'fa-thin fa-font-case' => 'font-case' ),
					array( 'fa-thin fa-font' => 'font' ),
					array( 'fa-thin fa-football-helmet' => 'football-helmet' ),
					array( 'fa-thin fa-football' => 'football' ),
					array( 'fa-thin fa-fork-knife' => 'fork-knife' ),
					array( 'fa-thin fa-fork' => 'fork' ),
					array( 'fa-thin fa-forklift' => 'forklift' ),
					array( 'fa-thin fa-fort' => 'fort' ),
					array( 'fa-thin fa-forward-fast' => 'forward-fast' ),
					array( 'fa-thin fa-forward-step' => 'forward-step' ),
					array( 'fa-thin fa-forward' => 'forward' ),
					array( 'fa-thin fa-frame' => 'frame' ),
					array( 'fa-thin fa-franc-sign' => 'franc-sign' ),
					array( 'fa-thin fa-french-fries' => 'french-fries' ),
					array( 'fa-thin fa-frog' => 'frog' ),
					array( 'fa-thin fa-function' => 'function' ),
					array( 'fa-thin fa-futbol' => 'futbol' ),
					array( 'fa-thin fa-g' => 'g' ),
					array( 'fa-thin fa-galaxy' => 'galaxy' ),
					array( 'fa-thin fa-gallery-thumbnails' => 'gallery-thumbnails' ),
					array( 'fa-thin fa-game-board-simple' => 'game-board-simple' ),
					array( 'fa-thin fa-game-board' => 'game-board' ),
					array( 'fa-thin fa-game-console-handheld-crank' => 'game-console-handheld-crank' ),
					array( 'fa-thin fa-game-console-handheld' => 'game-console-handheld' ),
					array( 'fa-thin fa-gamepad-modern' => 'gamepad-modern' ),
					array( 'fa-thin fa-gamepad' => 'gamepad' ),
					array( 'fa-thin fa-garage-car' => 'garage-car' ),
					array( 'fa-thin fa-garage-open' => 'garage-open' ),
					array( 'fa-thin fa-garage' => 'garage' ),
					array( 'fa-thin fa-garlic' => 'garlic' ),
					array( 'fa-thin fa-gas-pump-slash' => 'gas-pump-slash' ),
					array( 'fa-thin fa-gas-pump' => 'gas-pump' ),
					array( 'fa-thin fa-gauge-circle-bolt' => 'gauge-circle-bolt' ),
					array( 'fa-thin fa-gauge-circle-minus' => 'gauge-circle-minus' ),
					array( 'fa-thin fa-gauge-circle-plus' => 'gauge-circle-plus' ),
					array( 'fa-thin fa-gauge-high' => 'gauge-high' ),
					array( 'fa-thin fa-gauge-low' => 'gauge-low' ),
					array( 'fa-thin fa-gauge-max' => 'gauge-max' ),
					array( 'fa-thin fa-gauge-min' => 'gauge-min' ),
					array( 'fa-thin fa-gauge-simple-high' => 'gauge-simple-high' ),
					array( 'fa-thin fa-gauge-simple-low' => 'gauge-simple-low' ),
					array( 'fa-thin fa-gauge-simple-max' => 'gauge-simple-max' ),
					array( 'fa-thin fa-gauge-simple-min' => 'gauge-simple-min' ),
					array( 'fa-thin fa-gauge-simple' => 'gauge-simple' ),
					array( 'fa-thin fa-gauge' => 'gauge' ),
					array( 'fa-thin fa-gavel' => 'gavel' ),
					array( 'fa-thin fa-gear-code' => 'gear-code' ),
					array( 'fa-thin fa-gear-complex-code' => 'gear-complex-code' ),
					array( 'fa-thin fa-gear-complex' => 'gear-complex' ),
					array( 'fa-thin fa-gear' => 'gear' ),
					array( 'fa-thin fa-gears' => 'gears' ),
					array( 'fa-thin fa-gem' => 'gem' ),
					array( 'fa-thin fa-genderless' => 'genderless' ),
					array( 'fa-thin fa-ghost' => 'ghost' ),
					array( 'fa-thin fa-gif' => 'gif' ),
					array( 'fa-thin fa-gift-card' => 'gift-card' ),
					array( 'fa-thin fa-gift' => 'gift' ),
					array( 'fa-thin fa-gifts' => 'gifts' ),
					array( 'fa-thin fa-gingerbread-man' => 'gingerbread-man' ),
					array( 'fa-thin fa-glass-citrus' => 'glass-citrus' ),
					array( 'fa-thin fa-glass-empty' => 'glass-empty' ),
					array( 'fa-thin fa-glass-half' => 'glass-half' ),
					array( 'fa-thin fa-glass-water-droplet' => 'glass-water-droplet' ),
					array( 'fa-thin fa-glass-water' => 'glass-water' ),
					array( 'fa-thin fa-glass' => 'glass' ),
					array( 'fa-thin fa-glasses-round' => 'glasses-round' ),
					array( 'fa-thin fa-glasses' => 'glasses' ),
					array( 'fa-thin fa-globe-pointer' => 'globe-pointer' ),
					array( 'fa-thin fa-globe-snow' => 'globe-snow' ),
					array( 'fa-thin fa-globe-stand' => 'globe-stand' ),
					array( 'fa-thin fa-globe' => 'globe' ),
					array( 'fa-thin fa-goal-net' => 'goal-net' ),
					array( 'fa-thin fa-golf-ball-tee' => 'golf-ball-tee' ),
					array( 'fa-thin fa-golf-club' => 'golf-club' ),
					array( 'fa-thin fa-golf-flag-hole' => 'golf-flag-hole' ),
					array( 'fa-thin fa-gopuram' => 'gopuram' ),
					array( 'fa-thin fa-graduation-cap' => 'graduation-cap' ),
					array( 'fa-thin fa-gramophone' => 'gramophone' ),
					array( 'fa-thin fa-grapes' => 'grapes' ),
					array( 'fa-thin fa-grate-droplet' => 'grate-droplet' ),
					array( 'fa-thin fa-grate' => 'grate' ),
					array( 'fa-thin fa-greater-than-equal' => 'greater-than-equal' ),
					array( 'fa-thin fa-greater-than' => 'greater-than' ),
					array( 'fa-thin fa-grid-2-plus' => 'grid-2-plus' ),
					array( 'fa-thin fa-grid-2' => 'grid-2' ),
					array( 'fa-thin fa-grid-4' => 'grid-4' ),
					array( 'fa-thin fa-grid-5' => 'grid-5' ),
					array( 'fa-thin fa-grid-dividers' => 'grid-dividers' ),
					array( 'fa-thin fa-grid-horizontal' => 'grid-horizontal' ),
					array( 'fa-thin fa-grid-round-2-plus' => 'grid-round-2-plus' ),
					array( 'fa-thin fa-grid-round-2' => 'grid-round-2' ),
					array( 'fa-thin fa-grid-round-4' => 'grid-round-4' ),
					array( 'fa-thin fa-grid-round-5' => 'grid-round-5' ),
					array( 'fa-thin fa-grid-round' => 'grid-round' ),
					array( 'fa-thin fa-grid' => 'grid' ),
					array( 'fa-thin fa-grill-fire' => 'grill-fire' ),
					array( 'fa-thin fa-grill-hot' => 'grill-hot' ),
					array( 'fa-thin fa-grill' => 'grill' ),
					array( 'fa-thin fa-grip-dots-vertical' => 'grip-dots-vertical' ),
					array( 'fa-thin fa-grip-dots' => 'grip-dots' ),
					array( 'fa-thin fa-grip-lines-vertical' => 'grip-lines-vertical' ),
					array( 'fa-thin fa-grip-lines' => 'grip-lines' ),
					array( 'fa-thin fa-grip-vertical' => 'grip-vertical' ),
					array( 'fa-thin fa-grip' => 'grip' ),
					array( 'fa-thin fa-group-arrows-rotate' => 'group-arrows-rotate' ),
					array( 'fa-thin fa-guarani-sign' => 'guarani-sign' ),
					array( 'fa-thin fa-guitar-electric' => 'guitar-electric' ),
					array( 'fa-thin fa-guitar' => 'guitar' ),
					array( 'fa-thin fa-guitars' => 'guitars' ),
					array( 'fa-thin fa-gun-slash' => 'gun-slash' ),
					array( 'fa-thin fa-gun-squirt' => 'gun-squirt' ),
					array( 'fa-thin fa-gun' => 'gun' ),
					array( 'fa-thin fa-h' => 'h' ),
					array( 'fa-thin fa-h1' => 'h1' ),
					array( 'fa-thin fa-h2' => 'h2' ),
					array( 'fa-thin fa-h3' => 'h3' ),
					array( 'fa-thin fa-h4' => 'h4' ),
					array( 'fa-thin fa-h5' => 'h5' ),
					array( 'fa-thin fa-h6' => 'h6' ),
					array( 'fa-thin fa-hammer-crash' => 'hammer-crash' ),
					array( 'fa-thin fa-hammer-war' => 'hammer-war' ),
					array( 'fa-thin fa-hammer' => 'hammer' ),
					array( 'fa-thin fa-hamsa' => 'hamsa' ),
					array( 'fa-thin fa-hand-back-fist' => 'hand-back-fist' ),
					array( 'fa-thin fa-hand-back-point-down' => 'hand-back-point-down' ),
					array( 'fa-thin fa-hand-back-point-left' => 'hand-back-point-left' ),
					array( 'fa-thin fa-hand-back-point-ribbon' => 'hand-back-point-ribbon' ),
					array( 'fa-thin fa-hand-back-point-right' => 'hand-back-point-right' ),
					array( 'fa-thin fa-hand-back-point-up' => 'hand-back-point-up' ),
					array( 'fa-thin fa-hand-dots' => 'hand-dots' ),
					array( 'fa-thin fa-hand-fingers-crossed' => 'hand-fingers-crossed' ),
					array( 'fa-thin fa-hand-fist' => 'hand-fist' ),
					array( 'fa-thin fa-hand-heart' => 'hand-heart' ),
					array( 'fa-thin fa-hand-holding-box' => 'hand-holding-box' ),
					array( 'fa-thin fa-hand-holding-dollar' => 'hand-holding-dollar' ),
					array( 'fa-thin fa-hand-holding-droplet' => 'hand-holding-droplet' ),
					array( 'fa-thin fa-hand-holding-hand' => 'hand-holding-hand' ),
					array( 'fa-thin fa-hand-holding-heart' => 'hand-holding-heart' ),
					array( 'fa-thin fa-hand-holding-magic' => 'hand-holding-magic' ),
					array( 'fa-thin fa-hand-holding-medical' => 'hand-holding-medical' ),
					array( 'fa-thin fa-hand-holding-seedling' => 'hand-holding-seedling' ),
					array( 'fa-thin fa-hand-holding-skull' => 'hand-holding-skull' ),
					array( 'fa-thin fa-hand-holding' => 'hand-holding' ),
					array( 'fa-thin fa-hand-horns' => 'hand-horns' ),
					array( 'fa-thin fa-hand-lizard' => 'hand-lizard' ),
					array( 'fa-thin fa-hand-love' => 'hand-love' ),
					array( 'fa-thin fa-hand-middle-finger' => 'hand-middle-finger' ),
					array( 'fa-thin fa-hand-peace' => 'hand-peace' ),
					array( 'fa-thin fa-hand-point-down' => 'hand-point-down' ),
					array( 'fa-thin fa-hand-point-left' => 'hand-point-left' ),
					array( 'fa-thin fa-hand-point-ribbon' => 'hand-point-ribbon' ),
					array( 'fa-thin fa-hand-point-right' => 'hand-point-right' ),
					array( 'fa-thin fa-hand-point-up' => 'hand-point-up' ),
					array( 'fa-thin fa-hand-pointer' => 'hand-pointer' ),
					array( 'fa-thin fa-hand-scissors' => 'hand-scissors' ),
					array( 'fa-thin fa-hand-sparkles' => 'hand-sparkles' ),
					array( 'fa-thin fa-hand-spock' => 'hand-spock' ),
					array( 'fa-thin fa-hand-wave' => 'hand-wave' ),
					array( 'fa-thin fa-hand' => 'hand' ),
					array( 'fa-thin fa-handcuffs' => 'handcuffs' ),
					array( 'fa-thin fa-hands-asl-interpreting' => 'hands-asl-interpreting' ),
					array( 'fa-thin fa-hands-bound' => 'hands-bound' ),
					array( 'fa-thin fa-hands-bubbles' => 'hands-bubbles' ),
					array( 'fa-thin fa-hands-clapping' => 'hands-clapping' ),
					array( 'fa-thin fa-hands-holding-child' => 'hands-holding-child' ),
					array( 'fa-thin fa-hands-holding-circle' => 'hands-holding-circle' ),
					array( 'fa-thin fa-hands-holding-diamond' => 'hands-holding-diamond' ),
					array( 'fa-thin fa-hands-holding-dollar' => 'hands-holding-dollar' ),
					array( 'fa-thin fa-hands-holding-heart' => 'hands-holding-heart' ),
					array( 'fa-thin fa-hands-holding' => 'hands-holding' ),
					array( 'fa-thin fa-hands-praying' => 'hands-praying' ),
					array( 'fa-thin fa-hands' => 'hands' ),
					array( 'fa-thin fa-handshake-angle' => 'handshake-angle' ),
					array( 'fa-thin fa-handshake-simple-slash' => 'handshake-simple-slash' ),
					array( 'fa-thin fa-handshake-simple' => 'handshake-simple' ),
					array( 'fa-thin fa-handshake-slash' => 'handshake-slash' ),
					array( 'fa-thin fa-handshake' => 'handshake' ),
					array( 'fa-thin fa-hanukiah' => 'hanukiah' ),
					array( 'fa-thin fa-hard-drive' => 'hard-drive' ),
					array( 'fa-thin fa-hashtag-lock' => 'hashtag-lock' ),
					array( 'fa-thin fa-hashtag' => 'hashtag' ),
					array( 'fa-thin fa-hat-beach' => 'hat-beach' ),
					array( 'fa-thin fa-hat-chef' => 'hat-chef' ),
					array( 'fa-thin fa-hat-cowboy-side' => 'hat-cowboy-side' ),
					array( 'fa-thin fa-hat-cowboy' => 'hat-cowboy' ),
					array( 'fa-thin fa-hat-santa' => 'hat-santa' ),
					array( 'fa-thin fa-hat-winter' => 'hat-winter' ),
					array( 'fa-thin fa-hat-witch' => 'hat-witch' ),
					array( 'fa-thin fa-hat-wizard' => 'hat-wizard' ),
					array( 'fa-thin fa-head-side-brain' => 'head-side-brain' ),
					array( 'fa-thin fa-head-side-cough-slash' => 'head-side-cough-slash' ),
					array( 'fa-thin fa-head-side-cough' => 'head-side-cough' ),
					array( 'fa-thin fa-head-side-gear' => 'head-side-gear' ),
					array( 'fa-thin fa-head-side-goggles' => 'head-side-goggles' ),
					array( 'fa-thin fa-head-side-headphones' => 'head-side-headphones' ),
					array( 'fa-thin fa-head-side-heart' => 'head-side-heart' ),
					array( 'fa-thin fa-head-side-mask' => 'head-side-mask' ),
					array( 'fa-thin fa-head-side-medical' => 'head-side-medical' ),
					array( 'fa-thin fa-head-side-virus' => 'head-side-virus' ),
					array( 'fa-thin fa-head-side' => 'head-side' ),
					array( 'fa-thin fa-heading' => 'heading' ),
					array( 'fa-thin fa-headphones-simple' => 'headphones-simple' ),
					array( 'fa-thin fa-headphones' => 'headphones' ),
					array( 'fa-thin fa-headset' => 'headset' ),
					array( 'fa-thin fa-heart-circle-bolt' => 'heart-circle-bolt' ),
					array( 'fa-thin fa-heart-circle-check' => 'heart-circle-check' ),
					array( 'fa-thin fa-heart-circle-exclamation' => 'heart-circle-exclamation' ),
					array( 'fa-thin fa-heart-circle-minus' => 'heart-circle-minus' ),
					array( 'fa-thin fa-heart-circle-plus' => 'heart-circle-plus' ),
					array( 'fa-thin fa-heart-circle-xmark' => 'heart-circle-xmark' ),
					array( 'fa-thin fa-heart-crack' => 'heart-crack' ),
					array( 'fa-thin fa-heart-half-stroke' => 'heart-half-stroke' ),
					array( 'fa-thin fa-heart-half' => 'heart-half' ),
					array( 'fa-thin fa-heart-pulse' => 'heart-pulse' ),
					array( 'fa-thin fa-heart' => 'heart' ),
					array( 'fa-thin fa-heat' => 'heat' ),
					array( 'fa-thin fa-helicopter-symbol' => 'helicopter-symbol' ),
					array( 'fa-thin fa-helicopter' => 'helicopter' ),
					array( 'fa-thin fa-helmet-battle' => 'helmet-battle' ),
					array( 'fa-thin fa-helmet-safety' => 'helmet-safety' ),
					array( 'fa-thin fa-helmet-un' => 'helmet-un' ),
					array( 'fa-thin fa-hexagon-check' => 'hexagon-check' ),
					array( 'fa-thin fa-hexagon-divide' => 'hexagon-divide' ),
					array( 'fa-thin fa-hexagon-exclamation' => 'hexagon-exclamation' ),
					array( 'fa-thin fa-hexagon-image' => 'hexagon-image' ),
					array( 'fa-thin fa-hexagon-minus' => 'hexagon-minus' ),
					array( 'fa-thin fa-hexagon-plus' => 'hexagon-plus' ),
					array( 'fa-thin fa-hexagon-vertical-nft-slanted' => 'hexagon-vertical-nft-slanted' ),
					array( 'fa-thin fa-hexagon-vertical-nft' => 'hexagon-vertical-nft' ),
					array( 'fa-thin fa-hexagon-xmark' => 'hexagon-xmark' ),
					array( 'fa-thin fa-hexagon' => 'hexagon' ),
					array( 'fa-thin fa-high-definition' => 'high-definition' ),
					array( 'fa-thin fa-highlighter-line' => 'highlighter-line' ),
					array( 'fa-thin fa-highlighter' => 'highlighter' ),
					array( 'fa-thin fa-hill-avalanche' => 'hill-avalanche' ),
					array( 'fa-thin fa-hill-rockslide' => 'hill-rockslide' ),
					array( 'fa-thin fa-hippo' => 'hippo' ),
					array( 'fa-thin fa-hockey-mask' => 'hockey-mask' ),
					array( 'fa-thin fa-hockey-puck' => 'hockey-puck' ),
					array( 'fa-thin fa-hockey-stick-puck' => 'hockey-stick-puck' ),
					array( 'fa-thin fa-hockey-sticks' => 'hockey-sticks' ),
					array( 'fa-thin fa-holly-berry' => 'holly-berry' ),
					array( 'fa-thin fa-honey-pot' => 'honey-pot' ),
					array( 'fa-thin fa-hood-cloak' => 'hood-cloak' ),
					array( 'fa-thin fa-horizontal-rule' => 'horizontal-rule' ),
					array( 'fa-thin fa-horse-head' => 'horse-head' ),
					array( 'fa-thin fa-horse-saddle' => 'horse-saddle' ),
					array( 'fa-thin fa-horse' => 'horse' ),
					array( 'fa-thin fa-hose-reel' => 'hose-reel' ),
					array( 'fa-thin fa-hose' => 'hose' ),
					array( 'fa-thin fa-hospital-user' => 'hospital-user' ),
					array( 'fa-thin fa-hospital' => 'hospital' ),
					array( 'fa-thin fa-hospitals' => 'hospitals' ),
					array( 'fa-thin fa-hot-tub-person' => 'hot-tub-person' ),
					array( 'fa-thin fa-hotdog' => 'hotdog' ),
					array( 'fa-thin fa-hotel' => 'hotel' ),
					array( 'fa-thin fa-hourglass-clock' => 'hourglass-clock' ),
					array( 'fa-thin fa-hourglass-end' => 'hourglass-end' ),
					array( 'fa-thin fa-hourglass-half' => 'hourglass-half' ),
					array( 'fa-thin fa-hourglass-start' => 'hourglass-start' ),
					array( 'fa-thin fa-hourglass' => 'hourglass' ),
					array( 'fa-thin fa-house-blank' => 'house-blank' ),
					array( 'fa-thin fa-house-building' => 'house-building' ),
					array( 'fa-thin fa-house-chimney-blank' => 'house-chimney-blank' ),
					array( 'fa-thin fa-house-chimney-crack' => 'house-chimney-crack' ),
					array( 'fa-thin fa-house-chimney-heart' => 'house-chimney-heart' ),
					array( 'fa-thin fa-house-chimney-medical' => 'house-chimney-medical' ),
					array( 'fa-thin fa-house-chimney-user' => 'house-chimney-user' ),
					array( 'fa-thin fa-house-chimney-window' => 'house-chimney-window' ),
					array( 'fa-thin fa-house-chimney' => 'house-chimney' ),
					array( 'fa-thin fa-house-circle-check' => 'house-circle-check' ),
					array( 'fa-thin fa-house-circle-exclamation' => 'house-circle-exclamation' ),
					array( 'fa-thin fa-house-circle-xmark' => 'house-circle-xmark' ),
					array( 'fa-thin fa-house-crack' => 'house-crack' ),
					array( 'fa-thin fa-house-day' => 'house-day' ),
					array( 'fa-thin fa-house-fire' => 'house-fire' ),
					array( 'fa-thin fa-house-flag' => 'house-flag' ),
					array( 'fa-thin fa-house-flood-water-circle-arrow-right' => 'house-flood-water-circle-arrow-right' ),
					array( 'fa-thin fa-house-flood-water' => 'house-flood-water' ),
					array( 'fa-thin fa-house-heart' => 'house-heart' ),
					array( 'fa-thin fa-house-laptop' => 'house-laptop' ),
					array( 'fa-thin fa-house-lock' => 'house-lock' ),
					array( 'fa-thin fa-house-medical-circle-check' => 'house-medical-circle-check' ),
					array( 'fa-thin fa-house-medical-circle-exclamation' => 'house-medical-circle-exclamation' ),
					array( 'fa-thin fa-house-medical-circle-xmark' => 'house-medical-circle-xmark' ),
					array( 'fa-thin fa-house-medical-flag' => 'house-medical-flag' ),
					array( 'fa-thin fa-house-medical' => 'house-medical' ),
					array( 'fa-thin fa-house-night' => 'house-night' ),
					array( 'fa-thin fa-house-person-leave' => 'house-person-leave' ),
					array( 'fa-thin fa-house-person-return' => 'house-person-return' ),
					array( 'fa-thin fa-house-signal' => 'house-signal' ),
					array( 'fa-thin fa-house-tree' => 'house-tree' ),
					array( 'fa-thin fa-house-tsunami' => 'house-tsunami' ),
					array( 'fa-thin fa-house-turret' => 'house-turret' ),
					array( 'fa-thin fa-house-user' => 'house-user' ),
					array( 'fa-thin fa-house-water' => 'house-water' ),
					array( 'fa-thin fa-house-window' => 'house-window' ),
					array( 'fa-thin fa-house' => 'house' ),
					array( 'fa-thin fa-hryvnia-sign' => 'hryvnia-sign' ),
					array( 'fa-thin fa-hundred-points' => 'hundred-points' ),
					array( 'fa-thin fa-hurricane' => 'hurricane' ),
					array( 'fa-thin fa-hyphen' => 'hyphen' ),
					array( 'fa-thin fa-i-cursor' => 'i-cursor' ),
					array( 'fa-thin fa-i' => 'i' ),
					array( 'fa-thin fa-ice-cream' => 'ice-cream' ),
					array( 'fa-thin fa-ice-skate' => 'ice-skate' ),
					array( 'fa-thin fa-icicles' => 'icicles' ),
					array( 'fa-thin fa-icons' => 'icons' ),
					array( 'fa-thin fa-id-badge' => 'id-badge' ),
					array( 'fa-thin fa-id-card-clip' => 'id-card-clip' ),
					array( 'fa-thin fa-id-card' => 'id-card' ),
					array( 'fa-thin fa-igloo' => 'igloo' ),
					array( 'fa-thin fa-image-landscape' => 'image-landscape' ),
					array( 'fa-thin fa-image-polaroid-user' => 'image-polaroid-user' ),
					array( 'fa-thin fa-image-polaroid' => 'image-polaroid' ),
					array( 'fa-thin fa-image-portrait' => 'image-portrait' ),
					array( 'fa-thin fa-image-slash' => 'image-slash' ),
					array( 'fa-thin fa-image-user' => 'image-user' ),
					array( 'fa-thin fa-image' => 'image' ),
					array( 'fa-thin fa-images-user' => 'images-user' ),
					array( 'fa-thin fa-images' => 'images' ),
					array( 'fa-thin fa-inbox-full' => 'inbox-full' ),
					array( 'fa-thin fa-inbox-in' => 'inbox-in' ),
					array( 'fa-thin fa-inbox-out' => 'inbox-out' ),
					array( 'fa-thin fa-inbox' => 'inbox' ),
					array( 'fa-thin fa-inboxes' => 'inboxes' ),
					array( 'fa-thin fa-indent' => 'indent' ),
					array( 'fa-thin fa-indian-rupee-sign' => 'indian-rupee-sign' ),
					array( 'fa-thin fa-industry-windows' => 'industry-windows' ),
					array( 'fa-thin fa-industry' => 'industry' ),
					array( 'fa-thin fa-infinity' => 'infinity' ),
					array( 'fa-thin fa-info' => 'info' ),
					array( 'fa-thin fa-inhaler' => 'inhaler' ),
					array( 'fa-thin fa-input-numeric' => 'input-numeric' ),
					array( 'fa-thin fa-input-pipe' => 'input-pipe' ),
					array( 'fa-thin fa-input-text' => 'input-text' ),
					array( 'fa-thin fa-integral' => 'integral' ),
					array( 'fa-thin fa-interrobang' => 'interrobang' ),
					array( 'fa-thin fa-intersection' => 'intersection' ),
					array( 'fa-thin fa-island-tropical' => 'island-tropical' ),
					array( 'fa-thin fa-italic' => 'italic' ),
					array( 'fa-thin fa-j' => 'j' ),
					array( 'fa-thin fa-jack-o-lantern' => 'jack-o-lantern' ),
					array( 'fa-thin fa-jar-wheat' => 'jar-wheat' ),
					array( 'fa-thin fa-jar' => 'jar' ),
					array( 'fa-thin fa-jedi' => 'jedi' ),
					array( 'fa-thin fa-jet-fighter-up' => 'jet-fighter-up' ),
					array( 'fa-thin fa-jet-fighter' => 'jet-fighter' ),
					array( 'fa-thin fa-joint' => 'joint' ),
					array( 'fa-thin fa-joystick' => 'joystick' ),
					array( 'fa-thin fa-jug-bottle' => 'jug-bottle' ),
					array( 'fa-thin fa-jug-detergent' => 'jug-detergent' ),
					array( 'fa-thin fa-jug' => 'jug' ),
					array( 'fa-thin fa-k' => 'k' ),
					array( 'fa-thin fa-kaaba' => 'kaaba' ),
					array( 'fa-thin fa-kazoo' => 'kazoo' ),
					array( 'fa-thin fa-kerning' => 'kerning' ),
					array( 'fa-thin fa-key-skeleton-left-right' => 'key-skeleton-left-right' ),
					array( 'fa-thin fa-key-skeleton' => 'key-skeleton' ),
					array( 'fa-thin fa-key' => 'key' ),
					array( 'fa-thin fa-keyboard-brightness-low' => 'keyboard-brightness-low' ),
					array( 'fa-thin fa-keyboard-brightness' => 'keyboard-brightness' ),
					array( 'fa-thin fa-keyboard-down' => 'keyboard-down' ),
					array( 'fa-thin fa-keyboard-left' => 'keyboard-left' ),
					array( 'fa-thin fa-keyboard' => 'keyboard' ),
					array( 'fa-thin fa-keynote' => 'keynote' ),
					array( 'fa-thin fa-khanda' => 'khanda' ),
					array( 'fa-thin fa-kidneys' => 'kidneys' ),
					array( 'fa-thin fa-kip-sign' => 'kip-sign' ),
					array( 'fa-thin fa-kit-medical' => 'kit-medical' ),
					array( 'fa-thin fa-kitchen-set' => 'kitchen-set' ),
					array( 'fa-thin fa-kite' => 'kite' ),
					array( 'fa-thin fa-kiwi-bird' => 'kiwi-bird' ),
					array( 'fa-thin fa-kiwi-fruit' => 'kiwi-fruit' ),
					array( 'fa-thin fa-knife-kitchen' => 'knife-kitchen' ),
					array( 'fa-thin fa-knife' => 'knife' ),
					array( 'fa-thin fa-l' => 'l' ),
					array( 'fa-thin fa-lacrosse-stick-ball' => 'lacrosse-stick-ball' ),
					array( 'fa-thin fa-lacrosse-stick' => 'lacrosse-stick' ),
					array( 'fa-thin fa-lambda' => 'lambda' ),
					array( 'fa-thin fa-lamp-desk' => 'lamp-desk' ),
					array( 'fa-thin fa-lamp-floor' => 'lamp-floor' ),
					array( 'fa-thin fa-lamp-street' => 'lamp-street' ),
					array( 'fa-thin fa-lamp' => 'lamp' ),
					array( 'fa-thin fa-land-mine-on' => 'land-mine-on' ),
					array( 'fa-thin fa-landmark-dome' => 'landmark-dome' ),
					array( 'fa-thin fa-landmark-flag' => 'landmark-flag' ),
					array( 'fa-thin fa-landmark' => 'landmark' ),
					array( 'fa-thin fa-language' => 'language' ),
					array( 'fa-thin fa-laptop-arrow-down' => 'laptop-arrow-down' ),
					array( 'fa-thin fa-laptop-binary' => 'laptop-binary' ),
					array( 'fa-thin fa-laptop-code' => 'laptop-code' ),
					array( 'fa-thin fa-laptop-file' => 'laptop-file' ),
					array( 'fa-thin fa-laptop-medical' => 'laptop-medical' ),
					array( 'fa-thin fa-laptop-mobile' => 'laptop-mobile' ),
					array( 'fa-thin fa-laptop-slash' => 'laptop-slash' ),
					array( 'fa-thin fa-laptop' => 'laptop' ),
					array( 'fa-thin fa-lari-sign' => 'lari-sign' ),
					array( 'fa-thin fa-lasso-sparkles' => 'lasso-sparkles' ),
					array( 'fa-thin fa-lasso' => 'lasso' ),
					array( 'fa-thin fa-layer-group' => 'layer-group' ),
					array( 'fa-thin fa-layer-minus' => 'layer-minus' ),
					array( 'fa-thin fa-layer-plus' => 'layer-plus' ),
					array( 'fa-thin fa-leaf-heart' => 'leaf-heart' ),
					array( 'fa-thin fa-leaf-maple' => 'leaf-maple' ),
					array( 'fa-thin fa-leaf-oak' => 'leaf-oak' ),
					array( 'fa-thin fa-leaf' => 'leaf' ),
					array( 'fa-thin fa-leafy-green' => 'leafy-green' ),
					array( 'fa-thin fa-left-from-line' => 'left-from-line' ),
					array( 'fa-thin fa-left-long-to-line' => 'left-long-to-line' ),
					array( 'fa-thin fa-left-long' => 'left-long' ),
					array( 'fa-thin fa-left-right' => 'left-right' ),
					array( 'fa-thin fa-left-to-line' => 'left-to-line' ),
					array( 'fa-thin fa-left' => 'left' ),
					array( 'fa-thin fa-lemon' => 'lemon' ),
					array( 'fa-thin fa-less-than-equal' => 'less-than-equal' ),
					array( 'fa-thin fa-less-than' => 'less-than' ),
					array( 'fa-thin fa-life-ring' => 'life-ring' ),
					array( 'fa-thin fa-thin-ceiling' => 'light-ceiling' ),
					array( 'fa-thin fa-thin-emergency-on' => 'light-emergency-on' ),
					array( 'fa-thin fa-thin-emergency' => 'light-emergency' ),
					array( 'fa-thin fa-thin-switch-off' => 'light-switch-off' ),
					array( 'fa-thin fa-thin-switch-on' => 'light-switch-on' ),
					array( 'fa-thin fa-thin-switch' => 'light-switch' ),
					array( 'fa-thin fa-thinbulb-cfl-on' => 'lightbulb-cfl-on' ),
					array( 'fa-thin fa-thinbulb-cfl' => 'lightbulb-cfl' ),
					array( 'fa-thin fa-thinbulb-dollar' => 'lightbulb-dollar' ),
					array( 'fa-thin fa-thinbulb-exclamatin-on' => 'lightbulb-exclamatin-on' ),
					array( 'fa-thin fa-thinbulb-exclamation' => 'lightbulb-exclamation' ),
					array( 'fa-thin fa-thinbulb-gear' => 'lightbulb-gear' ),
					array( 'fa-thin fa-thinbulb-on' => 'lightbulb-on' ),
					array( 'fa-thin fa-thinbulb-slash' => 'lightbulb-slash' ),
					array( 'fa-thin fa-thinbulb' => 'lightbulb' ),
					array( 'fa-thin fa-thinhouse' => 'lighthouse' ),
					array( 'fa-thin fa-thins-holiday' => 'lights-holiday' ),
					array( 'fa-thin fa-line-columns' => 'line-columns' ),
					array( 'fa-thin fa-line-height' => 'line-height' ),
					array( 'fa-thin fa-lines-leaning' => 'lines-leaning' ),
					array( 'fa-thin fa-link-horizontal-slash' => 'link-horizontal-slash' ),
					array( 'fa-thin fa-link-horizontal' => 'link-horizontal' ),
					array( 'fa-thin fa-link-simple-slash' => 'link-simple-slash' ),
					array( 'fa-thin fa-link-simple' => 'link-simple' ),
					array( 'fa-thin fa-link-slash' => 'link-slash' ),
					array( 'fa-thin fa-link' => 'link' ),
					array( 'fa-thin fa-lips' => 'lips' ),
					array( 'fa-thin fa-lira-sign' => 'lira-sign' ),
					array( 'fa-thin fa-list-check' => 'list-check' ),
					array( 'fa-thin fa-list-dropdown' => 'list-dropdown' ),
					array( 'fa-thin fa-list-music' => 'list-music' ),
					array( 'fa-thin fa-list-ol' => 'list-ol' ),
					array( 'fa-thin fa-list-radio' => 'list-radio' ),
					array( 'fa-thin fa-list-timeline' => 'list-timeline' ),
					array( 'fa-thin fa-list-tree' => 'list-tree' ),
					array( 'fa-thin fa-list-ul' => 'list-ul' ),
					array( 'fa-thin fa-list' => 'list' ),
					array( 'fa-thin fa-litecoin-sign' => 'litecoin-sign' ),
					array( 'fa-thin fa-loader' => 'loader' ),
					array( 'fa-thin fa-lobster' => 'lobster' ),
					array( 'fa-thin fa-location-arrow' => 'location-arrow' ),
					array( 'fa-thin fa-location-check' => 'location-check' ),
					array( 'fa-thin fa-location-crosshairs-slash' => 'location-crosshairs-slash' ),
					array( 'fa-thin fa-location-crosshairs' => 'location-crosshairs' ),
					array( 'fa-thin fa-location-dot-slash' => 'location-dot-slash' ),
					array( 'fa-thin fa-location-dot' => 'location-dot' ),
					array( 'fa-thin fa-location-exclamation' => 'location-exclamation' ),
					array( 'fa-thin fa-location-minus' => 'location-minus' ),
					array( 'fa-thin fa-location-pen' => 'location-pen' ),
					array( 'fa-thin fa-location-pin-lock' => 'location-pin-lock' ),
					array( 'fa-thin fa-location-pin-slash' => 'location-pin-slash' ),
					array( 'fa-thin fa-location-pin' => 'location-pin' ),
					array( 'fa-thin fa-location-plus' => 'location-plus' ),
					array( 'fa-thin fa-location-question' => 'location-question' ),
					array( 'fa-thin fa-location-smile' => 'location-smile' ),
					array( 'fa-thin fa-location-xmark' => 'location-xmark' ),
					array( 'fa-thin fa-lock-a' => 'lock-a' ),
					array( 'fa-thin fa-lock-hashtag' => 'lock-hashtag' ),
					array( 'fa-thin fa-lock-keyhole-open' => 'lock-keyhole-open' ),
					array( 'fa-thin fa-lock-keyhole' => 'lock-keyhole' ),
					array( 'fa-thin fa-lock-open' => 'lock-open' ),
					array( 'fa-thin fa-lock' => 'lock' ),
					array( 'fa-thin fa-locust' => 'locust' ),
					array( 'fa-thin fa-lollipop' => 'lollipop' ),
					array( 'fa-thin fa-loveseat' => 'loveseat' ),
					array( 'fa-thin fa-luchador-mask' => 'luchador-mask' ),
					array( 'fa-thin fa-lungs-virus' => 'lungs-virus' ),
					array( 'fa-thin fa-lungs' => 'lungs' ),
					array( 'fa-thin fa-m' => 'm' ),
					array( 'fa-thin fa-mace' => 'mace' ),
					array( 'fa-thin fa-magnet' => 'magnet' ),
					array( 'fa-thin fa-magnifying-glass-arrow-right' => 'magnifying-glass-arrow-right' ),
					array( 'fa-thin fa-magnifying-glass-chart' => 'magnifying-glass-chart' ),
					array( 'fa-thin fa-magnifying-glass-dollar' => 'magnifying-glass-dollar' ),
					array( 'fa-thin fa-magnifying-glass-location' => 'magnifying-glass-location' ),
					array( 'fa-thin fa-magnifying-glass-minus' => 'magnifying-glass-minus' ),
					array( 'fa-thin fa-magnifying-glass-plus' => 'magnifying-glass-plus' ),
					array( 'fa-thin fa-magnifying-glass' => 'magnifying-glass' ),
					array( 'fa-thin fa-mailbox-flag-up' => 'mailbox-flag-up' ),
					array( 'fa-thin fa-mailbox' => 'mailbox' ),
					array( 'fa-thin fa-manat-sign' => 'manat-sign' ),
					array( 'fa-thin fa-mandolin' => 'mandolin' ),
					array( 'fa-thin fa-mango' => 'mango' ),
					array( 'fa-thin fa-manhole' => 'manhole' ),
					array( 'fa-thin fa-map-location-dot' => 'map-location-dot' ),
					array( 'fa-thin fa-map-location' => 'map-location' ),
					array( 'fa-thin fa-map-pin' => 'map-pin' ),
					array( 'fa-thin fa-map' => 'map' ),
					array( 'fa-thin fa-marker' => 'marker' ),
					array( 'fa-thin fa-mars-and-venus-burst' => 'mars-and-venus-burst' ),
					array( 'fa-thin fa-mars-and-venus' => 'mars-and-venus' ),
					array( 'fa-thin fa-mars-double' => 'mars-double' ),
					array( 'fa-thin fa-mars-stroke-right' => 'mars-stroke-right' ),
					array( 'fa-thin fa-mars-stroke-up' => 'mars-stroke-up' ),
					array( 'fa-thin fa-mars-stroke' => 'mars-stroke' ),
					array( 'fa-thin fa-mars' => 'mars' ),
					array( 'fa-thin fa-martini-glass-citrus' => 'martini-glass-citrus' ),
					array( 'fa-thin fa-martini-glass-empty' => 'martini-glass-empty' ),
					array( 'fa-thin fa-martini-glass' => 'martini-glass' ),
					array( 'fa-thin fa-mask-face' => 'mask-face' ),
					array( 'fa-thin fa-mask-snorkel' => 'mask-snorkel' ),
					array( 'fa-thin fa-mask-ventilator' => 'mask-ventilator' ),
					array( 'fa-thin fa-mask' => 'mask' ),
					array( 'fa-thin fa-masks-theater' => 'masks-theater' ),
					array( 'fa-thin fa-mattress-pillow' => 'mattress-pillow' ),
					array( 'fa-thin fa-maximize' => 'maximize' ),
					array( 'fa-thin fa-meat' => 'meat' ),
					array( 'fa-thin fa-medal' => 'medal' ),
					array( 'fa-thin fa-megaphone' => 'megaphone' ),
					array( 'fa-thin fa-melon-slice' => 'melon-slice' ),
					array( 'fa-thin fa-melon' => 'melon' ),
					array( 'fa-thin fa-memo-circle-check' => 'memo-circle-check' ),
					array( 'fa-thin fa-memo-circle-info' => 'memo-circle-info' ),
					array( 'fa-thin fa-memo-pad' => 'memo-pad' ),
					array( 'fa-thin fa-memo' => 'memo' ),
					array( 'fa-thin fa-memory' => 'memory' ),
					array( 'fa-thin fa-menorah' => 'menorah' ),
					array( 'fa-thin fa-mercury' => 'mercury' ),
					array( 'fa-thin fa-merge' => 'merge' ),
					array( 'fa-thin fa-message-arrow-down' => 'message-arrow-down' ),
					array( 'fa-thin fa-message-arrow-up-right' => 'message-arrow-up-right' ),
					array( 'fa-thin fa-message-arrow-up' => 'message-arrow-up' ),
					array( 'fa-thin fa-message-bot' => 'message-bot' ),
					array( 'fa-thin fa-message-captions' => 'message-captions' ),
					array( 'fa-thin fa-message-check' => 'message-check' ),
					array( 'fa-thin fa-message-code' => 'message-code' ),
					array( 'fa-thin fa-message-dollar' => 'message-dollar' ),
					array( 'fa-thin fa-message-dots' => 'message-dots' ),
					array( 'fa-thin fa-message-exclamation' => 'message-exclamation' ),
					array( 'fa-thin fa-message-heart' => 'message-heart' ),
					array( 'fa-thin fa-message-image' => 'message-image' ),
					array( 'fa-thin fa-message-lines' => 'message-lines' ),
					array( 'fa-thin fa-message-medical' => 'message-medical' ),
					array( 'fa-thin fa-message-middle-top' => 'message-middle-top' ),
					array( 'fa-thin fa-message-middle' => 'message-middle' ),
					array( 'fa-thin fa-message-minus' => 'message-minus' ),
					array( 'fa-thin fa-message-music' => 'message-music' ),
					array( 'fa-thin fa-message-pen' => 'message-pen' ),
					array( 'fa-thin fa-message-plus' => 'message-plus' ),
					array( 'fa-thin fa-message-question' => 'message-question' ),
					array( 'fa-thin fa-message-quote' => 'message-quote' ),
					array( 'fa-thin fa-message-slash' => 'message-slash' ),
					array( 'fa-thin fa-message-smile' => 'message-smile' ),
					array( 'fa-thin fa-message-sms' => 'message-sms' ),
					array( 'fa-thin fa-message-text' => 'message-text' ),
					array( 'fa-thin fa-message-xmark' => 'message-xmark' ),
					array( 'fa-thin fa-message' => 'message' ),
					array( 'fa-thin fa-messages-dollar' => 'messages-dollar' ),
					array( 'fa-thin fa-messages-question' => 'messages-question' ),
					array( 'fa-thin fa-messages' => 'messages' ),
					array( 'fa-thin fa-meteor' => 'meteor' ),
					array( 'fa-thin fa-meter-bolt' => 'meter-bolt' ),
					array( 'fa-thin fa-meter-droplet' => 'meter-droplet' ),
					array( 'fa-thin fa-meter-fire' => 'meter-fire' ),
					array( 'fa-thin fa-meter' => 'meter' ),
					array( 'fa-thin fa-microchip-ai' => 'microchip-ai' ),
					array( 'fa-thin fa-microchip' => 'microchip' ),
					array( 'fa-thin fa-microphone-lines-slash' => 'microphone-lines-slash' ),
					array( 'fa-thin fa-microphone-lines' => 'microphone-lines' ),
					array( 'fa-thin fa-microphone-slash' => 'microphone-slash' ),
					array( 'fa-thin fa-microphone-stand' => 'microphone-stand' ),
					array( 'fa-thin fa-microphone' => 'microphone' ),
					array( 'fa-thin fa-microscope' => 'microscope' ),
					array( 'fa-thin fa-microwave' => 'microwave' ),
					array( 'fa-thin fa-mill-sign' => 'mill-sign' ),
					array( 'fa-thin fa-minimize' => 'minimize' ),
					array( 'fa-thin fa-minus' => 'minus' ),
					array( 'fa-thin fa-mistletoe' => 'mistletoe' ),
					array( 'fa-thin fa-mitten' => 'mitten' ),
					array( 'fa-thin fa-mobile-button' => 'mobile-button' ),
					array( 'fa-thin fa-mobile-notch' => 'mobile-notch' ),
					array( 'fa-thin fa-mobile-retro' => 'mobile-retro' ),
					array( 'fa-thin fa-mobile-screen-button' => 'mobile-screen-button' ),
					array( 'fa-thin fa-mobile-screen' => 'mobile-screen' ),
					array( 'fa-thin fa-mobile-signal-out' => 'mobile-signal-out' ),
					array( 'fa-thin fa-mobile-signal' => 'mobile-signal' ),
					array( 'fa-thin fa-mobile' => 'mobile' ),
					array( 'fa-thin fa-money-bill-1-wave' => 'money-bill-1-wave' ),
					array( 'fa-thin fa-money-bill-1' => 'money-bill-1' ),
					array( 'fa-thin fa-money-bill-simple-wave' => 'money-bill-simple-wave' ),
					array( 'fa-thin fa-money-bill-simple' => 'money-bill-simple' ),
					array( 'fa-thin fa-money-bill-transfer' => 'money-bill-transfer' ),
					array( 'fa-thin fa-money-bill-trend-up' => 'money-bill-trend-up' ),
					array( 'fa-thin fa-money-bill-wave' => 'money-bill-wave' ),
					array( 'fa-thin fa-money-bill-wheat' => 'money-bill-wheat' ),
					array( 'fa-thin fa-money-bill' => 'money-bill' ),
					array( 'fa-thin fa-money-bills-simple' => 'money-bills-simple' ),
					array( 'fa-thin fa-money-bills' => 'money-bills' ),
					array( 'fa-thin fa-money-check-dollar-pen' => 'money-check-dollar-pen' ),
					array( 'fa-thin fa-money-check-dollar' => 'money-check-dollar' ),
					array( 'fa-thin fa-money-check-pen' => 'money-check-pen' ),
					array( 'fa-thin fa-money-check' => 'money-check' ),
					array( 'fa-thin fa-money-from-bracket' => 'money-from-bracket' ),
					array( 'fa-thin fa-money-simple-from-bracket' => 'money-simple-from-bracket' ),
					array( 'fa-thin fa-monitor-waveform' => 'monitor-waveform' ),
					array( 'fa-thin fa-monkey' => 'monkey' ),
					array( 'fa-thin fa-monument' => 'monument' ),
					array( 'fa-thin fa-moon-cloud' => 'moon-cloud' ),
					array( 'fa-thin fa-moon-over-sun' => 'moon-over-sun' ),
					array( 'fa-thin fa-moon-stars' => 'moon-stars' ),
					array( 'fa-thin fa-moon' => 'moon' ),
					array( 'fa-thin fa-moped' => 'moped' ),
					array( 'fa-thin fa-mortar-pestle' => 'mortar-pestle' ),
					array( 'fa-thin fa-mosque' => 'mosque' ),
					array( 'fa-thin fa-mosquito-net' => 'mosquito-net' ),
					array( 'fa-thin fa-mosquito' => 'mosquito' ),
					array( 'fa-thin fa-motorcycle' => 'motorcycle' ),
					array( 'fa-thin fa-mound' => 'mound' ),
					array( 'fa-thin fa-mountain-city' => 'mountain-city' ),
					array( 'fa-thin fa-mountain-sun' => 'mountain-sun' ),
					array( 'fa-thin fa-mountain' => 'mountain' ),
					array( 'fa-thin fa-mountains' => 'mountains' ),
					array( 'fa-thin fa-mouse-field' => 'mouse-field' ),
					array( 'fa-thin fa-mp3-player' => 'mp3-player' ),
					array( 'fa-thin fa-mug-hot' => 'mug-hot' ),
					array( 'fa-thin fa-mug-marshmallows' => 'mug-marshmallows' ),
					array( 'fa-thin fa-mug-saucer' => 'mug-saucer' ),
					array( 'fa-thin fa-mug-tea-saucer' => 'mug-tea-saucer' ),
					array( 'fa-thin fa-mug-tea' => 'mug-tea' ),
					array( 'fa-thin fa-mug' => 'mug' ),
					array( 'fa-thin fa-mushroom' => 'mushroom' ),
					array( 'fa-thin fa-music-note-slash' => 'music-note-slash' ),
					array( 'fa-thin fa-music-note' => 'music-note' ),
					array( 'fa-thin fa-music-slash' => 'music-slash' ),
					array( 'fa-thin fa-music' => 'music' ),
					array( 'fa-thin fa-mustache' => 'mustache' ),
					array( 'fa-thin fa-n' => 'n' ),
					array( 'fa-thin fa-naira-sign' => 'naira-sign' ),
					array( 'fa-thin fa-narwhal' => 'narwhal' ),
					array( 'fa-thin fa-nesting-dolls' => 'nesting-dolls' ),
					array( 'fa-thin fa-network-wired' => 'network-wired' ),
					array( 'fa-thin fa-neuter' => 'neuter' ),
					array( 'fa-thin fa-newspaper' => 'newspaper' ),
					array( 'fa-thin fa-nfc-lock' => 'nfc-lock' ),
					array( 'fa-thin fa-nfc-magnifying-glass' => 'nfc-magnifying-glass' ),
					array( 'fa-thin fa-nfc-pen' => 'nfc-pen' ),
					array( 'fa-thin fa-nfc-signal' => 'nfc-signal' ),
					array( 'fa-thin fa-nfc-slash' => 'nfc-slash' ),
					array( 'fa-thin fa-nfc-symbol' => 'nfc-symbol' ),
					array( 'fa-thin fa-nfc-trash' => 'nfc-trash' ),
					array( 'fa-thin fa-nfc' => 'nfc' ),
					array( 'fa-thin fa-nose' => 'nose' ),
					array( 'fa-thin fa-not-equal' => 'not-equal' ),
					array( 'fa-thin fa-notdef' => 'notdef' ),
					array( 'fa-thin fa-note-medical' => 'note-medical' ),
					array( 'fa-thin fa-note-sticky' => 'note-sticky' ),
					array( 'fa-thin fa-note' => 'note' ),
					array( 'fa-thin fa-notebook' => 'notebook' ),
					array( 'fa-thin fa-notes-medical' => 'notes-medical' ),
					array( 'fa-thin fa-notes' => 'notes' ),
					array( 'fa-thin fa-o' => 'o' ),
					array( 'fa-thin fa-object-exclude' => 'object-exclude' ),
					array( 'fa-thin fa-object-group' => 'object-group' ),
					array( 'fa-thin fa-object-intersect' => 'object-intersect' ),
					array( 'fa-thin fa-object-subtract' => 'object-subtract' ),
					array( 'fa-thin fa-object-ungroup' => 'object-ungroup' ),
					array( 'fa-thin fa-object-union' => 'object-union' ),
					array( 'fa-thin fa-objects-align-bottom' => 'objects-align-bottom' ),
					array( 'fa-thin fa-objects-align-center-horizontal' => 'objects-align-center-horizontal' ),
					array( 'fa-thin fa-objects-align-center-vertical' => 'objects-align-center-vertical' ),
					array( 'fa-thin fa-objects-align-left' => 'objects-align-left' ),
					array( 'fa-thin fa-objects-align-right' => 'objects-align-right' ),
					array( 'fa-thin fa-objects-align-top' => 'objects-align-top' ),
					array( 'fa-thin fa-objects-column' => 'objects-column' ),
					array( 'fa-thin fa-octagon-check' => 'octagon-check' ),
					array( 'fa-thin fa-octagon-divide' => 'octagon-divide' ),
					array( 'fa-thin fa-octagon-exclamation' => 'octagon-exclamation' ),
					array( 'fa-thin fa-octagon-minus' => 'octagon-minus' ),
					array( 'fa-thin fa-octagon-plus' => 'octagon-plus' ),
					array( 'fa-thin fa-octagon-xmark' => 'octagon-xmark' ),
					array( 'fa-thin fa-octagon' => 'octagon' ),
					array( 'fa-thin fa-oil-can-drip' => 'oil-can-drip' ),
					array( 'fa-thin fa-oil-can' => 'oil-can' ),
					array( 'fa-thin fa-oil-temperature' => 'oil-temperature' ),
					array( 'fa-thin fa-oil-well' => 'oil-well' ),
					array( 'fa-thin fa-olive-branch' => 'olive-branch' ),
					array( 'fa-thin fa-olive' => 'olive' ),
					array( 'fa-thin fa-om' => 'om' ),
					array( 'fa-thin fa-omega' => 'omega' ),
					array( 'fa-thin fa-onion' => 'onion' ),
					array( 'fa-thin fa-option' => 'option' ),
					array( 'fa-thin fa-ornament' => 'ornament' ),
					array( 'fa-thin fa-otter' => 'otter' ),
					array( 'fa-thin fa-outdent' => 'outdent' ),
					array( 'fa-thin fa-outlet' => 'outlet' ),
					array( 'fa-thin fa-oven' => 'oven' ),
					array( 'fa-thin fa-overline' => 'overline' ),
					array( 'fa-thin fa-p' => 'p' ),
					array( 'fa-thin fa-page-caret-down' => 'page-caret-down' ),
					array( 'fa-thin fa-page-caret-up' => 'page-caret-up' ),
					array( 'fa-thin fa-page' => 'page' ),
					array( 'fa-thin fa-pager' => 'pager' ),
					array( 'fa-thin fa-paint-roller' => 'paint-roller' ),
					array( 'fa-thin fa-paintbrush-fine' => 'paintbrush-fine' ),
					array( 'fa-thin fa-paintbrush-pencil' => 'paintbrush-pencil' ),
					array( 'fa-thin fa-paintbrush' => 'paintbrush' ),
					array( 'fa-thin fa-palette' => 'palette' ),
					array( 'fa-thin fa-pallet-box' => 'pallet-box' ),
					array( 'fa-thin fa-pallet-boxes' => 'pallet-boxes' ),
					array( 'fa-thin fa-pallet' => 'pallet' ),
					array( 'fa-thin fa-pan-food' => 'pan-food' ),
					array( 'fa-thin fa-pan-frying' => 'pan-frying' ),
					array( 'fa-thin fa-pancakes' => 'pancakes' ),
					array( 'fa-thin fa-panel-ews' => 'panel-ews' ),
					array( 'fa-thin fa-panel-fire' => 'panel-fire' ),
					array( 'fa-thin fa-panorama' => 'panorama' ),
					array( 'fa-thin fa-paper-plane-top' => 'paper-plane-top' ),
					array( 'fa-thin fa-paper-plane' => 'paper-plane' ),
					array( 'fa-thin fa-paperclip-vertical' => 'paperclip-vertical' ),
					array( 'fa-thin fa-paperclip' => 'paperclip' ),
					array( 'fa-thin fa-parachute-box' => 'parachute-box' ),
					array( 'fa-thin fa-paragraph-left' => 'paragraph-left' ),
					array( 'fa-thin fa-paragraph' => 'paragraph' ),
					array( 'fa-thin fa-party-bell' => 'party-bell' ),
					array( 'fa-thin fa-party-horn' => 'party-horn' ),
					array( 'fa-thin fa-passport' => 'passport' ),
					array( 'fa-thin fa-paste' => 'paste' ),
					array( 'fa-thin fa-pause' => 'pause' ),
					array( 'fa-thin fa-paw-claws' => 'paw-claws' ),
					array( 'fa-thin fa-paw-simple' => 'paw-simple' ),
					array( 'fa-thin fa-paw' => 'paw' ),
					array( 'fa-thin fa-peace' => 'peace' ),
					array( 'fa-thin fa-peach' => 'peach' ),
					array( 'fa-thin fa-peanut' => 'peanut' ),
					array( 'fa-thin fa-peanuts' => 'peanuts' ),
					array( 'fa-thin fa-peapod' => 'peapod' ),
					array( 'fa-thin fa-pear' => 'pear' ),
					array( 'fa-thin fa-pedestal' => 'pedestal' ),
					array( 'fa-thin fa-pegasus' => 'pegasus' ),
					array( 'fa-thin fa-pen-circle' => 'pen-circle' ),
					array( 'fa-thin fa-pen-clip-slash' => 'pen-clip-slash' ),
					array( 'fa-thin fa-pen-clip' => 'pen-clip' ),
					array( 'fa-thin fa-pen-fancy-slash' => 'pen-fancy-slash' ),
					array( 'fa-thin fa-pen-fancy' => 'pen-fancy' ),
					array( 'fa-thin fa-pen-field' => 'pen-field' ),
					array( 'fa-thin fa-pen-line' => 'pen-line' ),
					array( 'fa-thin fa-pen-nib-slash' => 'pen-nib-slash' ),
					array( 'fa-thin fa-pen-nib' => 'pen-nib' ),
					array( 'fa-thin fa-pen-paintbrush' => 'pen-paintbrush' ),
					array( 'fa-thin fa-pen-ruler' => 'pen-ruler' ),
					array( 'fa-thin fa-pen-slash' => 'pen-slash' ),
					array( 'fa-thin fa-pen-swirl' => 'pen-swirl' ),
					array( 'fa-thin fa-pen-to-square' => 'pen-to-square' ),
					array( 'fa-thin fa-pen' => 'pen' ),
					array( 'fa-thin fa-pencil-mechanical' => 'pencil-mechanical' ),
					array( 'fa-thin fa-pencil-slash' => 'pencil-slash' ),
					array( 'fa-thin fa-pencil' => 'pencil' ),
					array( 'fa-thin fa-people-arrows' => 'people-arrows' ),
					array( 'fa-thin fa-people-carry-box' => 'people-carry-box' ),
					array( 'fa-thin fa-people-dress-simple' => 'people-dress-simple' ),
					array( 'fa-thin fa-people-dress' => 'people-dress' ),
					array( 'fa-thin fa-people-group' => 'people-group' ),
					array( 'fa-thin fa-people-line' => 'people-line' ),
					array( 'fa-thin fa-people-pants-simple' => 'people-pants-simple' ),
					array( 'fa-thin fa-people-pants' => 'people-pants' ),
					array( 'fa-thin fa-people-pulling' => 'people-pulling' ),
					array( 'fa-thin fa-people-robbery' => 'people-robbery' ),
					array( 'fa-thin fa-people-roof' => 'people-roof' ),
					array( 'fa-thin fa-people-simple' => 'people-simple' ),
					array( 'fa-thin fa-people' => 'people' ),
					array( 'fa-thin fa-pepper-hot' => 'pepper-hot' ),
					array( 'fa-thin fa-pepper' => 'pepper' ),
					array( 'fa-thin fa-percent' => 'percent' ),
					array( 'fa-thin fa-period' => 'period' ),
					array( 'fa-thin fa-person-arrow-down-to-line' => 'person-arrow-down-to-line' ),
					array( 'fa-thin fa-person-arrow-up-from-line' => 'person-arrow-up-from-line' ),
					array( 'fa-thin fa-person-biking-mountain' => 'person-biking-mountain' ),
					array( 'fa-thin fa-person-biking' => 'person-biking' ),
					array( 'fa-thin fa-person-booth' => 'person-booth' ),
					array( 'fa-thin fa-person-breastfeeding' => 'person-breastfeeding' ),
					array( 'fa-thin fa-person-burst' => 'person-burst' ),
					array( 'fa-thin fa-person-cane' => 'person-cane' ),
					array( 'fa-thin fa-person-carry-box' => 'person-carry-box' ),
					array( 'fa-thin fa-person-chalkboard' => 'person-chalkboard' ),
					array( 'fa-thin fa-person-circle-check' => 'person-circle-check' ),
					array( 'fa-thin fa-person-circle-exclamation' => 'person-circle-exclamation' ),
					array( 'fa-thin fa-person-circle-minus' => 'person-circle-minus' ),
					array( 'fa-thin fa-person-circle-plus' => 'person-circle-plus' ),
					array( 'fa-thin fa-person-circle-question' => 'person-circle-question' ),
					array( 'fa-thin fa-person-circle-xmark' => 'person-circle-xmark' ),
					array( 'fa-thin fa-person-digging' => 'person-digging' ),
					array( 'fa-thin fa-person-dolly-empty' => 'person-dolly-empty' ),
					array( 'fa-thin fa-person-dolly' => 'person-dolly' ),
					array( 'fa-thin fa-person-dots-from-line' => 'person-dots-from-line' ),
					array( 'fa-thin fa-person-dress-burst' => 'person-dress-burst' ),
					array( 'fa-thin fa-person-dress-fairy' => 'person-dress-fairy' ),
					array( 'fa-thin fa-person-dress-simple' => 'person-dress-simple' ),
					array( 'fa-thin fa-person-dress' => 'person-dress' ),
					array( 'fa-thin fa-person-drowning' => 'person-drowning' ),
					array( 'fa-thin fa-person-fairy' => 'person-fairy' ),
					array( 'fa-thin fa-person-falling-burst' => 'person-falling-burst' ),
					array( 'fa-thin fa-person-falling' => 'person-falling' ),
					array( 'fa-thin fa-person-from-portal' => 'person-from-portal' ),
					array( 'fa-thin fa-person-half-dress' => 'person-half-dress' ),
					array( 'fa-thin fa-person-harassing' => 'person-harassing' ),
					array( 'fa-thin fa-person-hiking' => 'person-hiking' ),
					array( 'fa-thin fa-person-military-pointing' => 'person-military-pointing' ),
					array( 'fa-thin fa-person-military-rifle' => 'person-military-rifle' ),
					array( 'fa-thin fa-person-military-to-person' => 'person-military-to-person' ),
					array( 'fa-thin fa-person-pinball' => 'person-pinball' ),
					array( 'fa-thin fa-person-praying' => 'person-praying' ),
					array( 'fa-thin fa-person-pregnant' => 'person-pregnant' ),
					array( 'fa-thin fa-person-rays' => 'person-rays' ),
					array( 'fa-thin fa-person-rifle' => 'person-rifle' ),
					array( 'fa-thin fa-person-running-fast' => 'person-running-fast' ),
					array( 'fa-thin fa-person-running' => 'person-running' ),
					array( 'fa-thin fa-person-seat-reclined' => 'person-seat-reclined' ),
					array( 'fa-thin fa-person-seat' => 'person-seat' ),
					array( 'fa-thin fa-person-shelter' => 'person-shelter' ),
					array( 'fa-thin fa-person-sign' => 'person-sign' ),
					array( 'fa-thin fa-person-simple' => 'person-simple' ),
					array( 'fa-thin fa-person-skating' => 'person-skating' ),
					array( 'fa-thin fa-person-ski-jumping' => 'person-ski-jumping' ),
					array( 'fa-thin fa-person-ski-lift' => 'person-ski-lift' ),
					array( 'fa-thin fa-person-skiing-nordic' => 'person-skiing-nordic' ),
					array( 'fa-thin fa-person-skiing' => 'person-skiing' ),
					array( 'fa-thin fa-person-sledding' => 'person-sledding' ),
					array( 'fa-thin fa-person-snowboarding' => 'person-snowboarding' ),
					array( 'fa-thin fa-person-snowmobiling' => 'person-snowmobiling' ),
					array( 'fa-thin fa-person-swimming' => 'person-swimming' ),
					array( 'fa-thin fa-person-through-window' => 'person-through-window' ),
					array( 'fa-thin fa-person-to-door' => 'person-to-door' ),
					array( 'fa-thin fa-person-to-portal' => 'person-to-portal' ),
					array( 'fa-thin fa-person-walking-arrow-loop-left' => 'person-walking-arrow-loop-left' ),
					array( 'fa-thin fa-person-walking-arrow-right' => 'person-walking-arrow-right' ),
					array( 'fa-thin fa-person-walking-dashed-line-arrow-right' => 'person-walking-dashed-line-arrow-right' ),
					array( 'fa-thin fa-person-walking-luggage' => 'person-walking-luggage' ),
					array( 'fa-thin fa-person-walking-with-cane' => 'person-walking-with-cane' ),
					array( 'fa-thin fa-person-walking' => 'person-walking' ),
					array( 'fa-thin fa-person' => 'person' ),
					array( 'fa-thin fa-peseta-sign' => 'peseta-sign' ),
					array( 'fa-thin fa-peso-sign' => 'peso-sign' ),
					array( 'fa-thin fa-phone-arrow-down-left' => 'phone-arrow-down-left' ),
					array( 'fa-thin fa-phone-arrow-right' => 'phone-arrow-right' ),
					array( 'fa-thin fa-phone-arrow-up-right' => 'phone-arrow-up-right' ),
					array( 'fa-thin fa-phone-flip' => 'phone-flip' ),
					array( 'fa-thin fa-phone-hangup' => 'phone-hangup' ),
					array( 'fa-thin fa-phone-intercom' => 'phone-intercom' ),
					array( 'fa-thin fa-phone-missed' => 'phone-missed' ),
					array( 'fa-thin fa-phone-office' => 'phone-office' ),
					array( 'fa-thin fa-phone-plus' => 'phone-plus' ),
					array( 'fa-thin fa-phone-rotary' => 'phone-rotary' ),
					array( 'fa-thin fa-phone-slash' => 'phone-slash' ),
					array( 'fa-thin fa-phone-volume' => 'phone-volume' ),
					array( 'fa-thin fa-phone-xmark' => 'phone-xmark' ),
					array( 'fa-thin fa-phone' => 'phone' ),
					array( 'fa-thin fa-photo-film-music' => 'photo-film-music' ),
					array( 'fa-thin fa-photo-film' => 'photo-film' ),
					array( 'fa-thin fa-pi' => 'pi' ),
					array( 'fa-thin fa-piano-keyboard' => 'piano-keyboard' ),
					array( 'fa-thin fa-piano' => 'piano' ),
					array( 'fa-thin fa-pickaxe' => 'pickaxe' ),
					array( 'fa-thin fa-pickleball' => 'pickleball' ),
					array( 'fa-thin fa-pie' => 'pie' ),
					array( 'fa-thin fa-pig' => 'pig' ),
					array( 'fa-thin fa-piggy-bank' => 'piggy-bank' ),
					array( 'fa-thin fa-pills' => 'pills' ),
					array( 'fa-thin fa-pinata' => 'pinata' ),
					array( 'fa-thin fa-pinball' => 'pinball' ),
					array( 'fa-thin fa-pineapple' => 'pineapple' ),
					array( 'fa-thin fa-pipe-circle-check' => 'pipe-circle-check' ),
					array( 'fa-thin fa-pipe-collar' => 'pipe-collar' ),
					array( 'fa-thin fa-pipe-section' => 'pipe-section' ),
					array( 'fa-thin fa-pipe-smoking' => 'pipe-smoking' ),
					array( 'fa-thin fa-pipe-valve' => 'pipe-valve' ),
					array( 'fa-thin fa-pipe' => 'pipe' ),
					array( 'fa-thin fa-pizza-slice' => 'pizza-slice' ),
					array( 'fa-thin fa-pizza' => 'pizza' ),
					array( 'fa-thin fa-place-of-worship' => 'place-of-worship' ),
					array( 'fa-thin fa-plane-arrival' => 'plane-arrival' ),
					array( 'fa-thin fa-plane-circle-check' => 'plane-circle-check' ),
					array( 'fa-thin fa-plane-circle-exclamation' => 'plane-circle-exclamation' ),
					array( 'fa-thin fa-plane-circle-xmark' => 'plane-circle-xmark' ),
					array( 'fa-thin fa-plane-departure' => 'plane-departure' ),
					array( 'fa-thin fa-plane-engines' => 'plane-engines' ),
					array( 'fa-thin fa-plane-lock' => 'plane-lock' ),
					array( 'fa-thin fa-plane-prop' => 'plane-prop' ),
					array( 'fa-thin fa-plane-slash' => 'plane-slash' ),
					array( 'fa-thin fa-plane-tail' => 'plane-tail' ),
					array( 'fa-thin fa-plane-up-slash' => 'plane-up-slash' ),
					array( 'fa-thin fa-plane-up' => 'plane-up' ),
					array( 'fa-thin fa-plane' => 'plane' ),
					array( 'fa-thin fa-planet-moon' => 'planet-moon' ),
					array( 'fa-thin fa-planet-ringed' => 'planet-ringed' ),
					array( 'fa-thin fa-plant-wilt' => 'plant-wilt' ),
					array( 'fa-thin fa-plate-utensils' => 'plate-utensils' ),
					array( 'fa-thin fa-plate-wheat' => 'plate-wheat' ),
					array( 'fa-thin fa-play-pause' => 'play-pause' ),
					array( 'fa-thin fa-play' => 'play' ),
					array( 'fa-thin fa-plug-circle-bolt' => 'plug-circle-bolt' ),
					array( 'fa-thin fa-plug-circle-check' => 'plug-circle-check' ),
					array( 'fa-thin fa-plug-circle-exclamation' => 'plug-circle-exclamation' ),
					array( 'fa-thin fa-plug-circle-minus' => 'plug-circle-minus' ),
					array( 'fa-thin fa-plug-circle-plus' => 'plug-circle-plus' ),
					array( 'fa-thin fa-plug-circle-xmark' => 'plug-circle-xmark' ),
					array( 'fa-thin fa-plug' => 'plug' ),
					array( 'fa-thin fa-plus-large' => 'plus-large' ),
					array( 'fa-thin fa-plus-minus' => 'plus-minus' ),
					array( 'fa-thin fa-plus' => 'plus' ),
					array( 'fa-thin fa-podcast' => 'podcast' ),
					array( 'fa-thin fa-podium-star' => 'podium-star' ),
					array( 'fa-thin fa-podium' => 'podium' ),
					array( 'fa-thin fa-police-box' => 'police-box' ),
					array( 'fa-thin fa-poll-people' => 'poll-people' ),
					array( 'fa-thin fa-pompebled' => 'pompebled' ),
					array( 'fa-thin fa-poo-storm' => 'poo-storm' ),
					array( 'fa-thin fa-poo' => 'poo' ),
					array( 'fa-thin fa-pool-8-ball' => 'pool-8-ball' ),
					array( 'fa-thin fa-poop' => 'poop' ),
					array( 'fa-thin fa-popcorn' => 'popcorn' ),
					array( 'fa-thin fa-popsicle' => 'popsicle' ),
					array( 'fa-thin fa-pot-food' => 'pot-food' ),
					array( 'fa-thin fa-potato' => 'potato' ),
					array( 'fa-thin fa-power-off' => 'power-off' ),
					array( 'fa-thin fa-prescription-bottle-medical' => 'prescription-bottle-medical' ),
					array( 'fa-thin fa-prescription-bottle-pill' => 'prescription-bottle-pill' ),
					array( 'fa-thin fa-prescription-bottle' => 'prescription-bottle' ),
					array( 'fa-thin fa-prescription' => 'prescription' ),
					array( 'fa-thin fa-presentation-screen' => 'presentation-screen' ),
					array( 'fa-thin fa-pretzel' => 'pretzel' ),
					array( 'fa-thin fa-print-magnifying-glass' => 'print-magnifying-glass' ),
					array( 'fa-thin fa-print-slash' => 'print-slash' ),
					array( 'fa-thin fa-print' => 'print' ),
					array( 'fa-thin fa-projector' => 'projector' ),
					array( 'fa-thin fa-pump-medical' => 'pump-medical' ),
					array( 'fa-thin fa-pump-soap' => 'pump-soap' ),
					array( 'fa-thin fa-pump' => 'pump' ),
					array( 'fa-thin fa-pumpkin' => 'pumpkin' ),
					array( 'fa-thin fa-puzzle-piece-simple' => 'puzzle-piece-simple' ),
					array( 'fa-thin fa-puzzle-piece' => 'puzzle-piece' ),
					array( 'fa-thin fa-puzzle' => 'puzzle' ),
					array( 'fa-thin fa-q' => 'q' ),
					array( 'fa-thin fa-qrcode' => 'qrcode' ),
					array( 'fa-thin fa-question' => 'question' ),
					array( 'fa-thin fa-quote-left' => 'quote-left' ),
					array( 'fa-thin fa-quote-right' => 'quote-right' ),
					array( 'fa-thin fa-quotes' => 'quotes' ),
					array( 'fa-thin fa-r' => 'r' ),
					array( 'fa-thin fa-rabbit-running' => 'rabbit-running' ),
					array( 'fa-thin fa-rabbit' => 'rabbit' ),
					array( 'fa-thin fa-raccoon' => 'raccoon' ),
					array( 'fa-thin fa-racquet' => 'racquet' ),
					array( 'fa-thin fa-radar' => 'radar' ),
					array( 'fa-thin fa-radiation' => 'radiation' ),
					array( 'fa-thin fa-radio-tuner' => 'radio-tuner' ),
					array( 'fa-thin fa-radio' => 'radio' ),
					array( 'fa-thin fa-rainbow' => 'rainbow' ),
					array( 'fa-thin fa-raindrops' => 'raindrops' ),
					array( 'fa-thin fa-ram' => 'ram' ),
					array( 'fa-thin fa-ramp-loading' => 'ramp-loading' ),
					array( 'fa-thin fa-ranking-star' => 'ranking-star' ),
					array( 'fa-thin fa-raygun' => 'raygun' ),
					array( 'fa-thin fa-receipt' => 'receipt' ),
					array( 'fa-thin fa-record-vinyl' => 'record-vinyl' ),
					array( 'fa-thin fa-rectangle-ad' => 'rectangle-ad' ),
					array( 'fa-thin fa-rectangle-barcode' => 'rectangle-barcode' ),
					array( 'fa-thin fa-rectangle-code' => 'rectangle-code' ),
					array( 'fa-thin fa-rectangle-history-circle-plus' => 'rectangle-history-circle-plus' ),
					array( 'fa-thin fa-rectangle-history-circle-user' => 'rectangle-history-circle-user' ),
					array( 'fa-thin fa-rectangle-history' => 'rectangle-history' ),
					array( 'fa-thin fa-rectangle-list' => 'rectangle-list' ),
					array( 'fa-thin fa-rectangle-pro' => 'rectangle-pro' ),
					array( 'fa-thin fa-rectangle-terminal' => 'rectangle-terminal' ),
					array( 'fa-thin fa-rectangle-vertical-history' => 'rectangle-vertical-history' ),
					array( 'fa-thin fa-rectangle-vertical' => 'rectangle-vertical' ),
					array( 'fa-thin fa-rectangle-wide' => 'rectangle-wide' ),
					array( 'fa-thin fa-rectangle-xmark' => 'rectangle-xmark' ),
					array( 'fa-thin fa-rectangle' => 'rectangle' ),
					array( 'fa-thin fa-rectangles-mixed' => 'rectangles-mixed' ),
					array( 'fa-thin fa-recycle' => 'recycle' ),
					array( 'fa-thin fa-reel' => 'reel' ),
					array( 'fa-thin fa-refrigerator' => 'refrigerator' ),
					array( 'fa-thin fa-registered' => 'registered' ),
					array( 'fa-thin fa-repeat-1' => 'repeat-1' ),
					array( 'fa-thin fa-repeat' => 'repeat' ),
					array( 'fa-thin fa-reply-all' => 'reply-all' ),
					array( 'fa-thin fa-reply-clock' => 'reply-clock' ),
					array( 'fa-thin fa-reply' => 'reply' ),
					array( 'fa-thin fa-republican' => 'republican' ),
					array( 'fa-thin fa-restroom-simple' => 'restroom-simple' ),
					array( 'fa-thin fa-restroom' => 'restroom' ),
					array( 'fa-thin fa-retweet' => 'retweet' ),
					array( 'fa-thin fa-rhombus' => 'rhombus' ),
					array( 'fa-thin fa-ribbon' => 'ribbon' ),
					array( 'fa-thin fa-right-from-bracket' => 'right-from-bracket' ),
					array( 'fa-thin fa-right-from-line' => 'right-from-line' ),
					array( 'fa-thin fa-right-left-large' => 'right-left-large' ),
					array( 'fa-thin fa-right-left' => 'right-left' ),
					array( 'fa-thin fa-right-long-to-line' => 'right-long-to-line' ),
					array( 'fa-thin fa-right-long' => 'right-long' ),
					array( 'fa-thin fa-right-to-bracket' => 'right-to-bracket' ),
					array( 'fa-thin fa-right-to-line' => 'right-to-line' ),
					array( 'fa-thin fa-right' => 'right' ),
					array( 'fa-thin fa-ring-diamond' => 'ring-diamond' ),
					array( 'fa-thin fa-ring' => 'ring' ),
					array( 'fa-thin fa-rings-wedding' => 'rings-wedding' ),
					array( 'fa-thin fa-road-barrier' => 'road-barrier' ),
					array( 'fa-thin fa-road-bridge' => 'road-bridge' ),
					array( 'fa-thin fa-road-circle-check' => 'road-circle-check' ),
					array( 'fa-thin fa-road-circle-exclamation' => 'road-circle-exclamation' ),
					array( 'fa-thin fa-road-circle-xmark' => 'road-circle-xmark' ),
					array( 'fa-thin fa-road-lock' => 'road-lock' ),
					array( 'fa-thin fa-road-spikes' => 'road-spikes' ),
					array( 'fa-thin fa-road' => 'road' ),
					array( 'fa-thin fa-robot-astromech' => 'robot-astromech' ),
					array( 'fa-thin fa-robot' => 'robot' ),
					array( 'fa-thin fa-rocket-launch' => 'rocket-launch' ),
					array( 'fa-thin fa-rocket' => 'rocket' ),
					array( 'fa-thin fa-roller-coaster' => 'roller-coaster' ),
					array( 'fa-thin fa-rotate-exclamation' => 'rotate-exclamation' ),
					array( 'fa-thin fa-rotate-left' => 'rotate-left' ),
					array( 'fa-thin fa-rotate-right' => 'rotate-right' ),
					array( 'fa-thin fa-rotate' => 'rotate' ),
					array( 'fa-thin fa-route-highway' => 'route-highway' ),
					array( 'fa-thin fa-route-interstate' => 'route-interstate' ),
					array( 'fa-thin fa-route' => 'route' ),
					array( 'fa-thin fa-router' => 'router' ),
					array( 'fa-thin fa-rss' => 'rss' ),
					array( 'fa-thin fa-ruble-sign' => 'ruble-sign' ),
					array( 'fa-thin fa-rug' => 'rug' ),
					array( 'fa-thin fa-rugby-ball' => 'rugby-ball' ),
					array( 'fa-thin fa-ruler-combined' => 'ruler-combined' ),
					array( 'fa-thin fa-ruler-horizontal' => 'ruler-horizontal' ),
					array( 'fa-thin fa-ruler-triangle' => 'ruler-triangle' ),
					array( 'fa-thin fa-ruler-vertical' => 'ruler-vertical' ),
					array( 'fa-thin fa-ruler' => 'ruler' ),
					array( 'fa-thin fa-rupee-sign' => 'rupee-sign' ),
					array( 'fa-thin fa-rupiah-sign' => 'rupiah-sign' ),
					array( 'fa-thin fa-rv' => 'rv' ),
					array( 'fa-thin fa-s' => 's' ),
					array( 'fa-thin fa-sack-dollar' => 'sack-dollar' ),
					array( 'fa-thin fa-sack-xmark' => 'sack-xmark' ),
					array( 'fa-thin fa-sack' => 'sack' ),
					array( 'fa-thin fa-sailboat' => 'sailboat' ),
					array( 'fa-thin fa-salad' => 'salad' ),
					array( 'fa-thin fa-salt-shaker' => 'salt-shaker' ),
					array( 'fa-thin fa-sandwich' => 'sandwich' ),
					array( 'fa-thin fa-satellite-dish' => 'satellite-dish' ),
					array( 'fa-thin fa-satellite' => 'satellite' ),
					array( 'fa-thin fa-sausage' => 'sausage' ),
					array( 'fa-thin fa-saxophone-fire' => 'saxophone-fire' ),
					array( 'fa-thin fa-saxophone' => 'saxophone' ),
					array( 'fa-thin fa-scale-balanced' => 'scale-balanced' ),
					array( 'fa-thin fa-scale-unbalanced-flip' => 'scale-unbalanced-flip' ),
					array( 'fa-thin fa-scale-unbalanced' => 'scale-unbalanced' ),
					array( 'fa-thin fa-scalpel-line-dashed' => 'scalpel-line-dashed' ),
					array( 'fa-thin fa-scalpel' => 'scalpel' ),
					array( 'fa-thin fa-scanner-gun' => 'scanner-gun' ),
					array( 'fa-thin fa-scanner-image' => 'scanner-image' ),
					array( 'fa-thin fa-scanner-keyboard' => 'scanner-keyboard' ),
					array( 'fa-thin fa-scanner-touchscreen' => 'scanner-touchscreen' ),
					array( 'fa-thin fa-scarecrow' => 'scarecrow' ),
					array( 'fa-thin fa-scarf' => 'scarf' ),
					array( 'fa-thin fa-school-circle-check' => 'school-circle-check' ),
					array( 'fa-thin fa-school-circle-exclamation' => 'school-circle-exclamation' ),
					array( 'fa-thin fa-school-circle-xmark' => 'school-circle-xmark' ),
					array( 'fa-thin fa-school-flag' => 'school-flag' ),
					array( 'fa-thin fa-school-lock' => 'school-lock' ),
					array( 'fa-thin fa-school' => 'school' ),
					array( 'fa-thin fa-scissors' => 'scissors' ),
					array( 'fa-thin fa-screen-users' => 'screen-users' ),
					array( 'fa-thin fa-screencast' => 'screencast' ),
					array( 'fa-thin fa-screwdriver-wrench' => 'screwdriver-wrench' ),
					array( 'fa-thin fa-screwdriver' => 'screwdriver' ),
					array( 'fa-thin fa-scribble' => 'scribble' ),
					array( 'fa-thin fa-scroll-old' => 'scroll-old' ),
					array( 'fa-thin fa-scroll-torah' => 'scroll-torah' ),
					array( 'fa-thin fa-scroll' => 'scroll' ),
					array( 'fa-thin fa-scrubber' => 'scrubber' ),
					array( 'fa-thin fa-scythe' => 'scythe' ),
					array( 'fa-thin fa-sd-card' => 'sd-card' ),
					array( 'fa-thin fa-sd-cards' => 'sd-cards' ),
					array( 'fa-thin fa-seal-exclamation' => 'seal-exclamation' ),
					array( 'fa-thin fa-seal-question' => 'seal-question' ),
					array( 'fa-thin fa-seal' => 'seal' ),
					array( 'fa-thin fa-seat-airline' => 'seat-airline' ),
					array( 'fa-thin fa-section' => 'section' ),
					array( 'fa-thin fa-seedling' => 'seedling' ),
					array( 'fa-thin fa-semicolon' => 'semicolon' ),
					array( 'fa-thin fa-send-back' => 'send-back' ),
					array( 'fa-thin fa-send-backward' => 'send-backward' ),
					array( 'fa-thin fa-sensor-cloud' => 'sensor-cloud' ),
					array( 'fa-thin fa-sensor-fire' => 'sensor-fire' ),
					array( 'fa-thin fa-sensor-on' => 'sensor-on' ),
					array( 'fa-thin fa-sensor-triangle-exclamation' => 'sensor-triangle-exclamation' ),
					array( 'fa-thin fa-sensor' => 'sensor' ),
					array( 'fa-thin fa-server' => 'server' ),
					array( 'fa-thin fa-shapes' => 'shapes' ),
					array( 'fa-thin fa-share-all' => 'share-all' ),
					array( 'fa-thin fa-share-from-square' => 'share-from-square' ),
					array( 'fa-thin fa-share-nodes' => 'share-nodes' ),
					array( 'fa-thin fa-share' => 'share' ),
					array( 'fa-thin fa-sheep' => 'sheep' ),
					array( 'fa-thin fa-sheet-plastic' => 'sheet-plastic' ),
					array( 'fa-thin fa-shekel-sign' => 'shekel-sign' ),
					array( 'fa-thin fa-shelves-empty' => 'shelves-empty' ),
					array( 'fa-thin fa-shelves' => 'shelves' ),
					array( 'fa-thin fa-shield-cat' => 'shield-cat' ),
					array( 'fa-thin fa-shield-check' => 'shield-check' ),
					array( 'fa-thin fa-shield-cross' => 'shield-cross' ),
					array( 'fa-thin fa-shield-dog' => 'shield-dog' ),
					array( 'fa-thin fa-shield-exclamation' => 'shield-exclamation' ),
					array( 'fa-thin fa-shield-halved' => 'shield-halved' ),
					array( 'fa-thin fa-shield-heart' => 'shield-heart' ),
					array( 'fa-thin fa-shield-keyhole' => 'shield-keyhole' ),
					array( 'fa-thin fa-shield-minus' => 'shield-minus' ),
					array( 'fa-thin fa-shield-plus' => 'shield-plus' ),
					array( 'fa-thin fa-shield-quartered' => 'shield-quartered' ),
					array( 'fa-thin fa-shield-slash' => 'shield-slash' ),
					array( 'fa-thin fa-shield-virus' => 'shield-virus' ),
					array( 'fa-thin fa-shield-xmark' => 'shield-xmark' ),
					array( 'fa-thin fa-shield' => 'shield' ),
					array( 'fa-thin fa-ship' => 'ship' ),
					array( 'fa-thin fa-shirt-long-sleeve' => 'shirt-long-sleeve' ),
					array( 'fa-thin fa-shirt-running' => 'shirt-running' ),
					array( 'fa-thin fa-shirt-tank-top' => 'shirt-tank-top' ),
					array( 'fa-thin fa-shirt' => 'shirt' ),
					array( 'fa-thin fa-shish-kebab' => 'shish-kebab' ),
					array( 'fa-thin fa-shoe-prints' => 'shoe-prints' ),
					array( 'fa-thin fa-shop-lock' => 'shop-lock' ),
					array( 'fa-thin fa-shop-slash' => 'shop-slash' ),
					array( 'fa-thin fa-shop' => 'shop' ),
					array( 'fa-thin fa-shovel-snow' => 'shovel-snow' ),
					array( 'fa-thin fa-shovel' => 'shovel' ),
					array( 'fa-thin fa-shower-down' => 'shower-down' ),
					array( 'fa-thin fa-shower' => 'shower' ),
					array( 'fa-thin fa-shredder' => 'shredder' ),
					array( 'fa-thin fa-shrimp' => 'shrimp' ),
					array( 'fa-thin fa-shuffle' => 'shuffle' ),
					array( 'fa-thin fa-shutters' => 'shutters' ),
					array( 'fa-thin fa-shuttle-space' => 'shuttle-space' ),
					array( 'fa-thin fa-shuttlecock' => 'shuttlecock' ),
					array( 'fa-thin fa-sickle' => 'sickle' ),
					array( 'fa-thin fa-sidebar-flip' => 'sidebar-flip' ),
					array( 'fa-thin fa-sidebar' => 'sidebar' ),
					array( 'fa-thin fa-sigma' => 'sigma' ),
					array( 'fa-thin fa-sign-hanging' => 'sign-hanging' ),
					array( 'fa-thin fa-signal-bars-fair' => 'signal-bars-fair' ),
					array( 'fa-thin fa-signal-bars-good' => 'signal-bars-good' ),
					array( 'fa-thin fa-signal-bars-slash' => 'signal-bars-slash' ),
					array( 'fa-thin fa-signal-bars-weak' => 'signal-bars-weak' ),
					array( 'fa-thin fa-signal-bars' => 'signal-bars' ),
					array( 'fa-thin fa-signal-fair' => 'signal-fair' ),
					array( 'fa-thin fa-signal-good' => 'signal-good' ),
					array( 'fa-thin fa-signal-slash' => 'signal-slash' ),
					array( 'fa-thin fa-signal-stream-slash' => 'signal-stream-slash' ),
					array( 'fa-thin fa-signal-stream' => 'signal-stream' ),
					array( 'fa-thin fa-signal-strong' => 'signal-strong' ),
					array( 'fa-thin fa-signal-weak' => 'signal-weak' ),
					array( 'fa-thin fa-signal' => 'signal' ),
					array( 'fa-thin fa-signature-lock' => 'signature-lock' ),
					array( 'fa-thin fa-signature-slash' => 'signature-slash' ),
					array( 'fa-thin fa-signature' => 'signature' ),
					array( 'fa-thin fa-signs-post' => 'signs-post' ),
					array( 'fa-thin fa-sim-card' => 'sim-card' ),
					array( 'fa-thin fa-sim-cards' => 'sim-cards' ),
					array( 'fa-thin fa-sink' => 'sink' ),
					array( 'fa-thin fa-siren-on' => 'siren-on' ),
					array( 'fa-thin fa-siren' => 'siren' ),
					array( 'fa-thin fa-sitemap' => 'sitemap' ),
					array( 'fa-thin fa-skeleton-ribs' => 'skeleton-ribs' ),
					array( 'fa-thin fa-skeleton' => 'skeleton' ),
					array( 'fa-thin fa-ski-boot-ski' => 'ski-boot-ski' ),
					array( 'fa-thin fa-ski-boot' => 'ski-boot' ),
					array( 'fa-thin fa-skull-cow' => 'skull-cow' ),
					array( 'fa-thin fa-skull-crossbones' => 'skull-crossbones' ),
					array( 'fa-thin fa-skull' => 'skull' ),
					array( 'fa-thin fa-slash-back' => 'slash-back' ),
					array( 'fa-thin fa-slash-forward' => 'slash-forward' ),
					array( 'fa-thin fa-slash' => 'slash' ),
					array( 'fa-thin fa-sleigh' => 'sleigh' ),
					array( 'fa-thin fa-slider' => 'slider' ),
					array( 'fa-thin fa-sliders-simple' => 'sliders-simple' ),
					array( 'fa-thin fa-sliders-up' => 'sliders-up' ),
					array( 'fa-thin fa-sliders' => 'sliders' ),
					array( 'fa-thin fa-slot-machine' => 'slot-machine' ),
					array( 'fa-thin fa-smog' => 'smog' ),
					array( 'fa-thin fa-smoke' => 'smoke' ),
					array( 'fa-thin fa-smoking' => 'smoking' ),
					array( 'fa-thin fa-snake' => 'snake' ),
					array( 'fa-thin fa-snooze' => 'snooze' ),
					array( 'fa-thin fa-snow-blowing' => 'snow-blowing' ),
					array( 'fa-thin fa-snowflake-droplets' => 'snowflake-droplets' ),
					array( 'fa-thin fa-snowflake' => 'snowflake' ),
					array( 'fa-thin fa-snowflakes' => 'snowflakes' ),
					array( 'fa-thin fa-snowman-head' => 'snowman-head' ),
					array( 'fa-thin fa-snowman' => 'snowman' ),
					array( 'fa-thin fa-snowplow' => 'snowplow' ),
					array( 'fa-thin fa-soap' => 'soap' ),
					array( 'fa-thin fa-socks' => 'socks' ),
					array( 'fa-thin fa-soft-serve' => 'soft-serve' ),
					array( 'fa-thin fa-solar-panel' => 'solar-panel' ),
					array( 'fa-thin fa-solar-system' => 'solar-system' ),
					array( 'fa-thin fa-sort-down' => 'sort-down' ),
					array( 'fa-thin fa-sort-up' => 'sort-up' ),
					array( 'fa-thin fa-sort' => 'sort' ),
					array( 'fa-thin fa-spa' => 'spa' ),
					array( 'fa-thin fa-space-station-moon-construction' => 'space-station-moon-construction' ),
					array( 'fa-thin fa-space-station-moon' => 'space-station-moon' ),
					array( 'fa-thin fa-spade' => 'spade' ),
					array( 'fa-thin fa-spaghetti-monster-flying' => 'spaghetti-monster-flying' ),
					array( 'fa-thin fa-sparkle' => 'sparkle' ),
					array( 'fa-thin fa-sparkles' => 'sparkles' ),
					array( 'fa-thin fa-speaker' => 'speaker' ),
					array( 'fa-thin fa-speakers' => 'speakers' ),
					array( 'fa-thin fa-spell-check' => 'spell-check' ),
					array( 'fa-thin fa-spider-black-widow' => 'spider-black-widow' ),
					array( 'fa-thin fa-spider-web' => 'spider-web' ),
					array( 'fa-thin fa-spider' => 'spider' ),
					array( 'fa-thin fa-spinner-third' => 'spinner-third' ),
					array( 'fa-thin fa-spinner' => 'spinner' ),
					array( 'fa-thin fa-split' => 'split' ),
					array( 'fa-thin fa-splotch' => 'splotch' ),
					array( 'fa-thin fa-spoon' => 'spoon' ),
					array( 'fa-thin fa-sportsball' => 'sportsball' ),
					array( 'fa-thin fa-spray-can-sparkles' => 'spray-can-sparkles' ),
					array( 'fa-thin fa-spray-can' => 'spray-can' ),
					array( 'fa-thin fa-sprinkler-ceiling' => 'sprinkler-ceiling' ),
					array( 'fa-thin fa-sprinkler' => 'sprinkler' ),
					array( 'fa-thin fa-square-0' => 'square-0' ),
					array( 'fa-thin fa-square-1' => 'square-1' ),
					array( 'fa-thin fa-square-2' => 'square-2' ),
					array( 'fa-thin fa-square-3' => 'square-3' ),
					array( 'fa-thin fa-square-4' => 'square-4' ),
					array( 'fa-thin fa-square-5' => 'square-5' ),
					array( 'fa-thin fa-square-6' => 'square-6' ),
					array( 'fa-thin fa-square-7' => 'square-7' ),
					array( 'fa-thin fa-square-8' => 'square-8' ),
					array( 'fa-thin fa-square-9' => 'square-9' ),
					array( 'fa-thin fa-square-a-lock' => 'square-a-lock' ),
					array( 'fa-thin fa-square-a' => 'square-a' ),
					array( 'fa-thin fa-square-ampersand' => 'square-ampersand' ),
					array( 'fa-thin fa-square-arrow-down-left' => 'square-arrow-down-left' ),
					array( 'fa-thin fa-square-arrow-down-right' => 'square-arrow-down-right' ),
					array( 'fa-thin fa-square-arrow-down' => 'square-arrow-down' ),
					array( 'fa-thin fa-square-arrow-left' => 'square-arrow-left' ),
					array( 'fa-thin fa-square-arrow-right' => 'square-arrow-right' ),
					array( 'fa-thin fa-square-arrow-up-left' => 'square-arrow-up-left' ),
					array( 'fa-thin fa-square-arrow-up-right' => 'square-arrow-up-right' ),
					array( 'fa-thin fa-square-arrow-up' => 'square-arrow-up' ),
					array( 'fa-thin fa-square-b' => 'square-b' ),
					array( 'fa-thin fa-square-bolt' => 'square-bolt' ),
					array( 'fa-thin fa-square-c' => 'square-c' ),
					array( 'fa-thin fa-square-caret-down' => 'square-caret-down' ),
					array( 'fa-thin fa-square-caret-left' => 'square-caret-left' ),
					array( 'fa-thin fa-square-caret-right' => 'square-caret-right' ),
					array( 'fa-thin fa-square-caret-up' => 'square-caret-up' ),
					array( 'fa-thin fa-square-check' => 'square-check' ),
					array( 'fa-thin fa-square-chevron-down' => 'square-chevron-down' ),
					array( 'fa-thin fa-square-chevron-left' => 'square-chevron-left' ),
					array( 'fa-thin fa-square-chevron-right' => 'square-chevron-right' ),
					array( 'fa-thin fa-square-chevron-up' => 'square-chevron-up' ),
					array( 'fa-thin fa-square-code' => 'square-code' ),
					array( 'fa-thin fa-square-d' => 'square-d' ),
					array( 'fa-thin fa-square-dashed-circle-plus' => 'square-dashed-circle-plus' ),
					array( 'fa-thin fa-square-dashed' => 'square-dashed' ),
					array( 'fa-thin fa-square-divide' => 'square-divide' ),
					array( 'fa-thin fa-square-dollar' => 'square-dollar' ),
					array( 'fa-thin fa-square-down-left' => 'square-down-left' ),
					array( 'fa-thin fa-square-down-right' => 'square-down-right' ),
					array( 'fa-thin fa-square-down' => 'square-down' ),
					array( 'fa-thin fa-square-e' => 'square-e' ),
					array( 'fa-thin fa-square-ellipsis-vertical' => 'square-ellipsis-vertical' ),
					array( 'fa-thin fa-square-ellipsis' => 'square-ellipsis' ),
					array( 'fa-thin fa-square-envelope' => 'square-envelope' ),
					array( 'fa-thin fa-square-exclamation' => 'square-exclamation' ),
					array( 'fa-thin fa-square-f' => 'square-f' ),
					array( 'fa-thin fa-square-fragile' => 'square-fragile' ),
					array( 'fa-thin fa-square-full' => 'square-full' ),
					array( 'fa-thin fa-square-g' => 'square-g' ),
					array( 'fa-thin fa-square-h' => 'square-h' ),
					array( 'fa-thin fa-square-heart' => 'square-heart' ),
					array( 'fa-thin fa-square-i' => 'square-i' ),
					array( 'fa-thin fa-square-info' => 'square-info' ),
					array( 'fa-thin fa-square-j' => 'square-j' ),
					array( 'fa-thin fa-square-k' => 'square-k' ),
					array( 'fa-thin fa-square-kanban' => 'square-kanban' ),
					array( 'fa-thin fa-square-l' => 'square-l' ),
					array( 'fa-thin fa-square-left' => 'square-left' ),
					array( 'fa-thin fa-square-list' => 'square-list' ),
					array( 'fa-thin fa-square-m' => 'square-m' ),
					array( 'fa-thin fa-square-minus' => 'square-minus' ),
					array( 'fa-thin fa-square-n' => 'square-n' ),
					array( 'fa-thin fa-square-nfi' => 'square-nfi' ),
					array( 'fa-thin fa-square-o' => 'square-o' ),
					array( 'fa-thin fa-square-p' => 'square-p' ),
					array( 'fa-thin fa-square-parking-slash' => 'square-parking-slash' ),
					array( 'fa-thin fa-square-parking' => 'square-parking' ),
					array( 'fa-thin fa-square-pen' => 'square-pen' ),
					array( 'fa-thin fa-square-person-confined' => 'square-person-confined' ),
					array( 'fa-thin fa-square-phone-flip' => 'square-phone-flip' ),
					array( 'fa-thin fa-square-phone-hangup' => 'square-phone-hangup' ),
					array( 'fa-thin fa-square-phone' => 'square-phone' ),
					array( 'fa-thin fa-square-plus' => 'square-plus' ),
					array( 'fa-thin fa-square-poll-horizontal' => 'square-poll-horizontal' ),
					array( 'fa-thin fa-square-poll-vertical' => 'square-poll-vertical' ),
					array( 'fa-thin fa-square-q' => 'square-q' ),
					array( 'fa-thin fa-square-quarters' => 'square-quarters' ),
					array( 'fa-thin fa-square-question' => 'square-question' ),
					array( 'fa-thin fa-square-quote' => 'square-quote' ),
					array( 'fa-thin fa-square-r' => 'square-r' ),
					array( 'fa-thin fa-square-right' => 'square-right' ),
					array( 'fa-thin fa-square-ring' => 'square-ring' ),
					array( 'fa-thin fa-square-root-variable' => 'square-root-variable' ),
					array( 'fa-thin fa-square-root' => 'square-root' ),
					array( 'fa-thin fa-square-rss' => 'square-rss' ),
					array( 'fa-thin fa-square-s' => 'square-s' ),
					array( 'fa-thin fa-square-share-nodes' => 'square-share-nodes' ),
					array( 'fa-thin fa-square-sliders-vertical' => 'square-sliders-vertical' ),
					array( 'fa-thin fa-square-sliders' => 'square-sliders' ),
					array( 'fa-thin fa-square-small' => 'square-small' ),
					array( 'fa-thin fa-square-star' => 'square-star' ),
					array( 'fa-thin fa-square-t' => 'square-t' ),
					array( 'fa-thin fa-square-terminal' => 'square-terminal' ),
					array( 'fa-thin fa-square-this-way-up' => 'square-this-way-up' ),
					array( 'fa-thin fa-square-u' => 'square-u' ),
					array( 'fa-thin fa-square-up-left' => 'square-up-left' ),
					array( 'fa-thin fa-square-up-right' => 'square-up-right' ),
					array( 'fa-thin fa-square-up' => 'square-up' ),
					array( 'fa-thin fa-square-user' => 'square-user' ),
					array( 'fa-thin fa-square-v' => 'square-v' ),
					array( 'fa-thin fa-square-virus' => 'square-virus' ),
					array( 'fa-thin fa-square-w' => 'square-w' ),
					array( 'fa-thin fa-square-x' => 'square-x' ),
					array( 'fa-thin fa-square-xmark' => 'square-xmark' ),
					array( 'fa-thin fa-square-y' => 'square-y' ),
					array( 'fa-thin fa-square-z' => 'square-z' ),
					array( 'fa-thin fa-square' => 'square' ),
					array( 'fa-thin fa-squid' => 'squid' ),
					array( 'fa-thin fa-squirrel' => 'squirrel' ),
					array( 'fa-thin fa-staff-snake' => 'staff-snake' ),
					array( 'fa-thin fa-staff' => 'staff' ),
					array( 'fa-thin fa-stairs' => 'stairs' ),
					array( 'fa-thin fa-stamp' => 'stamp' ),
					array( 'fa-thin fa-standard-definition' => 'standard-definition' ),
					array( 'fa-thin fa-stapler' => 'stapler' ),
					array( 'fa-thin fa-star-and-crescent' => 'star-and-crescent' ),
					array( 'fa-thin fa-star-christmas' => 'star-christmas' ),
					array( 'fa-thin fa-star-exclamation' => 'star-exclamation' ),
					array( 'fa-thin fa-star-half-stroke' => 'star-half-stroke' ),
					array( 'fa-thin fa-star-half' => 'star-half' ),
					array( 'fa-thin fa-star-of-david' => 'star-of-david' ),
					array( 'fa-thin fa-star-of-life' => 'star-of-life' ),
					array( 'fa-thin fa-star-sharp-half-stroke' => 'star-sharp-half-stroke' ),
					array( 'fa-thin fa-star-sharp-half' => 'star-sharp-half' ),
					array( 'fa-thin fa-star-sharp' => 'star-sharp' ),
					array( 'fa-thin fa-star-shooting' => 'star-shooting' ),
					array( 'fa-thin fa-star' => 'star' ),
					array( 'fa-thin fa-starfighter-twin-ion-engine-advanced' => 'starfighter-twin-ion-engine-advanced' ),
					array( 'fa-thin fa-starfighter-twin-ion-engine' => 'starfighter-twin-ion-engine' ),
					array( 'fa-thin fa-starfighter' => 'starfighter' ),
					array( 'fa-thin fa-stars' => 'stars' ),
					array( 'fa-thin fa-starship-freighter' => 'starship-freighter' ),
					array( 'fa-thin fa-starship' => 'starship' ),
					array( 'fa-thin fa-steak' => 'steak' ),
					array( 'fa-thin fa-steering-wheel' => 'steering-wheel' ),
					array( 'fa-thin fa-sterling-sign' => 'sterling-sign' ),
					array( 'fa-thin fa-stethoscope' => 'stethoscope' ),
					array( 'fa-thin fa-stocking' => 'stocking' ),
					array( 'fa-thin fa-stomach' => 'stomach' ),
					array( 'fa-thin fa-stop' => 'stop' ),
					array( 'fa-thin fa-stopwatch-20' => 'stopwatch-20' ),
					array( 'fa-thin fa-stopwatch' => 'stopwatch' ),
					array( 'fa-thin fa-store-lock' => 'store-lock' ),
					array( 'fa-thin fa-store-slash' => 'store-slash' ),
					array( 'fa-thin fa-store' => 'store' ),
					array( 'fa-thin fa-strawberry' => 'strawberry' ),
					array( 'fa-thin fa-street-view' => 'street-view' ),
					array( 'fa-thin fa-stretcher' => 'stretcher' ),
					array( 'fa-thin fa-strikethrough' => 'strikethrough' ),
					array( 'fa-thin fa-stroopwafel' => 'stroopwafel' ),
					array( 'fa-thin fa-subscript' => 'subscript' ),
					array( 'fa-thin fa-subtitles-slash' => 'subtitles-slash' ),
					array( 'fa-thin fa-subtitles' => 'subtitles' ),
					array( 'fa-thin fa-suitcase-medical' => 'suitcase-medical' ),
					array( 'fa-thin fa-suitcase-rolling' => 'suitcase-rolling' ),
					array( 'fa-thin fa-suitcase' => 'suitcase' ),
					array( 'fa-thin fa-sun-bright' => 'sun-bright' ),
					array( 'fa-thin fa-sun-cloud' => 'sun-cloud' ),
					array( 'fa-thin fa-sun-dust' => 'sun-dust' ),
					array( 'fa-thin fa-sun-haze' => 'sun-haze' ),
					array( 'fa-thin fa-sun-plant-wilt' => 'sun-plant-wilt' ),
					array( 'fa-thin fa-sun' => 'sun' ),
					array( 'fa-thin fa-sunglasses' => 'sunglasses' ),
					array( 'fa-thin fa-sunrise' => 'sunrise' ),
					array( 'fa-thin fa-sunset' => 'sunset' ),
					array( 'fa-thin fa-superscript' => 'superscript' ),
					array( 'fa-thin fa-sushi-roll' => 'sushi-roll' ),
					array( 'fa-thin fa-sushi' => 'sushi' ),
					array( 'fa-thin fa-swap-arrows' => 'swap-arrows' ),
					array( 'fa-thin fa-swap' => 'swap' ),
					array( 'fa-thin fa-swatchbook' => 'swatchbook' ),
					array( 'fa-thin fa-sword-laser-alt' => 'sword-laser-alt' ),
					array( 'fa-thin fa-sword-laser' => 'sword-laser' ),
					array( 'fa-thin fa-sword' => 'sword' ),
					array( 'fa-thin fa-swords-laser' => 'swords-laser' ),
					array( 'fa-thin fa-swords' => 'swords' ),
					array( 'fa-thin fa-symbols' => 'symbols' ),
					array( 'fa-thin fa-synagogue' => 'synagogue' ),
					array( 'fa-thin fa-syringe' => 'syringe' ),
					array( 'fa-thin fa-t' => 't' ),
					array( 'fa-thin fa-table-cells-large' => 'table-cells-large' ),
					array( 'fa-thin fa-table-cells' => 'table-cells' ),
					array( 'fa-thin fa-table-columns' => 'table-columns' ),
					array( 'fa-thin fa-table-layout' => 'table-layout' ),
					array( 'fa-thin fa-table-list' => 'table-list' ),
					array( 'fa-thin fa-table-picnic' => 'table-picnic' ),
					array( 'fa-thin fa-table-pivot' => 'table-pivot' ),
					array( 'fa-thin fa-table-rows' => 'table-rows' ),
					array( 'fa-thin fa-table-tennis-paddle-ball' => 'table-tennis-paddle-ball' ),
					array( 'fa-thin fa-table-tree' => 'table-tree' ),
					array( 'fa-thin fa-table' => 'table' ),
					array( 'fa-thin fa-tablet-button' => 'tablet-button' ),
					array( 'fa-thin fa-tablet-rugged' => 'tablet-rugged' ),
					array( 'fa-thin fa-tablet-screen-button' => 'tablet-screen-button' ),
					array( 'fa-thin fa-tablet-screen' => 'tablet-screen' ),
					array( 'fa-thin fa-tablet' => 'tablet' ),
					array( 'fa-thin fa-tablets' => 'tablets' ),
					array( 'fa-thin fa-tachograph-digital' => 'tachograph-digital' ),
					array( 'fa-thin fa-taco' => 'taco' ),
					array( 'fa-thin fa-tag' => 'tag' ),
					array( 'fa-thin fa-tags' => 'tags' ),
					array( 'fa-thin fa-tally-1' => 'tally-1' ),
					array( 'fa-thin fa-tally-2' => 'tally-2' ),
					array( 'fa-thin fa-tally-3' => 'tally-3' ),
					array( 'fa-thin fa-tally-4' => 'tally-4' ),
					array( 'fa-thin fa-tally' => 'tally' ),
					array( 'fa-thin fa-tamale' => 'tamale' ),
					array( 'fa-thin fa-tank-water' => 'tank-water' ),
					array( 'fa-thin fa-tape' => 'tape' ),
					array( 'fa-thin fa-tarp-droplet' => 'tarp-droplet' ),
					array( 'fa-thin fa-tarp' => 'tarp' ),
					array( 'fa-thin fa-taxi-bus' => 'taxi-bus' ),
					array( 'fa-thin fa-taxi' => 'taxi' ),
					array( 'fa-thin fa-teddy-bear' => 'teddy-bear' ),
					array( 'fa-thin fa-teeth-open' => 'teeth-open' ),
					array( 'fa-thin fa-teeth' => 'teeth' ),
					array( 'fa-thin fa-telescope' => 'telescope' ),
					array( 'fa-thin fa-temperature-arrow-down' => 'temperature-arrow-down' ),
					array( 'fa-thin fa-temperature-arrow-up' => 'temperature-arrow-up' ),
					array( 'fa-thin fa-temperature-empty' => 'temperature-empty' ),
					array( 'fa-thin fa-temperature-full' => 'temperature-full' ),
					array( 'fa-thin fa-temperature-half' => 'temperature-half' ),
					array( 'fa-thin fa-temperature-high' => 'temperature-high' ),
					array( 'fa-thin fa-temperature-list' => 'temperature-list' ),
					array( 'fa-thin fa-temperature-low' => 'temperature-low' ),
					array( 'fa-thin fa-temperature-quarter' => 'temperature-quarter' ),
					array( 'fa-thin fa-temperature-snow' => 'temperature-snow' ),
					array( 'fa-thin fa-temperature-sun' => 'temperature-sun' ),
					array( 'fa-thin fa-temperature-three-quarters' => 'temperature-three-quarters' ),
					array( 'fa-thin fa-tenge-sign' => 'tenge-sign' ),
					array( 'fa-thin fa-tennis-ball' => 'tennis-ball' ),
					array( 'fa-thin fa-tent-arrow-down-to-line' => 'tent-arrow-down-to-line' ),
					array( 'fa-thin fa-tent-arrow-left-right' => 'tent-arrow-left-right' ),
					array( 'fa-thin fa-tent-arrow-turn-left' => 'tent-arrow-turn-left' ),
					array( 'fa-thin fa-tent-arrows-down' => 'tent-arrows-down' ),
					array( 'fa-thin fa-tent' => 'tent' ),
					array( 'fa-thin fa-tents' => 'tents' ),
					array( 'fa-thin fa-terminal' => 'terminal' ),
					array( 'fa-thin fa-text-height' => 'text-height' ),
					array( 'fa-thin fa-text-size' => 'text-size' ),
					array( 'fa-thin fa-text-slash' => 'text-slash' ),
					array( 'fa-thin fa-text-width' => 'text-width' ),
					array( 'fa-thin fa-text' => 'text' ),
					array( 'fa-thin fa-thermometer' => 'thermometer' ),
					array( 'fa-thin fa-theta' => 'theta' ),
					array( 'fa-thin fa-thought-bubble' => 'thought-bubble' ),
					array( 'fa-thin fa-thumbs-down' => 'thumbs-down' ),
					array( 'fa-thin fa-thumbs-up' => 'thumbs-up' ),
					array( 'fa-thin fa-thumbtack' => 'thumbtack' ),
					array( 'fa-thin fa-tick' => 'tick' ),
					array( 'fa-thin fa-ticket-airline' => 'ticket-airline' ),
					array( 'fa-thin fa-ticket-simple' => 'ticket-simple' ),
					array( 'fa-thin fa-ticket' => 'ticket' ),
					array( 'fa-thin fa-tickets-airline' => 'tickets-airline' ),
					array( 'fa-thin fa-tilde' => 'tilde' ),
					array( 'fa-thin fa-timeline-arrow' => 'timeline-arrow' ),
					array( 'fa-thin fa-timeline' => 'timeline' ),
					array( 'fa-thin fa-timer' => 'timer' ),
					array( 'fa-thin fa-tire-flat' => 'tire-flat' ),
					array( 'fa-thin fa-tire-pressure-warning' => 'tire-pressure-warning' ),
					array( 'fa-thin fa-tire-rugged' => 'tire-rugged' ),
					array( 'fa-thin fa-tire' => 'tire' ),
					array( 'fa-thin fa-toggle-large-off' => 'toggle-large-off' ),
					array( 'fa-thin fa-toggle-large-on' => 'toggle-large-on' ),
					array( 'fa-thin fa-toggle-off' => 'toggle-off' ),
					array( 'fa-thin fa-toggle-on' => 'toggle-on' ),
					array( 'fa-thin fa-toilet-paper-blank-under' => 'toilet-paper-blank-under' ),
					array( 'fa-thin fa-toilet-paper-blank' => 'toilet-paper-blank' ),
					array( 'fa-thin fa-toilet-paper-check' => 'toilet-paper-check' ),
					array( 'fa-thin fa-toilet-paper-slash' => 'toilet-paper-slash' ),
					array( 'fa-thin fa-toilet-paper-under-slash' => 'toilet-paper-under-slash' ),
					array( 'fa-thin fa-toilet-paper-under' => 'toilet-paper-under' ),
					array( 'fa-thin fa-toilet-paper-xmark' => 'toilet-paper-xmark' ),
					array( 'fa-thin fa-toilet-paper' => 'toilet-paper' ),
					array( 'fa-thin fa-toilet-portable' => 'toilet-portable' ),
					array( 'fa-thin fa-toilet' => 'toilet' ),
					array( 'fa-thin fa-toilets-portable' => 'toilets-portable' ),
					array( 'fa-thin fa-tomato' => 'tomato' ),
					array( 'fa-thin fa-tombstone-blank' => 'tombstone-blank' ),
					array( 'fa-thin fa-tombstone' => 'tombstone' ),
					array( 'fa-thin fa-toolbox' => 'toolbox' ),
					array( 'fa-thin fa-tooth' => 'tooth' ),
					array( 'fa-thin fa-toothbrush' => 'toothbrush' ),
					array( 'fa-thin fa-torii-gate' => 'torii-gate' ),
					array( 'fa-thin fa-tornado' => 'tornado' ),
					array( 'fa-thin fa-tower-broadcast' => 'tower-broadcast' ),
					array( 'fa-thin fa-tower-cell' => 'tower-cell' ),
					array( 'fa-thin fa-tower-control' => 'tower-control' ),
					array( 'fa-thin fa-tower-observation' => 'tower-observation' ),
					array( 'fa-thin fa-tractor' => 'tractor' ),
					array( 'fa-thin fa-trademark' => 'trademark' ),
					array( 'fa-thin fa-traffic-cone' => 'traffic-cone' ),
					array( 'fa-thin fa-traffic-light-go' => 'traffic-light-go' ),
					array( 'fa-thin fa-traffic-light-slow' => 'traffic-light-slow' ),
					array( 'fa-thin fa-traffic-light-stop' => 'traffic-light-stop' ),
					array( 'fa-thin fa-traffic-light' => 'traffic-light' ),
					array( 'fa-thin fa-trailer' => 'trailer' ),
					array( 'fa-thin fa-train-subway-tunnel' => 'train-subway-tunnel' ),
					array( 'fa-thin fa-train-subway' => 'train-subway' ),
					array( 'fa-thin fa-train-track' => 'train-track' ),
					array( 'fa-thin fa-train-tram' => 'train-tram' ),
					array( 'fa-thin fa-train-tunnel' => 'train-tunnel' ),
					array( 'fa-thin fa-train' => 'train' ),
					array( 'fa-thin fa-transformer-bolt' => 'transformer-bolt' ),
					array( 'fa-thin fa-transgender' => 'transgender' ),
					array( 'fa-thin fa-transporter-1' => 'transporter-1' ),
					array( 'fa-thin fa-transporter-2' => 'transporter-2' ),
					array( 'fa-thin fa-transporter-3' => 'transporter-3' ),
					array( 'fa-thin fa-transporter-4' => 'transporter-4' ),
					array( 'fa-thin fa-transporter-5' => 'transporter-5' ),
					array( 'fa-thin fa-transporter-6' => 'transporter-6' ),
					array( 'fa-thin fa-transporter-7' => 'transporter-7' ),
					array( 'fa-thin fa-transporter-empty' => 'transporter-empty' ),
					array( 'fa-thin fa-transporter' => 'transporter' ),
					array( 'fa-thin fa-trash-arrow-up' => 'trash-arrow-up' ),
					array( 'fa-thin fa-trash-can-arrow-up' => 'trash-can-arrow-up' ),
					array( 'fa-thin fa-trash-can-check' => 'trash-can-check' ),
					array( 'fa-thin fa-trash-can-clock' => 'trash-can-clock' ),
					array( 'fa-thin fa-trash-can-list' => 'trash-can-list' ),
					array( 'fa-thin fa-trash-can-plus' => 'trash-can-plus' ),
					array( 'fa-thin fa-trash-can-slash' => 'trash-can-slash' ),
					array( 'fa-thin fa-trash-can-undo' => 'trash-can-undo' ),
					array( 'fa-thin fa-trash-can-xmark' => 'trash-can-xmark' ),
					array( 'fa-thin fa-trash-can' => 'trash-can' ),
					array( 'fa-thin fa-trash-check' => 'trash-check' ),
					array( 'fa-thin fa-trash-clock' => 'trash-clock' ),
					array( 'fa-thin fa-trash-list' => 'trash-list' ),
					array( 'fa-thin fa-trash-plus' => 'trash-plus' ),
					array( 'fa-thin fa-trash-slash' => 'trash-slash' ),
					array( 'fa-thin fa-trash-undo' => 'trash-undo' ),
					array( 'fa-thin fa-trash-xmark' => 'trash-xmark' ),
					array( 'fa-thin fa-trash' => 'trash' ),
					array( 'fa-thin fa-treasure-chest' => 'treasure-chest' ),
					array( 'fa-thin fa-tree-christmas' => 'tree-christmas' ),
					array( 'fa-thin fa-tree-city' => 'tree-city' ),
					array( 'fa-thin fa-tree-deciduous' => 'tree-deciduous' ),
					array( 'fa-thin fa-tree-decorated' => 'tree-decorated' ),
					array( 'fa-thin fa-tree-large' => 'tree-large' ),
					array( 'fa-thin fa-tree-palm' => 'tree-palm' ),
					array( 'fa-thin fa-tree' => 'tree' ),
					array( 'fa-thin fa-trees' => 'trees' ),
					array( 'fa-thin fa-triangle-exclamation' => 'triangle-exclamation' ),
					array( 'fa-thin fa-triangle-instrument' => 'triangle-instrument' ),
					array( 'fa-thin fa-triangle-person-digging' => 'triangle-person-digging' ),
					array( 'fa-thin fa-triangle' => 'triangle' ),
					array( 'fa-thin fa-tricycle-adult' => 'tricycle-adult' ),
					array( 'fa-thin fa-tricycle' => 'tricycle' ),
					array( 'fa-thin fa-trillium' => 'trillium' ),
					array( 'fa-thin fa-trophy-star' => 'trophy-star' ),
					array( 'fa-thin fa-trophy' => 'trophy' ),
					array( 'fa-thin fa-trowel-bricks' => 'trowel-bricks' ),
					array( 'fa-thin fa-trowel' => 'trowel' ),
					array( 'fa-thin fa-truck-arrow-right' => 'truck-arrow-right' ),
					array( 'fa-thin fa-truck-bolt' => 'truck-bolt' ),
					array( 'fa-thin fa-truck-clock' => 'truck-clock' ),
					array( 'fa-thin fa-truck-container-empty' => 'truck-container-empty' ),
					array( 'fa-thin fa-truck-container' => 'truck-container' ),
					array( 'fa-thin fa-truck-droplet' => 'truck-droplet' ),
					array( 'fa-thin fa-truck-fast' => 'truck-fast' ),
					array( 'fa-thin fa-truck-field-un' => 'truck-field-un' ),
					array( 'fa-thin fa-truck-field' => 'truck-field' ),
					array( 'fa-thin fa-truck-flatbed' => 'truck-flatbed' ),
					array( 'fa-thin fa-truck-front' => 'truck-front' ),
					array( 'fa-thin fa-truck-medical' => 'truck-medical' ),
					array( 'fa-thin fa-truck-monster' => 'truck-monster' ),
					array( 'fa-thin fa-truck-moving' => 'truck-moving' ),
					array( 'fa-thin fa-truck-pickup' => 'truck-pickup' ),
					array( 'fa-thin fa-truck-plane' => 'truck-plane' ),
					array( 'fa-thin fa-truck-plow' => 'truck-plow' ),
					array( 'fa-thin fa-truck-ramp-box' => 'truck-ramp-box' ),
					array( 'fa-thin fa-truck-ramp-couch' => 'truck-ramp-couch' ),
					array( 'fa-thin fa-truck-ramp' => 'truck-ramp' ),
					array( 'fa-thin fa-truck-tow' => 'truck-tow' ),
					array( 'fa-thin fa-truck' => 'truck' ),
					array( 'fa-thin fa-trumpet' => 'trumpet' ),
					array( 'fa-thin fa-tty-answer' => 'tty-answer' ),
					array( 'fa-thin fa-tty' => 'tty' ),
					array( 'fa-thin fa-tugrik-sign' => 'tugrik-sign' ),
					array( 'fa-thin fa-turkey' => 'turkey' ),
					array( 'fa-thin fa-turkish-lira-sign' => 'turkish-lira-sign' ),
					array( 'fa-thin fa-turn-down-left' => 'turn-down-left' ),
					array( 'fa-thin fa-turn-down-right' => 'turn-down-right' ),
					array( 'fa-thin fa-turn-down' => 'turn-down' ),
					array( 'fa-thin fa-turn-up' => 'turn-up' ),
					array( 'fa-thin fa-turntable' => 'turntable' ),
					array( 'fa-thin fa-turtle' => 'turtle' ),
					array( 'fa-thin fa-tv-music' => 'tv-music' ),
					array( 'fa-thin fa-tv-retro' => 'tv-retro' ),
					array( 'fa-thin fa-tv' => 'tv' ),
					array( 'fa-thin fa-typewriter' => 'typewriter' ),
					array( 'fa-thin fa-u' => 'u' ),
					array( 'fa-thin fa-ufo-beam' => 'ufo-beam' ),
					array( 'fa-thin fa-ufo' => 'ufo' ),
					array( 'fa-thin fa-umbrella-beach' => 'umbrella-beach' ),
					array( 'fa-thin fa-umbrella-simple' => 'umbrella-simple' ),
					array( 'fa-thin fa-umbrella' => 'umbrella' ),
					array( 'fa-thin fa-underline' => 'underline' ),
					array( 'fa-thin fa-unicorn' => 'unicorn' ),
					array( 'fa-thin fa-uniform-martial-arts' => 'uniform-martial-arts' ),
					array( 'fa-thin fa-union' => 'union' ),
					array( 'fa-thin fa-universal-access' => 'universal-access' ),
					array( 'fa-thin fa-unlock-keyhole' => 'unlock-keyhole' ),
					array( 'fa-thin fa-unlock' => 'unlock' ),
					array( 'fa-thin fa-up-down-left-right' => 'up-down-left-right' ),
					array( 'fa-thin fa-up-down' => 'up-down' ),
					array( 'fa-thin fa-up-from-bracket' => 'up-from-bracket' ),
					array( 'fa-thin fa-up-from-dotted-line' => 'up-from-dotted-line' ),
					array( 'fa-thin fa-up-from-line' => 'up-from-line' ),
					array( 'fa-thin fa-up-left' => 'up-left' ),
					array( 'fa-thin fa-up-long' => 'up-long' ),
					array( 'fa-thin fa-up-right-and-down-left-from-center' => 'up-right-and-down-left-from-center' ),
					array( 'fa-thin fa-up-right-from-square' => 'up-right-from-square' ),
					array( 'fa-thin fa-up-right' => 'up-right' ),
					array( 'fa-thin fa-up-to-dotted-line' => 'up-to-dotted-line' ),
					array( 'fa-thin fa-up-to-line' => 'up-to-line' ),
					array( 'fa-thin fa-up' => 'up' ),
					array( 'fa-thin fa-upload' => 'upload' ),
					array( 'fa-thin fa-usb-drive' => 'usb-drive' ),
					array( 'fa-thin fa-user-alien' => 'user-alien' ),
					array( 'fa-thin fa-user-astronaut' => 'user-astronaut' ),
					array( 'fa-thin fa-user-bounty-hunter' => 'user-bounty-hunter' ),
					array( 'fa-thin fa-user-check' => 'user-check' ),
					array( 'fa-thin fa-user-chef' => 'user-chef' ),
					array( 'fa-thin fa-user-clock' => 'user-clock' ),
					array( 'fa-thin fa-user-cowboy' => 'user-cowboy' ),
					array( 'fa-thin fa-user-crown' => 'user-crown' ),
					array( 'fa-thin fa-user-doctor-hair-long' => 'user-doctor-hair-long' ),
					array( 'fa-thin fa-user-doctor-hair' => 'user-doctor-hair' ),
					array( 'fa-thin fa-user-doctor-message' => 'user-doctor-message' ),
					array( 'fa-thin fa-user-doctor' => 'user-doctor' ),
					array( 'fa-thin fa-user-gear' => 'user-gear' ),
					array( 'fa-thin fa-user-graduate' => 'user-graduate' ),
					array( 'fa-thin fa-user-group-crown' => 'user-group-crown' ),
					array( 'fa-thin fa-user-group-simple' => 'user-group-simple' ),
					array( 'fa-thin fa-user-group' => 'user-group' ),
					array( 'fa-thin fa-user-hair-buns' => 'user-hair-buns' ),
					array( 'fa-thin fa-user-hair-long' => 'user-hair-long' ),
					array( 'fa-thin fa-user-hair-mullet' => 'user-hair-mullet' ),
					array( 'fa-thin fa-user-hair' => 'user-hair' ),
					array( 'fa-thin fa-user-headset' => 'user-headset' ),
					array( 'fa-thin fa-user-helmet-safety' => 'user-helmet-safety' ),
					array( 'fa-thin fa-user-injured' => 'user-injured' ),
					array( 'fa-thin fa-user-large-slash' => 'user-large-slash' ),
					array( 'fa-thin fa-user-large' => 'user-large' ),
					array( 'fa-thin fa-user-lock' => 'user-lock' ),
					array( 'fa-thin fa-user-magnifying-glass' => 'user-magnifying-glass' ),
					array( 'fa-thin fa-user-minus' => 'user-minus' ),
					array( 'fa-thin fa-user-music' => 'user-music' ),
					array( 'fa-thin fa-user-ninja' => 'user-ninja' ),
					array( 'fa-thin fa-user-nurse-hair-long' => 'user-nurse-hair-long' ),
					array( 'fa-thin fa-user-nurse-hair' => 'user-nurse-hair' ),
					array( 'fa-thin fa-user-nurse' => 'user-nurse' ),
					array( 'fa-thin fa-user-pen' => 'user-pen' ),
					array( 'fa-thin fa-user-pilot-tie' => 'user-pilot-tie' ),
					array( 'fa-thin fa-user-pilot' => 'user-pilot' ),
					array( 'fa-thin fa-user-plus' => 'user-plus' ),
					array( 'fa-thin fa-user-police-tie' => 'user-police-tie' ),
					array( 'fa-thin fa-user-police' => 'user-police' ),
					array( 'fa-thin fa-user-robot-xmarks' => 'user-robot-xmarks' ),
					array( 'fa-thin fa-user-robot' => 'user-robot' ),
					array( 'fa-thin fa-user-secret' => 'user-secret' ),
					array( 'fa-thin fa-user-shakespeare' => 'user-shakespeare' ),
					array( 'fa-thin fa-user-shield' => 'user-shield' ),
					array( 'fa-thin fa-user-slash' => 'user-slash' ),
					array( 'fa-thin fa-user-tag' => 'user-tag' ),
					array( 'fa-thin fa-user-tie-hair-long' => 'user-tie-hair-long' ),
					array( 'fa-thin fa-user-tie-hair' => 'user-tie-hair' ),
					array( 'fa-thin fa-user-tie' => 'user-tie' ),
					array( 'fa-thin fa-user-unlock' => 'user-unlock' ),
					array( 'fa-thin fa-user-visor' => 'user-visor' ),
					array( 'fa-thin fa-user-vneck-hair-long' => 'user-vneck-hair-long' ),
					array( 'fa-thin fa-user-vneck-hair' => 'user-vneck-hair' ),
					array( 'fa-thin fa-user-vneck' => 'user-vneck' ),
					array( 'fa-thin fa-user-xmark' => 'user-xmark' ),
					array( 'fa-thin fa-user' => 'user' ),
					array( 'fa-thin fa-users-between-lines' => 'users-between-lines' ),
					array( 'fa-thin fa-users-gear' => 'users-gear' ),
					array( 'fa-thin fa-users-line' => 'users-line' ),
					array( 'fa-thin fa-users-medical' => 'users-medical' ),
					array( 'fa-thin fa-users-rays' => 'users-rays' ),
					array( 'fa-thin fa-users-rectangle' => 'users-rectangle' ),
					array( 'fa-thin fa-users-slash' => 'users-slash' ),
					array( 'fa-thin fa-users-viewfinder' => 'users-viewfinder' ),
					array( 'fa-thin fa-users' => 'users' ),
					array( 'fa-thin fa-utensils-slash' => 'utensils-slash' ),
					array( 'fa-thin fa-utensils' => 'utensils' ),
					array( 'fa-thin fa-utility-pole-double' => 'utility-pole-double' ),
					array( 'fa-thin fa-utility-pole' => 'utility-pole' ),
					array( 'fa-thin fa-v' => 'v' ),
					array( 'fa-thin fa-vacuum-robot' => 'vacuum-robot' ),
					array( 'fa-thin fa-vacuum' => 'vacuum' ),
					array( 'fa-thin fa-value-absolute' => 'value-absolute' ),
					array( 'fa-thin fa-van-shuttle' => 'van-shuttle' ),
					array( 'fa-thin fa-vault' => 'vault' ),
					array( 'fa-thin fa-vector-circle' => 'vector-circle' ),
					array( 'fa-thin fa-vector-polygon' => 'vector-polygon' ),
					array( 'fa-thin fa-vector-square' => 'vector-square' ),
					array( 'fa-thin fa-vent-damper' => 'vent-damper' ),
					array( 'fa-thin fa-venus-double' => 'venus-double' ),
					array( 'fa-thin fa-venus-mars' => 'venus-mars' ),
					array( 'fa-thin fa-venus' => 'venus' ),
					array( 'fa-thin fa-vest-patches' => 'vest-patches' ),
					array( 'fa-thin fa-vest' => 'vest' ),
					array( 'fa-thin fa-vial-circle-check' => 'vial-circle-check' ),
					array( 'fa-thin fa-vial-virus' => 'vial-virus' ),
					array( 'fa-thin fa-vial' => 'vial' ),
					array( 'fa-thin fa-vials' => 'vials' ),
					array( 'fa-thin fa-video-arrow-down-left' => 'video-arrow-down-left' ),
					array( 'fa-thin fa-video-arrow-up-right' => 'video-arrow-up-right' ),
					array( 'fa-thin fa-video-plus' => 'video-plus' ),
					array( 'fa-thin fa-video-slash' => 'video-slash' ),
					array( 'fa-thin fa-video' => 'video' ),
					array( 'fa-thin fa-vihara' => 'vihara' ),
					array( 'fa-thin fa-violin' => 'violin' ),
					array( 'fa-thin fa-virus-covid-slash' => 'virus-covid-slash' ),
					array( 'fa-thin fa-virus-covid' => 'virus-covid' ),
					array( 'fa-thin fa-virus-slash' => 'virus-slash' ),
					array( 'fa-thin fa-virus' => 'virus' ),
					array( 'fa-thin fa-viruses' => 'viruses' ),
					array( 'fa-thin fa-voicemail' => 'voicemail' ),
					array( 'fa-thin fa-volcano' => 'volcano' ),
					array( 'fa-thin fa-volleyball' => 'volleyball' ),
					array( 'fa-thin fa-volume-high' => 'volume-high' ),
					array( 'fa-thin fa-volume-low' => 'volume-low' ),
					array( 'fa-thin fa-volume-off' => 'volume-off' ),
					array( 'fa-thin fa-volume-slash' => 'volume-slash' ),
					array( 'fa-thin fa-volume-xmark' => 'volume-xmark' ),
					array( 'fa-thin fa-volume' => 'volume' ),
					array( 'fa-thin fa-vr-cardboard' => 'vr-cardboard' ),
					array( 'fa-thin fa-w' => 'w' ),
					array( 'fa-thin fa-waffle' => 'waffle' ),
					array( 'fa-thin fa-wagon-covered' => 'wagon-covered' ),
					array( 'fa-thin fa-walker' => 'walker' ),
					array( 'fa-thin fa-walkie-talkie' => 'walkie-talkie' ),
					array( 'fa-thin fa-wallet' => 'wallet' ),
					array( 'fa-thin fa-wand-magic-sparkles' => 'wand-magic-sparkles' ),
					array( 'fa-thin fa-wand-magic' => 'wand-magic' ),
					array( 'fa-thin fa-wand-sparkles' => 'wand-sparkles' ),
					array( 'fa-thin fa-wand' => 'wand' ),
					array( 'fa-thin fa-warehouse-full' => 'warehouse-full' ),
					array( 'fa-thin fa-warehouse' => 'warehouse' ),
					array( 'fa-thin fa-washing-machine' => 'washing-machine' ),
					array( 'fa-thin fa-watch-apple' => 'watch-apple' ),
					array( 'fa-thin fa-watch-calculator' => 'watch-calculator' ),
					array( 'fa-thin fa-watch-fitness' => 'watch-fitness' ),
					array( 'fa-thin fa-watch-smart' => 'watch-smart' ),
					array( 'fa-thin fa-watch' => 'watch' ),
					array( 'fa-thin fa-water-arrow-down' => 'water-arrow-down' ),
					array( 'fa-thin fa-water-arrow-up' => 'water-arrow-up' ),
					array( 'fa-thin fa-water-ladder' => 'water-ladder' ),
					array( 'fa-thin fa-water' => 'water' ),
					array( 'fa-thin fa-watermelon-slice' => 'watermelon-slice' ),
					array( 'fa-thin fa-wave-pulse' => 'wave-pulse' ),
					array( 'fa-thin fa-wave-sine' => 'wave-sine' ),
					array( 'fa-thin fa-wave-square' => 'wave-square' ),
					array( 'fa-thin fa-wave-triangle' => 'wave-triangle' ),
					array( 'fa-thin fa-waveform-lines' => 'waveform-lines' ),
					array( 'fa-thin fa-waveform' => 'waveform' ),
					array( 'fa-thin fa-webhook' => 'webhook' ),
					array( 'fa-thin fa-weight-hanging' => 'weight-hanging' ),
					array( 'fa-thin fa-weight-scale' => 'weight-scale' ),
					array( 'fa-thin fa-whale' => 'whale' ),
					array( 'fa-thin fa-wheat-awn-circle-exclamation' => 'wheat-awn-circle-exclamation' ),
					array( 'fa-thin fa-wheat-awn-slash' => 'wheat-awn-slash' ),
					array( 'fa-thin fa-wheat-awn' => 'wheat-awn' ),
					array( 'fa-thin fa-wheat-slash' => 'wheat-slash' ),
					array( 'fa-thin fa-wheat' => 'wheat' ),
					array( 'fa-thin fa-wheelchair-move' => 'wheelchair-move' ),
					array( 'fa-thin fa-wheelchair' => 'wheelchair' ),
					array( 'fa-thin fa-whiskey-glass-ice' => 'whiskey-glass-ice' ),
					array( 'fa-thin fa-whiskey-glass' => 'whiskey-glass' ),
					array( 'fa-thin fa-whistle' => 'whistle' ),
					array( 'fa-thin fa-wifi-exclamation' => 'wifi-exclamation' ),
					array( 'fa-thin fa-wifi-fair' => 'wifi-fair' ),
					array( 'fa-thin fa-wifi-slash' => 'wifi-slash' ),
					array( 'fa-thin fa-wifi-weak' => 'wifi-weak' ),
					array( 'fa-thin fa-wifi' => 'wifi' ),
					array( 'fa-thin fa-wind-turbine' => 'wind-turbine' ),
					array( 'fa-thin fa-wind-warning' => 'wind-warning' ),
					array( 'fa-thin fa-wind' => 'wind' ),
					array( 'fa-thin fa-window-flip' => 'window-flip' ),
					array( 'fa-thin fa-window-frame-open' => 'window-frame-open' ),
					array( 'fa-thin fa-window-frame' => 'window-frame' ),
					array( 'fa-thin fa-window-maximize' => 'window-maximize' ),
					array( 'fa-thin fa-window-minimize' => 'window-minimize' ),
					array( 'fa-thin fa-window-restore' => 'window-restore' ),
					array( 'fa-thin fa-window' => 'window' ),
					array( 'fa-thin fa-windsock' => 'windsock' ),
					array( 'fa-thin fa-wine-bottle' => 'wine-bottle' ),
					array( 'fa-thin fa-wine-glass-crack' => 'wine-glass-crack' ),
					array( 'fa-thin fa-wine-glass-empty' => 'wine-glass-empty' ),
					array( 'fa-thin fa-wine-glass' => 'wine-glass' ),
					array( 'fa-thin fa-won-sign' => 'won-sign' ),
					array( 'fa-thin fa-worm' => 'worm' ),
					array( 'fa-thin fa-wreath-laurel' => 'wreath-laurel' ),
					array( 'fa-thin fa-wreath' => 'wreath' ),
					array( 'fa-thin fa-wrench-simple' => 'wrench-simple' ),
					array( 'fa-thin fa-wrench' => 'wrench' ),
					array( 'fa-thin fa-x-ray' => 'x-ray' ),
					array( 'fa-thin fa-x' => 'x' ),
					array( 'fa-thin fa-xmark-large' => 'xmark-large' ),
					array( 'fa-thin fa-xmark-to-slot' => 'xmark-to-slot' ),
					array( 'fa-thin fa-xmark' => 'xmark' ),
					array( 'fa-thin fa-xmarks-lines' => 'xmarks-lines' ),
					array( 'fa-thin fa-y' => 'y' ),
					array( 'fa-thin fa-yen-sign' => 'yen-sign' ),
					array( 'fa-thin fa-yin-yang' => 'yin-yang' ),
					array( 'fa-thin fa-z' => 'z' ),
				),
			);

			return array_merge( $icons, $new_icons );
		}
	}

	new Smilepure_VC_Icon_FontAwesome5();
}
