<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Smilepure_Service' ) ) {
	class Smilepure_Service {

		public function __construct() {
			add_action( 'wp_ajax_service_infinite_load', array( $this, 'infinite_load' ) );
			add_action( 'wp_ajax_nopriv_service_infinite_load', array( $this, 'infinite_load' ) );
		}

		public function infinite_load() {
			$post_type      = ! empty( $_POST['post_type'] ) ? sanitize_text_field( $_POST['post_type'] ) : 'service';
			$posts_per_page = ! empty( $_POST['posts_per_page'] ) ? intval( $_POST['posts_per_page'] ) : -1;
			$orderby        = ! empty( $_POST['orderby'] ) ? sanitize_text_field( $_POST['orderby'] ) : 'date';
			$order          = ! empty( $_POST['order'] ) ? sanitize_text_field( $_POST['order'] ) : 'DESC';
			$paged          = ! empty( $_POST['paged'] ) ? intval( $_POST['paged'] ) : 1;

			$args = array(
				'post_type'      => $post_type,
				'posts_per_page' => $posts_per_page,
				'orderby'        => $orderby,
				'order'          => $order,
				'paged'          => $paged,
				'post_status'    => 'publish',
			);

			if ( ! empty( $_POST['taxonomies'] ) ) {
				$args = Smilepure_VC::get_tax_query_of_taxonomies( $args, sanitize_text_field( $_POST['taxonomies'] ) );
			}

			if ( ! empty( $_POST['extra_taxonomy'] ) ) {
				$args = Smilepure_VC::get_tax_query_of_taxonomies( $args, sanitize_text_field( $_POST['extra_taxonomy'] ) );
			}

			$allowed_styles = array(
				'grid_classic_01',
				'grid_classic_02',
				'grid_classic_03',
				'grid_classic_04',
				'grid_classic_05',
				'grid_classic_06',
				'grid_classic_07',
				'grid_classic_08',
				'carousel_01',
				'carousel_02',
				'carousel_03',
				'carousel_04',
				'carousel_05',
				'carousel_06',
				'carousel_07',
				'carousel_08',
			);

			$style = isset( $_POST['style'] ) ? sanitize_file_name( $_POST['style'] ) : 'grid_classic_01';
			if ( ! in_array( $style, $allowed_styles, true ) ) {
				$style = 'grid_classic_01';
			}

			$image_size = isset( $_POST['image_size'] ) ? sanitize_text_field( $_POST['image_size'] ) : '';

			$Smilepure_query = new WP_Query( $args );
			$count           = $Smilepure_query->post_count;

			$response = array(
				'max_num_pages' => $Smilepure_query->max_num_pages,
				'found_posts'   => $Smilepure_query->found_posts,
				'count'         => $Smilepure_query->post_count,
			);

			ob_start();

			if ( $Smilepure_query->have_posts() ) {
				set_query_var( 'Smilepure_query', $Smilepure_query );
				set_query_var( 'count', $count );
				set_query_var( 'image_size', $image_size );

				get_template_part( 'loop/shortcodes/service/style', $style );
				wp_reset_postdata();
			}

			$template             = ob_get_clean();
			$template             = preg_replace( '~>\s+<~', '><', $template );
			$response['template'] = $template;

			wp_send_json_success( $response );
		}
	}

	new Smilepure_Service();
}
