<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Plugin installation and activation for WordPress themes
 */
if ( ! class_exists( 'Smilepure_Register_Plugins' ) ) {
	class Smilepure_Register_Plugins {

		const GOOGLE_DRIVER_API = 'AIzaSyDXOs0Bxx-uBEA4fH4fzgoHtl64g0RWv-g';

		public function __construct() {
			add_filter( 'insight_core_tgm_plugins', array( $this, 'register_required_plugins' ) );
		}

		public function register_required_plugins() {
			/*
			 * Array of plugin arrays. Required keys are name and slug.
			 * If the source is NOT from the .org repo, then source is also required.
			 */
			$plugins = array(
				array(
					'name'     => esc_html__( 'Insight Core', 'smilepure' ),
					'slug'     => 'insight-core',
					'source'   => $this->get_plugin_google_driver_url( '18Ed9yJ6c8uh70wokhdZg4rxBxFw3osKR' ),
					'version'  => '2.7.4',
					'required' => true,
				),
				array(
					'name'     => esc_html__( 'WPBakery Page Builder', 'smilepure' ),
					'slug'     => 'js_composer',
					'source'   => $this->get_plugin_google_driver_url( '1PIn948Dv0Cfo1F0FMXFCZM9zp2g7-Aep' ),
					'version'  => '8.6.1',
					'required' => true,
				),
				array(
					'name'     => esc_html__( 'WPBakery Page Builder (Visual Composer) Clipboard', 'smilepure' ),
					'slug'     => 'vc_clipboard',
					'source'   => $this->get_plugin_google_driver_url( '1Ut4Y4ZsOl9xBXp-bFzVLWTlbpuELhFKy' ),
					'version'  => '5.0.6',
					'required' => false,
				),
				array(
					'name'     => esc_html__( 'QuickCal - Powerful appointment booking made simple', 'smilepure' ),
					'slug'     => 'quickcal',
					'source'   => $this->get_plugin_google_driver_url( '15s5q2UlMjKrfJT5alXCDXGr9fMWIpfih' ),
					'version'  => '1.0.16',
					'required' => false,
				),
				array(
					'name'     => esc_html__( 'Timetable and Event Schedule', 'smilepure' ),
					'slug'     => 'mp-timetable',
					'required' => false,
				),
				array(
					'name'     => esc_html__( 'Contact Form 7', 'smilepure' ),
					'slug'     => 'contact-form-7',
					'required' => false,
				),
				array(
					'name'     => esc_html__( 'MailChimp for WordPress', 'smilepure' ),
					'slug'     => 'mailchimp-for-wp',
					'required' => false,
				),
				array(
					'name' => esc_html__( 'WooCommerce', 'smilepure' ),
					'slug' => 'woocommerce',
				),
				array(
					'name'     => esc_html__( 'WooCommerce Smart Quick View', 'smilepure' ),
					'slug'     => 'woo-smart-quick-view',
					'required' => false,
				),
				array(
					'name' => esc_html__( 'WPC Smart Compare for WooCommerce', 'smilepure' ),
					'slug' => 'woo-smart-compare',
				),
				array(
					'name' => esc_html__( 'WPC Smart Wishlist for WooCommerce', 'smilepure' ),
					'slug' => 'woo-smart-wishlist',
				),
				array(
					'name'     => esc_html__( 'Revolution Slider', 'smilepure' ),
					'slug'     => 'revslider',
					'source'   => $this->get_plugin_google_driver_url( '1O_lutNVt_E50b_iqWI1EuhCUpXAMNTUs' ),
					'version'  => '6.7.36',
					'required' => true,
				),
			);

			return $plugins;
		}

		public function get_plugin_google_driver_url( $file_id ) {
			return "https://www.googleapis.com/drive/v3/files/{$file_id}?alt=media&key=" . self::GOOGLE_DRIVER_API;
		}
	}

	new Smilepure_Register_Plugins();
}
