/**
 * @preserve JSizes - JQuery plugin v0.33
 *
 * Licensed under the revised BSD License.
 * Copyright 2008-2010 Bram Stein
 * All rights reserved.
 */
/*global jQuery*/
(
    function ( $ ) {
        'use strict';
        var num = function ( value ) {
            return parseInt( value, 10 ) || 0;
        };

        /**
         * Sets or gets the values for min-width, min-height, max-width
         * and max-height.
         */
        $.each( ['min', 'max'], function ( i, name ) {
            $.fn[name + 'Size'] = function ( value ) {
                var width, height;
                if ( value ) {
                    if ( value.width !== undefined ) {
                        this.css( name + '-width', value.width );
                    }
                    if ( value.height !== undefined ) {
                        this.css( name + '-height', value.height );
                    }
                } else {
                    width = this.css( name + '-width' );
                    height = this.css( name + '-height' );
                    // Apparently:
                    //  * Opera returns -1px instead of none
                    //  * IE6 returns undefined instead of none
                    return {
                        'width': (
                                     name === 'max' && (
                                         width === undefined || width === 'none' || num( width ) === - 1
                                     ) && Number.MAX_VALUE
                                 ) || num( width ),
                        'height': (
                                      name === 'max' && (
                                          height === undefined || height === 'none' || num( height ) === - 1
                                      ) && Number.MAX_VALUE
                                  ) || num( height )
                    };
                }
                return this;
            };
        } );

        /**
         * Returns whether or not an element is visible.
         */
        $.fn.isVisible = function () {
            return this.is( ':visible' );
        };

        /**
         * Sets or gets the values for border, margin and padding.
         */
        $.each( ['border', 'margin', 'padding'], function ( i, name ) {
            $.fn[name] = function ( value ) {
                if ( value ) {
                    if ( value.top !== undefined ) {
                        this.css( name + '-top' + (
                            name === 'border' ? '-width' : ''
                        ), value.top );
                    }
                    if ( value.bottom !== undefined ) {
                        this.css( name + '-bottom' + (
                            name === 'border' ? '-width' : ''
                        ), value.bottom );
                    }
                    if ( value.left !== undefined ) {
                        this.css( name + '-left' + (
                            name === 'border' ? '-width' : ''
                        ), value.left );
                    }
                    if ( value.right !== undefined ) {
                        this.css( name + '-right' + (
                            name === 'border' ? '-width' : ''
                        ), value.right );
                    }
                } else {
                    return {
                        top: num( this.css( name + '-top' + (
                            name === 'border' ? '-width' : ''
                        ) ) ),
                        bottom: num( this.css( name + '-bottom' + (
                            name === 'border' ? '-width' : ''
                        ) ) ),
                        left: num( this.css( name + '-left' + (
                            name === 'border' ? '-width' : ''
                        ) ) ),
                        right: num( this.css( name + '-right' + (
                            name === 'border' ? '-width' : ''
                        ) ) )
                    };
                }
                return this;
            };
        } );
    }( jQuery )
);
