<?php
    $page_id = smarty_page_id();
    $metaboxes = smarty_title_box_settings();

    // Page Head - Class
    $page_head_class = 'stm-page-head';

    if( $metaboxes[ 'stm_show_shipping_cart' ] && class_exists( 'WooCommerce' ) ) {
        $page_head_class .= ' stm-page-head_has_shopping-cart';
    }

    if( $metaboxes[ 'stm_page_subtitle' ] ) {
        $page_head_class .= ' stm-page-head_has_subtitle';
    }

    if( !empty( $metaboxes[ 'stm_page_title_style_size' ] ) ) {
        $page_head_class .= ' stm-page-head_size_' . esc_attr( $metaboxes[ 'stm_page_title_style_size' ] );
    } else {
        $page_head_class .= ' stm-page-head_size_small';
    }

    if( !empty( $metaboxes[ 'stm_page_title_style_color' ] ) ) {
        $page_head_class .= ' stm-page-head_color_' . esc_attr( $metaboxes[ 'stm_page_title_style_color' ] );
    } else {
        $page_head_class .= ' stm-page-head_color_white';
    }
    // Page Head - Style
    $page_head_styles = array();

    if( !empty( $metaboxes[ 'stm_page_title_bgimage' ] ) ) {
        $stm_page_title_bgimage_src = wp_get_attachment_image_src( $metaboxes[ 'stm_page_title_bgimage' ], 'full' );
        if(isset($stm_page_title_bgimage_src[ 0 ])){
            $page_head_styles[] = 'background-image: url(' . esc_url( $stm_page_title_bgimage_src[ 0 ] ) . ')';
        }
    }

    $page_head_styles[] = 'background-position:' . esc_attr( $metaboxes[ 'stm_page_title_bgimage_position' ] );

    if( !empty( $metaboxes[ 'stm_page_title_padding' ] ) ) {
        foreach ( $metaboxes[ 'stm_page_title_padding' ] as $stm_page_title_padding_side => $stm_page_title_padding_val ) {
            if( $stm_page_title_padding_val ) {
                $page_head_styles[] = 'padding-' . esc_attr( $stm_page_title_padding_side ) . ':' . esc_attr( $stm_page_title_padding_val );
            }
        }
    }

    $page_head_styles[] = 'height:' . $metaboxes[ 'stm_page_title_height' ];
    $page_head_styles[] = 'background-color:' . esc_attr( $metaboxes[ 'stm_page_title_bgcolor' ] );
    $page_head_style = smarty_element_style( $page_head_styles );

    // Title - Style
    $page_title_styles = 'style=' . 'color:' . esc_attr( $metaboxes[ 'stm_page_title_color' ] );
    $page_title_sep_line_styles = 'style=' . 'background:' . esc_attr( $metaboxes[ 'stm_page_title_sep_line_color' ] );

    // Subtitle - Style
    $page_subtitle_styles = 'style=' . 'color:' . esc_attr( $metaboxes[ 'stm_page_subtitle_color' ] );

    // Overlay - Style
    $page_title_overlay_styles = array();
    $stm_page_title_overlay_color = $metaboxes[ 'stm_page_title_overlay_color' ];
    $stm_page_title_overlay_opacity = $metaboxes[ 'stm_page_title_overlay_opacity' ];

    if( empty( $stm_page_title_overlay_opacity ) ) {
        $stm_page_title_overlay_opacity = false;
    }

    if( !empty( $stm_page_title_overlay_color ) ) {
        $page_title_overlay_styles[] = 'background-color:'. smarty_hex2rgba($stm_page_title_overlay_color, $stm_page_title_overlay_opacity);
    }

    $page_title_overlay_style = smarty_element_style( $page_title_overlay_styles );

    if( !$metaboxes[ 'stm_page_title_hide' ] ) : ?>

	<div class="<?php echo esc_attr( $page_head_class ); ?>" <?php echo sanitize_text_field( $page_head_style ); ?>>

		<div class="container">
			<div class="stm-page-head__content">
                <?php if ( ! get_post_meta( $page_id, 'stm_page_breadcrumbs_hide', true ) ) : ?>

                    <?php if ( in_array( 'breadcrumb-navxt/breadcrumb-navxt.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) : ?>
                        <div class="breadcrumbs">
                            <?php if(function_exists('bcn_display')) {bcn_display();} ?>
                        </div>
                    <?php endif; ?>

                <?php endif; ?>
				<?php if( is_author() ) : ?>
					<?php the_post(); ?>
					<h1 class="stm-page-head__title <?php echo esc_attr( $metaboxes[ 'stm_page_title_position' ] ) ?>" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php printf( esc_html__( 'All posts by %s', 'smarty' ), get_the_author() ); ?></h1>
					<?php rewind_posts(); ?>
				<?php elseif( is_tag() ) : ?>
					<h1 class="stm-page-head__title <?php echo esc_attr( $metaboxes[ 'stm_page_title_position' ] ); ?>" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php printf( esc_html__( '%s', 'smarty' ), single_tag_title( '', false ) ); ?></h1>
				<?php elseif( is_category() ) : ?>
					<h1 class="stm-page-head__title <?php echo esc_attr( $metaboxes[ 'stm_page_title_position' ] ); ?>" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php printf( esc_html__( '%s', 'smarty' ), single_cat_title( '', false ) ); ?></h1>
                <?php elseif( is_tax() ) : ?>
					<h1 class="stm-page-head__title <?php echo esc_attr( $metaboxes[ 'stm_page_title_position' ] ); ?>" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php printf( esc_html__( '%s', 'smarty' ), single_cat_title( '', false ) ); ?></h1>
				<?php elseif( ! $page_id && is_home() ) : ?>
					<?php $posts_title = get_theme_mod( 'posts_title',  esc_html__( 'News', 'smarty' ) ); ?>
					<h1 class="stm-page-head__title <?php echo esc_attr( $metaboxes[ 'stm_page_title_position' ] ); ?>" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php echo esc_html( $posts_title ); ?></h1>
				<?php elseif( is_search() ) : ?>
					<h1 class="stm-page-head__title <?php echo esc_attr( $metaboxes[ 'stm_page_title_position' ] ); ?>" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php esc_html_e( 'Search results', 'smarty' ); ?></h1>
				<?php elseif( class_exists('WooCommerce') && is_product() ) : ?>
					<h1 class="stm-page-head__title <?php echo esc_attr( $metaboxes[ 'stm_page_title_position' ] ); ?>" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php the_title(); ?></h1>
				<?php elseif( $stm_page_title = get_post_meta( $page_id, 'stm_page_title', true ) ) : ?>
					<h1 class="stm-page-head__title <?php echo esc_attr( $metaboxes[ 'stm_page_title_position' ] ); ?>" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php echo esc_html( $stm_page_title ); ?></h1>
				<?php elseif( get_the_title( $page_id ) ) : ?>
					<h1 class="stm-page-head__title <?php echo esc_attr( $metaboxes[ 'stm_page_title_position' ] ); ?>" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php echo get_the_title( $page_id ); ?></h1>
				<?php endif; ?>

				<div class="stm-page-head__separator">
					<div class="stm-page-head__separator-line"<?php echo sanitize_text_field( $page_title_sep_line_styles ); ?>></div>
				</div>

				<?php if( $metaboxes[ 'stm_page_subtitle' ] ) : ?>
					<div class="stm-page-head__subtitle" <?php echo sanitize_text_field( $page_subtitle_styles );; ?>>
						<?php echo wp_kses_post( $metaboxes[ 'stm_page_subtitle' ] ); ?>
					</div>
				<?php endif; ?>
			</div>
            <?php
            if( $metaboxes[ 'stm_show_shipping_cart' ] && class_exists( 'WooCommerce' ) ) {
                smarty_get_layout_file( '/parts', '/mini-cart' );
            }
            ?>
		</div>

        <?php if( $metaboxes[ 'stm_page_title_overlay' ] ) : ?>
            <div class="stm-page-head__overlay" <?php if( !empty( $metaboxes[ 'stm_page_title_overlay_color' ] ) ) { echo sanitize_text_field( $page_title_overlay_style ); } ?>></div>
        <?php endif; ?>
	</div>

<?php endif;