<?php
    $page_id = smarty_page_id();
    $metaboxes = smarty_title_box_settings();

    // Page Head - Class
    $page_head_class = 'stm-page-head';

    if( $metaboxes[ 'stm_show_shipping_cart' ] && class_exists( 'WooCommerce' ) ) {
        $page_head_class .= ' stm-page-head_has_shopping-cart';
    }

    if( $metaboxes[ 'stm_page_subtitle' ] ) {
        $page_head_class .= ' stm-page-head_has_subtitle';
    }

    if( !empty( $metaboxes[ 'stm_page_title_style_size' ] ) ) {
        $page_head_class .= ' stm-page-head_size_' . esc_attr( $metaboxes[ 'stm_page_title_style_size' ] );
    } else {
        $page_head_class .= ' stm-page-head_size_small';
    }

    if( !empty( $metaboxes[ 'stm_page_title_style_color' ] ) ) {
        $page_head_class .= ' stm-page-head_color_' . esc_attr( $metaboxes[ 'stm_page_title_style_color' ] );
    } else {
        $page_head_class .= ' stm-page-head_color_white';
    }

    // Page Head - Style
    $page_head_styles = array();

    if( !empty( $metaboxes[ 'stm_page_title_bgimage' ] ) ) {
        $stm_page_title_bgimage_src = wp_get_attachment_image_src( $metaboxes[ 'stm_page_title_bgimage' ], 'full' );
        $page_head_styles[] = 'background-image: url(' . esc_url( $stm_page_title_bgimage_src ? $stm_page_title_bgimage_src[ 0 ] : '') . ')';
    }

    $page_head_styles[] = 'background-position:' . esc_attr( $metaboxes[ 'stm_page_title_bgimage_position' ] );

    if( !empty( $metaboxes[ 'stm_page_title_padding' ] ) ) {
        foreach ( $metaboxes[ 'stm_page_title_padding' ] as $stm_page_title_padding_side => $stm_page_title_padding_val ) {
            if( $stm_page_title_padding_val ) {
                $page_head_styles[] = 'padding-' . esc_attr( $stm_page_title_padding_side ) . ':' . esc_attr( $stm_page_title_padding_val );
            }
        }
    }

    $page_head_styles[] = 'height:' . $metaboxes[ 'stm_page_title_height' ];
    $page_head_styles[] = 'background-color:' . esc_attr( $metaboxes[ 'stm_page_title_bgcolor' ] );
    $page_head_style = smarty_element_style( $page_head_styles );

    // Title - Style
    $page_title_styles = 'style=' . 'color:' . esc_attr( $metaboxes[ 'stm_page_title_color' ] );
    $page_title_sep_line_styles = 'style=' . 'background:' . esc_attr( $metaboxes[ 'stm_page_title_sep_line_color' ] );

    // Subtitle - Style
    $page_subtitle_styles = 'style=' . 'color:' . esc_attr( $metaboxes[ 'stm_page_subtitle_color' ] );

    // Overlay - Style
    $page_title_overlay_styles = 'style=' . 'background-color:' . smarty_hex2rgba( $metaboxes[ 'stm_page_title_overlay_color' ] );

    if( !$metaboxes[ 'stm_page_title_hide' ] ) : ?>

    <div class="<?php echo esc_attr( $page_head_class ); ?>" <?php echo sanitize_text_field( $page_head_style ); ?>>

        <div class="container">
            <div class="stm-page-head__content">
                <?php if( !get_post_meta( $page_id, 'stm_page_breadcrumbs_hide', true ) ) : ?>

                    <div class="breadcrumbs">
                        <?php if( function_exists( 'bcn_display' ) ) {
                            bcn_display();
                        } ?>
                    </div>

                <?php endif; ?>

                <?php if( is_single() ): ?>
                    <header class="entry-header">
                        <div class="entry-date">
                            <div class="entry-date__day"><?php echo get_the_date( 'j', get_the_ID() ); ?></div>
                            <div class="entry-date__month"><?php echo get_the_date( 'M', get_the_ID() ); ?></div>
                        </div>
                        <div class="entry-header__heading">
                            <h1 class="entry-title" <?php if( !empty( $metaboxes[ 'stm_page_title_color' ] ) ) { echo esc_attr( $page_title_styles ); } ?>><?php the_title(); ?></h1>
                            <ul class="entry-meta">
                                <?php
                                if( !is_multi_author() ) {
                                    printf( '<li><span class="byline"><span class="author vcard"><span class="stm-icon stm-icon-pencil"></span> <span class="screen-reader-text">%1$s </span><a class="url fn n" href="%2$s">%3$s</a></span></span></li>',
                                        _x( 'Author', 'Used before post author name.', 'smarty' ),
                                        esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
                                        get_the_author()
                                    );
                                }
                                ?>
                                <li>
                                    <span class="cat-links"><span class="stm-icon stm-icon-tag_flag"></span> <?php echo get_the_category_list( _x( ', ', 'Used between list items, there is a space after the comma.', 'smarty' ) ); ?></span>
                                </li>
                                <li>
                                    <span class="stm-icon stm-icon-comment"></span> <?php comments_popup_link( '<span class="leave-reply">' . esc_html__( 'Leave a comment', 'smarty' ) . '</span>', esc_html__( '1 comment', 'smarty' ), esc_html__( '% comments', 'smarty' ) ); ?>
                                </li>
                            </ul>
                        </div>
                    </header>
                <?php endif; ?>

            </div>
            <?php
            if( $metaboxes[ 'stm_show_shipping_cart' ] && class_exists( 'WooCommerce' ) ) {
                smarty_get_layout_file( '/parts', '/mini-cart' );
            }
            ?>
        </div>

        <?php if( $metaboxes[ 'stm_page_title_overlay' ] ) : ?>
            <div class="stm-page-head__overlay" <?php if( !empty( $metaboxes[ 'stm_page_title_overlay_color' ] ) ) { echo esc_attr( $page_title_overlay_styles );} ?>></div>
        <?php endif; ?>
    </div>

<?php endif;