<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

$smartseo_args = get_query_var( 'smartseo_logo_args' );

// Site logo
$smartseo_logo_type   = isset( $smartseo_args['type'] ) ? $smartseo_args['type'] : '';
$smartseo_logo_image  = smartseo_get_logo_image( $smartseo_logo_type );
$smartseo_logo_text   = smartseo_is_on( smartseo_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$smartseo_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $smartseo_logo_image['logo'] ) || ! empty( $smartseo_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $smartseo_logo_image['logo'] ) ) {
			if ( empty( $smartseo_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($smartseo_logo_image['logo']) && (int) $smartseo_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$smartseo_attr = smartseo_getimagesize( $smartseo_logo_image['logo'] );
				echo '<img src="' . esc_url( $smartseo_logo_image['logo'] ) . '"'
						. ( ! empty( $smartseo_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $smartseo_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $smartseo_logo_text ) . '"'
						. ( ! empty( $smartseo_attr[3] ) ? ' ' . wp_kses_data( $smartseo_attr[3] ) : '' )
						. '>';
			}
		} else {
			smartseo_show_layout( smartseo_prepare_macros( $smartseo_logo_text ), '<span class="logo_text">', '</span>' );
			smartseo_show_layout( smartseo_prepare_macros( $smartseo_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
