<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0.06
 */

$smartseo_header_css   = '';
$smartseo_header_image = get_header_image();
$smartseo_header_video = smartseo_get_header_video();
if ( ! empty( $smartseo_header_image ) && smartseo_trx_addons_featured_image_override( is_singular() || smartseo_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$smartseo_header_image = smartseo_get_current_mode_image( $smartseo_header_image );
}

$smartseo_header_id = smartseo_get_custom_header_id();
$smartseo_header_meta = get_post_meta( $smartseo_header_id, 'trx_addons_options', true );
if ( ! empty( $smartseo_header_meta['margin'] ) ) {
	smartseo_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( smartseo_prepare_css_value( $smartseo_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $smartseo_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $smartseo_header_id ) ) ); ?>
				<?php
				echo ! empty( $smartseo_header_image ) || ! empty( $smartseo_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $smartseo_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $smartseo_header_image ) {
					echo ' ' . esc_attr( smartseo_add_inline_css_class( 'background-image: url(' . esc_url( $smartseo_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( smartseo_is_on( smartseo_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight smartseo-full-height';
				}
				$smartseo_header_scheme = smartseo_get_theme_option( 'header_scheme' );
				if ( ! empty( $smartseo_header_scheme ) && ! smartseo_is_inherit( $smartseo_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $smartseo_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $smartseo_header_video ) ) {
		get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'smartseo_action_show_layout', $smartseo_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
