<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

$smartseo_template_args = get_query_var( 'smartseo_template_args' );
if ( is_array( $smartseo_template_args ) ) {
	$smartseo_columns    = empty( $smartseo_template_args['columns'] ) ? 2 : max( 1, $smartseo_template_args['columns'] );
	$smartseo_blog_style = array( $smartseo_template_args['type'], $smartseo_columns );
    $smartseo_columns_class = smartseo_get_column_class( 1, $smartseo_columns, ! empty( $smartseo_template_args['columns_tablet']) ? $smartseo_template_args['columns_tablet'] : '', ! empty($smartseo_template_args['columns_mobile']) ? $smartseo_template_args['columns_mobile'] : '' );
} else {
	$smartseo_template_args = array();
	$smartseo_blog_style = explode( '_', smartseo_get_theme_option( 'blog_style' ) );
	$smartseo_columns    = empty( $smartseo_blog_style[1] ) ? 2 : max( 1, $smartseo_blog_style[1] );
    $smartseo_columns_class = smartseo_get_column_class( 1, $smartseo_columns );
}

$smartseo_post_format = get_post_format();
$smartseo_post_format = empty( $smartseo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $smartseo_post_format );

?><div class="
<?php
if ( ! empty( $smartseo_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( smartseo_is_blog_style_use_masonry( $smartseo_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $smartseo_columns ) : esc_attr( $smartseo_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $smartseo_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $smartseo_columns )
		. ( 'portfolio' != $smartseo_blog_style[0] ? ' ' . esc_attr( $smartseo_blog_style[0] )  . '_' . esc_attr( $smartseo_columns ) : '' )
	);
	smartseo_add_blog_animation( $smartseo_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$smartseo_hover   = ! empty( $smartseo_template_args['hover'] ) && ! smartseo_is_inherit( $smartseo_template_args['hover'] )
								? $smartseo_template_args['hover']
								: smartseo_get_theme_option( 'image_hover' );

	if ( 'dots' == $smartseo_hover ) {
		$smartseo_post_link = empty( $smartseo_template_args['no_links'] )
								? ( ! empty( $smartseo_template_args['link'] )
									? $smartseo_template_args['link']
									: get_permalink()
									)
								: '';
		$smartseo_target    = ! empty( $smartseo_post_link ) && smartseo_is_external_url( $smartseo_post_link )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$smartseo_components = ! empty( $smartseo_template_args['meta_parts'] )
							? ( is_array( $smartseo_template_args['meta_parts'] )
								? $smartseo_template_args['meta_parts']
								: explode( ',', $smartseo_template_args['meta_parts'] )
								)
							: smartseo_array_get_keys_by_value( smartseo_get_theme_option( 'meta_parts' ) );

	// Featured image
	smartseo_show_post_featured( apply_filters( 'smartseo_filter_args_featured',
        array(
			'hover'         => $smartseo_hover,
			'no_links'      => ! empty( $smartseo_template_args['no_links'] ),
			'thumb_size'    => ! empty( $smartseo_template_args['thumb_size'] )
								? $smartseo_template_args['thumb_size']
								: smartseo_get_thumb_size(
									smartseo_is_blog_style_use_masonry( $smartseo_blog_style[0] )
										? (	strpos( smartseo_get_theme_option( 'body_style' ), 'full' ) !== false || $smartseo_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( smartseo_get_theme_option( 'body_style' ), 'full' ) !== false || $smartseo_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => smartseo_is_blog_style_use_masonry( $smartseo_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $smartseo_components,
			'class'         => 'dots' == $smartseo_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $smartseo_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $smartseo_post_link )
												? '<a href="' . esc_url( $smartseo_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $smartseo_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $smartseo_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $smartseo_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!