<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.71.0
 */

$smartseo_template_args = get_query_var( 'smartseo_template_args' );
if ( ! is_array( $smartseo_template_args ) ) {
	$smartseo_template_args = array(
								'type'    => 'band',
								'columns' => 1
								);
}

$smartseo_columns       = 1;

$smartseo_expanded      = ! smartseo_sidebar_present() && smartseo_get_theme_option( 'expand_content' ) == 'expand';

$smartseo_post_format   = get_post_format();
$smartseo_post_format   = empty( $smartseo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $smartseo_post_format );

if ( is_array( $smartseo_template_args ) ) {
	$smartseo_columns    = empty( $smartseo_template_args['columns'] ) ? 1 : max( 1, $smartseo_template_args['columns'] );
	$smartseo_blog_style = array( $smartseo_template_args['type'], $smartseo_columns );
	if ( ! empty( $smartseo_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $smartseo_columns > 1 ) {
	    $smartseo_columns_class = smartseo_get_column_class( 1, $smartseo_columns, ! empty( $smartseo_template_args['columns_tablet']) ? $smartseo_template_args['columns_tablet'] : '', ! empty($smartseo_template_args['columns_mobile']) ? $smartseo_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $smartseo_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $smartseo_post_format ) );
	smartseo_add_blog_animation( $smartseo_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$smartseo_hover      = ! empty( $smartseo_template_args['hover'] ) && ! smartseo_is_inherit( $smartseo_template_args['hover'] )
							? $smartseo_template_args['hover']
							: smartseo_get_theme_option( 'image_hover' );
	$smartseo_components = ! empty( $smartseo_template_args['meta_parts'] )
							? ( is_array( $smartseo_template_args['meta_parts'] )
								? $smartseo_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $smartseo_template_args['meta_parts'] ) )
								)
							: smartseo_array_get_keys_by_value( smartseo_get_theme_option( 'meta_parts' ) );
	smartseo_show_post_featured( apply_filters( 'smartseo_filter_args_featured',
		array(
			'no_links'   => ! empty( $smartseo_template_args['no_links'] ),
			'hover'      => $smartseo_hover,
			'meta_parts' => $smartseo_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $smartseo_template_args['thumb_size'] )
								? $smartseo_template_args['thumb_size']
								: smartseo_get_thumb_size( 
								in_array( $smartseo_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( smartseo_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $smartseo_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$smartseo_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$smartseo_show_title = get_the_title() != '';
		$smartseo_show_meta  = count( $smartseo_components ) > 0 && ! in_array( $smartseo_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $smartseo_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'smartseo_filter_show_blog_categories', $smartseo_show_meta && in_array( 'categories', $smartseo_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'smartseo_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						smartseo_show_post_meta( apply_filters(
															'smartseo_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $smartseo_hover, 1
															)
											);
						?>
					</div>
					<?php
					$smartseo_components = smartseo_array_delete_by_value( $smartseo_components, 'categories' );
					do_action( 'smartseo_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'smartseo_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'smartseo_action_before_post_title' );
					if ( empty( $smartseo_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'smartseo_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $smartseo_template_args['excerpt_length'] ) && ! in_array( $smartseo_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$smartseo_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'smartseo_filter_show_blog_excerpt', empty( $smartseo_template_args['hide_excerpt'] ) && smartseo_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				smartseo_show_post_content( $smartseo_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'smartseo_filter_show_blog_meta', $smartseo_show_meta, $smartseo_components, 'band' ) ) {
			if ( count( $smartseo_components ) > 0 ) {
				do_action( 'smartseo_action_before_post_meta' );
				smartseo_show_post_meta(
					apply_filters(
						'smartseo_filter_post_meta_args', array(
							'components' => join( ',', $smartseo_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'smartseo_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'smartseo_filter_show_blog_readmore', ! $smartseo_show_title || ! empty( $smartseo_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $smartseo_template_args['no_links'] ) ) {
				do_action( 'smartseo_action_before_post_readmore' );
				smartseo_show_post_more_link( $smartseo_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'smartseo_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $smartseo_template_args ) ) {
	if ( ! empty( $smartseo_template_args['slider'] ) || $smartseo_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
