<?php
/**
 * Required plugins
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$smartseo_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'smartseo' ),
	'page_builders' => esc_html__( 'Page Builders', 'smartseo' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'smartseo' ),
	'socials'       => esc_html__( 'Socials and Communities', 'smartseo' ),
	'events'        => esc_html__( 'Events and Appointments', 'smartseo' ),
	'content'       => esc_html__( 'Content', 'smartseo' ),
	'other'         => esc_html__( 'Other', 'smartseo' ),
);
$smartseo_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'smartseo' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'smartseo' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $smartseo_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'smartseo' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'smartseo' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $smartseo_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'smartseo' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'smartseo' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $smartseo_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'smartseo' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'smartseo' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $smartseo_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'smartseo' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'smartseo' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'woocommerce.png',
		'group'       => $smartseo_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'smartseo' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'smartseo' ),
		'required'    => false,
		'install'     => false, // TRX_addons has marked the "Elegro Crypto Payment" plugin as obsolete and no longer recommends it for installation, even if it had been previously recommended by the theme
		'logo'        => 'elegro-payment.png',
		'group'       => $smartseo_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'smartseo' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'smartseo' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $smartseo_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'smartseo' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'smartseo' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $smartseo_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $smartseo_theme_required_plugins_groups['events'],
	),
	'quickcal'                     => array(
		'title'       => esc_html__( 'QuickCal', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'quickcal.png',
		'group'       => $smartseo_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $smartseo_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'smartseo' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'smartseo' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $smartseo_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => smartseo_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $smartseo_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'logo'        => smartseo_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $smartseo_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => smartseo_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $smartseo_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => smartseo_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $smartseo_theme_required_plugins_groups['ecommerce'],
	),
	'woo-smart-quick-view'                  => array(
		'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => smartseo_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
		'group'       => $smartseo_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => smartseo_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $smartseo_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $smartseo_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'smartseo' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'revslider.png',
		'group'       => $smartseo_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'smartseo' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'smartseo' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $smartseo_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'smartseo' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'smartseo' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $smartseo_theme_required_plugins_groups['other'],
	),
	'gdpr-framework'         => array(
		'title'       => esc_html__( 'The GDPR Framework', 'smartseo' ),
		'description' => esc_html__( "Tools to help make your website GDPR-compliant. Fully documented, extendable and developer-friendly.", 'smartseo' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'gdpr-framework.png',
		'group'       => $smartseo_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'smartseo' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'smartseo' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $smartseo_theme_required_plugins_groups['other'],
	),
);

if ( SMARTSEO_THEME_FREE ) {
	unset( $smartseo_theme_required_plugins['js_composer'] );
	unset( $smartseo_theme_required_plugins['booked'] );
	unset( $smartseo_theme_required_plugins['quickcal'] );
	unset( $smartseo_theme_required_plugins['the-events-calendar'] );
	unset( $smartseo_theme_required_plugins['calculated-fields-form'] );
	unset( $smartseo_theme_required_plugins['essential-grid'] );
	unset( $smartseo_theme_required_plugins['revslider'] );
	unset( $smartseo_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $smartseo_theme_required_plugins['trx_updater'] );
	unset( $smartseo_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
smartseo_storage_set( 'required_plugins', $smartseo_theme_required_plugins );
