<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

$smartseo_template = apply_filters( 'smartseo_filter_get_template_part', smartseo_blog_archive_get_template() );

if ( ! empty( $smartseo_template ) && 'index' != $smartseo_template ) {

	get_template_part( $smartseo_template );

} else {

	smartseo_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$smartseo_stickies   = is_home()
								|| ( in_array( smartseo_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) smartseo_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$smartseo_post_type  = smartseo_get_theme_option( 'post_type' );
		$smartseo_args       = array(
								'blog_style'     => smartseo_get_theme_option( 'blog_style' ),
								'post_type'      => $smartseo_post_type,
								'taxonomy'       => smartseo_get_post_type_taxonomy( $smartseo_post_type ),
								'parent_cat'     => smartseo_get_theme_option( 'parent_cat' ),
								'posts_per_page' => smartseo_get_theme_option( 'posts_per_page' ),
								'sticky'         => smartseo_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $smartseo_stickies )
															&& count( $smartseo_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		smartseo_blog_archive_start();

		do_action( 'smartseo_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'smartseo_action_before_page_author' );
			get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'smartseo_action_after_page_author' );
		}

		if ( smartseo_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'smartseo_action_before_page_filters' );
			smartseo_show_filters( $smartseo_args );
			do_action( 'smartseo_action_after_page_filters' );
		} else {
			do_action( 'smartseo_action_before_page_posts' );
			smartseo_show_posts( array_merge( $smartseo_args, array( 'cat' => $smartseo_args['parent_cat'] ) ) );
			do_action( 'smartseo_action_after_page_posts' );
		}

		do_action( 'smartseo_action_blog_archive_end' );

		smartseo_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'smartseo_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
