<?php
$smartseo_woocommerce_sc = smartseo_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $smartseo_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$smartseo_scheme = smartseo_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $smartseo_scheme ) && ! smartseo_is_inherit( $smartseo_scheme ) ) {
			echo ' scheme_' . esc_attr( $smartseo_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( smartseo_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( smartseo_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$smartseo_css      = '';
			$smartseo_bg_image = smartseo_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $smartseo_bg_image ) ) {
				$smartseo_css .= 'background-image: url(' . esc_url( smartseo_get_attachment_url( $smartseo_bg_image ) ) . ');';
			}
			if ( ! empty( $smartseo_css ) ) {
				echo ' style="' . esc_attr( $smartseo_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$smartseo_anchor_icon = smartseo_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$smartseo_anchor_text = smartseo_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $smartseo_anchor_icon ) || ! empty( $smartseo_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $smartseo_anchor_icon ) ? ' icon="' . esc_attr( $smartseo_anchor_icon ) . '"' : '' )
											. ( ! empty( $smartseo_anchor_text ) ? ' title="' . esc_attr( $smartseo_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( smartseo_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' smartseo-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$smartseo_css      = '';
				$smartseo_bg_mask  = smartseo_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$smartseo_bg_color_type = smartseo_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $smartseo_bg_color_type ) {
					$smartseo_bg_color = smartseo_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $smartseo_bg_color_type ) {
					$smartseo_bg_color = smartseo_get_scheme_color( 'bg_color', $smartseo_scheme );
				} else {
					$smartseo_bg_color = '';
				}
				if ( ! empty( $smartseo_bg_color ) && $smartseo_bg_mask > 0 ) {
					$smartseo_css .= 'background-color: ' . esc_attr(
						1 == $smartseo_bg_mask ? $smartseo_bg_color : smartseo_hex2rgba( $smartseo_bg_color, $smartseo_bg_mask )
					) . ';';
				}
				if ( ! empty( $smartseo_css ) ) {
					echo ' style="' . esc_attr( $smartseo_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$smartseo_caption     = smartseo_get_theme_option( 'front_page_woocommerce_caption' );
				$smartseo_description = smartseo_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $smartseo_caption ) || ! empty( $smartseo_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $smartseo_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $smartseo_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $smartseo_caption, 'smartseo_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $smartseo_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $smartseo_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $smartseo_description ), 'smartseo_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $smartseo_woocommerce_sc ) {
						$smartseo_woocommerce_sc_ids      = smartseo_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$smartseo_woocommerce_sc_per_page = count( explode( ',', $smartseo_woocommerce_sc_ids ) );
					} else {
						$smartseo_woocommerce_sc_per_page = max( 1, (int) smartseo_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$smartseo_woocommerce_sc_columns = max( 1, min( $smartseo_woocommerce_sc_per_page, (int) smartseo_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$smartseo_woocommerce_sc}"
										. ( 'products' == $smartseo_woocommerce_sc
												? ' ids="' . esc_attr( $smartseo_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $smartseo_woocommerce_sc
												? ' category="' . esc_attr( smartseo_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $smartseo_woocommerce_sc
												? ' orderby="' . esc_attr( smartseo_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( smartseo_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $smartseo_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $smartseo_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
