<div class="front_page_section front_page_section_testimonials<?php
	$smartseo_scheme = smartseo_get_theme_option( 'front_page_testimonials_scheme' );
	if ( ! empty( $smartseo_scheme ) && ! smartseo_is_inherit( $smartseo_scheme ) ) {
		echo ' scheme_' . esc_attr( $smartseo_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( smartseo_get_theme_option( 'front_page_testimonials_paddings' ) );
	if ( smartseo_get_theme_option( 'front_page_testimonials_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$smartseo_css      = '';
		$smartseo_bg_image = smartseo_get_theme_option( 'front_page_testimonials_bg_image' );
		if ( ! empty( $smartseo_bg_image ) ) {
			$smartseo_css .= 'background-image: url(' . esc_url( smartseo_get_attachment_url( $smartseo_bg_image ) ) . ');';
		}
		if ( ! empty( $smartseo_css ) ) {
			echo ' style="' . esc_attr( $smartseo_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$smartseo_anchor_icon = smartseo_get_theme_option( 'front_page_testimonials_anchor_icon' );
	$smartseo_anchor_text = smartseo_get_theme_option( 'front_page_testimonials_anchor_text' );
if ( ( ! empty( $smartseo_anchor_icon ) || ! empty( $smartseo_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_testimonials"'
									. ( ! empty( $smartseo_anchor_icon ) ? ' icon="' . esc_attr( $smartseo_anchor_icon ) . '"' : '' )
									. ( ! empty( $smartseo_anchor_text ) ? ' title="' . esc_attr( $smartseo_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_testimonials_inner
	<?php
	if ( smartseo_get_theme_option( 'front_page_testimonials_fullheight' ) ) {
		echo ' smartseo-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$smartseo_css      = '';
			$smartseo_bg_mask  = smartseo_get_theme_option( 'front_page_testimonials_bg_mask' );
			$smartseo_bg_color_type = smartseo_get_theme_option( 'front_page_testimonials_bg_color_type' );
			if ( 'custom' == $smartseo_bg_color_type ) {
				$smartseo_bg_color = smartseo_get_theme_option( 'front_page_testimonials_bg_color' );
			} elseif ( 'scheme_bg_color' == $smartseo_bg_color_type ) {
				$smartseo_bg_color = smartseo_get_scheme_color( 'bg_color', $smartseo_scheme );
			} else {
				$smartseo_bg_color = '';
			}
			if ( ! empty( $smartseo_bg_color ) && $smartseo_bg_mask > 0 ) {
				$smartseo_css .= 'background-color: ' . esc_attr(
					1 == $smartseo_bg_mask ? $smartseo_bg_color : smartseo_hex2rgba( $smartseo_bg_color, $smartseo_bg_mask )
				) . ';';
			}
			if ( ! empty( $smartseo_css ) ) {
				echo ' style="' . esc_attr( $smartseo_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_testimonials_content_wrap content_wrap">
			<?php
			// Caption
			$smartseo_caption = smartseo_get_theme_option( 'front_page_testimonials_caption' );
			if ( ! empty( $smartseo_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_testimonials_caption front_page_block_<?php echo ! empty( $smartseo_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $smartseo_caption, 'smartseo_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$smartseo_description = smartseo_get_theme_option( 'front_page_testimonials_description' );
			if ( ! empty( $smartseo_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_testimonials_description front_page_block_<?php echo ! empty( $smartseo_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $smartseo_description ), 'smartseo_kses_content' ); ?></div>
				<?php
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_testimonials_output">
				<?php
				if ( is_active_sidebar( 'front_page_testimonials_widgets' ) ) {
					dynamic_sidebar( 'front_page_testimonials_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! smartseo_exists_trx_addons() ) {
						smartseo_customizer_need_trx_addons_message();
					} else {
						smartseo_customizer_need_widgets_message( 'front_page_testimonials_caption', 'ThemeREX Addons - Testimonials' );
					}
				}
				?>
			</div>
		</div>
	</div>
</div>
