<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

							do_action( 'smartseo_action_page_content_end_text' );
							
							// Widgets area below the content
							smartseo_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'smartseo_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'smartseo_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'smartseo_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'smartseo_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$smartseo_body_style = smartseo_get_theme_option( 'body_style' );
					$smartseo_widgets_name = smartseo_get_theme_option( 'widgets_below_page', 'hide' );
					$smartseo_show_widgets = ! smartseo_is_off( $smartseo_widgets_name ) && is_active_sidebar( $smartseo_widgets_name );
					$smartseo_show_related = smartseo_is_single() && smartseo_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $smartseo_show_widgets || $smartseo_show_related ) {
						if ( 'fullscreen' != $smartseo_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $smartseo_show_related ) {
							do_action( 'smartseo_action_related_posts' );
						}

						// Widgets area below page content
						if ( $smartseo_show_widgets ) {
							smartseo_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $smartseo_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'smartseo_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'smartseo_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! smartseo_is_singular( 'post' ) && ! smartseo_is_singular( 'attachment' ) ) || ! in_array ( smartseo_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="smartseo_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'smartseo_action_before_footer' );

				// Footer
				$smartseo_footer_type = smartseo_get_theme_option( 'footer_type' );
				if ( 'custom' == $smartseo_footer_type && ! smartseo_is_layouts_available() ) {
					$smartseo_footer_type = 'default';
				}
				get_template_part( apply_filters( 'smartseo_filter_get_template_part', "templates/footer-" . sanitize_file_name( $smartseo_footer_type ) ) );

				do_action( 'smartseo_action_after_footer' );

			}
			?>

			<?php do_action( 'smartseo_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'smartseo_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'smartseo_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>