<?php
/***************************************************************************
 *						Theme Modules
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  					Copyright (C) Themify
 * 						https://themify.me
 *
 *  To add custom modules to the theme, create a new 'custom-modules.php' file in the theme folder.
 *  They will be added to the theme automatically.
 * 
 ***************************************************************************/

/**
 * Markup for theme design options
 * @param array $data
 * @return string
 */
function themify_theme_design_controls( $data = array() ) {
	/**
	 * Module markup
	 * @var string
	 */
	$html = '<div class="themify-info-link">'. __( 'Here you can set the theme appearance site-wide. The appearance settings here can be override on individual post/page &gt; edit &gt; Themify Custom Panel  &gt; Page Appearance).', 'themify' ) .'</div>';


	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-color_design';

	/**
	 * Header Design
	 * @var array
	 */
	$design_options = themify_theme_header_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$pre = 'setting-header_design';

	// Store items to hide
	$html .= '<div class="group-hide" data-hide="none header-left-pane header-minbar-left header-minbar-right header-boxed-content header-right-pane">';

		/**
		 * Header Design
		 */

		$html .= '<p class="tf_clearfix">
						<span class="label">' . __( 'Header Design', 'themify' ) . '</span>';
		$val = themify_get( $pre,'header-logo-center',true);
		$html .= '<span class="preview-icon-wrapper">';
		unset( $design_options[0] );
		foreach ( $design_options as $option ) {
			$class = $val == $option['value']? ' selected' : '';

			$html .= '<a href="#" class="preview-icon' . $class . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . THEME_URI . '/' . $option['img']  . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}

		$html .= '	<input type="hidden" name="' . $pre. '" class="val" value="' . esc_attr( $val ) . '" />';
		$html .= '</span>';
					'</p>';

		/**
		 * Fixed header
		 */
		$html .= sprintf('<p class="hide-if none header-leftpane header-slide-left header-slide-right header-minbar boxed-content header-rightpane pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-revealing_header',
			checked( themify_get( 'setting-revealing_header','',true ), 'on', false ),
			__('Enable Revealing Header.', 'themify')
		);

		$html .= sprintf('<p class="hide-if none header-slide-left header-slide-right header-boxed-content header-left-pane header-right-pane header-minbar-left header-minbar-right pushlabel" data-show-if-element="[name=setting-revealing_header]" data-show-if-value="false"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-fixed_header_disabled',
			checked( themify_get( 'setting-fixed_header_disabled','',true ), 'on', false ),
			__('Disable Sticky Header.', 'themify')
		);

		/**
		 * Full height header
		 */
		$key = 'setting-full_height_header';
		$html .= sprintf('<p class="hide-if none header-logo-left header-left-pane header-minbar-left header-minbar-right header-slide-left header-slide-right header-top-bar header-boxed-layout header-boxed-content header-right-pane header-stripe header-logo-center header-overlay pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s value="yes"/> %3$s</label>
			<br><small>%4$s</small>
			</p>',
			$key,
			checked( themify_get( $key ), 'yes', false ),
			__( 'Full Height Header.', 'themify' ),
			__( 'Full height will display the container in 100% viewport height', 'themify' )
		);
		
		/**
		 * Exclude Site Logo
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_site_logo',
			checked( themify_get( 'setting-exclude_site_logo' ), 'on', false ),
			__('Exclude Site Logo.', 'themify')
		);

		/**
		 * Exclude Site Tagline
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_site_tagline',
			checked( themify_get( 'setting-exclude_site_tagline','',true ), 'on', false ),
			__('Exclude Site Tagline.', 'themify')
		);

		/**
		 * Exclude Cart Icon
		 */
		if( themify_is_woocommerce_active() ) {
			$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
				'setting-exclude_cart',
				checked( themify_get( 'setting-exclude_cart','',true ), 'on', false ),
				__('Exclude Cart Icon.', 'themify')
			);
			
			$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
				'setting-exclude_wishlist',
				checked( themify_get( 'setting-exclude_wishlist','',true ), 'on', false ),
				__('Exclude Wishlist Icon.', 'themify')
			);
		}

		/**
		 * Exclude Search Form
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_search_button',
			checked( themify_get( 'setting-exclude_search_button','',true  ), 'on', false ),
			__('Exclude Search Icon.', 'themify')
		);

		/**
		 * Exclude Menu Navigation
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_menu_navigation',
			checked( themify_get( 'setting-exclude_menu_navigation','',true  ), 'on', false ),
			__('Exclude Menu Navigation.', 'themify')
		);

		/**
		 * Exclude Top Bar Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-exclude_top_bar_widgets',
			checked( themify_get( 'setting-exclude_top_bar_widgets','',true  ), 'on', false ),
			__('Exclude Top Bar Widgets.', 'themify')
		);

		/**
		 * Mobile Menu Designs
		 */
		$html .= '<p class="hide-if none" data-show-if-element="[name=setting-exclude_menu_navigation]" data-show-if-value="false"><span class="label">' . __( 'Mobile Menu Style', 'themify' ) . '</span>';
		$html.='<select name="setting-mobile-menu-styles">' . themify_options_module( array(
			array( 'name' => __( 'Default', 'themify' ), 'value' => 'default' ),
			array( 'name' => __( 'Boxed', 'themify' ), 'value' => 'boxed' ),
			array( 'name' => __( 'Dropdown', 'themify' ), 'value' => 'dropdown' ),
			array( 'name' => __( 'Fade Overlay', 'themify' ), 'value' => 'fade-overlay' ),
			array( 'name' => __( 'Fadein Down', 'themify' ), 'value' => 'fadein-down' ),
			array( 'name' => __( 'Flip Down', 'themify' ), 'value' => 'flip-down' ),
			array( 'name' => __( 'FlipIn Left', 'themify' ), 'value' => 'flipin-left' ),
			array( 'name' => __( 'FlipIn Right', 'themify' ), 'value' => 'flipin-right' ),
			array( 'name' => __( 'Flip from Left', 'themify' ), 'value' => 'flip-from-left' ),
			array( 'name' => __( 'Flip from Right', 'themify' ), 'value' => 'flip-from-right' ),
			array( 'name' => __( 'Flip from Top', 'themify' ), 'value' => 'flip-from-top' ),
			array( 'name' => __( 'Flip from Bottom', 'themify' ), 'value' => 'flip-from-bottom' ),
			array( 'name' => __( 'Morphing', 'themify' ), 'value' => 'morphing' ),
			array( 'name' => __( 'Overlay ZoomIn', 'themify' ), 'value' => 'overlay-zoomin' ),
			array( 'name' => __( 'Overlay ZoomIn Right', 'themify' ), 'value' => 'overlay-zoomin-right' ),
			array( 'name' => __( 'Rotate ZoomIn', 'themify' ), 'value' => 'rotate-zoomin' ),
			array( 'name' => __( 'Slide Down', 'themify' ), 'value' => 'slide-down' ),
			array( 'name' => __( 'SlideIn Left', 'themify' ), 'value' => 'slidein-left' ),
			array( 'name' => __( 'SlideIn Right', 'themify' ), 'value' => 'slidein-right' ),
			array( 'name' => __( 'Split', 'themify' ), 'value' => 'split' ),
			array( 'name' => __( 'Swing Left to Right', 'themify' ), 'value' => 'swing-left-to-right' ),
			array( 'name' => __( 'Swing Right to Left', 'themify' ), 'value' => 'swing-right-to-left' ),
			array( 'name' => __( 'Swing Top to Bottom', 'themify' ), 'value' => 'swing-top-to-bottom' ),
			array( 'name' => __( 'Swipe Left', 'themify' ), 'value' => 'swipe-left' ),
			array( 'name' => __( 'Swipe Right', 'themify' ), 'value' => 'swipe-right' ),
			array( 'name' => __( 'Zoom Down', 'themify' ), 'value' => 'zoomdown' ),
		), 'setting-mobile-menu-styles' ) . '
		</select></p>';

	/**
	 * Expand All child menus
	 */
	$html .= sprintf('<p class="hide-if none pushlabel" data-show-if-element="[name=setting-exclude_menu_navigation]" data-show-if-value="false"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		'setting-mobile_menu_expand',
		checked( themify_get( 'setting-mobile_menu_expand','',true ), 'on', false ),
		__('Expand all child menus', 'themify')
	);

	/**
	 * Toggle child menus
	 */
	$html .= sprintf('<p class="hide-if none pushlabel" data-show-if-element="[name=setting-exclude_menu_navigation]" data-show-if-value="false"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
		'setting-mobile_menu_toggle',
		checked( themify_get( 'setting-mobile_menu_toggle','',true ), 'on', false ),
		__('Toggle child menus like accordion', 'themify')
	);

	// End group of elements to hide
	$html .= '</div><!-- /.group-hide -->';

	$html .= '<p><span class="label">' . __( 'Main Menu Tooltip', 'themify' ) .themify_help(__( 'On main navigation menu, use WordPress menu link title attribute as tooltip.', 'themify' )) . '</span>';
		$html .= sprintf('<label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'menu_tooltips',
			checked( themify_get( 'menu_tooltips','',true ), 'on', false ),
			__('Enable menu tooltip (use link title attribute as tooltip)', 'themify')
		);
	$html .= '</p>';

	/**
	 * Footer Design
	 * @var array
	 */
	$design_options = themify_theme_footer_design_options();

	/**
	 * Prefix for theme settings
	 * @var string
	 */
	$key = 'setting-footer_design';

	// Store items to hide
	$html .= '<div class="group-hide" data-hide="none">';

		/**
		 * Footer Design
		 */
		$html .= '<p>
						<span class="label">' . __( 'Footer Design', 'themify' ) . '</span>';
		$val = themify_get( $key,'',true );
		foreach ( $design_options as $option ) {
                        if($option['value']==='default'){
                            continue;
                        }
                        elseif($option['value']==='footer-block'){
                            $option['selected'] = true;
                        }
			if (!$val && $option['selected'] ) {
				$val = $option['value'];
			}

			$class = $val == $option['value'] ? ' selected' : '';

			$html .= '<a href="#" class="preview-icon' . $class . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . THEME_URI . '/' . $option['img'] . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
		}

		$html .= '	<input type="hidden" name="' . $key. '" class="val" value="' . esc_attr( $val ) . '" />
					</p>';

		// Exclusions

		$key = 'setting-exclude_';

		/**
		 * Exclude Site Logo
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_site_logo',
			checked( themify_get( $key . 'footer_site_logo','',true ), 'on', false ),
			__('Exclude Site Logo.', 'themify')
		);

		/**
		 * Exclude Footer Widgets
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_widgets',
			checked( themify_get( $key . 'footer_widgets','',true ), 'on', false ),
			__('Exclude Footer Widgets.', 'themify')
		);

		/**
		 * Exclude Menu Navigation
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_menu_navigation',
			checked( themify_get( $key . 'footer_menu_navigation','',true ), 'on', false ),
			__('Exclude Menu Navigation.', 'themify')
		);

		/**
		 * Exclude Footer Texts
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_texts',
			checked( themify_get( $key . 'footer_texts','',true ), 'on', false ),
			__('Exclude Footer Text', 'themify')
		);

		/**
		 * Exclude Footer Back to Top
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			$key . 'footer_back',
			checked( themify_get( $key . 'footer_back','',true ), 'on', false ),
			__('Exclude Back to Top button', 'themify')
		);

        /**
         * Use Floating Back to Top
         */
        $html .= sprintf('<p class="hide-if none pushlabel" data-show-if-element="[name=setting-exclude_footer_back]" data-show-if-value="false"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
            'setting-use_float_back',
            checked( themify_get( 'setting-use_float_back' ,'',true), 'on', false ),
            __('Use Floating Back to Top Button', 'themify')
        );

		/**
		 * Revealing footer
		 */
		$html .= sprintf('<p class="hide-if none pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
			'setting-revealing_footer',
			checked( themify_get( 'setting-revealing_footer' ), 'on', false ),
			__( 'Enable Revealing Footer', 'themify' )
		);

	// End group of elements to hide
	$html .= '</div><!-- /.group-hide -->';

	$options = array(
		array(
			'value' => 'footerwidget-4col',
			'img' => 'themify/img/sidebars/4col.png',
			'title' => __('Widgets 4 Columns', 'themify')),
		array(
			'value' => 'footerwidget-3col',
			'img' => 'themify/img/sidebars/3col.png',
			'title' => __('Widgets 3 Columns', 'themify'),
			'selected' => true),
		array(
			'value' => 'footerwidget-2col',
			'img' => 'themify/img/sidebars/2col.png',
			'title' => __('Widgets 2 Columns', 'themify')),
		array(
			'value' => 'footerwidget-1col',
			'img' => 'themify/img/sidebars/1col.png',
			'title' => __('Widgets 1 Column', 'themify')),
		array(
			'value' => 'none_widget',
			'img' => 'themify/img/sidebars/none.png',
			'title' => __('No Widgets', 'themify'))
	);
	$val = themify_get( 'setting-footer_widgets',false,true );
	$html.='<div data-show-if-element="[name=setting-footer_design]"  data-show-if-value=' . '["footer-block","footer-left-column","footer-right-column","footer-horizontal-left","footer-horizontal-right"]' . '>';
	$html .= '<p><span class="label">' . __( 'Footer Widgets', 'themify' ) . '</span>';

	foreach($options as $option){
		if(!$val && isset($option['selected']) && $option['selected']){ 
		    $val = $option['value'];
		}
		$class = $val == $option['value']?' selected':'';
		$html .= '<a href="#" class="' . 'preview-icon' . $class . '" title="' . esc_attr( $option['title'] ) . '"><img src="' . THEME_URI.'/'.$option['img'] . '" alt="' . esc_attr( $option['value'] ) . '"  /></a>';
	}
	$html .= '<input type="hidden" name="setting-footer_widgets" class="val" value="' . esc_attr( $val ) . '" />';

	$html .= '</p>';
		
		// Footer widget position
	$key = 'setting-footer_widget_position';
	$html .= '<p data-show-if-element="[name=setting-footer_widgets]"  data-show-if-value=' . '["footerwidget-1col","footerwidget-2col","footerwidget-3col","footerwidget-4col"]' . '><span class="label">' . __( 'Footer Widgets Position', 'themify' ) . '</span>';
	$html.='<select name="' . $key . '">' . themify_options_module( array(
				array( 'name' => __( 'After Footer Text', 'themify' ), 'value' => '' ),
				array( 'name' => __( 'Before Footer Text', 'themify' ), 'value' => 'top' ),
		), $key ) . '
		</select></p>';

    // Rounded Corners
    $key = 'setting-rounded_corners_';
    $html .= sprintf('<p><span class="label">%1$s</span><label for="%2$s"><input type="checkbox" id="%2$s" name="%2$s" %3$s /> %4$s</label></p>',
        __('Rounded Corners', 'themify'),
        $key . 'images',
        checked( themify_get( $key . 'images',null,true ), 'on', false ),
        __('Reset rounded corners on featured images', 'themify')
    );
    $html .= sprintf('<p class="pushlabel"><label for="%1$s"><input type="checkbox" id="%1$s" name="%1$s" %2$s /> %3$s</label></p>',
        $key . 'inputs',
        checked( themify_get( $key . 'inputs',null,true ), 'on', false ),
        __('Reset rounded corners on form inputs/buttons', 'themify')
    );

	$html.='</div>';
	return $html;
}

/**
 * Image Filter Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_image_filter( $data = array() ) {
	$data = themify_get_data();
	/**
	 * Theme Settings Option Key Prefix
	 *
	 * @var string
	 */
	$key = 'setting-imagefilter_options';

	/**
	 * Module markup
	 * @var string
	 */
	$out = '<p>
				<span class="label">' . __( 'Image Filter', 'themify' ) . '</span>
				<select name="' . $key . '">' . themify_options_module( array(
					array( 'name' => __( 'None', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Grayscale', 'themify' ), 'value' => 'grayscale' ),
					array( 'name' => __( 'Sepia', 'themify' ), 'value' => 'sepia' ),
					array( 'name' => __( 'Blur', 'themify' ), 'value' => 'blur' ),
				), $key ) . '
				</select>
			</p>';


	$out .= '<p>
				<span class="label">' . __( 'Image Hover Filter', 'themify' ) . '</span>
				<select name="' . $key . '_hover">' . themify_options_module( array(
					array( 'name' => __( 'None', 'themify' ), 'value' => '' ),
					array( 'name' => __( 'Grayscale', 'themify' ), 'value' => 'grayscale' ),
					array( 'name' => __( 'Sepia', 'themify' ), 'value' => 'sepia' ),
					array( 'name' => __( 'Blur', 'themify' ), 'value' => 'blur' ),
				), $key . '_hover' ) . '
				</select>
			</p>';

	$key1 = 'setting-imagefilter_applyto';
	$preset = themify_get( $key1,'featuredonly',true );
	$out .= '<div>
				<span class="label">' . __( 'Apply to', 'themify' ) . '</span>' .
		        sprintf('<label for="%1$s"><input type="radio" id="%1$s" name="%1$s" %2$s value="featuredonly" /> %3$s</label>',
				$key1, checked( $preset, 'featuredonly', false ), __( 'Featured Images Only', 'themify' ) ) .
				'<br/>
				<span class="pushlabel">' .
		        sprintf('<label for="%1$s"><input type="radio" id="%1$s" name="%1$s" %2$s value="allimages" /> %3$s</label>',
				$key1, checked( themify_get( $key1 ), 'allimages', false ), __( 'All Images', 'themify' ) ) . '
				</span>
			</div>';

	return $out;
}


/**
 * Default Index Layout Module
 * @param array $data Theme settings data
 * @return string Markup for module.
 * @since 1.0.0
 */
function themify_default_layout( $data = array() ){
	$data = themify_get_data();

	/**
	 * Theme Settings Option Key Prefix
	 * @var string
	 */
	$prefix = 'setting-default_';
	
	if ( ! isset( $data[$prefix . 'more_text'] ) || '' == $data[$prefix . 'more_text'] ) {
		$more_text = __( 'More', 'themify' );
	} else {
		$more_text = $data[$prefix . 'more_text'];
	}

	/**
	 * Tertiary options <blank>|yes|no
	 * @var array
	 */
	$default_options = array(
		array('name' => '', 'value' => ''),
		array('name' => __('Yes', 'themify'), 'value' => 'yes'),
		array('name' => __('No', 'themify'), 'value' => 'no')
	);

	/**
	 * Default options 'yes', 'no'
	 * @var array
	 */
	$binary_options = array(
		array('name'=>__('Yes', 'themify'),'value'=>'yes'),
		array('name'=>__('No', 'themify'),'value'=>'no')
	);

	/**
	 * Post content display options
	 * @var array
	 */
	$default_display_options = array(
		array('name' => __('Full Content', 'themify'),'value' => 'content'),
		array('name' => __('Excerpt', 'themify'),'value' => 'excerpt'),
		array('name' => __('None', 'themify'),'value' => 'none')
	);


	/**
	 * Entry media position, above or below the title
	 */
	$media_position = array(
		array('name'=>__('Above Post Title', 'themify'), 'value'=>'above'),
		array('name'=>__('Below Post Title', 'themify'), 'value'=>'below'),
	);

	/**
	 * HTML for settings panel
	 * @var string
	 */
	$output = '' . __( '', 'themify' ) . '';
	
	/**
	 * Index Sidebar Option
	 */
    $output .= '<p>
					<span class="label">' . __('Archive Sidebar Option', 'themify') . '</span>';
    $val = themify_get_default_selection($prefix.'layout', $data ,themify_sidebar_location_options() );
    $output .= themify_render_option_items( themify_sidebar_location_options(), $val );
    $output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';


	/**
	 * Sticky Sidebar for Archive Post
	 */

	$output .= '<p class="pushlabel" data-show-if-element="[name=' . esc_attr( $prefix ) . 'layout]" 
		    data-show-if-value=\'["", "sidebar1", "sidebar1 sidebar-left"]\'>
						<label for="'.esc_attr($prefix).'sticky_sidebar">
							<input type="checkbox" id="'.esc_attr($prefix).'sticky_sidebar" name="'.esc_attr($prefix).'sticky_sidebar" value="1"
							'.checked( themify_get( esc_attr($prefix).'sticky_sidebar' ), 1, false ) .'
							/>'.__('Enable sticky sidebar', 'themify').'
						</label>
					</p>';


	/**
     * Post Layout
     */
    $output .= '<p>
					<span class="label">' . __('Post Layout', 'themify') . '</span>';
    $val = themify_get_default_selection($prefix.'post_layout', $data ,themify_default_post_layout_options() );
    $output .= themify_render_option_items( themify_default_post_layout_options(), $val );
    $output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'post_layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	/**
	 * Post Content Style
	 */
	$output .= '<p data-show-if-element="[name=setting-default_post_layout]" data-show-if-value=' . '["grid2","grid3","grid4","grid5","grid6","list-post"]' . '>
					<span class="label">' . __( 'Post Content Style', 'themify' ) . '</span>
					<select name="setting-post_content_layout">'.
						themify_options_module( array(
							array( 'name' => __( 'Default', 'themify' ), 'value' => '' ),
							array( 'name' => __( 'Overlay', 'themify' ), 'value' => 'overlay' ),
							array( 'name' => __( 'Polaroid', 'themify' ), 'value' => 'polaroid' ),
							array( 'name' => __( 'Boxed', 'themify' ), 'value' => 'boxed' ),
							array( 'name' => __( 'Flip', 'themify' ), 'value' => 'flip' )
						), 'setting-post_content_layout' ) . '
					</select>
				</p>';

	/**
	 * Enable Masonry
	 */
	$output .=	'<p data-show-if-element="[name=setting-default_post_layout]" data-show-if-value=' . '["grid2","grid3","grid4","grid5","grid6"]' . '>
					<span class="label">' . __('Post Masonry', 'themify') . '</span>
					<select name="setting-post_masonry">' .
						themify_options_module($binary_options, 'setting-post_masonry') . '
					</select>
				</p>';

    $output .= '<p data-show-if-element="[name=setting-default_post_layout]" data-show-if-value=' . '["grid2","grid3","grid4","grid5","grid6"]' . '><span class="label">' . __('Align Posts', 'themify') . '</span>
				<label><input type="checkbox" name="setting-post_masonry_align" ' . checked(themify_check('setting-post_masonry_align',true), true, false) . ' /></label></p>';

	/**
	 * Post Gutter
	 */
	$output .= '<p>
					<span class="label">' . __( 'Post Gutter', 'themify' ) . '</span>
					<select name="setting-post_gutter">'.
						themify_options_module( array(
							array( 'name' => __( 'Default', 'themify' ), 'value' => 'gutter' ),
							array( 'name' => __( 'No gutter', 'themify' ), 'value' => 'no-gutter' )
						), 'setting-post_gutter' ) . '
					</select>
				</p>';

	/**
	 * Display Content
	 */
	$output .= '<p>
					<span class="label">' . __('Display Content', 'themify') . '</span> 
					<select name="' . esc_attr( $prefix ) . 'layout_display">'.
						themify_options_module($default_display_options, $prefix.'layout_display').'
					</select>
				</p>';

	/**
	 * Excerpt length
	 */
	$output .= '<p data-show-if-element="[name=setting-default_layout_display]" data-show-if-value=\'["excerpt"]\'>
					<span class="pushlabel vertical-grouped">
						<label>
							<input class="width2" type="text" value="' . ( isset( $data[ $prefix . 'excerpt_length' ] ) ? esc_attr( $data[ $prefix . 'excerpt_length' ] ) : '' ) . '" name="' . esc_attr( $prefix ) . 'excerpt_length"> '
							. __( 'Excerpt length (enter number of words)', 'themify' ) . '
						</label>
					</span>
				</p>';
	
	/**
	 * More Text
	 */
	$output .= '<p>
					<span class="label">' . __('More Text', 'themify') . '</span>
					<input type="text" name="' . esc_attr( $prefix ) . 'more_text" value="' . esc_attr( $more_text ) . '">
					
					<span class="pushlabel vertical-grouped"><label for="setting-excerpt_more"><input type="checkbox" value="1" id="setting-excerpt_more" name="setting-excerpt_more" '.checked( themify_get( 'setting-excerpt_more' ), 1, false ).'/> ' . __('Display more link button in excerpt mode as well.', 'themify') . '</label></span>
				</p>';

	/**
	 * Order & OrderBy Options
	 */
	$output .= themify_post_sorting_options('setting-index_order', $data);
				
	/**
	 * Hide Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_title">' .
						themify_options_module($default_options, $prefix.'post_title') . '
					</select>
				</p>';
	
	/**
	 * Unlink Post Title
	 */
	$output .= '<p>
					<span class="label">' . __('Unlink Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_title">' .
						themify_options_module($default_options, $prefix.'unlink_post_title') . '
					</select>
				</p>';
	
	/**
	 * Hide Post Meta
	 */
	$output .= themify_post_meta_options($prefix.'post_meta', $data);
	
	/**
	 * Hide Post Date
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Post Date', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_date">' .
						themify_options_module($default_options, $prefix.'post_date') . '
					</select>
				</p>';
	
	/**
	 * Auto Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Auto Featured Image', 'themify') . '</span>
					<label for="setting-auto_featured_image"><input type="checkbox" value="1" id="setting-auto_featured_image" name="setting-auto_featured_image" ' . checked( themify_get( 'setting-auto_featured_image' ), 1, false ) . '/> ' . __( 'If no featured image is specified, display first image in content.', 'themify' ) . '</label>
				</p>';
	
	/**
	 * Featured Image Position
	 */
	$output .= '<p>
					<span class="label">' . __( 'Featured Image Position', 'themify' ) . '</span>
					<select name="' . esc_attr( $prefix ) . 'media_position">' .
						themify_options_module( $media_position, $prefix.'media_position' ) . '
					</select>
				</p>';
	
	/**
	 * Hide Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Hide Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_image">' .
						themify_options_module($default_options, $prefix.'post_image') . '
					</select>
				</p>';
	
	/**
	 * Unlink Featured Image
	 */
	$output .= '<p>
					<span class="label">' . __('Unlink Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_image">' .
						themify_options_module($default_options, $prefix.'unlink_post_image') . '
					</select>
				</p>';
	
	/**
	 * Featured Image Sizes
	 */
	$output .= themify_feature_image_sizes_select('image_post_feature_size');
	
	/**
	 * Image Dimensions
	 */	
	$output .= '<p class="show_if_enabled_img_php">
                            <span class="label">' . __('Image Size', 'themify') . '</span>  
                            <input type="text" class="width2" name="setting-image_post_width" value="' . themify_get( 'setting-image_post_width' ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>
                            <input type="text" class="width2" name="setting-image_post_height" value="' . themify_get( 'setting-image_post_height' ) . '" /> <span>' . __('height', 'themify') . ' <small>(px)</small></span>
                            <br /><span class="pushlabel"><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
                    </p>';
	
	return $output;
}


if (!function_exists('themify_pagination_infinite')) {

	/**
	 * Choose pagination or infinite scroll
	 * @param array $data
	 * @return string
	 */
	function themify_pagination_infinite($data = array()) {

		$output = '<p><span class="label">' . __( 'Pagination Option', 'themify' ) . '</span>';

		//Infinite Scroll
		$output .= '<input ' . checked(  themify_get( 'setting-more_posts','infinite',true ), 'infinite', false ) . ' type="radio" id="setting-more_posts_infinite" name="setting-more_posts" value="infinite" /> ';
		$output .= __('Infinite Scroll (posts are loaded on the same page)', 'themify');
		$output .= '<div class="pushlabel indented-field" data-show-if-element="[name=setting-more_posts]:checked" data-show-if-value="infinite">';
		$output .= '<label for="setting-autoinfinite"><input type="checkbox" id="setting-autoinfinite" name="setting-autoinfinite" '.checked( themify_get( 'setting-autoinfinite' ), 'on', false ).'/> ' . __('Disable automatic infinite scroll', 'themify').'</label>';
		$output .= '<br/>';
		$output .= '<label for="setting-infinite-url"><input type="checkbox" id="setting-infinite-url" name="setting-infinite-url" '.checked( themify_get( 'setting-infinite-url' ), 'on', false ).'/> ' . __('Disable page number updates on address URL on scrolling', 'themify').'</label>';
		$output .= '</div>';
		$output .= '<br/>';

		//Numbered pagination
		$output .= '<span class="pushlabel"><input ' . checked( themify_get( 'setting-more_posts' ), 'pagination', false ) . ' type="radio" id="setting-more_posts_pagination" name="setting-more_posts" value="pagination" /> ';
		$output .= __('Standard Pagination', 'themify') . '</span>';
		$output .= '</p>';

		$key = 'setting-entries_nav';
		$output .= '<div class="pushlabel indented-field" data-show-if-element="[name=setting-more_posts]:checked" data-show-if-value="pagination">';
		$output .= '<p>';
			// Numbered pagination
			$output .= '<label for="' . esc_attr( $key . '_numbered' ) . '">';
			$output .= '<input ' . checked( isset( $data[$key] )? $data[$key] : 'numbered', 'numbered', false) . ' type="radio" id="' . esc_attr( $key . '_numbered' ) . '" name="' . esc_attr( $key ) . '" value="numbered" /> ';
			$output .= __( 'Numbered Pagination (page 1, 2, 3, etc.)', 'themify' ) . '</label>';
			$output .= '<br/>';
			
			// Previous / Next links
			$output .= '<label for="' . esc_attr( $key . '_prevnext' ) . '">';
			$output .= '<input ' . checked( isset( $data[$key] )? $data[$key] : '', 'prevnext', false ) . ' type="radio" id="' . esc_attr( $key . '_prevnext' ) . '" name="' . esc_attr( $key ) . '" value="prevnext" /> ';
			$output .= __( 'Previous Posts and Next Posts Links', 'themify' ) . '</label>';
		$output .= '</p>';
		$output .= '</div>';
		
		return $output;
	
	}

}


if (!function_exists('themify_footer_social_banners')) {

	/**
	 * Choose pagination or infinite scroll
	 * @param array $data
	 * @return string
	 */
	function themify_footer_social_banners($data = array()) {
		
		$socials = themify_get_footer_banners();
		$output = '';
		if(!empty($socials)){
			$key = 'settings-footer_banner_';
			
			foreach($socials as $k=>$v){
				$input = $key.$k;
				$output.= '<p><span class="label">' . $v . '</span><label><input type="checkbox" value="'.$k.'" id="'.$input.'" name="'.$input.'" '.checked( themify_get( $input ),$k, false ).' />'.sprintf(__('Show %s banner','themify'),$v).'</label></p>';
				$output.='<div  class="pushlabel" data-show-if-element="[name='.$input.']" data-show-if-value=' . '["true"]' . '>';
				$input = $key.$k.'_username';
				$output.='<label><input type="text" name="'.$input.'" value="'.esc_attr(themify_get($input)).'">'.__('Username','themify').'</label><br/>';
				$input = $key.$k.'_link';
				$output.='<label><input class="width8" type="text" name="'.$input.'" value="'.esc_url(themify_get($input)).'">'.__('Banner Link','themify').'</label><br/>';
				$input = $key.$k.'_image';
				$output.='<input class="width8"  type="text" id="'.$input.'" name="'.$input.'" value="'.esc_url(themify_get($input)).'">'.__('Banner Image','themify').themify_get_uploader($input, array('tomedia' => true)) .'<br/>';
				$output.='</div>';
			}
		}
		return $output;
	
	}

}

if (!function_exists('themify_search_result_layout')) {
    /**
     * search result Layout Module
     * @param array $data Theme settings data
     * @return string Markup for module.
     * @since 1.0.0
     */
    function themify_search_result_layout( $data = array() ){
        $data = themify_get_data();

        /**
         * Theme Settings Option Key Prefix
         * @var string
         */
        $prefix = 'setting-search-result_';
        $setting = 'setting-search-';

        /**
         * Index Sidebar Option
         */
        $output = '<p>
					<span class="label">' . __('Search Sidebar Option', 'themify') . '</span>';
        $val = themify_get_default_selection($prefix.'layout', $data ,themify_sidebar_location_options() );
        $output .= themify_render_option_items( themify_sidebar_location_options(), $val );
        $output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';



	    /**
	     * Sticky Sidebar for Search Result Page
	     */

	    $output .= '<p class="pushlabel" data-show-if-element="[name=' . esc_attr( $prefix ) . 'layout]" 
		    data-show-if-value=\'["", "sidebar1", "sidebar1 sidebar-left"]\'>
						<label for="'.esc_attr($prefix).'sticky_sidebar">
							<input type="checkbox" id="'.esc_attr($prefix).'sticky_sidebar" name="'.esc_attr($prefix).'sticky_sidebar" value="1"
							'.checked( themify_get( esc_attr($prefix).'sticky_sidebar' ), 1, false ) .'
							/>'.__('Enable sticky sidebar', 'themify').'
						</label>
					</p>';


	    /**
         * Post Layout
         */
        $output .= '<p>
					<span class="label">' . __('Post Layout', 'themify') . '</span>';
        $val = themify_get_default_selection(esc_attr( $prefix ).'post_layout', $data ,themify_default_post_layout_options() );
        $output .= themify_render_option_items( themify_default_post_layout_options(), $val );
        $output .= '	<input type="hidden" name="' . esc_attr( $prefix ) . 'post_layout" class="val" value="' . esc_attr( $val ) . '" />
				</p>';

	    /**
	     * Post Content Style
	     */
	    $output .= '<p data-show-if-element="[name='.esc_attr( $prefix ).'post_layout]" data-show-if-value=' . '["grid2","grid3","grid4","grid5","grid6","list-post"]' . '>
					<span class="label">' . __( 'Post Content Style', 'themify' ) . '</span>
					<select name="'.esc_attr( $prefix ).'content_layout">'.
		    themify_options_module( themify_post_contetnt_layout(), esc_attr($prefix).'content_layout' ) . '
					</select>
				</p>';


	    /**
         * Display Content
         */
        $output .= '<p>
					<span class="label">' . __('Display Content', 'themify') . '</span> 
					<select name="' . esc_attr( $prefix ) . 'layout_display">'.
			themify_options_module(themify_default_display_options(), $prefix.'layout_display',true,'excerpt' ).'
					</select>
				</p>';


        /**
         * Hide Post Title
         */
        $output .= '<p>
					<span class="label">' . __('Hide Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_title">' .
            themify_options_module(themify_default_options(), $prefix.'post_title') . '
					</select>
				</p>';

        /**
         * Unlink Post Title
         */
        $output .= '<p>
					<span class="label">' . __('Unlink Post Title', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_title">' .
            themify_options_module(themify_default_options(), $prefix.'unlink_post_title') . '
					</select>
				</p>';

        /**
         * Hide Post Meta
         */
        $output .= themify_post_meta_options($prefix.'post_meta', $data);

        /**
         * Hide Post Date
         */
        $output .= '<p>
					<span class="label">' . __('Hide Post Date', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_date">' .
            themify_options_module(themify_default_options(), $prefix.'post_date') . '
					</select>
				</p>';

        /**
         * Auto Featured Image
         */
        $output .= '<p>
					<span class="label">' . __('Auto Featured Image', 'themify') . '</span>
					<label for="'.esc_attr($setting).'auto_featured_image"><input type="checkbox" value="1" id="'.esc_attr($setting).'auto_featured_image" name="'.esc_attr($setting).'auto_featured_image" ' . checked( themify_get( esc_attr($setting).'auto_featured_image' ), 1, false ) . '/> ' . __( 'If no featured image is specified, display first image in content.', 'themify' ) . '</label>
				</p>';

        /**
         * Featured Image Position
         */
        $output .= '<p>
					<span class="label">' . __( 'Featured Image Position', 'themify' ) . '</span>
					<select name="' . esc_attr( $prefix ) . 'media_position">' .
            themify_options_module( themify_media_position(), $prefix.'media_position' ) . '
					</select>
				</p>';

        /**
         * Hide Featured Image
         */
        $output .= '<p>
					<span class="label">' . __('Hide Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'post_image">' .
            themify_options_module(themify_default_options(), $prefix.'post_image') . '
					</select>
				</p>';

        /**
         * Unlink Featured Image
         */
        $output .= '<p>
					<span class="label">' . __('Unlink Featured Image', 'themify') . '</span>
					<select name="' . esc_attr( $prefix ) . 'unlink_post_image">' .
            themify_options_module(themify_default_options(), $prefix.'unlink_post_image') . '
					</select>
				</p>';

        /**
         * Featured Image Sizes
         */
        $output .= themify_feature_image_sizes_select('image_post_feature_size');

        /**
         * Image Dimensions
         */
        $output .= '<p>
					<span class="label">' . __('Image Size', 'themify') . '</span>  
					<input type="text" class="width2" name="'.esc_attr($setting).'image_post_width" value="' . themify_get( esc_attr($setting).'image_post_width' ) . '" /> ' . __('width', 'themify') . ' <small>(px)</small>
					<input type="text" class="width2 show_if_enabled_img_php" name="'.esc_attr($setting).'image_post_height" value="' . themify_get( esc_attr($setting).'image_post_height' ) . '" /> <span class="show_if_enabled_img_php">' . __('height', 'themify') . ' <small>(px)</small></span>
					<br /><span class="pushlabel show_if_enabled_img_php"><small>' . __('Enter height = 0 to disable vertical cropping with img.php enabled', 'themify') . '</small></span>
				</p>';

        return $output;
    }


}


/**
 * @return array
 */
function themify_post_contetnt_layout()
{
	return array(
		array('name' => __('Default', 'themify'), 'value' => ''),
		array('name' => __('Overlay', 'themify'), 'value' => 'overlay'),
		array('name' => __('Polaroid', 'themify'), 'value' => 'polaroid'),
		array('name' => __('Boxed', 'themify'), 'value' => 'boxed'),
		array('name' => __('Flip', 'themify'), 'value' => 'flip')
	);
}


/**
 * @return array
 */
function themify_post_gutter(){
    return array(
        array('name' => __('Default', 'themify'), 'value' => 'gutter'),
        array('name' => __('No gutter', 'themify'), 'value' => 'no-gutter')
    );
}

/**
 * @return array
 */
function themify_content_layout(){
    return array(
        array('name' => __('Default', 'themify'), 'value' => ''),
        array('name' => __('Overlay', 'themify'), 'value' => 'overlay'),
        array('name' => __('Polaroid', 'themify'), 'value' => 'polaroid'),
        array('name' => __('Boxed', 'themify'), 'value' => 'boxed'),
        array('name' => __('Flip', 'themify'), 'value' => 'flip')
    );
}


/**
 * @return array
 */
function themify_media_position(){
    return array(
        array('name' => __('Above Post Title', 'themify'), 'value' => 'above'),
        array('name' => __('Below Post Title', 'themify'), 'value' => 'below'),
    );
}

/**
 * @return array
 */
function themify_sidebar_location_options(){
    return array(
        array('value' => 'sidebar1', 'img' => 'images/layout-icons/sidebar1.png', 'selected' => true, 'title' => __('Sidebar Right', 'themify')),
        array('value' => 'sidebar1 sidebar-left', 'img' => 'images/layout-icons/sidebar1-left.png', 'title' => __('Sidebar Left', 'themify')),
        array('value' => 'sidebar-none', 'img' => 'images/layout-icons/sidebar-none.png', 'title' => __('No Sidebar', 'themify'))
    );
}

/**
 * @return array
 */
function themify_default_post_layout_options(){
    return array(
        array('value' => 'list-post', 'img' => 'images/layout-icons/list-post.png', 'title' => __( 'List Post', 'themify' ), "selected" => true),
        array('value' => 'grid2', 'img' => 'images/layout-icons/grid2.png', 'title' => __( 'Grid 2', 'themify' )),
        array('value' => 'grid3', 'img' => 'images/layout-icons/grid3.png', 'title' => __( 'Grid 3', 'themify' )),
        array('value' => 'grid4', 'img' => 'images/layout-icons/grid4.png', 'title' => __( 'Grid 4', 'themify' )),
		array('value' => 'grid5', 'img' => 'images/layout-icons/grid5.png','title' => __('Grid 5', 'themify')),
		array('value' => 'grid6','img' => 'images/layout-icons/grid6.png','title' => __('Grid 6', 'themify')),
        array('value' => 'list-large-image','img' => 'images/layout-icons/list-large-image.png', 'title' => __('List Large Image', 'themify')),
        array('value' => 'auto_tiles', 'img' => 'images/layout-icons/auto-tiles.png', 'title' => __('Tiles', 'themify'))
    );
}

/**
 * @return array
 */
function themify_default_display_options(){
    return array(
        array('name' => __('Full Content', 'themify'),'value' => 'content'),
        array('name' => __('Excerpt', 'themify'),'value' => 'excerpt'),
        array('name' => __('None', 'themify'),'value' => 'none')
    );
}

/**
 * @return array
 */
function themify_binary_options(){
    return array(
        array('name' => __('Yes', 'themify'), 'value' => 'yes'),
        array('name' => __('No', 'themify'), 'value' => 'no')
    );
}

/**
 * Tertiary options <blank>|yes|no
 * @var array
 */

function themify_default_options(){
    return array(
        array('name' => '', 'value' => ''),
        array('name' => __('Yes', 'themify'), 'value' => 'yes'),
        array('name' => __('No', 'themify'), 'value' => 'no')
    );
}

function themify_render_option_items(array $item_list, $val ){
    $output = '';
    foreach ($item_list as $option) {
        if (($val == '' || !$val || !isset($val)) && $option['selected']) {
            $val = $option['value'];
        }
        if ($val == $option['value']) {
            $class = 'selected';
        } else {
            $class = '';
        }
        $output .= '<a href="#" class="preview-icon ' . esc_attr($class) . '" title="' . esc_attr($option['title']) . '"><img src="' . esc_url(THEME_URI . '/' . $option['img']) . '" alt="' . esc_attr($option['value']) . '"  /></a>';
    }
    return $output;
}

function themify_get_default_selection($item_name, array $data , array $item_list)
{
    $val =isset($data[$item_name]) ? $data[$item_name] : '';

    foreach ($item_list as $option) {
        if ($val == $option['value']) {
            return $val;
        }
    };
    return $item_list[0]['value'];

}

function themify_extend_mega_menu_options($out){
	$key = 'setting-mega_menu';
	$out .= '<p>
				<span class="label">' . __( 'Post Count', 'themify' ) . '</span>
				<input type="hidden" name="'.$key.'_post_count" value="off">
				<input type="checkbox" value="on" id="'.$key.'_post_count" name="'.$key.'_post_count" '. checked( themify_get($key.'_post_count',false,true), 'on', false ) .'/> ' . __('Include post count on category links', 'themify') . '</label>
			</p>';
	return $out;
}
add_filter('themify_mega_menu_settings','themify_extend_mega_menu_options');
if( themify_is_woocommerce_active()){
    function themify_add_serach_post_type_option($out){
	    $out = '<p class="themify_search_post_type"><span class="label">' . __('Search Post Type', 'themify') . '</span>
	    <label for="search_post_type_all">
		<input '.checked( themify_get( 'setting-search_post_type','all' ), 'all', false ).' type="radio" id="search_post_type_all" name="setting-search_post_type" value="all"  />
	    '. __( 'All', 'themify' ) . '</label>
	    <label for="search_post_type_product">
		<input '.checked( themify_get( 'setting-search_post_type' ), 'product', false ).' type="radio" id="search_post_type_product" name="setting-search_post_type" value="product"  />
	    '. __( 'Product', 'themify' ) . '</label>
	</p>'.$out;
	    return $out;
    }
    add_filter('themify_search_settings_output','themify_add_serach_post_type_option');
}

/**
 * Markup for theme dark mode options
 * @param array $data
 * @return string
 */
function themify_theme_dark_mode_controls( $data = array() ) {

    $key = 'setting-dark_mode_';
    $html='';
    $html .= sprintf('<p><span class="label">%1$s</span><label><input type="checkbox" name="%2$s" %3$s /> %4$s</label></p>',
        __('Dark Mode', 'themify'),
        $key . 'enabled',
        checked( themify_get( $key . 'enabled',null,true ), 'on', false ),
        __('Enable dark mode', 'themify')
    );
    $time=themify_get( $key . 'time',null,true );
    $html .= sprintf('<p data-show-if-element="[name=%6$s]" data-show-if-value="true"><label class="pushlabel"><input type="radio" name="%1$s" value="always" %2$s /> %3$s</label><label class="pushlabel"><input type="radio" name="%1$s" value="schedule" %4$s /> %5$s</label></p>',
        $key . 'time',
        checked( $time, 'always', false ),
        __('All time', 'themify'),
        checked( $time, 'schedule', false ),
        __('Schedule', 'themify'),
        $key . 'enabled'
    );
    $html .= sprintf('<p data-show-if-element="[name=%7$s]" data-show-if-value="schedule"><label class="pushlabel"><input class="width4" type="text" name="%1$s" value="%2$s"/> %3$s</label><label class="pushlabel"><input class="width4" type="text" name="%4$s" value="%5$s"/> %6$s</label></p>',
        $key . 'start',
        themify_get( $key . 'start','',true ),
        __('Start time(eg. 20:00)', 'themify'),
        $key . 'end',
        themify_get( $key . 'end','',true ),
        __('End time(eg. 07:00)', 'themify'),
        $key . 'time'
    );
    return $html;
}
