<?php
/**
 * Single Product Rating
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/rating.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $product;

if ( ! wc_review_ratings_enabled() ) {
	return;
}

$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average      = $product->get_average_rating();

if ( $rating_count > 0 ) : ?>

	<div class="description_section v_centered">

		<div class="woocommerce-product-rating" itemprop="aggregateRating" itemscope itemtype="https://schema.org/AggregateRating">
			<div class="star-rating" title="<?php printf( esc_html__( 'Rated %s out of 5', 'shopme' ), $average ); ?>">
				<span style="width:<?php echo ( ( $average / 5 ) * 100 ); ?>%">
					<strong itemprop="ratingValue" class="rating"><?php echo esc_html( $average ); ?></strong> <?php printf( esc_html__( 'out of %s5%s', 'shopme' ), '<span itemprop="bestRating">', '</span>' ); ?>
					<?php printf( _n( 'based on %s customer rating', 'based on %s customer ratings', $rating_count, 'shopme' ), '<span itemprop="ratingCount" class="rating">' . $rating_count . '</span>' ); ?>
				</span>
			</div>
		</div>

		<ul class="top-bar">

			<?php if ( is_singular('product') ): ?>

				<?php if ( $rating_count > 0 ) : ?>

					<?php if ( comments_open() ) : ?>
						<li><a href="#reviews" class="woocommerce-review-link" rel="nofollow">
								<?php printf( _n( '%s Review', '%s Reviews', $review_count, 'shopme' ), '<span class="count">' . $review_count . '</span>' ); ?></a>
						</li>
						<li><a href="#commentform" class="woocommerce-write-review-link" rel="nofollow"><?php esc_html_e('Add Your Review', 'shopme') ?></a></li>
					<?php endif ?>

				<?php else: ?>

					<?php if ( comments_open() ) : ?>
						<li><a href="#commentform" class="woocommerce-write-review-link" rel="nofollow"><?php esc_html_e('Add Your Review', 'shopme') ?></a></li>
					<?php endif; ?>

				<?php endif; ?>

			<?php else: ?>

				<?php if ( $rating_count > 0 ) : ?>

					<?php if ( comments_open() ) : ?>
						<li><a href="<?php echo esc_url(get_the_permalink()) ?>#reviews" class="woocommerce-review-link" rel="nofollow">
								<?php printf( _n( '%s Review', '%s Reviews', $review_count, 'shopme' ), '<span class="count">' . $review_count . '</span>' ); ?></a>
						</li>
						<li><a href="<?php echo esc_url(get_the_permalink()) ?>#commentform" class="woocommerce-write-review-link" rel="nofollow"><?php esc_html_e('Add Your Review', 'shopme') ?></a></li>
					<?php endif ?>

				<?php else: ?>

					<?php if ( comments_open() ) : ?>
						<li><a href="<?php echo esc_url(get_the_permalink()) ?>#commentform" class="woocommerce-write-review-link" rel="nofollow"><?php esc_html_e('Add Your Review', 'shopme') ?></a></li>
					<?php endif; ?>

				<?php endif; ?>

			<?php endif; ?>

		</ul><!--/ .top-bar-->

	</div>

<?php endif; ?>

