<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;
?>
<div class="product_meta">
<?php if (get_option("rtl") && get_option("rtl") == "on" ): ?>

	<?php if ( $product->is_type( array( 'simple', 'variable' ) ) && get_option('woocommerce_enable_sku') == 'yes' && $product->get_sku() ) : ?>
		<span itemprop="productID" class="sku"><?php _e('SKU:', 'woocommerce'); ?> <?php echo $product->get_sku(); ?>.</span>
	<?php endif; ?>

	<?php echo wc_get_product_category_list( $product->get_id(), ' ,', ' <span class="posted_in">', '</span>'); ?>

	<span style="margin-right: 8px"><?php _e('Category', 'woocommerce'); ?></span>

	<?php echo wc_get_product_tag_list( $product->get_id(), ' ,', ' <span class="tagged_as">', '</span>'); ?>

	<span><?php _e('Tags', 'woocommerce'); ?></span>

<?php else: ?>

	<?php if ( $product->is_type( array( 'simple', 'variable' ) ) && get_option('woocommerce_enable_sku') == 'yes' && $product->get_sku() ) : ?>
		<span itemprop="productID" class="sku"><?php _e('SKU:', 'woocommerce'); ?> <?php echo $product->get_sku(); ?>.</span>
	<?php endif; ?>

	<?php echo wc_get_product_category_list( $product->get_id(), ', ', ' <span class="posted_in">'.__('Category:', 'woocommerce').' ', '.</span>'); ?>

	<?php echo wc_get_product_tag_list( $product->get_id(), ', ', ' <span class="tagged_as">'.__('Tags:', 'woocommerce').' ', '.</span>'); ?>

<?php endif; ?>

</div>
