<?php
/**
 * Show options for ordering
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="woocommerce_ordering">
	<form class="woocommerce-ordering" method="get">
		<select name="orderby" class="orderby">
			<?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
				<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
			<?php endforeach; ?>
		</select>
		<input type="hidden" name="paged" value="1" />
		<?php wc_query_string_form_fields( null, array( 'orderby', 'submit', 'paged', 'product-page' ) ); ?>
	</form>

	<?php
		echo '<div class="widget-container widget_price_filter price-filter-outside">'; 
		if ( is_active_sidebar( 'filter-widget-area' ) ) : ?>
							<ul class="xoxo">
								<?php dynamic_sidebar( 'filter-widget-area' ); ?>
							</ul>
		<?php endif;
		echo '</div>';
	?>
</div>