<?php

if ( !defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

//custom styles
add_action( 'wp_enqueue_scripts', 'seosight_custom_css_styles', 99 );

//custom styles
add_action( 'wp_enqueue_scripts', '_seosight_custom_font', 99 );

function _seosight_generate_font_styles( $tag ) {
	$font		 = fw_get_db_customizer_option( 'typography_' . $tag, array() );
	$font_family = fw_akg( 'family', $font, 'Default' );
	$font_color	 = fw_akg( 'color', $font, '' );

	if ( $tag === 'logo' ) {
		$font_css = '.logo .logo-text .logo-title, .logo .logo-text .logo-sub-title{';
	} elseif ( $tag === 'nav' ) {
		$font_css = '.navigation-menu .menu-item > a, .megamenu-item-info{';
	} elseif ( $tag === 'body' ) {
		$font_css = 'body, p, article p{';
	} else {
		$font_css = $tag . ', .' . $tag . '{';
	}
	if ( !empty( $font_family ) && 'Default' !== $font_family ) {
		$font_css	 .= 'font-family:"' . $font_family . '", sans-serif;';
		$variant	 = fw_akg( 'variation', $font, '' );
		if ( $variant ) {
			if ( substr_count( $variant, 'italic' ) > 0 ) {
				$font_css	 .= 'font-style:italic;';
				$variant	 = str_replace( 'italic', '', $variant );
			}
			$font_css .= 'font-weight:' . $variant . ';';
		} elseif ( false === $font[ 'google_font' ] ) {
			$font_css	 .= 'font-style:' . $font[ 'style' ] . ';';
			$font_css	 .= 'font-weight:' . $font[ 'weight' ] . ';';
		}
	}

	if ( !empty( $font_color ) ) {
		$font_css .= 'color:' . $font_color . ';';
	}

	$letter_spacing = fw_akg( 'letter-spacing', $font, '' );
	if ( !empty( $letter_spacing ) ) {
		$font_css .= 'letter-spacing:' . $letter_spacing . 'px;';
	}
	$size = fw_akg( 'size', $font, '' );
	if ( !empty( $size ) ) {
		$font_css .= 'font-size:' . $size . 'px;';
	}
	$font_css .= '} ';

	return $font_css;
}

function _seosight_custom_font() {
	$custom_css = '';

	if ( function_exists( 'fw_get_db_settings_option' ) ) {
		$custom_css	 .= _seosight_generate_font_styles( 'h1' );
		$custom_css	 .= _seosight_generate_font_styles( 'h2' );
		$custom_css	 .= _seosight_generate_font_styles( 'h3' );
		$custom_css	 .= _seosight_generate_font_styles( 'h4' );
		$custom_css	 .= _seosight_generate_font_styles( 'h5' );
		$custom_css	 .= _seosight_generate_font_styles( 'h6' );
		$custom_css	 .= _seosight_generate_font_styles( 'body' );
		$custom_css	 .= _seosight_generate_font_styles( 'nav' );
		$custom_css	 .= _seosight_generate_font_styles( 'logo' );
	}
	wp_add_inline_style( 'seosight-theme-style', $custom_css );
}

function seosight_custom_css_styles() {
	if ( function_exists( 'fw_get_db_customizer_option' ) ) {
		$custom_css		 = '';
		$primary_color	 = get_option( 'primary-accent-color' );
		$primary_color	 = $primary_color !== false ? $primary_color : fw_get_db_customizer_option( 'primary_color', '' );

		$secondary_color = get_option( 'secondary-accent-color' );
		$secondary_color = $secondary_color !== false ? $secondary_color : fw_get_db_customizer_option( 'secondary_color', '' );

		$links_color	 = get_option( 'links-color' );

		$website_preloader = fw_get_db_customizer_option( 'website_preloader', '' );

		if ( true === $website_preloader ) {
			if ( !empty( $primary_color ) ) {
				$bg_color = $primary_color;
			} else {
				$bg_color = '#4cc2c0';
			}
			$custom_css .= '#hellopreloader {display: block;position: fixed;z-index: 99999;top: 0;left: 0;width: 100%;height: 100%;min-width: 100%;background: url(' . get_template_directory_uri() . '/svg/preloader.svg) center center no-repeat;  background-color: ' . esc_attr( $bg_color ) . ';  background-size:100px;  opacity: 1;}';
		}


		if ( ! empty( $links_color ) || ! empty( $secondary_color ) || ! empty( $primary_color ) ) {
			$custom_css .= ':root{';
			if ( ! empty( $primary_color ) ) {
				$custom_css .= '--primary-accent-color: ' . esc_attr( $primary_color ) . ';';
			}
			if ( ! empty( $secondary_color ) ) {
				$custom_css .= '--secondary-accent-color: ' . esc_attr( $secondary_color ) . ';';
			}
			if ( ! empty( $links_color ) ) {
				$custom_css .= '--global-link-color: ' . esc_attr( $links_color ) . ';';
			}
			$custom_css .= '}';
		}

		if ( is_page() || is_singular( 'fw-portfolio' ) || is_singular( 'post' ) ) {
			$page_id				 = get_the_ID();
			$enable_customization	 = fw_get_db_post_option( $page_id, 'custom-header/enable', 'no' );
			if ( 'yes' === $enable_customization ) {
				$header_opacity	 = fw_get_db_post_option( $page_id, 'custom-header/yes/header-opacity', '100' );
				$font_color		 = fw_get_db_post_option( $page_id, 'custom-header/yes/header-color', '' );
				if ( 100 != $header_opacity || !empty( $font_color ) ) {
					$custom_css .= '#site-header{';
					if ( 100 != $header_opacity ) {
						$custom_css .= 'background:rgba(255,255,255,0.' . esc_attr( $header_opacity ) . ');';
					}
					if ( !empty( $font_color ) ) {
						$custom_css .= 'color:' . esc_attr( $font_color ) . ';';
					}
					$custom_css .= '}';
				}
			}
		}

		$options = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( 'stunning-show', array() ) : array();

		$style					 = '';
		$bg_color				 = fw_get_db_customizer_option( 'stunning_bg_color', '' );
		$bg_image				 = fw_get_db_customizer_option( 'stunning_bg_type/image_bg/stunning_bg_image', fw_get_db_customizer_option( 'stunning_bg_image', array() ) );
		$bg_cover				 = fw_get_db_customizer_option( 'stunning_bg_type/image_bg/stunning_bg_cover', fw_get_db_customizer_option( 'stunning_bg_cover', false ) );
		$text_color				 = fw_get_db_customizer_option( 'stunning_text_color', '' );
		$enable_customization	 = fw_get_db_post_option( get_the_ID(), 'custom-stunning/enable', 'no' );
		$queried_object			 = get_queried_object();
		if ( is_category() ) {
			$enable_customization = fw_get_db_term_option( get_queried_object_id(), 'category', 'custom-stunning/enable', 'no' );
		} elseif ( is_tax() && 'fw-portfolio-category' === $queried_object->taxonomy ) {
			$enable_customization = fw_get_db_term_option( $queried_object->term_id, $queried_object->taxonomy, 'custom-stunning/enable', 'no' );
		}
		if ( 'yes' === $enable_customization ) {
			$options = fw_get_db_post_option( get_the_ID(), 'custom-stunning/yes/stunning-show', array() );
			if ( is_category() ) {
				$options = fw_get_db_term_option( get_queried_object_id(), 'category', 'custom-stunning/yes/stunning-show', array() );
			} elseif ( is_tax() && 'fw-portfolio-category' === $queried_object->taxonomy ) {
				$options = fw_get_db_term_option( $queried_object->term_id, $queried_object->taxonomy, 'custom-stunning/yes/stunning-show', array() );
			}

			$meta_bg_color	 = fw_akg( 'yes/stunning_bg_color', $options, '' );
			$meta_bg_image	 = fw_akg( 'yes/stunning_bg_type/image_bg/stunning_bg_image', $options, fw_akg( 'yes/stunning_bg_image', $options, array() ) );
			$meta_bg_cover	 = fw_akg( 'yes/stunning_bg_type/image_bg/stunning_bg_cover', $options, fw_akg( 'yes/stunning_bg_cover', $options, false ) );
			$meta_text_color = fw_akg( 'yes/stunning_text_color', $options, '' );

			$bg_color	 = !empty( $meta_bg_color ) ? $meta_bg_color : $bg_color;
			$bg_image	 = !empty( $meta_bg_image ) ? $meta_bg_image : $bg_image;
			$bg_cover	 = !empty( $meta_bg_cover ) ? $meta_bg_cover : $bg_cover;
			$text_color	 = !empty( $meta_text_color ) ? $meta_text_color : $text_color;
		}

		$bg_img_url = fw_akg( 'data/css/background-image', $bg_image, '' );

		if ( fw_akg( 'yes/padding-top', $options, '60px' ) !== '60px' ) {
			$style .= 'padding-top:' . fw_akg( 'yes/padding-top', $options ) . ';';
		}
		if ( fw_akg( 'yes/padding-bottom', $options, '60px' ) !== '60px' ) {
			$style .= 'padding-bottom:' . fw_akg( 'yes/padding-bottom', $options ) . ';';
		}
		if ( !empty( $bg_color ) ) {
			$style .= 'background-color:' . ( $bg_color ) . ';';
		}
		if ( !empty( $bg_img_url ) ) {
			$style .= 'background-image:' . ( $bg_img_url ) . ';';
		}
		if ( true === $bg_cover ) {
			$style .= 'background-size:cover;';
		}
		if ( !empty( $text_color ) ) {
			$style .= 'color:' . ( $text_color ) . ';';
		}

		if ( !empty( $style ) ) {
			$custom_css .= '#stunning-header{' . $style . '}';
		}

		$subscribe_section		 = fw_get_db_customizer_option( 'show_subscribe_section', 'yes' );
		$enable_customization	 = fw_get_db_post_option( get_the_ID(), 'custom-subscribe/enable', 'no' );

		if ( 'yes' === $enable_customization ) {
			$subscribe_section = fw_get_db_post_option( get_the_ID(), 'custom-subscribe/yes/subscribe-show/value', 'yes' );
		}
		if ( 'yes' === $subscribe_section ) {
			// Subscribe section styling.
			$subscribe_bg		 = fw_get_db_customizer_option( 'subscribe_bg_color', '' );
			$subscribe_bg_img	 = fw_get_db_customizer_option( 'subscribe_bg_image', '' );

			$subscribe_bg_cover	 = fw_get_db_customizer_option( 'subscribe_bg_cover', false );
			$subscribe_text		 = fw_get_db_customizer_option( 'subscribe_text_color', '' );

			if ( 'yes' === $enable_customization ) {
				$panel_options		 = fw_get_db_post_option( get_the_ID(), 'custom-subscribe/yes/subscribe-show', array() );
				// Subscribe section styling.
				$subscribe_bg		 = fw_akg( 'yes/subscribe_bg_color', $panel_options, '' );
				$subscribe_bg_img	 = fw_akg( 'yes/subscribe_bg_image', $panel_options, '' );

				$subscribe_bg_cover	 = fw_akg( 'yes/subscribe_bg_cover', $panel_options, '' );
				$subscribe_text		 = fw_akg( 'yes/subscribe_text_color', $panel_options, '' );
			}
			if ( !empty( $subscribe_bg ) || !empty( $subscribe_bg_img ) || !empty( $subscribe_text ) ) {
				$custom_css .= '#subscribe-section{';
				if ( !empty( $subscribe_bg ) ) {
					$custom_css .= 'background-color:' . esc_attr( $subscribe_bg ) . ';';
				}
				if ( !empty( $subscribe_bg_img ) ) {
					$bg_img_url = fw_akg( 'data/css/background-image', $subscribe_bg_img, '' );
					if ( !empty( $bg_img_url ) ) {
						$custom_css .= 'background-image:' . ( $bg_img_url ) . ';';

						if ( true === $subscribe_bg_cover ) {
							$custom_css .= 'background-size:cover;';
						}
					}
				}
				if ( !empty( $subscribe_text ) ) {
					$custom_css .= 'color:' . esc_attr( $subscribe_text ) . ';';
				}
				$custom_css .= '} ';
			}
		}

		// Paddings
		$padding_top	 = 80;
		$padding_bottom	 = 80;

		if ( function_exists( 'fw_get_db_customizer_option' ) ) {
			$menu_bg_color			 = fw_get_db_customizer_option( 'dropdown-style/2/bg-color', '#ecf4fc' );
			$sections_padding_data	 = fw_get_db_customizer_option( 'sections_padding', '' );
			$sections_padding_picker = fw_akg( 'sections_padding_picker', $sections_padding_data, 'medium' );

			switch ( $sections_padding_picker ) {
				case 'small':
					$padding_top	 = 40;
					$padding_bottom	 = 40;
					break;
				case 'medium':
					$padding_top	 = 80;
					$padding_bottom	 = 80;
					break;
				case 'large':
					$padding_top	 = 120;
					$padding_bottom	 = 120;
					break;
				default:
					$padding_top	 = (int) fw_akg( 'custom/top', $sections_padding_data, 120 );
					$padding_bottom	 = (int) fw_akg( 'custom/bottom', $sections_padding_data, 120 );
					break;
			}
		}

		if ( is_int( $padding_top ) && is_int( $padding_bottom ) ) {
			$custom_css .= ".elementor-section:not(.elementor-inner-section) , .kc_row:not(.kc_row_inner) , .medium-padding120 {padding: {$padding_top}px 0 {$padding_bottom}px;}";
		}

		// Footer section styling.
		$footer_bg		 = fw_get_db_customizer_option( 'footer_bg_color', '' );
		$footer_bg_img	 = fw_get_db_customizer_option( 'footer_bg_image', '' );
		$footer_bg_cover = fw_get_db_customizer_option( 'footer_bg_cover', false );
		$footer_text	 = fw_get_db_customizer_option( 'footer_text_color', '' );
		$footer_title	 = fw_get_db_customizer_option( 'footer_title_color', '' );

		if ( !empty( $footer_bg ) || !empty( $footer_bg_img ) || !empty( $footer_text ) ) {
			$custom_css .= '#site-footer{';
			if ( !empty( $footer_bg ) ) {
				$custom_css .= 'background-color:' . esc_attr( $footer_bg ) . ';';
			}
			if ( !empty( $footer_bg_img ) ) {
				$bg_img_url = fw_akg( 'data/css/background-image', $footer_bg_img, '' );
				if ( isset( $footer_bg_img ) && !empty( $footer_bg_img ) ) {
					$custom_css .= 'background-image:' . ( $bg_img_url ) . ';';

					if ( true === $footer_bg_cover ) {
						$custom_css .= 'background-size:cover;';
					}
				}
			}
			if ( !empty( $footer_text ) ) {
				$custom_css .= 'color:' . esc_attr( $footer_text ) . ';';
			}
			$custom_css .= '}';
		}
		if ( !empty( $footer_title ) ) {
			$custom_css	 .= '.footer .info .heading .heading-title, #site-footer .contacts-item .content .title, #site-footer a{';
			$custom_css	 .= 'color:' . esc_attr( $footer_title ) . ';';
			$custom_css	 .= '}';
		}

		// Copyright section styling.
		$copyright_bg	 = fw_get_db_customizer_option( 'copyright_bg_color', '' );
		$copyright_text	 = fw_get_db_customizer_option( 'copyright_text_color', '' );
		if ( !empty( $copyright_bg ) || !empty( $copyright_text ) ) {
			if ( !empty( $copyright_bg ) ) {
				$custom_css .= '#site-footer .sub-footer{ background-color:' . esc_attr( $copyright_bg ) . '}';
			}
			if ( !empty( $copyright_text ) ) {
				$custom_css .= '#site-footer .site-copyright-text{ color:' . esc_attr( $copyright_text ) . '}';
			}
		}

		wp_add_inline_style( 'seosight-theme-blocks', $custom_css );
	}
}